(

	----------------------------------------------------------------------
	--KRAKATOA CHANNELS EDITOR (KCE) SCHEMATIC EDITOR
	-- Code by Borislav Petrov - bobo@franticfilms.com
	----------------------------------------------------------------------
	
	--NODE DEFINITION ARRAY:
	--The node definition array contains the data used by the Compiler and the KCE.
	--It has 3 representations:
	--*Base - contains the compact version of the flow including unexpanded BlackOps. Stored in the .internalflow parameter of a KCM, used to generate the other representations.
	--*Expanded - contains the fully expanded version of the flow where all nested BlackOps are recursively expanded (BlackOps are a UI-level concept, the Compiler does not understand them). Stored in the .flow parameter of the KCM.
	--*Display (KrakatoaChannelEditor_DisplayNodeTreeData) - contains the array of nodes for editing. This one is being converted back to Base flow when updating. The Base is converted to Expanded for the Compiler to work with.
	
	-- #(
	--[1]: "Node Type",  --stores the signature of the node type - "Output", "Input", "Operator", "BlackOp" used by the Compiler and KCE. Once set, a node type cannot be changed.
	--[2] #(ConnectionIndices),  --stores the node's Input socket connections used by both the Compiler and KCE. Output connections are implicitly defined by Inputs of other nodes
	--[3] #("DataType",DataValues),  --stores the node data used by the Compiler. 
	
	--[4] #( --this array is used by the KCE editor and is NOT checked for consistency by the Compiler. Thus, it can contain arbitrary data. The records below are used internally:
	--[4][1]:[X,Y], --used by all nodes, stores the position of the node in the schematic view
	--[4][2]: Collapsed, --used by all nodes except for Output, true when collapsed, false when expanded.
	--[4][3]: Selected, --used by all nodes, stores the selected state of the node (this means that saving and loading a flow preserves selection!)
	--[4][4]:ID, --used by Input nodes to define the unique ID of the TrackView track used to store its controllers
	--[4][5]:#(Int,Float,Vector) --used by Input nodes to store the last values of Integer, Float and Vector track. 
	--[4][6]:"LastScriptCode", --used by Input nodes to store the last used script
	--[4][7]:isConnected, --true when the node is connected, false when it is free-floating, causes the node to be drawn darker
	--[4][8]:"UserName" --used by all Nodes
	--[4][9]:"LastChannelType" --used by Input nodes
	--[4][10]:"Last Transform Object Name" --used by ToSpace/FromSpace Operators
	--[4][11]:"Position Locked" --allows the locking of a node to prevent moving with the mouse. RESERVED. Not implemented in the KCE yet.
	--[4][12]:"Control Exposed"
	--[4][13]:"BlackOp Info Array.
	--[4][14]: Input Socket Flipped
	
	--[5]: Enabled --stores the PassThrough/Enabled flag. When set to false, the node is disabled and if it has a first input and an output, the data is passed through. Used by Compiler and KCE
	--)
	
	global KrakatoaChannelNodeEditor_Rollout --the variable containing the KCE floating dialog.
	try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch() --if the dialog is open already, it should be closed first.
	
	global KrakatoaChannelsModifier --this is the class of the KCM, just in case the KCM is evaluated after the KCE (should not happen, but better safe than sorry)
	global KrakatoaChannelEditor_LastUndoRecordNumber  --contains the index of the last undo record.
	if KrakatoaChannelEditor_LastUndoRecordNumber == undefined do KrakatoaChannelEditor_LastUndoRecordNumber = 0
	global KrakatoaChannelEditor_UndoRecordNames = #("") --contains the names of undo records for the current session.
	global KrakatoaChannelEditor_BaseNodeTreeData  = #() --used to store the base form of the node tree definition taken from the KCM
	global KrakatoaChannelEditor_DisplayNodeTreeData  --used to store the display form of the base node tree definition 
	global KrakatoaChannelEditor_NodeTreeData = #() --used for loading and saving of flows
	global KrakatoaChannelEditor_NodeTreeEditingLevel = #()
	global KrakatoaChannelEditor_NodeTreeEditingNames = #()
	global KrakatoaChannelEditor_NodeTreeEditingUndoLevel = #()
	global KrakatoaChannelEditor_MacroRecording = #()
	global KrakatoaChannelEditor_PlaybackDuration = 1.0
	global KrakatoaChannelEditor_UndoRecordName = ""
	local currentMacroLine = 0

	
	local leftDepotMargin = 0
	local currentlyEditedBlackOpName = ""
	--global DisplayNodeTreeData = #() --stores the intermediate version of the NodeTreeData in the form for KCE display.

	
	global KrakatoaChannelNodeEditor_Rollout_MainMenu --contains the main menu bar of the KCE
	global KrakatoaChannelNodeEditor_NodeNameRollout, KrakatoaChannelNodeEditor_OperatorDescriptionRollout, KrakatoaChannelNodeEditor_OperatorRollout, KrakatoaChannelNodeEditor_ConnectorRollout, KrakatoaChannelNodeEditor_OutputConnectorRollout --the rollouts used in the KCE "command panel"
	global KrakatoaChannelNodeEditor_CurrentModifier --contains the current KCM represented by the KCE
	
	global KrakatoaChannelEditor_CurrentFloatController --the current float controller of a Value Input shown in the KCE's "command panel"
	global KrakatoaChannelEditor_CurrentIntController --the current integer controller of a Value Input shown in the KCE's "command panel"
	global KrakatoaChannelEditor_CurrentVectorController --the current vector controller of a Value Input shown in the KCE's "command panel"

	global KrakatoaChannelEditor_ModifierCallback --contains the callback function to be called when a modifier changes.
	global KrakatoaChannelEditor_TrackviewCleanupCallback --contains the callback function to be called pre-save to remove unused TV nodes
	
	global KrakatoaChannelEditor_BlackOpData = #() --contains the definition data of a BlackOp
	global KrakatoaChannelEditor_ClipboardArray = #() --contains the copy/paste data 
	
	global KrakatoaChannelEditor_ExpandBLOPs = false 
	global KrakatoaChannelEditor_LastError = #(0,"") 
	
	local KrakatoaChannelEditor_UpdateDepot --contains the function called to update the Depot
	
	local AutoZoomExtents = false
	local scriptCodeAutoCheck = true
	local AutoReorderToggle = false
	local AutoReorderPattern = #row
	
	local operatorHeightConstant = true
	local useMousePositionOnCreation = false
	
	--local flagUnconnectedAsErrors = false
	
	local KrakatoaChannelsEditor_isInitializing = false
	
	local	theBackgroundColor = color 192 192 198
	local	theGridColor = color 200 200 210	
	local SnapToGrid = true
	local GridSizeX = 10
	local GridSizeY = 10
	local NodeWidth = 140
	local NodeXSpace = 20
	
	local theHeaderColor = color 80 80 128
	global theInputNodeColor = color 220 220 255
	local theOutputNodeColor = color 200 255 200
	global theOperatorNodeColor = color  255 235 200
	global theBoxNodeColor = color 255 200 180
	local theErrorNodeColor = color 255 64 64
	
	local theInputSocketColor = color 255 0 0
	local theChannelSocketColor = color 0 0 200
	local theFloatSocketColor = color 0 128 0
	local theIntegerSocketColor = color 128 0 255
	local theVectorSocketColor = color 0 255 200
	local theTimeSocketColor = color 255 255 0
	local theTextureMapSocketColor = color 255 128 128
	
	local theNodesCastShadows = false
	
	local DepotPlacement = #bottomrollupreverse
	local DepotAutoCollapseOnDragAndDrop = false
	local DepotShowBLOPs = true
	local DepotShowCategories = true
	local DepotNodeWidth = 60
	local theDepotNodesArray  
	
	local UnconnectedNodesPlacement = #right
	local lastSelectionBeforeClick = 0

	global KrakatoaChannelsEditor_Functions
	struct KrakatoaChannelsEditor_Functions 
	(
		
		fn escapeString txt =
		(
			txt = txt as string
			local newString = ""
			for i = txt.count to 1 by -1 do
			(
				if txt[i] == "\"" and i>1 and txt[i-1] != "\\" then
					newString = "\\\"" + newString
				else if txt[i] == "\n" and i>1 and txt[i-1] != "\\" then
					newString = "\\n" + newString
				else
					newString = txt[i] + newString 
			)
			newString 
		),
		
		fn purifyText txt =
		(
			local newString = ""
			for i = txt.count to 1 by -1 do 
				if txt[i] == "\\" or txt[i] == "\"" then () else newString =txt[i]+newString
			newString	
		),
		
		fn purifyTextScript txt =
		(
			local newString = ""
			for i = txt.count to 1 by -1 do 
				if txt[i] != "\\" do newString =txt[i]+newString
			newString	
		),		
		
		fn createTrackViewControllers nodeID theNode =
		(
			
			theRootNode = try(trackViewNodes.KrakatoaChannelEditor)catch(newTrackViewNode "KrakatoaChannelEditor")
			theID = KrakatoaChannelNodeEditor_CurrentModifier.trackID
			--format "createTrackViewControllers Called with ID %\n" theID 
			theModTrack = try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+theID))catch(newTrackViewNode theRootNode ("KCE_"+theID))
			theNodeTrack = try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+theID+".Input_"+nodeID as string))catch(newTrackViewNode theModTrack ("Input_"+nodeID as string) )
			try
			(
				theIntController = theNodeTrack[1].controller
			)
			catch
			(
				addTrackViewController  theNodeTrack (theIntController = bezier_Float()) "Integer"
				theIntController.value = 1 
				try(theIntController.value = theNode[4][5][1])catch()
			)
			try
			(
				theFloatController = theNodeTrack[2].controller
			)
			catch
			(
				addTrackViewController  theNodeTrack (theFloatController = bezier_Float()) "Float" 
				try(theFloatController.value = theNode[4][5][2])catch()
			)
			try
			(
				theVectorController = theNodeTrack[3].controller
			)
			catch
			(
				addTrackViewController  theNodeTrack (theVectorController = point3_xyz()) "Vector" 
				try(theVectorController.value = theNode[4][5][3])catch()
			)
			"trackViewNodes.KrakatoaChannelEditor.KCE_"+theID+".Input_"+nodeID as string
		),	
		fn fixFlowIDsAfterLoading theArray=
		(
			--format "fixFlowIDsAfterLoading Called with current modifier %\n" KrakatoaChannelNodeEditor_CurrentModifier
			for i = 1 to theArray.count do
			(
				if theArray[i][1] == "Output" then
					theArray[i][4][8] = "Output"
				else if theArray[i][1] == "Input" then
				(
					local theID = (theArray[i][4][4])					
					if theID == undefined do 
					(
						theArray[i][4][4] = theID = (random 10000 1000000) as string + "_" + (random 10000 1000000) as string
					)	
					if theArray[i][3][1] != "Channel" do
						theArray[i][3][3] = KrakatoaChannelsEditor_Functions.createTrackViewControllers theID theArray[i]
					if theArray[i][3][1] == "TextureMap" or theArray[i][3][1] == "Time" or theArray[i][3][1] == "Script" do 
						try(deleteItem theArray[i][3] 3)catch()
				)	
				else
					if theArray[i][1] != "Operator"  and theArray[i][3][3] != undefined do 
						deleteItem theArray[i][3] 3	
			)
		),
		fn navigateToErrorModifier =
		(
			if KrakatoaChannelEditor_LastError[1] > 0 do
			(
				local theModErrors = (for m in getClassInstances KrakatoaChannelsModifier where m.trackId == KrakatoaChannelEditor_LastError[3] collect m)
				if theModErrors.count == 1 do 
				(
					max modify mode
					modPanel.setCurrentObject theModErrors[1]
				)
			)
		),
		fn displayError ErrorNodeIndex compilerError trackID =
		(
			--format "ERROR: % % % %\n" ErrorNodeIndex compilerError trackID  KrakatoaChannelNodeEditor_CurrentModifier.trackID
			--try(
				KrakatoaChannelEditor_LastError = #(ErrorNodeIndex,compilerError,trackID)
				if ErrorNodeIndex > 0 then 
				(
					if trackID == KrakatoaChannelNodeEditor_CurrentModifier.trackID then
					(
						local theErrorNode = KrakatoaChannelEditor_LastError[1]
						if theErrorNode > KrakatoaChannelEditor_BaseNodeTreeData.count then
						(
							KrakatoaChannelEditor_NodeTreeData = (execute KrakatoaChannelNodeEditor_CurrentModifier.flow)
							local theBlackOpIndex = KrakatoaChannelEditor_NodeTreeData[theErrorNode][4][13][1]
							local theActualNodeIndex = KrakatoaChannelEditor_NodeTreeData[theErrorNode][4][13][2]
							
							local theBlackOpName = KrakatoaChannelEditor_BaseNodeTreeData[theBlackOpIndex][4][8]
							local theActualNodeName = KrakatoaChannelEditor_NodeTreeData[theErrorNode][4][8]
							
							KrakatoaChannelNodeEditor_Rollout.lbx_log.items = append KrakatoaChannelNodeEditor_Rollout.lbx_log.items \
								(localtime +": ERROR In Node ["+theActualNodeIndex as string +":" +theActualNodeName as string +"] In BlackOp [" + theBlackOpIndex as string +":"+ theBlackOpName as string +"] : " + KrakatoaChannelEditor_LastError[2])
						)	
						else
							KrakatoaChannelNodeEditor_Rollout.lbx_log.items = append KrakatoaChannelNodeEditor_Rollout.lbx_log.items (localtime +": ERROR In Node " + theErrorNode as string + " : " + KrakatoaChannelEditor_LastError[2])
						--local theSel = (KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()) as bitarray
						--theSel[KrakatoaChannelEditor_LastError[1]] = false
						--KrakatoaChannelNodeEditor_Rollout.setSelectedNodesInData (theSel as array)
					)	
					else
					(
						local theModErrors = (for m in getClassInstances KrakatoaChannelsModifier where m.ErrorNodeIndex != 0 collect m)
						for m in theModErrors do
							KrakatoaChannelNodeEditor_Rollout.lbx_log.items = append KrakatoaChannelNodeEditor_Rollout.lbx_log.items (localtime +": ERROR In Node " + m.ErrorNodeIndex as string + " of Modifier ["+ m.name +"] ID:("+m.trackID as string+") : " + m.compilerError) 
					)	
				)	
				KrakatoaChannelNodeEditor_Rollout.lbx_log.selection = KrakatoaChannelNodeEditor_Rollout.lbx_log.items.count
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			--)catch(KrakatoaChannelNodeEditor_Rollout.lbx_log.items = #("Failed to get the Compiler Error from Modifier"))	
		),
		
		fn updateParentModifier =
		(
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 do 
			(
				return false
			)	
			try(
				KrakatoaChannelEditor_NodeTreeData = deepCopy KrakatoaChannelEditor_DisplayNodeTreeData
				for i = 1 to KrakatoaChannelEditor_NodeTreeData.count where KrakatoaChannelEditor_NodeTreeData[i][3][1] == "Script" do
						KrakatoaChannelEditor_NodeTreeData[i][3][2] = KrakatoaChannelEditor_NodeTreeData[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_NodeTreeData[i][4][6])
				with printAllElements on KrakatoaChannelNodeEditor_CurrentModifier.internalFlow = (KrakatoaChannelEditor_NodeTreeData as string)
				KrakatoaChannelEditor_BaseNodeTreeData = execute (KrakatoaChannelNodeEditor_CurrentModifier.internalFlow )
				KrakatoaChannelNodeEditor_CurrentModifier.flow = KrakatoaChannelsEditor_Functions.expandFlow KrakatoaChannelNodeEditor_CurrentModifier.internalFlow
				KrakatoaChannelNodeEditor_CurrentModifier.name = "KCM_"+ KrakatoaChannelEditor_BaseNodeTreeData[1][3][1]
			)catch()	
			if KrakatoaChannelEditor_LastError[1] == 0 do KrakatoaChannelNodeEditor_Rollout.lbx_log.items = #()
			KrakatoaChannelEditor_LastError = #(0,"","")
		),
		
		fn saveFlow theFilename =
		(
			for i = 1 to KrakatoaChannelEditor_BaseNodeTreeData.count where KrakatoaChannelEditor_BaseNodeTreeData[i][3][1] == "Script" do
					KrakatoaChannelEditor_BaseNodeTreeData[i][3][2] = KrakatoaChannelEditor_BaseNodeTreeData[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_BaseNodeTreeData[i][4][6])
				
			local theFileHandle = createFile theFileName
			with PrintAllElements true	format "global KrakatoaChannelEditor_NodeTreeData = %\n" KrakatoaChannelEditor_BaseNodeTreeData to:theFileHandle 
			close theFileHandle

			KrakatoaChannelEditor_BaseNodeTreeData = execute ( with PrintAllElements true KrakatoaChannelEditor_BaseNodeTreeData as string)
			KrakatoaChannelsEditor_Functions.buildDisplayTree()
		),
		
		fn buildDisplayTree =
		(
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count == 0 then
			(
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_BaseNodeTreeData 
			)
			else
			(
				KrakatoaChannelEditor_NodeTreeData = deepCopy KrakatoaChannelEditor_BaseNodeTreeData
				for j = 1 to KrakatoaChannelEditor_NodeTreeEditingLevel.count do
					KrakatoaChannelEditor_NodeTreeData = (KrakatoaChannelEditor_NodeTreeData[KrakatoaChannelEditor_NodeTreeEditingLevel[j]][3][2])
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Connector" do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8] = KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1]
					if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "OutputConnector" do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8] = KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1]
					--if KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] != undefined do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] += [300,100]
				)
			)
		),
		
		fn commitChangesToBLOP =
		(
			txt = "KrakatoaChannelEditor_BaseNodeTreeData"
			for j = 1 to KrakatoaChannelEditor_NodeTreeEditingLevel.count do
			(
				txt += "["+KrakatoaChannelEditor_NodeTreeEditingLevel[j] as string +"][3][2]"
			)
			txt += "= KrakatoaChannelEditor_DisplayNodeTreeData"
			execute txt			
		),
		
		fn endEditingBLOP type:#yesnocancel=
		(
			if KrakatoaChannelEditor_NodeTreeEditingUndoLevel[KrakatoaChannelEditor_NodeTreeEditingUndoLevel.count] != KrakatoaChannelEditor_LastUndoRecordNumber do
			(
				local q = case type of
				(
					#yesnocancel: yesnocancelbox "Do you want to keep the changes to this BlackOp?\n\nClick [Yes] to commit the changes to the BlackOp.\nClick [No] to discard any changes made in this Edit BlackOp session.\nClick [Cancel] to continue Editing..." title:"Exit BlackOp Editing Mode"
					#yesno: querybox "Do you want to keep the changes to this BlackOp?\n\nClick [Yes] to commit the changes to the BlackOp.\nClick [No] to discard any changes made in this Edit BlackOp session." title:"Exit BlackOp Editing Mode"
				)	
				case q of
				(
					#yes: 
					(
						txt = "KrakatoaChannelEditor_BaseNodeTreeData"
						for j = 1 to KrakatoaChannelEditor_NodeTreeEditingLevel.count do
						(
							txt += "["+KrakatoaChannelEditor_NodeTreeEditingLevel[j] as string +"][3][2]"
						)
						txt += "= KrakatoaChannelEditor_DisplayNodeTreeData"
						execute txt
					)
					#no: ()
					#cancel: (return false)
				)
			)
			
			deleteItem KrakatoaChannelEditor_NodeTreeEditingLevel KrakatoaChannelEditor_NodeTreeEditingLevel.count
			deleteItem KrakatoaChannelEditor_NodeTreeEditingUndoLevel KrakatoaChannelEditor_NodeTreeEditingUndoLevel.count
			deleteItem KrakatoaChannelEditor_NodeTreeEditingNames KrakatoaChannelEditor_NodeTreeEditingNames.count
			
			KrakatoaChannelsEditor_Functions.buildDisplayTree()
			KrakatoaChannelNodeEditor_Rollout.createDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord "End BlackOp Editing"		
			KrakatoaChannelsEditor_Functions.updateEditorTitle()						
			KrakatoaChannelNodeEditor_Rollout.displaySelectedNodeProperties()
		),	
			
		fn expandFlow theFlow specificNode:0 deleteBlop:true=
		(
			local st = timestamp()
			
			-- For every BlackOp
			--+ Collect all SubOps and put at the end of the array
			--+ Renumber their internal links to match the new offset
			--+ Reconnect those pointing at Connectors to connect to the links listed in the same order in [2]
			--+ Delete the original BlackOp node 
			--+ Renumber all links above it to keep the connections
			-- Repeat
			
			local theConvertedFlow = execute (theFlow)
			local notDone = true
			while notDone do
			(
				notDone = false
				for i = 1 to theConvertedFlow.count do
				(
					local theRule = if specificNode > 0 then specificNode  == i and theConvertedFlow[i][1] == "BlackOp" else theConvertedFlow[i][1] == "BlackOp" 
					if theRule then --if the 
					(
						notDone = true
						local basePos = theConvertedFlow[i][4][1] 
						local theNode = deepcopy theConvertedFlow[i][3][2] --the blackops definition
						local theOldCount = theConvertedFlow.count --the number of nodes before expansion
						local theOutputConnector = 0
						for j = 1 to theNode.count do --go through all nodes in the BlackOps def
						(
							if theNode[j][1] == "Operator" do theNode[j][5] = theConvertedFlow[i][5] --if BlackOp set to PassThrough, do the same for all its Operators
							theNode[j][4][13] = #(i,j) --store the parent of this node for error display
							
							try(theNode[j][4][1] += basePos-[300,100])catch()
							if theNode[j][1] == "OutputConnector" then --if the node inside is an output connector, set its link to point at the the original node plus old count
								theOutputConnector = theNode[j][2][1] + theOldCount
							else
								for c = 1 to theNode[j][2].count where theNode[j][2][c] != undefined and theNode[j][2][c] > 0 do
									theNode[j][2][c] += theOldCount
							
						)	
						join theConvertedFlow theNode 
						if theOutputConnector > 0 do --find out who is connected to the output of the BlackOp and redirect the link to the actual root inside the BlackOp:
							for j = 1 to theOldCount do
								for c = 1 to theConvertedFlow[j][2].count where theConvertedFlow[j][2][c] == i do 
									theConvertedFlow[j][2][c] = theOutputConnector
						
						local theConnectors = for j = theOldCount+1 to theConvertedFlow.count where theConvertedFlow[j][1] == "Connector" collect j
						for c = 1 to theConnectors.count do
						(
							if theConvertedFlow[i][2][c] == undefined do theConvertedFlow[i][2][c] = 0
							local theConnectorIndex = theConnectors[c] --contains the new index of the connector
							local theNodeToConnect1 = theConvertedFlow[i][2][c] --points at a node in original flow that should be connected to the expanded node
							for j = theOldCount+1 to theConvertedFlow.count do 
								for k = 1 to theConvertedFlow[j][2].count do
									if theConvertedFlow[j][2][k] == theConnectorIndex do
										theConvertedFlow[j][2][k] = theNodeToConnect1
						)
						--delete the connector nodes from the expanded flow:
						for j = theConvertedFlow.count to theOldCount+1 by -1 do
							if theConvertedFlow[j][1] == "Connector" or theConvertedFlow[j][1] == "OutputConnector" do 
							(
								deleteItem theConvertedFlow j --delete the connector node
								for k = 1 to theConvertedFlow.count do
									for c = 1 to theConvertedFlow[k][2].count where theConvertedFlow[k][2][c] != undefined and theConvertedFlow[k][2][c] > j do 
										theConvertedFlow[k][2][c] -= 1
							)
						if deleteBLOP do deleteItem theConvertedFlow i  --delete the original blackop
						--now renumber all connections in all nodes pointing at nodes above the deleted one by subtracting 1:
						for j = 1 to theConvertedFlow.count do
							for c = 1 to theConvertedFlow[j][2].count where theConvertedFlow[j][2][c] != undefined and theConvertedFlow[j][2][c] > i do 
								theConvertedFlow[j][2][c] -= 1
							
					)	
				)
			)--end while	
			--format "Flow Conversion: % ms.\n" (timestamp()-st)
			--KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading theConvertedFlow
			with printAllElements true theConvertedFlow as string
		),
		
		fn updateEditorTitle =
		(
			txt = "Krakatoa Channels Editor - ID:" + KrakatoaChannelNodeEditor_CurrentModifier.trackID as string + " - ["+ KrakatoaChannelNodeEditor_CurrentModifier.name+"]"
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 do 
			(
				txt += " - BlackOp "
				for j = 1 to KrakatoaChannelEditor_NodeTreeEditingLevel.count do txt += "["+ KrakatoaChannelEditor_NodeTreeEditingLevel[j] as string + ":" + KrakatoaChannelEditor_NodeTreeEditingNames[j] + "]>"
			)		
			KrakatoaChannelNodeEditor_Rollout.title = txt
		),		
		
		fn KrakatoaChannelEditor_UpdateDepot =
		(
			--try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch()
			if KrakatoaChannelNodeEditor_CurrentModifier != undefined do
			(
				/*
				local theSize = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Size")
				if theSize == OK do theSize = [980,600]
				
				local thePos = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Position")
				if thePos == OK do thePos = [100,100]
				createDialog KrakatoaChannelNodeEditor_Rollout theSize.x theSize.y thePos.x thePos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing, #style_minimizebox, #style_maximizebox) menu:KrakatoaChannelNodeEditor_Rollout_MainMenu
				KrakatoaChannelNodeEditor_Rollout.resized theSize	
				KrakatoaChannelNodeEditor_Rollout.title = "Krakatoa Channels Editor - ID:" + KrakatoaChannelNodeEditor_CurrentModifier.trackID as string + " - ["+ KrakatoaChannelNodeEditor_CurrentModifier.name+"]"
				*/
				KrakatoaChannelNodeEditor_Rollout.updateDepotDefinition()
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
				setFocus KrakatoaChannelNodeEditor_Rollout.hc		
			)
		),
		
		fn exposeControlsToModifier theMod =
		(
			try(modpanel.setCurrentObject theMod)catch()
			try(deleteItem theMod.custAttributes (("KCM_CA_"+theMod.trackID as string) as name)	)catch()
			try(modpanel.setCurrentObject theMod)catch()
			local theCADef2 = "rollout params \"Exposed Parameters\" \n("
			
			theCADef2 += "fn updateMod = (\n"
			theCADef2 += "local theMod = (custAttributes.getOwner this)\n"
			theCADef2 += "if theMod.autoUpdate do theMod.autoUpdate = theMod.autoUpdate \n"
			theCADef2 += "if KrakatoaChannelNodeEditor_Rollout.open do KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false\n"
			theCADef2 += ")\n"
			
			theCADef3 = "on params open do (\n"
			
			local theCADef = "KCM_CA_DEF = attributes KCM_CA_"+theMod.trackID + "(\n"
			theCADef += "parameters main rollout:params ( \n"
				
			cnt = 0
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Float" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
			(
				cnt+=1
				local theName = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8]
				local theID = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][4]
				theCADef += "float_"+cnt as string+ " type:#float ui:spn_"+cnt as string+" default:1 \n"
				theCADef2 += "spinner spn_"+cnt as string+" \""+i as string + ": "+theName+": \" type:#float range:[-100000,100000,0] offset:[7,0]\n"
				theCADef2 += "on spn_"+cnt as string+" changed val do updateMod()\n"
			)--end i loop
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Integer" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
			(
				cnt+=1
				local theName = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8]
				local theID = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][4]
				theCADef += "int_"+cnt as string+ " type:#integer ui:spn_"+cnt as string+" default:1 \n"
				theCADef2 += "spinner spn_"+cnt as string+" \""+i as string + ": "+theName+": \" type:#integer range:[1,3,1] offset:[7,0]\n"
				theCADef2 += "on spn_"+cnt as string+" changed val do updateMod()\n"
			)--end i loop
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Vector" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
			(
				local theName = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8]
				local theID = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][4]
				theCADef2 += "group \""+i as string + ": "+theName+"\"(\n"

				cnt+=1				
				theCADef += "vect_"+cnt as string+ " type:#float ui:spn_"+cnt as string+"\n"
				theCADef2 += "spinner spn_"+cnt as string+" \"X: \" type:#float range:[-1000000,1000000,0] offset:[5,0] scale:0.01\n"
				
				cnt+=1
				theCADef += "vect_"+cnt as string+ " type:#float ui:spn_"+cnt as string+"\n"
				theCADef2 += "spinner spn_"+cnt as string+" \"Y: \" type:#float range:[-1000000,1000000,0] offset:[5,0] scale:0.01\n"
				
				cnt+=1
				theCADef += "vect_"+cnt as string+ " type:#float ui:spn_"+cnt as string+"\n"
				theCADef2 += "spinner spn_"+cnt as string+" \"Z: \" type:#float range:[-1000000,1000000,0] offset:[5,0] scale:0.01\n"

				
/*				
				theCADef += "color_"+cnt as string+ " type:#frgba ui:clr_"+cnt as string+" animatable:false\n"
				theCADef2 += "colorpicker clr_"+cnt as string+" offset:[-5,-65] height:60 width:55 align:#left modal:false alpha:true enabled:true\n"

				theCADef += "on vect_"+(cnt-2) as string+ " set val do (\n"
				theCADef += "color_"+(cnt) as string+ " = [val,vect_"+(cnt-1) as string+",vect_"+(cnt) as string+",0])\n"
				theCADef += "on vect_"+(cnt-1) as string+ " set val do (\n"
				theCADef += "color_"+(cnt) as string+ " = [vect_"+(cnt-2) as string+",val,vect_"+(cnt) as string+",0])\n"
				theCADef += "on vect_"+(cnt) as string+ " set val do (\n"
				theCADef += "color_"+(cnt) as string+ " = [vect_"+(cnt-2) as string+",vect_"+(cnt-1) as string+",val,0])\n"

				--theCADef += "on vect_"+(cnt-2) as string+ " get val do (print val\n"
				--theCADef += "val = 0 \n)" --[vect_"+(cnt-2) as string+",vect_"+(cnt-1) as string+",vect_"+(cnt) as string+",0])\n" --"color_"+(cnt) as string+ 
*/

				theCADef2 += ")--end group\n"
				cnt-=2

				theCADef2 += "fn updateColor"+(cnt+2) as string+" = ()\n"
				--theCADef2 += "color_"+(cnt+2) as string+" = [vect_"+(cnt as string)+",vect_"+((cnt+1) as string)+",vect_"+(cnt+2) as string+"]*255)\n"

				theCADef2 += "on spn_"+cnt as string+" changed val do (updateMod();updateColor"+(cnt+2) as string+"())\n"
				cnt+=1
				theCADef2 += "on spn_"+cnt as string+" changed val do (updateMod();updateColor"+(cnt+1) as string+"())\n"
				cnt+=1
				theCADef2 += "on spn_"+cnt as string+" changed val do (updateMod();updateColor"+cnt as string+"())\n"	
				
				--theCADef3 += "updateColor"+cnt as string+"()\n"	
				/*theCADef2 += "on clr_"+cnt as string+" changed val do(\n"	
				theCADef2 += "vect_"+(cnt-2) as string+" = val.r/255.0\n"	
				theCADef2 += "vect_"+(cnt-1) as string+" = val.g/255.0\n"	
				theCADef2 += "vect_"+(cnt) as string+" = val.b/255.0\n)\n"	
				*/
			)--end i loop			

			theCADef += ")--end params\n"
			theCADef3 += ")--end on open\n"
			theCADef2 += theCADef3 
			theCADef2 += ")--end rollout\n"
			theCADef2 += ")--end def\n"
			if cnt > 0 do
			(
				KCM_CA_DEF = execute (theCADef+theCADef2)
				custAttributes.add theMod KCM_CA_DEF
				local theCAName = (("KCM_CA_"+theMod.trackID as string) as name)

				cnt = 0
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Float" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
				(
					cnt+=1
					local theController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[i][3][3]+"[2].controller")
					theMod.custAttributes[theCAName][cnt].controller = theController
				)
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Integer" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
				(
					cnt+=1
					local theController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[i][3][3]+"[1].controller")
					theMod.custAttributes[theCAName][cnt].controller = theController
				)
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == "Vector" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do
				(
					cnt+=1
					local theController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[i][3][3]+"[3].controller[1].controller")
					theMod.custAttributes[theCAName][cnt].controller = theController
					cnt+=1
					local theController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[i][3][3]+"[3].controller[2].controller")
					theMod.custAttributes[theCAName][cnt].controller = theController
					cnt+=1
					local theController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[i][3][3]+"[3].controller[3].controller")
					theMod.custAttributes[theCAName][cnt].controller = theController
				)	
				try(modpanel.setCurrentObject theMod)catch()
			)
		)--end fn

	)--end struct

	fn KrakatoaChannelEditor_TrackviewCleanupCallback =
	(
		local theInstances = getClassInstances KrakatoaChannelsModifier
		local theIDs = for i in theInstances collect i.trackID
		local theRootNode = try(trackViewNodes.KrakatoaChannelEditor)catch(undefined)
		if theRootNode != undefined do
		(
			for i = trackViewNodes.KrakatoaChannelEditor.numsubs to 1 by -1 do
			(
				local theModTrack = trackViewNodes.KrakatoaChannelEditor[i]
				if theModTrack != undefined do
				(
					local theID = substring theModTrack.name 5 -1
					if findItem theIDs theID == 0 do 
						deleteTrackViewNode trackViewNodes.KrakatoaChannelEditor (execute ("trackViewNodes.KrakatoaChannelEditor."+theModTrack.name))
				)	
			)

			for i = trackViewNodes.KrakatoaChannelEditor.numsubs to 1 by -1 do
			(
				local theModTrack = trackViewNodes.KrakatoaChannelEditor[i]
				if theModTrack != undefined do
				(
					local theID = substring theModTrack.name 5 -1
					local theIndex = findItem theIDs theID
					if theIndex > 0 do
					(
						local theData = execute theInstances[theIndex].internalFlow
						local theControllerIDs = for c = 1 to theData.count where theData[c][1] == "Input" collect theData[c][4][4]
						local theModsToDelete = for j = theModTrack.numsubs to 1 by -1 collect
						(
							local theControllerID = substring theModTrack[j].name 7 -1
							if findItem theControllerIDs theControllerID == 0 then
								(execute ("trackViewNodes.KrakatoaChannelEditor."+theModTrack.name+"."+theModTrack[j].name)) 
							else
								dontcollect
						)
						local theRoot = execute ("trackViewNodes.KrakatoaChannelEditor."+theModTrack.name)
						for j in theModsToDelete do deleteTrackViewNode theRoot j 
					)	
				)	
			)			
		)
	)

	fn loadDisplaySettings filename:"" =
	(
		if filename == "" do filename =  (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini")
		
		local theVal = (getIniSetting FileName "ParticleChannelEditor" "DepotPlacement") 
		if theVal == "" do theVal = #bottomrollupreverse
		DepotPlacement = theVal as name
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "DepotAutoCollapseOnDragAndDrop") 
		if theVal == OK do theVal = false
		DepotAutoCollapseOnDragAndDrop = theVal		
				
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "DepotShowCategories") 
		if theVal == OK do theVal = true
		DepotShowCategories = theVal		
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "DepotShowBLOPs") 
		if theVal == OK do theVal = true
		DepotShowBLOPs = theVal		
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "DepotNodeWidth") 
		if theVal == OK do theVal = 60
		DepotNodeWidth = theVal		
		
		

		local theVal = (getIniSetting FileName "ParticleChannelEditor" "UnconnectedNodesPlacement") 
		if theVal == "" do theVal = #left
		UnconnectedNodesPlacement	= theVal as name
		
		/*
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "FlagUnconnectedAsErrors") 
		if theVal == OK do theVal = true
		flagUnconnectedAsErrors = theVal
		*/
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "NodeWidth")
		if theVal == OK do theVal = 140
		NodeWidth = theVal

		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "NodeXSpace")
		if theVal == OK do theVal = 40
		NodeXSpace = theVal
		
		local theVal = execute (getIniSetting FileName "ParticleChannelEditor" "OperatorHeightConstant")
		if theVal == OK do theVal = true
		operatorHeightConstant = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "SnapToGrid" )
		if theVal == OK do theVal = true
		SnapToGrid = theVal

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "AutoZoomExtents" )
		if theVal == OK do theVal = false
		AutoZoomExtents = theVal		

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "AutoReorderToggle" )
		if theVal == OK do theVal = false
		AutoReorderToggle = theVal


		theVal = (getIniSetting filename "ParticleChannelEditor" "AutoReorderPattern" )
		if theVal == "" do theVal = "row"
		AutoReorderPattern = theVal as name
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "UseMousePositionOnCreation" )
		if theVal == OK do theVal = false
		useMousePositionOnCreation = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "BackgroundColor" )
		if theVal == OK do theVal = color 192 192 198
		theBackgroundColor = theVal	
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "GridColor" )
		if theVal == OK do theVal = color 200 200 210
		theGridColor = theVal			
		
		

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "DepotHeaderColor")
		if theVal == OK do theVal = color 80 80 128
		theHeaderColor  = theVal

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "InputNodeColor")
		if theVal == OK do theVal = color 220 220 255
		theInputNodeColor  = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "OutputNodeColor")
		if theVal == OK do theVal = color 200 255 200
		theOutputNodeColor = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "OperatorNodeColor")
		if theVal == OK do theVal = color  255 235 200
		theOperatorNodeColor  = theVal

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "BoxNodeColor")
		if theVal == OK do theVal = color  255 200 180
		theBoxNodeColor  = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "NodesCastShadows")
		if theVal == OK do theVal = false
		theNodesCastShadows = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "InputSocketColor")
		if theVal == OK do theVal = color 255 0 0
		theInputSocketColor  = theVal
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "ChannelSocketColor")
		if theVal == OK do theVal = color 0 0 200
		theChannelSocketColor  = theVal		
		
		theVal = execute (getIniSetting filename "ParticleChannelEditor" "FloatSocketColor")
		if theVal == OK do theVal = color 0 128 0
		theFloatSocketColor  = theVal		

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "VectorSocketColor")
		if theVal == OK do theVal = color  0 255 200
		theVectorSocketColor  = theVal		

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "IntegerSocketColor")
		if theVal == OK do theVal = color  128 0 255
		theIntegerSocketColor  = theVal			

		theVal = execute (getIniSetting filename "ParticleChannelEditor" "TimeSocketColor")
		if theVal == OK do theVal = color  255 255 0
		theTimeSocketColor  = theVal				
	)
	
	
	if KrakatoaChannelEditor_BaseNodeTreeData==undefined do 
	(
		KrakatoaChannelEditor_BaseNodeTreeData = #(
			#("Output", #(2), #("Color","float16",3), #([500,0],false,false), true )
		)
	)
	
	local channelsList = #(
	#("Position", "float32", 3, "Particle Position"),
	#("Velocity", "float16", 3, "Particle Velocity units/sec."),
	#("Density", "float16", 1, "Particle Density"),
	#("Color", "float16", 3 , "Scatter Color/Max Vertex Color"),
	#("Absorption", "float16", 3, "Absorption Color"),
	#("Emission", "float16", 3, "Emission Color"),
	#("Lighting", "float32", 3, "Krakatoa Lighting"),
	#("Normal", "float16", 3, "Normal Vector (X Axis)"),
	#("Tangent", "float16", 3, "Tangent Vector (Y Axis)"),
	#("TextureCoord", "float16", 3, "3ds Max Mapping Channel 1"),
	#("Age", "int32", 1, "Particle Age"),
	#("LifeSpan", "int32", 1, "Particle Life Span"),
	#("ID", "int32", 1, "Particle ID"),
	#("MtlIndex","int32", 1, "PFlow Particle Material ID"),
	#("MXSInteger", "int32", 1, "PFlow Scripted Integer Channel"),
	#("MXSFloat", "float32", 1, "PFlow Scripted Float Channel"),
	#("MXSVector", "float16", 3, "PFlow Scripted Vector Channel"),
	#("Orientation", "float16", 4, "Particle Quaternion Orientation"),
	#("Scale", "float16", 3, "Particle Scale"),
	#("Acceleration", "float16", 3, "Particle Acceleration"),
	#("Fuel", "float16", 1, "FumeFX Fuel Channel"),
	#("Temperature", "float16", 1, "FumeFX/RealFlow Temperature"),
	#("Force", "float32", 3, "RealFlow Force Channel"),
	#("Vorticity", "float32", 3, "RealFlow Vorticity Channel"),
	#("NeighborCount", "int32", 1, "RealFlow Neighbor Count"),
	#("IsolationTime", "float32", 1, "RealFlow Isolation Time"),
	#("Viscosity", "float32", 1, "RealFlow Viscosity"),
	#("Pressure", "float32", 1, "RealFlow Pressure"),
	#("Mass", "float32", 1, "RealFlow Mass")
	)	
	for i = 2 to 99 do append channelsList #("Mapping"+i as string, "float32", 3, "3ds Max Mapping Channel "+i as string)		

	global KrakatoaChannelEditor_AddNode_RCMenu
	rcmenu KrakatoaChannelEditor_AddNode_RCMenu 
	(
		fn anythingSelected = ((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		fn moreThanOneSelected = ((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 1)
		fn depotIsOff = (DepotPlacement == #off)
		fn isInBlackOpEditingMode = (KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0)
		menuItem mnu_endEditingBLOP "Exit BlackOp Editing Mode" filter:isInBlackOpEditingMode
		separator sep_10 filter:isInBlackOpEditingMode
		
		menuItem mnu_DepotOn "Enable Depot" filter:depotIsOff		
		separator sep_20 filter:depotIsOff
		
		subMenu "Inputs"
		(		
			subMenu "Channel Inputs"
			(			
				menuItem mnu_addPositionChannel "[Position] Channel Input (Shift+P)"
				menuItem mnu_addColorChannel "[Color] Channel Input (Shift+C)"
				menuItem mnu_addDensityChannel "[Density] Channel Input (Shift+D)"
				menuItem mnu_addVelocityChannel "[Velocity] Channel Input (Shift+V)"
				menuItem mnu_addNormalChannel "[Normal] Channel Input (Shift+N)"
				menuItem mnu_addTangentChannel "[Tangent] Channel Input (Shift+T)"
				menuItem mnu_addLightingChannel "[Lighting] Channel Input (Shift+L)"
				menuItem mnu_addMappingChannel "[TextureCoord] Channel Input (Shift+M)"
				menuItem mnu_addAgeChannel "[Age] Channel Input (Shift+A)"
				menuItem mnu_addIDChannel "[ID] Channel Input (Shift+I)"
			)	
			separator sep_30
			menuItem mnu_addInputInteger "[Integer Value] Input (I)"
			menuItem mnu_addInputFloat "[Float Value] Input (F)"
			menuItem mnu_addInputVector "[Vector Value] Input (V)"
			separator sep_40
			menuItem mnu_addInputTextureMap "[TextureMap] Input (M)"
			--menuItem mnu_addInputTime "[Time] Input"
			menuItem mnu_addInputScript "[Script] Input"
		)
		separator sep_50
		menuItem mnu_addChannelOperator "Automatic Operator (O)"
		subMenu "Arithmetic Operators"
		(
			menuItem mnu_addAddOperator "[Add] Operator (Num.+)"
			menuItem mnu_addSubtractOperator "[Subtract] Operator (Num.-)"
			menuItem mnu_addMultiplyOperator "[Multiply] Operator (Num.*)"
			menuItem mnu_addDivideOperator "[Divide] Operator (Num./)"
			menuItem mnu_addPowerOperator "[Power] Operator (^)"
			menuItem mnu_addModuloOperator "[Modulo] Operator"
			menuItem mnu_addBlendOperator "[Blend] Operator (B)"
			menuItem mnu_addClamp "[Clamp] Operator (C)"
			menuItem mnu_addAbsoluteValueOperator "[AbsoluteValue] Operator (A)"
			menuItem mnu_addFloorOperator "[Floor] Operator (Ctrl+F)"
			menuItem mnu_addNegateOperator "[Negate] Operator (Ctrl+Shift+N)"
		)
		subMenu "Vector Operators"
		(
			menuItem mnu_addDotProduct "[DotProduct] Operator (.)"
			menuItem mnu_addCrossProduct "[CrossProduct] Operator (,)"
			menuItem mnu_addNormalizeOperator "[Normalize] Operator (N)"
			menuItem mnu_addMagnitude "[Magnitude] Operator (M)"
			menuItem mnu_addComponentSum "[ComponentSum] Operator (S)"
		)	
		subMenu "Trigonometry Operators"
		(
			menuItem mnu_addSin "[Sin] Operator ([)"
			menuItem mnu_addCos "[Cos] Operator (])"
			menuItem mnu_addTan "[Tan] Operator (\)"
			separator sep_100
			menuItem mnu_addASin "[ASin] Operator ({)"
			menuItem mnu_addACos "[ACos] Operator (})"
			menuItem mnu_addATan "[ATan] Operator (|)"
		)
		subMenu "Conversion Operators"
		(
			menuItem mnu_addToVector "[ToVector] Operator (T)"
			menuItem mnu_addToFloat "[ToFloat] Operator"				
			menuItem mnu_addToInteger "[ToInteger] Operator"
			menuItem mnu_addToScalar "[ToScalar] Operator (Shift+S)"
		)
		subMenu "Transformation Operators"
		(
			menuItem mnu_addToWorldOperator "[ToWorld] Operator "
			menuItem mnu_addFromWorldOperator "[FromWorld] Operator "
			menuItem mnu_addToSpaceOperator "[ToSpace] Operator "
			menuItem mnu_addFromSpaceOperator "[FromSpace] Operator "
			
		)
		subMenu "Logic and Comparison Operators"
		(
			menuItem mnu_addLessOperator "[Less] < Operator "
			menuItem mnu_addLessOrEqualOperator "[LessOrEqual] <= Operator "
			menuItem mnu_addGreaterOperator "[Greater] > Operator "
			menuItem mnu_addGreaterOrEqualOperator "[GreaterOrEqual] >= Operator "
			menuItem mnu_addEqualOperator "[Equal] == Operator "
			separator sep_200
			menuItem mnu_addAndOperator "[And] Operator "
			menuItem mnu_addOrOperator "[Or] Operator "
			menuItem mnu_addNotOperator "[Not] Operator "
			separator sep_210
			menuItem mnu_addSwitchOperator "[Switch] Operator (/)"
		)
		separator sep_300
		menuItem mnu_addNewBLOPInline "[BlackOp] Compound Operator From Selection" filter:moreThanOneSelected	
		menuItem mnu_addNewBLOP "[BlackOp] Compound Operator From File"
		menuItem mnu_saveBLOPDefinition "Save Selection As BlackOP" filter:moreThanOneSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		separator sep_310 filter:anythingSelected
			
		subMenu "Expose Selected..." filter:anythingSelected
		(
			menuitem mnu_selectExposedInputs "Select Exposed Inputs"
			menuitem mnu_UnExposeSelectedInputs "Unexpose Selected Inputs"
			menuitem mnu_ExposeSelectedInputs "Expose Selected Inputs"
			separator sep_500
			menuitem mnu_updateExposedInputs "Update Exposed Inputs"
		)
		separator sep_315 filter:anythingSelected
		menuItem mnu_swapInputs "Swap First Two Inputs Of Selected Operators (Ctrl+W)" filter:anythingSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		menuItem mnu_swapSecondInputs "Swap Last Two Inputs Of Selected Operators (Shift+Ctrl+W)" filter:anythingSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		menuItem mnu_toggleNode "Toggle Selected Nodes On/Off (Ctrl+P)" filter:anythingSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		separator sep_320 filter:anythingSelected
		fn clipboardFull = (KrakatoaChannelEditor_ClipboardArray.count > 0) 
		menuItem mnu_copyToClipboard "Copy Selected Nodes (Ctrl+C)" filter:anythingSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0) 
		menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" filter:clipboardFull 
		separator sep_330 filter:anythingSelected
		
		subMenu "Disconnect..." filter:anythingSelected
		(
			menuItem mnu_disconnectAllInputsSel "Disconnect All Inputs Of Selected Nodes"	
			menuItem mnu_disconnectAllOutputsSel "Disconnect All Outputs Of Selected Nodes" --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		)	
		separator sep_340 filter:anythingSelected
		menuItem mnu_deleteSelectedNodes "Delete Selected Nodes (Del.)" filter:anythingSelected --enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)

		
		on mnu_UnExposeSelectedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.unexposeSelectedInputs()
		on mnu_ExposeSelectedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.exposeSelectedInputs()
		on mnu_updateExposedInputs picked do
			KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier			
		on mnu_selectExposedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.selectExposedInputs()

		on mnu_endEditingBLOP picked do
			KrakatoaChannelsEditor_Functions.endEditingBLOP()

		on mnu_DepotOn picked do
		(
			DepotPlacement = #bottom
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)
		
		on mnu_disconnectAllInputsSel picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllInputs Single:false
		
		on mnu_disconnectAllOutputsSel picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllOutputs Single:false
	
		on mnu_saveBLOPDefinition picked do KrakatoaChannelNodeEditor_Rollout.saveBLOPDefinition()
			
		on mnu_copyToClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.copySelectionToClipboard()

		on mnu_pasteFromClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.pasteSelectionFromClipboard()
		
		on mnu_addNewBLOP picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewBLOP creationType:#rcmenu
		
		on mnu_addNewBLOPInline picked do
			KrakatoaChannelNodeEditor_Rollout.createBLOPInline creationType:#rcmenu 

		on mnu_swapInputs picked do
			KrakatoaChannelNodeEditor_Rollout.swapInputsOrder Single:false
		
		on mnu_swapSecondInputs picked do
			KrakatoaChannelNodeEditor_Rollout.swapInputsOrder Single:false Last:true
			
		
		on mnu_toggleNode picked do
			KrakatoaChannelNodeEditor_Rollout.setPassThrough Single:false
		
		on mnu_deleteSelectedNodes picked do
			KrakatoaChannelNodeEditor_Rollout.deleteSelectedNodes()
		
		on mnu_resetPan picked do
			KrakatoaChannelNodeEditor_Rollout.resetPanFactor()

		on mnu_resetZoom picked do
			KrakatoaChannelNodeEditor_Rollout.resetZoomFactor()
		
		on mnu_ZoomExtents picked do
			KrakatoaChannelNodeEditor_Rollout.ZoomExtents()
		
		on mnu_ZoomExtentsSelected picked do
			KrakatoaChannelNodeEditor_Rollout.ZoomExtentsSelected()
		
		on mnu_addPositionChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Position" creationType:#rcmenu
		on mnu_addColorChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Color" creationType:#rcmenu
		on mnu_addDensityChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Density" creationType:#rcmenu
		on mnu_addVelocityChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Velocity" creationType:#rcmenu
		on mnu_addNormalChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Normal" creationType:#rcmenu
		on mnu_addTangentChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Tangent" creationType:#rcmenu
		on mnu_addLightingChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Lighting" creationType:#rcmenu
		on mnu_addMappingChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"TextureCoord" creationType:#rcmenu
		on mnu_addAgeChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"Age" creationType:#rcmenu
		on mnu_addIDChannel picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#channel channelName:"ID" creationType:#rcmenu
		
		on mnu_addInputFloat picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#value valueType:#float creationType:#rcmenu

		on mnu_addInputInteger picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#value valueType:#integer creationType:#rcmenu

		on mnu_addInputVector picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#value valueType:#vector creationType:#rcmenu
		
		--on mnu_addInputTime picked do KrakatoaChannelNodeEditor_Rollout.addNewInput type:#time creationType:#rcmenu

		on mnu_addInputScript picked do
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#script creationType:#rcmenu
		
		on mnu_addInputTextureMap picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewInput type:#TextureMap creationType:#rcmenu
		
		on mnu_addChannelOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator creationType:#rcmenu

		on mnu_addAddOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Add" creationType:#rcmenu
		
		on mnu_addSubtractOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Subtract" creationType:#rcmenu
		
		on mnu_addMultiplyOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Multiply" creationType:#rcmenu
		
		on mnu_addDivideOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Divide" creationType:#rcmenu
		
		on mnu_addPowerOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Power" creationType:#rcmenu

		on mnu_addModuloOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Modulo" creationType:#rcmenu
		
		on mnu_addBlendOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Blend" creationType:#rcmenu

		on mnu_addAbsoluteValueOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"AbsoluteValue" creationType:#rcmenu

		on mnu_addFloorOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Floor" creationType:#rcmenu

		on mnu_addNegateOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Negate" creationType:#rcmenu
		
		on mnu_addNormalizeOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Normalize" creationType:#rcmenu

		on mnu_addToScalar picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToScalar" creationType:#rcmenu
		on mnu_addToScalar2 picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToScalar" creationType:#rcmenu

		on mnu_addMagnitude picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Magnitude" creationType:#rcmenu

		on mnu_addComponentSum picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ComponentSum" creationType:#rcmenu

		on mnu_addDotProduct picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"DotProduct" creationType:#rcmenu
		on mnu_addCrossProduct picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"CrossProduct" creationType:#rcmenu
		
		on mnu_addSin picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Sin" creationType:#rcmenu
		on mnu_addCos picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Cos" creationType:#rcmenu
		on mnu_addTan picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Tan" creationType:#rcmenu
		on mnu_addASin picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ASin" creationType:#rcmenu
		on mnu_addACos picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ACos" creationType:#rcmenu
		on mnu_addATan picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ATan"	creationType:#rcmenu	

		on mnu_addToFloat picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToFloat" creationType:#rcmenu	
		on mnu_addToInteger picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToInteger" creationType:#rcmenu	


		on mnu_addToWorldOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToWorld" creationType:#rcmenu	
		on mnu_addFromWorldOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"FromWorld" creationType:#rcmenu	
		on mnu_addToSpaceOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"ToSpace" creationType:#rcmenu	
		on mnu_addFromSpaceOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"FromSpace" creationType:#rcmenu	
	

		on mnu_addLessOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Less" creationType:#rcmenu
		on mnu_addLessOrEqualOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"LessOrEqual" creationType:#rcmenu	
		on mnu_addGreaterOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Greater" creationType:#rcmenu
		on mnu_addGreaterOrEqualOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"GreaterOrEqual" creationType:#rcmenu
		on mnu_addEqualOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Equal"	creationType:#rcmenu
		
		on mnu_addAndOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"LogicalAnd" creationType:#rcmenu	
		on mnu_addOrOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"LogicalOr" creationType:#rcmenu		
		on mnu_addNotOperator picked do 
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"LogicalNot" creationType:#rcmenu	

		on mnu_addSwitchOperator picked do
			KrakatoaChannelNodeEditor_Rollout.addNewOperator type:"Switch" creationType:#rcmenu
		
	)	
	
	rcmenu KrakatoaChannelEditor_EditNode_RCMenu 
	(
		fn isOperatorUnderMouse = ( (KrakatoaChannelNodeEditor_Rollout.lastNodeClick > 1 and KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][1] == "Operator") )
		fn isInputUnderMouse = ( (KrakatoaChannelNodeEditor_Rollout.lastNodeClick > 1 and KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][1] == "Input") )
		fn anythingSelected =((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
		fn moreThanOneSelected = ((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 1)
		fn canExposeControl = (KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] == "Value" and KrakatoaChannelEditor_NodeTreeEditingLevel.count == 0)
		fn isBlackopUnderMouse = (KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][1]=="BlackOp")
		fn isBlackopOrSelection = isBlackopUnderMouse() or anythingSelected()
		fn canPaste = (KrakatoaChannelEditor_ClipboardArray.count > 0)
		fn canPasteOrSelected = (canPaste() or anythingSelected())
		fn isInBlackOpEditingMode = (KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0)
		fn moreThanOneSelectedOrBLOP = (moreThanOneSelected() or isBlackopUnderMouse())
		
		
		
		menuItem mnu_endEditingBLOP "Exit BlackOp Editing Mode" filter:isInBlackOpEditingMode
		separator sep_1 filter:isInBlackOpEditingMode
		
		menuItem mnu_editBLOP "Edit BlackOp" filter:isBlackopUnderMouse
		--menuItem mnu_closeBLOP "Close BlackOp" filter:isBlackopOpen
		
		menuItem mnu_addNewBLOPInline "[BlackOp] From Selection" filter:moreThanOneSelected
		menuItem mnu_saveBLOPDefinition "Save Selection As BlackOP" filter:moreThanOneSelected
		menuItem mnu_explodeBLOP "Explode BlackOp" filter:isBlackopUnderMouse
		separator sep_10 filter:moreThanOneSelectedOrBLOP
		
		menuItem mnu_exposeControl "Expose Control" filter:canExposeControl  checked:(KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] == true)
		subMenu "Expose Selected..." filter:anythingSelected
		(
			menuitem mnu_selectExposedInputs "Select Exposed Inputs"
			menuitem mnu_UnExposeSelectedInputs "Unexpose Selected Inputs"
			menuitem mnu_ExposeSelectedInputs "Expose Selected Inputs"
			separator sep_500
			menuitem mnu_updateExposedInputs "Update Exposed Inputs"
		)
		
		separator sep_2 filter:canExposeControl
		
		menuItem mnu_disconnectAllInputs "Disconnect All Inputs"	
		menuItem mnu_disconnectAllOutputs "Disconnect All Outputs"	
		menuItem mnu_disconnectAllInputsSel "Disconnect All Inputs Of Selected Nodes"	filter:anythingSelected
		menuItem mnu_disconnectAllOutputsSel "Disconnect All Outputs Of Selected Nodes" filter:anythingSelected
		
		
		separator sep_100 filter:isBlackopOrSelection
		
		menuItem mnu_copyToClipboard "Copy Selected Nodes (Ctrl+C)" filter:anythingSelected
		menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" filter:canPaste
		
		separator sep_200 filter:canPasteOrSelected
		menuItem mnu_swapInputs "Swap First Two Inputs (Ctrl+W)" filter:isOperatorUnderMouse
		menuItem mnu_swapLastInputs "Swap Last Two Inputs (Shift+Ctrl+W)" filter:isOperatorUnderMouse
		separator sep_300 filter:isOperatorUnderMouse
		
		menuItem mnu_flipSocketPosition "Flip Socket Position" --filter:isInputUnderMouse
		
		separator sep_310 --filter:isInputUnderMouse
		
		menuItem mnu_toggleNode "Toggle Node On/Off"		
		menuItem mnu_toggleNodeSel "Toggle Selected Nodes On/Off (Ctrl+P)"		

		separator sep_400

		
		menuItem mnu_deleteNode "Delete Node Under Mouse Pointer"	
		menuItem mnu_deleteSelectedNodes "Delete Selected Nodes (Del.)" filter:anythingSelected
		
		on mnu_explodeBLOP picked do
		(
			KrakatoaChannelNodeEditor_CurrentModifier.internalFlow = KrakatoaChannelsEditor_Functions.expandFlow KrakatoaChannelNodeEditor_CurrentModifier.internalFlow specificNode:KrakatoaChannelNodeEditor_Rollout.lastNodeClick
			KrakatoaChannelNodeEditor_CurrentModifier.Flow = KrakatoaChannelsEditor_Functions.expandFlow KrakatoaChannelNodeEditor_CurrentModifier.internalFlow 
			KrakatoaChannelEditor_BaseNodeTreeData = execute KrakatoaChannelNodeEditor_CurrentModifier.internalFlow 
			KrakatoaChannelsEditor_Functions.buildDisplayTree()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Explode BlackOp"			
		)			
		
		on mnu_flipSocketPosition picked do
		(
			if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][14] == undefined do
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][14] = false
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][14] = not KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][14]
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Flip Socket Position"	
		)
		
		on mnu_editBLOP  picked do 
		(
			local q = true
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 and KrakatoaChannelEditor_NodeTreeEditingUndoLevel[KrakatoaChannelEditor_NodeTreeEditingUndoLevel.count] != KrakatoaChannelEditor_LastUndoRecordNumber then
			(
				q = querybox "Editing a nested BlackOp will cause the current BlackOp changes to be COMMITTED!\n\nClick [Yes] to commit changes and edit the nested BlackOp.\nClick [No] to remain at the current BlackOp editing level without committing any changes." title:"Edit Nested BlackOp Commit Changes"
				if q do KrakatoaChannelsEditor_Functions.commitChangesToBLOP()
			)	
			else
				KrakatoaChannelsEditor_Functions.updateParentModifier()
			
			if q do
			(
				currentlyEditedBlackOpName = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8]
				append KrakatoaChannelEditor_NodeTreeEditingLevel KrakatoaChannelNodeEditor_Rollout.lastNodeClick
				append KrakatoaChannelEditor_NodeTreeEditingUndoLevel (KrakatoaChannelEditor_LastUndoRecordNumber+1)
				append KrakatoaChannelEditor_NodeTreeEditingNames currentlyEditedBlackOpName
				KrakatoaChannelsEditor_Functions.updateEditorTitle()
				KrakatoaChannelsEditor_Functions.buildDisplayTree()
				KrakatoaChannelNodeEditor_Rollout.createDepot()
				KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
				if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
				if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
				KrakatoaChannelNodeEditor_Rollout.displaySelectedNodeProperties()
				KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Edit BlackOp"	
			)	
		)
		
		on mnu_UnExposeSelectedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.unexposeSelectedInputs()
		on mnu_ExposeSelectedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.exposeSelectedInputs()
		on mnu_updateExposedInputs picked do
			KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier			
		on mnu_selectExposedInputs picked do
			KrakatoaChannelNodeEditor_Rollout.selectExposedInputs()		
		
		on mnu_endEditingBLOP picked do
			KrakatoaChannelsEditor_Functions.endEditingBLOP()
		
		on mnu_saveBLOPDefinition picked do KrakatoaChannelNodeEditor_Rollout.saveBLOPDefinition()
		on mnu_addNewBLOPInline picked do
			KrakatoaChannelNodeEditor_Rollout.createBLOPInline creationType:#rcmenu 		
		
		on mnu_disconnectAllInputs picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllInputs Single:true
		
		on mnu_disconnectAllOutputs picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllOutputs Single:true

		on mnu_disconnectAllInputsSel picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllInputs Single:false
		
		on mnu_disconnectAllOutputsSel picked do
			KrakatoaChannelNodeEditor_Rollout.disconnectAllOutputs Single:false
		
		on mnu_copyToClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.copySelectionToClipboard()

		on mnu_pasteFromClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.pasteSelectionFromClipboard()		

		on mnu_parentSelectedNodes picked do
			KrakatoaChannelNodeEditor_Rollout.parentSelectedNodes()

		on mnu_unparentSelectedNodes picked do
			KrakatoaChannelNodeEditor_Rollout.unparentSelectedNodes()
		
		on mnu_swapInputs picked do KrakatoaChannelNodeEditor_Rollout.swapInputsOrder Single:true
		on mnu_swapLastInputs picked do KrakatoaChannelNodeEditor_Rollout.swapInputsOrder Single:true Last:true
			
		on mnu_toggleNode picked do
			KrakatoaChannelNodeEditor_Rollout.setPassThrough Single:true
		on mnu_toggleNodeSel picked do
			KrakatoaChannelNodeEditor_Rollout.setPassThrough Single:false
		
		on mnu_exposeControl picked do
		(
			if KrakatoaChannelNodeEditor_Rollout.lastNodeClick > 1 do
			(
				if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] == undefined do KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] = false
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] = not KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] 
				KrakatoaChannelsEditor_Functions.updateParentModifier()
				KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			)
		)
		
		
		on mnu_deleteNode picked do
		(
			if KrakatoaChannelNodeEditor_Rollout.lastNodeClick > 1 do
			(
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[i][2].count do
					(
						if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] == KrakatoaChannelNodeEditor_Rollout.lastNodeClick do
							KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] = 0
						if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > KrakatoaChannelNodeEditor_Rollout.lastNodeClick do
							KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] -= 1
					)	
				)
				deleteItem KrakatoaChannelEditor_DisplayNodeTreeData KrakatoaChannelNodeEditor_Rollout.lastNodeClick
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
				KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Delete Node"
				KrakatoaChannelNodeEditor_Rollout.displaySelectedNodeProperties()
			)	
		)
		
		on mnu_deleteSelectedNodes picked do
		(
			KrakatoaChannelNodeEditor_Rollout.deleteSelectedNodes()
		)			
	)
	
	rcmenu KrakatoaChannelNodeEditor_DepotMenu
	(
		fn categoriesOn = (DepotShowCategories)
		menuItem mnu_DepotOff "Depot Off" checked: (DepotPlacement == #off)
		menuItem mnu_DepotLeft "Depot On Left" checked: (DepotPlacement == #left)
		menuItem mnu_DepotBottom "Depot At Bottom" checked: (DepotPlacement == #bottom)
		menuItem mnu_DepotBottomRollup "Depot At Bottom - Rollup" checked: (DepotPlacement == #bottomrollup)
		menuItem mnu_DepotBottomRollupReverse "Depot At Bottom - Reverse Rollup" checked: (DepotPlacement == #bottomrollupreverse)
		separator sep_10
		
		menuItem mnu_DepotShowBLOPs "Show BlackOp Categories In Depot" checked:DepotShowBLOPs
		
		separator sep_20
		menuItem mnu_DepotShowCategories "Use Depot Categories" checked:DepotShowCategories
		menuItem mnu_DepotAutoCollapseOnDragAndDrop "Auto-Collapse Categories On DragAndDrop" checked:DepotAutoCollapseOnDragAndDrop
		separator sep_30 filter:categoriesOn
		menuItem mnu_expandAllCategories "Expand All Categories (Shift+Click Category)" filter:categoriesOn
		menuItem mnu_collapseAllCategories "Collapse All Categories (Ctrl+Shift+Click Category)" filter:categoriesOn
		
		on mnu_collapseAllCategories picked do
		(
			for i = 1 to theDepotNodesArray.count do theDepotNodesArray[i][1][6] = false
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)

		on mnu_expandAllCategories picked do
		(
			for i = 1 to theDepotNodesArray.count do theDepotNodesArray[i][1][6] = true
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false
		)		
		
		
		on mnu_DepotShowCategories picked do 
		(
			DepotShowCategories = not DepotShowCategories
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			if not DepotShowCategories and (DepotPlacement == #bottomrollup or DepotPlacement == #bottomrollupreverse) do 
			(
				DepotPlacement = #bottom
				setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			)	
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)		

		on mnu_DepotAutoCollapseOnDragAndDrop picked do 
		(
			DepotAutoCollapseOnDragAndDrop = not DepotAutoCollapseOnDragAndDrop
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotAutoCollapseOnDragAndDrop" (DepotAutoCollapseOnDragAndDrop as string)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)			
		
		on mnu_DepotShowBLOPs picked do 
		(
			DepotShowBLOPs = not DepotShowBLOPs
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowBLOPs" (DepotShowBLOPs as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)			
		
		on mnu_DepotOff picked do 
		(
			DepotPlacement = #off
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)	
		on mnu_DepotLeft picked do 
		(
			DepotPlacement = #left
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)	
		on mnu_DepotBottom picked do 
		(
			DepotPlacement = #bottom
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)			
		on mnu_DepotBottomRollup picked do
		(
			DepotPlacement = #bottomrollup
			DepotShowCategories = true
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)
		on mnu_DepotBottomRollupReverse picked do
		(
			DepotPlacement = #bottomrollupreverse
			DepotShowCategories = true
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)		
	)	
	
	rcmenu KrakatoaChannelNodeEditor_Rollout_MainMenu 
	(
		subMenu "File"
		(
			menuitem mnu_new "&New... (Ctrl+N)"
			separator sep_01
			menuitem mnu_open "&Open Flow... (Ctrl+O)"
			menuitem mnu_save "&Save Flow As... (Ctrl+S)"
			separator sep_02
			menuitem mnu_close "Close... (Ctrl+Q)"
		)
		subMenu "Edit"
		(
			menuitem mnu_undo "Undo (Ctrl+Z)" enabled:KrakatoaChannelNodeEditor_Rollout.btn_undo.enabled
			menuitem mnu_redo "Redo (Ctrl+Y)" enabled:KrakatoaChannelNodeEditor_Rollout.btn_redo.enabled
			separator sep_10
			menuItem mnu_copyToClipboard "Copy (Ctrl+C)" enabled:((KrakatoaChannelNodeEditor_Rollout.getSelectedNodes()).count > 0)
			menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" enabled:(KrakatoaChannelEditor_ClipboardArray.count > 0)
			separator sep_20
			menuitem mnu_selectAllNodes "Select All Nodes (Ctrl+A)" 
			menuitem mnu_invertSelection "Invert Selection (Ctrl+I)"
			menuitem mnu_deselectAllNodes "Deselect All Nodes (Ctrl+D)" 
			separator sep_30
			menuitem mnu_selectUnconnectedNodes "Select Unconnected Nodes (Ctrl+U)" 
			menuitem mnu_selectDisabledNodes "Select Disabled Nodes (Ctrl+Shift+U)" 
			menuitem mnu_selectInputNodesOnly "Select All Input Nodes" 
			menuitem mnu_selectOperatorNodesOnly "Select All Operator Nodes" 
			menuitem mnu_selectBlackOpNodesOnly "Select All BlackOp Nodes" 
			separator sep_40
			menuitem mnu_growSelectionChildren "Grow Selection - Add Children (Shift+PgDn)" 
			menuitem mnu_growSelectionParents "Grow Selection - Add Parents (Shift+PgUp)" 
			separator sep_50
			menuitem mnu_deleteSelectedNodes "Delete Selected Nodes (Del)"
		)
		
		subMenu "View"
		(
			menuitem mnu_autoReorderFlow "Reorder Flow Now (Ctrl+R)"
			menuitem mnu_autoReorderToggle "Auto-Reorder - Toggle" checked:AutoReorderToggle 
			subMenu "Reorder Patterns"
			(
				menuitem mnu_autoReorderRow "Row Pattern" checked:(AutoReorderPattern == #row)
				menuitem mnu_autoReorderAlignToTop "Top Aligned Row Pattern" checked:(AutoReorderPattern == #rowtopalign)
				menuitem mnu_AutoReorderWeighted "Weighted Row Pattern" checked:(AutoReorderPattern == #rowweighted)
				menuitem mnu_autoReorderTree "Tree Pattern" checked:(AutoReorderPattern == #tree)
			)	
			subMenu "Unconnected Nodes Auto-Placement"
			(
				menuItem mnu_nodesLeft "Left Side Of Flow" checked: (UnconnectedNodesPlacement == #left)
				menuItem mnu_nodesRight "Right Side Of Flow" checked: (UnconnectedNodesPlacement == #right)
				menuItem mnu_nodesBottom "Bottom Of Flow" checked: (UnconnectedNodesPlacement == #bottom)
			)			
			separator sep_105
			menuItem mnu_AlignAllNodesToGrid "Align All Nodes To Grid (Shift+Ctrl+A)" 
			menuItem mnu_SnapToGrid "Snap To Grid - Toggle (Ctrl+G)" checked:SnapToGrid

			separator sep_110
			menuitem mnu_AutoZoomExtents "Auto-Zoom Extents - Toggle" checked:AutoZoomExtents
			menuItem mnu_ZoomExtents "Zoom Extents (Z)"
			menuItem mnu_ZoomExtentsSelected "Zoom Extents Selected (Shift+Z)"			
			separator sep_120
			menuItem mnu_resetZoom "Reset Zoom (X)"
			menuitem mnu_resetPan "Reset Pan (Shift+X)"
			--separator sep_130
			
			--menuItem mnu_flagUnconnectedAsErrors "Flag Nodes With Unconnected Inputs As Errors" checked:flagUnconnectedAsErrors
			separator sep_140
			subMenu "Depot Display"
			(
				menuItem mnu_DepotOff "Depot Off" checked: (DepotPlacement == #off)
				menuItem mnu_DepotLeft "Depot On Left" checked: (DepotPlacement == #left)
				menuItem mnu_DepotBottom "Depot At Bottom" checked: (DepotPlacement == #bottom)
				menuItem mnu_DepotBottomRollup "Depot At Bottom - Rollup" checked: (DepotPlacement == #bottomrollup)
				menuItem mnu_DepotBottomRollupReverse "Depot At Bottom - Reverse Rollup" checked: (DepotPlacement == #bottomrollupreverse)
				separator sep_180
				menuItem mnu_DepotShowBLOPs "Show BlackOp Categories In Depot" checked:DepotShowBLOPs
				separator sep_185
				menuItem mnu_DepotShowCategories "Use Depot Categories" checked:DepotShowCategories
				menuItem mnu_DepotAutoCollapseOnDragAndDrop "Auto-Collapse Categories On DragAndDrop" checked:DepotAutoCollapseOnDragAndDrop
			)	
		)
		
		subMenu "Expose"
		(
			menuitem mnu_selectExposedInputs "Select Exposed Inputs"
			menuitem mnu_UnExposeSelectedInputs "Unexpose Selected Inputs"
			menuitem mnu_ExposeSelectedInputs "Expose Selected Inputs"
			separator sep_200
			menuitem mnu_updateExposedInputs "Update Exposed Inputs"
		)
		
		subMenu "Recorder"
		(
			menuItem mnu_convertUndoBufferToRecording "Save Undo Buffer As A Macro Recording..."
			separator sep_222
			menuItem mnu_LoadMacroRecording "Load Macro Recording..."
			/*
			menuItem mnu_StepForwardMacroRecording ">> Step Forward..."
			menuItem mnu_StepBackMacroRecording "<< Step Back..."
			menuItem mnu_PlayBackRecording "|> Play Recording..."
			menuItem mnu_StopPlayBackRecording "|| Stop Playback..."
			*/
		)
		
		on mnu_PlayBackRecording picked do KrakatoaChannelNodeEditor_Rollout.PlayBackRecording()
		on mnu_StopPlayBackRecording picked do KrakatoaChannelNodeEditor_Rollout.StopPlayBackRecording()
		
		on mnu_convertUndoBufferToRecording picked do
			KrakatoaChannelNodeEditor_Rollout.convertUndoBufferToRecording()
		
		on mnu_StepForwardMacroRecording picked do KrakatoaChannelNodeEditor_Rollout.StepForwardMacroRecording()
		on mnu_StepBackMacroRecording picked do KrakatoaChannelNodeEditor_Rollout.StepBackMacroRecording()
			
		
		on mnu_LoadMacroRecording picked do
		(
			KrakatoaChannelNodeEditor_Rollout.LoadMacroRecording()
		)
		
		on mnu_UnExposeSelectedInputs picked do
		(
			KrakatoaChannelNodeEditor_Rollout.unexposeSelectedInputs()
		)
		on mnu_ExposeSelectedInputs picked do
		(
			KrakatoaChannelNodeEditor_Rollout.exposeSelectedInputs()
		)
		
		on mnu_updateExposedInputs picked do
		(
			KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier			
		)	
		on mnu_selectExposedInputs picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectExposedInputs()
		)
		
		subMenu "Help"
		(
			menuitem mnu_openHelp "Krakatoa Channels Editor Online Documentation"
		)
		
		on mnu_growSelectionChildren picked do KrakatoaChannelNodeEditor_Rollout.selectChildrenNodesByParent()
		on mnu_growSelectionParents picked do KrakatoaChannelNodeEditor_Rollout.selectParentNodesByChild()
		
		
		/*on mnu_flagUnconnectedAsErrors picked do
		(
			flagUnconnectedAsErrors = not flagUnconnectedAsErrors
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "FlagUnconnectedAsErrors" (flagUnconnectedAsErrors as string)
			KrakatoaChannelNodeEditor_Rollout.flagUnconnectedOperatorsAsError()
		)*/
		
		on mnu_DepotShowCategories picked do 
		(
			DepotShowCategories = not DepotShowCategories
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			if not DepotShowCategories and (DepotPlacement == #bottomrollup or DepotPlacement == #bottomrollupreverse) do 
			(
				DepotPlacement = #bottom
				setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)	

		on mnu_DepotAutoCollapseOnDragAndDrop picked do 
		(
			DepotAutoCollapseOnDragAndDrop = not DepotAutoCollapseOnDragAndDrop
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotAutoCollapseOnDragAndDrop" (DepotAutoCollapseOnDragAndDrop as string)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)		

		on mnu_DepotShowBLOPs picked do 
		(
			DepotShowBLOPs = not DepotShowBLOPs
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowBLOPs" (DepotShowBLOPs as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)			

		on mnu_invertSelection picked do 
		(
			KrakatoaChannelNodeEditor_Rollout.invertSelection()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)
		
		on mnu_selectUnconnectedNodes picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectUnconnectedNodes()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false				
		)
		
		on mnu_selectOperatorNodesOnly picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectOperatorNodesOnly()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false				
		)

		on mnu_selectInputNodesOnly picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectInputNodesOnly()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false				
		)

		on mnu_selectBlackOpNodesOnly picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectBlackOpNodesOnly()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false				
		)		
		
		on mnu_selectDisabledNodes picked do
		(
			KrakatoaChannelNodeEditor_Rollout.selectDisabledNodes()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false					
		)
		
		
		
		on mnu_nodesLeft picked do
		(
			UnconnectedNodesPlacement = #left
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "UnconnectedNodesPlacement" (UnconnectedNodesPlacement  as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)
		on mnu_nodesRight picked do
		(
			UnconnectedNodesPlacement = #right
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "UnconnectedNodesPlacement" (UnconnectedNodesPlacement  as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)
		on mnu_nodesBottom picked do
		(
			UnconnectedNodesPlacement = #bottom
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "UnconnectedNodesPlacement" (UnconnectedNodesPlacement  as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)		

		on mnu_openHelp picked do 
			shellLaunch "http://www.franticfilms.com/software/support/krakatoa/particle_channels_editor.php" ""
			
		on mnu_DepotOff picked do 
		(
			DepotPlacement = #off
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)	
		on mnu_DepotLeft picked do 
		(
			DepotPlacement = #left
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)	
		on mnu_DepotBottom picked do 
		(
			DepotPlacement = #bottom
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)	
		on mnu_DepotBottomRollup picked do
		(
			DepotPlacement = #bottomrollup
			DepotShowCategories = true
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
		)
		on mnu_DepotBottomRollupReverse picked do
		(
			DepotPlacement = #bottomrollupreverse
			DepotShowCategories = true
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotPlacement" (DepotPlacement  as string)
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()			
		)		
		
		on mnu_copyToClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.copySelectionToClipboard()

		on mnu_pasteFromClipboard  picked do
			KrakatoaChannelNodeEditor_Rollout.pasteSelectionFromClipboard()			
		
		
		on mnu_autoReorderFlow picked do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
		on mnu_AutoZoomExtents picked do
		(
			AutoZoomExtents = not AutoZoomExtents  
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoZoomExtents" (AutoZoomExtents  as string)
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents()			
		)
		
		on mnu_SnapToGrid picked do
		(
			KrakatoaChannelNodeEditor_Rollout.toggleSnapToGrid()
		)	
		
		on mnu_selectAllNodes picked do KrakatoaChannelNodeEditor_Rollout.selectAllNodes()
		on mnu_deselectAllNodes picked do KrakatoaChannelNodeEditor_Rollout.deselectAllNodes()
		
		on mnu_autoReorderAlignToTop picked do
		(
			AutoReorderPattern = #rowtopalign
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoReorderToggle" (AutoReorderToggle as string)			
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)

		on mnu_AutoReorderToggle picked do
		(
			AutoReorderToggle = not AutoReorderToggle 
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoReorderToggle" (AutoReorderToggle as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)
		
		on mnu_autoReorderRow picked do 
		(
			AutoReorderPattern = #row
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoReorderPattern" (AutoReorderPattern as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
		)	
		on mnu_AutoReorderWeighted picked do 
		(
			AutoReorderPattern = #rowweighted
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoReorderPattern" (AutoReorderPattern as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false				
		)		
		on mnu_autoReorderTree picked do 
		(
			AutoReorderPattern = #tree		
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoReorderPattern" (AutoReorderPattern as string)
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)		
		
		on mnu_AlignAllNodesToGrid picked do KrakatoaChannelNodeEditor_Rollout.alignAllNodesToGrid()
		
		on mnu_undo  picked do KrakatoaChannelNodeEditor_Rollout.undoLastStep()

		on mnu_redo picked do KrakatoaChannelNodeEditor_Rollout.redoLastStep()
		
		on mnu_resetPan picked do KrakatoaChannelNodeEditor_Rollout.resetPanFactor()

		on mnu_resetZoom picked do KrakatoaChannelNodeEditor_Rollout.resetZoomFactor()
		
		on mnu_ZoomExtents picked do KrakatoaChannelNodeEditor_Rollout.ZoomExtents()
		
		on mnu_ZoomExtentsSelected picked do KrakatoaChannelNodeEditor_Rollout.ZoomExtentsSelected()
		
		on mnu_new picked do KrakatoaChannelNodeEditor_Rollout.newFlow()
		
		on mnu_save picked do KrakatoaChannelNodeEditor_Rollout.saveFlowAs()
		
		on mnu_open picked do KrakatoaChannelNodeEditor_Rollout.openFlow()
		
		on mnu_deleteSelectedNodes picked do KrakatoaChannelNodeEditor_Rollout.deleteSelectedNodes()
		
		on mnu_close picked do
		(
			destroyDialog KrakatoaChannelNodeEditor_Rollout
		)
	)
	
	rollout KrakatoaChannelNodeEditor_OptionsRollout "Display Options" category:1000
	(
		button btn_savePreset "Save Preset..." across:2 width:80 offset:[-5,0]
		button btn_loadPreset "Load Preset..." width:80 offset:[5,0]
		
		group "Background and Grid"
		(
			spinner spn_gridSizeX "Grid Width:" range:[5,100,10] type:#integer
			spinner spn_gridSizeY "Grid Height:" range:[5,100,10] type:#integer
			
			colorpicker clr_backgroundColor "Background:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetBackgroundColor "Reset" width:35 align:#right offset:[6,0]
			colorpicker clr_GridColor "Grid:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetGridColor "Reset" width:35 align:#right offset:[6,0]
		)
		
		group "Depot"
		(
			dropdownlist ddl_depotPlacement items:#("Disabled","Left","Bottom","Bottom - Rollup","Bottom - Reverse Rollup") width:150 align:#center selection:(findItem #(#off,#left,#bottom,#bottomrollup,#bottomrollupreverse) DepotPlacement)
			spinner spn_DepotNodeWidth "Item Width:" type:#integer range:[20,200,DepotNodeWidth]
			colorpicker clr_CategoryOnColor "Category:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetCategoryOnColor "Reset" width:35 align:#right offset:[6,0]			
			checkbox chk_DepotShowCategories "Show Depot Categories" checked:DepotShowCategories
		)
		
		group "Nodes"
		(
			checkbox chk_useMousePositionOnCreation "Shortcut To Mouse Pos."
			dropdownlist ddl_NodeWidth items:#("Node Width 80","Node Width 100","Node Width 120","Node Width 140 (default)","Node Width 160","Node Width 180","Node Width 200","Node Width 220","Node Width 240","Node Width 260","Node Width 280","Node Width 300") width:150 align:#center
			dropdownlist ddl_NodeXSpace items:#("Horiz.Spacing 0","Horiz.Spacing 10","Horiz.Spacing 20","Horiz.Spacing 30 (default)","Horiz.Spacing 40","Horiz.Spacing 50","Horiz.Spacing 60","Horiz.Spacing 70","Horiz.Spacing 80","Horiz.Spacing 90","Horiz.Spacing 100") width:150 align:#center
			checkbox chk_operatorHeightConstant "Fixed Operator Height"
			
			colorpicker clr_InputColor "Input:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetInputColor "Reset" width:35 align:#right offset:[6,0]

			colorpicker clr_OperatorColor "Operator:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetOperatorColor "Reset" width:35 align:#right offset:[6,0]
			
			colorpicker clr_BoxColor "BlackOp:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetBoxColor "Reset" width:35 align:#right offset:[6,0]

			colorpicker clr_OutputColor "Output:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetOutputColor "Reset" width:35 align:#right offset:[6,0]
			
			checkbox chk_castShadows "Cast Shadows"
		)
		


		group "Sockets and Connections"
		(
			colorpicker clr_InputSocketColor "Free Input:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetInputSocketColor "Reset" width:35 align:#right offset:[6,0]
			
			colorpicker clr_ChannelSocketColor "Channel:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetChannelColor "Reset" width:35 align:#right offset:[6,0]

			colorpicker clr_IntegerSocketColor "Integer:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetIntegerColor "Reset" width:35 align:#right offset:[6,0]
			
			colorpicker clr_FloatSocketColor "Float:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetFloatColor "Reset" width:35 align:#right offset:[6,0]

			colorpicker clr_VectorSocketColor "Vector:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetVectorColor "Reset" width:35 align:#right offset:[6,0]

			colorpicker clr_TimeSocketColor "Time:" align:#right across:2 fieldwidth:40 align:#right offset:[38,0] modal:false
			button btn_resetTimeColor "Reset" width:35 align:#right offset:[6,0]
		)


		
		
		fn updateBackground fileName:"" =
		(
			if FileName == "" do FileName = GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini"
			setIniSetting FileName "ParticleChannelEditor" "BackgroundColor"  (theBackgroundColor as string)
			setIniSetting FileName "ParticleChannelEditor" "GridColor"  (theGridColor as string)
			setIniSetting FileName "ParticleChannelEditor" "GridSizeX"  (GridSizeX as string)
			setIniSetting FileName "ParticleChannelEditor" "GridSizeX"  (GridSizeX as string)
			
			KrakatoaChannelNodeEditor_Rollout.showGrid SnapToGrid
			KrakatoaChannelNodeEditor_Rollout.hc.redrawView
		)
		
		fn updateNodeColors fileName:""=
		(
			if FileName == "" do FileName = GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini"
			setIniSetting FileName "ParticleChannelEditor" "InputNodeColor"  (theInputNodeColor as string)
			setIniSetting FileName "ParticleChannelEditor" "OutputNodeColor"  (theOutputNodeColor as string)
			setIniSetting FileName "ParticleChannelEditor" "OperatorNodeColor"  (theOperatorNodeColor as string)
			setIniSetting FileName "ParticleChannelEditor" "BoxNodeColor"  (theBoxNodeColor as string)
			setIniSetting FileName "ParticleChannelEditor" "NodesCastShadows" (theNodesCastShadows as string)
			setIniSetting FileName "ParticleChannelEditor" "NodeWidth" (NodeWidth as string)
			setIniSetting FileName "ParticleChannelEditor" "NodeXSpace" (NodeXSpace as string)
			setIniSetting FileName "ParticleChannelEditor" "OperatorHeightConstant" (operatorHeightConstant as string)
			setIniSetting FileName "ParticleChannelEditor" "UseMousePositionOnCreation" (useMousePositionOnCreation as string)
			setIniSetting FileName "ParticleChannelEditor" "DepotHeaderColor" (theHeaderColor as string)
			KrakatoaChannelNodeEditor_Rollout.createDepot()
			KrakatoaChannelNodeEditor_Rollout.updateDepotDefinition()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
		)
		
		fn updateSocketColors filename:"" =
		(
			if FileName == "" do FileName = GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini"
			setIniSetting FileName "ParticleChannelEditor" "InputSocketColor"  (theInputSocketColor as string)
			setIniSetting FileName "ParticleChannelEditor" "ChannelSocketColor"  (theChannelSocketColor as string)
			setIniSetting FileName "ParticleChannelEditor" "FloatSocketColor"  (theFloatSocketColor as string)				
			setIniSetting FileName "ParticleChannelEditor" "VectorSocketColor"  (theVectorSocketColor as string)				
			setIniSetting FileName "ParticleChannelEditor" "IntegerSocketColor"  (theIntegerSocketColor as string)				
			setIniSetting FileName "ParticleChannelEditor" "TimeSocketColor"  (theTimeSocketColor as string)				
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true	
		)
		

		
		fn updateGUI = 
		(
			clr_CategoryOnColor.color = theHeaderColor
			clr_GridColor.color = theGridColor
			clr_backgroundColor.color = theBackgroundColor
			spn_GridSizeX.value = gridSizeX 
			spn_GridSizeY.value = gridSizeY
			clr_InputColor.color = theInputNodeColor  
			clr_OutputColor.color = theOutputNodeColor 
			clr_OperatorColor.color = theOperatorNodeColor 		
			clr_BoxColor.color = theBoxNodeColor
			
			clr_InputSocketColor.color = theInputSocketColor
			clr_ChannelSocketColor.color = theChannelSocketColor
			clr_FloatSocketColor.color = theFloatSocketColor
			clr_VectorSocketColor.color = theVectorSocketColor
			clr_IntegerSocketColor.color = theIntegerSocketColor
			clr_TimeSocketColor.color = theTimeSocketColor
			
			chk_castShadows.state = theNodesCastShadows
			chk_useMousePositionOnCreation.state = useMousePositionOnCreation
			
			ddl_NodeWidth.selection = findItem #(80,100,120,140,160,180,200,220,240,260,280,300) NodeWidth
			ddl_NodeXSpace.selection = findItem #(0,10,20,30,40,50,60,70,80,90,100) NodeXSpace
			chk_operatorHeightConstant.state = OperatorHeightConstant
		)			
		

		
		on chk_DepotShowCategories changed state do
		(
			DepotShowCategories = not DepotShowCategories
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "DepotShowCategories" (DepotShowCategories as string)
			--KrakatoaChannelNodeEditor_Rollout.updateDepotDefinition()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
		)

		on ddl_NodeWidth selected itm do
		(
			NodeWidth = #(80,100,120,140,160,180,200,220,240,260,280,300)[itm]
			KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			updateNodeColors() 
			--KrakatoaChannelNodeEditor_Rollout.alignAllNodesToGrid()
		)
		

	
		
		on ddl_NodeXSpace selected itm do
		(
			NodeXSpace = #(0,10,20,30,40,50,60,70,80,90,100)[itm]
			KrakatoaChannelNodeEditor_Rollout.autoReorderFlow()
			updateNodeColors()
		)
		
		on chk_useMousePositionOnCreation changed state do
		(
			useMousePositionOnCreation = state
			updateNodeColors()
		)		
		
		on chk_operatorHeightConstant changed state do 
		(
			operatorHeightConstant = state
			updateNodeColors()
		)
		
		on btn_savePreset pressed do
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\") all:true
			local theFileName = getSaveFileName caption:"Save Krakatoa Channels Editor Display Settings To..." filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\Settings.kcs") types:"Krakatoa Channels Editor Settings (*.kcs)|*.kcs"
			if theFileName != undefined do
			(
				updateBackground fileName:theFileName
				updateNodeColors fileName:theFileName
				updateSocketColors fileName:theFileName
			)
		)
		on btn_loadPreset pressed do
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\") all:true
			local theFileName = getOpenFileName caption:"Load Krakatoa Channels Editor Display Settings From..." filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\Settings.kcs") types:"Krakatoa Channels Editor Settings (*.kcs)|*.kcs"
			if theFileName != undefined do
			(
				loadDisplaySettings fileName:theFileName
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
				KrakatoaChannelNodeEditor_Rollout.showGrid SnapToGrid
				updateGUI()
				updateBackground()
				updateNodeColors()
				updateSocketColors()
			)
		)
		


		on btn_resetInputSocketColor pressed do 
		(
			theInputSocketColor = clr_InputSocketColor.color = color 255 0 0
			updateSocketColors()		
		)
		
		on btn_resetChannelColor pressed do 
		(
			theChannelSocketColor = clr_ChannelSocketColor.color = color 0 0 200
			updateSocketColors()	
		)
		on btn_resetFloatColor pressed do 
		(
			theFloatSocketColor = clr_FloatSocketColor.color = color 0 128 0
			updateSocketColors()	
		)
		on btn_resetVectorColor pressed do 
		(
			theVectorSocketColor = clr_VectorSocketColor.color = color 0 255 200
			updateSocketColors()	
		)
		on btn_resetIntegerColor pressed do 
		(
			theIntegerSocketColor = clr_IntegerSocketColor.color = color 128 0 255
			updateSocketColors()	
		)
		on btn_resetTimeColor pressed do 
		(
			theTimeSocketColor = clr_TimeSocketColor.color = color 255 255 0	
			updateSocketColors()	
		)
		
		on clr_InputSocketColor changed val do 
		(
			theInputSocketColor = val 
			updateSocketColors()
		)	
		on clr_ChannelSocketColor changed val do 
		(
			theChannelSocketColor = val
			updateSocketColors()
		)	
		on clr_FloatSocketColor changed val do 
		(
			theFloatSocketColor = val
			updateSocketColors()
		)
		on clr_VectorSocketColor changed val do 
		(
			theVectorSocketColor = val
			updateSocketColors()
		)
		on clr_IntegerSocketColor changed val do 
		(
			theIntegerSocketColor = val
			updateSocketColors()
		)
		on clr_TimeSocketColor changed val do 
		(
			theTimeSocketColor = val
			updateSocketColors()
		)
		
		on clr_InputColor changed val do
		(
			theInputNodeColor = val
			updateNodeColors()
		)
		
		on btn_resetInputColor pressed do
		(
			clr_InputColor.color = theInputNodeColor = color 220 220 255
			updateNodeColors()			
		)
		

		
		on clr_OutputColor changed val do
		(
			theOutputNodeColor = val
			updateNodeColors()
		)
		
		on btn_resetOutputColor pressed do
		(
			clr_OutputColor.color = theOutputNodeColor = color 200 255 200
			updateNodeColors()			
		)		
		
		on clr_OperatorColor changed val do
		(
			theOperatorNodeColor = val
			updateNodeColors()
		)
		
		on btn_resetOperatorColor pressed do
		(
			clr_OperatorColor.color = theOperatorNodeColor = color 255 235 200
			updateNodeColors()			
		)				
		
		on clr_BoxColor changed val do
		(
			theBoxNodeColor = val
			updateNodeColors()
		)
		on btn_resetBoxColor pressed do
		(
			clr_BoxColor.color = theBoxNodeColor = color 255 200 180
			updateNodeColors()			
		)			
		
		on clr_backgroundColor changed val do
		(
			theBackgroundColor = val
			updateBackground()
		)
		
		on btn_resetBackgroundColor pressed do
		(
			clr_backgroundColor.color = theBackgroundColor = color 192 192 198
			updateBackground()
			updateBackgroundColor 
		)
		
		on clr_GridColor changed val do
		(
			theGridColor = val
			updateBackground()
		)
		
		on btn_resetGridColor pressed do
		(
			clr_GridColor.color = theGridColor = color 200 200 210
			updateBackground()
			updateBackgroundColor 
		)		
		
		on spn_gridSizeX changed val do
		(
			gridSizeX = val
			updateBackground()			
		)
		on spn_gridSizeY changed val do
		(
			gridSizeY = val
			updateBackground()			
		)		
		
		on chk_castShadows changed val do 
		(
			KrakatoaChannelNodeEditor_Rollout.hc.drawShadows = theNodesCastShadows = val
			updateNodeColors()
		)		
		
		on clr_CategoryOnColor changed val do
		(
			theHeaderColor  = val
			updateNodeColors()
			KrakatoaChannelNodeEditor_Rollout.drawDepot init:false	
		)			
		
		on btn_resetCategoryOnColor pressed do
		(
			clr_CategoryOnColor.color = theHeaderColor = color 80 80 120
			updateNodeColors()		
			KrakatoaChannelNodeEditor_Rollout.drawDepot init:false	
		)		
		
		on spn_DepotNodeWidth changed val do
		(
			local FileName = GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini"
			DepotNodeWidth = val
			KrakatoaChannelNodeEditor_Rollout.drawDepot init:false			
			setIniSetting FileName "ParticleChannelEditor" "DepotNodeWidth"  (DepotNodeWidth as string)	
		)		
		
		on ddl_depotPlacement selected itm do
		(
			local FileName = GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini"
			DepotPlacement = case itm of
			(
				default: #off
				2: #left
				3: #bottom
				4: #bottomrollup
				5: #bottomrollupreverse
			)
			setIniSetting FileName "ParticleChannelEditor" "DepotPlacement"  (DepotPlacement as string)	
			KrakatoaChannelNodeEditor_Rollout.CreateDepot()
			--KrakatoaChannelNodeEditor_Rollout.updateDepotDefinition()
			KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()
			--KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
		)		
		

		on KrakatoaChannelNodeEditor_OptionsRollout open do
		(
			loadDisplaySettings()
			updateGUI()
		)
	)
	
	rollout KrakatoaChannelNodeEditor_OperatorDescriptionRollout "Operator Description" category:200
	(
		
		group "Operator Description:"
		(
			label lbl_description01 "" align:#left offset:[-5,0]
			label lbl_description02 "" align:#left offset:[-5,-3]
			label lbl_description03 "" align:#left offset:[-5,-3]
			label lbl_description04 "" align:#left offset:[-5,-3]
			label lbl_description05 "" align:#left offset:[-5,-3]
			label lbl_description06 "" align:#left offset:[-5,-3]
			label lbl_description07 "" align:#left offset:[-5,-3]
			label lbl_description08 "" align:#left offset:[-5,-3]
			label lbl_description09 "" align:#left offset:[-5,-3]
			label lbl_description10 "" align:#left offset:[-5,-3]
			label lbl_description11 "" align:#left offset:[-5,-3]
			label lbl_description12 "" align:#left offset:[-5,-3]
		)
		
		fn updateDescription =
		(
			local theLabels = #(lbl_description01,lbl_description02,lbl_description03,lbl_description04,lbl_description05,lbl_description06,lbl_description07,lbl_description08,lbl_description09,lbl_description10,lbl_description11,lbl_description12)
			local theText = case KrakatoaChannelNodeEditor_OperatorRollout.ddl_type.selected of
			(
				--Arithmetics
				"Add": "Adds componentwise the #two Inputs together:# #1+2=3#[1,2,3]+[4,5,6]=[5,7,9]#[1,2,3]+4=NOT SUPPORTED"
				"Subtract": "Subtracts componentwise#the second Input from the first.#Both Inputs must have matching Arity.# #3--2=1#[6,5,4]--[1,2,3]=[5,3,1]#[6,5,4]--3=NOT SUPPORTED#8-[1,2,3]=NOT SUPPORTED"
				"Multiply": "Multiplies componentwise#the two Inputs:# #2*3=6#[1,2,3]*[4,5,6]=[4,10,18]#[1,2,3]*4=[1,2,3]*[4,4,4]=[4,8,12]"
				"Divide": "Divides componentwise the#first Input by the second Input:# #6*3=2#[4,10,18]/[4,5,6]=[1,2,3]#[4,8,12]/4=[1,2,3]#8/[8,4,2]->NOT SUPPORTED"
				"Power": "Calculates componentwise the#first Input to the Power of#the second Input:# #2^3=8#[2,3,4]^[1,2,3]=[2,9,64]#[2,3,4]^2=[4,9,16]#2^[1,2,3]->NOT SUPPORTED"
				"Modulo": "Calculates the remainder of#the division of Input1 by Input2."
				
				"Blend": "Blends componentwise#the first and second inputs#using the third input as#the Blend Factor (0.0-1.0):# #B=0.4#2,3->B*2+(1.0-B)*3=0.8+1.8=2.6#[1,2,3],[4,5,6]->[2.8,3.8,4.8]#[1,2,3],4->[2.8,3.2,3.6]"
				"Clamp": "Clamps the components of#the First Input between#the second and the third Inputs:# #I2=2; I3=6:#I1=1->2; I1=5->5; I1=9->6#I1=[1,5,9]->[2,5,6]# #I2=[1,2,3]; I3=[3,4,5]:#I1=[4,3,2]->[3,3,3]#I1=1->NOT SUPPORTED"
				"Negate": "Changes the Sign of the Input:# #1 --> -1#[1,2,-3] --> [-1,-2,3]"
				"AbsoluteValue": "Outputs the Absolute Value of Input 1# #-12.3->12.3#[-1,2,-3]->[1,2,3]"
				
				--Vectors
				"Magnitude": "Calculates the Length of Input 1.#If a Scalar, outputs the Scalar.# #[0,0,1]->1#10.1->10.1"
				"Normalize": "Returns the Unit Vector with#the same direction as Input1#but length of 1.0# #[0,10,0]->[0,1,0]"
				"ComponentSum": "Adds the 3 Components of#the Input1 Vector together and#outputs them as a Float.# #[10.1,21.5,32.8]->64.4"
				"DotProduct": "Calculates the Dot Product of.#two Vector Inputs.#Equivalent to the projection of#the one vector onto the other#or the Cosine of their angle"
				"CrossProduct": "Calculates the Cross Product of#two Vector Inputs.#Result is a new vector#perpendicular to the two#with length equal to#the area of the parallelogram#defined by the two vectors."
				
				--Trigonometry
				"Sin": "Calculates the Sine of#the Angle provided by#the Input 1 Scalar# #0->0#90->1#180->0#270->-1"
				"Cos": "Calculates the Cosine of#the Angle provided by#the Input 1 Scalar# #0->1#90->0#180->-1#270->0"
				"Tan": "Calculates the Tangent of the#Angle provided by#the Input 1 Scalar# #0->0#45->1.0#60->1.73205#120->-1.73205"
				"ASin": "Calculates the Inverse of the#Sine provided by#the Input 1 Scalar#and returns the Angle as Float# #0->0#0.5->30.0#0.707107->45.0#1->90.0"
				"ACos": "Calculates the Inverse of the#Cosine provided by#the Input 1 Scalar#and returns the Angle as Float# #0->90#0.5->60.0#0.707107->45.0#1->0.0"
				"ATan": "Calculates the Inverse of the#Tangent provided by#the Input 1 Scalar#and returns the Angle as Float# #0->0#1->45.0#1.73205->60.0"
				
				--Conversion
				"ToVector": "Takes 3 Scalar Inputs and#combines them to a Vector:# #I1=1; I2=3; I3=8->[1,3,8]"
				"ToScalar": "Takes Vector Input 1 and#outputs component specified#by Scalar Input 2 where#1=X, 2=Y, 3=Z#If I2>Arity returns 0# #I1=[10,20,30]; I2=3->30"
				"ToFloat": "Takes Integer Input 1 and#outputs a Float# #10->10.0"
				"ToInteger": "Takes Float Input 1 and#outputs an Integer by cropping# the decimal porition.# #1.234->1"
				
				--Transformations
				"ToWorld": "Transforms A Point, Vector#or Normal out of Local Space#into World Space by multiplying#with the Transformation Matrix#of the Host Object"
				"FromWorld": "Transforms A Point, Vector#or Normal out of World Space#into Local Space by multiplying#with the Inverse Transformation#Matrix of the Host Object"
				"ToSpace": "Transforms A Point, Vector#or Normal into the Space#of a selected Scene Object."
				"FromSpace": "Transforms A Point, Vector#or Normal out of the Space#of a selected Scene Object."

				--Logic and Comparison
				"LogicalAnd": "Returns 1.0 (TRUE) if both#Float Inputs are non-zero(TRUE)#or 0.0(FALSE) if either#Input is equal to 0.0(FALSE)"
				"LogicalOr": "Returns 1.0 (TRUE) if at least#one of the two Float Inputs#is non-zero(TRUE)#or 0.0(FALSE) if both#Inputs are equal to 0.0(FALSE)"
				"LogicalNot": "Returns 1.0 (TRUE) if the#Float Input is 0.0(FALSE)#and 0.0(FALSE) if the#Float Input is a non-zero value"
				"Less": "Returns 1.0 (TRUE) if the#Float Input1 is less than#the Float Input2, 0.0(FALSE)#otherwise."
				"LessOrEqual": "Returns 1.0 (TRUE) if the#Float Input1 is less or equal#to the Float Input2, 0.0(FALSE)#otherwise."
				"Greater": "Returns 1.0 (TRUE) if the#Float Input1 is greater than#the Float Input2, 0.0(FALSE)#otherwise."
				"GreaterOrEqual": "Returns 1.0 (TRUE) if the#Float Input1 is greater or equal#to the Float Input2, 0.0(FALSE)#otherwise."
				"Equal": "Returns 1.0 (TRUE) if the#Float Input1 is equal to#the Float Input2, 0.0(FALSE)#otherwise."
				"Switch": "Outputs Input1 if the Input3#control value is non-zero(TRUE).#Outputs Input2 if Input3 is#equal to 0.0(FALSE)."
				default: "Info Not Available"
			)
			theFS = filterString theText "#"
			for i in theLabels do i.text = ""
			for i = 1 to theFS.count do
			(
				theLabels[i].text = theFS[i]
			)
		)		
		
		on KrakatoaChannelNodeEditor_OperatorDescriptionRollout open do
		(
			updateDescription()
		)		
		
		on KrakatoaChannelNodeEditor_OperatorDescriptionRollout rolledup state do
		(
			if not KrakatoaChannelsEditor_isInitializing do
			(
				setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "OperatorDescriptionRolloutRolledup" (state as string)
			)
		)			
	)
	
	rollout KrakatoaChannelNodeEditor_NodeNameRollout "Node Name" category:50
	(
		edittext edt_nodeName width:160 offset:[-4,0] align:#center
		on edt_nodeName entered txt do 
		(
			--print "edt_nodeName"
			txt = KrakatoaChannelsEditor_Functions.purifyText txt
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = txt
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Change Node Name To [" +txt +"]")
			if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][12] == true do
				KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier	
			edt_nodeName.text = txt
		)			
		
		on KrakatoaChannelNodeEditor_NodeNameRollout open do
		(
			edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8]
		)		
		
		on KrakatoaChannelNodeEditor_NodeNameRollout rolledup state do
		(
			if not KrakatoaChannelsEditor_isInitializing do
			(
				setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "NodeNameRolloutRolledup" (state as string)
			)
		)
	)		

	rollout KrakatoaChannelNodeEditor_InputRollout "Input" category:100
	(
		--group "Node Name:"		(
		--label lbl_nodeName "Node Name:" align:#left offset:[-8,0]
		--	edittext edt_nodeName width:150 offset:[-3,0] align:#center
		--)
		group "Input Node Settings:"
		(
			dropdownlist ddl_InputType "Input Type:" height:10 items:#("Channel","Value","TextureMap","Script") width:150 align:#center --"Time",
			dropdownlist ddl_ValueType "Value Type:               " height:25 items:#() width:150 align:#center
			label lbl_channelInfo "" offset:[-3,-4] align:#center
			edittext edt_ChannelName fieldwidth:149 offset:[-3,-4] align:#center
			
			spinner spn_valueInt "Integer:" range:[-1000000,1000000,0] visible:false offset:[0,-21] type:#integer controller:KrakatoaChannelEditor_CurrentIntController
			spinner spn_value "Float:" range:[-1000000,1000000,0] visible:false offset:[0,-21] controller:KrakatoaChannelEditor_CurrentFloatController scale:0.01
			button btn_getTextureMap "Get Texture Map..." width:150 align:#center visible:false offset:[0,-21]
			button btn_putMaterialToEditor "Put To Active MEditor Slot" width:150 align:#center visible:false offset:[0,-3]
			button btn_removeTextureMap "Remove Texture Map" width:150 align:#center visible:false offset:[0,-3]
			
			spinner spn_x "X:" range:[-1000000,1000000,0] offset:[0,-70] visible:false controller:KrakatoaChannelEditor_CurrentVectorController[1].controller scale:0.01
			spinner spn_y "Y:" range:[-1000000,1000000,0] visible:false controller:KrakatoaChannelEditor_CurrentVectorController[2].controller scale:0.01
			spinner spn_z "Z:" range:[-1000000,1000000,0] visible:false controller:KrakatoaChannelEditor_CurrentVectorController[3].controller scale:0.01
			colorpicker clr_color "As Color:" align:#right fieldwidth:72 height:15 color:white offset:[0,0] visible:true alpha:true modal:false
			button btn_connectToSceneTrack "Connect To Scene Track" width:150 align:#center
			button btn_disconnectFromTrack "Disconnect From Scene Track" width:150 align:#center
			button btn_zoomTrackView "Zoom In Track View" width:150 align:#center

			label lbl_scriptCode "Expression:" align:#left offset:[0,-190]
			edittext edt_scriptCode width:154 height:150 offset:[-3,0] align:#center 
			checkbox chk_scriptCodeAutoCheck "Auto-Check For Errors" align:#left checked:scriptCodeAutoCheck
		)
		
		fn point3_filter_function val = 
		(
			local result = true
			try(if classof val.anim.value != Point3 do result = false)catch(result = false)
			--try(if matchPattern val.name pattern:"Vector" do result = false)catch(result = false)
			result
		)
		
		fn float_filter_function val = 
		(
			local result = true
			try(if classof val.anim.value != Float AND classof val.anim.value != Integer do result = false)catch(result = false)
			--try(if matchPattern val.name pattern:"Float" or matchPattern val.name pattern:"Integer" do result = false)catch(result = false)
			result
		)		
		

		
		fn getConnectedNode =
		(
			local theController = case ddl_ValueType.selected of
			(
				"Integer": try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]+"[1].controller"))catch(undefined)
				"Float": try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]+"[2].controller"))catch(undefined)
				"Vector": try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]+"[3].controller[1].controller"))catch(undefined)
			)	
			if classof theController == Float_Script then
			(
				local theTarget = theController.GetTarget "KCE_Reference" asObject:false
				local theNodes = (for o in (refs.dependents theTarget ) where classof (superclassof o) == node and isProperty o "Name" collect o)
				if theNodes.count > 0 then
				(
					theNodes[1].name + "." + (filterString (theTarget as string) ":")[2]
				)
				else
				(
					"Connect To Scene Track"
				)
			)	
			else 
				"Connect To Scene Track"
		)
		
		
		fn createControllers =
		(
			if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4] == undefined do 
			(
				local theNodeID = ((random 10000 1000000) as string + "_" + (random 10000 1000000) as string)
				KrakatoaChannelsEditor_Functions.createTrackViewControllers theNodeID KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick]
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4] = theNodeID
			)
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = "trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]
			KrakatoaChannelNodeEditor_Rollout.displaySelectedNodeProperties()
		)
		
		fn storeValues =
		(
			try
			(
				if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][5] == undefined do 
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][5] = #()
				case ddl_ValueType.selected of
				(
					"Integer": KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][5][1] = spn_valueInt.value
					"Float": KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][5][2] = spn_value.value
					"Vector": KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][5][3] = [spn_X.value,spn_y.value,spn_z.value]
				)
			)catch()	
		)
		
	
		
		fn updateControls =
		(
			if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] == undefined do KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = "Untitled"
			KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8]
			case ddl_InputType.selected of
			(
				"Channel": 
				(
					ddl_ValueType.caption = "Channel Name:"
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] != undefined do 
						deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3
					
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] == undefined do KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] = "Color"
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9]
					
					lbl_channelInfo.visible = edt_ChannelName.visible = ddl_ValueType.visible = true
					chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = btn_zoomTrackView.visible = spn_valueInt.visible = spn_value.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
					ddl_ValueType.items =  join #("[Custom Channel]") (for i in channelsList collect i[1])
					edt_ChannelName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
					local theIndex = findItem ddl_ValueType.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
					if theIndex == 0 do theIndex = 1
					ddl_ValueType.selection = theIndex
					lbl_channelInfo.text = if theIndex > 1 then channelsList[theIndex-1][4] else "  "
				)
				"Value": 
				(
					ddl_ValueType.caption = "Value Type:"
					ddl_ValueType.items = #("Vector","Float","Integer")
					ddl_ValueType.selection = findItem ddl_ValueType.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4] == undefined do 
					(
						local theNodeID = ((random 10000 1000000) as string + "_" + (random 10000 1000000) as string)
						KrakatoaChannelsEditor_Functions.createTrackViewControllers theNodeID KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick]
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4] = theNodeID
					)
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = "trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]
					if ddl_ValueType.selection ==0 do 
					(
						ddl_ValueType.selection = 1
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = ddl_ValueType.selected
					)	
					case ddl_ValueType.selected of
					(
						"Integer" : (
							btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_zoomTrackView.visible = spn_valueInt.visible = ddl_ValueType.visible = true
							lbl_channelInfo.visible = chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = spn_value.visible = edt_ChannelName.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
							)						
						"Float": (
							btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_zoomTrackView.visible = ddl_ValueType.visible = spn_value.visible = true
							lbl_channelInfo.visible = chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = spn_valueInt.visible = edt_ChannelName.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
							)
						"Vector": (
							btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_zoomTrackView.visible = ddl_ValueType.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = true
							lbl_channelInfo.visible = chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = spn_valueInt.visible = edt_ChannelName.visible = spn_value.visible  = false
							clr_color.color = [spn_x.value, spn_y.value , spn_z.value , 1]
						)
					)	
					btn_connectToSceneTrack.tooltip = btn_connectToSceneTrack.text = getConnectedNode()
					
				)
				"TextureMap":
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] != undefined do 
						deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3					
					ddl_ValueType.caption = "Texture Maps:"
					btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = ddl_ValueType.visible = true
					lbl_channelInfo.visible = chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_zoomTrackView.visible = spn_valueInt.visible = spn_value.visible = edt_ChannelName.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
					ddl_ValueType.items = join #("Object's Diffuse Map") (for i in KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources collect i as string)
					if classof KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] != Integer do 
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = 1
					ddl_ValueType.selection = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
				)
				"Time": 
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] != undefined do 
						deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3					
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = "Frame"
					lbl_channelInfo.visible = chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = btn_zoomTrackView.visible = edt_ChannelName.visible = spn_valueInt.visible = ddl_ValueType.visible = spn_value.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
				)
				"Script": 
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] != undefined do 
						deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3					
					if KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][6] == undefined do KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][6] = "0"
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][6]
					edt_scriptCode.text =  KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] 
					chk_scriptCodeAutoCheck.visible = lbl_scriptCode.visible = edt_scriptCode.visible = true
					lbl_channelInfo.visible = btn_connectToSceneTrack.visible = btn_disconnectFromTrack.visible = btn_removeTextureMap.visible = btn_putMaterialToEditor.visible = btn_getTextureMap.visible = btn_zoomTrackView.visible = edt_ChannelName.visible = spn_valueInt.visible = ddl_ValueType.visible = spn_value.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = false
				)
			)			
		)
		
		on chk_scriptCodeAutoCheck changed state do 
		(
			scriptCodeAutoCheck = state
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
		)
		
		on btn_disconnectFromTrack pressed do
		(
			local q = querybox "Are you sure you want to Disconnect the Input Node from the Scene Parameter?" title:"Disconnect From Scene Parameter"
			if q then
			(
				case ddl_ValueType.selected of
				(
					"Integer":
					(
						theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4])
						theTrack[1].controller = bezier_float()
					)
					"Float":
					(
						theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4])
						theTrack[2].controller = bezier_float()
					)				
					"Vector":
					(
						theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4])
						theTrack[3][1].controller = bezier_float()
						theTrack[3][2].controller = bezier_float()
						theTrack[3][3].controller = bezier_float()
					)				
				)
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
				updateControls()
			)
		)		
			
		on btn_connectToSceneTrack pressed do
		(
			theInt = 0
			theInt = bit.set theInt 10 true --hide sound track
			theInt = bit.set theInt 13 true --show hidden nodes
			theInt = bit.set theInt 27 true --focus on first selected node
			
			case ddl_ValueType.selected of
			(
				"Integer":
				(
					theTVP = trackView.pickTrackDlg float_filter_function options:theInt
					if theTVP != undefined do
					(
						local theController = theTVP.anim
						local theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4])
						local theFloatScript = float_script()
						theFloatScript.AddTarget "KCE_Reference" theController
						theFloatScript.SetExpression "KCE_Reference" 
						theTrack[1].controller = theFloatScript
						KrakatoaChannelNodeEditor_Rollout.updateNodeDependencies()
					)
				)
				"Float":
				(
					theTVP = trackView.pickTrackDlg float_filter_function options:theInt
					if theTVP != undefined do
					(
						local theController = theTVP.anim
						local theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4])
						local theFloatScript = float_script()
						theFloatScript.AddTarget "KCE_Reference" theController
						theFloatScript.SetExpression "KCE_Reference" 
						theTrack[2].controller = theFloatScript
						KrakatoaChannelNodeEditor_Rollout.updateNodeDependencies()
					)
				)				
				"Vector":
				(
					theTVP = trackView.pickTrackDlg point3_filter_function options:theInt
					if theTVP != undefined do
					(
						local theController = theTVP.anim
						local theTrack = execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID+".Input_"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][4]+".Vector.controller")
						local theFloatScriptX = float_script()
						theFloatScriptX.AddTarget "KCE_Reference" theController
						theFloatScriptX.SetExpression "KCE_Reference.x" 
						theTrack[1].controller = theFloatScriptX
						
						local theFloatScriptY = float_script()
						theFloatScriptY.AddTarget "KCE_Reference" theController
						theFloatScriptY.SetExpression "KCE_Reference.y" 
						theTrack[2].controller = theFloatScriptY
						
						local theFloatScriptZ = float_script()
						theFloatScriptZ.AddTarget "KCE_Reference" theController
						theFloatScriptZ.SetExpression "KCE_Reference.z" 
						theTrack[3].controller = theFloatScriptZ
						KrakatoaChannelNodeEditor_Rollout.updateNodeDependencies()
					)
				)				
			)
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			updateControls()
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		
		on btn_zoomTrackView pressed do
		(
			try
			(
				trackView.open "Krakatoa Channels Editor Tracks"
				trackviews.current.rootTrack = execute "trackViewNodes.KrakatoaChannelEditor"
				trackviews.zoomOn "Krakatoa Channels Editor Tracks" (execute KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3]) ddl_ValueType.selection
			)catch()	
		)			
		
		on edt_scriptCode entered txt do
		(
			theString = KrakatoaChannelsEditor_Functions.purifyTextScript txt			
			KrakatoaChannelEditor_LastError = #(0,"","")
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][6] = theString
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			try
			(
				local theVal = execute theString
				if classof theVal == Integer or classof theVal == Float or classof theVal  == Point3 or classof theVal == color then
				(
					KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Script Expression Changed.")
				)	
				else
					throw "Invalid Type"
			)catch(KrakatoaChannelNodeEditor_Rollout.lbx_log.items = append KrakatoaChannelNodeEditor_Rollout.lbx_log.items (localtime +": ERROR in Script Expression:" + getCurrentException() ))	
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			edt_scriptCode.text = theString
		)
		/*
		on  edt_scriptCode entered txt do
		(
			edt_scriptCode.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
		)
		*/
		on btn_getTextureMap pressed do
		(
			local theMap = materialBrowseDlg #maps
			if theMap != undefined and findItem KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources theMap == 0 do 
			(
				append KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources theMap
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]  = KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources.count + 1
				updateControls()
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
				if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()				
			)	
		)
		
		on btn_putMaterialToEditor pressed do
		(
			if ddl_ValueType.selection > 1 do 
			(
				medit.PutMtlToMtlEditor KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources[ddl_ValueType.selection-1] (medit.GetActiveMtlSlot())
			)	
		)		
		
		on btn_removeTextureMap pressed do
		(
			local theIndex = ddl_ValueType.selection
			if theIndex > 1 do 
			(
				deleteItem KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources (theIndex-1)
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1] == "TextureMap" do
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] == theIndex then
						KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2]  = 1 
					else if KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] > theIndex do KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] -= 1
				)
				updateControls()
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
				if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)
		)
		
		on edt_ChannelName entered txt do
		(
			txt = KrakatoaChannelsEditor_Functions.purifyText txt
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = txt
			updateControls()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Enter Channel Name ["+ txt +"]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			edt_ChannelName.text = txt
		)
		on spn_valueInt changed val do
		(
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)		
		on spn_valueInt entered do
		(
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Integer Value [" + spn_valueInt.value as string + "]")
			storeValues()
		)
		
		on spn_value changed val do
		(
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		on spn_value entered do
		(
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Float Value [" + spn_value.value as string + "]")
			storeValues()
		)		
		
		on spn_x changed val do
		(
			clr_color.color.r = val*255
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		on spn_x entered do
		(
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Vector X Value [" + spn_x.value as string + "]")
			storeValues()
		)			
		
		on spn_y changed val do
		(
			clr_color.color.g = val*255
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		on spn_y entered do
		(
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Vector Y Value [" + spn_y.value as string + "]")
			storeValues()
		)			
		
		on spn_z changed val do
		(
			clr_color.color.b = val*255
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)	
		on spn_z entered do
		(
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Vector Z Value [" + spn_z.value as string + "]")
			storeValues()
		)			
		
		on clr_color changed val do
		(
			spn_x.value = clr_color.color.r/255.0
			spn_y.value = clr_color.color.g/255.0
			spn_z.value = clr_color.color.b/255.0
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Color ["+ (val as Point3) as string + "]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)

		on ddl_InputType selected itm do 
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] = ddl_InputType.selected
			KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading KrakatoaChannelEditor_DisplayNodeTreeData
			if itm == 2 do createControllers()
			updateControls()
			try(KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = ddl_ValueType.selected)catch()
			case ddl_InputType.selected of
			(
				"Script": KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = "Script"
				"TextureMap": KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = "Map"
				"Time": KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = "Time"
				default: ()
			)	
			
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Input Type [" + ddl_InputType.selected + "]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			setFocus KrakatoaChannelNodeEditor_Rollout.hc
		)	
		on ddl_ValueType selected itm do 
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			case ddl_InputType.selected of
			(
				"TextureMap":
				(
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = ddl_ValueType.selection
					KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = "Map"
					updateControls()
					KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
					KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Set TextureMap to [" + ddl_ValueType.selected + "]")
					if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
					setFocus KrakatoaChannelNodeEditor_Rollout.hc
				)
				"Channel":
				(
					if itm > 1 then
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = ddl_ValueType.selected
						updateControls()
						KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
						KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Channel [" + ddl_ValueType.selected + "]")
						if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
						setFocus KrakatoaChannelNodeEditor_Rollout.hc					
					)	
					else
						ddl_ValueType.selection = findItem ddl_ValueType.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
				)
				default:
				(
					KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = ddl_ValueType.selected
					updateControls()
					KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
					KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Value Type [" + ddl_ValueType.selected + "]")
					if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
					setFocus KrakatoaChannelNodeEditor_Rollout.hc
				)	
			)
		)	
		
		
	
		on KrakatoaChannelNodeEditor_InputRollout open do
		(
			ddl_InputType.selection = findItem ddl_InputType.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1]
			updateControls()
		)
	)
	
	rollout KrakatoaChannelNodeEditor_OutputRollout "Output"
	(
		label lbl_channelName "Channel Name:" align:#left offset:[-10,-5]
		edittext edt_ChannelName fieldwidth:160 align:#center offset:[-1,-3]
		listbox ddl_ChannelType "Standard Channel Names:" items:#() width:160 align:#center
		listbox ddl_ChannelData "Data Type" items:#("16","32") height:2 width:160 align:#center
		
		fn updateDataDepth =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theVal = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
			theVal = (substring theVal 1 (theVal.count-2))
			case ddl_ChannelData.selection of
			(
				2: theVal += "32"
				default: theVal += "16"
			)	
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = theVal			
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		
		fn updateSelection =
		(
			ddl_ChannelType.selection = findItem ddl_ChannelType.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1]
			ddl_ChannelData.selection = if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] pattern:"*32" then 2	 else 1
		)
		
		on edt_ChannelName entered txt do
		(
			txt = KrakatoaChannelsEditor_Functions.purifyText txt
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] = txt
			updateDataDepth()
			updateSelection()
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Enter Output Channel Name ["+ txt +"]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			edt_ChannelName.text = txt
		)
		
		on ddl_ChannelType selected itm do
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			edt_ChannelName.text = ddl_ChannelType.selected
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] = for i = 1 to 3 collect channelsList[itm][i]
			updateSelection()
			updateDataDepth()
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Output Channel Name ["+ ddl_ChannelType.selected +"]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		
		on ddl_ChannelData selected itm do
		(
			updateDataDepth()
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Output Channel Data ["+ddl_ChannelData.selected + "]")
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		
	
		
		on KrakatoaChannelNodeEditor_OutputRollout open do
		(
			edt_ChannelName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1]
			ddl_ChannelType.items = for i in channelsList collect i[1]
			updateSelection()
		)
	)
	
	rollout KrakatoaChannelNodeEditor_TransformationOperatorsRollout "Transformations" category:110
	(
		dropdownlist ddl_transformMode "Transform Mode:" items:#("Point","Vector","Normal") align:#center width:160
		pickbutton pck_referenceNode "Pick Reference Node..." align:#center width:160 enabled:false
		button btn_removeNodeReference "Remove Reference Node" align:#center width:160 enabled:false
		
		fn updateSceneObjectName =
		(
			local theName = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][10] 
			if isValidNode (getNodeByName (theName as string)) then 
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = pck_referenceNode.caption = theName 
			else			
			(
				pck_referenceNode.caption ="Pick Reference Node..."
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = ""
			)	
			case KrakatoaChannelNodeEditor_OperatorRollout.ddl_type.selected of 
			(
				"ToWorld": (deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3)
				"FromWorld": (try(deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3)catch())
				default: ()
			)
		)
		
		on KrakatoaChannelNodeEditor_TransformationOperatorsRollout open do
		(
			local theIndex = findItem ddl_transformMode.items KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9]
			if theIndex == 0 do theIndex = 1
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] =  ddl_transformMode.items[theIndex]
			ddl_transformMode.selection = theIndex
			pck_referenceNode.enabled = btn_removeNodeReference.enabled = KrakatoaChannelNodeEditor_OperatorRollout.ddl_type.selection > 2
			updateSceneObjectName()
		)
		
		on btn_removeNodeReference pressed do
		(
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][10] = ""
			pck_referenceNode.caption = "Pick Reference Node..."
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false			
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Removed Reference Node")
		)
		
		on ddl_transformMode selected itm do
		(
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][9] = ddl_transformMode.selected
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false			
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Changed Transform Mode To [" + ddl_transformMode.selected + "]")
		)
		
		on pck_referenceNode picked obj do
		(
			if obj != undefined do
			(
				pck_referenceNode.caption = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][10] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][3] = obj.name
				if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false	
				KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Picked Reference Node [" + obj.name+"]")
			)
		)
	)

	rollout KrakatoaChannelNodeEditor_OperatorRollout "Operator" category:100
	(
		
		local theListDefs = #(
			#("Add","Subtract","Multiply","Divide","Power","Modulo","Blend","Clamp","AbsoluteValue","Floor","Negate"),
			#("Magnitude","Normalize","ComponentSum","DotProduct","CrossProduct"),
			#("Sin","Cos","Tan","ASin","ACos","ATan"),
			#("ToVector","ToScalar","ToFloat","ToInteger"),
			#("ToWorld","FromWorld","ToSpace","FromSpace"),
			#("LogicalAnd","LogicalOr","LogicalNot","Less","LessOrEqual","Greater","GreaterOrEqual","Equal","Switch")
		)		
		
		--label lbl_nodeName "Node Name:" align:#left offset:[-8,0]

		group "Operator Settings:"
		(
			dropdownlist ddl_category "Operator Category:" items:#("Arithmetic","Vector","Trigonometry","Conversion","Transformations","Logic and Comparison") width:150 align:#center
			dropdownlist ddl_type "Operation Type:" width:150 align:#center height:20
		)	
		
		fn updateType =
		(
			--print "updateType"
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
			KrakatoaChannelNodeEditor_OperatorDescriptionRollout.updateDescription()
			KrakatoaChannelNodeEditor_Rollout.setSelectedNodes #(KrakatoaChannelNodeEditor_Rollout.lastNodeClick)
			if ddl_category.selected != "Transformations" do
			(
				try(deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 3)catch()
				try(deleteItem KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3] 2)catch()
			)	
			setFocus KrakatoaChannelNodeEditor_Rollout.hc			
		)
		
		fn updateCategories =
		(
			--KrakatoaChannelEditor_LastError = #(0,"","")
			--print "updateCategories"
			ddl_type.selection = 1
			for i = 1 to theListDefs.count do 
			(
				local theIndex = findItem theListDefs[i] KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1]
				if theIndex > 0 do
				(
					ddl_category.selection = i
					ddl_type.items = theListDefs[i]			
					ddl_type.selection = theIndex
					--print theIndex
					exit
				)
			)	

			updateType()
		)	
		
		fn updateTransformRollout =
		(
			try(removeSubRollout KrakatoaChannelNodeEditor_Rollout.NodePropsSR KrakatoaChannelNodeEditor_TransformationOperatorsRollout)catch()
			if ddl_category.selected == "Transformations" do
				addSubRollout KrakatoaChannelNodeEditor_Rollout.NodePropsSR KrakatoaChannelNodeEditor_TransformationOperatorsRollout
		)
		
		on ddl_type selected itm do
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			if ddl_type.selected != undefined do
				KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = ddl_type.selected
			updateType()
			if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			updateTransformRollout()
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Change Operator Output Type"			
		)		
		
		on ddl_category selected itm do
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			ddl_type.items = theListDefs[itm]	
			--if ddl_type.selection > ddl_type.items.count do 
			ddl_type.selection = 1
			if ddl_type.selected != undefined do
				KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = ddl_type.selected			
			updateTransformRollout()
			updateType()
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord "Change Operator Category"			
		)		
		
		on KrakatoaChannelNodeEditor_OperatorRollout open do
		(
			updateCategories()
			updateTransformRollout()
			KrakatoaChannelNodeEditor_OperatorDescriptionRollout.updateDescription()
		)
	)	
	
	rollout KrakatoaChannelNodeEditor_ConnectorRollout "BlackOp Connector"
	(
		label lbl_socketName "Socket Name:" align:#left offset:[-10,-3]
		edittext edt_socketName align:#center fieldwidth:160 offset:[-2,-3]
		
		on edt_socketName entered txt do
		(
			txt = KrakatoaChannelsEditor_Functions.purifyText txt
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1] = txt
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			edt_socketName.text = txt
		)
		
		on KrakatoaChannelNodeEditor_ConnectorRollout open do
		(
			edt_socketName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][1]
		)
	)
	
	rollout KrakatoaChannelNodeEditor_OutputConnectorRollout "BlackOp Output Connector"
	(
		--label lbl_socketName "No Properties Exposed Yet." align:#center --offset:[-10,-3]
		
		button btn_loadFromDisk "Load Definition From Disk..." align:#center width:160 height:25
		button btn_saveToDisk "Save Definition To Disk..." align:#center width:160 height:25
		button btn_exploreFolders "Explore BlackOp Folders..." align:#center width:160 height:25 
		button btn_exitEditing "EXIT BLACKOP EDITING..." align:#center width:160 height:35 offset:[0,5]
		
		on btn_exitEditing pressed do KrakatoaChannelsEditor_Functions.endEditingBLOP()

		on btn_saveToDisk pressed do
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps") all:true
			local theFileName = getSaveFileName caption:"Save BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\"+currentlyEditedBlackOpName) types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
			if theFileName != undefined do
			(
				KrakatoaChannelEditor_BLOPArray = deepCopy KrakatoaChannelEditor_DisplayNodeTreeData
				for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
				(
					if KrakatoaChannelEditor_BLOPArray[i][3][1] == "Script" do KrakatoaChannelEditor_BLOPArray[i][3][2] = KrakatoaChannelEditor_BLOPArray[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_BLOPArray[i][4][6])
					if KrakatoaChannelEditor_BLOPArray[i][1] == "Input"  and KrakatoaChannelEditor_BLOPArray[i][3][3]  != undefined do deleteItem KrakatoaChannelEditor_BLOPArray[i][3] 3
				)
				local theFileHandle = createFile theFileName
				with PrintAllElements true	format "global KrakatoaChannelEditor_BlackOpData = %\n" KrakatoaChannelEditor_BLOPArray to:theFileHandle 
				close theFileHandle
				KrakatoaChannelEditor_BlackOpData = execute ( with PrintAllElements true KrakatoaChannelEditor_BLOPArray as string)
			)	
		)
		
		on btn_loadFromDisk pressed do
		(
			local theFileName = getOpenFileName caption:"Load BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\"+currentlyEditedBlackOpName) types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
			if theFileName != undefined do
			(
				fileIn theFileName
				local theBLOPDef = deepcopy KrakatoaChannelEditor_BlackOpData
				KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading theBLOPDef
				--KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = getFileNameFile theFileName
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy theBLOPDef 
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
				if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
				if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
				KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Load BlackOp Definition From File")
			)	
		)
		
		on btn_exploreFolders pressed do
		(
			shellLaunch (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\") ""
		)		
	)	
	
	rollout KrakatoaChannelNodeEditor_BlackOpsRollout "BlackOp" category:100
	(
		local theConnectorNames = #()
		local theConnectorIndices = #()

		button btn_loadFromDisk "Load Definition From Disk..." align:#center width:160
		
		listbox lbx_inputConnections "Input Names:" align:#center width:160
		edittext edt_ConnectionName align:#center width:162 offset:[-2,-5]
		button btn_saveToDisk "Save Definition To Disk..." align:#center width:160
		button btn_exploreFolders "Explore BlackOp Folders..." align:#center width:160
		
		on edt_ConnectionName entered txt do
		(
			txt = KrakatoaChannelsEditor_Functions.purifyText txt
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2][theConnectorIndices[lbx_inputConnections.selection]][3][1] = theConnectorNames[lbx_inputConnections.selection] = txt
			lbx_inputConnections.items = theConnectorNames
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:false
			KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("BlackOp Input Name ["+ txt+"]")
			edt_ConnectionName.text = txt
		)
		
		on btn_saveToDisk pressed do
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps") all:true
			local theFileName = getSaveFileName caption:"Save BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8]) types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
			if theFileName != undefined do
			(
				KrakatoaChannelEditor_BLOPArray = deepCopy KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2]
				for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
				(
					if KrakatoaChannelEditor_BLOPArray[i][3][1] == "Script" do KrakatoaChannelEditor_BLOPArray[i][3][2] = KrakatoaChannelEditor_BLOPArray[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_BLOPArray[i][4][6])
					if KrakatoaChannelEditor_BLOPArray[i][1] == "Input"  and KrakatoaChannelEditor_BLOPArray[i][3][3]  != undefined do deleteItem KrakatoaChannelEditor_BLOPArray[i][3] 3
				)
				local theFileHandle = createFile theFileName
				with PrintAllElements true	format "global KrakatoaChannelEditor_BlackOpData = %\n" KrakatoaChannelEditor_BLOPArray to:theFileHandle 
				close theFileHandle
				KrakatoaChannelEditor_BlackOpData = execute ( with PrintAllElements true KrakatoaChannelEditor_BLOPArray as string)
			)	
		)
		
		on btn_loadFromDisk pressed do
		(
			local theFileName = getOpenFileName caption:"Load BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8]) types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
			if theFileName != undefined do
			(
				fileIn theFileName
				local theBLOPDef = deepcopy KrakatoaChannelEditor_BlackOpData
				KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading theBLOPDef
				KrakatoaChannelNodeEditor_NodeNameRollout.edt_nodeName.text = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][4][8] = getFileNameFile theFileName
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][3][2] = deepCopy theBLOPDef 
				KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
				if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
				if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false	
				KrakatoaChannelNodeEditor_Rollout.createUndoRecord ("Load BlackOp Definition From File")
				if KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)	
		)
		
		on btn_exploreFolders pressed do
		(
			shellLaunch (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\") ""
		)
		
		on KrakatoaChannelNodeEditor_BlackOpsRollout open do
		(
			local theNode = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick]
			
			theConnectorNames = #()
			theConnectorIndices = #()
			
			for i = 1 to theNode[3][2].count where theNode[3][2][i][1] == "Connector" do
			(
				append theConnectorNames theNode[3][2][i][3][1]
				append theConnectorIndices i
			)
			lbx_inputConnections.items = theConnectorNames
			if theConnectorNames.count > 0 do
				edt_ConnectionName.text = theConnectorNames[1]
		)
	)
	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--MAIN ROLLOUT--
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
	
	rollout KrakatoaChannelNodeEditor_Rollout "Krakatoa Channels Editor"
	(
		local lastMouseClick = [0,0]
		local lastNodeClick = 0			
		local displaySelectedNodeProperties, autoReorderFlow, zoomExtents

		
		SchematicControl hc "" width:800 height:600 pos:[0,0] 
		progressbar prg_bar width:176 height:6 pos:[0,0] color:red value:100
		subRollout NodePropsSR width:180 height:600 pos:[800,0]
		dropdownlist lbx_log width:800 height:10 pos:[0,0]
		
		checkbutton chk_autoUpdateModifier "AUTO" width:60 height:20  pos:[800,1] 
		button btn_updateModifier "UPDATE" width:118 height:20  pos:[860,1] 
		
		button btn_zoomExtents "ZE" width:25 height:25  pos:[800,580] tooltip:"Zoom Extents; Right-Click To Reset Pan and Zoom"
		button btn_zoomExtentsSelected "ZS" width:25  height:25  pos:[820,580] tooltip:"Zoom Extents Selected; Right-Click To Reset Pan and Zoom"
		button btn_NoZoom "NZ" width:25  height:25  pos:[840,580] tooltip:"Reset Zoom; Right-Click To Reset Pan and Zoom"
		button btn_NoPoom "NP" width:25  height:25  pos:[860,580] tooltip:"Reset Pan; Right-Click To Reset Pan and Zoom"
		
		button btn_Undo "Undo" width:39 height:25 tooltip:"Click to Undo; Right-Click to display Undo History"
		button btn_Redo "Redo" width:39 height:25 tooltip:"Click to Redo; Right-Click to display Redo History"
		
		button btn_RecorderToStart "|<" width:25 height:25 visible:false
		button btn_RecorderBackOneStep "<<" width:25 height:25 visible:false
		checkbutton chk_RecorderPlay "|>"  width:25 height:25 visible:false
		button btn_RecorderForwardOneStep ">>" width:25 height:25 visible:false
		button btn_RecorderToEnd ">|"width:25 height:25 visible:false
		button btn_RecorderClose "Close" width:50 height:25 visible:false
		
		
		
		fn logInfo txt =
		(
			lbx_log.items = #(txt)
		)
		
		on lbx_log selected itm do
		(
			KrakatoaChannelsEditor_Functions.navigateToErrorModifier()
		)	
		
		fn getSelectedNodes =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.Count collect
			(
				hc.activeNode = i	
				if hc.isSelected == true then i else dontcollect
			)
		)
		
		fn getSelectedDepotButton =
		(
			for i = KrakatoaChannelEditor_DisplayNodeTreeData.Count+1 to hc.getNodeCount collect
			(
				hc.activeNode = i
				if hc.isSelected == true then i-KrakatoaChannelEditor_DisplayNodeTreeData.Count else dontcollect
			)
		)
		
		fn getDepotSelection =
		(
			for i = KrakatoaChannelEditor_DisplayNodeTreeData.Count+1 to hc.getNodeCount collect
			(
				hc.activeNode = i
				if hc.isSelected == true then i else dontcollect
			)
		)
		
		fn getUnSelectedNodes =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.Count collect
			(
				hc.activeNode = i	
				if hc.isSelected == false then i else dontcollect
			)
		)		
		
		fn setSelectedNodes theSel =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.Count do
			(
				hc.activeNode = i	
				hc.isSelected = false
			)			
			for i in theSel where i <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				hc.activeNode = i	
				hc.isSelected = true
			)
		)
		
		fn setSelectedNodesInData theSel =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.Count do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][3] = false
			)			
			for i in theSel do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][3] = true
			)
		)		


		fn updateNodeDependencies = 
		(
			--KrakatoaChannelEditor_LastError = #(0,"","")
			deleteAllChangeHandlers id:#KCE_CurrentModifierSceneParametersMonitor
			local theDepNodes = #()
			local theTabuNodes = refs.dependents KrakatoaChannelNodeEditor_CurrentModifier
			local theRoot = try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+KrakatoaChannelNodeEditor_CurrentModifier.trackID))catch(undefined)
			if theRoot != undefined do
			(
				for i = 1 to theRoot.numsubs do
				(
					theTrack = theRoot[i] 
					for t in #(theTrack[1],theTrack[2],theTrack[3][1]) do
					(
						if classof t.controller == Float_Script do
						(
							local theTarget = try(t.controller.getTarget "KCE_Reference") catch(undefined)
							if theTarget != undefined do
							(
								for o in refs.dependents theTarget where classof (superclassof o) == Node and findItem theDepNodes o == 0 and findItem theTabuNodes o == 0 and isProperty o "name" do 
									append theDepNodes o
							)	
						)
					)--end t loop	
				)
				--try(KrakatoaChannelNodeEditor_CurrentModifier.nodeDependencies = theDepNodes)catch()
				
				for i in KrakatoaChannelEditor_DisplayNodeTreeData where i[3][1] == "FromSpace" or i[3][1] == "ToSpace"  do 
				(
					local theNode = try(getNodeByName i[3][3])catch(undefined)
					if isValidNode theNode and findItem theTabuNodes theNode == 0 do append theDepNodes theNode
				)
				
				when parameters theDepNodes change id:#KCE_CurrentModifierSceneParametersMonitor do 
					try(if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier())catch()
			)	
		)		
		
		fn getInputSocketColor theNode theSocketIndex =
		(
			if theNode[2][theSocketIndex] == undefined or theNode[2][theSocketIndex] < 1 then
				theInputSocketColor
			else
			(
				local theConnected = KrakatoaChannelEditor_DisplayNodeTreeData[theNode[2][theSocketIndex] ]
				if theConnected != undefined then
				(
					case theConnected[1] of
					(
						default:
						(
							if theConnected[5] == false then 
								theInputSocketColor
							else
							case theConnected[3][1] of
							(
								"Value": 
								(
									case theConnected[3][2] of
									(
										"Integer" : theIntegerSocketColor 
										"Float" : theFloatSocketColor 
										"Vector": theVectorSocketColor 
										default: red
										--"Color":   try(theConnected[3][3]*255)catch(theIntegerSocketColor)
									)											
								)
								"Time" : theTimeSocketColor 
								"Channel" : theChannelSocketColor 
								"TextureMap" : theTextureMapSocketColor
								"Script": theFloatSocketColor
								default: red
							)							
						)
						"Operator": theChannelSocketColor
						"BlackOp": theChannelSocketColor
						"Output": theChannelSocketColor
					)
				)
				else theInputSocketColor
			)							
		)		
		fn getInputSocketName theNode theSocketIndex =
		(
			--format "%\n" theNode 
			--print theSocketIndex
			local result = "???"
			if theNode[2][theSocketIndex] == undefined or theNode[2][theSocketIndex] < 1 then
				result = "Input " + theSocketIndex as string
			else
			(
				local theConnected = KrakatoaChannelEditor_DisplayNodeTreeData[theNode[2][theSocketIndex] ]
				if theConnected != undefined then
				(
					result= case theConnected[1] of
					(
						"Connector": theConnected[3][1]
						default: theConnected[4][8] as string
						"Input": (
							case theConnected[3][1] of
							(
								default: theConnected[4][8] as string
								"TextureMap": try("[" + (join #("Current") (for i in KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources collect (classof i) as string))[theConnected[3][2]]+"]")catch("Missing Map")
							)
						)
					)
				)
				else 
					result= "Input " + theSocketIndex as string
			)					
			result
		)			
		
		fn getChannelDataType theChannelName =
		(
			theIndex = findItem (for i in ChannelsList collect i[1]) theChannelName
			if theIndex == 0 then "??? " else ChannelsList[theIndex][2] + "[" + ChannelsList[theIndex][3] as string + "]"
		)



		local addNewInput, addNewOperator, theDepotNodes, addNewBLOP
		
		fn createDepot =
		(
			local expandCategories = DepotPlacement != #bottomrollup and DepotPlacement != #bottomrollupreverse
			theDepotNodesArray  =#(
			#(	
				#("HEAD","Inputs:",theHeaderColor,[0,0], "Inputs Group", expandCategories),
				#("IN","Channel",theInputNodeColor,[0,0], #channel, #none),
				#("IN","Vector",theInputNodeColor+[0,20,0],[0,0], #value, #vector),
				#("IN","Float",theInputNodeColor+[-20,20,-20] ,[0,0], #value, #float),
				#("IN","Integer",theInputNodeColor-[0,20,20],[0,0], #value, #integer),
				#("IN","Script",theInputNodeColor+ [20,-20,-20],[0,0], #script, #none),
				#("IN","TexMap",theInputNodeColor+ [20,0,-20],[0,0], #textureMap, #none)
			--#("IN","Time",theInputNodeColor- [0,0,40],[0,0], #time, #none),
			),
			
			#(
				#("HEAD","Arithmetic:",theHeaderColor,[0,0], "Arithmetic Operators Group", expandCategories),
				#("OP","+ Add",theOperatorNodeColor,[0,0], "Add"),
				#("OP","- Subtract",theOperatorNodeColor,[0,0],  "Subtract"),
				#("OP","* Multiply",theOperatorNodeColor,[0,0] , "Multiply"),
				#("OP","/ Divide",theOperatorNodeColor,[0,0], "Divide"),
				#("OP","^ Power",theOperatorNodeColor,[0,0], "Power"),
				#("OP","Modulo",theOperatorNodeColor,[0,0], "Modulo"),
				#("OP","Blend",theOperatorNodeColor,[0,0], "Blend"),
				#("OP","Clamp",theOperatorNodeColor,[0,0], "Clamp"),
				#("OP","Absolute",theOperatorNodeColor,[0,0], "AbsoluteValue"),
				#("OP","Floor",theOperatorNodeColor,[0,0], "Floor"),
				#("OP","Negate",theOperatorNodeColor,[0,0], "Negate")
			),
			#(
				#("HEAD","Vectors:",theHeaderColor,[0,0], "Vector Operators Group",expandCategories),
				#("OP","Magnitude",theOperatorNodeColor+[0,10,0],[0,0], "Magnitude"),
				#("OP","Normalize",theOperatorNodeColor+[0,10,0],[0,0], "Normalize"),
				#("OP","CompSum",theOperatorNodeColor+[0,10,0],[0,0], "ComponentSum"),			
				#("OP","Dot",theOperatorNodeColor+[0,10,0],[0,0], "DotProduct"),			
				#("OP","Cross",theOperatorNodeColor+[0,10,0],[0,0], "CrossProduct")
			),

			#(
				#("HEAD","Trigonom.:",theHeaderColor,[0,0], "Trigonometry Operators Group", expandCategories),
				#("OP","Sin",theOperatorNodeColor+[0,-10,0],[0,0], "Sin"),
				#("OP","Cos",theOperatorNodeColor+[0,-10,0],[0,0], "Cos"),
				#("OP","Tan",theOperatorNodeColor+[0,-10,0],[0,0], "Tan"),
				#("OP","ASin",theOperatorNodeColor+[0,-10,0],[0,0], "ASin"),
				#("OP","ACos",theOperatorNodeColor+[0,-10,0],[0,0], "ACos"),
				#("OP","ATan",theOperatorNodeColor+[0,-10,0],[0,0], "ATan")
			),
			#(
				#("HEAD","Convert:",theHeaderColor,[0,0], "Conversion Group", expandCategories),
				
				#("OP","ToVector",theOperatorNodeColor+[-10,-10,10],[0,0], "ToVector"),
				#("OP","ToScalar",theOperatorNodeColor+[-10,-10,10],[0,0], "ToScalar"),
				#("OP","ToFloat",theOperatorNodeColor+[-10,-10,10],[0,0], "ToFloat"),
				#("OP","ToInteger",theOperatorNodeColor+[-10,-10,10],[0,0], "ToInteger")
			),

			#(
				#("HEAD","Transform:",theHeaderColor,[0,0], "Transformations Group", expandCategories),
				#("OP","ToWorld",theOperatorNodeColor+[-10,10,0],[0,0], "ToWorld"),
				#("OP","FromWorld",theOperatorNodeColor+[-10,10,0],[0,0], "FromWorld"),
				#("OP","ToSpace",theOperatorNodeColor+[-10,10,0],[0,0], "ToSpace"),
				#("OP","FromSpace",theOperatorNodeColor+[-10,10,0],[0,0], "FromSpace")
			),

			#(
				#("HEAD","Logic:",theHeaderColor,[0,0], "Boolean Logic Operators Group", expandCategories),
				#("OP","And",theOperatorNodeColor+[-10,0,10],[0,0], "LogicalAnd"),
				#("OP","Or",theOperatorNodeColor+[-10,0,10],[0,0], "LogicalOr"),
				#("OP","Not",theOperatorNodeColor+[-10,0,10],[0,0], "LogicalNot"),
				#("OP","<",theOperatorNodeColor+[-10,0,10],[0,0], "Less"),
				#("OP","<=",theOperatorNodeColor+[-10,0,10],[0,0], "LessOrEqual"),
				#("OP",">",theOperatorNodeColor+[-10,0,10],[0,0], "Greater"),
				#("OP",">=",theOperatorNodeColor+[-10,0,10],[0,0], "GreaterOrEqual"),
				#("OP","==",theOperatorNodeColor+[-10,0,10],[0,0], "Equal"),
				#("OP","Switch",theOperatorNodeColor+[-10,0,10],[0,0], "Switch")
			),
			
			#(
				#("HEAD","Loaders:",theHeaderColor,[0,0], "Loaders Group", expandCategories),
				#("BLOP","BlackOp",theBoxNodeColor,[0,0], "BlackOp")
			)

			)		
			
			if DepotShowBLOPs do
			(
				local theRoot = (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps")
				local theDirs = join #(theRoot) (getDirectories (theRoot+"\\*"))
				for d in theDirs do
				(
					local theFiles = getFiles (d+"\\*.kcb")
					if theFiles.count > 0 do
					(
						local theFS = filterString d "\\"
						local theLastDir = theFS[theFS.count]
						append theDepotNodesArray #(#("HEAD",theLastDir,theHeaderColor,[0,0], ("["+theLastDir +"] BlackOps Folder"), false))
						for f in theFiles do
							append theDepotNodesArray[theDepotNodesArray.count] #("UBLOP",(getFileNameFile f),theBoxNodeColor+[-20,-20,0],[0,0], f)			
					)	
				)
			)
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 do
			(
				append theDepotNodesArray[1] #("CN","Connector",theOutputNodeColor,[0,0], #value, #connector)
			)
		)
		
		fn updateDepotDefinition =
		(
			theDepotNodes = #()
			
			if DepotShowCategories == true then
			(
				for i in theDepotNodesArray do 
				(
					if i[1][1] == "HEAD" do
						if i[1][6] == true then
							for j = 1 to i.count do append theDepotNodes (deepCopy i[j])
						else
							append theDepotNodes (deepCopy i[1])
				)		
			)
			else
			(
				for i in theDepotNodesArray do 
					for j = 2 to i.count do append theDepotNodes (deepCopy i[j])
			)	
		)
		
		fn prepareDepotForDragAndDrop =
		(
			if DepotPlacement == #off do return false
			for i = 1 to theDepotNodes.count do
			(
				hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count+i
				theDepotNodes[i][4] = hc.activeNodePos
			)				
		)
		
		fn drawDepot init:false lock:false =
		(
			leftDepotMargin = 0
			if DepotPlacement == #off do return false
			
			if DepotPlacement == #bottom do
			(
				local DepotX = 0
				local theHCount = (hc.width/DepotNodeWidth/hc.zoom) 
				local theVCount = ceil (theDepotNodes.count/theHCount)
				local DepotY = (hc.height-(18+(theVCount*18/hc.zoom)))
			)
			if DepotPlacement == #left do
			(
				local DepotX = 0
				local DepotY = 0
				leftDepotMargin = DepotNodeWidth
			)
			if DepotPlacement == #bottomrollup do
			(
				local DepotX = 0
				local theHCount = theDepotNodesArray.count
				local ArrayCnt = 1
				local theVCount = if theDepotNodesArray[ArrayCnt][1][6] then theDepotNodesArray[ArrayCnt].count else 1
				local DepotY = (hc.height-(18+theVCount*18/hc.zoom))
			)
			if DepotPlacement == #bottomrollupreverse do
			(
				local DepotX = 0
				local theHCount = theDepotNodesArray.count
				local ArrayCnt = 1
				local theVCount = if theDepotNodesArray[ArrayCnt][1][6] then theDepotNodesArray[ArrayCnt].count else 1
				local DepotY = (hc.height-36)
			)			
			for i = 1 to theDepotNodes.count do
			(
				if init do hc.addNode
				hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count+i
				hc.nodeName = theDepotNodes[i][2]
				hc.nodeColor = theDepotNodes[i][3] * (if theDepotNodes[i][1]=="HEAD" then (if theDepotNodes[i][6] == true then 1.0 else 0) else 1.0)
				hc.nodeSize = [(DepotNodeWidth-2)/hc.zoom,15/hc.zoom]
				hc.nodeCollapsedSize = hc.nodeSize 
				hc.isCollapsible  = false
				try(hc.drawLayer = 3)catch()
				--theDepotNodes[i][4] = hc.activeNodePos
				try
				(
					if lock or theDepotNodes[i][1]=="HEAD" then 
					(
						hc.viewAlign = -1
						hc.viewAlignOffset = [DepotX, DepotY]
					)
					else					
					(
						hc.viewAlign = 0
					)
					hc.activeNodePosRelative = [DepotX, DepotY]
				)
				catch(hc.activeNodePosRelative = [DepotX, DepotY])
				case DepotPlacement of
				(
					#bottom: (
						DepotX += DepotNodeWidth
						if DepotX > hc.width-DepotNodeWidth  do
						(
							DepotX = 0
							DepotY+=18
						)
					)
					#left:
					(
						DepotY += 18
						if DepotY > hc.height-20 do
						(
							DepotX += DepotNodeWidth
							leftDepotMargin = depotX+DepotNodeWidth
							DepotY=0
						)
					)	
					#bottomrollup:
					(
						DepotY += 18
						if try(theDepotNodes[i+1][1] == "HEAD")catch(false) do
						(
							DepotX += DepotNodeWidth
							ArrayCnt += 1
							theVCount = if theDepotNodesArray[ArrayCnt][1][6] then theDepotNodesArray[ArrayCnt].count else 1
							--format "%  %\n" ArrayCnt theVCount
							DepotY = (hc.height-(18+theVCount*18/hc.zoom))						
						)					
					)	
					#bottomrollupreverse:
					(
						DepotY -= 18
						if try(theDepotNodes[i+1][1] == "HEAD")catch(false) do
						(
							DepotX += DepotNodeWidth
							ArrayCnt += 1
							theVCount = if theDepotNodesArray[ArrayCnt][1][6] then theDepotNodesArray[ArrayCnt].count else 1
							--format "%  %\n" ArrayCnt theVCount
							DepotY = (hc.height-36)						
						)					
					)						
				)--end case
			)
			hc.redrawView				
		)
		


		fn getInputCount theNode =
		(
			if findItem #("ToWorld","FromWorld","ToSpace","FromSpace","Normalize","Negate","Floor","Magnitude","ComponentSum","AbsoluteValue","Sin","Cos","Tan","ASin","ACos","ATan","ToFloat","ToInteger","LogicalNot") theNode[3][1] > 0 then 1 
			else if findItem #("Add","Subtract","Multiply","Divide","Power","Modulo","ToScalar","DotProduct","CrossProduct","Less","LessOrEqual","Greater","GreaterOrEqual","Equal","LogicalAnd","LogicalOr") theNode[3][1]  > 0 then 2 
			else if findItem #("Blend","Clamp","ToVector","Switch") theNode[3][1] > 0 then 3 
			else if findItem #("BlackOp") theNode[1] > 0 then 
			(
				(for i = 1 to theNode[3][2].count where theNode[3][2][i][1] == "Connector" collect i).count
			)
			else if theNode[1] == "Output" then 1 else 0
		)	
		
		fn FlagUnconnectedNodes =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] = true
				local maxSocketCount = getInputCount KrakatoaChannelEditor_DisplayNodeTreeData[i]
				local connectedSockets = 0
				for j = 1 to maxSocketCount do 
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > 0 do 
						connectedSockets += 1
				)		
				if connectedSockets == 0 do
				(
					for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
						if findItem KrakatoaChannelEditor_DisplayNodeTreeData[j][2] i > 0 do connectedSockets += 1
					if connectedSockets == 0 do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] = false
				)
			)				
		)

		
		/*
		fn FlagUnconnectedOperatorsAsError =
		(
			--return false
			local theErrorNodes = #()
			--lbx_log.items = #()
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				local maxSocketCount = getInputCount KrakatoaChannelEditor_DisplayNodeTreeData[i]
				for j = 1 to maxSocketCount where KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] == undefined or KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] < 1 do
					if findItem theErrorNodes i == 0 do append theErrorNodes i
			)	
			for i in theErrorNodes do 
			(
				hc.activeNode = i
				if KrakatoaChannelEditor_DisplayNodeTreeData[i][5] != false do 
				(
					hc.nodeColor = theErrorNodeColor
					lbx_log.items = append lbx_log.items (localtime + ": ERROR: Disconnected but Active Operator ["+ i as string + ":" +KrakatoaChannelEditor_DisplayNodeTreeData[i][4][8] as string +"] Found. Connect, Disable (Ctrl+P) or Delete to Repair the Flow.")
				)
			)
			hc.redrawView	
			lbx_log.selection = lbx_log.items.count
			theErrorNodes.count > 0
		)			
		*/
		
		
		fn createNodeTree init:false=
		(
--			KrakatoaChannelsEditor_Functions.buildDisplayTree()
			ConnectorLeftMargin = 0
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 and DepotPlacement == #left do 
			(
				ConnectorLeftMargin = leftDepotMargin
			)
			if init do
			(
				for i = hc.getNodeCount to 1 by -1 do 
				(
					hc.activeNode = i	
					hc.deleteActiveNode
				)
			)	
			FlagUnconnectedNodes()
			local connectorCount = 0
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				local currentNode = KrakatoaChannelEditor_DisplayNodeTreeData[i]
				local nodeNumber = i as string
				case currentNode[1] of
				(
					"Output": (
						if init do hc.addNode
						hc.activeNode = i
						hc.nodeName =  nodeNumber +" OUT:" + currentNode[3][1] 
						hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID  then 
							theErrorNodeColor 
						else 
							theOutputNodeColor 
						hc.activeNodePos = currentNode[4][1] 
						hc.isCollapsible = false
						try(hc.drawLayer = 3)catch()
						try(hc.viewAlign = 1)catch()
						if init do hc.addInSocket
						hc.activeSocket = 1
						try(hc.activeSocketFlipped  = true)catch()
						hc. socketPosition = [5,17]
						hc.socketName = currentNode[3][2]+"["+currentNode[3][3] as string+"] " 
						hc.connectionColor = getInputSocketColor currentNode 1
						hc.nodeSize = [NodeWidth,30]
						hc.nodeCollapsedSize = [NodeWidth,30]		
						hc.activeNodeCollapsed  = currentNode[4][2] == true
						hc.isSelected = currentNode[4][3] == true
					)
					"OutputConnector": (
						if init do hc.addNode
						hc.activeNode = i
						hc.nodeName = currentlyEditedBlackOpName
						hc.nodeColor = theOutputNodeColor 
						--hc.activeNodePos = currentNode[4][1] 
						hc.isCollapsible = false
						try(hc.drawLayer = 3)catch()
						try(hc.viewAlign = 1)catch()
						if init do hc.addInSocket
						hc.activeSocket = 1
						try(hc.activeSocketFlipped  = true)catch()
						hc. socketPosition = [5,17]
						hc.socketName = "BlackOp Output "
						hc.connectionColor = red --getInputSocketColor currentNode 1
						hc.nodeSize = [NodeWidth,30]
						hc.nodeCollapsedSize = [NodeWidth,30]		
						hc.activeNodeCollapsed  = currentNode[4][2] == true
						hc.isSelected = currentNode[4][3] == true
					)		
					"Connector": (
						if init do hc.addNode
						hc.activeNode = i
						hc.nodeName =  " INPUT SOCKET " + (connectorCount+1)  as string
						hc.nodeColor = theOutputNodeColor 
						hc.viewAlignOffset = [ConnectorLeftMargin,connectorCount*40] --currentNode[4][1] 
						connectorCount +=1
						hc.isCollapsible = false
						try(hc.drawLayer = 3)catch()
						try(hc.viewAlign = -1)catch()
						--try(hc.activeSocketFlipped  = true)catch()
						if init do hc.addOutSocket
						hc.activeSocket = 1
						hc.socketPosition = [5,17]
						hc.socketName = currentNode[3][1] + " " --+"["+currentNode[3][3] as string+"] " 
						hc.connectionColor = color 200 100 100 --getInputSocketColor currentNode 1
						hc.nodeSize = [NodeWidth,30]
						hc.nodeCollapsedSize = [NodeWidth,30]		
						hc.isSelected = currentNode[4][3] == true
						hc.activeSocketShowValue = false
					)						
					
					"BlackOp":
					(
						if init do hc.addNode
						hc.activeNode = i
						try(hc.drawLayer = 1)catch()
						hc.nodeName = nodeNumber + " BLOP:" + currentNode[4][8] as string
						hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID  then 
							theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
						else 
							theBoxNodeColor * (if currentNode[5] == false then 0.5 else 1.0)
						hc.activeNodePos = currentNode[4][1] 
						hc.isCollapsible = true

						local totalInSockets = (for j in currentNode[3][2] where j[1] == "Connector" collect j)
						for s = 1 to totalInSockets.count do 
						(
							if init do hc.addInSocket
							hc.activeSocket = s
							hc.socketPosition = [5,30+(s-1)*13]
							hc.socketName = totalInSockets[s][3][1] as string  --s as string + " " + 
							hc.connectionColor = getInputSocketColor currentNode s
							hc.activeNodeCollapsed  = currentNode[4][2] == true
							hc.isSelected = currentNode[4][3] == true		
						)
						if init do hc.addOutSocket
						hc.activeSocket = totalInSockets.count+1
						hc.socketName = "Output "
						hc.activeSocketShowValue = false
						hc.connectionColor = theChannelSocketColor * (if currentNode[5] == false then 0.5 else 1.0)
						hc.socketPosition = [110,18]					
						if currentNode[4][14] == true do 
						(
							try(hc.activeSocketFlipped  = true)catch()
						)							
						hc.nodeSize = [NodeWidth,30+(totalInSockets.count)*13]
						hc.nodeCollapsedSize = [NodeWidth,15]		
					)
					"Input": 
					(
						if init do hc.addNode
						hc.activeNode = i
						try(hc.drawLayer = 2)catch()
						hc.activeNodePos = currentNode[4][1] 			
						if init do hc.addOutSocket
						hc.activeSocket = 1
						hc.socketPosition = [110,17]
						if currentNode[4][14] == true do 
						(
							try(hc.activeSocketFlipped  = true)catch()
						)	
						if currentNode[3][1] == "Channel" do
						(
							local theNameString = currentNode[4][8]
							if theNameString == undefined do theNameString = currentNode[4][8] = currentNode[3][2]
							hc.nodeName = nodeNumber + " IN:Channel:" + theNameString
							hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
								theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
							else 
								theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0)
							hc.connectionColor = theChannelSocketColor * (if currentNode[5] == false then 0.5 else 1.0)
							hc.socketName = currentNode[3][2]+ " "+ getChannelDataType currentNode[3][2]
						)
						hc.activeSocketShowValue = false
						if currentNode[3][1] == "Value" then
						(
							hc.socketName = currentNode[3][2] + " "
							local theNameString = currentNode[4][8]
							if theNameString == undefined do theNameString = currentNode[4][8] = currentNode[3][2]
							case currentNode[3][2] of
							(
								"Integer" : 
								( 
									local theExpString = ""
									if currentNode[4][12] == true do theExpString +="E" 
									try(if classof (execute (currentNode[3][3]+"[1].controller")) == Float_Script do theExpString +="C" )catch()
									hc.nodeName = theExpString + nodeNumber+ " IN:Int:" + theNameString
									hc.socketName ="Integer:" + (try(((floor((execute (currentNode[3][3]+"[1].controller.value"))+0.5)) as integer) as string + " ")catch("??"))
									hc.connectionColor = theIntegerSocketColor * (if currentNode[5] == false then 0.5 else 1.0) 
									hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
										theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
									else 
										theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) - [0,20,20]
									)
								"Float" : 
								( 
									local theExpString = ""
									if currentNode[4][12] == true do theExpString +="E" 
									try(if classof (execute (currentNode[3][3]+"[2].controller")) == Float_Script do theExpString +="C" )catch()
									hc.nodeName =  theExpString + nodeNumber+ " IN:Float:" + theNameString
									hc.socketName = "Float:" + (try((execute (currentNode[3][3]+"[2].controller.value")) as string + " ")catch("?.?") )
									hc.connectionColor = theFloatSocketColor * (if currentNode[5] == false then 0.5 else 1.0) 
									hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
										theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
									else 
										theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) + [-20,20,-20] 
									)
								"Vector": 
								( 
									local theExpString = ""
									if currentNode[4][12] == true do theExpString +="E" 
									try(if classof (execute (currentNode[3][3]+"[3].controller[1].controller")) == Float_Script do theExpString +="C" )catch()
									hc.nodeName =  theExpString+nodeNumber+ " IN:Vector:" + theNameString
									--print (currentNode[3][3]+"[3].controller.value")
									hc.socketName =  "Vector:" + (try((execute (currentNode[3][3]+"[3].controller.value")) as string+ " ")catch("[?, ?, ?]")) --currentNode[3][2] + " " +
									hc.connectionColor = theVectorSocketColor * (if currentNode[5] == false then 0.5 else 1.0) 
									hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
										theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
									else 
										theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) + [0,20,0]
								)
								default:
								(
									hc.nodeName =  nodeNumber + " IN:???:" + theNameString
									hc.socketName =  "???"
									hc.connectionColor = theVectorSocketColor * (if currentNode[5] == false then 0.5 else 1.0) 
									hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
										theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
									else 
										theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) + [0,20,0]
								)
							)								
						)	
						if currentNode[3][1] == "Time" then
						(
							local theNameString = currentNode[4][8]
							if theNameString == undefined do theNameString = currentNode[4][8] = "Time"
							
							hc.nodeName =  nodeNumber + " IN:Time:" +theNameString
							hc.socketName = "Time "
							hc.connectionColor = theTimeSocketColor * (if currentNode[5] == false then 0.5 else 1.0)
							hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
								theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
							else 
								theInputNodeColor * (if currentNode[5] == false then 0.5 else 1.0) - [0,0,40]
						)
						if currentNode[3][1] == "TextureMap" do
						(
							local theNameString = currentNode[4][8]
							if theNameString == undefined do theNameString = currentNode[4][8] = "[" + (join #("Current") (for i in KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources collect i as string))[currentNode[3][2]]+"]"
							hc.nodeName = nodeNumber +  " IN:Map:"+ theNameString 
							hc.socketName = try("[" + (join #("Current") (for i in KrakatoaChannelNodeEditor_CurrentModifier.TextureMapSources collect i as string))[currentNode[3][2]]+"]")catch("Missing Map")
							hc.connectionColor = theTextureMapSocketColor * (if currentNode[5] == false then 0.5 else 1.0)
							hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
								theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
							else 
								theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) + [20,0,-20]
						)				
						if currentNode[3][1] == "Script" do
						(
							local theNameString = currentNode[4][8]
							if theNameString == undefined do theNameString = currentNode[4][8] = "MyScript"
							hc.nodeName =  nodeNumber + " IN:"+theNameString
							hc.socketName = "Script:Output"
							hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
								theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
							else 
								theInputNodeColor * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0) + [20,-20,-20]
							if scriptCodeAutoCheck do
							(
								try
								(
									local theVal = execute( currentNode[3][2])
									if classof theVal == Integer or classof theVal == Float or classof theVal  == Point3 or classof theVal == color then
									(
										hc.socketName = theVal as string
									)
									else
									(
										hc.socketName = "NAN "
										hc.nodeColor = color 255 128 128									
									)
								)catch
								(
									hc.socketName = "ERROR "
									hc.nodeColor = color 255 128 128
								)
							)	
							hc.connectionColor = theFloatSocketColor * (if currentNode[5] == false then 0.5 else 1.0)
						)				
						hc.nodeSize = [NodeWidth,30]
						hc.nodeCollapsedSize = [NodeWidth,15]			
						hc.activeNodeCollapsed  = currentNode[4][2] == true
						hc.isSelected = currentNode[4][3] == true
					)	
					"Operator": 
					(
						if init do hc.addNode
						hc.activeNode = i
						try(hc.drawLayer = 2)catch()
						local theNameString = currentNode[4][8]
						if theNameString == undefined do theNameString = currentNode[4][8] = currentNode[3][1]
						hc.nodeName =  nodeNumber+ " OP:" + theNameString 
						local theColorOffset = [0,0,0]
						if findItem #("Magnitude","Normalize",	"ComponentSum",	"DotProduct","CrossProduct") currentNode[3][1] > 0 do theColorOffset = [0,10,0]
						if findItem #("Sin","Cos","Tan","ASin","ACos","ATan") currentNode[3][1] > 0 do theColorOffset = [0,-10,0] 
						if findItem #("LogicalAnd", "LogicalOr", "LogicalNot", "Less", "Greater", "GreaterOrEqual", "Equal", "Switch") currentNode[3][1] > 0 do theColorOffset =  [-10,0,10]
						if findItem #("ToVector","ToScalar","ToFloat","ToInteger") currentNode[3][1] > 0 do theColorOffset = [-10,-10,10]
						if findItem #("ToWorld","FromWorld","ToSpace","FromSpace") currentNode[3][1] > 0 do theColorOffset = [-10,10,10]
						

						hc.nodeColor = if KrakatoaChannelEditor_LastError[1] == i and KrakatoaChannelEditor_LastError[3] == KrakatoaChannelNodeEditor_CurrentModifier.trackID then 
							theErrorNodeColor * (if currentNode[5] == false then 0.75 else 1.0)
						else 
							(theOperatorNodeColor+theColorOffset ) * (if currentNode[4][7]==false then 0.9 else 1.0) * (if currentNode[5] == false then 0.5 else 1.0)
						hc.activeNodePos = currentNode[4][1] 

						--TWO INPUTS
						if getInputCount currentNode == 2 then
						(
							if init do hc.addInSocket
							hc.activeSocket = 1
							hc.socketPosition = [5,30]
							hc.socketName = getInputSocketName currentNode 1
							hc.connectionColor = getInputSocketColor currentNode 1
							
							if init do hc.addInSocket
							hc.activeSocket = 2
							hc.socketPosition = [5,43]
							hc.connectionColor = getInputSocketColor currentNode 2
							hc.socketName = getInputSocketName currentNode 2
							
							if init do hc.addOutSocket
							hc.activeSocket = 3
							hc.socketName = currentNode[3][1]+" "
							hc.connectionColor = color 0 0 200
							hc.activeSocketShowValue = false
							hc.socketPosition = [110,18]
							hc.nodeSize = if operatorHeightConstant then
								[NodeWidth , 70]
							else
								[NodeWidth , 57]
							if currentNode[4][14] == true do 
							(
								try(hc.activeSocketFlipped  = true)catch()
							)								
						)
					
						--ONE INPUT
						if getInputCount currentNode == 1 then
						(
							if init do hc.addInSocket
							hc.activeSocket = 1
							hc.socketPosition = [5,30]
							hc.socketName = getInputSocketName currentNode 1
							hc.connectionColor = getInputSocketColor currentNode 1
							if init do hc.addOutSocket
							hc.activeSocket = 2
							hc.socketName = if currentNode[3][1] == "ToSpace" or currentNode[3][1] == "FromSpace" then
								currentNode[3][3] as string +" "
							else
								currentNode[3][1]+" "							
							hc.activeSocketShowValue = false
							hc.connectionColor = color 0 0 200
							hc.socketPosition = [110,18]
							hc.nodeSize = if operatorHeightConstant then
								[NodeWidth , 70]
							else
								[NodeWidth , 45]
							if currentNode[4][14] == true do 
							(
								try(hc.activeSocketFlipped  = true)catch()
							)								
						)	
						
						
						--THREE INPUTS
						if getInputCount currentNode == 3 then
						(
							if init do hc.addInSocket
							hc.activeSocket = 1
							hc.socketPosition = [5,30]
							hc.socketName = getInputSocketName currentNode 1
							hc.connectionColor = getInputSocketColor currentNode 1
							
							if init do hc.addInSocket
							hc.activeSocket = 2
							hc.socketPosition = [5,43]
							hc.socketName = getInputSocketName currentNode 2
							hc.connectionColor = getInputSocketColor currentNode 2
							
							if init do hc.addInSocket
							hc.activeSocket = 3
							hc.socketPosition = [5,56]
							hc.socketName = case currentNode[3][1] of
							(
								"Switch": "Condition"
								"Blend": "Blend Value"	
								default: "Input 3"
							)	
							if getInputSocketName currentNode 3 != "Input 3" do hc.socketName = getInputSocketName currentNode 3
							hc.connectionColor = getInputSocketColor currentNode 3
							
							if init do hc.addOutSocket
							hc.activeSocket = 4
							hc.socketName = currentNode[3][1]+" "
							hc.activeSocketShowValue = false
							hc.connectionColor = color 0 0 200
							hc.socketPosition = [110,18]
							hc.nodeSize = [NodeWidth,70]
							if currentNode[4][14] == true do 
							(
								try(hc.activeSocketFlipped  = true)catch()
							)								
						)
						
						hc.nodeCollapsedSize = [NodeWidth,15]	
						hc.activeNodeCollapsed  = currentNode[4][2] == true
						hc.isSelected = currentNode[4][3] == true
					)		
				)
			)--end loop
			if init do 
			(
				--Recreate all connections
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					local currentNode = KrakatoaChannelEditor_DisplayNodeTreeData[i]
					local theConnections = currentNode[2]
					for c = 1 to theConnections.count do
					(
						if theConnections[c] != undefined and theConnections[c] > 0 do
						(
							hc.activeNode = theConnections[c]
							hc.activeSocket = hc.getSocketCount
							hc.toggleConnection = [i,c]
						)	
					)
				)
			)
			drawDepot init:init
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
			hc.redrawView	
		)
		
		fn handleDepotDragAndDrop =
		(
			local returnValue = false
			if DepotPlacement == #off do return false
			for i = 1 to theDepotNodes.count do
			(
				hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count+i
				
				if theDepotNodes[i][4] != undefined do
				(
					if (DepotPlacement==#left and hc.activeNodePos.x > theDepotNodes[i][4].x) or ((DepotPlacement==#bottom or DepotPlacement==#bottomrollup or DepotPlacement==#bottomrollupreverse )and hc.activeNodePos.y < theDepotNodes[i][4].y) do
					(
--						format "% % % %\n" hc.activeNode hc.activeNodePos i theDepotNodes[i]
						lastMouseClick = mouse.screenpos - [NodeWidth/2,0]
						setSelectedNodes lastSelectionBeforeClick
						case theDepotNodes[i][1] of
						(
							"IN": addNewInput type:theDepotNodes[i][5] valuetype:theDepotNodes[i][6] creationType:#rcmenu
							"OP": addNewOperator type:theDepotNodes[i][5] creationType:#rcmenu
							"BLOP": addNewBLOP creationType:#rcmenu useFile:true createUndo:true
							"UBLOP": addNewBLOP creationType:#rcmenu useFile:false createUndo:true theFile:theDepotNodes[i][5]
							"CN": addNewInput type:theDepotNodes[i][5] valuetype:theDepotNodes[i][6] creationType:#rcmenu
						)	
						returnValue = true
						if DepotAutoCollapseOnDragAndDrop do
						(
							for j = 1 to theDepotNodesArray.count where theDepotNodesArray[j][1][1]  == "HEAD" do
								theDepotNodesArray[j][1][6] = false		
							updateDepotDefinition()
							createNodeTree init:true
						)
						exit
					)	
				)
				hc.activeNodePos = theDepotNodes[i][4]
			)		
			hc.redrawView		
			returnValue			
		)
	
		
		fn setUndoRedoEnable = 
		(
			btn_redo.enabled = KrakatoaChannelEditor_LastUndoRecordNumber < (getFiles (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord.*")).count 
			btn_undo.enabled = KrakatoaChannelEditor_LastUndoRecordNumber > 1
		)
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--UNDO/REDO FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		fn updatePlaybackBar =
		(
			prg_bar.value = 100.0 * (currentMacroLine)/(KrakatoaChannelEditor_MacroRecording.count)
		)
		
		fn updateMacroRecorderControls =
		(
			val = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Size" )
			if val != OK do
			(
				NodePropsSR.height = if KrakatoaChannelEditor_MacroRecording.count > 0 then val.y-80 else val.y-49
				btn_RecorderToStart.visible = btn_RecorderBackOneStep.visible = chk_RecorderPlay.visible = btn_RecorderForwardOneStep.visible = btn_RecorderToEnd.visible = btn_RecorderClose.visible = KrakatoaChannelEditor_MacroRecording.count > 0 
			)	
			--btn_RecorderToStart.enabled = currentMacroLine > 1 
			--btn_RecorderToEnd.enabled = currentMacroLine < KrakatoaChannelEditor_MacroRecording.count
			updatePlaybackBar()
		)		
		
		
		fn createUndoRecord undoText playbackDuration:1.0=
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\") all:true
			local theCount = (getFiles (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord.*")).count
			if KrakatoaChannelEditor_LastUndoRecordNumber < theCount do 
			(
				for i = KrakatoaChannelEditor_LastUndoRecordNumber+1 to theCount do
				(
					deleteFile (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + i as string)
				)
			)
			KrakatoaChannelEditor_LastUndoRecordNumber +=1
			KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber] = undoText
			
			local theFileName = GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + KrakatoaChannelEditor_LastUndoRecordNumber as string
			local theFileHandle = createFile theFileName
			
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1] == "Script" do
				KrakatoaChannelEditor_DisplayNodeTreeData[i][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_DisplayNodeTreeData[i][4][6])
			
			with PrintAllElements true	format "global KrakatoaChannelEditor_NodeTreeData = %\n" KrakatoaChannelEditor_DisplayNodeTreeData to:theFileHandle 
			with PrintAllElements true	format "global KrakatoaChannelEditor_NodeTreeEditingLevel = %\n" KrakatoaChannelEditor_NodeTreeEditingLevel to:theFileHandle 
			with PrintAllElements true	format "global KrakatoaChannelEditor_NodeTreeEditingNames = %\n" KrakatoaChannelEditor_NodeTreeEditingNames to:theFileHandle 
			with PrintAllElements true	format "global KrakatoaChannelEditor_NodeTreeEditingUndoLevel = %\n" KrakatoaChannelEditor_NodeTreeEditingUndoLevel to:theFileHandle 
			format "global KrakatoaChannelEditor_PlaybackDuration = %\n" playbackDuration to:theFileHandle 
			format "global KrakatoaChannelEditor_UndoRecordName = \"%\"\n" undoText to:theFileHandle 

			close theFileHandle
			
			KrakatoaChannelEditor_DisplayNodeTreeData = execute ( with PrintAllElements true KrakatoaChannelEditor_DisplayNodeTreeData as string)
			--KrakatoaChannelsEditor_Functions.buildDisplayTree()
			setUndoRedoEnable()
			try(hc.setInfo = KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber])catch()
			try
			(
				KrakatoaChannelNodeEditor_CurrentModifier.currentPreset == "Custom"
				KrakatoaChannelNodeEditor_CurrentModifier.main_rollout.ddl_currentPreset.selection = 1
			)catch()
		)
		

		
		
		
		fn undoLastStep =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			if KrakatoaChannelEditor_LastUndoRecordNumber > 1 do
			(
				KrakatoaChannelEditor_LastUndoRecordNumber -= 1
				try
				(
					fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + KrakatoaChannelEditor_LastUndoRecordNumber as string)
					KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
					--KrakatoaChannelsEditor_Functions.buildDisplayTree()					
					createNodeTree init:true
				)catch()

			)	
			try(hc.setInfo = "Undo '" + KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber+1]+"'")catch()
			setUndoRedoEnable()
			displaySelectedNodeProperties()
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			KrakatoaChannelsEditor_Functions.updateEditorTitle()
		)
		
		fn undoToRecord theRecord =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			try
			(
				fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + (theRecord-1) as string)
				KrakatoaChannelEditor_LastUndoRecordNumber = theRecord-1
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
				--KrakatoaChannelsEditor_Functions.buildDisplayTree()					
				createNodeTree init:true
			)catch()
			
			try(hc.setInfo = "Undo To '" +KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber]+"'")catch()
			setUndoRedoEnable()		
			displaySelectedNodeProperties()		
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()			
			KrakatoaChannelsEditor_Functions.updateEditorTitle()
		)
		
		fn redoToRecord theRecord =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			try
			(
				fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + (theRecord) as string)
				KrakatoaChannelEditor_LastUndoRecordNumber = theRecord
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
				--KrakatoaChannelsEditor_Functions.buildDisplayTree()					
				createNodeTree init:true
			)catch()
			try(hc.setInfo = "Redo to '" + KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber]+"'")catch()
			setUndoRedoEnable()		
			displaySelectedNodeProperties()			
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			KrakatoaChannelsEditor_Functions.updateEditorTitle()
		)		
		
		
		fn redoLastStep =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			if KrakatoaChannelEditor_LastUndoRecordNumber < (getFiles (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord.*")).count do
			(
				KrakatoaChannelEditor_LastUndoRecordNumber += 1
				try
				(
					fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + KrakatoaChannelEditor_LastUndoRecordNumber as string)
					KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
					--KrakatoaChannelsEditor_Functions.buildDisplayTree()					
					createNodeTree init:true				
				)catch()
			)
			try(hc.setInfo = "Redo '" + KrakatoaChannelEditor_UndoRecordNames[KrakatoaChannelEditor_LastUndoRecordNumber]+"'")catch()
			setUndoRedoEnable()
			displaySelectedNodeProperties()
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			KrakatoaChannelsEditor_Functions.updateEditorTitle()
		)			

		fn convertUndoBufferToRecording =
		(
			local theMacroFilename = getSaveFileName caption:"Save Macro Recording" types:"Krakatoa Channels Editor Recording (*.kcr)|*.kcr"
			if theMacroFilename != undefined do
			(
				--createUndoRecord "Save MacroRecord"
				KrakatoaChannelEditor_MacroRecording = #()
				for i = 1 to KrakatoaChannelEditor_LastUndoRecordNumber do
				(
					fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + i as string)
					append KrakatoaChannelEditor_MacroRecording #(deepCopy KrakatoaChannelEditor_NodeTreeData, deepCopy KrakatoaChannelEditor_NodeTreeEditingLevel, deepCopy KrakatoaChannelEditor_NodeTreeEditingNames, deepCopy KrakatoaChannelEditor_NodeTreeEditingUndoLevel, KrakatoaChannelEditor_PlaybackDuration, KrakatoaChannelEditor_UndoRecordName)
				)
				local theFileHandle = createFile theMacroFilename
				with PrintAllElements true format "global KrakatoaChannelEditor_MacroRecording = %\n" KrakatoaChannelEditor_MacroRecording to:theFileHandle 
				close theFileHandle
			)
			updateMacroRecorderControls()
			--fileIn (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\UndoRecord." + KrakatoaChannelEditor_LastUndoRecordNumber as string)
			--KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
		)
		
		timer tmr_macroPlayback interval:1000 active:false
		
		fn LoadMacroRecording =
		(
			local theMacroFilename = getOpenFileName caption:"Load Macro Recording" types:"Krakatoa Channels Editor Recording (*.kcr)|*.kcr"
			if theMacroFilename != undefined do
			(
				--createUndoRecord "Load MacroRecording"
				fileIn theMacroFilename
				currentMacroLine = 0
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_MacroRecording[KrakatoaChannelEditor_MacroRecording.count][1]
				KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading KrakatoaChannelEditor_DisplayNodeTreeData 
				createNodeTree init:true
				--KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_MacroRecording[1][1]
				--createNodeTree init:true
			)
			updateMacroRecorderControls()
		)
		
		fn PlayBackRecording = 
		(
			tmr_macroPlayback.active = true
			chk_RecorderPlay.text = "||||"
			chk_RecorderPlay.checked = true
		)
		
		fn StopPlayBackRecording =
		(
			tmr_macroPlayback.active = false
			chk_RecorderPlay.text = "|>"
			chk_RecorderPlay.checked = false
		)
		
		local lastDelay  = 1.0
		fn PlayRecordLine =
		(
--			if currentMacroLine <= KrakatoaChannelEditor_MacroRecording.count then
			(
				KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_MacroRecording[currentMacroLine][1]
				KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading KrakatoaChannelEditor_DisplayNodeTreeData 
				KrakatoaChannelEditor_NodeTreeEditingLevel = KrakatoaChannelEditor_MacroRecording[currentMacroLine][2]
				KrakatoaChannelEditor_NodeTreeEditingNames = KrakatoaChannelEditor_MacroRecording[currentMacroLine][3]
				KrakatoaChannelEditor_NodeTreeEditingUndoLevel = KrakatoaChannelEditor_MacroRecording[currentMacroLine][4]
				hc.setInfo = KrakatoaChannelEditor_MacroRecording[currentMacroLine][6] as string
				
				createNodeTree init:true
				displaySelectedNodeProperties()
				
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false	
					
				if chk_autoUpdateModifier.checked do 
					KrakatoaChannelNodeEditor_CurrentModifier.flow = KrakatoaChannelsEditor_Functions.expandFlow (with PrintAllElements true KrakatoaChannelEditor_DisplayNodeTreeData as string)
				
				updatePlaybackBar()
				--sleep (lastDelay)
				--tmr_macroPlayback.interval = lastDelay*1000
				--lastDelay = KrakatoaChannelEditor_PlaybackDuration
			)			
			/*
			else
			(
				KrakatoaChannelsEditor_Functions.buildDisplayTree()		
				createNodeTree init:true					
				tmr_macroPlayback.active = false
				currentMacroLine = 0
				--undoLastStep()
			)
			*/
		)
		
		fn StepForwardMacroRecording =
		(
			if currentMacroLine < KrakatoaChannelEditor_MacroRecording.count do
			(
				currentMacroLine += 1
				PlayRecordLine()
			)	
		)
		fn StepBackMacroRecording =
		(
			if currentMacroLine > 1 do
			(
				currentMacroLine -= 1
				PlayRecordLine()
			)	
		)
		
		on prg_bar clicked val do 
		(
			local theVal = floor(val/100.0*KrakatoaChannelEditor_MacroRecording.count+0.5)
			if theVal != currentMacroLine and theVal > 0 do
			(
				currentMacroLine = theVal 
				if currentMacroLine < 1 do currentMacroLine  = 1
				if currentMacroLine > KrakatoaChannelEditor_MacroRecording.count do currentMacroLine  = KrakatoaChannelEditor_MacroRecording.count
				PlayRecordLine()	
			)	
		)
		
		
		on tmr_macroPlayback tick do
		(
			if currentMacroLine < KrakatoaChannelEditor_MacroRecording.count then
			(
				currentMacroLine += 1
				PlayRecordLine()
			)	
			else
			(
				StopPlayBackRecording()
				KrakatoaChannelsEditor_Functions.buildDisplayTree()		
				createNodeTree init:true					
			)
		)
		
		on btn_RecorderToStart pressed do 
		(
			currentMacroLine = 1
			PlayRecordLine()			
		)	
		on btn_RecorderToEnd pressed do 
		(
			currentMacroLine = KrakatoaChannelEditor_MacroRecording.count
			PlayRecordLine()
		)	
			
		on btn_RecorderBackOneStep pressed do StepBackMacroRecording()
		on btn_RecorderForwardOneStep pressed do StepForwardMacroRecording()

		--on chk_RecorderStop pressed do StopPlayBackRecording()
		on chk_RecorderPlay changed state do 
		(
			if state then 
			(
				PlayBackRecording() 
			)	
			else 
			(
				StopPlayBackRecording()
			)
		)	
		
		on btn_RecorderClose pressed do 
		(
			currentMacroLine = 1
			KrakatoaChannelEditor_MacroRecording = #()
			updateMacroRecorderControls()
		)
		
		fn createUndoRCMenu =
		(
			global KrakatoaChannelEditor_UndoRCMenu
			local txt = "rcmenu KrakatoaChannelEditor_UndoRCMenu (\n"
			for i = KrakatoaChannelEditor_LastUndoRecordNumber to 2 by -1 do
			(
				txt += "menuItem mnu_"+ i as string + " \"" + KrakatoaChannelEditor_UndoRecordNames[i] + "\"\n"
				txt += "on mnu_"+ i as string + " picked do KrakatoaChannelNodeEditor_Rollout.undoToRecord "+ i as string + "\n"
			)	
			txt += ")\n"
			execute txt
		)
		
		fn createRedoRCMenu =
		(
			global KrakatoaChannelEditor_UndoRCMenu
			local txt = "rcmenu KrakatoaChannelEditor_UndoRCMenu (\n"
			for i = KrakatoaChannelEditor_LastUndoRecordNumber+1 to KrakatoaChannelEditor_UndoRecordNames.count do
			(
				txt += "menuItem mnu_"+ i as string + " \"" + KrakatoaChannelEditor_UndoRecordNames[i] + "\"\n"
				txt += "on mnu_"+ i as string + " picked do KrakatoaChannelNodeEditor_Rollout.redoToRecord "+ i as string + "\n"
			)	
			txt += ")\n"
			execute txt
		)	

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--NODE PROPERTIES FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		fn displaySelectedNodeProperties =
		(
			for i = NodePropsSR.rollouts.count to 1 by -1 do 
				removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
			if hc.selectedNodeIndex > 0 and hc.getSelectionCount == 1 and  KrakatoaChannelEditor_DisplayNodeTreeData[hc.selectedNodeIndex] != undefined do
			(
				lastNodeClick = hc.selectedNodeIndex 
				case KrakatoaChannelEditor_DisplayNodeTreeData[hc.selectedNodeIndex][1] of
				(
					"Input": 
					(
						try
						(
							global KrakatoaChannelEditor_CurrentIntController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[hc.selectedNodeIndex][3][3]+"[1].controller")
							global KrakatoaChannelEditor_CurrentFloatController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[hc.selectedNodeIndex][3][3]+"[2].controller")
							global KrakatoaChannelEditor_CurrentVectorController = execute (KrakatoaChannelEditor_DisplayNodeTreeData[hc.selectedNodeIndex][3][3]+"[3].controller")
						)
						catch
						(
							global KrakatoaChannelEditor_CurrentIntController = 	bezier_float()
							global KrakatoaChannelEditor_CurrentFloatController = 	bezier_float()
							global KrakatoaChannelEditor_CurrentVectorController = point3_xyz()
						)	
						local theState = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "NodeNameRolloutRolledup")
						if theState == OK do theState = false
						KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_NodeNameRollout rolledup:(not theState)
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_InputRollout rolledup:false
						KrakatoaChannelsEditor_isInitializing = false
					)
					"Output": 
					(
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OutputRollout rolledup:false
					)
					"Operator": 
					(
						local theState = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "NodeNameRolloutRolledup")
						if theState == OK do theState = false
							KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_NodeNameRollout rolledup:(not theState)
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OperatorRollout rolledup:false
						local theState = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "OperatorDescriptionRolloutRolledup")
						if theState == OK do theState = false
							KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OperatorDescriptionRollout rolledup:(not theState)
						KrakatoaChannelsEditor_isInitializing = false
					)	
					"BlackOp":
					(
						local theState = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "NodeNameRolloutRolledup")
						if theState == OK do theState = false
						KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_NodeNameRollout rolledup:(not theState)
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_BlackOpsRollout rolledup:false
						KrakatoaChannelsEditor_isInitializing = false
					)
					"Connector":
					(
						KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_ConnectorRollout rolledup:false
						KrakatoaChannelsEditor_isInitializing = false
					)
					"OutputConnector":
					(
						KrakatoaChannelsEditor_isInitializing = true
						addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OutputConnectorRollout rolledup:false
						KrakatoaChannelsEditor_isInitializing = false
					)					
				)
			)		
			addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OptionsRollout rolledup:true
			setFocus hc
		)
		
		fn displayOptions =
		(
			for i = NodePropsSR.rollouts.count to 1 by -1 do 
				removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
			addSubRollout NodePropsSR KrakatoaChannelNodeEditor_OptionsRollout rolledup:false
		)

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--PAN AND ZOOM FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		fn resetPanFactor =
		(
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Pan" "[0,0]"	
			hc.pan = [0,0]
			createNodeTree init:false			
		)		
		
		fn resetZoomFactor =
		(
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Zoom" "1"	
			hc.zoom = 1
			createNodeTree init:false
		)
		
		fn ZoomExtents createUndo:true=
		(
			local minX = 1000000
			local maxX =-1000000
			local minY = 1000000
			local maxY =-1000000
			
			if KrakatoaChannelEditor_DisplayNodeTreeData.count > 2 then
			(
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					local theVal = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1]
					if theVal.x+150 > maxX do maxX = theVal.x+150
					if theVal.y+100 > maxY do maxY = theVal.y+100
					if theVal.x < minX do minX = theVal.x 
					if theVal.y < minY do minY = theVal.y
				)
				minY -=40
				theBBoxX = maxX-minX
				theBBoxY = maxY-minY
				theHCWidth = hc.width-leftDepotMargin
				hc.zoom = amin #(1.0*theHCWidth/theBBoxX,1.0*hc.height/theBBoxY)
				if hc.zoom > 1.5 do hc.zoom = 1.5
				hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
			)
			else
			(
				hc.zoom = 1.0
				hc.pan = [0,0]
			)
			createNodeTree init:false
			if createUndo do createUndoRecord ("Zoom Extents")
		)
		
		fn ZoomExtentsSelected createUndo:true =
		(
			local minX = 1000000
			local maxX =-1000000
			local minY = 1000000
			local maxY =-1000000
			local doZoom = 0
			if KrakatoaChannelEditor_DisplayNodeTreeData.count > 2 then
			(
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					hc.ActiveNode = i
					if hc.isSelected do
					(
						doZoom += 1
						local theVal = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1]
						if theVal.x+150 > maxX do maxX = theVal.x+150
						if theVal.y+100 > maxY do maxY = theVal.y+100
						if theVal.x < minX do minX = theVal.x 
						if theVal.y < minY do minY = theVal.y
					)		
				)
				if doZoom > 1 do
				(
					minY -=40
					theBBoxX = maxX-minX
					theBBoxY = maxY-minY
					hcWidth = hc.width-leftDepotMargin
					hc.zoom = amin #(1.0*hcWidth/theBBoxX,1.0*hc.height/theBBoxY)
					if hc.zoom > 1.5 do hc.zoom = 1.5
					hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
				)
				if doZoom == 1 do 
				(
					minY -= 40
					--minX -= hc.width/4
					theBBoxX = maxX-minX
					theBBoxY = maxY-minY			
					hc.zoom = amin #(1.0*hc.width/theBBoxX,1.0*hc.height/theBBoxY)					
					if hc.zoom > 1.5 do hc.zoom = 1.5
					hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
				)
			)
			createNodeTree init:false
			if createUndo do createUndoRecord ("Zoom Extents Selected")
		)		
		
		local theGridMap = #()
		local theMap = #{}
		
		fn setNodePositionRecursiveTree theNodeIndex theRefPos theXOffset maxLinks=
		(
			if theMap[theNodeIndex] == true do return false
			theActualOffset = case of
			(
				(maxLinks == 1): 0
				(maxLinks == 2): if theXOffset == 1 then -1 else 0
				(maxLinks == 3): if theXOffset == 1 then -1 else if theXOffset == 2 then 0 else 1
				default: ((theXOffset-maxLinks/2.0) as integer)
			)
			local theNewX = theRefPos.x-theActualOffset
			local theNewY = theRefPos.y+2
			while try(theGridMap[theNewX][theNewY] != undefined)catch(false) do theNewX -= 1
--			while theGridMap[theNewX][theNewY] == true do theNewY += 1
			theGridMap[theNewX][theNewY] = theNodeIndex
			
			
			if KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex] != undefined do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][4][14] = theActualOffset <= 0 
				local theLinks = for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2].count where KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][i] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][i] > 0 collect i
				theLinks = (theLinks as bitarray) as array
				
				local additionalYOffset = if KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][1] == "BlackOp" then
				(
					theSocketCount = (for j in KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][3][2] where j[1] == "Connector" collect j).count
					if theSocketCount > 3 then ((theSocketCount-2)/2) as integer else 0
				)else 0
				
				for j = theNewY to theNewY+additionalYOffset+1 do theGridMap[theNewX][j] = theNodeIndex
				
				for i = 1 to theLinks.count do
				(
					local theConnected = theLinks[i]
					if theConnected <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
						setNodePositionRecursiveTree KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][theConnected] [theNewX,theNewY+additionalYOffset] i theLinks.count
				)	
			)	
			theMap[theNodeIndex] = true
		)
		
		fn setNodePositionRecursive theNodeIndex theRefPos =
		(
			if theMap[theNodeIndex] == true do return false
			if AutoReorderPattern != #rowtopalign do 
				while theGridMap[theRefPos.x].count < theRefPos.y-1 do append theGridMap[theRefPos.x] 0
			append theGridMap[theRefPos.x] theNodeIndex
			theYIndex = theGridMap[theRefPos.x].count
			if theYIndex > 1 and (try(KrakatoaChannelEditor_DisplayNodeTreeData[theGridMap[theRefPos.x][theYIndex-1]][1] == "Operator" and not KrakatoaChannelEditor_DisplayNodeTreeData[theGridMap[theRefPos.x][theYIndex-1]][4][2])catch(false)) do 
				append theGridMap[theRefPos.x] theNodeIndex

			if theYIndex > 1 and (try(KrakatoaChannelEditor_DisplayNodeTreeData[theGridMap[theRefPos.x][theYIndex-1]][1] == "BlackOp" and not KrakatoaChannelEditor_DisplayNodeTreeData[theGridMap[theRefPos.x][theYIndex-1]][4][2])catch(false)) do 
			(
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[theGridMap[theRefPos.x][theYIndex-1]][2].count*0.7 do
				(
					append theGridMap[theRefPos.x] theNodeIndex
				)	
			)
			if KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex] != undefined do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][4][14] = false
				local theLinks = for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2].count where KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][i] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][i] > 0 collect i
				theLinks = (theLinks as bitarray) as array
				for i = 1 to theLinks.count do
				(
					local theConnected = theLinks[i]
					if theConnected <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
						setNodePositionRecursive KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][2][theConnected] [theRefPos.x+1,theYIndex]
				)	
			)	
			theMap[theNodeIndex] = true
		)
		
		fn weightedReorder theIndex =
		(
			local thePos = KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][1]
			local theAverageY = 0
			local theAverageCount = 0
			for i in KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][2] where i != undefined and i > 0 and i <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				weightedReorder i
				hc.ActiveNode = i
				local thePos = KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1].y
				local theHeight = if KrakatoaChannelEditor_DisplayNodeTreeData[i][4][2] then hc.nodeCollapsedSize.y else hc.nodeSize.y
				theAverageY += thePos+theHeight*0.5
				theAverageCount += 1
			)
			if theAverageCount > 0 do 
			(
				thePos.y = theAverageY/theAverageCount 
				hc.ActiveNode = theIndex
				if theAverageCount > 1 do thePos.y -= if KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][2] then hc.nodeCollapsedSize.y/2 else hc.nodeSize.y/2
				KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][1] = thePos
			)
		)
		local fixedOverlapping = false
		fn fixOverlapping theIndex =
		(
			--if KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][1] == "Input" do return false
			local thePos1 = KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][1]
			hc.ActiveNode = theIndex
			local theHeight1 = if KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][2] then hc.nodeCollapsedSize.y else hc.nodeSize.y
			for j = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				if theIndex != j do
				(
					thePos2 =  KrakatoaChannelEditor_DisplayNodeTreeData[j][4][1]
					hc.ActiveNode = j
					local theHeight2 = if KrakatoaChannelEditor_DisplayNodeTreeData[j][4][2] then hc.nodeCollapsedSize.y else hc.nodeSize.y
					theBox2 = (Box2 thePos2 (thePos2+[100,theHeight2]))
					if contains theBox2 thePos1 do 
					(
						thePos1.y = thePos2.y + theHeight2 + 10 
						KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][1] = thePos1
						fixedOverlapping = true
					)
					if contains theBox2 (thePos1+[100,theHeight1]) do
					(
						thePos1.y = thePos2.y - theHeight1 - 10
						KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][4][1] = thePos1						
						fixedOverlapping = true
					)
				)	
			)			
			for i in KrakatoaChannelEditor_DisplayNodeTreeData[theIndex][2] where i != undefined and i > 0 and i <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				fixOverlapping i
			)		
			true			
		)
		
		local alignAllNodesToGrid
		
		fn autoReorderFlow createUndo:true =
		(
			theMap = #{}
			alreadyProcessed = #{}
			theGridMap = #()
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] = true
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count*10 do append theGridMap #()
			local theOutputIndex = 1
			if KrakatoaChannelEditor_DisplayNodeTreeData[1][1] != "Output" then 
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do 
					if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[i][1] pattern:"*Output*" do (theOutputIndex = i; exit)
			
			if AutoReorderPattern == #tree then
			(
				theMapOffset = KrakatoaChannelEditor_DisplayNodeTreeData.count
				setNodePositionRecursiveTree theOutputIndex [theMapOffset,-1] 0 1
			)	
			else
			(
				theMapOffset = 3
				setNodePositionRecursive theOutputIndex [1,1]
			)	
			
			local theOffset = case UnconnectedNodesPlacement of
			(
				default: [0,0]
				#right: [NodeWidth+NodeXSpace,0]
			)
			for x = 1 to theGridMap.count do
			(
				for y = 1 to theGridMap[x].count do
				(
					local theNodeIndex = theGridMap[x][y]
					if theNodeIndex != undefined and theNodeIndex > 0 and KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex] != undefined and not alreadyProcessed[theNodeIndex] do
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][4][1] = [(KrakatoaChannelNodeEditor_Rollout.hc.width+NodeXSpace)-(x-theMapOffset+2)*(NodeWidth+NodeXSpace), 10+y*40] - theOffset
						theMap[theNodeIndex] = true
						alreadyProcessed[theNodeIndex] = true
					)	
				)
			)
			
			if AutoReorderPattern == #rowweighted do 
			(
				weightedReorder 1
				local DoneFixing = false
				local cnt = 0
				while not DoneFixing do 
				(
					cnt +=1
					fixedOverlapping = false
					fixOverlapping 1
					if cnt > 50 or fixedOverlapping == false do DoneFixing  = true
				)
				--format "% iterations\n" cnt
			)
			
			try
			(
				local theXArray = (for i in theMap collect KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1].x)
				local theYArray = (for i in theMap collect KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1].y)
			)catch(theXArray = theYArray = #(100))	
			local minX = amin theXArray
			local minY = amin theYArray 
			local maxX = amax theXArray
			local maxY = amax theYArray 
			
			local cnt = 0
			local cnt2 = 1
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where theMap[i] == false do 
			(
				case UnconnectedNodesPlacement of
				(
					#left: (
						KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = [minX, minY] + [-cnt2*(NodeWidth+NodeXSpace),cnt*40]
						cnt += if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Operator"  then 2 else 1
					)		
					#right: (
						KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = [maxX, minY] + [(cnt2-1)*(NodeWidth+NodeXSpace),cnt*40]
						cnt += if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Operator"  then 2 else 1
					)	
					#bottom: (
						KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = [maxX, maxY] + [-(cnt+1)*(NodeWidth+NodeXSpace),40*cnt2]
						cnt += 1
					)
				)	
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] = false
				if UnconnectedNodesPlacement == #bottom and cnt > KrakatoaChannelNodeEditor_Rollout.hc.width/(NodeWidth+NodeXSpace) do
				(
					cnt = 0
					cnt2 += 1
				)
				if UnconnectedNodesPlacement == #left and cnt > KrakatoaChannelNodeEditor_Rollout.hc.height/80 do
				(
					cnt = 0
					cnt2 += 1
				)							
			)
			createNodeTree init:true
			alignAllNodesToGrid createUndo:false
			if createUndo do createUndoRecord ("Reorder Nodes")
		)
		
		local stopRecursion = 0
		fn followFlowRecursive theParent TheChild =
		(
			for i in KrakatoaChannelEditor_DisplayNodeTreeData[TheChild][2] where i != undefined and i > 0 do
			(
				if theParent != i then
					followFlowRecursive theParent i
				else
					stopRecursion = theParent
			)	
		)
		
		fn checkForCyclicConnections =
		(
			for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				stopRecursion = 0
				followFlowRecursive i i
				if stopRecursion > 0 do 
				(
					logInfo ("Prevented Circular Loop Connection In Node " + stopRecursion as string + "...")
					exit
				)
			)
			stopRecursion
		)
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--DELETE NODES FUNCTIONS--
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		fn deleteSelectedNodes createUndo:true=
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			theIndices = for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count collect 
			(
				hc.ActiveNode = i
				if hc.isSelected then i else dontcollect
			)
			sort theIndices
			for index in theIndices.count to 1 by -1 do
			(
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[i][2].count do
					(
						if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] == theIndices[index] do
							KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] = 0
						if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > theIndices[index] do
							KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] -= 1
					)	
				)
				deleteItem KrakatoaChannelEditor_DisplayNodeTreeData theIndices[index]
			)				
			createNodeTree init:true	
			if AutoReorderToggle do autoReorderFlow createUndo:false
			if AutoZoomExtents do zoomExtents createUndo:false
			if createUndo do 	
				if theIndices.count == 1 then
					createUndoRecord ("Delete One Selected Node")
				else
					createUndoRecord ("Delete " + theIndices.count as string + " Selected Nodes")
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			displaySelectedNodeProperties()
		)
		
		
		fn removeNode deleteTheNode:true=
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			theIndices = for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count collect 
			(
				hc.ActiveNode = i
				if hc.isSelected then i else dontcollect
			)
			if theIndices.count > 0 do
			(
				sort theIndices
				for index in theIndices.count to 1 by -1 do
				(
					hc.ActiveNode = theIndices[index]
					if KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[index]][2][1] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[index]][2][1] > 1 do
					(
						hc.activeSocket = hc.getSocketCount
						local theConnectionIndices = hc.getActiveSocketConnectingNodeIndices
						if theConnectionIndices.count == 1 do
						(
							local theIndex = try(findItem KrakatoaChannelEditor_DisplayNodeTreeData[theConnectionIndices[1]][2] theIndices[index])catch(0)
							if theIndex > 0 do
								KrakatoaChannelEditor_DisplayNodeTreeData[theConnectionIndices[1]][2][theIndex] = KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[index]][2][1]
						)	
					)				
					for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
					(
						for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[i][2].count do
						(
							if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] == theIndices[index] do
								KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] = 0
							
							if deleteTheNode and KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] != undefined and KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > theIndices[index] do
								KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] -= 1
						)	
					)
					if deleteTheNode then
						deleteItem KrakatoaChannelEditor_DisplayNodeTreeData theIndices[index]
					else
						KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[index]][2]=#(0,0,0)
				)				
				createNodeTree init:true	
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false
				if theIndices.count  == 1 then
					createUndoRecord ("Remove Selected Node" + (if not deleteTheNode then " from Flow." else ".") )	
				else
					createUndoRecord ("Remove " + theIndices.count as string + " Selected Nodes" + (if not deleteTheNode then " from Flow" else ""))	
				displaySelectedNodeProperties()		
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()			
			)	
		)

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--ADDING NODES FUNCTIONS
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		local lastSelection = #()
		fn updateNodeSelection createUndo:true = 
		(
			hc.drawLastIndex = 1
			for i = KrakatoaChannelEditor_DisplayNodeTreeData.count to 1 by -1 do 
			(
				hc.activeNode = i	
				if hc.isSelected do 
				(
					hc.drawLastIndex = i
					if SnapToGrid == true do
					(
						thePos = hc.activeNodePos
						thePos.x = (floor (thePos.x/GridSizeX))*GridSizeX
						thePos.y = (floor (thePos.y/GridSizeY))*GridSizeY
						hc.activeNodePos = thePos
					)
				)	
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = hc.activeNodePos
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][2] = hc.activeNodeCollapsed 
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][3] = hc.isSelected 
			)
			if lastSelection as string != (getSelectedNodes()) as string do
			(
				lastSelection = getSelectedNodes()
				if createUndo do 
					case of
					(
						(lastSelection.count == 0): createUndoRecord ("Select No Nodes")
						(lastSelection.count == 1): createUndoRecord ("Select "+ KrakatoaChannelEditor_DisplayNodeTreeData[lastSelection[1]][1] + " Node ["+ KrakatoaChannelEditor_DisplayNodeTreeData[lastSelection[1]][4][8] as string +"]")
						(lastSelection.count > 1): createUndoRecord ("Select "+lastSelection.count as string+ " Nodes")
					)	
				displaySelectedNodeProperties()
			)
			hc.redrawView
		)		
		

		
		fn deleteTrackViewControllers nodeID =
		(
			theRootNode = try(trackViewNodes.KrakatoaChannelEditor)catch(newTrackViewNode "KrakatoaChannelEditor")
			theID = KrakatoaChannelNodeEditor_CurrentModifier.trackID
			theModTrack = try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+theID))catch(newTrackViewNode theRootNode ("KCE_"+theID))
			theNodeTrack = try(execute ("trackViewNodes.KrakatoaChannelEditor.KCE_"+theID+".Input_"+nodeID as string))catch(newTrackViewNode theModTrack ("Input_"+nodeID as string) )
			deleteTrackViewNode theModTrack theNodeTrack
		)
		
		fn connectSelectedNodes =
		(
			local theSelection = getSelectedNodes()
			if theSelection.count == 2 do
			(
				local theTarget = undefined
				local theSource = undefined
				if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] pattern:"Output" then
				(
					theTarget = theSelection[1]
					theSource = theSelection[2]
				)					
				else if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[2]][1] pattern:"Output" then
				(
					theTarget = theSelection[2]
					theSource = theSelection[1]					
				)
				else if not keyboard.shiftPressed then
				(
					if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[2]][1] pattern:"*Op*" then 
					(
						theTarget = theSelection[2]
						theSource = theSelection[1]
					)	
					else if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] pattern:"*Op*" then 
					(
						theTarget = theSelection[1]
						theSource = theSelection[2]
					)						
				)
				else
				(
					if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] pattern:"*Op*" then 
					(
						theTarget = theSelection[1]
						theSource = theSelection[2]
					)	
					else if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[2]][1] pattern:"*Op*" then 
					(
						theTarget = theSelection[2]
						theSource = theSelection[1]
					)	
				)	
				if theTarget != undefined do
				(
					local theSockets = KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2]
					if matchPattern KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][1]  pattern:"Output" then
					(
						local oldStatus = for i in KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2] collect i
						KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2] = #(theSource)
						checkForCyclicConnections() 
						if stopRecursion > 0 do KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2] = oldStatus						
					)
					else 
					(
						local maxSocketCount = getInputCount KrakatoaChannelEditor_DisplayNodeTreeData[theTarget]
						for j = 1 to maxSocketCount do
						(
							if theSockets[j] == undefined or theSockets[j] < 1 then
							(
								local oldStatus = for i in KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2] collect i
								KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2][j] = theSource
								checkForCyclicConnections() 
								if stopRecursion > 0 do KrakatoaChannelEditor_DisplayNodeTreeData[theTarget][2] = oldStatus
								exit
							)
						)
					)	
					createNodeTree init:true
					if AutoReorderToggle do autoReorderFlow createUndo:false
					if AutoZoomExtents do zoomExtents createUndo:false	
					createUndoRecord "Connect Selected Nodes"					
				)	
			)
			lbx_log.items = #()
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()	
			createNodeTree init:false
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
		)
		
		fn getNewNodePosition type:#input =
		(
			local theSelection = getSelectedNodes()
			if theSelection.count == 0 do theSelection = for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count collect i
			if theSelection.count > 0 then
			(
				local theX = amin (for i in theSelection where i > 0 collect KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1].x)
				local theY = amax (for i in theSelection where i > 0 collect KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1].y)
				local theNode = for i in theSelection where KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] == [theX,theY] collect KrakatoaChannelEditor_DisplayNodeTreeData[i][1]
				local theNodeType = if theNode.count > 0 then theNode[1] else "Operator"
			)		
			else
			(
				theNodeType = "Input"
				local theX = 500
				local theY = 40
			)
			theY += if theNodeType == "Input" then 40 else 80
			local theCollisionNode = #(1)
			while theCollisionNode.count > 0 do
			(
				theCollisionNode = #()
				for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count do 
				(
					local theHeight = if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Input" then 30 else 70
					local theBox = Box2 KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] (KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1]+[100,theHeight])
					if contains theBox [theX,theY] do append theCollisionNode i
				)	
				--format "%\n" theCollisionNode 
				for i in theCollisionNode do 
				(
					local theNodeType = KrakatoaChannelEditor_DisplayNodeTreeData[i][1]
					theY += if theNodeType == "Input" then 40 else 80
				)
			)		
			[theX,theY]
		)
		
		fn addNewInput type:#channel valueType:#float channelName:"Color" creationType:#keyboard =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theSelection = getSelectedNodes()
			local thePos = if useMousePositionOnCreation or creationType==#rcmenu then 
				(lastMouseClick - (getDialogPos KrakatoaChannelNodeEditor_Rollout) - [0,40] - hc.pan) /hc.zoom
			else
				getNewNodePosition type:#input 
			seed (timestamp())
			local theNodeID = (random 10000 1000000) as string + "_" + (random 10000 1000000) as string
			case type of
			(
				#channel: append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Channel",channelName), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,channelName,channelName ) , true)
				#value: 
				(
					case valueType of
					(
						#integer: 	append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Value","Integer"), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"Integer","Color"), true)
						#float: 		append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Value","Float"), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"Float","Color"), true)
						#vector: 	append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Value","Vector"), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"Vector","Color"), true)
						#connector: 	append KrakatoaChannelEditor_DisplayNodeTreeData #("Connector", #(), #("Value","Value"), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"Connector","Color"), true)
					)	
				)	
				#time: append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Time","Frame",0), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"Time","Color"), true)
				#script: append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("Script","0"), #(thePos, false, true, #(0,0,[0,0,0]),undefined,"0",undefined,"Script","Color" ), true)
				#TextureMap: append KrakatoaChannelEditor_DisplayNodeTreeData #("Input", #(), #("TextureMap",1), #(thePos, false, true, #(0,0,[0,0,0]),undefined,undefined,undefined,"TextureMap","Color"), true)
			)	
			local theControllerSignature = KrakatoaChannelsEditor_Functions.createTrackViewControllers theNodeID KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count]
			if type == #value do 
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][3][3] = theControllerSignature
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][4][4] = theNodeID
			createNodeTree init:true
			hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count
			KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][4][3] = true

			case type of
			(
				#channel: createUndoRecord "Add Channel Input "
				#value: createUndoRecord "Add Value Input"
				#time: createUndoRecord "Add Time Input"
				#script: createUndoRecord "Add Script Input"
				#textureMap: createUndoRecord "Add TextureMap Input"
			)				
			
			if theSelection.count == 1 and (KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] == "Operator" or KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] == "BlackOp")  do
			(
				local maxSocketCount = getInputCount KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]]
				local theSockets = KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][2]
				local notConnected = true
				local cnt = 0
				local unconnectedCount = (for i in theSockets where i == undefined or i < 1 collect i).count
				if unconnectedCount >= maxSocketCount and type==#value and valueType==#float and KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][3][1] == "ToVector" then
				(
					for i = 1 to maxSocketCount do 
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][2][i] = hc.activeNode
						if AutoReorderToggle do autoReorderFlow createUndo:false
						if AutoZoomExtents do zoomExtents createUndo:false		
						createUndoRecord ("Auto-Connect Input Node To Operator's Input Socket "+i as string) playbackDuration:0.1
					)	
					KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][4][3] = false							
				)
				else
				(
					while notConnected do
					(
						cnt += 1
						if cnt <= maxSocketCount then
						(
							if (theSockets[cnt] == undefined or theSockets[cnt] < 1) do
							(
								KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][2][cnt] = hc.activeNode
								KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][4][3] = false
								notConnected = false
								if AutoReorderToggle do autoReorderFlow createUndo:false
								if AutoZoomExtents do zoomExtents createUndo:false		
								createUndoRecord ("Auto-Connect Input Node to Operator's Input Socket "+ cnt as string) playbackDuration:0.1
							)	
						)
						else
							notConnected = false
					)
					if cnt >= maxSocketCount do 
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3] = false
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][4][3] = true
					)
				)	
			)
			if theSelection.count == 1 and KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][1] == "Output" do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][2][1] = hc.activeNode
				KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3] = false
			)
				
			--KrakatoaChannelsEditor_Functions.buildDisplayTree()
			createNodeTree init:true
			--updateNodeSelection createUndo:false
			if AutoReorderToggle do autoReorderFlow createUndo:false
			if AutoZoomExtents do zoomExtents createUndo:false				
				

			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
			displaySelectedNodeProperties()
		)		
		

		
		fn addNewOperator type:""  creationType:#keyboard=
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theSelection = getSelectedNodes()
			local theType = if type == "" then "Add" else type
			local theConnectArray = if theSelection.count == 1 or theSelection.count == 2 or theSelection.count == 3 then 
			(
				if not keyboard.ShiftPressed do
				(
					hc.activeNode = theSelection[1]
					hc.activeSocket = hc.getSocketCount
					local theIndices = hc.getActiveSocketConnectingNodeIndices
					if theIndices.count == 1 do
					(
						local theIndex = findItem KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[1]][2] theSelection[1]
						if theIndex > 0 do
							KrakatoaChannelEditor_DisplayNodeTreeData[theIndices[1]][2][theIndex] = KrakatoaChannelEditor_DisplayNodeTreeData.count+1
					)
				)	
				case theSelection.count of
				(
					1: 
					(
						if type == "" then 
						(
							theType = case KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][3][2] of
							(
								"Vector": "Normalize"
								"Integer": "ToFloat"
								"Float": "Negate"
								"Density": "Negate"
								"Age": "ToFloat"
								"LifeSpan": "ToFloat"
								"ID": "ToFloat"
								"MtlIndex": "ToFloat"
								"MXSInteger": "ToFloat"
								"MXSFloat": "Negate"
								default: "Magnitude"
							)
							KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3]=false
							theReturnArray = deepCopy theSelection
							join theReturnArray #(0,0)
						)	
						else
						(
							KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3]=false
							theReturnArray = deepCopy theSelection
							join theReturnArray #(0,0)
						)
					)
					2: 
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3]=false
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[2]][4][3]=false
						theReturnArray = deepCopy theSelection
						join theReturnArray #(0)
					)
					3: 
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][3]=false
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[2]][4][3]=false
						KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[3]][4][3]=false
						if type == "" do theType = "Blend"
						theSelection
					)
				)	
			)	
			else
				#(0,0,0)
			if theConnectArray == undefined do theConnectArray = #(0,0,0)
			local thePos = if useMousePositionOnCreation or creationType==#rcmenu then 
				(KrakatoaChannelNodeEditor_Rollout.lastMouseClick - (getDialogPos KrakatoaChannelNodeEditor_Rollout) - [10, 50] - hc.pan) /hc.zoom
			else
				getNewNodePosition type:#operator	
			append KrakatoaChannelEditor_DisplayNodeTreeData #("Operator", #(0,0,0), #(theType), #(thePos,false,true,undefined,undefined,undefined,undefined,theType,theType), true)
			createUndoRecord ("Add ["+ theType +"] Operator")
			
			createNodeTree init:true
			if AutoReorderToggle do autoReorderFlow createUndo:false
			if AutoZoomExtents do zoomExtents createUndo:false		
				
			if theSelection.count == 1 and type == "ToVector" and KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][3][2] == "Float" then
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2][1] = theConnectArray[1]
				
				createUndoRecord ("AutoConnect First Input Socket") playbackDuration:0.1
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2][2] = theConnectArray[1]
				createUndoRecord ("AutoConnect Second Input Socket") playbackDuration:0.1
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2][3] = theConnectArray[1]
				createUndoRecord ("AutoConnect Third Input Socket") playbackDuration:0.1
			)			
			else
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2] = theConnectArray
				if theConnectArray as string != "#(0, 0, 0)" do createUndoRecord ("AutoConnect") playbackDuration:0.1
			)	
			
			createNodeTree init:true
			if AutoReorderToggle do autoReorderFlow createUndo:false
			if AutoZoomExtents do zoomExtents createUndo:false	
			hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count
			setSelectedNodes #(KrakatoaChannelEditor_DisplayNodeTreeData.count)
			displaySelectedNodeProperties()		
				
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
		)
		
	
		
--INPUT TWEAKING (SWAPPING, PASS THROUGH)	

		fn disconnectAllInputs single:false =
		(
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 			
			for i in theSelection do
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][2] = #(0,0,0)
			)		
			if theSelection.count > 0 do
			(
				createNodeTree init:true
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false	
				createUndoRecord "Delete All Inputs"
				if single == false do setSelectedNodes theSelection
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)		
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()			
		)
		
		fn disconnectAllOutputs single:false =
		(
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 			
			for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
			(
				for i in theSelection do
				(
					local theIndex = findItem KrakatoaChannelEditor_DisplayNodeTreeData[j][2] i
					if theIndex > 0 do KrakatoaChannelEditor_DisplayNodeTreeData[j][2][theIndex] = 0
				)		
			)
			if theSelection.count > 0 do
			(
				createNodeTree init:true
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false	
				createUndoRecord "Delete All Inputs"
				if single == false do setSelectedNodes theSelection
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)			
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()			
		)		
		
		
		fn swapInputsOrder single:false Last:false=
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 
			for i in theSelection do
			(
				if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Operator" do
				(
					if (Last==true OR keyboard.ShiftPressed) and findItem #("Blend","Clamp","ToVector","Switch") KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1] > 0 then
					(
						local temp = KrakatoaChannelEditor_DisplayNodeTreeData[i][2][2]
						KrakatoaChannelEditor_DisplayNodeTreeData[i][2][2] = KrakatoaChannelEditor_DisplayNodeTreeData[i][2][3]
						KrakatoaChannelEditor_DisplayNodeTreeData[i][2][3] = temp						
					)
					else
					(
						local temp = KrakatoaChannelEditor_DisplayNodeTreeData[i][2][2]
						KrakatoaChannelEditor_DisplayNodeTreeData[i][2][2] = KrakatoaChannelEditor_DisplayNodeTreeData[i][2][1]
						KrakatoaChannelEditor_DisplayNodeTreeData[i][2][1] = temp
					)	
				)
			)
			if theSelection.count > 0 do
			(
				createNodeTree init:true
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false	
				createUndoRecord "Swap Operator Inputs"
				if single == false do setSelectedNodes theSelection
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)	
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
		)
		
		/*
		fn swapOutputConnections =
		(
			local theSelection = getSelectedNodes()
			if theSelection.count == 2 do
			(
				
			)
		)
		*/
		
		fn setPassThrough single:false =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 
			for i in theSelection do
			(
				if KrakatoaChannelEditor_DisplayNodeTreeData[i][1] != "Output" do
				(
					if KrakatoaChannelEditor_DisplayNodeTreeData[i][5] != false then 
						KrakatoaChannelEditor_DisplayNodeTreeData[i][5] = false
					else
						KrakatoaChannelEditor_DisplayNodeTreeData[i][5] = true
				)	
			)
			if theSelection.count > 0 do
			(			
				createNodeTree init:false
				if theSelection.count == 1  then
					createUndoRecord ("Toggle Node ["+ KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][8] as string +"] " + (if KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][5] == false then "Off" else "On") )
				else
					createUndoRecord ("Toggle "+theSelection.count as string +" Nodes On/Off")
				if single == false do setSelectedNodes theSelection			
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)	
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
		)
		
		
		fn alignAllNodesToGrid createUndo:true =
		(
			for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do 
			(
				hc.activeNode = i	
				thePos = hc.activeNodePos
				thePos.x = (floor (thePos.x/GridSizeX))*GridSizeX
				thePos.y = (floor (thePos.y/GridSizeY))*GridSizeY
				hc.activeNodePos = thePos
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = hc.activeNodePos
			)	
			createNodeTree init:false
			if createUndo do createUndoRecord ("Align All Nodes To Grid (" + GridSizeX as string + "x" + GridSizeY as string+")")
		)


		fn showGrid enabled =
		(
			local theX = GridSizeX*hc.zoom
			local theY = GridSizeY*hc.zoom

			local theBitmap = bitmap theX theY color:theBackgroundColor 
			
			if enabled and hc.zoom > 0.9 do
			(
				thePixels = for i = 1 to theX collect theGridColor
				setPixels theBitmap [0,0] thePixels
				for i = 1 to theY do 
					setPixels theBitmap [0,i-1] #(theGridColor)
			)
			
			hc.backgroundBitmap = theBitmap
			hc.tileBackground = true
		)
		

		fn toggleSnapToGrid =
		(
			SnapToGrid = not SnapToGrid
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "SnapToGrid" (SnapToGrid as string)
			showGrid SnapToGrid
			hc.redrawView			
		)			
		
--LOADING AND SAVING FUNCTIONS--
		
	
		fn openFlow =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\") all:true
			local theFileName = getOpenFileName caption:"Load Krakatoa Channels Editor Flow" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\Flow.kcf") types:"Krakatoa Channels Editor Flow (*.KCF)|*.KCF|All Files (*.*)|*.*"
			if theFileName != undefined do
			(
				try
				(
					--createUndoRecord ("Before Opening Flow File [" + getFileNameFile theFileName + "]")
					fileIn theFileName
					KrakatoaChannelEditor_BaseNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
					KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading KrakatoaChannelEditor_BaseNodeTreeData
					KrakatoaChannelsEditor_Functions.buildDisplayTree()	
					createNodeTree init:true
					createUndoRecord ("Open Flow File [" + getFileNameFile theFileName + "]")
					resetPanFactor()
					resetZoomFactor()
					showGrid SnapToGrid					
					hc.redrawView							
				)catch()
			)		
			displaySelectedNodeProperties()
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			setFocus hc
		)
		
		fn saveFlowAs =
		(
			makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\") all:true
			local theFileName = getSaveFileName caption:"Save Channels Editor Flow" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\Flow.kcf") types:"Krakatoa Channels Editor Flow (*.KCF)|*.KCF"
			if theFileName != undefined do
			(
				KrakatoaChannelsEditor_Functions.saveFlow theFileName
			)
			setFocus hc
		)		
		
		fn newFlow =
		(
			local q = querybox "Are you sure you want to start a new flow?" title:"New Channels Editor Flow"
			if q do 
			(
				--createUndoRecord "Before New Flow Creation"
				KrakatoaChannelEditor_DisplayNodeTreeData = #(#("Output", #(2), #("Color","float16",3), #([500,0],false,false), true )) --,#("Input", #(), #("Channel", "Color"), #([200,100], false, true), true)
				KrakatoaChannelEditor_DisplayNodeTreeData [1][4][8] = "Output"
				--KrakatoaChannelsEditor_Functions.buildDisplayTree()
				createNodeTree init:true
				createUndoRecord "Start New Flow"
			)		
			setFocus hc			
		)				
		
		fn selectAllNodes =
		(
			setSelectedNodesInData (for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count collect i)
			createNodeTree init:false
			createUndoRecord "Select All Nodes"				
		)			
		
		fn invertSelection =
		(
			setSelectedNodesInData (getUnSelectedNodes())
			createNodeTree init:false
			createUndoRecord "Invert Node Selection"				
		)
		
		fn selectUnconnectedNodes =
		(
			FlagUnconnectedNodes()
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] == false collect i)
			--format "%\n" theIndices
			setSelectedNodesInData theIndices 
			createNodeTree init:false
			case theIndices.count of
			(
				1: createUndoRecord ("Select One Unconnected Node")
				0: createUndoRecord ("No Unconnected Nodes Selected")
				default: createUndoRecord ("Select "+theIndices.count as string +" Unconnected Nodes")
			)
		)
		
		fn selectDisabledNodes =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][5] == false collect i)
			setSelectedNodesInData theIndices 
			createNodeTree init:false
			case theIndices.count of
			(
				1: createUndoRecord ("Select One Disabled Node")
				0: createUndoRecord ("No Disabled Nodes Selected")
				default: createUndoRecord ("Select "+theIndices.count as string +" Disabled Nodes")
			)			
		)
		
		fn selectOperatorNodesOnly =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Operator" collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One Operator Node")
				0:	createUndoRecord ("No Operator Nodes Selected")
				default:	createUndoRecord ("Select "+theIndices.count as string +" Operator Nodes")
			)	
		)

		fn selectInputNodesOnly =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Input" collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One Input Node")
				0:	createUndoRecord ("No Input Nodes Selected")
				default:	createUndoRecord ("Select "+theIndices.count as string +" Input Nodes")
			)	
		)
		
		fn selectExposedInputs =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One Exposed Input Node")
				0:	createUndoRecord ("No Exposed Input Nodes Selected")
				default:	createUndoRecord ("Select "+theIndices.count as string +" Exposed Input Nodes")
			)				
		)		
		
		fn unexposeSelectedInputs =
		(
			local theSel = getSelectedNodes()
			local cnt = 0
			for i in theSel where KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] == true do 
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] = false
				cnt +=1
			)	
			createNodeTree init:false
			case cnt of
			(
				0:	createUndoRecord ("No Selected Input Nodes Unexposed")
				default:	
				(
					createUndoRecord ("Unexpose "+cnt as string + " of "+ theSel.count as string +" Selected Nodes")
					KrakatoaChannelsEditor_Functions.updateParentModifier()					
					KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier
				)	
			)				
		)
		
		fn exposeSelectedInputs =
		(
			local theSel = getSelectedNodes()
			local cnt = 0
			for i in theSel where KrakatoaChannelEditor_DisplayNodeTreeData[i][3][1] == "Value" and KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] != true do 
			(
				KrakatoaChannelEditor_DisplayNodeTreeData[i][4][12] = true
				cnt +=1
			)	
			createNodeTree init:false
			case cnt of
			(
				0:	createUndoRecord ("No Selected Input Nodes Exposed")
				default:	
				(
					createUndoRecord ("Expose "+cnt as string + " of "+ theSel.count as string +" Selected Nodes")
					KrakatoaChannelsEditor_Functions.updateParentModifier()
					KrakatoaChannelsEditor_Functions.exposeControlsToModifier KrakatoaChannelNodeEditor_CurrentModifier
				)	
			)				
		)		

		fn selectBlackOpNodesOnly =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "BlackOp" collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One BlackOp Node")
				0:	createUndoRecord ("No BlackOp Nodes Selected")
				default: createUndoRecord ("Select "+theIndices.count as string+ " BlackOp Nodes")
			)	
		)		
		
		fn deselectAllNodes =
		(
			local theSel = getSelectedNodes()
			if theSel.count > 0 do
			(
				setSelectedNodesInData #()
				--updateNodeSelection createUndo:false
				createNodeTree init:false
				createUndoRecord "Deselect All Nodes"
			)			
		)
		
		global KrakatoaChannelEditor_BLOPArray = #()
		local theWalkArray = #()
		local averagePos = [0,0]
		fn recursiveWalkTheTree theChild =
		(
			if findItem theWalkArray theChild == 0 do 
			(
				append theWalkArray theChild
				for i in KrakatoaChannelEditor_BLOPArray[theChild][2] where i != undefined and i > 0 do
					recursiveWalkTheTree i
			)	
		)
		
		local BLOP_currentCountArray = #()
		fn isSelectionValidBLOP =
		(
			local theRootNode = 0
			local theSel = getSelectedNodes()
			if theSel.count > 1 do
			(
				BLOP_currentCountArray = #()
				KrakatoaChannelEditor_BLOPArray=#()
				local minX = 10000
				local minY = 10000
				averagePos = [0,0]
				local averageCount = 0
				for i in theSel where i > 1 do
				(
					local theNode = deepCopy KrakatoaChannelEditor_DisplayNodeTreeData[i] 
					if theNode[4][1].x < minX do minX = theNode[4][1].x 
					if theNode[4][1].y < minY do minY = theNode[4][1].y
					averagePos += theNode[4][1]
					averageCount += 1
					append KrakatoaChannelEditor_BLOPArray theNode
					append BLOP_currentCountArray i
				)	
				averagePos /= averageCount

				for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
				(
					KrakatoaChannelEditor_BLOPArray[i][4][1] -= averagePos  --[minX,minY]
					KrakatoaChannelEditor_BLOPArray[i][4][1] += [300,100]
					local theCount = getInputCount KrakatoaChannelEditor_BLOPArray[i] 
					for j = 1 to theCount do
					(
						if KrakatoaChannelEditor_BLOPArray[i][2][j] != undefined and KrakatoaChannelEditor_BLOPArray[i][2][j] > 0 then
						(
							local theIndex = findItem BLOP_currentCountArray KrakatoaChannelEditor_BLOPArray[i][2][j]
							if theIndex > 0 then
								KrakatoaChannelEditor_BLOPArray[i][2][j] = theIndex
							else
							(
								local theSocketName = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_BLOPArray[i][2][j]][4][8]
								if theSocketName == undefined do theSocketName = KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_BLOPArray[i][2][j]][3][1]
								append KrakatoaChannelEditor_BLOPArray #("Connector", #(), #(theSocketName,KrakatoaChannelEditor_BLOPArray[i][2][j]), #(), true )
								KrakatoaChannelEditor_BLOPArray[i][2][j] = KrakatoaChannelEditor_BLOPArray.count
							)	
						)
						else 
						(
							theRootNode = 0
							lbx_log.items = append lbx_log.items "--CANNOT SAVE AS BLACK OP: At least one Selected Node contains Unconnected Sockets!"
							lbx_log.selection = lbx_log.items.count
							return 0
						)
					)	
				)					
				for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
				(
					theWalkArray = #()
					recursiveWalkTheTree i
					if theWalkArray.count == KrakatoaChannelEditor_BLOPArray.count then
					(
						theRootNode = i
						lbx_log.items = #()
						return theRootNode
					)
				)
			)				
			if theSel.count > 1 then
				lbx_log.items = append lbx_log.items "--CANNOT SAVE AS BLACK OP: Could Not determine a Root Node!"
			else
				lbx_log.items = append lbx_log.items "--CANNOT SAVE AS BLACK OP: Please select at least two Nodes!"
			
			lbx_log.selection = lbx_log.items.count
			theRootNode
		)
		
		fn saveBLOPDefinition =
		(
			local theResult = isSelectionValidBLOP() 
			--print theResult
			--print KrakatoaChannelEditor_BLOPArray
			if theResult > 0 then
			(
				makeDir (GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps") all:true
				local theFileName = getSaveFileName caption:"Save BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\BlackOp.kcb") types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
				if theFileName != undefined do
				(
					append KrakatoaChannelEditor_BLOPArray #("OutputConnector", #(theResult), #(), #(), true)
					for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
					(
						if KrakatoaChannelEditor_BLOPArray[i][3][1] == "Script" do KrakatoaChannelEditor_BLOPArray[i][3][2] = KrakatoaChannelEditor_BLOPArray[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_BLOPArray[i][4][6])
						if KrakatoaChannelEditor_BLOPArray[i][1] == "Input"  and KrakatoaChannelEditor_BLOPArray[i][3][3]  != undefined do deleteItem KrakatoaChannelEditor_BLOPArray[i][3] 3
					)	
					local theFileHandle = createFile theFileName
					with PrintAllElements true	format "global KrakatoaChannelEditor_BlackOpData = %\n" KrakatoaChannelEditor_BLOPArray to:theFileHandle 
					close theFileHandle
					KrakatoaChannelEditor_BlackOpData = execute ( with PrintAllElements true KrakatoaChannelEditor_BLOPArray as string)
					--KrakatoaChannelNodeEditor_Rollout.updateDepotDefinition()
					KrakatoaChannelsEditor_Functions.KrakatoaChannelEditor_UpdateDepot()					
				)	
			)
		)
		
		fn addNewBLOP creationType:#keyboard useFile:true createUndo:true theFile:""=
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			local theSelection = getSelectedNodes()
			local theConnectArray = #()
			local thePos = [0,0]
			if creationType == #average then
				thePos = averagePos
			else if useMousePositionOnCreation or creationType==#rcmenu then 
				thePos =(KrakatoaChannelNodeEditor_Rollout.lastMouseClick - (getDialogPos KrakatoaChannelNodeEditor_Rollout) - [10, 50] - hc.pan) / hc.zoom
			else
				thePos = getNewNodePosition()
			
			local theFileName = if useFile then
				getOpenFileName caption:"Load BlackOp Definition" filename:(GetDir #plugcfg + "\\Krakatoa\\ChannelFlows\\BlackOps\\*.kcb") types:"Krakatoa Channels Editor BlackOp (*.KCB)|*.KCB"
			else 
				theFile
			if theFileName != undefined do
			(
				if useFile or doesFileExist theFile do fileIn theFileName
				local theBLOPDef = deepcopy KrakatoaChannelEditor_BlackOpData
				KrakatoaChannelsEditor_Functions.fixFlowIDsAfterLoading theBLOPDef
				append KrakatoaChannelEditor_DisplayNodeTreeData #("BlackOp", theConnectArray, #((getFileNameFile theFileName),theBLOPDef), #(thePos,false,true,undefined,undefined,undefined,undefined,(getFileNameFile theFileName)), true)
				if createUndo do createUndoRecord ("Add BlackOp From File")					
					
				local theConnectionCount = getInputCount KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count]
				if theSelection.count > 0 and theConnectionCount > 0 do
				(
					local theConnectedNodes = for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count where findItem KrakatoaChannelEditor_DisplayNodeTreeData[i][2] theSelection[1] > 0 collect i
					if theConnectedNodes.count == 1 then
					(
						KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2] = #(theSelection[1])
						local theIndex = findItem KrakatoaChannelEditor_DisplayNodeTreeData[theConnectedNodes[1]][2] theSelection[1]
						KrakatoaChannelEditor_DisplayNodeTreeData[theConnectedNodes[1]][2][theIndex] = KrakatoaChannelEditor_DisplayNodeTreeData.count
						if createUndo do createUndoRecord ("Insert BlackOp Into Existing Connection")
						for i = 2 to theSelection.count do
						(
							if i <= theConnectionCount do 
							(
								append KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2] theSelection[i]
								if createUndo do createUndoRecord ("Auto-Connect ["+i as string + ":"+KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[i]][4][8] as string +"] To BlackOp ["+KrakatoaChannelEditor_DisplayNodeTreeData.count as string+":"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][3][1] +"] Input " + i as string)
							)	
						)		
					)
					else
					(
						for i = 1 to theSelection.count do
							if i <= theConnectionCount do 
							(
								append KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2] theSelection[i]
								if createUndo do createUndoRecord ("Auto-Connect ["+i as string + ":"+KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[i]][4][8] as string +"] To BlackOp ["+KrakatoaChannelEditor_DisplayNodeTreeData.count as string+":"+KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][3][1] +"] Input " + i as string)
							)	
					)			
					setSelectedNodesInData #(KrakatoaChannelEditor_DisplayNodeTreeData.count)
				)					
					
				createNodeTree init:true
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false	
				hc.activeNode = KrakatoaChannelEditor_DisplayNodeTreeData.count
				setSelectedNodes #(KrakatoaChannelEditor_DisplayNodeTreeData.count)
				displaySelectedNodeProperties()			
				
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
				--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()
			)	
		)
		
		fn createBLOPInline =
		(
			local theSelection = getSelectedNodes()
			local theResult = isSelectionValidBLOP() 
			if theResult > 0 then
			(
				local oldCount = KrakatoaChannelEditor_DisplayNodeTreeData.count
				append KrakatoaChannelEditor_BLOPArray #("OutputConnector", #(theResult), #(), #(), true)
				for i = 1 to KrakatoaChannelEditor_BLOPArray.count do
				(
					if KrakatoaChannelEditor_BLOPArray[i][3][1] == "Script" do KrakatoaChannelEditor_BLOPArray[i][3][2] = KrakatoaChannelEditor_BLOPArray[i][4][6] = (KrakatoaChannelsEditor_Functions.escapeString KrakatoaChannelEditor_BLOPArray[i][4][6])
					if KrakatoaChannelEditor_BLOPArray[i][1] == "Input"  and KrakatoaChannelEditor_BLOPArray[i][3][3]  != undefined do deleteItem KrakatoaChannelEditor_BLOPArray[i][3] 3
				)	
				KrakatoaChannelEditor_BlackOpData = deepCopy KrakatoaChannelEditor_BLOPArray
				addNewBLOP creationType:#average useFile:false createUndo:false
				for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count-1 do
				(
					local theIndex = findItem KrakatoaChannelEditor_DisplayNodeTreeData[i][2] (BLOP_currentCountArray[theResult])
					if theIndex > 0 do KrakatoaChannelEditor_DisplayNodeTreeData[i][2][theIndex] = KrakatoaChannelEditor_DisplayNodeTreeData.count
				)
				local theConnectors = for i = 1 to KrakatoaChannelEditor_BlackOpData.count where KrakatoaChannelEditor_BlackOpData[i][1] == "Connector" collect KrakatoaChannelEditor_BlackOpData[i][3][2]
				KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelEditor_DisplayNodeTreeData.count][2] = theConnectors
				setSelectedNodes theSelection
				deleteSelectedNodes createUndo:false
				setSelectedNodesInData #(KrakatoaChannelEditor_DisplayNodeTreeData.count)
				createNodeTree init:true
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false				
				createUndoRecord ("Add BlackOp From Selection")	
			)	
		)		
		
		fn copySelectionToClipboard =
		(
			local theSel = getSelectedNodes()
			if theSel.count > 0 do
			(
				local currentCountArray = #()
				KrakatoaChannelEditor_ClipboardArray=#()
				local minX = 10000
				local minY = 10000
				for i in theSel where i > 1 do
				(
					local theNode = deepCopy KrakatoaChannelEditor_DisplayNodeTreeData[i] 
					if theNode[4][1].x < minX do minX = theNode[4][1].x 
					if theNode[4][1].y < minY do minY = theNode[4][1].y
					append KrakatoaChannelEditor_ClipboardArray theNode
					append currentCountArray i
				)	
				for i = 1 to KrakatoaChannelEditor_ClipboardArray.count do
				(
					KrakatoaChannelEditor_ClipboardArray[i][4][1] -= [minX,minY]
					for j = 1 to KrakatoaChannelEditor_ClipboardArray[i][2].count where KrakatoaChannelEditor_ClipboardArray[i][2][j] != undefined and KrakatoaChannelEditor_ClipboardArray[i][2][j] > 0 do
						KrakatoaChannelEditor_ClipboardArray[i][2][j] = findItem currentCountArray KrakatoaChannelEditor_ClipboardArray[i][2][j]
				)
			)	
		)
		
		fn pasteSelectionFromClipboard =
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			if KrakatoaChannelEditor_ClipboardArray.count > 0 do
			(
				local thePos = (lastMouseClick - (getDialogPos KrakatoaChannelNodeEditor_Rollout) - [0,40] - hc.pan)/hc.zoom --mouse.screenpos
				setSelectedNodes #()
				local theOldCount = KrakatoaChannelEditor_DisplayNodeTreeData.count
				local theArrayToPaste =deepCopy KrakatoaChannelEditor_ClipboardArray
				for i = 1 to theArrayToPaste.count do 
				(
					theArrayToPaste[i][4][1] += thePos 
					if theArrayToPaste[i][3][1] == "Value" do 
					(
						theArrayToPaste[i][4][4] = theID = (random 10000 1000000) as string + "_" + (random 10000 1000000) as string
						theArrayToPaste[i][3][3] = KrakatoaChannelsEditor_Functions.createTrackViewControllers theID KrakatoaChannelEditor_DisplayNodeTreeData[(KrakatoaChannelEditor_DisplayNodeTreeData.count+1)]
					)	
				)
				join KrakatoaChannelEditor_DisplayNodeTreeData theArrayToPaste 
				for i = theOldCount+1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
					for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[i][2].count where KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > 0 do
						KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] += theOldCount
				createNodeTree init:true
				setSelectedNodes (for i = theOldCount+1 to KrakatoaChannelEditor_DisplayNodeTreeData.count collect i)
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false					
				createUndoRecord ("Paste "+ KrakatoaChannelEditor_ClipboardArray.count as string +" Nodes From Clipboard")
				
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
			)	
		)
		
		
----------------------------------------------------------			
--EVENT HANDLERS
----------------------------------------------------------		
		
		on btn_zoomExtents pressed do ZoomExtents()
		on btn_zoomExtentsSelected pressed do ZoomExtentsSelected()
		on btn_NoZoom pressed do resetZoomFactor()
		on btn_NoPoom pressed do resetPanFactor()
		
		on btn_zoomExtents rightclick do (resetZoomFactor();resetPanFactor())
		on btn_zoomExtentsSelected rightclick do (resetZoomFactor();resetPanFactor())
		on btn_NoZoom rightclick do (resetZoomFactor();resetPanFactor())
		on btn_NoPoom rightclick do (resetZoomFactor();resetPanFactor())
		
		on btn_Undo pressed do undoLastStep()
		on btn_Redo pressed do redoLastStep()
		
		on btn_Undo rightClick do 
		(
			createUndoRCMenu()
			popupMenu KrakatoaChannelEditor_UndoRCMenu pos:mouse.screenpos
		)	
		on btn_Redo rightClick do 
		(
			createRedoRCMenu()
			popupMenu KrakatoaChannelEditor_UndoRCMenu pos:mouse.screenpos
		)			
		
		
		on hc connectionChanged fromNodeIndex toNodeIndex toSocketID fromSocketID status toSocketCount do
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			oldStatus = KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][2][toSocketID]
			if status == 1 then
				KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][2][toSocketID] = fromNodeIndex
			else
				KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][2][toSocketID] = 0
			checkForCyclicConnections() 
			if stopRecursion > 0 do KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][2][toSocketID]  = oldStatus
			createNodeTree init:true
			if AutoReorderToggle do autoReorderFlow createUndo:false		
			if AutoZoomExtents do zoomExtents createUndo:false
			if status == 1 then
				createUndoRecord ("Connect ["+ KrakatoaChannelEditor_DisplayNodeTreeData[fromNodeIndex][1] as string + ":"+ KrakatoaChannelEditor_DisplayNodeTreeData[fromNodeIndex][3][1] as string  +"] to ["+KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][1] as string + ":"+KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][3][1] as string +"]")
			else		
				createUndoRecord ("Disconnect ["+ KrakatoaChannelEditor_DisplayNodeTreeData[fromNodeIndex][1] as string + ":"+ KrakatoaChannelEditor_DisplayNodeTreeData[fromNodeIndex][3][1] as string  +"] from ["+KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][1] as string  + ":"+KrakatoaChannelEditor_DisplayNodeTreeData[toNodeIndex][3][1] as string +"]")
			if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()	
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()					
		)		
		
		on hc nodesDeleted do
		(
			local needUpdate = false
			KrakatoaChannelEditor_LastError = #(0,"","")
			theIndices = sort (for i = 1 to hc.getDeletedNodeCount collect (hc.getDeletedNodeIndex = i))
			for index in theIndices.count to 1 by -1 do
			(
				if theIndices[index] > 1 and theIndices[index] <= KrakatoaChannelEditor_DisplayNodeTreeData.count do
				(
					needUpdate = true
					for i = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
					(
						for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData[i][2].count do
						(
							if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] == theIndices[index] do
								KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] = 0
							if KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] != undefined AND KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] > theIndices[index] do
								KrakatoaChannelEditor_DisplayNodeTreeData[i][2][j] -= 1
						)	
					)
					deleteItem KrakatoaChannelEditor_DisplayNodeTreeData theIndices[index]
				)	
			)	
			createNodeTree init:true			
			if needUpdate do
			(
				createUndoRecord ("Delete " + theIndices.count as string + " Selected Node(s)")
				if chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
				if AutoReorderToggle do autoReorderFlow createUndo:false
				if AutoZoomExtents do zoomExtents createUndo:false
				displaySelectedNodeProperties()
			)	
			drawDepot init:false			
		)

		on hc mouseScroll do
		(
			if hc.zoom > 1.2 do hc.zoom = 1.2
			showGrid SnapToGrid
			drawDepot init:false lock:true
		)
		
		on hc mButtonUp do
		(
			drawDepot init:false lock:false
		)		
		
		on hc mButtonDown do
		(
			drawDepot init:false lock:true
		)			
		
		on hc LButtonDown do
		(
			prepareDepotForDragAndDrop()
			lastSelectionBeforeClick = getSelectedNodes()
		)
		
		on hc LButtonUp do
		(
			local theSel = getSelectedDepotButton()
			
			hc.setInfo = case theSel.count of
			(
				1: "Depot: " +getFileNameFile theDepotNodes[theSel[1]][5]
				0: "" 
				default: "Multiple Depot Nodes Selected"
			)	
			if theSel.count == 1 and theDepotNodes[theSel[1]][1] == "HEAD" then
			(
				if (keyboard.ControlPressed and not keyboard.shiftPressed) then
				(
					if (DepotPlacement != #bottomrollup and DepotPlacement != #bottomrollupreverse) do
						for j = 1 to theDepotNodesArray.count where theDepotNodesArray[j][1][1]  == "HEAD" do
							theDepotNodesArray[j][1][6] = false
					for j = 1 to theDepotNodesArray.count where theDepotNodesArray[j][1][2] == theDepotNodes[theSel[1]][2] do
						theDepotNodesArray[j][1][6] = true
				)
				else if keyboard.shiftPressed and not keyboard.ControlPressed then
				(
					for j = 1 to theDepotNodesArray.count where theDepotNodesArray[j][1][1]  == "HEAD" do
						theDepotNodesArray[j][1][6] = true					
				)
				else if keyboard.shiftPressed and keyboard.ControlPressed then
				(
					for j = 1 to theDepotNodesArray.count where theDepotNodesArray[j][1][1]  == "HEAD" do
						theDepotNodesArray[j][1][6] = false							
				)
				else if not keyboard.shiftPressed and not keyboard.ControlPressed then
				(
					for j = 1 to theDepotNodesArray.count do
					(
						if theDepotNodesArray[j][1][2] == theDepotNodes[theSel[1]][2] do
						(
							theDepotNodesArray[j][1][6] = not theDepotNodesArray[j][1][6]
							if (DepotPlacement == #bottomrollup or DepotPlacement == #bottomrollupreverse) and theDepotNodesArray[j][1][6] == true do 
							(
								for k = 1 to theDepotNodesArray.count where k != j do
									theDepotNodesArray[k][1][6] = false
							)
						)
					)
					
				)	
				updateDepotDefinition()
				createNodeTree init:true
				if AutoZoomExtents do zoomExtents createUndo:false
			)	
			else
			(
				local result = handleDepotDragAndDrop()
				drawDepot init:false
				if not result do updateNodeSelection()
			)	
			if keyboard.shiftPressed do removeNode deleteTheNode:false
			if AutoReorderToggle do autoReorderFlow createUndo:false
			--if flagUnconnectedAsErrors == true do FlagUnconnectedOperatorsAsError()	
		)
		
		fn selectNextNodeByCreationOrder =
		(
			local theSel = getSelectedNodes()
			if theSel.count == 0 do theSelected = 1
			if theSel.count > 0 do theSelected = theSel[theSel.count]
			theSelected +=1
			if theSelected > KrakatoaChannelEditor_DisplayNodeTreeData.count do theSelected = 1
			setSelectedNodes #(theSelected)
			updateNodeSelection createUndo:false
			createNodeTree init:false
			createUndoRecord ("Select Next Node " + theSelected as string )
		)
		
		fn selectPreviousNodeByCreationOrder =
		(
			local theSel = getSelectedNodes()
			if theSel.count == 0 do theSelected = 1
			if theSel.count > 0 do theSelected = theSel[theSel.count]
			theSelected -=1
			if theSelected < 1 do theSelected =  KrakatoaChannelEditor_DisplayNodeTreeData.count
			setSelectedNodes #(theSelected)
			updateNodeSelection createUndo:false
			createNodeTree init:false
			createUndoRecord ("Select Previous Node "	+ theSelected as string )
		)
		
		fn selectChildrenNodesByParent =
		(
			local theSel = getSelectedNodes()
			if theSel.count == 0 do theSel = #(1)
			local newSelection = deepCopy theSel
			for i in theSel do
				for j in KrakatoaChannelEditor_DisplayNodeTreeData[i][2] where j != undefined and j > 0 and  findItem newSelection  j == 0 do
					append newSelection j
			setSelectedNodesInData newSelection
			createNodeTree init:false
			createUndoRecord ("Grow Child Selection From " + theSel.count as string + " to " + newSelection.count as string +" Nodes." )				
		)
		
		fn selectParentNodesByChild =
		(
			local theSel = getSelectedNodes()
			if theSel.count == 0 do return false
			local newSelection = deepCopy theSel
			for i in theSel do
				for j = 1 to KrakatoaChannelEditor_DisplayNodeTreeData.count do
					for k in KrakatoaChannelEditor_DisplayNodeTreeData[j][2] where k == i and findItem newSelection j == 0 do
						append newSelection j
			setSelectedNodesInData newSelection
			createNodeTree init:false
			createUndoRecord ("Grow Parent Selection From " + theSel.count as string + " to " + newSelection.count as string +" Nodes." )					
		)
		

--KEYBOARD SHORTCUTS
		
		on hc keyboardDown keyCode do
		(
			--print keycode
			
			if keyCode == 8 and not keyboard.ControlPressed do removeNode deleteTheNode:(not keyboard.ShiftPressed) --Backspace
			
			if keyCode == 32 do connectSelectedNodes() --Spacebar

			if keyCode == 34 and not keyboard.ControlPressed and not keyboard.ShiftPressed do selectNextNodeByCreationOrder()
			if keyCode == 33 and not keyboard.ControlPressed and not keyboard.ShiftPressed do selectPreviousNodeByCreationOrder()
			
			if keyCode == 34 and not keyboard.ControlPressed and keyboard.ShiftPressed do selectChildrenNodesByParent()
			if keyCode == 33 and not keyboard.ControlPressed and keyboard.ShiftPressed do selectParentNodesByChild()
			
			if keycode == 54 do  --6^
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Power" 
			)

			if keycode ==65 and not keyboard.ShiftPressed and not keyboard.ControlPressed do  --A
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"AbsoluteValue"
			)				
			if keycode ==65 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+A
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Age"
			)				

			if keycode == 65 and keyboard.ControlPressed and keyboard.ShiftPressed  do alignAllNodesToGrid() --Ctrl+Shift+A
			if keycode == 65 and keyboard.ControlPressed and not keyboard.ShiftPressed  do --Ctrl+A
			(
				selectAllNodes()
			)
			
			if keycode == 66 and not keyboard.ControlPressed do  --B
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Blend" 
			)	
			
			if keycode == 67 and not keyboard.ShiftPressed and not keyboard.ControlPressed do --C
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Clamp" 
			)	
			
			if keycode == 67 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+C
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Color"
			)	
			
			if keycode == 67 and not keyboard.ShiftPressed and  keyboard.ControlPressed do  --Ctrl+C
			(
				copySelectionToClipboard()
			)				
			
			
			
			if keycode == 68 and keyboard.ControlPressed do  --D
			(
				deselectAllNodes()
			)			

			if keycode == 68 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+D
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Density"
			)	
				
			if keycode == 70 and not keyboard.ControlPressed do  --F
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#value valueType:#float 
			)			
			
			if keycode == 70 and keyboard.ControlPressed do  --Ctrl+F
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Floor" 
			)					

			if keycode == 71 and keyboard.ControlPressed do  --Ctrl+G
				toggleSnapToGrid	()
		
			
			if keyCode == 73 do --I
			(
				lastMouseClick = mouse.screenpos
				if not keyboard.ControlPressed and not keyboard.ShiftPressed do addNewInput type:#value valueType:#integer --I
				if not keyboard.ControlPressed and keyboard.ShiftPressed do addNewInput type:#channel channelName:"ID" --Shift+I
				if keyboard.ControlPressed and not keyboard.ShiftPressed do invertSelection() --addNewInput type:#script
			)	

			if keycode == 76 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+L
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Lighting"
			)				

			if keycode == 77 and not keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+M
			(
				lastMouseClick = mouse.screenpos
				KrakatoaChannelNodeEditor_Rollout.addNewInput type:#TextureMap
			)	
			
			if keycode == 77 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+M
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"TextureCoord"
			)	
			
			if keycode == 77 and not keyboard.ShiftPressed and keyboard.ControlPressed do  --Ctrl+M
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Magnitude" 
			)				
			
			if keycode == 78 and not keyboard.ShiftPressed and not keyboard.ControlPressed do  --N
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Normalize" 
			)					
			
			
			if keyCode == 78 and not keyboard.ShiftPressed and keyboard.ControlPressed do newFlow() --Ctrl+N
			if keyCode == 78 and keyboard.ShiftPressed and keyboard.ControlPressed do 	--Shift+Ctrl+N
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Negate" 				
			)
			
			if keycode == 78 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+N
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Normal"
			)	
			


			if keyCode == 79 do 
			(
				if keyboard.ControlPressed then --Ctrl+O
				(
					openFlow()
				)
				else --O
				(
					lastMouseClick = mouse.screenpos
					addNewOperator()
				)	
			)

			if keycode == 80 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --P
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Position"
			)	
			
			if keyCode == 80 and keyboard.ControlPressed do setPassThrough() --Ctrl+P
			
			if keyCode == 81 and keyboard.ControlPressed do try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch() --Ctrl+Q
			
			if keyCode == 82 and keyboard.ControlPressed do autoReorderFlow()
			
			if keyCode == 83 do --S
			(
				if keyboard.ControlPressed do saveFlowAs() --Ctrl+S
				if not keyboard.ControlPressed and not keyboard.ShiftPressed do addNewOperator type:"ComponentSum" 
				if not keyboard.ControlPressed and keyboard.ShiftPressed do addNewOperator type:"ToScalar" 
			)	

			if keycode == 84 and not keyboard.ShiftPressed and not keyboard.ControlPressed do --T		
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"ToVector" 
			)	
			
			if keycode == 84 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+T
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Tangent"
			)				
				
			
			
			if keycode == 85 and not keyboard.ShiftPressed and keyboard.ControlPressed do --Ctrl+U
			(
				selectUnconnectedNodes()
			)
						
			if keycode == 86 and not keyboard.ShiftPressed and not keyboard.ControlPressed do -- V
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#value valueType:#vector --V
			)
			
			if keycode == 86 and keyboard.ShiftPressed and not keyboard.ControlPressed do  --Shift+V
			(
				lastMouseClick = mouse.screenpos
				addNewInput type:#channel channelName:"Velocity"
			)				

			if keycode == 86 and not keyboard.ShiftPressed and  keyboard.ControlPressed do  --Ctrl+V
			(
				pasteSelectionFromClipboard()
			)				
			
			
			if keyCode == 87 and keyboard.ControlPressed do swapInputsOrder() --Ctrl+W
			if keyCode == 88 do
				if not keyboard.ShiftPressed then
					resetZoomFactor() --X
				else
					resetPanFactor() --Shift+X
			
			if keyCode == 89 and keyboard.ControlPressed do redoLastStep() --Ctrl+Y
			
			if keyCode == 90 do --zoom
			(
				if keyboard.ControlPressed then
					undoLastStep()
				else
				(
					if keyboard.ShiftPressed then
						ZoomExtentsSelected()
					else
						ZoomExtents()
				)	
			)	

			if keycode == 106 and not keyboard.ControlPressed do  --NumPad *
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Multiply" 
			)			
			if keycode == 107 and not keyboard.ControlPressed do --NumPad +
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Add" 
			)
			if keyCode == 109 and not keyboard.ControlPressed do  --NumPad --
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Subtract" 
			)				
			if keycode == 111 and not keyboard.ControlPressed do  --NumPad /
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Divide" 
			)	

			if keycode == 188 and not keyboard.ControlPressed do  --,
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"CrossProduct" 
			)					
			if keycode == 190 and not keyboard.ControlPressed do  --.
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"DotProduct" 
			)				
			
			if keycode == 191 and not keyboard.ControlPressed do  --/
			(
				lastMouseClick = mouse.screenpos
				addNewOperator type:"Switch" 
			)				
			
			if keycode == 219 and not keyboard.ControlPressed and  not keyboard.ShiftPressed do  --[ key
			(
				addNewOperator type:"Sin" 
			)		
			if keycode == 221 and not keyboard.ControlPressed and  not keyboard.ShiftPressed do  --] key
			(
				addNewOperator type:"Cos" 
			)		
			if keycode == 220 and not keyboard.ControlPressed and  not keyboard.ShiftPressed do  --\ key
			(
				addNewOperator type:"Tan" 
			)		
			
			if keycode == 219 and not keyboard.ControlPressed and keyboard.ShiftPressed do  --{ key
			(
				addNewOperator type:"ASin" 
			)	
			if keycode == 221 and not keyboard.ControlPressed and  keyboard.ShiftPressed do  --} key
			(
				addNewOperator type:"ACos" 
			)		
			if keycode == 220 and not keyboard.ControlPressed and  keyboard.ShiftPressed do  --| key
			(
				addNewOperator type:"ATan" 
			)
			/*
			if keycode == 189 and not keyboard.ControlPressed do  -- minus
			(
				lastMouseClick = mouse.screenpos
				if keyboard.ShiftPressed then
				addNewOperator type:"One Over" 
				else
				addNewOperator type:"One Minus" 
			)		
			*/
		)

		on hc RButtonDown do
		(
			lastMouseClick = mouse.screenpos
			local theMouse = (lastMouseClick - (getDialogPos KrakatoaChannelNodeEditor_Rollout))-[3,40]
			lastNodeClick = (hc.findNodeByPos = theMouse)
			if lastNodeClick == 0 then
				popupMenu KrakatoaChannelEditor_AddNode_RCMenu pos:lastMouseClick
			else if lastNodeClick > 1 and lastNodeClick <= KrakatoaChannelEditor_DisplayNodeTreeData.count do popupMenu KrakatoaChannelEditor_EditNode_RCMenu pos:lastMouseClick
			
			if (DepotPlacement != #off) and lastNodeClick>KrakatoaChannelEditor_DisplayNodeTreeData.count do popupMenu KrakatoaChannelNodeEditor_DepotMenu pos:lastMouseClick
		)		
		
		fn updateValues =
		(
			createNodeTree init:false
			try
			(
				if KrakatoaChannelNodeEditor_InputRollout.open and KrakatoaChannelNodeEditor_InputRollout.ddl_InputType.selection == 2 do 
					KrakatoaChannelNodeEditor_InputRollout.updateControls()
			)catch()	
		)
		
		on KrakatoaChannelNodeEditor_Rollout open do
		(
			try(btn_zoomExtents.images = #("krakatoa_channelEditor_16i.bmp","krakatoa_channelEditor_16a.bmp", 4,1,1,1,1,true) )catch()
			try(btn_zoomExtentsSelected.images = #("krakatoa_channelEditor_16i.bmp","krakatoa_channelEditor_16a.bmp", 4,2,2,2,2,true) )catch()
			try(btn_NoZoom.images = #("krakatoa_channelEditor_16i.bmp","krakatoa_channelEditor_16a.bmp", 4,3,3,3,3,true) )catch()
			try(btn_NoPoom.images = #("krakatoa_channelEditor_16i.bmp","krakatoa_channelEditor_16a.bmp", 4,4,4,4,4,true) )catch()
			
			
			
			try(hc.useDrawLayers = true)catch()
			loadDisplaySettings()
			createDepot()
			updateDepotDefinition()
			--KrakatoaChannelsEditor_Functions.buildDisplayTree()			
			createNodeTree init:true
			hc.drawShadows = theNodesCastShadows
			hc.allowZoom  = true
			try(hc.zoomAboutMouse = false)catch()
			hc.drawMenuBars = true
			hc.allowUIDelete = true
			hc.showInfo = true
			hc.setInfo = ""
			hc.pan = [0,0]

			local theVal = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoUpdate" )
			if theVal == OK do theVal = false
			chk_autoUpdateModifier.state = KrakatoaChannelNodeEditor_CurrentModifier.autoUpdate --theVal
			
			showGrid SnapToGrid
			hc.redrawView			
			
			createUndoRecord "Session Start"
			setUndoRedoEnable()
			displaySelectedNodeProperties()
			registerTimeCallback updateValues
			KrakatoaChannelsEditor_Functions.displayError KrakatoaChannelEditor_LastError[1] KrakatoaChannelEditor_LastError[2] KrakatoaChannelEditor_LastError[3]			
			--drawDepot init:true
			if autoZoomExtents do zoomExtents()
			if AutoReorderToggle do autoReorderFlow createUndo:false
			registerViewWindow KrakatoaChannelNodeEditor_Rollout	
		)
		
		on KrakatoaChannelNodeEditor_Rollout close do
		(
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 do
			(
				KrakatoaChannelsEditor_Functions.endEditingBLOP type:#yesno
			)				
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Pan" (hc.pan as string)
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Zoom" (hc.zoom as string)
			KrakatoaChannelsEditor_Functions.updateParentModifier()
			unregisterTimeCallback updateValues
			deleteAllChangeHandlers id:#KCE_CurrentModifierSceneParametersMonitor
		)
		
		on btn_updateModifier pressed do 
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			KrakatoaChannelsEditor_Functions.updateParentModifier()
			if chk_autoUpdateModifier.checked do updateNodeDependencies()
		)
		
		on chk_autoUpdateModifier changed state do 	
		(
			KrakatoaChannelEditor_LastError = #(0,"","")
			if state then
			(
				KrakatoaChannelsEditor_Functions.updateParentModifier()
				updateNodeDependencies()
			)
			else
				deleteAllChangeHandlers id:#KCE_CurrentModifierSceneParametersMonitor
			KrakatoaChannelNodeEditor_CurrentModifier.autoUpdate = state
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "AutoUpdate" (state as string)
		)
		

		
		on KrakatoaChannelNodeEditor_Rollout resized val do 
		(
			hc.width = val.x-182
			hc.height = val.y-18
			
			prg_bar.pos = [val.x-178,val.y-31]
			
			lbx_log.width = val.x-176
			lbx_log.pos = [-2,val.y-19]
			
			btn_RecorderToStart.pos = [val.x-178,val.y-56]
			btn_RecorderBackOneStep.pos = [val.x-178+25,val.y-56]
			chk_RecorderPlay.pos = [val.x-178+25*2,val.y-56]
			btn_RecorderForwardOneStep.pos = [val.x-178+25*3,val.y-56]
			btn_RecorderToEnd.pos = [val.x-178+25*4,val.y-56]
			btn_RecorderClose.pos = [val.x-178+25*5,val.y-56]
			
			NodePropsSR.pos = [val.x-180,23]
			NodePropsSR.height = if KrakatoaChannelEditor_MacroRecording.count > 0 then val.y-80 else val.y-49
			
			chk_autoUpdateModifier.pos=[val.x-180,1] 
			btn_updateModifier.pos = [val.x-118,1] 			
			
			btn_zoomExtents.pos = [val.x-178,val.y-25]
			btn_zoomExtentsSelected.pos = [val.x-153,val.y-25]
			btn_NoZoom.pos = [val.x-128,val.y-25]
			btn_NoPoom.pos = [val.x-103,val.y-25]
			
			btn_Undo.pos = [val.x-78,val.y-25]
			btn_Redo.pos = [val.x-39,val.y-25]
			drawDepot init:false			
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Size" (val as string)
			updateMacroRecorderControls()
			if AutoReorderToggle do KrakatoaChannelNodeEditor_Rollout.autoReorderFlow createUndo:false
			if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)
		
		on KrakatoaChannelNodeEditor_Rollout moved val do 
			setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Position" (val as string)		
	)
	
	fn KrakatoaChannelEditor_ModifierCallback =
	(
		local theObj = modPanel.getCurrentObject()
		if theObj != undefined and theObj.classid as string == "#(393701632, 48107384)" and KrakatoaChannelNodeEditor_Rollout.open == true and KrakatoaChannelNodeEditor_CurrentModifier != theobj do 
		(
			if KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0 do
			(
				KrakatoaChannelsEditor_Functions.endEditingBLOP type:#yesno
			)	
			--try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch()
			if KrakatoaChannelNodeEditor_CurrentModifier != theObj do 
			(
				global KrakatoaChannelEditor_LastUndoRecordNumber = 0
			)	
			global KrakatoaChannelNodeEditor_CurrentModifier = theObj
			global KrakatoaChannelEditor_BaseNodeTreeData = execute theObj.internalFlow
			global KrakatoaChannelEditor_NodeTreeEditingLevel = #()
			global KrakatoaChannelEditor_NodeTreeEditingNames = #()
			global KrakatoaChannelEditor_NodeTreeEditingUndoLevel = #()			
			KrakatoaChannelsEditor_Functions.buildDisplayTree()
			
			/*
			local theSize = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Size")
			if theSize == OK do theSize = [980,600]
			local thePos = execute (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "ParticleChannelEditor" "Position")
			if thePos == OK do thePos = [100,100]
			createDialog KrakatoaChannelNodeEditor_Rollout theSize.x theSize.y thePos.x thePos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing, #style_minimizebox, #style_maximizebox) menu:KrakatoaChannelNodeEditor_Rollout_MainMenu
			KrakatoaChannelNodeEditor_Rollout.resized theSize	
			*/
			
			KrakatoaChannelNodeEditor_Rollout.title = "Krakatoa Channels Editor - ID:" + KrakatoaChannelNodeEditor_CurrentModifier.trackID as string + " - ["+ KrakatoaChannelNodeEditor_CurrentModifier.name+"]"
			KrakatoaChannelNodeEditor_Rollout.createNodeTree init:true
			KrakatoaChannelNodeEditor_Rollout.displaySelectedNodeProperties()
			KrakatoaChannelNodeEditor_Rollout.chk_autoUpdateModifier.state = KrakatoaChannelNodeEditor_CurrentModifier.autoUpdate
			setFocus KrakatoaChannelNodeEditor_Rollout.hc	
		)		
	)
	
	deleteAllChangeHandlers id:#KCE_CurrentModifierSceneParametersMonitor
	callbacks.removeScripts id:#KrakatoaChannelEditor
	callbacks.addScript #modPanelObjPostChange "KrakatoaChannelEditor_ModifierCallback()" id:#KrakatoaChannelEditor
	callbacks.addScript #filePreOpen "try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch()" id:#KrakatoaChannelEditor
	callbacks.addScript #filePreSave "try(KrakatoaChannelEditor_TrackviewCleanupCallback())catch()" id:#KrakatoaChannelEditor
	callbacks.addScript #systemPostNew "try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch()" id:#KrakatoaChannelEditor
	callbacks.addScript #systemPostReset "try(destroyDialog KrakatoaChannelNodeEditor_Rollout)catch()" id:#KrakatoaChannelEditor
	
)	

