----------------------------------------------------------------------
-- Krakatoa for 3ds Max
-- Volumetric particle rendering.
-- Version 1.5.0 BETA 3 (1.4.3)
--
-- Copyright  2004-2009 Frantic Films Software
-- All rights reserved.
--
--
-- Development Team:
-- Darcy Harrison - dharrison@franticfilms.com
-- Borislav Petrov - bobo@franticfilms.com
-- Mark Wiebe - mwiebe@franticfilms.com
-- Mike Yurick - myurick@franticfilms.com
--
-- Please report bugs and comments to: software@franticfilms.com
----------------------------------------------------------------------

-- In case Deadline is in use, the Deadline interfaces need to be declared global.
global SMTDSettings, SMTDFunctions, FranticParticleRenderMXS, SMTDPaths, XMLSceneUtils
global FranticParticleRenderInitCheck 

global Krakatoa_CustomizeRollouts_Dialog
global Krakatoa_PRTIgnoreMissingFrames = false

global Krakatoa_PresetsDirectory = GetDir #plugcfg + "\\Krakatoa"
makeDir Krakatoa_PresetsDirectory 
makeDir (Krakatoa_PresetsDirectory  + "\\presets")
makeDir (Krakatoa_PresetsDirectory  + "\\history") 
makeDir (Krakatoa_PresetsDirectory  + "\\samples")

global Krakatoa_Closing_Floater = false
global Krakatoa_PresetIniFile
global Krakatoa_PresetDialogMode = #save
global Krakatoa_SavePresetDialog    	--the dialog rollout
global Krakatoa_DoExportTable = #() 	--list of rollout controls flags (true to save, false to skip)
global Krakatoa_ObjectsTable = #()  	--list of rollout controls to save
global Krakatoa_IsRendering = false  	--set by the local partitioning code to avoid the call of initialization function and associated prints to Log window
global Krakatoa_VFB_Overlay_Rollout, Krakatoa_VFB_Left_Rollout, Krakatoa_VFB_Right_Rollout --rollouts of the VFB Overlay in Max 2009 and higher
global Krakatoa_CustomizeRollouts_Dialog 

(
	--CUSTOM SKIN COLORS
	struct KrakatoaSkinColorsStructDef 
	(
		UseCustomColors = false,
		History = white,
		Main = color 255 200 150,
		Channels = white,
		Partitioning = color 200 255 200,
		Systems = color 255 200 150,
		Loaders = color 255 200 255,
		Thinking = color 255 150 200,
		Matte = color 255 255 200,
		Shadows = color 200 255 255,
		APME = white,
		Preferences = white,
		VFB = color 255 200 150
	)
	global KrakatoaSkinColorsStruct = KrakatoaSkinColorsStructDef()
)

global Krakatoa_LoadSkinColors 
fn Krakatoa_LoadSkinColors =
(
	local theDefaultColor =  ((colorman.getColor #activeCommand)*255) as color
	local KrakatoaPreferencesINI = (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" )
	local theValue  = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "UseCustomColors")
	KrakatoaSkinColorsStruct.UseCustomColors = if theValue == OK then false else theValue

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "History")
	KrakatoaSkinColorsStruct.History = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Main")
	KrakatoaSkinColorsStruct.Main = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor
	
	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Channels")
	KrakatoaSkinColorsStruct.Channels = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor
	
	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Partitioning") 
	KrakatoaSkinColorsStruct.Partitioning = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Systems") 
	KrakatoaSkinColorsStruct.Systems = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Loaders") 
	KrakatoaSkinColorsStruct.Loaders = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Thinking") 
	KrakatoaSkinColorsStruct.Thinking = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Matte") 
	KrakatoaSkinColorsStruct.Matte = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Shadows")  
	KrakatoaSkinColorsStruct.Shadows = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "APME") 
	KrakatoaSkinColorsStruct.APME = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor

	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "Preferences")  
	KrakatoaSkinColorsStruct.Preferences = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor
		
	theValue = execute (getIniSetting KrakatoaPreferencesINI "SkinColors" "VFB")  
	KrakatoaSkinColorsStruct.VFB = if KrakatoaSkinColorsStruct.UseCustomColors and classof theValue == Color then theValue else theDefaultColor
		
	true
)

Krakatoa_LoadSkinColors()

--------------------------------------------------
--GLOBAL VARIABLE DEFINITIONS--
--------------------------------------------------

global Krakatoa_GUI_Main, Krakatoa_GUI_Target, Krakatoa_GUI_SaveParticles
global Krakatoa_GUI_MatteObjects, Krakatoa_GUI_Partition, Krakatoa_GUI_Presets, Krakatoa_GUI_Notes, Krakatoa_GUI_ParticleLoaders, Krakatoa_GUI_Preferences, Krakatoa_GUI_Particles, Krakatoa_GUI_Shadows
global Krakatoa_GUI_History_Dialog, Krakatoa_GUI_AmbientPME, Krakatoa_GUI_Channels, Krakatoa_GUI_ThinkingParticles
global Krakatoa_GUI_FileSortingProgress_Dialog
global Krakatoa_GUI_About
global Krakatoa_Gui_floater, Krakatoa_Gui_floater_2, Krakatoa_Gui_floater_3
global Krakatoa_SeedIncrement_UserFunction
global Krakatoa_SeedIncrement_LastValue

try(closeRolloutFloater Krakatoa_GUI_Floater_2)catch()
if Krakatoa_GUI_Floater_2 == undefined do
	Krakatoa_GUI_Floater_2 = newRolloutFloater "Krakatoa Secondary Floater" 10 10 10 10
try(closeRolloutFloater Krakatoa_GUI_Floater_2)catch()

--Make sure MAXScript has enough Heap Memory for complex stuff. Default is 7.5MB, we give it 32MB.
if heapSize < 33554432 do heapSize = 33554432
	
-- When the renderer changes, we should close the UI, because all its values will become invalid.
callbacks.removeScripts id:#FranticParticles
callbacks.addScript #postRendererChange "FranticParticleRenderMXS.closerRolloutFloaters debugMessage:\"Closed by #PostRendererChange Callback.\"" id:#FranticParticles
callbacks.addScript #systemPostReset "FranticParticleRenderMXS.closerRolloutFloaters debugMessage:\"Closed by #SystemPostReset Callback.\"" id:#FranticParticles
callbacks.addScript #systemPostNew "FranticParticleRenderMXS.closerRolloutFloaters debugMessage:\"Closed by #SystemPostNew Callback.\"" id:#FranticParticles
callbacks.addScript #filePreOpen "FranticParticleRenderMXS.closerRolloutFloaters debugMessage:\"Closed by #SystemPostOpen Callback.\"" id:#FranticParticles



rollout Krakatoa_GUI_FileSortingProgress_Dialog "Krakatoa: Collecting And Sorting Data"
(
	label lbl_feedback "" align:#center
	progressbar prg_progress color:blue height:10 align:#center visible:false
)	

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--CUSTOMIZE GUI ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	

rollout Krakatoa_CustomizeRollouts_Dialog "Manage Krakatoa GUI Rollouts" category:0 rolledup:true
(
	local hiddenRollouts = #()
	local visibleRollouts = #()

	edittext edt_RolloutVisibilityPreset across:4 align:#left offset:[-10,0]  width:175
	button btn_saveVisibilityPreset "SAVE" align:#center offset:[28,0] width:40 height:18
	dropdownlist ddl_rolloutVisibilityPreset  align:#center offset:[45,-1] width:175
	button btn_loadVisibilityPreset "LOAD" align:#right width:40 offset:[12,0] height:18
	
	multilistbox lbx_hiddenRollouts "Hidden Rollouts" across:2 height:14 offset:[-10,0] 
	multilistbox lbx_visibleRollouts "Visible Rollouts [F]loat [D]ocked [S]econdary" height:14 offset:[10,0]
	
	button btn_selectAllHidden "All" 				width:42 height:20 align:#left offset:[-10,-5] across:10 tooltip:"Select ALL Hidden Rollouts"
	button btn_selectInvertHidden "Invert" 	width:42 height:20 align:#left offset:[-10,-5] tooltip:"INVERT the Hidden Rollouts Selection"
	button btn_selectDockedHidden "[D]" 		width:42 height:20 align:#left offset:[-10,-5] tooltip:"Select Hidden Rollouts that are DOCKED."
	button btn_selectFloatingHidden "[F]" 	width:42 height:20 align:#left offset:[-10,-5] tooltip:"Select Hidden Rollouts that are FLOATED."
	button btn_selectSecondaryHidden "[S]" width:42 height:20 align:#left offset:[-10,-5] tooltip:"Select Hidden Rollouts that are Docked to the SECONDARY Floater."

	button btn_selectAllVisible "All" 				width:42 height:20 align:#right offset:[10,-5] tooltip:"Select ALL Visible Rollouts"
	button btn_selectInvertVisible "Invert" 	width:42 height:20 align:#right offset:[10,-5] tooltip:"INVERT the Visible Rollouts Selection"
	button btn_selectDockedVisible "[D]" 		width:42 height:20 align:#right offset:[10,-5] tooltip:"Select Visible Rollouts that are DOCKED."
	button btn_selectFloatingVisible "[F]" 		width:42 height:20 align:#right offset:[10,-5] tooltip:"Select Visible Rollouts that are FLOATED."
	button btn_selectSecondaryVisible "[S]" 	width:42 height:20 align:#right offset:[10,-5] tooltip:"Select Visible Rollouts that are Docked to the SECONDARY Floater."
	

	button btn_dockHidden "Dock" 				width:71 height:20 align:#left offset:[-10,-3] across:6 tooltip:"Set Selected Hidden Rollouts To DOCKED. Will affect a rollout when it is unhidden."
	button btn_floatHidden "Float" 				width:70 height:20 align:#left offset:[-9,-3] tooltip:"Set Selected Hidden Rollouts To FLOATING. Will affect a rollout when it is unhidden."
	button btn_secondaryHidden "Secondary" width:71 height:20 align:#left offset:[-9,-3] tooltip:"Set Selected Hidden Rollouts To Docked To SECONDARY Floater. Will affect a rollout when it is unhidden."
	
	button btn_dockVisible "Dock" 				width:71 height:20 align:#right offset:[13,-3] tooltip:"Set Selected Visible Rollouts To DOCKED."
	button btn_floatVisible "Float" 				width:70 height:20 align:#right offset:[13,-3] tooltip:"Set Selected Visible Rollouts To FLOATING."
	button btn_secondaryVisible "Secondary" width:71 height:20 align:#right offset:[14,-3] tooltip:"Set Selected Visible Rollouts To Docked To SECONDARY Floater."
	
	button btn_moveRight ">" width:20 height:50 pos:[219,110]
	button btn_moveLeft "<" width:20 height:50 pos:[219,160]
	
	local allRollouts = #(
			Krakatoa_GUI_Presets, 
			Krakatoa_GUI_Main, 
			Krakatoa_GUI_SaveParticles,
			Krakatoa_GUI_Channels, 
			Krakatoa_GUI_Partition, 
			Krakatoa_GUI_Particles,
			Krakatoa_GUI_ParticleLoaders, 
			Krakatoa_GUI_ThinkingParticles,
			Krakatoa_GUI_MatteObjects, 
			Krakatoa_GUI_Shadows,
			Krakatoa_GUI_AmbientPME, 
			Krakatoa_GUI_Preferences, 
			Krakatoa_GUI_Notes, 
			Krakatoa_GUI_About
	)	
	
	fn Refresh_GUI =
	(
		hiddenRollouts = #()
		visibleRollouts = #()		

		for i in allRollouts do
		(
			local theState =  execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" i.title) 
			if theState == OK do theState = true
			if theState then append visibleRollouts i else append hiddenRollouts i  
		)
		lbx_hiddenRollouts.items = for i in hiddenRollouts collect 
		(
			local theDockedState = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" i.title) 
			if theDockedState == OK then theDockedState = true
			local theDockString = "F"
			if theDockedState then 
			(
				theDockString = "D" 
				local theDockHost = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" i.title) 	
				if theDockHost == "2" do theDockString = "S"
			)
			"["+theDockString+"] " + i.title
		)	
		lbx_visibleRollouts.items = for i in visibleRollouts collect 
		(
			local theDockedState = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" i.title) 
			if theDockedState == OK then theDockedState = true
			local theDockString = "F"
			if theDockedState then 
			(
				theDockString = "D" 
				local theDockHost = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" i.title) 	
				if theDockHost == "2" do theDockString = "S"
			)
			"["+theDockString+"] " + i.title
		)	
		
		local theLayoutPresetFiles = getFiles (Krakatoa_PresetsDirectory + "\\*.krl")
		local theArray = for i in theLayoutPresetFiles collect (getFileNameFile i)
		theArray  = join #("") theArray 
		ddl_rolloutVisibilityPreset.items = theArray 
	)

	fn moveRight =
	(
		local theArray = lbx_hiddenRollouts.selection as array
		for i = theArray.count to 1 by -1 do
		(			
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" hiddenRollouts[theArray[i]].title "true"
			try(destroyDialog hiddenRollouts[theArray[i]])catch()
			--addRollout hiddenRollouts[theArray[i]] Krakatoa_Gui_floater rolledup:false
			local theState = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" hiddenRollouts[theArray[i]].title)
			local theHost = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" hiddenRollouts[theArray[i]].title)
			if theState != false then
			(
				if theHost == "2" then
					FranticParticleRenderMXS.floatOrDockRollout hiddenRollouts[theArray[i]] forceMode:#dock2
				else
					FranticParticleRenderMXS.floatOrDockRollout hiddenRollouts[theArray[i]] forceMode:#dock
			)	
			else
				FranticParticleRenderMXS.floatOrDockRollout hiddenRollouts[theArray[i]] forceMode:#float
		)	
		Refresh_GUI()			
	)
	fn moveLeft =
	(
		local theArray = lbx_visibleRollouts.selection as array
		for i = theArray.count to 1 by -1 do
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" visibleRollouts[theArray[i]].title "false"
			try(destroyDialog visibleRollouts[theArray[i]])catch()
			try(removeRollout visibleRollouts[theArray[i]] Krakatoa_Gui_floater)catch()
			try(removeRollout visibleRollouts[theArray[i]] Krakatoa_Gui_floater_2)catch()
			if Krakatoa_Gui_floater_2.rollouts.count == 0 do closeRolloutFloater Krakatoa_Gui_floater_2
		)	
		Refresh_GUI()
	)
	
	on btn_floatAll pressed do
	(
		for i in allRollouts do
		(	
			local currentState =  execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" i.title ) 
			if currentState == OK do currentState = true
			if currentState do FranticParticleRenderMXS.floatOrDockRollout i forceMode:#float
		)	
		Refresh_GUI()
	)
	on btn_dockAll pressed do
	(
		for i in allRollouts do
		(
			local currentState =  execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" i.title ) 
			if currentState == OK do currentState = true
			if not currentState do FranticParticleRenderMXS.floatOrDockRollout i forceMode:#dock
		)		
		Refresh_GUI()
	)		
	on btn_toggleDockFloatAll pressed do
	(
		for i in allRollouts do
			FranticParticleRenderMXS.floatOrDockRollout i forceMode:#none
		Refresh_GUI()
	)			


	
	on btn_selectAllHidden pressed do
	(
		lbx_hiddenRollouts.selection = #{1..lbx_hiddenRollouts.items.count}
	)
	on btn_selectInvertHidden pressed do
	(
		lbx_hiddenRollouts.selection = -lbx_hiddenRollouts.selection
	)
	on btn_selectDockedHidden pressed do 
	(
		lbx_hiddenRollouts.selection = for i = 1 to lbx_hiddenRollouts.items.count where matchPattern lbx_hiddenRollouts.items[i] pattern:"*[D]*" collect i
	)
	on btn_selectFloatingHidden pressed do 
	(
		lbx_hiddenRollouts.selection = for i = 1 to lbx_hiddenRollouts.items.count where matchPattern lbx_hiddenRollouts.items[i] pattern:"*[F]*" collect i
	)	
	on btn_selectSecondaryHidden pressed do 
	(
		lbx_hiddenRollouts.selection = for i = 1 to lbx_hiddenRollouts.items.count where matchPattern lbx_hiddenRollouts.items[i] pattern:"*[S]*" collect i
	)
	
	on btn_dockHidden pressed do
	(
		for i in lbx_hiddenRollouts.selection do
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" hiddenRollouts[i].title "true"
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" hiddenRollouts[i].title "1"
		)
		Refresh_GUI()
	)		
	on btn_floatHidden pressed do
	(
		for i in lbx_hiddenRollouts.selection do
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" hiddenRollouts[i].title "false"
		)
		Refresh_GUI()
	)		
	on btn_secondaryHidden pressed do
	(
		for i in lbx_hiddenRollouts.selection do
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" hiddenRollouts[i].title "true"
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" hiddenRollouts[i].title "2"
		)
		Refresh_GUI()
	)		
	
	
	
	
	on btn_selectAllVisible pressed do
	(
		lbx_visibleRollouts.selection = #{1..lbx_visibleRollouts.items.count}
	)
	on btn_selectInvertVisible pressed do
	(
		lbx_visibleRollouts.selection = -lbx_visibleRollouts.selection
	)	
	on btn_selectDockedVisible pressed do 
	(
		lbx_visibleRollouts.selection = for i = 1 to lbx_visibleRollouts.items.count where matchPattern lbx_visibleRollouts.items[i] pattern:"*[D]*" collect i
	)
	on btn_selectFloatingVisible pressed do 
	(
		lbx_visibleRollouts.selection = for i = 1 to lbx_visibleRollouts.items.count where matchPattern lbx_visibleRollouts.items[i] pattern:"*[F]*" collect i
	)	
	on btn_selectSecondaryVisible pressed do 
	(
		lbx_visibleRollouts.selection = for i = 1 to lbx_visibleRollouts.items.count where matchPattern lbx_visibleRollouts.items[i] pattern:"*[S]*" collect i
	)		
	on btn_dockVisible pressed do
	(
		local oldSel = lbx_visibleRollouts.selection
		for i in lbx_visibleRollouts.selection do
			FranticParticleRenderMXS.floatOrDockRollout visibleRollouts[i] forceMode:#dock
		Refresh_GUI()
		lbx_visibleRollouts.selection = oldSel
	)	
	on btn_floatVisible pressed do
	(
		local oldSel = lbx_visibleRollouts.selection
		for i in lbx_visibleRollouts.selection do
			FranticParticleRenderMXS.floatOrDockRollout visibleRollouts[i] forceMode:#float
		Refresh_GUI()
		lbx_visibleRollouts.selection = oldSel
	)		
	on btn_secondaryVisible pressed do
	(
		local oldSel = lbx_visibleRollouts.selection
		for i in lbx_visibleRollouts.selection do
			FranticParticleRenderMXS.floatOrDockRollout visibleRollouts[i] forceMode:#dock2
		Refresh_GUI()
		lbx_visibleRollouts.selection = oldSel
	)		

	
	
	
	on lbx_visibleRollouts doubleClicked itm do moveLeft()
	on lbx_hiddenRollouts doubleClicked itm do moveRight()
	
	on btn_moveLeft pressed do moveLeft()
	on btn_moveRight pressed do moveRight()
	
	on btn_saveVisibilityPreset pressed do
	(
		if edt_RolloutVisibilityPreset.text != "" do
		(
			local theSourceFile =(Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") 
			local theTargetFile = (Krakatoa_PresetsDirectory + "\\"+ edt_RolloutVisibilityPreset.text +".krl")
			for i in allRollouts do
			(
				local currentState =  execute (getIniSetting theSourceFile "RolloutDocked" i.title ) 
				if currentState == OK do currentState = true
				local currentVis = execute (getIniSetting theSourceFile "RolloutVisible" i.title ) 
				if currentVis == OK do currentVis = true
				local currentPos = getIniSetting theSourceFile "RolloutDialogPositions" i.title
				local currentHost = getIniSetting theSourceFile "RolloutDockHost" i.title
				if currentHost == "" do currentHost = "1"
				
				setIniSetting theTargetFile "RolloutVisible" i.title (currentVis as string)
				setIniSetting theTargetFile "RolloutDocked" i.title (currentState as string)
				setIniSetting theTargetFile "RolloutDockHost" i.title currentHost 
				setIniSetting theTargetFile "RolloutDialogPositions" i.title currentPos
			)					
			Refresh_GUI()
		)
	)
	on btn_loadVisibilityPreset pressed do
	(
		if ddl_rolloutVisibilityPreset.selected != "" do
		(
			local theTargetFile =(Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") 
			local theSourceFile= (Krakatoa_PresetsDirectory + "\\"+ ddl_rolloutVisibilityPreset.selected +".krl")
			
			for i in allRollouts do
			(
				local currentState =  execute (getIniSetting theSourceFile "RolloutDocked" i.title ) 
				if currentState == OK do currentState = true
				local currentVis = 	execute (getIniSetting theSourceFile "RolloutVisible" i.title ) 
				if currentVis == OK do currentVis = true
				local currentHost = (getIniSetting theSourceFile "RolloutDockHost" i.title ) 
				if currentHost == "" do currentHost = "1"
					
				setIniSetting theTargetFile "RolloutVisible" i.title (currentVis as string)
				setIniSetting theTargetFile "RolloutDocked" i.title (currentState as string)
				setIniSetting theTargetFile "RolloutDockHost" i.title currentHost 
				
				try(destroyDialog i)catch()
				try(removeRollout i Krakatoa_Gui_floater)catch()
				if currentVis then
				(
					if currentState then 
					(
						if currentHost == "2" then
							FranticParticleRenderMXS.floatOrDockRollout i forceMode:#dock2
						else	
							FranticParticleRenderMXS.floatOrDockRollout i forceMode:#dock
					)	
					else
						FranticParticleRenderMXS.floatOrDockRollout i forceMode:#float
				)	
			)					
		)
		Refresh_GUI()
	)		
	
	on ddl_rolloutVisibilityPreset selected itm do
	(
		edt_RolloutVisibilityPreset.text = ddl_rolloutVisibilityPreset.selected
	)

	on Krakatoa_CustomizeRollouts_Dialog moved pos do 
	(
		FranticParticles.SetProperty "GUI:Position" (pos as string)
		setINIsetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Dialog" "Position" (pos as string)
		if FranticParticleRenderMXS.lockSecondaryToPrimaryFloater do
			Krakatoa_GUI_Floater_2.pos = pos + [484,0]
	)	
	on Krakatoa_CustomizeRollouts_Dialog resized size do FranticParticles.SetProperty "GUI:Size" (size as string)
	
	on Krakatoa_CustomizeRollouts_Dialog close do
	(
		global Krakatoa_Closing_Floater = true
		for i in allRollouts do try(destroyDialog i)catch()
		try(closeRolloutFloater Krakatoa_GUI_Floater_2)catch()
		global Krakatoa_Closing_Floater = false
		global KrakatoaGuiOpen = false
		updateToolbarButtons()
		FranticParticles.LogProgress "+Krakatoa GUI CLOSED."
		FranticParticles.LogProgress ("-----" +localtime + "--------------------------")
		FranticParticles.LogProgress ("                                                                 ")
	)
	
	on Krakatoa_CustomizeRollouts_Dialog open do
	(
		Refresh_GUI()
	)
)



--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--RIGHT CLICK CONTEXT MENUS
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
(
	global Krakatoa_RCMenu_Struct 
	struct Krakatoa_RCMenu_StructDef 
	(
		Float_Rollout_RCMenu,
		ParticleCache_RCMenu,
		RenderButton_RCMenu,
		IterativeOptions_RCMenu,
		History_FilterValue_RCMenu,
		Presets_RCMenu,
		Load_Save_Rollout_RCMenu,
		HistoryPatternOptions01_RCMenu,
		HistoryPatternOptions02_RCMenu,
		
		Float_Rollout_RCMenu_CurrentRollout,
		IterativeOptions_Selection="1",
		IterativeOptions_ScaleDensity = false
	)
	Krakatoa_RCMenu_Struct = Krakatoa_RCMenu_StructDef()
	
	rcmenu Load_Save_Rollout_RCMenu
	(
		menuItem save_Rollout_Preset "Save this Rollout's Controls as Preset..."
		menuItem load_Rollout_Preset "Load this Rollout's Controls from Preset..."
		separator sep_10
		submenu "More Options..."
		(
			menuItem save_All_Preset "Save All Controls as Preset..."
			menuItem load_All_Preset "Load All Controls from Preset..."
			separator sep_20
			menuItem load_Rollout_History "Load this Rollout's Controls from History..."
			menuItem load_All_History "Load All Controls from History..."
		)
		
		on save_Rollout_Preset picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout
			FranticParticleRenderMXS.PresetFilterString = ""
			Krakatoa_PresetDialogMode = #save
			FranticParticleRenderMXS.displaySavePresetDialog()
		)	
		
		on load_Rollout_Preset picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout
			FranticParticleRenderMXS.PresetFilterString = "*_"+ FranticParticleRenderMXS.fixTimeString Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout.title
			Krakatoa_PresetDialogMode = #load
			FranticParticleRenderMXS.displaySavePresetDialog()
		)		
		
		on save_All_Preset picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = undefined 
			FranticParticleRenderMXS.PresetFilterString = ""
			Krakatoa_PresetDialogMode = #save
			FranticParticleRenderMXS.displaySavePresetDialog()
		)	
		
		on load_All_Preset picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
			FranticParticleRenderMXS.PresetFilterString = ""
			Krakatoa_PresetDialogMode = #load
			FranticParticleRenderMXS.displaySavePresetDialog()
		)		

		on load_Rollout_History picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout
			FranticParticleRenderMXS.PresetFilterString = getFileNameFile maxFileName
			Krakatoa_PresetDialogMode = #loadHistory
			FranticParticleRenderMXS.displaySavePresetDialog()
		)		
		
		on load_All_History picked do
		(
			FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
			FranticParticleRenderMXS.PresetFilterString = ""
			Krakatoa_PresetDialogMode = #loadHistory
			FranticParticleRenderMXS.displaySavePresetDialog()
		)			
	)
	Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu = Load_Save_Rollout_RCMenu

	rcmenu Float_Rollout_RCMenu
	(
		fn isNotInDialog = (not Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout.inDialog)
		fn isNotInFloater1 = try(findItem Krakatoa_GUI_Floater.rollouts Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout == 0)catch(true)
		fn isNotInFloater2 = try(findItem Krakatoa_GUI_Floater_2.rollouts Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout == 0)catch(true)
		menuitem mnu_floatAsDialog "Float Rollout as Free Dialog" filter:isNotInDialog
		menuitem mnu_dockRolloutInPrimaryFloater "Dock Rollout in Primary Floater" filter:isNotInFloater1
		menuitem mnu_dockRolloutInSecondaryFloater "Dock Rollout in Secondary Floater" filter:isNotInFloater2
		separator sep_10
		menuitem mnu_disableRollout "Hide Rollout" 
		separator sep_20
		menuitem mnu_lockSecondaryToPrimaryFloater "Lock Secondary To Primary Floater" checked:FranticParticleRenderMXS.lockSecondaryToPrimaryFloater
		
		on mnu_lockSecondaryToPrimaryFloater picked do
		(
			FranticParticleRenderMXS.lockSecondaryToPrimaryFloater = not FranticParticleRenderMXS.lockSecondaryToPrimaryFloater
			if FranticParticleRenderMXS.lockSecondaryToPrimaryFloater then
			(
				local thePos = execute(FranticParticles.GetProperty "GUI:Position")
				if FranticParticleRenderMXS.lockSecondaryToPrimaryFloater do
					Krakatoa_GUI_Floater_2.pos = thePos + [484,0]
			)	
		)
		
		on mnu_floatAsDialog picked do
		(
			FranticParticleRenderMXS.floatOrDockRollout Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout forceMode:#float
		)
		on mnu_dockRolloutInPrimaryFloater picked do
		(
			FranticParticleRenderMXS.floatOrDockRollout Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout forceMode:#dock
		)
		on mnu_dockRolloutInSecondaryFloater picked do
		(
			FranticParticleRenderMXS.floatOrDockRollout Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout forceMode:#dock2
		)
		on mnu_disableRollout picked do
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout.title "false"
			try(destroyDialog Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout)catch()
			try(removeRollout Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout Krakatoa_Gui_floater)catch()
			try(removeRollout Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout Krakatoa_Gui_floater_2)catch()
			if Krakatoa_Gui_floater_2.rollouts.count == 0 do closeRolloutFloater Krakatoa_Gui_floater_2		
			Krakatoa_CustomizeRollouts_Dialog.refresh_GUI()
		)		
	)	

	Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu = Float_Rollout_RCMenu
	
	rcmenu ParticleCache_RCMenu 
	(
		menuitem mnu_cacheSize "In Memory: 0 Particles using 0.0 MB"
		separator spr_cache01
		menuitem mnu_ClearLightingCache "Clear Lighting Cache Only"
		menuitem mnu_ClearCaches "Clear Both Caches"
		separator spr_cache02
		menuitem mnu_cacheLastFrame "Keep Last Frame In Cache" checked:(FranticParticles.GetBoolProperty "CacheLastFrame")
		menuitem mnu_UseCacheInSlaveMode "Use Cache In Slave Mode" checked:(FranticParticles.GetBoolProperty "UseCacheInSlaveMode")
		
		on mnu_UseCacheInSlaveMode picked do
		(
			if not (FranticParticles.GetBoolProperty "UseCacheInSlaveMode") then
			(
				local q = querybox "You requested to turn ON the option to KEEP PARTICLES IN CACHE during Network Rendering\n\nThis means that the first frame loaded by a machine will be kept in memory and rendered on all frames.\nThis is a very special and DANGEROUS mode! It will be enabled for THIS SCENE ONLY and will not be sticky for other sessions.\n\nPlease confirm you really know what you are doing by clicking [Yes]. If you did not understand the above warning, you should probably click [No]." title:"REALLY Enable PCache In Slave Mode?"
				if q == true do FranticParticles.SetProperty "UseCacheInSlaveMode" "true"
			)
			else
			(
				FranticParticles.SetProperty "UseCacheInSlaveMode" "false"
			)	
		)
		
		on mnu_cacheSize picked do FranticParticles.LogStats mnu_cacheSize.text
		on mnu_cacheLastFrame picked do 
		(
			FranticParticles.SetProperty "CacheLastFrame" (not (FranticParticles.GetBoolProperty "CacheLastFrame"))
			Krakatoa_GUI_Preferences.refresh_GUI()
		)	
		on mnu_ClearLightingCache picked do 
		(
			FranticParticles.InvalidateLightingCache()
			Krakatoa_GUI_Main.refreshCacheStatus()
			Krakatoa_GUI_Channels.updateMemChannels()
			try(Krakatoa_VFB_Overlay_Rollout.refresh_GUI())catch()
		)	
		on mnu_ClearCaches picked do 
		(
			FranticParticles.InvalidateParticleCache()
			Krakatoa_GUI_Main.refreshCacheStatus()
			Krakatoa_GUI_Channels.updateMemChannels()
			try(Krakatoa_VFB_Overlay_Rollout.refresh_GUI())catch()
		)	
	)

	Krakatoa_RCMenu_Struct.ParticleCache_RCMenu = ParticleCache_RCMenu

	rcmenu RenderButton_RCMenu
	(
		fn filterFN = ((FranticParticles.GetProperty "ParticleMode") != "Save Particles To File Sequence")
		fn filterBBFN = (FranticParticleRenderMXS.DeadlineDetected > 0)
		menuitem mnu_IgnoreMissingFrames "Ignore Missing Particle Files" checked:(Krakatoa_PRTIgnoreMissingFrames == true)
		separator spr_01
		
		menuitem mnu_RenderSceneDialog "Open Render Scene Dialog..." checked:(renderSceneDialog.isOpen())
		menuitem mnu_KeepRenderSceneDialogOpen "Keep Render Scene Dialog Open" checked:((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
		separator spr_05
		
		menuitem mnu_SaveRenderPath "Save Render Output" checked:rendSaveFile enabled:(rendOutputFileName != "") filter:filterFN 
		menuitem mnu_SetSaveRenderPath "Set Render Output Filename..." checked:(rendOutputFileName != "") filter:filterFN 
		
		menuitem mnu_exploreRenderPath "Explore Render Path..." enabled:(rendOutputFileName != "") filter:filterFN 
		separator spr_10 filter:filterFN 
		menuitem mnu_singleFrame "Single Frame" checked:(rendTimeType == 1)
		menuitem mnu_activeSegment "Active Segment" checked:(rendTimeType == 2)
		menuitem mnu_customRange "Custom Range" checked:(rendTimeType == 3)
		menuitem mnu_CustomFrames "Custom Frames" checked:(rendTimeType == 4)
		separator spr_20 filter:filterFN
		menuitem mnu_NetRender "Net Render Using Backburner" checked:rendUseNet enabled:((FranticParticles.GetProperty "ParticleMode")!="Save Particles To File Sequence") filter:filterBBFN 
		separator spr_30 filter:filterBBFN
		menuitem mnu_SaveAttenuationMaps "Save Attenuation Maps" checked:(FranticParticles.GetBoolProperty "EnableAttenuationMapSaving") enabled:(rendSaveFile and rendOutputFileName != "") filter:filterFN
		
		on mnu_IgnoreMissingFrames picked do Krakatoa_PRTIgnoreMissingFrames = not Krakatoa_PRTIgnoreMissingFrames
		
		on mnu_SaveAttenuationMaps picked do 
		(
			local theState = (FranticParticles.GetBoolProperty "EnableAttenuationMapSaving")
			theState = not theState 
			FranticParticles.SetProperty "EnableAttenuationMapSaving" (theState as string)
			Krakatoa_GUI_Shadows.refresh_GUI()
		)
		
		on mnu_RenderSceneDialog picked do if renderSceneDialog.isOpen() then renderSceneDialog.close() else renderSceneDialog.open() 
		on mnu_KeepRenderSceneDialogOpen picked do
		(
			local theVal = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")		
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen" ((not theVal) as string)
		)
		
		on mnu_exploreRenderPath picked do shelllaunch "explorer.exe" (getFileNamePath rendOutputFileName)
		on mnu_SaveRenderPath picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			rendSaveFile = not rendSaveFile 
			if oldState and keepOpen do renderSceneDialog.open()
		)	

		on mnu_SetSaveRenderPath picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			theBitmapPath = getBitmapSaveFileName filename:rendOutputFilename
			if theBitmapPath != undefined do
			(
				rendOutputFilename = theBitmapPath 
				rendSaveFile = true
			)	
			if oldState and keepOpen do renderSceneDialog.open()	
		)	

		
		on mnu_singleFrame picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			rendTimeType = 1
			if oldState and keepOpen do renderSceneDialog.open()
			Krakatoa_GUI_Main.refresh_GUI()
		)	
		on mnu_activeSegment picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			rendTimeType = 2
			if oldState and keepOpen do renderSceneDialog.open()
			Krakatoa_GUI_Main.refresh_GUI()
		)	
		on mnu_customRange picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			rendTimeType = 3
			if oldState and keepOpen do renderSceneDialog.open()
			Krakatoa_GUI_Main.refresh_GUI()
		)	
		on mnu_CustomFrames picked do 
		(
			local oldState = renderSceneDialog.isOpen()
			local keepOpen = ((getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "KeepRenderSceneDialogOpen")=="true")
			renderSceneDialog.close()
			rendTimeType = 4
			if oldState and keepOpen do renderSceneDialog.open()
			Krakatoa_GUI_Main.refresh_GUI()
		)	
	)--end menu
	Krakatoa_RCMenu_Struct.RenderButton_RCMenu = RenderButton_RCMenu
	
	
	
	rcmenu IterativeOptions_RCMenu 
	(
		menuitem mnu_renderRes_2 "Double Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="2")
		separator sep_10
		menuitem mnu_renderRes_1 "Full Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="1")
		separator sep_20
		menuitem mnu_renderRes_1_2 "1/2 Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="1/2")
		menuitem mnu_renderRes_1_4 "1/4 Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="1/4")
		menuitem mnu_renderRes_1_8 "1/8 Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="1/8")
		menuitem mnu_renderRes_1_16 "1/16 Resolution" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_Selection=="1/6")
		--separator sep_30
		--menuitem mnu_ScaleDensity "Scale Density" checked:(Krakatoa_RCMenu_Struct.IterativeOptions_ScaleDensity)
		
		on mnu_ScaleDensity picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_ScaleDensity = not Krakatoa_RCMenu_Struct.IterativeOptions_ScaleDensity
		)	
		
		on mnu_renderRes_2 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "2"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
		on mnu_renderRes_1 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "1"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
		on mnu_renderRes_1_2 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "1/2"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
		on mnu_renderRes_1_4 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "1/4"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
		on mnu_renderRes_1_8 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "1/8"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
		on mnu_renderRes_1_16 picked do 
		(
			Krakatoa_RCMenu_Struct.IterativeOptions_Selection = "1/16"
			Krakatoa_GUI_Main.updateIterativeRenderText()
		)	
			
	)
	Krakatoa_RCMenu_Struct.IterativeOptions_RCMenu = IterativeOptions_RCMenu
	
	rcmenu HistoryPatternOptions01_RCMenu 
	(
		fn filterFN =
		(
			Krakatoa_GUI_Presets.ddl_historyFiles01.selection > 0
		)
		fn	filterSceneFN = Krakatoa_GUI_Presets.rad_files01.state == 2 and maxFileName != ""
		fn filterClearFN = Krakatoa_GUI_Presets.edt_filter01.text.count > 0
		
		menuitem mnu_getFromList "Get Search Pattern From RECORD Name" filter:filterFN 
		menuitem mnu_getFromMaxScene "Get Search Pattern From SCENE File Name" filter:filterSceneFN 
		menuitem mnu_clear "CLEAR Search Pattern" filter:filterClearFN 
		
		on mnu_getFromList picked do 
		(
			if Krakatoa_GUI_Presets.ddl_historyFiles01.selection > 0 do
			(
				if Krakatoa_GUI_Presets.rad_files01.state == 1 then 
					theString = Krakatoa_GUI_Presets.ddl_historyFiles01.selected 
				else
				(
					theString = ""
					theFS = filterString Krakatoa_GUI_Presets.ddl_historyFiles01.selected "_"
					for i = 1 to theFS.count-6 do theString+= theFS[i] + "_"
				)
				Krakatoa_GUI_Presets.edt_filter01.changed (Krakatoa_GUI_Presets.edt_filter01.text = theString)
			)	
		)	
		
		on mnu_getFromMaxScene picked do 
		(
			Krakatoa_GUI_Presets.edt_filter01.changed (Krakatoa_GUI_Presets.edt_filter01.text = getFileNameFile maxFileName)
		)	

		on mnu_clear picked do 
		(
			Krakatoa_GUI_Presets.edt_filter01.changed (Krakatoa_GUI_Presets.edt_filter01.text = "")
		)			
		
	)
	Krakatoa_RCMenu_Struct.HistoryPatternOptions01_RCMenu = HistoryPatternOptions01_RCMenu	
	
	rcmenu HistoryPatternOptions02_RCMenu 
	(
		fn filterFN =
		(
			Krakatoa_GUI_Presets.ddl_historyFiles01.selection > 1
		)	
		fn	filterSceneFN = Krakatoa_GUI_Presets.rad_files02.state == 2 and maxFileName != ""
		fn filterClearFN = Krakatoa_GUI_Presets.edt_filter02.text.count > 0
			
		menuitem mnu_getFromList "Get Search Pattern From RECORD Name" filter:filterFN 
		menuitem mnu_getFromMaxScene "Get Search Pattern From SCENE File Name" filter:filterSceneFN 
		menuitem mnu_clear "CLEAR Search Pattern" filter:filterClearFN 
		
		on mnu_getFromList picked do 
		(
			if Krakatoa_GUI_Presets.ddl_historyFiles02.selection > 0 do
			(
				if Krakatoa_GUI_Presets.rad_files02.state == 1 then 
					theString = Krakatoa_GUI_Presets.ddl_historyFiles02.selected 
				else
				(
					theString = ""
					theFS = filterString Krakatoa_GUI_Presets.ddl_historyFiles02.selected "_"
					for i = 1 to theFS.count-6 do theString+= theFS[i] + "_"
				)
				Krakatoa_GUI_Presets.edt_filter02.changed (Krakatoa_GUI_Presets.edt_filter02.text = theString)
			)	
		)	
		
		on mnu_getFromMaxScene picked do 
		(
			Krakatoa_GUI_Presets.edt_filter02.changed (Krakatoa_GUI_Presets.edt_filter02.text = getFileNameFile maxFileName)
		)	

		on mnu_clear picked do 
		(
			Krakatoa_GUI_Presets.edt_filter02.changed (Krakatoa_GUI_Presets.edt_filter02.text = "")
		)			
		
	)
	Krakatoa_RCMenu_Struct.HistoryPatternOptions02_RCMenu = HistoryPatternOptions02_RCMenu		

)--end local scope






--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PRESETS AND HISTORY ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_Presets "Presets and History" rolledup:true category:1 width:457
(
	local theLockOffset = 0
	local ComparisonArray = #()
	local leftBitmap = bitmap 213 160
	local rightBitmap = bitmap 213 160
	local leftBitmapFileName = ""
	local rightBitmapFileName = ""
	local leftBitmapPreview, rightBitmapPreview 
	local thePresetFiles = #()
	local theHistoryFiles = #() 
	
	button btn_Help_History  "Open Krakatoa Online Help..." height:14 width:430 align:#left offset:[-10,-5] across:2
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	on btn_Help_History pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/presets_and_history.php" ""

	button btn_savePresetAll "Save Preset..." width:110 align:#left offset:[-6,-3] across:4 tooltip:"Press to open the Krakatoa Presets SAVE dialog."
	button btn_loadPresetAll "Load Preset..." width:110 align:#center offset:[-1,-3] tooltip:"Press to open the Krakatoa Presets LOAD dialog."
	button btn_loadHistory "Load From History..." width:110 align:#center offset:[4,-3] tooltip:"Press to open the Krakatoa History LOAD dialog."
	button btn_ExplorePresetDir "Explore Folder..." width:110 align:#right offset:[8,-3] tooltip:"Press to open the Krakatoa Presets/History folder in Windows Explorer to delete, copy, edit and otherwise manage Preset, History and Thumbnail files."
	
	checkbutton chk_SaveRenderHistory ">Save Render History" checked:true offset:[-3,-2] across:2 width:220 highlightcolor:KrakatoaSkinColorsStruct.History
	checkbutton chk_SaveImageSample ">Save Image Sample" checked:true offset:[3,-2] width:220 highlightcolor:KrakatoaSkinColorsStruct.History

	group "Compare Settings"
	(
		radiobuttons rad_files01 labels:#("Presets","History") across:5 align:#left default:2 offset:[0,-3] columns:2
		button btn_update "Update" width:60 height:20 align:#center tooltip:"Force a refresh the comparison list." offset:[20,-5] 
		button btn_align "Align" width:60 height:20 align:#center tooltip:"Align the comparison lists with an offset of one. Both lists must be in the same display mode - either Presets or History." offset:[-5,-5]
		checkbutton chk_lock ">Scroll Lock" width:70 height:20 offset:[-25,-5] align:#center tooltip:"Lock Selection in Left and Right drop-down list. Scrolling the one list will scoll the other with constant offset."  highlightcolor:KrakatoaSkinColorsStruct.History
		radiobuttons rad_files02 labels:#("Presets","History") align:#right offset:[8,-3] columns:2 default:2

		edittext edt_filter01 width:204 align:#left offset:[-8,-4] across:4
		button btn_filterOptions01 ">>" width:15 height:17 align:#left offset:[90,-4] 
		edittext edt_filter02 width:204 align:#right offset:[94,-4]
		button btn_filterOptions02 ">>" width:15 height:17 align:#right offset:[4,-4] 
		
		dropdownlist ddl_historyFiles01 items:#("[Current]") width:218 across:2 align:#left offset:[-4,-2]
		dropdownlist ddl_historyFiles02 items:#("[Current]") width:218 align:#right offset:[4,-2]
		
		listbox lbx_compareSettings width:440 align:#center height:6 offset:[0,-4]
		
		edittext edt_settings01 width:185 align:#left offset:[-8,-4] across:4
		button btn_get01 "Set..." width:35 height:18 align:#left offset:[71,-4]
		edittext edt_settings02 width:185 align:#right offset:[76,-4]
		button btn_get02 "Set..." width:35 height:18 align:#right offset:[5,-4]
		
		listbox lbx_SceneInfo01 width:440 height:7 align:#center offset:[0,-2]
		listbox lbx_SceneInfo02 width:440 height:7 align:#center offset:[0,-7]

		button btn_deletePreset01 "Delete Record/Thumbnail..." width:145 align:#left across:3 offset:[-4,-4]
		button btn_compareImages "Compare in RAM Player..." width:145 align:#center offset:[0,-4] tooltip:"Open one or both images (if available) in RAM Player for viewing or A|B comparison"
		button btn_deletePreset02 "Delete Record/Thumbnail..." width:145 align:#right offset:[4,-4]

		button btn_imagefile01 width:220 height:165 align:#left across:2 offset:[-4,-4]
		button btn_imagefile02 width:220 height:165 align:#right offset:[4,-4]
	)
	
	
	fn rebuildPresetsCache =
	(
		local st = timestamp()
		try(destroyDialog Krakatoa_GUI_FileSortingProgress_Dialog)catch()
		createDialog Krakatoa_GUI_FileSortingProgress_Dialog 400 40
		Krakatoa_GUI_FileSortingProgress_Dialog.prg_progress.visible = true
		FranticParticles.LogDebug (">Rebuilding Preset Cache...")
		local theFiles = getFiles (Krakatoa_PresetsDirectory + "\\presets\\*.KrakatoaPreset") 
		Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Sorting "+ theFiles.count as string +" Presets... This might take a while!"
		local theCache = createFile (Krakatoa_PresetsDirectory+"\\_PresetsCache.List")
		local cnt = 0
		local theSortedFiles = (FranticParticleRenderMXS.sortFilesByDate theFiles)
		Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Rebuilding Presets Cache with "+ theFiles.count as string +" Entries... This might take a while!"
		for f in theSortedFiles do 
		(
			format "%\n" (getFileNameFile f) to:theCache
			append thePresetFiles (getFileNameFile f)
			cnt += 1
			Krakatoa_GUI_FileSortingProgress_Dialog.prg_progress.value = 50.0*cnt/theFiles.count
		)	
		close theCache	
		FranticParticles.LogDebug (" +" + theFiles.count as string + " Preset File(s) Cached.")
		try(destroyDialog Krakatoa_GUI_FileSortingProgress_Dialog)catch()
		FranticParticles.LogDebug (" +Rebuilding Preset Cache FINISHED in " + (timestamp() - st) as string + "ms.")		
	)
	fn rebuildHistoryCache =
	(
		local st = timestamp()
		try(destroyDialog Krakatoa_GUI_FileSortingProgress_Dialog)catch()
		createDialog Krakatoa_GUI_FileSortingProgress_Dialog 400 40
		Krakatoa_GUI_FileSortingProgress_Dialog.prg_progress.visible = true
		FranticParticles.LogDebug (">Rebuilding History Cache...")
		local theFiles = getFiles (Krakatoa_PresetsDirectory + "\\history\\*.KrakatoaSettings") 
		Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Sorting "+ theFiles.count as string +" History files... This might take a while!"
		local theCache = createFile (Krakatoa_PresetsDirectory+"\\_HistoryCache.List")
		local cnt = 0
		local theSortedFiles = (FranticParticleRenderMXS.sortFilesByDate theFiles)
		Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Rebuilding History Cache with "+ theFiles.count as string +" Entries... This might take a while!"
		for f in theSortedFiles do
		(
			format "%\n" (getFileNameFile f) to:theCache
			append theHistoryFiles (getFileNameFile f)
			cnt += 1
			Krakatoa_GUI_FileSortingProgress_Dialog.prg_progress.value = 50+50.0*cnt/theFiles.count				
		)				
		close theCache	
		FranticParticles.LogDebug (" +" + theFiles.count as string + " History File(s) Cached.")
		try(destroyDialog Krakatoa_GUI_FileSortingProgress_Dialog)catch()
		FranticParticles.LogDebug (" +Rebuilding History Cache FINISHED in " + (timestamp() - st) as string + "ms.")
	)
	
	fn updateLists =
	(	
		local st = timestamp()
		FranticParticles.LogDebug (">Updating History and Preset Lists...")
		if not doesFileExist (Krakatoa_PresetsDirectory+"\\_PresetsCache.List") do
			rebuildPresetsCache()
		if not doesFileExist (Krakatoa_PresetsDirectory+"\\_HistoryCache.List")  do 
			rebuildHistoryCache()
		
		local theCache = openFile (Krakatoa_PresetsDirectory+"\\_PresetsCache.List")
		local thePresetFiles = #()
		while not eof theCache do
			append thePresetFiles (readline theCache)
		close theCache	

		local theCache = openFile (Krakatoa_PresetsDirectory+"\\_HistoryCache.List")
		local theHistoryFiles = #()
		while not eof theCache do
			append theHistoryFiles (readline theCache)
		close theCache	
		
		if theHistoryFiles.count != (getFiles (Krakatoa_PresetsDirectory + "\\history\\*.KrakatoaSettings") ).count do rebuildHistoryCache()
		if thePresetFiles.count != (getFiles (Krakatoa_PresetsDirectory + "\\presets\\*.KrakatoaPreset") ).count do rebuildPresetsCache()
		
		local thePattern01 = "*"
		local thePattern02 = "*"
		if edt_filter01.text != "" do thePattern01 = edt_filter01.text + "*"
		if edt_filter02.text != "" do thePattern02 = edt_filter02.text + "*"
		
		ddl_historyFiles01.items = if rad_files01.state == 2 then 
			for i = theHistoryFiles.count to 1 by -1 where matchPattern theHistoryFiles[i] pattern:thePattern01 collect theHistoryFiles[i]
		else	
			for i = thePresetFiles.count to 1 by -1 where matchPattern thePresetFiles[i] pattern:thePattern01 collect thePresetFiles[i]

		ddl_historyFiles02.items = if rad_files02.state == 2 then
			join #("[Current]") (for i = theHistoryFiles.count to 1 by -1 where matchPattern theHistoryFiles[i] pattern:thePattern02 collect theHistoryFiles[i]) 
		else	
			join #("[Current]") (for i = thePresetFiles.count to 1 by -1 where matchPattern thePresetFiles[i] pattern:thePattern02 collect thePresetFiles[i])	
		if ddl_historyFiles01.selection == 0 and ddl_historyFiles01.items.count > 0 do ddl_historyFiles01.selection = ddl_historyFiles01.items.count
		if ddl_historyFiles02.selection == 0 and ddl_historyFiles02.items.count > 0 do ddl_historyFiles02.selection = ddl_historyFiles02.items.count
		FranticParticles.LogDebug (" +Updating History and Preset Lists FINISHED in " + (timestamp() - st) as string + "ms." )
	)
	
	fn compareSettings =
	(
		local st = timestamp()
		FranticParticles.LogDebug (">Comparing Settings...")
		if ddl_historyFiles01.selection > 0 and ddl_historyFiles02.selection > 0 then
		(
			if rad_files01.state == 1 then
				file01 = Krakatoa_PresetsDirectory + "\\presets\\" + ddl_historyFiles01.selected + ".KrakatoaPreset"
			else	
				file01 = Krakatoa_PresetsDirectory + "\\history\\" + ddl_historyFiles01.selected+ ".KrakatoaSettings"
			if ddl_historyFiles02.selection == 1 then
			(
				file02 = Krakatoa_PresetsDirectory + "\\_CurrentSettings.KrakatoaSettings" 
				deleteFile file02
				FranticParticleRenderMXS.savePresetAll file02
			)	
			else
			(			
				if rad_files02.state == 1 then
					file02 = Krakatoa_PresetsDirectory + "\\presets\\" + ddl_historyFiles02.selected+ ".KrakatoaPreset"
				else	
					file02 = Krakatoa_PresetsDirectory + "\\history\\" + ddl_historyFiles02.selected+ ".KrakatoaSettings"
			)		
				
			ComparisonArray = FranticParticleRenderMXS.compareSettings file01 file02
			local tempArray = #()
			for i in ComparisonArray do
			(
				local theRollout = execute i[1]
				if theRollout != undefined then
					theRolloutName = theRollout.title
				else
					theRolloutName = i[1]
				if matchPattern theRolloutName pattern:"Krakatoa:*" do theRolloutName = substring theRolloutName 11 -1					
				if matchPattern theRolloutName pattern:"Krakatoa_*" do theRolloutName = substring theRolloutName 10 -1					
					
				local theRolloutControl = try(execute (i[1] + "." + i[2]))catch(undefined)
				local theRolloutControlName = if theRolloutControl == undefined then  
				(
					i[2] 
				)	
				else 
				(
					if theRolloutControl.caption == "" then 
						if matchPattern theRolloutControl.name pattern:"ddl_*" then substring theRolloutControl.name 5 -1 else theRolloutControl.name
					else 
						if matchPattern theRolloutControl.name pattern:"pkb_*" then substring theRolloutControl.name 5 -1 else theRolloutControl.caption
				)	
				append tempArray  (theRolloutName  +": "+ theRolloutControlName + " ["+ i[3] + "]>>[" + i[4] + "]")
			)
			lbx_compareSettings.items = tempArray
			if tempArray.count > 0 and lbx_compareSettings.selection > 0 then 
			(
				edt_settings01.text = ComparisonArray[lbx_compareSettings.selection][3]
				edt_settings02.text = ComparisonArray[lbx_compareSettings.selection][4]			
			)
			else
				edt_settings01.text = edt_settings02.text = ""
			edt_settings02.enabled = btn_get02.enabled = ddl_historyFiles02.selection > 1 	
			
			tempArray1 = #()
			theKeys = getIniSetting file01 "SceneInfo"
			for k in theKeys do 
				append tempArray1 (k + ":" + getIniSetting file01 "SceneInfo" k)
			lbx_SceneInfo01.items = tempArray1	
	
			tempArray2 = #()
			theKeys = getIniSetting file02 "SceneInfo"
			for k in theKeys do 
				append tempArray2 (k + ":" + getIniSetting file02 "SceneInfo" k)
			lbx_SceneInfo02.items = tempArray2	

			theSample01 = getIniSetting file01 "SampleImage" "Filename"
			if theSample01 != "" then
			(
				theSample01 = Krakatoa_PresetsDirectory + "\\samples\\" + theSample01
				if doesFileExist theSample01 then
				(
					local theBitmap01 = openBitmap theSample01
					copy theBitmap01 leftBitmap 
					close theBitmap01
					theBitmap01 = undefined
					btn_imagefile01.images = #(leftBitmap, undefined, 1,1,1,1,1 )
					leftBitmapFileName = theSample01 
				)	
				else
				(
					local tempBmp = bitmap 220 165 color:(white*0.5)
					for i = 0 to 219 do 
					(
						setPixels tempBmp [i,i*0.75] #(red,red)
						setPixels tempBmp [219-i,i*0.75] #(red,red)
					)	
					copy tempBmp  leftBitmap
					btn_imagefile01.images = #(leftBitmap, undefined, 1,1,1,1,1 )
					leftBitmapFileName = ""					
				)
			)
			else
			(
				local tempBmp = bitmap 220 165 color:(white*0.7)
				for i = 0 to 219 do 
				(
					setPixels tempBmp [i,i*0.75] #(red,red)
					setPixels tempBmp [219-i,i*0.75] #(red,red)
				)	
				copy tempBmp  leftBitmap
				btn_imagefile01.images = #(leftBitmap, undefined, 1,1,1,1,1 )
				leftBitmapFileName = ""
			)	

			theSample02 = getIniSetting file02 "SampleImage" "Filename"
			if theSample02 != "" then
			(
				theSample02 = Krakatoa_PresetsDirectory + "\\samples\\" + theSample02
				if doesFileExist theSample02 then 
				(
					local theBitmap02 = openBitmap theSample02 
					copy theBitmap02 rightBitmap 
					close theBitmap02
					theBitmap02 = undefined
					btn_imagefile02.images = #(rightBitmap, undefined, 1,1,1,1,1 )
					rightBitmapFileName = theSample02
				)	
				else
				(
					local tempBmp = bitmap 220 165 color:(white*0.5)
					for i = 0 to 219 do 
					(
						setPixels tempBmp [i,i*0.75] #(red,red)
						setPixels tempBmp [219-i,i*0.75] #(red,red)
					)	
					copy tempBmp rightBitmap
					btn_imagefile02.images = #(rightBitmap, undefined, 1,1,1,1,1 )	
					rightBitmapFileName = ""
				)						
			)
			else
			(
				local tempBmp = bitmap 220 165 color:(white*0.7)
				for i = 0 to 219 do 
				(
					setPixels tempBmp [i,i*0.75] #(red,red)
					setPixels tempBmp [219-i,i*0.75] #(red,red)
				)	
				copy tempBmp rightBitmap				
				btn_imagefile02.images = #(rightBitmap, undefined, 1,1,1,1,1 )	
				rightBitmapFileName = ""
			)	
		)--end if	
		FranticParticles.LogDebug (" +Comparing Settings FINISHED in " + (timestamp() - st) as string + "ms." )
	)

	on btn_filterOptions01 pressed do 
	(
		popupMenu Krakatoa_RCMenu_Struct.HistoryPatternOptions01_RCMenu pos:mouse.screenpos
	)
	on btn_filterOptions01 rightclick do 
	(
		popupMenu Krakatoa_RCMenu_Struct.HistoryPatternOptions01_RCMenu pos:mouse.screenpos
	)	
	on btn_filterOptions02 pressed do 
	(
		popupMenu Krakatoa_RCMenu_Struct.HistoryPatternOptions02_RCMenu pos:mouse.screenpos
	)
	on btn_filterOptions02 rightclick do 
	(
		popupMenu Krakatoa_RCMenu_Struct.HistoryPatternOptions02_RCMenu pos:mouse.screenpos
	)	
	
	on edt_filter01 changed txt do (updateLists(); compareSettings())
	on edt_filter02 changed txt do (updateLists(); compareSettings())
	
	on btn_compareImages pressed do
	(
		if doesFileExist leftBitmapFileName and doesFileExist rightBitmapFileName then
			RAMPlayer leftBitmapFileName rightBitmapFileName 
			else if not doesFileExist leftBitmapFileName and doesFileExist rightBitmapFileName then
				RAMPlayer "" rightBitmapFileName 
				else if doesFileExist leftBitmapFileName and not doesFileExist rightBitmapFileName then
					RAMPlayer leftBitmapFileName "" 
	)
	
	on btn_imagefile01 pressed do 
	(
		if doesFileExist leftBitmapFileName do 
		(
			leftBitmapPreview = openbitmap leftBitmapFileName 
			display leftBitmapPreview 
		)	
	)	
	
	on btn_imagefile02 pressed do 
	(
		if doesFileExist rightBitmapFileName do 
		(
			rightBitmapPreview = openbitmap rightBitmapFileName 
			display rightBitmapPreview 
		)	
	)	
	on btn_deletePreset01 pressed do
	(
		if ddl_historyFiles01.selection > 0  then
		(
			local q = yesnocancelbox ("Click YES to delete both [" +ddl_historyFiles01.selected +"] and its Thumbnail.\nClick NO to delete the Thumbnail only.\nClick CANCEL to not delete anything.") title:"Delete"
			local theInfoFile = if rad_files01.state == 1 then
				Krakatoa_PresetsDirectory + "\\presets\\" + ddl_historyFiles01.selected + ".KrakatoaPreset"
			else	
				Krakatoa_PresetsDirectory + "\\history\\" + ddl_historyFiles01.selected+ ".KrakatoaSettings"			
			if q != #cancel and doesFileExist leftBitmapFileName do deleteFile leftBitmapFileName 
			if q == #yes do deleteFile theInfoFile 
			if q != #cancel do 
			(
				updateLists()
				compareSettings()				
			)	
		)		
	)
	on btn_deletePreset02 pressed do
	(
		if ddl_historyFiles02.selection > 1 then
		(
			local q = yesnocancelbox ("Click YES to delete both [" +ddl_historyFiles02.selected +"] and its Thumbnail.\nClick NO to delete the Thumbnail only.\nClick CANCEL to not delete anything.") title:"Delete"
			local theInfoFile = if rad_files02.state == 1 then
				Krakatoa_PresetsDirectory + "\\presets\\" + ddl_historyFiles02.selected + ".KrakatoaPreset"
			else	
				Krakatoa_PresetsDirectory + "\\history\\" + ddl_historyFiles02.selected+ ".KrakatoaSettings"			
			if q != #cancel and doesFileExist rightBitmapFileName do deleteFile rightBitmapFileName 
			if q == #yes do deleteFile theInfoFile 
			if q != #cancel do
			(
				updateLists()
				compareSettings()				
			)	
		)		
	)		


	fn setCurrentValue valueIndex =
	(
		if lbx_compareSettings.selection > 0 do
		(
			theItem = ComparisonArray[lbx_compareSettings.selection]
			local theRollout = execute theItem[1]
			local theControl = try(execute (theItem[1] + "." + theItem [2]))catch(undefined)
			if theControl != undefined do
			(
				theValue = theItem[valueIndex]
				case classof theControl of
				(
					SpinnerControl: try(theControl.changed (theControl.value = execute theValue))catch()
					CheckButtonControl:	try(theControl.changed (theControl.state = execute theValue))catch()
					ColorPickerControl: try(theControl.changed (theControl.color = execute theValue))catch()
					ListBoxControl: (
						if theControl == Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do
							(theControl.items = execute theValue; Krakatoa_GUI_MatteObjects.saveSelectionSets();Krakatoa_GUI_MatteObjects.updateSelectionSets())
					)
					PickerControl: 
					(
					)	
					ComboBoxControl: (
										try(
											theFN = execute (theRollout.name +"." + theControl.name + "_SelectedFN")
											theFN (theControl.selection = findItem theControl.items theValue)
										)catch()
									)			
					EditTextControl: try(theControl.entered (theControl.text = theValue))catch()							
				)
			)
			if ddl_historyFiles02.selection == 1 do compareSettings()		
		)	
	)

	fn Refresh_GUI =
	(
		try(Krakatoa_GUI_Presets.open = FranticParticles.GetBoolProperty "GUI:PresetsRolloutOpen")catch()
		try(chk_SaveImageSample.state = FranticParticles.GetBoolProperty "Presets:SaveImageSample" )catch()
		if Krakatoa_GUI_Presets.open do 
		(
			updateLists()
			compareSettings()
		)	
	)
	
	on Krakatoa_GUI_Presets rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:PresetsRolloutOpen" val
		if val then 
		(
			updateLists()
			compareSettings()
			FranticParticles.LogDebug ("+Presets Rollout ROLLED DOWN.")
		)	
		else
			FranticParticles.LogDebug ("+Presets Rollout ROLLED UP.")
	)	


	
	
	on chk_SaveRenderHistory changed state do try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	on chk_SaveImageSample changed state do
	(
		try(FranticParticles.SetProperty "Presets:SaveImageSample" state)catch(FranticParticles.AddProperty "Presets:SaveImageSample" state)
		try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	)	
	
	on btn_savePresetAll pressed do
	(
		FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
		FranticParticleRenderMXS.PresetFilterString = ""
		Krakatoa_PresetDialogMode = #save
		FranticParticleRenderMXS.displaySavePresetDialog()
		updateLists()
		compareSettings()
	)

	on btn_loadPresetAll pressed do
	(
		FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
		FranticParticleRenderMXS.PresetFilterString = ""
		Krakatoa_PresetDialogMode = #load
		FranticParticleRenderMXS.displaySavePresetDialog()
		updateLists()
		compareSettings()			
	)

	on btn_loadHistory pressed do
	(
		FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
		FranticParticleRenderMXS.PresetFilterString = ""
		Krakatoa_PresetDialogMode = #loadHistory
		FranticParticleRenderMXS.displaySavePresetDialog()
		updateLists()
		compareSettings()
	)		
	
	on btn_ExplorePresetDir pressed do
		ShellLaunch "Explorer.exe" (Krakatoa_PresetsDirectory)
	
	on lbx_compareSettings selected itm do
	(
		edt_settings01.text = ComparisonArray[itm][3]
		edt_settings02.text = ComparisonArray[itm][4]
		btn_get02.enabled = edt_settings02.enabled =ddl_historyFiles02.selection > 1 
	)	
	
	on lbx_compareSettings doubleClicked itm do
		setCurrentValue (if ddl_historyFiles02.selection == 1 then 3 else 4)
	
	on btn_get01 pressed do
		setCurrentValue 3

	on btn_get02 pressed do
		setCurrentValue 4
	
	on btn_update pressed do 
	(
		updateLists()
		compareSettings()
	)	
	
	on rad_files01 changed state do 
	(
		updateLists()
		compareSettings()
	)
	on rad_files02 changed state do 
	(
		updateLists()
		compareSettings()
	)
	on ddl_historyFiles01 selected itm do 
	(
		if chk_lock.checked do 
		(
			theOffset = itm - theLockOffset
			if theOffset > 0 and theOffset <=ddl_historyFiles02.items.count do
				ddl_historyFiles02.selection = theOffset
		)	
		compareSettings()
	)	
	on ddl_historyFiles02 selected itm do 
	(
		if chk_lock.checked do 
		(
			theOffset = itm + theLockOffset 
			if theOffset > 0 and theOffset <=ddl_historyFiles01.items.count do
				ddl_historyFiles01.selection = theOffset
		)	
		compareSettings()
	)	
	
	on btn_align pressed do
	(
		if rad_files01.state == rad_files02.state then
		(
			ddl_historyFiles02.selection = ddl_historyFiles01.selection
			theLockOffset = 1
			compareSettings()
		)	
	)
	
	on chk_lock changed state do 
		if state then theLockOffset = ddl_historyFiles01.selection - ddl_historyFiles02.selection

	
	on lbx_SceneInfo01 doubleClicked itm do
	(
		if matchPattern lbx_SceneInfo01.selected pattern:"Path:*" then
		(
			thePath = getFileNamePath (substring lbx_SceneInfo01.selected 6 -1)
			format "%\n" thePath
			if doesFileExist thePath do ShellLaunch "Explorer.exe" thePath
		)	
		else
			if matchPattern lbx_SceneInfo01.selected pattern:"Output:*" then
			(
				thePath = getFileNamePath (substring lbx_SceneInfo01.selected 8 -1)
				format "%\n" thePath
				if doesFileExist thePath do ShellLaunch "Explorer.exe" thePath
			)	
			else
				format "%\n" lbx_SceneInfo01.selected			
	)
	on lbx_SceneInfo02 doubleClicked itm do
	(
		if matchPattern lbx_SceneInfo02.selected pattern:"Path:*" then
		(
			thePath = getFileNamePath (substring lbx_SceneInfo02.selected 6 -1)
			format "%\n" thePath
			if doesFileExist thePath do ShellLaunch "Explorer.exe" thePath
		)	
		else
			if matchPattern lbx_SceneInfo02.selected pattern:"Output:*" then
			(
				thePath = getFileNamePath (substring lbx_SceneInfo02.selected 8 -1)
				format "%\n" thePath
				if doesFileExist thePath do ShellLaunch "Explorer.exe" thePath
			)	
			else
				format "%\n" lbx_SceneInfo02.selected
	)		
	

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Presets
	)		

	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Presets
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)

	on Krakatoa_GUI_Presets moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Presets.title (pos as string)
	)
	
	on Krakatoa_GUI_Presets close do 
	(
		if Krakatoa_GUI_Presets.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Presets.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Presets open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Presets.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Presets Rollout OPENED.")			
	)	
	
)--end rollout



--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--USER NOTES ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_Notes "User Notes"  rolledup:true category:120 width:457
(

	button btn_Help_Notes  "Open Krakatoa Online Help..." height:14 width:430 align:#left offset:[-10,-5] across:2
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	on btn_Help_Notes pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/user_notes.php" ""

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Notes
	)		

	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Notes
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)

	on Krakatoa_GUI_Notes moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Notes.title (pos as string)
	)		
	
	label lbl_userNotes01 "Please use this field to enter your notes regarding the current setup"
	label lbl_userNotes02 "and anything others should know when loading and rendering your scene."
	
	edittext edt_userNotes width:440 height:200 align:#center
	
	label lbl_userNotes03 "NOTE that Presets and History files will not consider this field a property"
	label lbl_userNotes04 "but the text will be stored and displayed as part of the general Scene Info."
	
	on edt_userNotes entered txt do 
		try(FranticParticles.SetProperty "UserNotes" txt)catch()
		
	fn refresh_GUI = (
		try(Krakatoa_GUI_Notes.open = FranticParticles.GetBoolProperty "GUI:UserNotesRolloutOpen")catch()		
		try(edt_userNotes.text = FranticParticles.GetProperty "UserNotes")catch()
	)	

	on Krakatoa_GUI_Notes close do 
	(
		if Krakatoa_GUI_Notes.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Notes.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Notes open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Notes.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Notes Rollout OPENED.")			
	)	
	
	on Krakatoa_GUI_Notes rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:UserNotesRolloutOpen" val
		if val then 
			FranticParticles.LogDebug ("+User Notes Rollout ROLLED DOWN.")
		else
			FranticParticles.LogDebug ("+User Notes Rollout ROLLED UP.")			
	)	
)--end rollout



--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--SAVE FILE HISTORY DIALOG ROLLOUT
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_History_Dialog "Krakatoa Save File History"
(
	local filteredValues = #()
	listbox lbx_history height:20 width:820 align:#center
	edittext edt_filterValue "Filter Value:" fieldwidth:120 pos:[5,280] 
	button btn_ValueFilterOptions ">>" width:20 height:18 pos:[185,280] 
	
	edittext edt_filterPath "Filter Path:" fieldwidth:120 pos:[220,280] 
	button btn_PathFilterOptions ">>" width:20 height:18 pos:[395,280] 
	
	checkbox chk_order "Newest On Top" checked:true pos:[500,275] 
	checkbox chk_showPaths "Show Full Path" checked:true pos:[500,290] 
	
	button btn_ok "OK" height:25 width:90 pos:[620,280] 
	button btn_cancel "Cancel" height:25 width:90 pos:[720,280] 
	
	fn createPresetsMenu type:#value =
	(
		case type of
		(
			#value: (
						targetControl = "edt_filterValue"
						presetName = "HistoryDialogFilterValue"
						)
			#path: (
						targetControl = "edt_filterPath"
						presetName = "HistoryDialogFilterPath"
					)
		)
		
		local presetsList = #()
		local theKeys =getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName 
		sort theKeys 			
		for k in theKeys do
			if findItem presetsList theValue == 0 do append presetsList k
		local theValue = execute ("Krakatoa_GUI_History_Dialog."+ targetControl +".text")			
			
		local txt = "rcmenu History_FilterValue_RCMenu \n(\n"				
		if findItem presetsList theValue == 0 and theValue.count > 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add ["+ theValue as string+"]\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ theValue as string +"\" \""+ theValue +"\" \n"
			txt += "separator spr_01\n" 
		)	
			
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i + "\" \n" 
			txt += "on mnu_preset" + cnt as string + " picked do Krakatoa_GUI_History_Dialog."+ targetControl +".changed (Krakatoa_GUI_History_Dialog."+ targetControl +".text = \""+ i +"\")\n"
		)
		
		if findItem presetsList theValue != 0 do 
		(
			txt += "separator spr_10\n" 
			txt += "menuItem mnu_RemovePreset \"Remove ["+ theValue as string+"]\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName +"\" \""+ theValue +"\" \n"
		)				
		
		if cnt > 0 do txt += "separator sep_last \n"
		txt += "menuitem mnu_clearValueFilter \"Clear Value Filter\" \n"
		txt += "on mnu_clearValueFilter picked do \n(\n"
		txt += "Krakatoa_GUI_History_Dialog."+targetControl+".text = \"\" \n"
		txt += "Krakatoa_GUI_History_Dialog.updateList())\n"
		
		txt += ")\n"
		Krakatoa_RCMenu_Struct.History_FilterValue_RCMenu = execute txt
	)
	
	fn updateList =
	(
		filteredValues = #()
		if chk_order.checked then
		(
			startValue = Krakatoa_GUI_SaveParticles.allValues.count 
			endValue = 1
			stepValue = -1
		)
		else
		(
			startValue = 1
			endValue= Krakatoa_GUI_SaveParticles.allValues.count 
			stepValue = 1				
		)
		lbx_history.items = for i = startValue to endValue by stepValue collect 
		(
			if matchPattern Krakatoa_GUI_SaveParticles.allValues[i] pattern:("*"+edt_filterValue.text + "*") AND matchPattern Krakatoa_GUI_SaveParticles.allPaths[i] pattern:("*"+edt_filterPath.text + "*") then
			(
				append filteredValues Krakatoa_GUI_SaveParticles.allValues[i]
				(Krakatoa_GUI_SaveParticles.allValues[i] + (if chk_showPaths.checked then ("   ["+ Krakatoa_GUI_SaveParticles.allPaths[i] + "]") else "") )
			)	
			else
				dontcollect
		)	
	)

	on btn_ValueFilterOptions pressed do 	
	(
		createPresetsMenu type:#value
		popupMenu Krakatoa_RCMenu_Struct.History_FilterValue_RCMenu position:mouse.screenpos
	)	
	on btn_PathFilterOptions pressed do 
	(
		createPresetsMenu type:#path
		popupMenu Krakatoa_RCMenu_Struct.History_FilterValue_RCMenu position:mouse.screenpos
	)			
	on edt_filterValue changed txt do 
	(
		updateList()
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "LastFilterValuePattern" txt
	)	
	on edt_filterPath changed txt do 
	(
		updateList()
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "LastFilterPathPattern" txt
	)	
	
	on chk_order changed state do 
	(
		updateList()
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "NewestOnTop" (state as string)
	)	
	on chk_showPaths changed state do 
	(
		updateList()
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "ShowFullPath" (state as string)
	)	

	
	on btn_cancel pressed do 
	(
		Krakatoa_GUI_SaveParticles.historyValue = undefined
		destroyDialog Krakatoa_GUI_History_Dialog
	)	
	on btn_ok pressed do 
	(
		if lbx_history.selection > 0 do Krakatoa_GUI_SaveParticles.historyValue = filteredValues[lbx_history.selection]
		destroyDialog Krakatoa_GUI_History_Dialog
	)	
	on lbx_history doubleclicked itm do 
	(
		Krakatoa_GUI_SaveParticles.historyValue = filteredValues[lbx_history.selection]
		destroyDialog Krakatoa_GUI_History_Dialog		
	)
	on Krakatoa_GUI_History_Dialog open do 
	(
		theVal = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "NewestOnTop")
		if classof theVal != BooleanClass do theVal = true
		chk_order.state = theVal 
		theVal = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "ShowFullPath")
		if classof theVal != BooleanClass do theVal = true
		chk_showPaths.state = theVal 
		edt_filterValue.text = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "LastFilterValuePattern" 
		edt_filterPath.text = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "HistoryDialog" "LastFilterPathPattern" 
		updateList()
	)
)--end rollout


--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--MAIN CONTROLS ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_Main "Main Controls" category:10 width:457
(
	local theSize = 40.0
	local theBitmap = bitmap theSize theSize 
	local theBlankBitmap = bitmap theSize theSize color:[90,90,90]
	local theDisabledBitmap = bitmap theSize theSize color:[160,160,160]
	local theCachedChannelsArray = #()
	
	button btn_LoadSave_Main "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_Main "Open Krakatoa Online Help..." height:14 width:408 offset:[0,-5] align:#center
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	
	on btn_LoadSave_Main pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Main
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_Main rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Main
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	

	on btn_Help_Main pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/main_controls.php" ""


	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Main
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Main
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)		
		
	on Krakatoa_GUI_Main moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Main.title (pos as string)
	)
	
	group "Particle Color Source" 
	(
		checkbutton ckb_useGlobalColorOverride ">Override Particle Colors" width:140 across:3 align:#left offset:[-5,-3] tooltip:"When checked, the Global Particle Color Override from the drop-down list will be used instead of the particle's colors." highlightcolor:KrakatoaSkinColorsStruct.Main
		dropdownlist ddl_particleColorSource offset:[-4,-3] width:146 align:#center  items:#("Custom Particle Color","Material Editor Slot #1","Ignore Materials","Blended Z Depth","Blended Camera Distance") 
		colorpicker clr_chooseColor "Custom Particle Color:" color:[255,255,255] align:#right modal:false offset:[5,-3] fieldwidth:40

		checkbutton ckb_useFilterColor ">Use Filter Color" width:140  align:#left offset:[-5,-3] across:3 tooltip:"When checked, the R,G and B components of light will be attenuated separately based on the Filter color in Standard Materials." highlightcolor:KrakatoaSkinColorsStruct.Main
		checkbutton ckb_overrideEnvironmentColor  ">Custom Background Color" width:144 offset:[-5,-3] align:#right tooltip:"When checked, the 3ds Max Environment Background color will be used." highlightcolor:KrakatoaSkinColorsStruct.Main
		colorpicker clr_backgroundColor "Background Color:" alpha:true align:#right offset:[5,-3] modal:false fieldwidth:40
	)
	
	
	group "Lighting and Shading"
	(
		checkbutton ckb_useLighting ">USE SCENE LIGHTING" width:140 height:43 align:#left across:3 offset:[-5,-3] tooltip:"When checked, scene lights will be used to illuminate particles. When unchecked, the particles will be rendered as self-illuminated." highlightcolor:KrakatoaSkinColorsStruct.Main
		checkbutton ckb_useEnvironmentReflections ">Environment Reflections" width:144 offset:[-5,-3] align:#right tooltip:"When checked, the 3ds Max Environment Background color will be used." highlightcolor:KrakatoaSkinColorsStruct.Main
		
		spinner spn_specularLevel "Specular Level:" range:[0,1000000,0] fieldwidth:40 type:#float align:#right offset:[0,0] 

		spinner spn_anisotropy  "Anisotropy:" range:[0,1000,1] fieldwidth:40 type:#float align:#right offset:[66,-23] across:2
		spinner spn_glossiness  "Glossiness:" range:[0,1000,0] fieldwidth:40 type:#float align:#right offset:[-1,-23] 

		dropdownlist ddl_RenderingMethod items:#("Particle Rendering","Voxel Rendering") width:140 align:#left offset:[-5,-1] across:3
		spinner spn_VoxelSize "Voxel Size:" range:[0,10000000,1] align:#left fieldwidth:40 type:#float offset:[35,2]
		button btn_VoxelSizePreset ">>" width:20 height:20 align:#left offset:[-5,0] tooltip:"."		
		
		dropdownlist ddl_densityMethod items:#("Volumetric Density","Additive Density","Constant Alpha") width:140 align:#left offset:[-5,-5] across:3

		spinner spn_VoxelFilterRadius "Voxel Filter Radius:" range:[1,100,1] type:#integer fieldwidth:40 offset:[-5,-2]
		button btn_VoxelFilterRadiusPreset ">>" width:20 height:20 align:#left offset:[-5,-4] tooltip:"."	

		dropdownlist ddl_shadingMode width:140 align:#left offset:[-5,-5] across:3 items:#("Isotropic","Phong Surface","Ward Surface","Henyey-Greenstein","Schlick") 
		spinner spn_PhaseEccentricity "Phase Eccentricity:" range:[-1,1,0] align:#left fieldwidth:40 type:#float offset:[-4,-2]
		button btn_PhaseEccentricityPreset ">>" width:20 height:20 align:#left offset:[-5,-4] tooltip:"."		
		
		imgtag bmp_specular width:theSize height:theSize align:#right offset:[-5,-50] 
		imgtag bmp_specular2 width:theSize height:theSize align:#right offset:[-theSize-10,-theSize-5] 
	)
	
	group "Lighting and Final Pass Filtering and Density"
	(
		dropdownlist ddl_attenuationLookupFilter items:#("Self-Shadow Filter: Nearest","Self-Shadow Filter: Bilinear","Self-Shadow Filter: Bicubic") width:220 align:#right offset:[0,-3] across:2
		dropdownlist ddl_drawPointFilter items:#("Draw Point Filter: Nearest","Draw Point Filter: Bilinear","Draw Point Filter: Bicubic") width:220 align:#left offset:[0,-3] 
		
		spinner spn_LightingDensityPerParticle "Lighting Density Per Particle:" range:[0,10000000,1] align:#left across:2 fieldwidth:50 type:#float offset:[-2,-3]
		spinner spn_densityPerParticle "Density Per Particle:" range:[0,10000000,1] align:#right fieldwidth:50 type:#float offset:[-16,-3]
		
		spinner spn_LightingDensityExponent  "Density Exponent (10^x):" range:[-30,30,0] align:#left across:2 fieldwidth:50 type:#integer offset:[15,-3]
		spinner spn_densityExponent  "Density Exponent (10^x):" range:[-30,30,0] align:#right fieldwidth:50 type:#integer offset:[-16,-3]

		checkbutton ckb_linkLightingAndRenderingDensity ">Use Lighting Pass Density Settings" across:2 width:220 align:#left offset:[-5,-2] checked:true tooltip:"When checked, the Render Pass Density settings will be used by the Lighting Pass. When unchecked, separate Lighting Pass Density controls will become available." highlightcolor:KrakatoaSkinColorsStruct.Main
		checkbutton ckb_scaleDensityByMaterialOpacity ">Scale Density using Material Opacity" width:220 align:#right offset:[5,-2] highlightcolor:KrakatoaSkinColorsStruct.Main
	)
	button btn_lightingDensityPreset ">>" width:20 height:34 align:#left across:2 offset:[195,-69] tooltip:"Set Lighting Pass Density to a Preset Value, or Add/Remove current value to/from the Presets."
	button btn_finalDensityPreset ">>" width:20 height:34 align:#right offset:[5,-69] tooltip:"Set Final Pass Density to a Preset Value, or Add/Remove current value to/from the Presets."

	label lbl_placeHolderDensity height:22	
		
	fn update2009VFBControls side: = 
	(	
		case side of
		(
			#left: try(Krakatoa_VFB_Left_Rollout.refresh_GUI())catch() --update VFB Overlay in Max 2009+
			#right: 	try(Krakatoa_VFB_Right_Rollout.refresh_GUI())catch() --update VFB Overlay in Max 2009+
			default: (
				try(Krakatoa_VFB_Left_Rollout.refresh_GUI())catch()
				try(Krakatoa_VFB_Right_Rollout.refresh_GUI())catch()
			)
		)	
		try(Krakatoa_VFB_Overlay_Rollout.refresh_GUI())catch()
		updateToolbarButtons()
	)
	
	on ckb_useGlobalColorOverride changed state do
	(
		ddl_particleColorSource.enabled = state
		clr_chooseColor.enabled =  ddl_particleColorSource.selection == 1 and state
		FranticParticles.SetProperty "UseGlobalColorOverride" state
		Krakatoa_GUI_Channels.updateMemChannels()
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		update2009VFBControls side:#left
	)
	
	fn updateCurve which:1=
	(
		if (which == 1 and (ddl_shadingMode.selection == 2 or  ddl_shadingMode.selection == 3) ) or (which == 2 and ddl_shadingMode.selection == 3) then
		(
			theCurveColor = KrakatoaSkinColorsStruct.Main --(colorman.getColor #activeCommand) * 255 --get color of pressed checkbutton
			copy theBlankBitmap theBitmap
		)	
		else
		(
			theCurveColor = KrakatoaSkinColorsStruct.Main + (color 100 100 100)  --(colorman.getColor #activeCommand) * 255 +  (color 100 100 100)  --get color of pressed checkbox plus some gray
			copy theDisabledBitmap theBitmap		
		)	
		
		if spn_glossiness.value < 0.5 and spn_specularLevel.value > 1200.0 then
		(
			thePixels = for i = 1 to theSize collect theCurveColor
			thePixels[1] = white
			thePixels[thePixels.count] = white
			for j = 0 to theSize-1 do
				setPixels theBitmap [0,j] thePixels
		)
		else
		(
			theStep = 10.0 / spn_specularLevel.value
			if theStep < 0.02 do theStep = 0.02
			for a = 0.0 to 90.0 by theStep do
			(
				theDot = cos a
				x1 = (theSize-theSize * a/90.0)*0.5
				x2 = theSize-(x1 as integer)
				if x1 < 0.0 do x1 = 0.0
				if x2 > theSize do x2 = theSize
				thePixels = for i = x1 to x2 collect theCurveColor
				thePixels[1] = white
				thePixels[thePixels.count] = white
				if which == 1 then
					setPixels theBitmap [x1,theSize-(theDot^(1+spn_glossiness.value))*spn_specularLevel.value * 0.25  ] thePixels
				else	
					setPixels theBitmap [x1,theSize-(theDot^(1+spn_glossiness.value+spn_anisotropy.value))*spn_specularLevel.value * 0.25  ] thePixels
			)
		)	
		case which of
		(
			1: bmp_specular.bitmap = theBitmap 
			2: bmp_specular2.bitmap = theBitmap 
		)	
	)
	



	fn createDefaultsRCMenu theKey theName=
	(
		local theCurrentValue = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDefaults.ini") "Defaults" theKey
		if theCurrentValue == "" do theCurrentValue = "--Not Set--"
		local theNewValue = FranticParticles.getProperty theKey 
		
		local txt = "rcmenu Presets_RCMenu\n(\n"
		if theCurrentValue != theNewValue do
		(
			txt += "menuItem mnu_MakeDefault \"Save ["+ theNewValue +"] as Startup Default for ["+ theName +"] - Current Default:"+ theCurrentValue +"\" \n" 
			txt += "on mnu_MakeDefault picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theKey as string +"\" \""+ theNewValue as string +"\" \n"
		)
		if theCurrentValue != "--Not Set--" do
		(
			txt += "menuItem mnu_RemoveDefault \"Remove ["+ theCurrentValue +"] from ["+ theName +"] Startup Default - Use the Factory Default instead.\" \n" 
			txt += "on mnu_RemoveDefault picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theKey as string +"\"\n"
		)	
		txt += ")\n"
		Krakatoa_RCMenu_Struct.Presets_RCMenu = execute txt			
	)

	fn convertSourcesToString =
	(
		local theStringArray = #()
		if FranticParticles.GetBoolProperty "RenderParticleFlowGeometry" do append theStringArray "PF Geometry"
		if FranticParticles.GetBoolProperty "RenderParticleFlowPhantom" do append theStringArray "PF Phantom"
		if FranticParticles.GetBoolProperty "RenderParticleFlowBBox" do append theStringArray "PF Box"
		if FranticParticles.GetBoolProperty "RenderGeometryVertices" do append theStringArray "Vertices"
		
		if FranticParticles.GetBoolProperty "RenderMaxParticles" do append theStringArray "Legacy"
		if FranticParticles.GetBoolProperty "RenderThinkingParticles" do append theStringArray "TP"
		if FranticParticles.GetBoolProperty "RenderKrakatoaLoaders" do append theStringArray "PRT"
		if FranticParticles.GetBoolProperty "RenderFumeFX" do append theStringArray "FumeFX"
		if FranticParticles.GetBoolProperty "RenderGeometryVolumes" do append theStringArray "Volumes"
			
		
		theString = ""
		if theStringArray.count == 0 then 
			theString = "None"
		else if theStringArray.count == 8 then 
			theString = "All"
		else	
		(
			for i = 1 to theStringArray.count-1 do theString += theStringArray[i]+","
			theString += theStringArray[theStringArray.count]
		)	
		theString	
	)
	
	fn convertSourcesFromString theString =
	(
		if theString == "None" then 
			theStringArray = #()
		else
			if theString == "All" then
				theStringArray = #("PF Geometry","PF Phantom","PF Box","Vertices","Legacy","TP","PRT","FumeFX","Volumes")
			else
				theStringArray = filterString theString ","
		FranticParticles.SetProperty "RenderParticleFlowGeometry" (findItem theStringArray "PF Geometry" > 0)
		FranticParticles.SetProperty "RenderParticleFlowPhantom" (findItem theStringArray "PF Phantom" > 0)
		FranticParticles.SetProperty "RenderParticleFlowBBox" (findItem theStringArray "PF Box" > 0)
		FranticParticles.SetProperty "RenderGeometryVertices" (findItem theStringArray "Vertices" > 0)
		FranticParticles.SetProperty "RenderMaxParticles" (findItem theStringArray "Legacy" > 0)
		FranticParticles.SetProperty "RenderThinkingParticles" (findItem theStringArray "TP" > 0)
		FranticParticles.SetProperty "RenderKrakatoaLoaders" (findItem theStringArray "PRT" > 0)
		FranticParticles.SetProperty "RenderFumeFX" (findItem theStringArray "FumeFX" > 0)
		FranticParticles.SetProperty "RenderGeometryVolumes" (findItem theStringArray "Volumes" > 0)
		
		Krakatoa_GUI_Main.refresh_GUI()
	)
	
	fn createSourcePresetsRCMenu =
	(
		presetName = "UseParticlesFrom"
		local presetsList = #()
		local theKeys = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName  
		sort theKeys 
		if theKeys.count == 0 then 
		(
			theKeys = #("All","PF Geometry,PF Phantom,Legacy,TP,PRT","PF Geometry,PF Phantom,Vertices,Legacy,TP,PRT","None")
			for i in theKeys do
				setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName (i as string) (i as string)
		)
		for k in theKeys do
			if findItem presetsList theValue == 0 do append presetsList k

		theValue = convertSourcesToString()
		local txt = "rcmenu Presets_RCMenu\n(\n"
		
		if findItem presetsList theValue == 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add ["+ theValue as string+"]\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ theValue as string +"\" \""+ theValue as string +"\" \n"
			txt += "separator spr_01\n" 
		)	
		
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i as string + "\" \n" 
			txt += "on mnu_preset" + cnt as string + " picked do (Krakatoa_GUI_Main.convertSourcesFromString \""+ i + "\" )\n"
		)
		
		if findItem presetsList theValue != 0 do 
		(
			txt += "separator spr_10\n" 
			txt += "menuItem mnu_RemovePreset \"Remove ["+ theValue as string+"]\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName +"\" \""+ theValue as string +"\" \n"
		)	

		txt += "separator spr_20\n" 
		local currentDefault = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "SourceDefaults" (FranticParticles.GetProperty "ParticleMode")
		if currentDefault == "" do currentDefault = "--Not Set--"
		txt += "menuItem mnu_SetDefault \"Set ["+ theValue as string+"] as Default For ["+ (FranticParticles.GetProperty "ParticleMode") +"] mode - Current Default: "+ currentDefault +" \"\n" 
		txt += "on mnu_SetDefault picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \"SourceDefaults\" \""+ (FranticParticles.GetProperty "ParticleMode") +"\" \""+ theValue as string +"\" \n"
		

		txt += "separator spr_30\n" 
		theState = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SwitchSourceDefaultsByRenderMode"
		if theState == "" do theState = "false"
		
		txt += "menuItem mnu_EnableDefault \"Switch To User Defaults on 'Particle Render Mode' change.\" checked:"+ theState +"\n" 
		txt += "on mnu_EnableDefault picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \"Preferences\" \"SwitchSourceDefaultsByRenderMode\" ((not "+ theState  +") as string) \n"

		txt += ")\n"
		Krakatoa_RCMenu_Struct.Presets_RCMenu = execute txt		
	)

	fn createPresetsRCMenu type:#mblur =
	(
		case type of
		(
			#mblur: (
						presetName = "MotionBlurPresets"
						theSpinner = "spn_motionBlurSegments"
						theDefaultsKey = "MotionBlurSegments" 
					)	
			#shutter: (
						presetName = "ShutterPresets"
						theSpinner = "spn_blurShutter"
						theDefaultsKey = "ShutterAngleInDegrees"
					)	
			#bias: (
						presetName = "MotionBlurBiasPresets"
						theSpinner = "spn_blurBias"
						theDefaultsKey = "ShutterBias"
					)						
			#dofsamplerate: (
						presetName = "DOFSampleRatePresets"
						theSpinner = "spn_depthOfFieldSampleRate"
						theDefaultsKey = "DepthOfFieldSampleRate"
					)	
			#globalpercentage: (
						presetName = "GlobalPercentagePresets"
						theSpinner = "spn_GlobalParticlePercentage"
						theDefaultsKey = "GlobalParticlePercentage"
					)		
			#lightingdensity: (
						presetName = "LightingPassDensity"
						theSpinner = "spn_LightingDensityPerParticle"
						theSpinner2 = "spn_LightingDensityExponent"
						theDefaultsKey = "Lighting:Density:DensityPerParticle"
						theDefaultsKey2 = "Lighting:Density:DensityExponent"
					)	
			#finaldensity: (
						presetName = "FinalPassDensity"
						theSpinner = "spn_densityPerParticle"
						theSpinner2 = "spn_densityExponent"
						theDefaultsKey = "Density:DensityPerParticle"
						theDefaultsKey2 = "Density:DensityExponent"
					)	
			#voxelsize: (
						presetName = "VoxelSize"
						theSpinner = "spn_VoxelSize"
						theDefaultsKey = "VoxelSize" 
					)							
			#VoxelFilterRadius: (
						presetName = "VoxelFilterRadius"
						theSpinner = "spn_VoxelFilterRadius"
						theDefaultsKey = "VoxelFilterRadius" 
					)
			#PhaseEccentricity: (
						presetName = "PhaseEccentricity"
						theSpinner = "spn_PhaseEccentricity"
						theDefaultsKey = "PhaseEccentricity" 
					)				
		)
		local presetsList = #()
		local theKeys = if type == #lightingdensity or type == #finaldensity then
			for i in (getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName  ) collect i
		else
			for i in (getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName  ) collect (execute i)
			
		sort theKeys 
		if theKeys.count == 0 then 
		(
			theKeys = case type of
			(
				#mblur: #(2,8,16,32)
				#shutter: #(90.0,180.0,360.0)
				#bias: #(-1.0,0.0,1.0)
				#dofsamplerate: #(0.1,1.0,3.0,5.0,10.0)
				#globalpercentage: #(1.0,10.0,25.0,33.0,50.0,66.6,75.0,100.0)
				#lightingdensity: #("1.0E0","1.0E-1","1.0E-2")
				#finaldensity: #("1.0E0","1.0E-1","1.0E-2")
				#voxelsize: #(0.1,0.25,0.5,0.75,1.0)
				#VoxelFilterRadius: #(1,2,3,4,5,10)
				#PhaseEccentricity: #(-1.0,-0.5,0.0,0.5,1.0)
			)
			for i in theKeys do
				setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName (i as string) (i as string)
		)
		for k in theKeys do
			if findItem presetsList theValue == 0 do append presetsList k

		if type == #lightingdensity or type == #finaldensity then
			theValue = (execute ("Krakatoa_GUI_Main."+ theSpinner +".value")) as string + "E" + (execute ("Krakatoa_GUI_Main."+ theSpinner2 +".value")) as string 
		else
			theValue = execute ("Krakatoa_GUI_Main."+ theSpinner +".value")
		local txt = "rcmenu Presets_RCMenu\n(\n"
		
		if findItem presetsList theValue == 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add ["+ theValue as string+"]\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ theValue as string +"\" \""+ theValue as string +"\" \n"
			txt += "separator spr_01\n" 
		)	
		
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i as string + "\" \n" 
			if type == #lightingdensity or type == #finaldensity then
			(
				local theFS = filterString i "E"
				txt += "on mnu_preset" + cnt as string + " picked do (Krakatoa_GUI_Main."+ theSpinner +".changed (Krakatoa_GUI_Main."+ theSpinner +".value = "+ theFS[1]+ ");Krakatoa_GUI_Main."+ theSpinner2 +".changed (Krakatoa_GUI_Main."+ theSpinner2 +".value = "+ theFS[2] +"))\n"
			)	
			else
				txt += "on mnu_preset" + cnt as string + " picked do Krakatoa_GUI_Main."+ theSpinner +".changed (Krakatoa_GUI_Main."+ theSpinner +".value = "+ i as string +")\n"
		)
		
		if findItem presetsList theValue != 0 do 
		(
			txt += "separator spr_10\n" 
			txt += "menuItem mnu_RemovePreset \"Remove ["+ theValue as string+"]\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName +"\" \""+ theValue as string +"\" \n"
		)	
		
		local currentDefault = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDefaults.ini") "Defaults" theDefaultsKey
		if currentDefault == "" do currentDefault = "--Not Set--"
		if type == #lightingdensity or type == #finaldensity do
		(
			local currentDefault2 = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDefaults.ini") "Defaults" theDefaultsKey2
			if currentDefault2 != "" do currentDefault += "E"+currentDefault2 
		)	
			
		
		txt += "separator spr_20\n" 	
		if currentDefault != theValue as string do
		(
		
		txt += "menuItem mnu_MakeDefault \"Set ["+ theValue as string+"] as Default \"\n" 
		if type == #lightingdensity or type == #finaldensity then
		(
			local theFS = filterString theValue "E"
			txt += "on mnu_MakeDefault picked do (\n"
			txt += "setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey as string +"\" \""+ theFS[1] as string +"\" \n"
			txt += "setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey2 as string +"\" \""+ theFS[2] as string +"\" \n"
			txt += ")\n"
		)
		else	
			txt += "on mnu_MakeDefault picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey as string +"\" \""+ theValue as string +"\" \n"
		)

		if currentDefault != "--Not Set--" do
		(
			txt += "menuItem mnu_ResetDefault \"Reset Default ["+ currentDefault +"]\"\n" 
			if type == #lightingdensity or type == #finaldensity then
			(
				local theFS = filterString theValue "E"
				txt += "on mnu_ResetDefault picked do (\n"
				txt += "delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey as string +"\" \n"
				txt += "delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey2 as string +"\" \n"
				txt += ")\n"
			)
			else	
				txt += "on mnu_ResetDefault picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaDefaults.ini\") \"Defaults\" \""+ theDefaultsKey as string +"\"\n"
		)		
		
		txt += ")\n"
		Krakatoa_RCMenu_Struct.Presets_RCMenu = execute txt
	)

	group "Motion Blur and Depth of Field" 
	(
		checkbutton ckb_enableMotionBlur ">Enable Motion Blur" width:139 offset:[0,-5] align:#left tooltip:"Toggle Motion Blur On and Off." enabled:true highlightcolor:KrakatoaSkinColorsStruct.Main
		checkbutton ckb_jitteredMotionBlur ">Jittered Motion Blur" width:139 offset:[0,-5] align:#left tooltip:"When checked, samples will be jittered within the time segment. When unchecked, each sample will be centered to its time segment."  highlightcolor:KrakatoaSkinColorsStruct.Main
		checkbutton ckb_deformationMotionBlur ">Deformation Motion Blur" width:139 offset:[0,-5] align:#left tooltip:"When checked, Matte Object Deformations will be taken into account."  highlightcolor:KrakatoaSkinColorsStruct.Main 
		checkbutton ckb_enableDepthOfField ">Enable Depth Of Field" width:139 offset:[0,-5] align:#left tooltip:"Toggle Depth Of Field On and Off." enabled:true highlightcolor:KrakatoaSkinColorsStruct.Main
		
		spinner spn_motionBlurSegments  "Motion Blur Segments: " range:[1,1000,2] fieldwidth:80 type:#integer align:#right  offset:[-16,-88]
		spinner spn_blurShutter  "Motion Blur Shutter (degs): " range:[0,100000,180] fieldwidth:80 type:#float align:#right offset:[-16,0]
		spinner spn_blurBias  "Matte Objects Motion Blur Bias: " range:[-1,1,0] fieldwidth:80 type:#float align:#right offset:[-16,0]
		spinner spn_depthOfFieldSampleRate  "Depth of Field Sample Rate: " range:[0,1000,1] fieldwidth:80 type:#float align:#right offset:[-16,0]
		
		button btn_motionBlurPresets ">>" width:20 height:20 align:#right offset:[5,-86] tooltip:"Set Motion Blur Segments to a Preset Value, Add/Remove current value to/from the Presets, or save as Startup Default."
		button btn_blurShutterPresets ">>" width:20 height:20 align:#right offset:[5,-4] tooltip:"Set Motion Blur Shutter to a Preset Value, Add/Remove current value to/from the Presets, , or save as Startup Default."
		button btn_blurBiasPresets ">>" width:20 height:20 align:#right offset:[5,-4] tooltip:"Set Motion Blur Bias to a Preset Value, Add/Remove current value to/from the Presets, or save as Startup Default."
		button btn_depthOfFieldPresets ">>" width:20 height:20 align:#right offset:[5,-4] tooltip:"Set Depth Of Field Sample Rate to a Preset Value, Add/Remove current value to/from the Presets, or save as Startup Default."
	)

	dropdownlist ddl_particleMode width:278 offset:[-9,0] align:#left items:#("Render Scene Particles","Save Particles To File Sequence","Light Scene Particles") across:3
	
	spinner spn_GlobalParticlePercentage "Load Percentage: " range:[0,100,100] offset:[133,2] type:#float fieldwidth:45 align:#right across:2 enabled:true
	button btn_GlobalPercentagePresets ">>" width:20 height:20 align:#right offset:[11,0] tooltip:"Set Global Load Percentage to a Preset Value, or Add/Remove current value to/from the Presets." enabled:true

	checkbutton chk_Render_PFlowGeometry ">PFlow Geometry" width:92 height:25 align:#left across:3 offset:[-10,-3] tooltip:"Toggle Rendering of Particle Flow particles whose Render Type is set to Geometry in the Render Operator" highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_PFlowPhantom ">PFlow Phantom" width:92 height:25 align:#left offset:[-60,-3] tooltip:"Toggle Rendering of Particle Flow particles whose Render Type is set to Phantom in the Render Operator" highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_PFlowBBox ">PFlow BBox" width:92 height:25 align:#left  offset:[-110,-3] tooltip:"Toggle Rendering of Particle Flow particles whose Render Type is set to Bounding Box in the Render Operator" highlightcolor:KrakatoaSkinColorsStruct.Main
	
	checkbutton chk_Render_MaxParticles ">Legacy Particles" width:92 height:25 align:#left across:3 offset:[-10,-3] tooltip:"Toggle Rendering of 3ds Max Legacy Particles (Spray, Snow, PArray, PCloud, Super Spray etc.)" highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_ThinkingParticles ">ThinkingParticles" width:92 height:25 align:#left offset:[-60,-3] tooltip:"Toggle Rendering of Cebas Thinking Particles" highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_FumeFX ">FumeFX" width:92 height:25 align:#left offset:[-110,-3]  tooltip:"Toggle Rendering of FumeFX Simulations." highlightcolor:KrakatoaSkinColorsStruct.Main enabled:true

	checkbutton chk_Render_KrakatoaLoaders  ">Particle Loaders" width:92 height:25 align:#left across:3 offset:[-10,-3]	tooltip:"Toggle Rendering of Krakatoa Particle Loaders" highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_GeometryVertices ">Geo.Vertices" width:92 height:25 align:#left offset:[-60,-3] tooltip:"Toggle Rendering of visible Scene Geometry Objects (Vertices as Particles) - excluding Geometry Objects assigned as Matte Objects via Named Selection Sets." highlightcolor:KrakatoaSkinColorsStruct.Main
	checkbutton chk_Render_GeometryVolumes ">Geo.Volumes" width:92 height:25 align:#left offset:[-110,-3] tooltip:"Toggle Rendering of Scene Geometry Objects with Krakatoa Volume Fill Modifier - excluding Geometry Objects assigned as Matte Objects via Named Selection Sets." highlightcolor:KrakatoaSkinColorsStruct.Main
	
	button btn_useParticlesFromPresets ">>" width:16 height:79 align:#center offset:[62,-84] tooltip:"Load, Create and Manage Presets for the 'Load Particles From...' Options"
	
	checkbutton chk_iterativeRender ">Iterative [Full]" align:#right width:82 height:19 offset:[205,-84]  across:2 tooltip:"When checked, the current frame will be rendered and NOT saved to disk. Only affects the RENDER button in Krakatoa, not the Max Render controls."
	button btn_iterativeRenderSettings ">>" width:20 height:19 align:#right offset:[10,-84]

	button btn_quickRender "RENDER" align:#right width:102 height:59 offset:[9,-4] tooltip:"Click to Render or Save Particles. Right-click to open Render Context Menu."
	
	checkbutton btn_enableLightingCache  ">LCache" align:#right width:50 height:37 offset:[-94,-84] tooltip:"When checked, all particles for the Lighting Pass of the current frame will be cached temporarily to RAM when first rendering. Rendering again will use the cache." highlightcolor:KrakatoaSkinColorsStruct.Main
	progressbar prg_cacheStatus align:#right width:50 height:7 value:100 color:green offset:[-93,-6] 
	checkbutton btn_enableParticleCache  ">PCache" align:#right width:50 height:36 offset:[-94,-5] tooltip:"When checked, all particles for the Final Pass of the current frame will be cached temporarily to RAM when first rendering. Rendering again will use the cache." highlightcolor:KrakatoaSkinColorsStruct.Main

	groupbox grp_overrides "Overrides" width:225 height:40 across:2 offset:[-10,0]
	groupbox grp_post "Post Processing"  width:226 height:40 offset:[-1,0]

	checkbutton ckb_ignoreMissingParticles ">Ignore Missing Particles" width:215  across:2 align:#left offset:[-5,-30] tooltip:"When checked, PRT Loaders containing missing files will cause no errors. Good for test-rendering incomplete sequences." highlightcolor:(color 255 160 160) 
	checkbutton ckb_postDivideByAlpha ">Post-Divide by Alpha" width:215  align:#right offset:[5,-30]  tooltip:"When checked, the RGB values will be divided by the alpha value. Useful when rendering using 'Blended Z Depth' and 'Blended Camera Distance' color modes." highlightcolor:KrakatoaSkinColorsStruct.Main
	

	
	on btn_VoxelFilterRadiusPreset pressed do
	(
		createPresetsRCMenu type:#VoxelFilterRadius
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	
	on btn_VoxelFilterRadiusPreset rightclick do
	(
		createPresetsRCMenu type:#VoxelFilterRadius
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	

	
	on btn_PhaseEccentricityPreset pressed do
	(
		createPresetsRCMenu type:#PhaseEccentricity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	
	on btn_PhaseEccentricityPreset rightclick do
	(
		createPresetsRCMenu type:#PhaseEccentricity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)		
	
	


	on btn_VoxelSizePreset pressed do
	(
		createPresetsRCMenu type:#voxelsize
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	on btn_VoxelSizePreset rightclick do
	(
		createPresetsRCMenu type:#voxelsize
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	
	on btn_lightingDensityPreset pressed do
	(
		createPresetsRCMenu type:#lightingdensity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	on btn_lightingDensityPreset rightclick do
	(
		createPresetsRCMenu type:#lightingdensity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	
	on btn_finalDensityPreset pressed do
	(
		createPresetsRCMenu type:#finaldensity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	on btn_finalDensityPreset rightclick do
	(
		createPresetsRCMenu type:#finaldensity
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)			

	
	on btn_motionBlurPresets pressed do
	(
		createPresetsRCMenu type:#mblur
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)
	
	on btn_blurShutterPresets pressed do
	(
		createPresetsRCMenu type:#shutter
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	on btn_blurBiasPresets pressed do
	(
		createPresetsRCMenu type:#bias
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	on btn_depthOfFieldPresets pressed do
	(
		createPresetsRCMenu type:#dofsamplerate
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on btn_GlobalPercentagePresets pressed do
	(
		createPresetsRCMenu type:#globalpercentage
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	


	on btn_motionBlurPresets rightclick do
	(
		createPresetsRCMenu type:#mblur
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)
	
	on btn_blurShutterPresets rightclick do
	(
		createPresetsRCMenu type:#shutter
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	on btn_blurBiasPresets rightclick do
	(
		createPresetsRCMenu type:#bias
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	on btn_depthOfFieldPresets rightclick do
	(
		createPresetsRCMenu type:#dofsamplerate
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		

	on btn_GlobalPercentagePresets rightclick do
	(
		createPresetsRCMenu type:#globalpercentage
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	

	on ckb_scaleDensityByMaterialOpacity changed state do
	(
		if state then
			FranticParticles.setProperty "DensityScalingSource" "Material Opacity"
		else	
			FranticParticles.setProperty "DensityScalingSource" "No Scaling"			
		update2009VFBControls side:#left
	)
	on ckb_scaleDensityByMaterialOpacity rightClick do 
	(
		createDefaultsRCMenu "DensityScalingSource" ">Scale Density using Material Opacity"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on ckb_ignoreMissingParticles rightClick do
	(
		createDefaultsRCMenu "IgnoreMissingParticles" ">Ignore Missing Particles"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	
	on ckb_useGlobalColorOverride rightClick do
	(
		createDefaultsRCMenu "UseGlobalColorOverride" ">Override Particle Colors"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos	
	)		
	
	fn ddl_shadingMode_SelectedFN itm =
	(
		FranticParticles.SetProperty "PhaseFunction" ddl_shadingMode.selected
		spn_PhaseEccentricity.enabled = btn_PhaseEccentricityPreset.enabled = ddl_shadingMode.selected == "Henyey-Greenstein" or ddl_shadingMode.selected == "Schlick"
		Krakatoa_GUI_Channels.updateMemChannels()
		update2009VFBControls  side:#left
	)
	
	on spn_PhaseEccentricity changed val do FranticParticles.SetProperty "PhaseEccentricity" (val as string)
	
	on ddl_shadingMode selected itm do
	(
		ddl_shadingMode_SelectedFN itm
		spn_anisotropy.enabled = ddl_shadingMode.selection == 3
		spn_glossiness.enabled = spn_specularLevel.enabled = ddl_shadingMode.selection == 2 or ddl_shadingMode.selection == 3
		updateCurve which:1
		updateCurve which:2				
	)
	
	on btn_useParticlesFromPresets pressed do 
	(
		createSourcePresetsRCMenu()
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	on btn_useParticlesFromPresets rightClick do 
	(
		createSourcePresetsRCMenu()
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on spn_GlobalParticlePercentage changed val do 
	(
		FranticParticles.SetProperty "GlobalParticlePercentage" val
		update2009VFBControls()
	)	
	
	fn updateIterativeRenderText =
	(
		theString = case Krakatoa_RCMenu_Struct.IterativeOptions_Selection of
		(
			"2": "x2"
			"1": "Full"
			"1/2": "1/2"
			"1/4": "1/4"
			"1/8": "1/8"
			"1/16": "1/16"
		)
		chk_iterativeRender.text = (">Iterative ["+theString+"]")
	)	
	
	fn IsCacheValid =
	(
		try
		(
			local theCachedChannels = FranticParticles.GetCachedParticleChannels()
			local theRenderChannels = FranticParticles.GetRenderParticleChannels()
		)
		catch
		(	
			local theCachedChannels = #(#("Position","float32[3]"),#("Velocity","float16[3]"), #("Density","float16[1]"), #("Color","float16[3]") ) 
			local theRenderChannels = Krakatoa_GUI_Channels.activeMemChannels
		)	
		theCachedChannelsArray = for i in theCachedChannels collect i[1]
		theMissingChannels = for i in theRenderChannels where findItem theCachedChannelsArray i[1] == 0 collect i[1]
		if theMissingChannels.count == 0 then green else yellow
	)
	
	fn refreshCacheStatus =
	(
		prg_cacheStatus.color = if FranticParticles.getCacheSize() == 0.0 then 
				(colorman.getColor #background)*255 
			else 
				IsCacheValid() 
		
		try(Krakatoa_VFB_Right_Rollout.refreshCacheStatus())catch()
	)

--MAIN CONTROLS ROLLOUT REFRESH GUI
	
	fn refresh_GUI = 
	(
		try(Krakatoa_GUI_Main.open = FranticParticles.GetBoolProperty "GUI:MainControlsRolloutOpen")catch()
		FranticParticleRenderMXS.SetDropDownValue ddl_particleMode (FranticParticles.GetProperty "ParticleMode")

		local inParticleMode = (FranticParticles.GetProperty "RenderingMethod") == "Particle Rendering"
		local enableSaveParticleFileControls = (FranticParticles.GetProperty "ParticleMode") == "Save Particles To File Sequence"

		FranticParticleRenderMXS.SetDropDownValue ddl_densityMethod (FranticParticles.GetProperty "Density:DensityMethod")
		local enableLightingControls = (FranticParticles.GetProperty "Density:DensityMethod") != "Additive Density"
		
		
		spn_specularLevel.value = FranticParticles.GetFloatProperty "Lighting:Specular:Level" 
		spn_glossiness.value = FranticParticles.GetFloatProperty "Lighting:Specular:Glossiness"
		spn_anisotropy.value = FranticParticles.GetFloatProperty "Lighting:Specular:Anisotropy"
		--spn_diffuseLevel.value = FranticParticles.GetFloatProperty "Lighting:Diffuse:Level" 
		
		spn_VoxelSize.value = FranticParticles.GetFloatProperty "VoxelSize" 
		spn_VoxelFilterRadius.value = FranticParticles.GetFloatProperty "VoxelFilterRadius" 
		
		ddl_particleColorSource.enabled = (ckb_useGlobalColorOverride.state = FranticParticles.GetBoolProperty "UseGlobalColorOverride")

		local chooseColorEnabled = true
		
		ckb_linkLightingAndRenderingDensity.checked = not FranticParticles.GetBoolProperty "Density:LinkLightingAndRenderingDensity" 
		
		spn_densityPerParticle.value = FranticParticles.GetFloatProperty "Density:DensityPerParticle"
		spn_densityExponent.value = FranticParticles.GetIntProperty "Density:DensityExponent"
		spn_lightingDensityPerParticle.value = FranticParticles.GetFloatProperty "Lighting:Density:DensityPerParticle"
		spn_lightingDensityExponent.value = FranticParticles.GetIntProperty "Lighting:Density:DensityExponent"


		ckb_enableMotionBlur.checked = FranticParticles.GetBoolProperty "EnableMotionBlur" 
		ckb_enableDepthOfField.checked = FranticParticles.GetBoolProperty "EnableDepthOfField" 
		
		ckb_jitteredMotionBlur.checked = FranticParticles.GetBoolProperty "JitteredMotionBlur"
		ckb_deformationMotionBlur.checked = FranticParticles.GetBoolProperty "DeformationMotionBlur"
		ckb_postDivideByAlpha.checked = FranticParticles.GetBoolProperty "PostDivideByAlpha"
		spn_motionBlurSegments.value = FranticParticles.GetFloatProperty "MotionBlurSegments"
		spn_depthOfFieldSampleRate.value = FranticParticles.GetFloatProperty "DepthOfFieldSampleRate"
		spn_blurShutter.value = FranticParticles.GetFloatProperty "ShutterAngleInDegrees"
		spn_blurBias.value = FranticParticles.GetFloatProperty "ShutterBias"
		
		FranticParticleRenderMXS.SetDropDownValue ddl_RenderingMethod (FranticParticles.GetProperty "RenderingMethod")
		
		chk_Render_PFlowGeometry.state = FranticParticles.GetBoolProperty "RenderParticleFlowGeometry" 
		chk_Render_PFlowBBox.state = FranticParticles.GetBoolProperty "RenderParticleFlowBBox" 
		chk_Render_PFlowPhantom.state = FranticParticles.GetBoolProperty "RenderParticleFlowPhantom" 
		chk_Render_FumeFX.state = FranticParticles.GetBoolProperty "RenderFumeFX" 
		
		chk_Render_MaxParticles.state = FranticParticles.GetBoolProperty "RenderMaxParticles" 
		chk_Render_ThinkingParticles.state = FranticParticles.GetBoolProperty "RenderThinkingParticles" 
		chk_Render_GeometryVertices.state = FranticParticles.GetBoolProperty "RenderGeometryVertices" 
		chk_Render_KrakatoaLoaders.state = FranticParticles.GetBoolProperty "RenderKrakatoaLoaders" 
		chk_Render_GeometryVolumes.state = FranticParticles.GetBoolProperty "RenderGeometryVolumes" 
		
		ckb_ignoreMissingParticles.state = FranticParticles.GetBoolProperty "IgnoreMissingParticles" 
		
		spn_GlobalParticlePercentage.value = (FranticParticles.GetFloatProperty "GlobalParticlePercentage") 
		
		ddl_drawPointFilter.selection = findItem #("Nearest Neighbor","Bilinear","Bicubic") (FranticParticles.GetProperty "DrawPointFilter")
		ddl_attenuationLookupFilter.selection = findItem #("Nearest Neighbor","Bilinear","Bicubic")  (FranticParticles.GetProperty "AttenuationLookupFilter")
		
		ddl_particleColorSource.selection = findItem #("Choose Color", "Medit1", "No Material", "Blended Z Depth","Blended Camera Distance") (FranticParticles.GetProperty "ParticleColorSource")  --"Material Self-Illumination","Custom Material Self-Illumination","Script Vector Channel"
		if ddl_particleColorSource.selection == 0 do ddl_particleColorSource.selection = 1

		if (FranticParticles.GetProperty "ParticleColorSource") != "Choose Color" do
			chooseColorEnabled = false
		
		ckb_scaleDensityByMaterialOpacity.state = (FranticParticles.getProperty "DensityScalingSource") == "Material Opacity"
		
		ckb_useLighting.checked = FranticParticles.GetBoolProperty "UseLighting"
		clr_backgroundColor.color = (execute (FranticParticles.GetProperty "BackgroundColor"))
		clr_chooseColor.color = (execute (FranticParticles.GetProperty "ChosenColor"))
		
		ckb_overrideEnvironmentColor.state = not (FranticParticles.GetBoolProperty "UseEnvironmentColor")
		ckb_useEnvironmentReflections.state = (FranticParticles.GetBoolProperty "UseEnvironmentReflections")
		clr_backgroundColor.enabled = ckb_overrideEnvironmentColor.state 
		ckb_useFilterColor.state = (FranticParticles.GetBoolProperty "UseFilterColor")
		
		if enableSaveParticleFileControls then
		(
			btn_quickRender.caption = "SAVE PARTICLES"
			chk_iterativeRender.enabled = btn_iterativeRenderSettings.enabled = false
		)	
		else
		(
			if chk_iterativeRender.checked then
				btn_quickRender.caption = "RENDER FRAME"
			else				
				btn_quickRender.caption = "RENDER"
			chk_iterativeRender.enabled = btn_iterativeRenderSettings.enabled = true
		)
		
		
		btn_enableParticleCache.enabled = not enableSaveParticleFileControls  
		btn_enableLightingCache.enabled = not enableSaveParticleFileControls --and (ckb_useLighting.checked and ddl_shadingMode.selection == 1) --and not btn_SpecularOn.checked
		btn_enableParticleCache.state = FranticParticles.GetBoolProperty "EnableParticleCache" 
		btn_enableLightingCache.state = FranticParticles.GetBoolProperty "EnableLightingCache" 

		refreshCacheStatus()

		ddl_shadingMode.selection = findItem ddl_shadingMode.items (FranticParticles.GetProperty "PhaseFunction")
		spn_PhaseEccentricity.value = FranticParticles.GetFloatProperty "PhaseEccentricity"

		spn_anisotropy.enabled = ddl_shadingMode.selection == 3
		--ckb_useEnvironmentReflections.enabled = ddl_shadingMode.selection == 2 or ddl_shadingMode.selection == 3
		
		updateCurve which:1
		updateCurve which:2			
		
		ddl_attenuationLookupFilter.enabled = ckb_linkLightingAndRenderingDensity.checked AND ckb_useLighting.checked AND inParticleMode
		ddl_drawPointFilter.enabled = inParticleMode
		
		btn_lightingDensityPreset.enabled = spn_LightingDensityPerParticle.enabled = spn_LightingDensityExponent.enabled = ckb_linkLightingAndRenderingDensity.checked AND ckb_useLighting.checked -- AND enableLightingControls 
		--ckb_linkLightingAndRenderingDensity.checked AND ckb_useLighting.checked AND enableLightingControls AND (FranticParticles.GetProperty "Lighting:RenderingMethod") != "Particle Rendering"
		btn_VoxelSizePreset.enabled = spn_VoxelSize.enabled = spn_VoxelFilterRadius.enabled = btn_VoxelFilterRadiusPreset.enabled = (FranticParticles.GetProperty "RenderingMethod") != "Particle Rendering"
		ckb_linkLightingAndRenderingDensity.enabled = ckb_useLighting.checked --AND enableLightingControls 
		clr_chooseColor.enabled = chooseColorEnabled and ckb_useGlobalColorOverride.state
		
		ckb_postDivideByAlpha.enabled = enableLightingControls 
		spn_specularLevel.enabled = spn_glossiness.enabled = ckb_useLighting.checked AND enableLightingControls AND (ddl_shadingMode.selection == 2 OR ddl_shadingMode.selection == 3)
		spn_PhaseEccentricity.enabled = btn_PhaseEccentricityPreset.enabled = ddl_shadingMode.selected == "Henyey-Greenstein" or ddl_shadingMode.selected == "Schlick"
		--spn_diffuseLevel.enabled = 
		ddl_shadingMode.selected == "Phong Surface"  or ddl_shadingMode.selected == "Ward Surface" 
		
		Krakatoa_GUI_Partition.refresh_GUI()
		refreshCacheStatus()
		update2009VFBControls()
		updateIterativeRenderText()
	)
	

	on ckb_useEnvironmentReflections changed state do
	(
		FranticParticles.SetProperty "UseEnvironmentReflections" (state as string)
		Krakatoa_GUI_Channels.updateMemChannels()
	)
	
	on chk_iterativeRender changed state do 
	(
		refresh_GUI()
		update2009VFBControls  side:#right
	)	

	on btn_iterativeRenderSettings pressed do
	(
		popupMenu Krakatoa_RCMenu_Struct.IterativeOptions_RCMenu pos:mouse.screenpos
	)
	
	on btn_iterativeRenderSettings rightClick do
	(
		popupMenu Krakatoa_RCMenu_Struct.IterativeOptions_RCMenu pos:mouse.screenpos
	)
	
	on Krakatoa_GUI_Main rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:MainControlsRolloutOpen" val
		if val then 
		(
			FranticParticles.LogDebug ("+Main Controls Rollout ROLLED DOWN.")
		)	
		else
			FranticParticles.LogDebug ("+Main Controls Rollout ROLLED UP or CHANGED HEIGHT.")				
	)
	
	on ckb_ignoreMissingParticles changed state do
	(
		FranticParticles.SetProperty "IgnoreMissingParticles" (state as string)
	)	
	
	on btn_enableLightingCache changed state do
	(
		if not state then 
		(
			--try(FranticParticles.InvalidateLightingCache())catch()
			FranticParticles.SetProperty "EnableLightingCache" false
			FranticParticles.LogProgress "+Lighting Cache Disabled."
			refresh_GUI()
		)
		else	
		(
			FranticParticles.SetProperty "EnableLightingCache" true
			FranticParticles.LogProgress "+Lighting Cache Enabled."
			btn_enableParticleCache.changed (btn_enableParticleCache.state = true)
		)	
		update2009VFBControls side:#right
	)
	
	on btn_enableParticleCache changed state do
	(
		if not state then 
		(
			if not FranticParticles.getBoolProperty "CacheLastFrame" do 
				try(FranticParticles.InvalidateParticleCache())catch()
			FranticParticles.SetProperty "EnableParticleCache" false
			FranticParticles.LogProgress "+Particle Cache Disabled."
			btn_enableLightingCache.changed (btn_enableLightingCache.state = false)
		)
		else	
		(
			FranticParticles.SetProperty "EnableParticleCache" true
			FranticParticles.LogProgress "+Particle Cache Enabled."
		)	
		refresh_GUI()
		update2009VFBControls side:#right
	)
	
	fn showCacheSize = 
	(
		local theCount = try((FranticParticles.GetCachedParticleCount()) as string)catch("???")
		local theMemory = try((FranticParticles.getCacheSize()) as string)catch("???")
		Krakatoa_RCMenu_Struct.ParticleCache_RCMenu.mnu_cacheSize.text =  "In Memory: "+ FranticParticleRenderMXS.addCommas theCount +" Particles using " + theMemory  + " MB"
		popupmenu Krakatoa_RCMenu_Struct.ParticleCache_RCMenu position:mouse.ScreenPos 			
	)
	
	on btn_enableParticleCache rightclick do showCacheSize()
	on btn_enableLightingCache rightclick do showCacheSize()
	
	on btn_quickRender rightclick do 
	(
		if renderSceneDialog.isOpen() do renderSceneDialog.commit()
		Krakatoa_RCMenu_Struct.RenderButton_RCMenu.mnu_singleFrame.text = "Single Frame [" + (currentTime.frame as integer) as string + "]"
		Krakatoa_RCMenu_Struct.RenderButton_RCMenu.mnu_activeSegment.text = "Active Segment [" + (animationrange.start.frame as integer) as string + "-" + (animationrange.end.frame as integer) as string + "] Nth: " + rendNthFrame as string
		Krakatoa_RCMenu_Struct.RenderButton_RCMenu.mnu_customRange.text = "Custom Range [" + (rendStart.frame as integer) as string + "-" + (rendEnd .frame as integer) as string + "] Nth: " + rendNthFrame as string
		Krakatoa_RCMenu_Struct.RenderButton_RCMenu.mnu_CustomFrames.text = "Custom Frames ["  + rendPickupFrames + "] Nth: " + rendNthFrame as string
		popupmenu Krakatoa_RCMenu_Struct.RenderButton_RCMenu position:mouse.ScreenPos 
	)	

	on chk_Render_PFlowGeometry changed state do 
	(
		FranticParticles.SetProperty "RenderParticleFlowGeometry" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_PFlowGeometry rightClick do 
	(
		createDefaultsRCMenu "RenderParticleFlowGeometry" ">PFlow Geometry"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_PFlowBBox changed state do 
	(
		FranticParticles.SetProperty "RenderParticleFlowBBox" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_PFlowBBox rightClick do 
	(
		createDefaultsRCMenu "RenderParticleFlowBBox" ">PFlow BBox"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_PFlowPhantom changed state do 
	(
		FranticParticles.SetProperty "RenderParticleFlowPhantom" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_PFlowPhantom rightClick do 
	(
		createDefaultsRCMenu "RenderParticleFlowPhantom" ">PFlow Phantom"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_FumeFX changed state do 
	(
		FranticParticles.SetProperty "RenderFumeFX" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_FumeFX rightClick do 
	(
		createDefaultsRCMenu "RenderFumeFX" ">FumeFX"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on chk_Render_MaxParticles changed state do 
	(
		FranticParticles.SetProperty "RenderMaxParticles" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_MaxParticles rightClick do 
	(
		createDefaultsRCMenu "RenderMaxParticles" ">Legacy Particles"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on chk_Render_ThinkingParticles changed state do 
	(
		FranticParticles.SetProperty "RenderThinkingParticles" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_ThinkingParticles rightClick do 
	(
		createDefaultsRCMenu "RenderThinkingParticles" ">ThinkingParticles"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_GeometryVertices changed state do 
	(
		FranticParticles.SetProperty "RenderGeometryVertices" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_GeometryVertices rightClick do 
	(
		createDefaultsRCMenu "RenderGeometryVertices" ">Geometry Vertices"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_KrakatoaLoaders changed state do 
	(
		FranticParticles.SetProperty "RenderKrakatoaLoaders" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_KrakatoaLoaders rightClick do 
	(
		createDefaultsRCMenu "RenderKrakatoaLoaders" ">Particle Loaders"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on chk_Render_GeometryVolumes changed state do 
	(
		FranticParticles.SetProperty "RenderGeometryVolumes" state
		Krakatoa_GUI_Particles.refresh_GUI()
		update2009VFBControls side:#right
	)	
	on chk_Render_GeometryVolumes rightClick do 
	(
		createDefaultsRCMenu "RenderGeometryVolumes" ">Particle Loaders"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	
	
	
	on spn_VoxelSize changed  value do
	(
		FranticParticles.SetProperty "VoxelSize" (value as string)
	)
	
	on spn_VoxelFilterRadius changed value do
	(
		FranticParticles.SetProperty "VoxelFilterRadius" (value as string)
	)

	on spn_specularLevel changed value do 
	(
		FranticParticles.SetProperty "Lighting:Specular:Level" (value as string)
		updateCurve which:1
		updateCurve which:2
		update2009VFBControls side:#left
	)	
	on spn_glossiness changed value do 
	(
		FranticParticles.SetProperty "Lighting:Specular:Glossiness" (value as string)
		updateCurve which:1
		updateCurve which:2
		update2009VFBControls side:#left
	)
	/*
	on spn_diffuseLevel changed value do
	(
		FranticParticles.SetProperty "Lighting:Diffuse:Level" (value as string)
	)
	*/
	on spn_anisotropy changed value do
	(
		FranticParticles.SetProperty "Lighting:Specular:Anisotropy" (value as string)
		updateCurve which:2			
	)

	fn ddl_densityMethod_SelectedFN val = 
	(
		FranticParticles.SetProperty "Density:DensityMethod" ddl_densityMethod.text
		update2009VFBControls side:#left
	)
	on ddl_densityMethod selected val do 
	(
		ddl_densityMethod_SelectedFN val
		refresh_GUI()
	)	
	
	fn ddl_RenderingMethod_SelectedFN val =
	(
		FranticParticles.SetProperty "RenderingMethod" ddl_RenderingMethod.text
		refresh_GUI()
		update2009VFBControls side:#left
	)
	on ddl_RenderingMethod selected val do ddl_RenderingMethod_SelectedFN val		
	
	on spn_densityPerParticle changed val do 
	(
		FranticParticles.SetProperty "Density:DensityPerParticle" val
		update2009VFBControls side:#left
	)	
	on spn_densityExponent changed val do 
	(
		FranticParticles.SetProperty "Density:DensityExponent" val
		update2009VFBControls side:#left
	)	
	
	on spn_lightingDensityPerParticle changed val do 
	(
		FranticParticles.SetProperty "Lighting:Density:DensityPerParticle" val
		update2009VFBControls side:#left
	)	
	on spn_lightingDensityExponent changed val do 
	(
		FranticParticles.SetProperty "Lighting:Density:DensityExponent" val
		update2009VFBControls side:#left
	)	

	on ckb_enableMotionBlur changed val do 
	(
		FranticParticles.SetProperty "EnableMotionBlur" val
		Krakatoa_GUI_Channels.updateMemChannels()
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		refreshCacheStatus()
		update2009VFBControls side:#right
	)
	on ckb_enableMotionBlur rightClick do 
	(
		createDefaultsRCMenu "EnableMotionBlur" ">Enable Motion Blur"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	on ckb_enableDepthOfField changed val do 
	(
		FranticParticles.SetProperty "EnableDepthOfField" val
		update2009VFBControls side:#right
	)	
	on ckb_enableDepthOfField rightClick do 
	(
		createDefaultsRCMenu "EnableDepthOfField" ">Enable Depth Of Field"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on ckb_jitteredMotionBlur changed val do 
	(
		FranticParticles.SetProperty "JitteredMotionBlur" val
		Krakatoa_GUI_Channels.updateMemChannels()
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		refreshCacheStatus()
		update2009VFBControls side:#right
	)	
	
	on ckb_jitteredMotionBlur rightClick do 
	(
		createDefaultsRCMenu "JitteredMotionBlur" ">Jittered Motion Blur"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on ckb_deformationMotionBlur changed val do FranticParticles.SetProperty "DeformationMotionBlur" val
	
	on spn_motionBlurSegments changed val do 
	(
		FranticParticles.SetProperty "MotionBlurSegments" val
		update2009VFBControls side:#right
	)
	
	on spn_depthOfFieldSampleRate changed val do 
	(
		FranticParticles.SetProperty "DepthOfFieldSampleRate" val
		update2009VFBControls side:#right
	)
	
	on spn_blurShutter changed val do 
	(
		FranticParticles.SetProperty "ShutterAngleInDegrees" val
		update2009VFBControls side:#right
	)	
	on spn_blurBias changed val do 
	(
		FranticParticles.SetProperty "ShutterBias" val
		update2009VFBControls side:#right
	)
	
	fn ddl_particleMode_SelectedFN val =
	(
		FranticParticles.SetProperty "ParticleMode" ddl_particleMode.text
		Krakatoa_GUI_SaveParticles.open = val == 2
		
		--THIS IS A USER PREFERENCE
		local thePref = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout")
		case thePref of
		(
			default: Krakatoa_GUI_Partition.open = val == 2 --open if Save mode, close if Render or Light Mode
			"2": if val == 1 or val == 2 do Krakatoa_GUI_Partition.open = false --close if Render or Light mode
			"3": if val == 2 do Krakatoa_GUI_Partition.open = true --open if Save mode
			"4": ( )  --do nothing
		)
		
		--LOAD DEFAULT SOURCE SETTINGS - ALSO A PREFERENCE
		local thePref = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SwitchSourceDefaultsByRenderMode")
		if thePref == "true" then
		(
			local theString = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "SourceDefaults" (FranticParticles.GetProperty "ParticleMode")
			if theString != "" do convertSourcesFromString theString	
		)	
		refresh_GUI()
		update2009VFBControls()
	)
	
	on ddl_particleMode selected val do ddl_particleMode_SelectedFN val 
	
	on ckb_linkLightingAndRenderingDensity changed state do
	(	
		FranticParticles.SetProperty "Density:LinkLightingAndRenderingDensity" (not state)
		btn_lightingDensityPreset.enabled = spn_LightingDensityPerParticle.enabled = spn_LightingDensityExponent.enabled = state AND ckb_useLighting.checked
		ddl_attenuationLookupFilter.enabled = state AND ckb_useLighting.checked and (FranticParticles.GetProperty "RenderingMethod") == "Particle Rendering"
		update2009VFBControls side:#left
	)	

	on ckb_linkLightingAndRenderingDensity  rightClick do 
	(
		createDefaultsRCMenu "Density:LinkLightingAndRenderingDensity" "Link Lighting And Rendering Density] - the inverse of [>Use Lighting Pass Density Settings"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)
	
	fn ddl_drawPointFilter_selectedFN val = 
	(
		FranticParticles.SetProperty "DrawPointFilter" #("Nearest Neighbor","Bilinear","Bicubic")[val]
		update2009VFBControls side:#right		
	)
	on ddl_drawPointFilter selected val do ddl_drawPointFilter_selectedFN val 
	
	fn ddl_attenuationLookupFilter_SelectedFN val = 
	(
		FranticParticles.SetProperty "AttenuationLookupFilter" #("Nearest Neighbor","Bilinear","Bicubic")[val]
		update2009VFBControls side:#right		
	)
	on ddl_attenuationLookupFilter selected val do ddl_attenuationLookupFilter_SelectedFN val 
	
	fn ddl_particleColorSource_SelectedFN val =
	(
		local oldParticleColorSource = FranticParticles.GetProperty "ParticleColorSource"
		FranticParticles.SetProperty "ParticleColorSource" (#("Choose Color", "Medit1", "No Material", "Blended Z Depth","Blended Camera Distance"))[val] --"Material Self-Illumination","Custom Material Self-Illumination","Script Vector Channel"

		--THIS IS A USER PREFERENCE	- 1: Warn me and change settings, 2: Change without warning, 3: Do Not Change anything.
		local thePref = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch"
		if thePref == "1" do
		(
		-- Turn off lighting and enable post-divide by alpha when someone picks blended z depth
		-- This is so that the "correct" behavior for blended will happen by default when someone picks it
		if ddl_particleColorSource.text == "Blended Z Depth" or ddl_particleColorSource.text == "Blended Camera Distance" then 
		(
			local txt = "You are switching to '" + ddl_particleColorSource.text +"' mode.\nThe following settings will be changed to obtain correct results:\n\n"
			local q = true
			if FranticParticles.GetBoolProperty "UseLighting" == true do 
			(
				txt += "[ >Use Lighting ] will be turned OFF;\n"
				q = false 
			)	
			if FranticParticles.GetBoolProperty "PostDivideByAlpha" == false do 
			(
				txt += "[ >Post-Divide By Alpha ] will be turned ON.\n"
				q = false
			)	
			if not q do 
			(
				txt += "\n\nNOTE:You can disable this dialog in the Preferences rollout."
				messagebox txt title:"Krakatoa: Recommended Settings"
				FranticParticles.SetProperty "UseLighting" false
				FranticParticles.SetProperty "PostDivideByAlpha" true
			)	
		) 
		else if oldParticleColorSource == "Blended Z Depth" or oldParticleColorSource == "Blended Camera Distance" do 
		(
			-- If we're switching away from one of the Blended Distance modes, turn off the post-divide by alpha flag, and
			-- turn on the lighting.
			local txt = "You are switching from '"+ oldParticleColorSource +"' to '" + ddl_particleColorSource.text +"' mode.\nThe following settings will be changed to obtain correct results:\n\n"
			local q = true
			local theLights = for o in objects where findItem light.classes (classof o) > 0 collect o
			if FranticParticles.GetBoolProperty "UseLighting" == false and ddl_densityMethod.selected == "Volumetric Density" and theLights.count > 0 do 
			(
				txt += "[ >Use Lighting ] will be turned ON;\n"
				q = false 
			)	
			if FranticParticles.GetBoolProperty "PostDivideByAlpha" == true do 
			(
				txt += "[ >Post-Divide By Alpha ] will be turned OFF.\n"
				q = false
			)	
			if not q then
			(
				txt += "\n\nNOTE:You can disable this dialog in the Preferences rollout."
				messagebox txt title:"Krakatoa: Recommended Settings"
				if ddl_densityMethod.selected == "Volumetric Density" and theLights.count > 0 do FranticParticles.SetProperty "UseLighting" true
				FranticParticles.SetProperty "PostDivideByAlpha" false
			)	
		)
		)--end pref 1
		
		if thePref == "2" do
		(
			if ddl_particleColorSource.text == "Blended Z Depth" or ddl_particleColorSource.text == "Blended Camera Distance" then 
			(
				FranticParticles.SetProperty "UseLighting" false
				FranticParticles.SetProperty "PostDivideByAlpha" true				
			)
			else if oldParticleColorSource == "Blended Z Depth" or oldParticleColorSource == "Blended Camera Distance" do 
			(
				local theLights = for o in objects where findItem light.classes (classof o) > 0 collect o
				if ddl_densityMethod.selected == "Volumetric Density" and theLights.count > 0 do FranticParticles.SetProperty "UseLighting" true
				FranticParticles.SetProperty "PostDivideByAlpha" false				
			)
		)
		
		refresh_GUI()	
		Krakatoa_GUI_Channels.updateMemChannels()	
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		refreshCacheStatus()
		update2009VFBControls()
	)
	on ddl_particleColorSource selected val do ddl_particleColorSource_SelectedFN val

	on ckb_useLighting changed val do 
	(
		FranticParticles.SetProperty "UseLighting" val
		--btn_SpecularOn.enabled = 
		spn_specularLevel.enabled = spn_glossiness.enabled = val
		btn_enableLightingCache.enabled =  not((FranticParticles.GetProperty "ParticleMode") == "Save Particles To File Sequence") and val
		if not btn_enableLightingCache.enabled do 
		(
			--btn_enableLightingCache.checked = false
			--FranticParticles.SetProperty "EnableLightingCache" "false"
			--try(FranticParticles.InvalidateLightingCache())catch()
		)	
		ckb_linkLightingAndRenderingDensity.enabled = val
		ddl_attenuationLookupFilter.enabled = spn_LightingDensityPerParticle.enabled = spn_LightingDensityExponent.enabled = val AND ckb_linkLightingAndRenderingDensity.state
		updateCurve which:1
		updateCurve which:2
		Krakatoa_GUI_Channels.updateMemChannels()
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		refreshCacheStatus()
		update2009VFBControls()			
	)
	on ckb_useLighting rightClick do 
	(
		createDefaultsRCMenu "UseLighting" ">USE LIGHTING"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on clr_backgroundColor changed val do 
	(
		FranticParticles.SetProperty "BackgroundColor" (val as string)
		update2009VFBControls side:#left
	)
	
	on ckb_useFilterColor changed state do 
	(
		FranticParticles.SetProperty "UseFilterColor" (state as string)
		update2009VFBControls side:#left
	)
	on ckb_useFilterColor rightClick do 
	(
		createDefaultsRCMenu "UseFilterColor" ">Use Filter Color"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on ckb_overrideEnvironmentColor changed state do 
	(
		clr_backgroundColor.enabled = state		
		FranticParticles.SetProperty "UseEnvironmentColor" ((not state) as string)
		Krakatoa_GUI_Channels.updateMemChannels()
		Krakatoa_GUI_ParticleLoaders.updateLoadersList()
		update2009VFBControls side:#left
	)
	on ckb_overrideEnvironmentColor rightClick do 
	(
		createDefaultsRCMenu "UseEnvironmentColor" "Use Environment Color] - Inverse Of [>Use Background Color"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on clr_chooseColor changed val do FranticParticles.SetProperty "ChosenColor" (val as string)
	
	on ckb_postDivideByAlpha changed val do 
	(
		FranticParticles.SetProperty "PostDivideByAlpha" val
		update2009VFBControls side:#left
	)		
	on ckb_postDivideByAlpha rightClick do 
	(
		createDefaultsRCMenu "PostDivideByAlpha" ">Post-Divide by Alpha"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)

	on btn_quickRender pressed do 
	(
		if chk_iterativeRender.checked and chk_iterativeRender.enabled then 
		(
			local oldState = renderSceneDialog.isOpen()
			renderSceneDialog.close()
			
			local oldSaveFile = rendSaveFile 
			local oldTimeType = rendTimeType 
			
			rendSaveFile = false
			rendTimeType = 1
			local oldWidth = renderWidth
			local oldHeight = renderHeight
			
			local theScaleFactor = case Krakatoa_RCMenu_Struct.IterativeOptions_Selection of
			(
				"2" : 2
				"1" : 1
				"1/2" : 0.5
				"1/4" : 0.25
				"1/8" : 0.125
				"1/16" : 0.0625
			)
			renderWidth = oldWidth*theScaleFactor
			renderHeight = oldHeight*theScaleFactor
			
			local oldDensity = FranticParticles.getFloatProperty "Density:DensityPerParticle"
			if FranticParticles.getProperty "Density:DensityMethod" != "Volumetric Density" and FranticParticles.getProperty "RenderingMethod" != "Voxel Rendering" do 
				FranticParticles.setProperty "Density:DensityPerParticle" (((oldDensity)*(theScaleFactor^2))as string)
			max quick render

			FranticParticles.setProperty "Density:DensityPerParticle" (oldDensity as string)
			rendTimeType = oldTimeType 
			rendSaveFile = oldSaveFile 
			renderWidth = oldWidth 
			renderHeight = oldHeight
			if oldState do renderSceneDialog.Open()
		)
		else
			max quick render
	)

	on Krakatoa_GUI_Main close do 
	(
		
		if Krakatoa_GUI_Main.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Main.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Main open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Main.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Main Rollout OPENED.")			
	)			
)--end rollout

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PARTICLE SAVING ROLLOUT 
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	

rollout Krakatoa_GUI_SaveParticles "Save Particles" rolledup:true category:20 width:457
(
	local allPaths = #()
	local allValues = #()
	local historyValue = undefined
	
	button btn_LoadSave_SaveParticles "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_SaveParticles  "Open Krakatoa Online Help..." height:14 width:408 offset:[0,-5] align:#center 
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_LoadSave_SaveParticles pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_SaveParticles
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_SaveParticles rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_SaveParticles
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	
	on btn_Help_SaveParticles pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/save_particles_rollout.php" ""		

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_SaveParticles
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_SaveParticles
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)

	on Krakatoa_GUI_SaveParticles moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_SaveParticles.title (pos as string)
	)			

	group "Simple Save Path Controls"
	(
		button btn_particleFilesHistory "H" width:15 height:20 offset:[-5,-2] align:#left across:4 tooltip:"Browse Particle File Sequence History. Particle Render Mode will be changed to Save Particles To File Sequence automatically if a valid path is picked." 
		button btn_particleFiles "..." width:15 height:20 offset:[-93,-2] align:#left tooltip:"Select Path and File Name to Save Particle Files To. Particle Render Mode will be changed to Save Particles To File Sequence automatically if a valid path is specified."
		edittext edt_particleFiles "Path" fieldwidth:355 align:#center offset:[-44,0] 
		button btn_ExploreSavePath "E" align:#right width:16 height:20 offset:[6,-2] tooltip:"Open Current Save Path In Windows Explorer..." 
	)	
	group "Detailed Save Path Controls"
	(
		button btn_BaseHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:3 tooltip:"Browse Root Path History..." 
		edittext edt_particleFilesBase "Root" fieldwidth:355 align:#left offset:[-111,-2] 
		button btn_ExploreBase "E" align:#right width:16 height:20 offset:[5,-4] tooltip:"Open Root Path In Windows Explorer..."  

		button btn_ProjectHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:3 tooltip:"Browse Project History..." 
		edittext edt_particleFilesProject "Project" fieldwidth:355 align:#left offset:[-121,-2] 
		button btn_ExploreProjectPath "E" align:#right width:16 height:20 offset:[5,-4] tooltip:"Open Project Path In Windows Explorer..."  

		button btn_SequenceHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:3 tooltip:"Browse Sequence History" 
		edittext edt_particleFilesSequence "Seq." fieldwidth:355 align:#left offset:[-110,-2] 
		button btn_ExploreSequencePath "E" align:#right width:16 height:20 offset:[5,-4] tooltip:"Open Sequence Path In Windows Explorer..." 

		button btn_TakeHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:6 tooltip:"Browse Take History" 
		edittext edt_particleFilesTake "Take" fieldwidth:268 align:#left offset:[-41,-2] 
		button btn_TakeMajorUp "M+" align:#right width:28 height:20 offset:[144,-4] tooltip:"Increment MAJOR version (200,300,400...)" 
		button btn_TakeMinorUp "m+" align:#right width:28 height:20 offset:[102,-4] tooltip:"Increment minor version (110,120,130...)" 
		button btn_TakeUp "i+" align:#right width:28 height:20 offset:[60,-4] tooltip:"Increment take (101,102,103...)"
		button btn_ExploreTake "E" align:#right width:16 height:20 offset:[8,-4] tooltip:"Open Take Path In Windows Explorer..." 

		button btn_FilenameHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:6 tooltip:"Browse File Name History" 
		edittext edt_particleFilesName "File" fieldwidth:268 align:#left offset:[-32,-2] 
		button btn_TypePrt ".prt" align:#right width:28 height:20 offset:[144,-4] tooltip:"Frantic Particle Format" 
		button btn_TypeCsv ".csv" align:#right width:28 height:20 offset:[102,-4] tooltip:"Comma Separated Values File" 
		button btn_TypeBin ".bin" align:#right width:28 height:20 offset:[60,-4] tooltip:"RealFlow 4 Particle BIN Format"
		button btn_getFilenameFromMax "M" align:#right width:16 height:20 offset:[8,-4] tooltip:"Get 3ds Max Scene Name, or set to 'Particles' if Untitled." 
	)
	
	group "After a Partition is saved,"
	(
		dropdownlist ddl_BackupRootMode items:#("LEAVE the file sequence at the Save Path listed above.","COPY the file sequence to the Backup Path defined below:","MOVE the file sequence to the Backup Path defined below:") width:375 align:#right offset:[3,-2]
		button btn_BackupRootHistory "H" width:15 height:20 offset:[-5,-4] align:#left across:4 tooltip:"Browse Root Path History..." visible:false
		button btn_particleFilesBackup "..." width:15 height:20 offset:[-93,-4] align:#left tooltip:"Select Path and File Name to Save Particle Files To. Particle Render Mode will be changed to Save Particles To File Sequence automatically if a valid path is specified."
		edittext edt_particleFilesBackupRoot "Root" fieldwidth:355 align:#center offset:[-44,-2] 
		button btn_ExploreBackupRoot "E" align:#right width:16 height:20 offset:[5,-4] tooltip:"Open Backup Root Path In Windows Explorer..."  
		edittext edt_particleFilesBackupPath "Backup Path" fieldwidth:355 align:#left offset:[-7,-2] across:2 enabled:false
		button btn_ExploreBackupPath "E" align:#right width:16 height:20 offset:[3,-4] tooltip:"Open Backup Root Path In Windows Explorer..."  
	)
	
	fn isTake theTake =
	(
		local theValues = #()
		for i = theTake.count to 1 by -1 do 
		(
			if bit.charAsInt theTake[i] >= 48 and bit.charAsInt theTake[i] <= 57 then
				append theValues theTake[i]
			else	
				exit
		)	
		local txt = ""
		for i = theValues.count to 1 by -1 do txt += theValues[i]
		if txt.count > 0 then 
			#(substring theTake 1 (theTake.count - theValues.count), txt as integer)
		else
			undefined	
	)
	


	fn resolveAdvancedPathStructure =
	(	
		local val = FranticParticles.GetProperty "ParticleFiles" 
		if val != "" do
		(
			isNetworkPath = matchpattern val pattern:"\\\\*" 
			local fString = filterString val "\\/"
			if isNetworkPath do fString[1] = "\\\\" + fString[1]
			fString = for i = fString.count to 1 by -1 collect fString[i]
			fString = for i in fString where i.count > 0 collect i
			
			FranticParticles.SetProperty "ParticleFilesName" (edt_particleFilesName.text = fString[1])
			deleteItem fString 1
			if fString.count > 0 do
			(
				if isTake fString[1] != undefined then
				(
					FranticParticles.SetProperty "ParticleFilesTake" (edt_particleFilesTake.text = fString[1])
					deleteItem fString 1
				)	
				else
					FranticParticles.SetProperty "ParticleFilesTake" (edt_particleFilesTake.text = "")
					
				case fString.count of
				(
					0: ()
					1: (
						FranticParticles.SetProperty "ParticleFilesBase" (edt_particleFilesBase.text = fString[1])
						FranticParticles.SetProperty "ParticleFilesProject" (edt_particleFilesProject.text = "")
						FranticParticles.SetProperty "ParticleFilesSequence" (edt_ParticleFilesSequence.text = "")
						)
					2:
					(
							FranticParticles.SetProperty "ParticleFilesProject" (edt_particleFilesProject.text = fString[1])
							FranticParticles.SetProperty "ParticleFilesBase" (edt_particleFilesBase.text = fString[2])
							FranticParticles.SetProperty "ParticleFilesSequence" (edt_ParticleFilesSequence.text = "")
					)
					3:
					(
							FranticParticles.SetProperty "ParticleFilesSequence" (edt_ParticleFilesSequence.text = fString[1])
							FranticParticles.SetProperty "ParticleFilesProject" (edt_particleFilesProject.text = fString[2])
							FranticParticles.SetProperty "ParticleFilesBase" (edt_particleFilesBase.text = fString[3])
					)
					default:
					(
							FranticParticles.SetProperty "ParticleFilesSequence" (edt_ParticleFilesSequence.text = fString[1])
							FranticParticles.SetProperty "ParticleFilesProject" (edt_particleFilesProject.text = fString[2])
							local theRoot = ""
							for i = fString.count to 3 by -1 do theRoot += fString[i] + "\\"
								FranticParticles.SetProperty "ParticleFilesBase" (edt_particleFilesBase.text = theRoot)
					)		
				)--end case
			)	
		)
	)
	
	fn getFilenameFromBackupRoot =
	(
		local val = FranticParticles.GetProperty "Partition:BackupRoot"
		if val != "" do
		(
			local theNextVal = FranticParticles.GetProperty "ParticleFilesProject"
			if theNextVal != "" then
			(
				if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
				val += theNextVal
			)
			theNextVal = FranticParticles.GetProperty "ParticleFilesSequence"
			if theNextVal != "" then
			(
				if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
				val += theNextVal
			)
			theNextVal = FranticParticles.GetProperty "ParticleFilesTake"
			if theNextVal != "" then
			(
				if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
				val += theNextVal
			)			
		)	
		val 
	)		
	
	fn validateBackupPath txt =
	(
		if doesFileExist txt then
		(
			if txt[txt.count] != "\\" do txt+= "\\"
			FranticParticles.SetProperty "Partition:BackupRoot" (txt as string)
		)
		else
			if txt != "" do messagebox ("The specified path\n"+ txt +"does not exist!\n\nReverting to last stored value...") title:"Krakatoa: Local Partition Backup Path"
		edt_particleFilesBackupRoot.text = FranticParticles.GetProperty "Partition:BackupRoot"
		if edt_particleFilesBase.text == edt_particleFilesBackupRoot.text then
		(
			messagebox "The SAVE path and the BACKUP path can not be the same!" title:"Krakatoa: Local Partition Backup Path"
			FranticParticles.SetProperty "Partition:BackupRoot" ""
			edt_particleFilesBackupRoot.text = ""
		)
		edt_particleFilesBackupPath.text = getFilenameFromBackupRoot()	
	)			
	
	fn checkValidSaveFileName val =
	(
		val = trimRight (trimLeft val)
		local txt = ""
		local fString = (filterString val "\\/")
		if fString.count > 0 do
		(
			if matchPattern val pattern:"\\\\*" do fString[1] = "\\\\" + fString[1]
			for i = 1 to fString.count-1 do txt += fString[i] + "\\"
			txt += fString[fString.count]
			val = txt
			local q = false
			if getFileNamePath val != "" AND not doesFileExist (getFileNamePath val) do
			(
				q = querybox ("The path\n"+ (getFileNamePath val) +"\ndoes NOT exist.\nShould it be CREATED?") title:"Save Path Does Not Exist"
				if q do makeDir (getFileNamePath val) all:true --create the full path if it does not exist and the user wants to create it.
			)	
			if doesFileExist (getFileNamePath val) then 
			(
--					if not matchPattern (getFileNameFile val) pattern:"*_" do val = getFileNamePath val + (getFileNameFile val) + "_" + getFileNameType val
				if not matchpattern (getFileNameType val) pattern:".prt" and \
					not matchpattern (getFileNameType val) pattern:".csv" and \
					not matchpattern (getFileNameType val) pattern:".bin" do val = getFileNamePath val + getFilenameFile val + ".prt"
				FranticParticles.SetProperty "ParticleFiles" (edt_particleFiles.text = val)
				resolveAdvancedPathStructure()
			)	
			else --if the path does not exist, revert to the previously stored path
			(
				edt_particleFiles.text = FranticParticles.GetProperty "ParticleFiles" 
				resolveAdvancedPathStructure()
				if q do messagebox "The path you entered could not be created!\nReverting to the last stored path." title:"Failed To Create Directory"
			)			
		)
		validateBackupPath edt_particleFilesBackupRoot.text
	)
	


	
	fn buildFilenameFromAdvancedPath =
	(
		local val = FranticParticles.GetProperty "ParticleFilesBase"
			
		if not matchPattern val pattern:"*\\" and not matchPattern val pattern:"*/" do val += "\\"
		
		
		local theNextVal = FranticParticles.GetProperty "ParticleFilesProject"
		if theNextVal != "" then
		(
			if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
			val += theNextVal
		)
		theNextVal = FranticParticles.GetProperty "ParticleFilesSequence"
		if theNextVal != "" then
		(
			if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
			val += theNextVal
		)
		theNextVal = FranticParticles.GetProperty "ParticleFilesTake"
		if theNextVal != "" then
		(
			if not matchPattern theNextVal pattern:"*\\" and not matchPattern theNextVal pattern:"*/" do theNextVal += "\\"
			val += theNextVal
		)			
		theNextVal = FranticParticles.GetProperty "ParticleFilesName"
		if theNextVal != "" then
		(
--				if not matchpattern (getFileNameFile theNextVal) pattern:"*_" then 
--					theNextVal = (getFileNameFile theNextVal) + "_" + getFileNameType theNextVal
			val += theNextVal
		)
		else
			val += "particles_.prt"
			
		checkValidSaveFileName val	
	)
	

	fn checkForValidBinFile =
	(
		local theMode = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving"
		if theMode == "3" then return true
		local theFileName = FranticParticles.GetProperty "ParticleFilesName" 
		if theFileName != "" and matchpattern (getFileNameType theFileName) pattern:".bin" then
		(
			local txt = getFileNameFile theFileName
			local theValues = #()
			for i = txt.count to 1 by -1 do 
			(
				if bit.charAsInt txt[i] >= 48 and bit.charAsInt txt[i] <= 57 then
					append theValues txt[i]
				else	
					exit
			)					
			if theValues.count < 5 then
			(
				local theResult = true
				if theMode == "1" then
				(
					local theWarning = "WARNING:\nRealFlow expects Particle BIN files to contain 5 trailing digits in the file name.\n"
					if  theValues.count == 1 then
						theWarning += "The file name you specified contains only one digit and does not satisfy this requirement.\n"
					else	if theValues.count == 0 then
						theWarning += "The file name you specified contains no digits and does not satisfy this requirement.\n"
					else
						theWarning += "The file name you specified contains only "+  theValues.count as string +" digits and does not satisfy this requirement.\n"
					theWarning += "The files you are about to generate would not be usable with RealFlow 4 and its related importers.\n"
					theWarning += "\nPress [Yes] to fix the file name automatically.\n"
					theWarning += "Press [No] to leave the file name as is.\n\n"
					theWarning += "This warning can be disabled in the Preferences rollout."
					
					theResult = querybox theWarning title:"Krakatoa Saving RealFlow4 BIN Files"
				)
				if theResult then
				(
					thePrefix = substring "00000" 1 (5-theValues.count)
					for i in theValues do thePrefix += i
					newName = substring txt 1 (txt.count-theValues.count) + thePrefix
					 FranticParticles.SetProperty "ParticleFilesName" (newName + ".bin")
					 buildFilenameFromAdvancedPath()
				)
			)	
		)
	)			
	
	fn setSaveFileControlsVisibility state enable:true = 
	(
		btn_BaseHistory.enabled = edt_particleFilesBase.enabled= btn_ExploreBase.enabled=  enable
		btn_ProjectHistory.enabled= edt_particleFilesProject.enabled= btn_ExploreProjectPath.enabled= enable
		btn_SequenceHistory.enabled= edt_particleFilesSequence.enabled= btn_ExploreSequencePath.enabled= enable
		btn_FilenameHistory.enabled= edt_particleFilesName.enabled= btn_getFilenameFromMax.enabled= enable
		btn_TakeHistory.enabled= edt_particleFilesTake.enabled=  btn_TakeMajorUp.enabled= btn_TakeMinorUp.enabled= btn_TakeUp.enabled= btn_ExploreTake.enabled= enable
		btn_TypePrt.enabled= btn_TypeCsv.enabled= btn_TypeBin.enabled= enable
	)
	
	fn refresh_GUI = 
	(
		local enableSaveParticleFileControls = (FranticParticles.GetProperty "ParticleMode") == "Save Particles To File Sequence"
		Krakatoa_GUI_SaveParticles.open = FranticParticles.GetBoolProperty "GUI:SaveParticlesRolloutOpen" or enableSaveParticleFileControls 
		
--			edt_particleFiles.enabled = btn_ExploreSavePath.enabled = enableSaveParticleFileControls
		edt_particleFiles.text = FranticParticles.GetProperty "ParticleFiles"
		--setSaveFileControlsVisibility true enable:enableSaveParticleFileControls
		resolveAdvancedPathStructure()
		
		
		local theVal = execute (FranticParticles.GetProperty "Partition:BackupRootMode")
		if theVal == OK do theVal = 1
		ddl_BackupRootMode.selection = theVal
		edt_particleFilesBackupRoot.text = FranticParticles.GetProperty "Partition:BackupRoot"
		edt_particleFilesBackupPath.text = getFilenameFromBackupRoot()
		Krakatoa_GUI_Partition.refresh_GUI()
	)	

	fn takeUp mode:#increment =
	(
		local theFile = FranticParticles.GetProperty "ParticleFiles" 
		if theFile != "" do
		(
			local theTake = FranticParticles.GetProperty "ParticleFilesTake" 
			local theValues = #()
			for i = theTake.count to 1 by -1 do 
			(
				if bit.charAsInt theTake[i] >= 48 and bit.charAsInt theTake[i] <= 57 then
					append theValues theTake[i]
				else	
					exit
			)	
			theValue = ""
			for i = theValues.count to 1 by -1 do theValue += theValues[i]
			case mode of
			(
			#increment: theValue = ((theValue as integer) + 1)
			#minor: (
					theValue = 10 * ((theValue as integer)/10) 
					theValue += 10
				)
			#major: (
					theValue = 100 * ((theValue as integer)/100) 
					theValue += 100
				)
			)
			if theValues.count == 0 then 
			(
				theBase = "v"
				theCount = 3
			)	
			else	
			(
				theBase = substring theTake 1 (theTake.count - theValues.count)
				theCount = theValues.count 
			)			
			FranticParticles.SetProperty "ParticleFilesTake" (edt_particleFilesTake.text = theBase + (FranticParticleRenderMXS.LeadingZeros theValue theCount) + (theValue as string) )
			buildFilenameFromAdvancedPath()
		)			
	)
	
	on btn_TakeUp pressed do takeUp mode:#increment
	on btn_TakeMinorUp pressed do takeUp mode:#minor
	on btn_TakeMajorUp pressed do takeUp mode:#major
	
	fn getFromKrakatoaHistory mode:#particleFiles theControl: searchKey: =
	(
		allPaths = #()
		allValues = #()
		local theCacheFile = (Krakatoa_PresetsDirectory+"\\_HistoryCache.List")
		if not doesFileExist theCacheFile do Krakatoa_GUI_Presets.rebuildHistoryCache()
		local theHistoryCache = openFile theCacheFile
		local theHistoryFiles = #()
		while not eof theHistoryCache do 
		(
			local f =  ( Krakatoa_PresetsDirectory + "\\history\\" +  (readLine theHistoryCache) + ".KrakatoaSettings")
			if (thePath = (getIniSetting f "SceneInfo" searchKey)) != "" and findItem allValues thePath == 0 do 
			(
				append allPaths (getIniSetting f "SceneInfo" "ParticleFiles")
				append allValues thePath		
			)	
		)	
		close theHistoryCache
		
		createDialog Krakatoa_GUI_History_Dialog 820 310 modal:true
		if historyValue != undefined do 
		(
			case mode of
			(
				#Files:
				(
					FranticParticles.SetProperty searchKey (theControl.text = historyValue)
					FranticParticles.SetProperty "ParticleMode" "Save Particles To File Sequence"
					refresh_GUI()		
					resolveAdvancedPathStructure()			
				)
				default:
				(
					FranticParticles.SetProperty searchKey (theControl.text = historyValue)
					buildFilenameFromAdvancedPath ()			
				)	
			)	
		)	
	)
	
	on btn_particleFilesHistory pressed do getFromKrakatoaHistory mode:#Files theControl:edt_particleFiles searchKey:"ParticleFiles"
	on btn_BaseHistory pressed do getFromKrakatoaHistory mode:#Base theControl:edt_particleFilesBase searchKey:"ParticleFilesBase"
	on btn_ProjectHistory pressed do getFromKrakatoaHistory mode:#Project theControl:edt_ParticleFilesProject searchKey:"ParticleFilesProject"
	on btn_SequenceHistory pressed do getFromKrakatoaHistory mode:#Sequence theControl:edt_ParticleFilesSequence searchKey:"ParticleFilesSequence"
	on btn_TakeHistory pressed do getFromKrakatoaHistory mode:#Take theControl:edt_ParticleFilesTake searchKey:"ParticleFilesTake"
	on btn_FilenameHistory pressed do getFromKrakatoaHistory mode:#Name theControl:edt_ParticleFilesName searchKey:"ParticleFilesName"
	
	on btn_getFilenameFromMax pressed do
	(
		FranticParticles.SetProperty "ParticleFilesName"  (edt_particleFilesName.text = if maxFileName == "" then "particles_" else maxFileName)
		buildFilenameFromAdvancedPath ()	
	)
	
	on edt_particleFiles entered val do 
	(
		checkValidSaveFileName val 
		checkForValidBinFile()
	)	
	on edt_particleFilesBase entered txt do 
	(
		FranticParticles.SetProperty "ParticleFilesBase" (trimRight (trimLeft txt)) 
		buildFilenameFromAdvancedPath()
	)
	on edt_particleFilesProject entered txt do 
	(
		FranticParticles.SetProperty "ParticleFilesProject" (trimRight (trimLeft txt))
		buildFilenameFromAdvancedPath()
	)
	on edt_particleFilesSequence entered txt do 
	(
		FranticParticles.SetProperty "ParticleFilesSequence" (trimRight (trimLeft txt))
		buildFilenameFromAdvancedPath()
	)
	on edt_particleFilesTake entered txt do 
	(
		FranticParticles.SetProperty "ParticleFilesTake" (trimRight (trimLeft txt))
		buildFilenameFromAdvancedPath()
	)
	on edt_particleFilesName entered txt do 
	(
		local theVal = trimRight (trimLeft txt)
		theVal = (filterString theVal "\\/?*!" )[1] 
		if theVal == undefined do theVal = "Particles"
		FranticParticles.SetProperty "ParticleFilesName" theVal
		edt_particleFilesName.text = theVal
		buildFilenameFromAdvancedPath()
		checkForValidBinFile()
	)
	
	on btn_particleFiles pressed do 
	(
		local rootName = (FranticParticles.GetProperty "ParticleFiles")
		rootNameBase = getFileNamePath rootName + getFileNameFile rootName 
		if rootName == "" do 
			rootNameBase= (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath") + "particles_"
			
		local newParticleFiles = case (substring (getFileNameType rootName) 2 -1 )  as name of
		(
			default: getSaveFileName caption:"Select the Particle File Sequence to Save" filename:rootNameBase types:"Frantic Particle Files (*.prt)|*.prt|Comma Separated Value (*.csv)|*.csv|RealFlow 4 (*.bin)|*.bin" history:"KrakatoaParticles"
			#csv: getSaveFileName caption:"Select the Particle File Sequence to Save" filename:rootNameBase types:"Comma Separated Value (*.csv)|*.csv|Frantic Particle Files (*.prt)|*.prt|RealFlow 4 (*.bin)|*.bin" history:"KrakatoaParticles"
			#bin: getSaveFileName caption:"Select the Particle File Sequence to Save" filename:rootNameBase types:"RealFlow 4 (*.bin)|*.bin|Frantic Particle Files (*.prt)|*.prt|Comma Separated Value (*.csv)|*.csv" history:"KrakatoaParticles"
		)
		if newParticleFiles != undefined do 
		(
			theFileName = getFileNameFile newParticleFiles
--				if not matchpattern theFileName pattern:"*_" do newParticleFiles = getFileNamePath newParticleFiles + theFileName + "_" + getFileNameType newParticleFiles
			FranticParticles.SetProperty "ParticleFiles" newParticleFiles
			FranticParticles.SetProperty "ParticleMode" "Save Particles To File Sequence"
			Krakatoa_GUI_Main.refresh_GUI()
			refresh_GUI()
		)
	)

	fn changePrtFileType theType =
	(
		theFileName = FranticParticles.GetProperty "ParticleFilesName" 
		if theFileName != "" then
		(
			FranticParticles.SetProperty "ParticleFilesName" (getFileNameFile theFileName + theType )
			buildFilenameFromAdvancedPath()
		)	
	)
	on btn_TypePrt pressed do changePrtFileType ".prt"
	on btn_TypeCsv pressed do changePrtFileType ".csv"
	on btn_TypeBin pressed do 
	(
		changePrtFileType ".bin"
		checkForValidBinFile()
	)	
	
	
	fn explorePath thePath =
	(
		if doesFileExist thePath then 
			shelllaunch "explorer.exe" thePath
		else
			messagebox ("The Specified Path \n"+ thePath +"\nDoes Not Exist Yet.") title:"Krakatoa: Explore Path"		
	)
	
	on btn_ExploreSavePath pressed do
	(
		explorePath (getFileNamePath edt_particleFiles.text)
	)

	
	on btn_ExploreBase pressed do
	(	
		explorePath (FranticParticles.GetProperty "ParticleFilesBase")
	)
	
	on btn_ExploreProjectPath pressed do
	(	
		val = (FranticParticles.GetProperty "ParticleFilesBase")
		if matchPattern val pattern:"*/" do val[val.count] = "\\"
		if not matchPattern val pattern:"*\\" do val += "\\"
		val += (FranticParticles.GetProperty "ParticleFilesProject")
		explorePath val 
	)	

	on btn_ExploreSequencePath pressed do
	(	
		val = (FranticParticles.GetProperty "ParticleFilesBase")
		if matchPattern val pattern:"*/" do val[val.count] = "\\"
		if not matchPattern val pattern:"*\\" do val += "\\"
		nextval = (FranticParticles.GetProperty "ParticleFilesProject")
		if nextval != "" do
		(
			if matchPattern nextval pattern:"*/" do nextval[nextval.count] = "\\"
			if not matchPattern nextval pattern:"*\\" do nextval += "\\"
			val += nextval
		)
		nextval = (FranticParticles.GetProperty "ParticleFilesSequence")
		if nextval != "" do
		(
			if matchPattern nextval pattern:"*/" do nextval[nextval.count] = "\\"
			if not matchPattern nextval pattern:"*\\" do nextval += "\\"
			val += nextval
		)
		explorePath val 
	)	

	on btn_ExploreTake pressed do
	(	
		val = (FranticParticles.GetProperty "ParticleFilesBase")
		if matchPattern val pattern:"*/" do val[val.count] = "\\"
		if not matchPattern val pattern:"*\\" do val += "\\"
		nextval = (FranticParticles.GetProperty "ParticleFilesProject")
		if nextval != "" do
		(
			if matchPattern nextval pattern:"*/" do nextval[nextval.count] = "\\"
			if not matchPattern nextval pattern:"*\\" do nextval += "\\"
			val += nextval
		)
		nextval = (FranticParticles.GetProperty "ParticleFilesSequence")
		if nextval != "" do
		(
			if matchPattern nextval pattern:"*/" do nextval[nextval.count] = "\\"
			if not matchPattern nextval pattern:"*\\" do nextval += "\\"
			val += nextval
		)
		nextval = (FranticParticles.GetProperty "ParticleFilesTake")
		if nextval != "" do
		(
			if matchPattern nextval pattern:"*/" do nextval[nextval.count] = "\\"
			if not matchPattern nextval pattern:"*\\" do nextval += "\\"
			val += nextval
		)			
		explorePath val 
	)		


	
	on ddl_BackupRootMode selected itm do FranticParticles.SetProperty "Partition:BackupRootMode" (itm as string)
	on edt_particleFilesBackupRoot entered txt do validateBackupPath txt

	on btn_particleFilesBackup pressed do
	(
		local theBackupRoot = getSavePath caption:"Krakatoa: Select Backup Root" initialDir:(FranticParticles.GetProperty "Partition:BackupRoot")
		if theBackupRoot != undefined do
		(
			validateBackupPath theBackupRoot
		)
	)

	
	on btn_ExploreBackupRoot pressed do
	(	
		explorePath edt_particleFilesBackupRoot.text
	)		
	on btn_ExploreBackupPath pressed do
	(	
		explorePath edt_particleFilesBackupPath.text
	)	


	on Krakatoa_GUI_SaveParticles close do 
	(
		if Krakatoa_GUI_SaveParticles.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_SaveParticles.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_SaveParticles open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_SaveParticles.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Save Particles Rollout OPENED.")			
	)			
)
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PARTICLE CHANNELS ROLLOUT 
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	

rollout Krakatoa_GUI_Channels "Channels" rolledup:true category:30 width:457
(	
	local activeChannels = #()
	local inactiveChannels = #()
	local allPossibleChannels = #()
	
	local activeMemChannels = #()
	local inactiveMemChannels = #()
	
	local MemoryBytesPerParticle = 38
	
	button btn_LoadSave_Channels "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_Channels  "Open Krakatoa Online Help..." height:14 width:408 offset:[0,-5] align:#center
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	
	on btn_LoadSave_Channels pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Channels
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_Channels rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Channels
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)		
	
	on btn_Help_Channels pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/particle_channels.php" ""		
		
	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Channels
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Channels
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)			
	
	on Krakatoa_GUI_Channels moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Channels.title (pos as string)
	)		

	group "Particle Channels To Load Into Memory    + Cached   -- NOT Cached "
	(
		multilistbox lbx_allMemoryChannels " Inactive Channels:" items:#() height:8 across:2 width:204 align:#left offset:[0,-5]
		multilistbox lbx_activeMemoryChannels " Active Channels:" items:#() height:8 width:205 align:#right offset:[0,-5]
	)
	
	button btn_memmake16 "16" width:20 height:35 alignt:#center offset:[0,-110] tooltip:"Switch the Selected Channels To 16 bit Precision." 
	button btn_memmake32 "32" width:20 height:35 alignt:#center offset:[0,-3] tooltip:"Switch the Selected Channels To 32 bit Precision."
	button btn_memmake64 "64" width:20 height:30 alignt:#center offset:[0,-3] visible:false tooltip:"Switch the Selected Channels To 64 bit Precision." 

	label lbl_CurrentCache ""

	group "Particle Count / Memory Calculator"
	(
		spinner spn_particleCount "" range:[0,10000000,1] type:#float across:6 fieldwidth:90 offset:[0,0] align:#left
		button btn_countPresets ">>" width:22 height:18 align:#right offset:[-18,-1] tooltip:"Set Particle Count to a Preset Value, or Add/Remove current value to/from the Presets."
		label lbl_particleCount "Million Particles Require" offset:[10,2]
		spinner spn_MemoryUsage "" range:[0,1000000,3000] type:#float fieldwidth:90 offset:[66,0] align:#right
		button btn_memoryPresets ">>" width:22 height:18 align:#right offset:[18,-1] tooltip:"Set Memory to a Preset Value, or Add/Remove current value to/from the Presets."
		label lbl_MBRAM "MB Memory."align:#right offset:[10,2]
	)

	
	group "Particle Channels To Save To Disk"
	(
		multilistbox lbx_allChannels " Do Not Save Channels:" items:#() height:12 across:2 width:204 align:#left offset:[0,-5]
		multilistbox lbx_activeChannels " Save Channels:" items:#() height:12 width:205 align:#right offset:[0,-5]
		
		checkbutton ckb_showMappingChannels ">All Mapping Channels" align:#left offset:[0,-3] width:120 across:9 tooltip:"Show all Mapping Channels." highlightcolor:KrakatoaSkinColorsStruct.Channels
		button btn_allAll "All" width:40 alignt:#left offset:[70,-3] tooltip:"Select All Inactive Channels."
		button btn_allInvert "Invert" width:40 alignt:#left offset:[65,-3] tooltip:"Invert Inactive Channels Selection."

		button btn_activeAll "All" width:40 alignt:#center offset:[82,-3] tooltip:"Select All Active Channels."
		button btn_activeInvert "Invert" width:40 alignt:#center offset:[77,-3] tooltip:"Invert Active Channels Selection."
		
		button btn_make16 "16" width:40 alignt:#right offset:[70,-3] tooltip:"Switch the Selected Channels To 16 bit Precision."
		button btn_make32 "32" width:40 alignt:#right offset:[64,-3] tooltip:"Switch the Selected Channels To 32 bit Precision."
		button btn_make64 "64" width:40 alignt:#right offset:[57,-3] tooltip:"Switch the Selected Channels To 64 bit Precision."
		label lbl_MemoryUsed "" offset:[0,-184] align:#right
	)

	button btn_ChannelAdd ">" height:40 align:#center width:20 offset:[0,-155] tooltip:"Move the Selected Channels to the 'Save Channels' list."
	button btn_ChannelRemove "<" height:40 align:#center offset:[0,-3] width:20 tooltip:"Move the Selected Channels to the 'Do Not Save Channels' list."


	label lbl_KrakatoaMemoryUsed "" pos:[400,35] 

	fn calculateMemoryUsage theChannels =
	(
		local  totalBytes = 0
		for channel in theChannels do 
		(
			local theBytes = 0
			case channel[2] of 
			(
				"float16" : theBytes = 2
				"float32" : theBytes = 4
				"float64" : theBytes = 8
				"int8" : theBytes = 1
				"int16" : theBytes = 2
				"int32" : theBytes = 4
				"int64" : theBytes = 8
				"uint8" : theBytes = 1
				"uint16" : theBytes = 2
				"uint32" : theBytes = 4
				"uint64" : theBytes = 8
				default : ()
			)
			totalBytes += (theBytes * channel[3] )
		)
		--totalBytes += 8 - mod totalBytes 8
		totalBytes
	)
	
	on spn_particleCount changed val do
	(
		spn_MemoryUsage.value = ((calculateMemoryUsage activeMemChannels) * val * 1000000) / 1024^2
		FranticParticles.SetProperty "ParticleCountMemoryCalculator:Count" (val as string)
	)
	
	on spn_MemoryUsage changed val do
	(
		spn_particleCount.value = (val*1024.0*1024.0 / (calculateMemoryUsage activeMemChannels)) * 0.000001
	)
	
	
	fn updateMemChannels = 
	(
		inactiveMemChannels = #()	
		activeMemChannels = #()
--			activeMemChannelsNames = for i in FranticParticles.getRenderParticleChannels() collect i[1]
	
		append activeMemChannels #("Position","float32",3)
		
		if FranticParticles.getBoolProperty "EnableMotionBlur" then 
			append activeMemChannels #("Velocity", FranticParticles.getProperty "Memory:Channel:Velocity", 3)
		else	
			append inactiveMemChannels #("Velocity", FranticParticles.getProperty "Memory:Channel:Velocity", 3)

		if FranticParticles.getBoolProperty "UseGlobalColorOverride" and FranticParticles.getProperty "ParticleColorSource" == "Choose Color" then 
			append inactiveMemChannels #("Color",FranticParticles.getProperty "Memory:Channel:Color",3)
		else
			append activeMemChannels #("Color",FranticParticles.getProperty "Memory:Channel:Color",3)
		
		append activeMemChannels #("Density",FranticParticles.getProperty "Memory:Channel:Density",1)
			
		if FranticParticles.getBoolProperty "UseLighting" then 
			append activeMemChannels #("Lighting", FranticParticles.getProperty "Memory:Channel:Lighting", 3)
		else	
			append inactiveMemChannels #("Lighting", FranticParticles.getProperty "Memory:Channel:Lighting", 3)

		if (FranticParticles.GetBoolProperty "UseEnvironmentReflections") OR (matchPattern (FranticParticles.getProperty "PhaseFunction") pattern:"*Surface*" and FranticParticles.getBoolProperty "UseLighting") then 
			append activeMemChannels #("Normal", FranticParticles.getProperty "Memory:Channel:Normal", 3)
		else	
			append inactiveMemChannels #("Normal", FranticParticles.getProperty "Memory:Channel:Normal", 3)

		if (matchPattern (FranticParticles.getProperty "PhaseFunction") pattern:"*Ward*" and FranticParticles.getBoolProperty "UseLighting") then 
			append activeMemChannels #("Tangent", FranticParticles.getProperty "Memory:Channel:Tangent", 3)
		else	
			append inactiveMemChannels #("Tangent", FranticParticles.getProperty "Memory:Channel:Tangent", 3)

		
		if FranticParticles.getBoolProperty "EnableMotionBlur" and FranticParticles.getBoolProperty "JitteredMotionBlur" then 
			append activeMemChannels #("MBlurTime", FranticParticles.getProperty "Memory:Channel:MBlurTime", 1)
		else	
			append inactiveMemChannels #("MBlurTime", FranticParticles.getProperty "Memory:Channel:MBlurTime", 1)


		
		Krakatoa_GUI_Main.IsCacheValid()
		lbx_allMemoryChannels.items = for i in inactiveMemChannels collect 
		(
			local isCached = if FranticParticles.getCacheSize() == 0.0 then "-- " else
				if findItem Krakatoa_GUI_Main.theCachedChannelsArray i[1] > 0 then "+ " else "-- "
			if i[3] == 1 then
				(isCached + i[1] + "  :  " + i[2] )
			else
				(isCached + i[1] + "  :  " + i[2] + "[" + i[3] as string  + "]")
		)

		lbx_activeMemoryChannels.items = for i in activeMemChannels collect 
		(
			local isCached = if FranticParticles.getCacheSize() == 0.0 then "-- " else
				if findItem Krakatoa_GUI_Main.theCachedChannelsArray i[1] > 0 then "+ " else "-- "
			if i[3] == 1 then
				(isCached + i[1] + "  :  " + i[2])
			else
				(isCached + i[1] + "  :  " + i[2] + "[" + i[3] as string + "]")
		)
		MemoryBytesPerParticle = (calculateMemoryUsage activeMemChannels )		
		lbl_KrakatoaMemoryUsed.text = "Bytes/Particle:"+ MemoryBytesPerParticle as string
		spn_particleCount.changed spn_particleCount.value
		
		local theCount = try((FranticParticles.GetCachedParticleCount()) )catch(0)
		local theMemory = try((FranticParticles.getCacheSize()) )catch(0)
		lbl_currentCache.text = "Currently In Cache: " + FranticParticleRenderMXS.addCommas (theCount as string) + " Particles Using " + theMemory as string+ " MB Memory."
	)

	
	fn getAllChannels =
	(
		allPossibleChannels = #(
			#("Position", "float32", 3),
			#("Acceleration", "float32", 3),
			#("ID", "int32", 1),
			#("Age", "int32", 1),
			#("Color", "float32", 3),
			#("Density", "float32", 1),
			#("MaterialIndex","int32", 1),
			#("MXSInteger", "int32", 1),
			#("MXSFloat", "float32", 1),
			#("MXSVector", "float32", 3),
			#("Normal", "float32", 3),
			#("Tangent", "float32", 3),
			#("Orientation", "float32", 4),
			#("Scale", "float32", 3),
			#("TextureCoord", "float32", 3),
			#("Velocity", "float32", 3),
			#("Lighting", "float32", 3),
			#("Fuel", "float32", 1),
			#("Temperature", "float32", 1)
		)
		if ckb_showMappingChannels.checked do
			for i = 2 to 99 do append allPossibleChannels #("Mapping"+i as string, "float32", 3)
	)	

	fn populateLists =
	(
		getAllChannels()
		local activeChannelsSettings = FranticParticles.getProperty "ActiveParticleChannels"
--			local inactiveChannelsSettings = FranticParticles.getProperty "InactiveParticleChannels"
		theFS = filterString activeChannelsSettings ","
		activeChannels = #()
		for i = 1 to theFS.count by 3 do 
			append activeChannels #(theFS[i], theFS[i+1],theFS[i+2] as integer )

/*
		theFS = filterString inactiveChannelsSettings ","
		inactiveChannels = #()
		for i = 1 to theFS.count by 3 do 
			append inactiveChannels #(theFS[i], theFS[i+1],theFS[i+2] as integer)
*/			

		local activeNames = for i in activeChannels collect i[1]
		inactiveChannels = for i in allPossibleChannels where findItem activeNames i[1] == 0 collect i
		lbx_allChannels.items = for i in inactiveChannels collect 
			if i[3] == 1 then
				(i[1] + "  :  " + i[2] )
			else
				(i[1] + "  :  " + i[2] + "[" + i[3] as string  + "]")
		
		lbx_activeChannels.items = for i in activeChannels collect 
			if i[3] == 1 then
				(i[1] + "  :  " + i[2] )
			else
				(i[1] + "  :  " + i[2] + "[" + i[3] as string + "]")
		lbl_MemoryUsed.text = "Bytes/Particle:"+ (calculateMemoryUsage activeChannels) as string
	)
	
	on ckb_showMappingChannels changed state do populateLists()
	
	fn storeActiveChannels =
	(
		local thePropValue = ""
		for i in activeChannels do thePropValue += i[1] + "," + i[2] + "," + i[3] as string + ","
		if activeChannels.count > 0 do thePropValue = substring thePropValue 1 (thePropValue.count-1)
		FranticParticles.setProperty "ActiveParticleChannels" thePropValue
		
		/*
		local thePropValue = ""
		for i in inactiveChannels do thePropValue += i[1] + "," + i[2] + "," + i[3] as string + ","
		if inactiveChannels.count > 0 do thePropValue = substring thePropValue 1 (thePropValue.count-1)
		FranticParticles.setProperty "InactiveParticleChannels" thePropValue
		*/
	)
	
	fn addChannel =
	(
		local theArray = lbx_allChannels.selection as array
		local toSelect = for i in lbx_activeChannels.selection collect activeChannels[i][1]
		local newSelection = #{} 
		
		for j = theArray.count to 1 by -1 do
		(
			theIndex = theArray[j]
			append activeChannels inactiveChannels[theIndex]
			append toSelect inactiveChannels[theIndex][1]
			deleteItem inactiveChannels theIndex
			--local theNames = for i in inactiveChannels collect i[1]
			--activeChannels = for i in allChannels where findItem theNames i[1] == 0 collect i
		)		
		storeActiveChannels()
		populateLists()
		for j in toSelect do 
			for i = 1 to activeChannels.count where activeChannels[i][1] == j do append newSelection i
		lbx_activeChannels.selection = newSelection 
		lbx_allChannels.selection = #{}
	)
	
	fn removeChannel = 
	(
		local theArray = lbx_activeChannels.selection as array
		local toSelect = for i in lbx_allChannels.selection collect inactiveChannels[i][1]
		local newSelection = #{} 
		for j = theArray.count to 1 by -1 do
		(
			local theIndex = theArray[j]
			if not activeChannels[theIndex][1] == "Position" do
			(
				append inactiveChannels activeChannels[theIndex]
				append toSelect activeChannels[theIndex][1]
				deleteItem activeChannels theIndex
			)	
		)		
		storeActiveChannels()
		populateLists()
		for j in toSelect do 
			for i = 1 to inactiveChannels.count where inactiveChannels[i][1] == j do append newSelection i
		lbx_allChannels.selection = newSelection
		lbx_activeChannels.selection = #{}
	)
	
	fn updateChannels =
	(
		local firstBirth = FranticParticleRenderMXS.GetEarliestBirthFrame()
		local result = #ok
		if sliderTime > firstBirth then 
		(
			local str = "3ds Max is going to refresh the particle sources for Krakatoa to get all channels.\n"
				str += "This may take some time and could be faster if you would change the time slider to frame " + (firstBirth as string) + "\n\n"
				str += "Press [Yes] to change to frame "+ (firstBirth as string) +" and scan for channels.\n"
				str += "Press [No] to continue scanning for channels on the current frame.\n"
				str += "Press [Cancel] to cancel the scan for channels.\n"
			result = yesNoCancelBox str title:"WARNING!"
			if result == #yes then sliderTime = firstBirth
		)	
		if result != #cancel do
		(
			try (
				local allChannels = FranticParticles.GetSceneChannels()
				allNames = for i in activeChannels collect i[1]
				inactiveChannels = for i in allChannels where findItem allNames i[1] == 0 collect i
				storeActiveChannels()
				populateLists()
			)
			catch 
			(
				messageBox (getCurrentException()) title:"Krakatoa Error" 
			)			
		)	
	)
	
	fn changeMemoryChannelTo type =
	(
		for i in lbx_activeMemoryChannels.selection do
		(
			if matchpattern activeMemChannels[i][1] pattern:"Color*" do FranticParticles.setProperty "Memory:Channel:Color" type 
			if matchpattern activeMemChannels[i][1] pattern:"Density*" do FranticParticles.setProperty "Memory:Channel:Density" type 
			if matchpattern activeMemChannels[i][1] pattern:"Velocity*" do FranticParticles.setProperty "Memory:Channel:Velocity" type 
			if matchpattern activeMemChannels[i][1] pattern:"Lighting*" do FranticParticles.setProperty "Memory:Channel:Lighting" type 
			if matchpattern activeMemChannels[i][1] pattern:"Normal*" do FranticParticles.setProperty "Memory:Channel:Normal" type 
			if matchpattern activeMemChannels[i][1] pattern:"Tangent*" do FranticParticles.setProperty "Memory:Channel:Tangent" type 
			if matchpattern activeMemChannels[i][1] pattern:"MBlurTime*" do FranticParticles.setProperty "Memory:Channel:MBlurTime" type 
		)
		for i in lbx_allMemoryChannels.selection do
		(
			if matchpattern inactiveMemChannels[i][1] pattern:"Color*" do FranticParticles.setProperty "Memory:Channel:Color" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"Density*" do FranticParticles.setProperty "Memory:Channel:Density" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"Velocity*" do FranticParticles.setProperty "Memory:Channel:Velocity" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"Lighting*" do FranticParticles.setProperty "Memory:Channel:Lighting" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"Normal*" do FranticParticles.setProperty "Memory:Channel:Normal" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"Tangent*" do FranticParticles.setProperty "Memory:Channel:Tangent" type 
			if matchpattern inactiveMemChannels[i][1] pattern:"MBlurTime*" do FranticParticles.setProperty "Memory:Channel:MBlurTime" type 
		)
		updateMemChannels()		
	)
	
	fn createPresetsRCMenu type:#memory =
	(
		case type of
		(
			#memory : (
						presetName = "ParticleCountCalculator"
						theSpinner = "spn_MemoryUsage"
					)	
			#count: (
						presetName = "MemoryCalculator"
						theSpinner = "spn_ParticleCount"
					)	
		)
		local presetsList = #()
		local theKeys = for i in (getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName  ) collect (execute i)
		sort theKeys 
		if theKeys.count == 0 then 
		(
			theKeys = case type of
			(
				#memory: #(1024,2048,4096,8192,16384,32768,65536,131072)
				#count: #(1.0,10.0,50.0,100.0,200.0,500.0,1000.0)
			)
			for i in theKeys do
				setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName (i as string) (i as string)
		)
		for k in theKeys do
			if findItem presetsList theValue == 0 do append presetsList k

		theValue = execute ("Krakatoa_GUI_Channels."+ theSpinner +".value")
		local txt = "rcmenu Presets_RCMenu\n(\n"
		
		if findItem presetsList theValue == 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add "+ theValue as string+"\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ theValue as string +"\" \""+ theValue as string +"\" \n"
			txt += "separator spr_01\n" 
		)	
		
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i as string + "\" \n" 
			txt += "on mnu_preset" + cnt as string + " picked do Krakatoa_GUI_Channels."+ theSpinner +".changed (Krakatoa_GUI_Channels."+ theSpinner +".value = "+ i as string +")\n"
		)
		
		if findItem presetsList theValue != 0 do 
		(
			txt += "separator spr_01\n" 
			txt += "menuItem mnu_RemovePreset \"Remove "+ theValue as string+"\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName +"\" \""+ theValue as string +"\" \n"
		)	
		txt += ")\n"
		Krakatoa_RCMenu_Struct.Presets_RCMenu = execute txt
	)

	on btn_countPresets pressed do 
	(
		createPresetsRCMenu type:#count 
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)	
	on btn_countPresets rightClick do 
	(
		createPresetsRCMenu type:#count 
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos			
	)
	on btn_memoryPresets pressed do 
	(
		createPresetsRCMenu type:#memory 
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos			
	)	
	on btn_memoryPresets rightClick do 		
	(
		createPresetsRCMenu type:#memory 
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)
	
	on btn_memmake16 pressed do changeMemoryChannelTo "float16"
	on btn_memmake32 pressed do changeMemoryChannelTo "float32"
	on btn_memmake64 pressed do changeMemoryChannelTo "float64"
	
	on btn_ChannelAdd pressed do addChannel()
	on btn_ChannelRemove pressed do removeChannel()
	on btn_ChannelUpdate pressed do updateChannels()
	on lbx_allChannels doubleClicked itm do addChannel()
	on lbx_activeChannels doubleClicked itm do removeChannel()
	
	on btn_allAll pressed do lbx_allChannels.selection = #{1..lbx_allChannels.items.count}
	on btn_allInvert pressed do lbx_allChannels.selection = #{1..lbx_allChannels.items.count} - lbx_allChannels.selection

	on btn_activeAll pressed do lbx_activeChannels.selection = #{1..lbx_activeChannels.items.count}
	on btn_activeInvert pressed do lbx_activeChannels.selection = #{1..lbx_activeChannels.items.count} - lbx_activeChannels.selection
	
	on btn_make16 pressed do 
	(
		for i in lbx_activeChannels.selection where not matchPattern activeChannels[i][1] pattern:"Position" do
		(
			if matchpattern activeChannels[i][2] pattern:"float*" do activeChannels[i][2] = "float16"
			if matchpattern activeChannels[i][2] pattern:"int*" do activeChannels[i][2] = "int16"
			if matchpattern activeChannels[i][2] pattern:"uint*" do activeChannels[i][2] = "uint16"
		)
		storeActiveChannels()
		populateLists()			
	)
	on btn_make32 pressed do 
	(
		for i in lbx_activeChannels.selection do
		(
			if matchpattern activeChannels[i][2] pattern:"float*" do activeChannels[i][2] = "float32"
			if matchpattern activeChannels[i][2] pattern:"int*" do activeChannels[i][2] = "int32"
			if matchpattern activeChannels[i][2] pattern:"uint*" do activeChannels[i][2] = "uint32"
		)
		storeActiveChannels()
		populateLists()			
	)	
	on btn_make64 pressed do 
	(
		for i in lbx_activeChannels.selection where not matchPattern activeChannels[i][1] pattern:"Position" do
		(
			if matchpattern activeChannels[i][2] pattern:"float*" do activeChannels[i][2] = "float64"
			if matchpattern activeChannels[i][2] pattern:"int*" do activeChannels[i][2] = "int64"
			if matchpattern activeChannels[i][2] pattern:"uint*" do activeChannels[i][2] = "uint64"
		)
		storeActiveChannels()
		populateLists()			
	)	

	fn refresh_GUI =
	(
		Krakatoa_GUI_Channels.open = FranticParticles.GetBoolProperty "GUI:ParticleChannelsRolloutOpen"
		spn_particleCount.value = execute (FranticParticles.GetProperty "ParticleCountMemoryCalculator:Count")
		getAllChannels()
		--updateChannels()
		populateLists()	
		updateMemChannels()
	)

	on Krakatoa_GUI_Channels close do 
	(
		if Krakatoa_GUI_Channels.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Channels.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Channels open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Channels.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Channels Rollout OPENED.")			
	)			
	
	on Krakatoa_GUI_Channels rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ParticleChannelsRolloutOpen" val		
		if val then 
			FranticParticles.LogDebug ("+Particle Channels Rollout ROLLED DOWN.")
		else
			FranticParticles.LogDebug ("+Particle Channels Rollout ROLLED UP.")	
	)			
)




--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--THINKING PARTICLES ROLLOUT
--------------------------------------------------------------------------------------	

rollout Krakatoa_GUI_ThinkingParticles "Thinking Particles Groups" category:70 width:457
(
	local InactiveTPGroups = #()
	local ActiveTPGroups = #()

	button btn_LoadSave_TP "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_TP  "Open Krakatoa Online Help..." width:408 height:14 align:#center offset:[0,-5] 
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_LoadSave_TP pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_ThinkingParticles
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_TP rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_ThinkingParticles
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)		
	
	on btn_Help_TP pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/thinking_particles_groups.php" ""	 	
		
	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_ThinkingParticles
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_ThinkingParticles
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)		

	on Krakatoa_GUI_ThinkingParticles moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_ThinkingParticles.title (pos as string)
	)			

	multilistbox lbx_inactiveGroups " Non-Renderable TP Groups:" items:#() height:20 across:2 width:204 align:#left
	multilistbox lbx_allGroups " Renderable TP Groups:"  items:#() height:20 width:205 align:#right
	
	button btn_TPGroupsUpdate "Update TP Groups Lists" align:#left offset:[0,-3] width:120 across:6 tooltip:"Scan Scene For Thinking Particles Groups..."
	button btn_inactiveAll "All" width:40 alignt:#left offset:[34,-3] tooltip:"Select All Inactive Groups."
	button btn_inactiveInvert "Invert" width:40 alignt:#left offset:[5,-3] tooltip:"Invert Inactive Groups Selection."

	button btn_allAll "All" width:40 alignt:#right offset:[-3,-3] tooltip:"Select All Active Groups."
	button btn_allInvert "Invert" width:40 alignt:#right offset:[-32,-3] tooltip:"Invert Active Groups." 
	checkbutton chk_showFullHierarchy ">Show Full Hierarchy" align:#right offset:[3,-3] width:120 across:6 tooltip:"Expand the Hierarchy to show all Parent Groups." highlightcolor:KrakatoaSkinColorsStruct.Thinking

	label lbl_tpwarning ""
	button btn_GroupAdd ">" height:40 align:#center width:20 offset:[0,-225] tooltip:"Move the highlighted Channel to the Active list."
	button btn_GroupRemove "<" height:40 align:#center offset:[0,-3] width:20 tooltip:"Remove the highlighted Channel from the Active list."



	fn getSubGroups theMaster theBase theParent =
	(
		for g in getPropNames theParent where try( (classof (getProperty theParent g)) == PGroup ) catch(false)  do
		(
			local theNewBase = if chk_showFullHierarchy.checked then (theBase + "." + (g as string)) else (theBase + ".")
			if try(getProperty (getProperty theParent g) #Renderable)catch(true) then 
				append ActiveTPGroups #((getProperty theParent g), theMaster.name + theBase + "." + (g as string))
			else	
				append inactiveTPGroups #((getProperty theParent g), theMaster.name + theBase + "." + (g as string))
			getSubGroups theMaster theNewBase (getProperty theParent g)
		)
	)

	fn populateLists =
	(
		ActiveTPGroups = #() 
		inactiveTPGroups = #()
		lbl_tpwarning.text = ""
		local theTPObjects = for o in objects where classof o == Thinking collect o
		if theTPObjects.count > 0 then
		(
			local TPRolloutEnabled = try(hasProperty theTPObjects[1].GroupManager "Renderable")catch(false)
			lbx_allGroups.enabled = lbx_inactiveGroups.enabled = btn_GroupAdd.enabled = btn_GroupRemove.enabled = TPRolloutEnabled 
			btn_TPGroupsUpdate.enabled = btn_inactiveAll.enabled = btn_inactiveInvert.enabled = btn_allAll.enabled = btn_allInvert.enabled = chk_showFullHierarchy.enabled = TPRolloutEnabled 
			if not TPRolloutEnabled do lbl_tpwarning.text = "WARNING: Thinking Particles 3.0 or higher required to access Groups Renderable state."
			for o in theTPObjects do
			(
				if try(getProperty o.GroupManager #Renderable)catch(true) then --assume true if TP 2.5 which does not have #Renderable property
					append ActiveTPGroups #(o.GroupManager, o.name + ".All")
				else	
					append InactiveTPGroups #(o.GroupManager, o.name + ".All")
				theBase = if chk_showFullHierarchy.checked then ".All" else ""
				getSubGroups o theBase o.GroupManager
			)
		)
		lbx_allGroups.items = for i in ActiveTPGroups collect i[2] 
		lbx_inactiveGroups.items = for i in InactiveTPGroups collect i[2] 
	)	

	fn addGroups =
	(
		local theSel = lbx_inactiveGroups.selection as array
		for i = theSel.count to 1 by -1 do
			try(setProperty InactiveTPGroups[theSel[i]][1] #Renderable true)catch()
		populateLists()			
	)
	
	fn removeGroups =
	(
		local theSel = lbx_allGroups.selection as array
		for i = theSel.count to 1 by -1 do
			try(setProperty activeTPGroups[theSel[i]][1] #Renderable false)catch()
		populateLists()	
	)
	
	fn registerCallbacks =
	(
		FranticParticles.LogDebug ">Registering Callbacks..."
		local theTP = for o in objects where classof o == Thinking collect o
		deleteAllChangeHandlers id:#KrakatoaTPMonitor 
		if theTP.count > 0 do 
			when parameters theTP change id:#KrakatoaTPMonitor do populateLists()
	)
	fn unregisterCallbacks =
	(
		FranticParticles.LogDebug ">Unregistering Callbacks..."
		deleteAllChangeHandlers id:#KrakatoaTPMonitor 
	)		
	
	on btn_GroupAdd pressed do addGroups()
	on btn_GroupRemove pressed do removeGroups() 

	on lbx_allGroups doubleClicked itm do removeGroups()
	on lbx_inactiveGroups doubleClicked itm do addGroups()
	
	on btn_allAll pressed do lbx_allGroups.selection = #{1..lbx_allGroups.items.count}
	on btn_allInvert pressed do lbx_allGroups.selection = #{1..lbx_allGroups.items.count} - lbx_allGroups.selection

	on btn_inactiveAll pressed do lbx_inactiveGroups.selection = #{1..lbx_inactiveGroups.items.count}
	on btn_inactiveInvert pressed do lbx_inactiveGroups.selection = #{1..lbx_inactiveGroups.items.count} - lbx_inactiveGroups.selection
	
	on chk_showFullHierarchy changed state do populateLists()	


	fn refresh_GUI =
	(
		Krakatoa_GUI_ThinkingParticles.open = FranticParticles.GetBoolProperty "GUI:ThinkingParticlesRolloutOpen"
		if Krakatoa_GUI_ThinkingParticles.open do registerCallbacks()
		populateLists()
	)		
	
	on btn_TPGroupsUpdate pressed do 
	(
		registerCallbacks()
		populateLists()
	)	


	on Krakatoa_GUI_ThinkingParticles close do 
	(
		if Krakatoa_GUI_ThinkingParticles.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_ThinkingParticles.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_ThinkingParticles open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_ThinkingParticles.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Thinking Particles Rollout OPENED.")			
	)	
	
	on Krakatoa_GUI_ThinkingParticles rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ThinkingParticlesRolloutOpen" val		
		if val then 
		(
			FranticParticles.LogDebug ("+Thinking Particles Rollout ROLLED DOWN.")
			registerCallbacks()
			populateLists()
		)	
		else
		(
			FranticParticles.LogDebug ("+Thinking Particles Rollout ROLLED UP.")	
			unregisterCallbacks()
		)	
	)			
)

/*
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--RENDER TARGET ROLLOUT	(ALPHA FEATURES, NOT FOR COMMERCIAL USE YET)
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
Krakatoa_GUI_Target = undefined
if alphaFeatureControls do (
	rollout Krakatoa_GUI_Target "Render Target"
	(	
		label lbl_renderTarget "Render Target: " offset:[15,3] across:2 align:#left
		dropdownlist ddl_renderTarget items:#("Direct Render","Save To XML") offset:[-120,0] width:220 align:#left

		group "XML Files"
		(
			edittext edt_xmlOutputPaths "" fieldwidth:404 align:#left offset:[-3,0] across:2
			button btn_pickXMLOutputFiles "..." align:#right width:20 height:20 offset:[0,-2]
		)	

		group "Deadline Settings" (
			button btn_openDeadlineSubmitter "Edit Settings" align:#left width:135 height:30 across:3
			button btn_submitXMLToCommandLine "Submit XML" align:#left width:135 height:30 offset:[-4,0]
			button btn_generateAndSubmitXMLToCommandLine "Generate and Submit XML" align:#right width:150 height:30
		)

		fn refresh_GUI = 
		(
			try(Krakatoa_GUI_Target.open = FranticParticles.GetBoolProperty "GUI:RenderTargetRolloutOpen")catch()
		
			FranticParticleRenderMXS.SetDropDownValue ddl_renderTarget (FranticParticles.GetProperty "RenderTarget")
			local enableXmlSaveControls = false
			if (FranticParticles.GetProperty "RenderTarget") == "Save To XML" do (
				enableXmlSaveControls = true
			)
			edt_xmlOutputPaths.enabled = enableXmlSaveControls
			btn_pickXMLOutputFiles.enabled = enableXmlSaveControls
			edt_xmlOutputPaths.text = FranticParticles.GetProperty "XMLOutputFiles"

			btn_openDeadlineSubmitter.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableXmlSaveControls
			btn_submitXMLToCommandLine.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableXmlSaveControls
			btn_generateAndSubmitXMLToCommandLine.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableXmlSaveControls
			
		)
		on Krakatoa_GUI_Target rolledUp val do 
		(
			FranticParticles.SetProperty "GUI:RenderTargetRolloutOpen" val			
			if val then 
				FranticParticles.LogDebug ("+Render Target Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Render Target Rollout ROLLED UP.")		
		)				
		
		fn CreateJobInfoFile filename =
		(
			local JobInfoFile = CreateFile filename
			if (JobInfoFile != undefined) then
			(
				format "RenderFilenamePrefix=%\n" (XMLSceneUtils.FilenameWithoutNumberAndExtension (FranticParticles.GetProperty "XMLOutputFiles")) to:jobInfoFile 
				format "RenderFilenameExt=%\n" (getFilenameType (FranticParticles.GetProperty "XMLOutputFiles")) to:jobInfoFile 
				
				Close JobInfoFile
				true
			)
			else
				false			
		)
		
		fn SubmitXMLToDeadline = (
			local imageOutput = FranticParticles.ReplaceSequenceNumberWithHashes FranticParticles.RenderOutputFiles
			SMTDFunctions.CreateSubmitInfoFile SMTDPaths.SubmitInfofile customPlugin:"FranticParticleRender" customOutputFile:imageOutput
			CreateJobInfoFile SMTDPaths.JobInfofile

			local initialArgs = ""
			if SMTDSettings.bgSubmission do initialArgs += "-background -notify "
			if SMTDSettings.dropSubmission do initialArgs += "-drop "
				
			initialArgs += "\"" +SMTDPaths.SubmitInfofile + "\" \"" + SMTDPaths.JobInfofile + "\" "
			SMTDFunctions.waitForCommandToComplete ( initialArgs ) 60
			-- edit SMTDPaths.SubmitInfofile
		)

		fn ddl_renderTarget_SelectedFN val = 
		(
			FranticParticles.SetProperty "RenderTarget" ddl_renderTarget.text
			refresh_GUI()
		)
		on ddl_renderTarget selected val do ddl_renderTarget_SelectedFN val
		
		on edt_xmlOutputPaths changed val do FranticParticles.SetProperty "XMLOutputFiles" val
		on btn_pickXMLOutputFiles pressed do (
			local newXMLOutputFiles
			newXMLOutputFiles= getSaveFileName caption:"Select the XML Output Sequence to Save" filename:(FranticParticles.GetProperty "XMLOutputFiles") types:"XML Files (*.xml)|*.xml|All(*.*)|*.*" history:"KrakatoaXML"
			if newXMLOutputFiles != undefined do (
				FranticParticles.SetProperty "XMLOutputFiles" newXMLOutputFiles
				refresh_GUI()
			)
		)
		
		on btn_openDeadlineSubmitter pressed do (
			try(macros.run "Deadline" "SubmitMaxToDeadline2")catch()
		)
		
		on btn_submitXMLToCommandLine pressed do (
			SubmitXMLToDeadline()
		)
		
		on btn_generateAndSubmitXMLToCommandLine pressed do (
			max quick render
			SubmitXMLToDeadline()
		)

		on Krakatoa_GUI_Target open do refresh_GUI()
	)--end rollout
) -- alphaFeatureControls
*/	

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PARTICLE SYSTEMS ROLLOUT
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	

rollout Krakatoa_GUI_Particles "Scene Particle Systems" category:50 width:457
(
	local KrakatoaParticleSystemsList = #()
	
	button btn_Help_Systems  "Open Krakatoa Online Help..." width:430 height:14 align:#left offset:[-10,-5] across:2
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	on btn_Help_Systems pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/particle_systems.php" ""		

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Particles
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Particles
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)			

	on Krakatoa_GUI_Particles moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Particles.title (pos as string)
	)	
	
	checkbutton chb_synchSelections ">Synch. Selection" width:150 offset:[-8,0] align:#left checked:true highlightcolor:KrakatoaSkinColorsStruct.Systems across:3
	dropdownlist ddl_displayInfo items:#("None","Particle Flow Systems","Geometry Vertices","Legacy Particles","Thinking Particles","FumeFX Simulations","GeoVolumes","All Sources") width:142 align:#center offset:[2,0]
	checkbutton chb_showEnabledOnly ">Show Only Enabled Types" width:150 align:#right highlightcolor:KrakatoaSkinColorsStruct.Systems offset:[10,0]
	
	multilistbox lbx_particleSystemsInScene height:20 width:450 align:#center offset:[0,-3]
	
	button btn_selectAll "Select All Sources" width:140 align:#left across:3 offset:[0,-3]
	button btn_deselectAll "Deselect All Sources" width:140 align:#center offset:[0,-3]
	button btn_selectInvert "Invert Sources Selection" width:140 align:#right offset:[0,-3]
	
	button btn_hideSelected "Hide Selected Sources" width:140 align:#left across:3 offset:[0,-3]
	button btn_unhideSelected "Unhide Selected Sources" width:140 align:#center offset:[0,-3]
	button btn_selectHidden "Select Hidden Sources" width:140 align:#right offset:[0,-3]

	

	fn registerSelectionCallback =
	(
		 callbacks.addScript #selectionSetChanged "Krakatoa_GUI_Particles.synchSelectionFromScene()" id:#Krakatoa_ParticlesSelectionMonitor
	)
	
	fn registerSceneNodeCallbacks =
	(
		 callbacks.addScript #nodePostDelete "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
		 callbacks.addScript #nodeCreated "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
		 callbacks.addScript #nodeRenamed "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
		 callbacks.addScript #nodeHide "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
		 callbacks.addScript #nodeUnhide "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
		 if (maxVersion())[1] >=8000 do callbacks.addScript #sceneUndo "Krakatoa_GUI_Particles.nodesChanged()" id:#Krakatoa_ParticlesCreationDeletionMonitor
	)
	
	fn registerWhenConstructMonitor =
	(
		deleteAllChangeHandlers id:#Krakatoa_ParticlesParametersMonitor
		theBOs = for o in KrakatoaParticleSystemsList collect o.baseobject --we have to monitor just the base objects to avoid updates on node PRS changes!
		when parameters theBOs change id:#Krakatoa_ParticlesParametersMonitor do Krakatoa_GUI_Particles.nodesChanged()
	)
	
	fn synchSelectionToScene =
	(
		callbacks.removeScripts id:#Krakatoa_ParticlesSelectionMonitor
		max select none
		select (for i in lbx_particleSystemsInScene.selection where isValidNode KrakatoaParticleSystemsList[i] collect KrakatoaParticleSystemsList[i])
		registerSelectionCallback()
	)
	
	fn synchSelectionFromScene =
	(
		lbx_particleSystemsInScene.selection = (for o in selection where findItem KrakatoaParticleSystemsList o > 0 collect findItem KrakatoaParticleSystemsList o) as bitarray
	)
	
	

	fn updateParticlesList =
	(
		if Krakatoa_GUI_Particles.open do
		(
			local st = timestamp()
			FranticParticles.logDebug (">Populating Particle Systems List with " + ddl_displayInfo.selected )
			local legacyParticles = #(PArray, PCloud, SuperSpray, Blizzard, Snow, Spray)
			local theSystems = #()
			KrakatoaParticleSystemsList = #()
			local KrakatoaParticleSystemsText = #()
			
			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 2 do
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderParticleFlowGeometry" or FranticParticles.GetBoolProperty "RenderParticleFlowBBox" or FranticParticles.GetBoolProperty "RenderParticleFlowPhantom" do
				(
					theSystems = (for o in objects where classof o == PF_Source collect o)
					join KrakatoaParticleSystemsList theSystems
					for o in theSystems do 
					(
						hiddenFlag = if o.isHiddenInVpt then "--" else "+"
						actualAmount = requestedAmount = (o.numParticles() / o.Quantity_Viewport * o.Quantity_Render) as integer
						if requestedAmount > o.Particle_Amount_Limit do actualAmount = o.Particle_Amount_Limit
						append KrakatoaParticleSystemsText (hiddenFlag + "["+o.name+"] - <PF Source> - Req.:" + FranticParticleRenderMXS.addCommas (requestedAmount as string) + "  Limit:" + FranticParticleRenderMXS.addCommas (o.Particle_Amount_Limit as string) + "  Actual:" + FranticParticleRenderMXS.addCommas (actualAmount as string))
					)	
				)	
			)	
			
			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 3 do	
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderGeometryVertices" do
				(
					local useNamedSelectionSets = execute (FranticParticles.GetProperty "Matte:NamedSelectionSets")
					local matteSelSets = for i = 1 to selectionSets.count where findItem useNamedSelectionSets (getNamedSelSetName i) != 0 collect selectionSets[i]
					local matteObjects = #()
					for i in matteSelSets do 
						join matteObjects (for o in i collect o)
					
					theSystems = (for o in objects where findItem GeometryClass.classes (classof o) > 0 AND classof o != TargetObject AND classof o != Thinking AND classof o != ParticleGroup AND o.renderable AND findItem KrakatoaParticleSystemsList o == 0 AND findItem legacyParticles (classof o) == 0 AND classof o != PF_Source AND findItem matteObjects o == 0 and classof o != KrakatoaPrtLoader AND not FranticParticleRenderMXS.isGeoVolume o collect o)
					join KrakatoaParticleSystemsList theSystems 
					for o in theSystems do 
					(
						theMeshCount = getTrimeshFaceCount o
						hiddenFlag = if o.isHiddenInVpt then "--" else "+"
						append KrakatoaParticleSystemsText (hiddenFlag + "["+o.name+"] - <"+ (classof o) as string +"> - Vertices:" + FranticParticleRenderMXS.addCommas ( theMeshCount[2] as string) )
					)	
				)
			)	
			
			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 4 do
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderMaxParticles" do	
				(
					theSystems = (for o in objects where findItem legacyParticles (classof o) > 0 collect o)
					join KrakatoaParticleSystemsList theSystems 
					for o in theSystems do 
					(
						hiddenFlag = if o.isHiddenInVpt then "--" else "+"
						theVCount = particleCount o
						if isProperty o "viewPercent" then theVCount *= 100.0 / o.viewPercent 
						theVCount = (floor (theVCount+0.5)) as integer
						append KrakatoaParticleSystemsText (hiddenFlag + "["+o.name+"] - <3ds Max Legacy Particles> - Particles:" +  FranticParticleRenderMXS.addCommas (theVCount as string) )
					)	
				)
			)

			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 5 do
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderThinkingParticles" do
				(
					theSystems = (for o in objects where classof o == Thinking collect o)
					join KrakatoaParticleSystemsList theSystems
					for o in theSystems do 
					(
						append KrakatoaParticleSystemsText ("+["+o.name+"] - <Thinking Particles Container> ")
					)	
				)	
			)	
			
			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 6 do			
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderFumeFX" do
				(
					theSystems = (for o in objects where classof o == FumeFX collect o) --((findItem KrakatoaParticleSystemsList o) == 0) AND classof o != PF_Source AND classof o != Thinking AND (try(o.ParticleObjectExt;true)catch(false)) AND classof o != ParticleGroup collect o)
					join KrakatoaParticleSystemsList theSystems 
					for o in theSystems do 
					(
						hiddenFlag = if o.isHiddenInVpt then "--" else "+"
						append KrakatoaParticleSystemsText (hiddenFlag + "["+o.name+"] - <FumeFX> ")
					)	
				)	
			)	
			
			if ddl_displayInfo.selection == 8 or ddl_displayInfo.selection == 7 do			
			(
				if not chb_showEnabledOnly.checked OR FranticParticles.GetBoolProperty "RenderGeometryVolumes" do
				(
					local useNamedSelectionSets = execute (FranticParticles.GetProperty "Matte:NamedSelectionSets")
					local matteSelSets = for i = 1 to selectionSets.count where findItem useNamedSelectionSets (getNamedSelSetName i) != 0 collect selectionSets[i]
					local matteObjects = #()
					for i in matteSelSets do 
						join matteObjects (for o in i collect o)
					
					theSystems = (for o in objects where findItem GeometryClass.classes (classof o) > 0 AND FranticParticleRenderMXS.isGeoVolume o AND classof o != TargetObject AND classof o != Thinking AND classof o != ParticleGroup AND o.renderable AND findItem KrakatoaParticleSystemsList o == 0 AND findItem legacyParticles (classof o) == 0 AND classof o != PF_Source AND findItem matteObjects o == 0 and classof o != KrakatoaPrtLoader collect o)
					join KrakatoaParticleSystemsList theSystems 
					for o in theSystems do 
					(
						local theCount= FranticParticleRenderMXS.getGeoVolumeEstimatedCount o
						local hiddenFlag = if o.isHiddenInVpt then "--" else "+"
						append KrakatoaParticleSystemsText (hiddenFlag + "["+o.name+"] - <GeoVolume> - Estimated:" + theCount )
					)	
				)	
			)				
			
			lbx_particleSystemsInScene.items = KrakatoaParticleSystemsText 
			if ddl_displayInfo.selection > 1 do FranticParticles.logDebug (" +Particle Systems List POPULATED in " + (timestamp() - st) as string + "ms." )
		)
	)
	
	fn nodesChanged =
	(
		if Krakatoa_GUI_Particles.open do
		(
			updateParticlesList()
			registerWhenConstructMonitor()
		)	
	)		
	
	on ddl_displayInfo selected itm do updateParticlesList()

	fn refresh_GUI =
	(
		updateParticlesList()
		Krakatoa_GUI_Particles.open = FranticParticles.GetBoolProperty "GUI:ParticleSystemsRolloutOpen"
	)
	
	on btn_selectAll pressed do
	(
		--updateParticlesList ()
		lbx_particleSystemsInScene.selection = #{1..(lbx_particleSystemsInScene.items.count)}
		if chb_synchSelections.state do synchSelectionToScene()
	)
	
	on btn_deselectAll pressed do
	(
		--updateParticlesList ()
		lbx_particleSystemsInScene.selection = #{}
		if chb_synchSelections.state do synchSelectionToScene()
	)

	on btn_selectInvert pressed do
	(
		--updateParticlesList ()
		lbx_particleSystemsInScene.selection = -lbx_particleSystemsInScene .selection
		if chb_synchSelections.state do synchSelectionToScene()
	)			
	
	on lbx_particleSystemsInScene selectionEnd do if chb_synchSelections.state do synchSelectionToScene()
	
	on btn_hideSelected pressed do
	(
		hide (for i in lbx_particleSystemsInScene.selection collect KrakatoaParticleSystemsList[i])
		--updateParticlesList()
	)
	on btn_unhideSelected pressed do
	(
		unhide (for i in lbx_particleSystemsInScene.selection collect KrakatoaParticleSystemsList[i])
		--updateParticlesList()
	)
	
	on btn_selectHidden pressed do
	(
		--updateParticlesList()
		lbx_particleSystemsInScene.selection = (for i = 1 to lbx_particleSystemsInScene.items.count where KrakatoaParticleSystemsList[i].isHiddenInVpt collect i)
		if chb_synchSelections.state do 
			select (for i = 1 to lbx_particleSystemsInScene.items.count where KrakatoaParticleSystemsList[i].isHiddenInVpt collect KrakatoaParticleSystemsList[i])
	)
	
	
	on chb_showEnabledOnly changed state do updateParticlesList()


	on Krakatoa_GUI_Particles rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ParticleSystemsRolloutOpen" val		
			if val then 
				FranticParticles.LogDebug ("+Particle Systems Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Particle Systems Rollout ROLLED UP.")	
	)			
	
	
	on Krakatoa_GUI_Particles close do 
	(
		if Krakatoa_GUI_Particles.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Particles.title "false"
			Krakatoa_GUI_ParticleLoaders.Refresh_GUI()
		)	
		 callbacks.removeScripts id:#Krakatoa_ParticlesSelectionMonitor
		 callbacks.removeScripts id:#Krakatoa_ParticlesCreationDeletionMonitor
		 deleteAllChangeHandlers id:#Krakatoa_ParticlesParametersMonitor		
	)	

	on Krakatoa_GUI_Particles open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Particles.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		 refresh_GUI()
		 callbacks.removeScripts id:#Krakatoa_ParticlesSelectionMonitor
		 registerSelectionCallback()

		 callbacks.removeScripts id:#Krakatoa_ParticlesCreationDeletionMonitor
		 registerSceneNodeCallbacks()
		 
		 registerWhenConstructMonitor()		
		FranticParticles.LogDebug ("+Scene Particles Rollout OPENED.")			
	)			
	
)--end rollout

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PARTICLE LOADERS ROLLOUT
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_ParticleLoaders "Particle Loaders" category:60 width:457
(
	local KrakatoaLoadersList = #()

	button btn_Help_Loaders  "Open Krakatoa Online Help..." width:430 height:14 align:#left offset:[-10,-5] across:2
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	on btn_Help_Loaders pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/particle_loaders.php" ""	

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_ParticleLoaders
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_ParticleLoaders
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)				

	on Krakatoa_GUI_ParticleLoaders moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_ParticleLoaders.title (pos as string)
	)	

	checkbutton chb_synchSelections ">Synch. Selection" across:3 width:144 align:#left checked:true offset:[-8,0] highlightcolor:KrakatoaSkinColorsStruct.Loaders
	dropdownlist ddl_displayInfo items:#("Particle Files","Render Settings","Viewport Settings","Particle Display Mode","Particle Color Source","Timing","Options","Missing Frames In Scene","Missing Frames In Render") width:154 align:#center offset:[2,0]
	button btn_createLoader "Create New Loader..." width:144 align:#right offset:[10,0]
	
	multilistbox lbx_particleLoadersInScene height:20 width:450 align:#center offset:[0,-3]
	
	button btn_selectAll "Select All Loaders" width:143 align:#left across:3 offset:[0,-3]
	button btn_deselectAll "Deselect All Loaders" width:143 align:#center offset:[0,-3]
	button btn_selectInvert "Invert Loaders Selection" width:143 align:#right offset:[0,-3]
	
	button btn_hideSelected "Hide Selected Loaders" width:143 align:#left across:3 offset:[0,-3]
	button btn_unhideSelected "Unhide Selected Loaders" width:143 align:#center offset:[0,-3]
	button btn_selectHidden "Select Hidden Loaders" width:143 align:#right offset:[0,-3]
	
	label lbl_diskCount "Disk:" across:3 align:#left
	label lbl_renderCount "Render:" align:#center
	label lbl_viewCount "View:" align:#right
	
	label lbl_placeholder01 ""
	label lbl_placeholder02 ""

	button btn_enableInRender "Enable In Render" width:106 align:#left across:4 offset:[-5,-3]
	button btn_disableInRender "Disable In Render" width:106 align:#center offset:[-3,-3]
	button btn_enableInViewport "Enable In Viewport"  width:106 align:#center offset:[5,-3]
	button btn_disableInViewport "Disable In Viewport" width:106 align:#right offset:[5,-3]
	
	button btn_enableLimitInRender "Render Limit ON" width:106 align:#left across:4 offset:[-5,-3]
	button btn_disableLimitInRender "Render Limit OFF" width:106 align:#center offset:[-3,-3]
	button btn_enableLimitInViewport "Viewport Limit ON" width:106 align:#center offset:[5,-3]
	button btn_disableLimitInViewport "Viewport Limit OFF" width:106 align:#right offset:[5,-3]

	spinner spn_renderLimit "Render Limit (x1000):" fieldwidth:35 range:[1,10000,1000]  align:#center offset:[20,3] across:4 type:#integer
	button btn_setRenderLimit "Set Value" width:60 align:#right  offset:[-5,0]

	spinner spn_viewportLimit "Viewport Limit (x1000):" fieldwidth:35 range:[1,10000,100]  align:#center offset:[26,3] type:#integer
	button btn_setViewportLimit "Set Value" width:60 align:#right  offset:[5,0]



	
	dropdownlist ddl_renderLoadMode items:#("Load Every Nth Particle","Load First N Particles")	width:152 align:#left across:4 offset:[-5,0]
	button btn_SetRenderLoadMode "Set Mode" align:#center offset:[20,0] width:60
	dropdownlist ddl_viewLoadMode items:#("Load Using Render Mode","Load Every Nth Particle","Load First N Particles")  width:152 align:#center offset:[28,0]
	button btn_SetViewLoadMode "Set Mode" align:#right offset:[5,0] width:60
	
	dropdownlist ddl_particleColorSource items:#("Saved Particle Colors","Loader's Wireframe Color","Loader's Material Self-Illum.") width:152 align:#left across:4 offset:[-5,0]
	button btn_SetParticleColorSource "Set Mode" align:#center offset:[20,0] width:60
	
	dropdownlist ddl_ViewportParticleColorSource items:#("Color Using Render Mode","Saved Particle Colors","Loader's Wireframe Color","Loader's Material Self-Illum.") width:152 align:#center offset:[28,0]
	button  btn_SetViewportParticleColorSource "Set Mode" align:#right offset:[5,0] width:60


	--dropdownlist ddl_particleDensitySource items:#("Saved Particle Densities","Loader's Material Opacity","Particle Densities * Opacity") width:152 align:#left across:4 offset:[-5,0]
	checkbutton ckb_loadParticleDensities ">Load Particle Densities" width:152 align:#left across:4 offset:[-5,0]
	button btn_SetParticleDensitySource "Set Mode" align:#center offset:[20,0] width:60
	
	dropdownlist ddl_ViewportParticleDisplayMode items:#("Display As Small Dots","Display As Large Dots","Display Velocities","Display Normals","Display Tangents") width:152 align:#center offset:[28,0]
	button  btn_SetViewportParticleDisplayMode"Set Mode" align:#right offset:[5,0] width:60

	
	dropdownlist ddl_Void01 width:152 align:#left across:4 offset:[-5,0] visible:false
	button btn_Void01 "" align:#center offset:[20,0] width:60 visible:false
	
	spinner spn_viewportFraction "View % Of Render %:" fieldwidth:35 range:[0,100,1]  align:#center offset:[28,3]
	button btn_viewportFraction "Set Value" width:60 align:#right  offset:[5,0]



	groupbox grp_renderModes "Render:" width:225 height:205 pos:[3,395] across:2 
	groupbox grp_viewportModes "Viewport:" width:223 height:205 pos:[227,395] 
	groupbox lbl_massChangingUtility "Mass-Changing Utilities:" height:220 width:448 pos:[3,380] 

	button btn_launchPRTScan "Launch PRT Loader Scanner Utility..." width:214 align:#right
	on btn_launchPRTScan pressed do macros.run "Krakatoa" "KrakatoaPRTscan"
	
	fn registerSelectionCallback =
	(
		FranticParticles.LogDebug ("+Particle Loaders Rollout - Registering SELECTION Callback.")
		callbacks.addScript #selectionSetChanged "Krakatoa_GUI_ParticleLoaders.synchSelectionFromScene()" id:#Krakatoa_LoaderSelectionMonitor
	)
	
	fn registerSceneNodeCallbacks =
	(
		 FranticParticles.LogDebug ("+Particle Loaders Rollout - Registering NODE Callbacks.")
		 callbacks.addScript #nodePostDelete "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
		 callbacks.addScript #nodeCreated "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
		 callbacks.addScript #nodeRenamed "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
		 callbacks.addScript #nodeHide "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
		 callbacks.addScript #nodeUnhide "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
		 if (maxVersion())[1] >=8000 do callbacks.addScript #sceneUndo "Krakatoa_GUI_ParticleLoaders.nodesChanged()" id:#Krakatoa_LoaderCreationDeletionMonitor
	)
	
	fn registerWhenConstructMonitor =
	(
		FranticParticles.LogDebug ("+Particle Loaders Rollout - Registering WHEN Callbacks.")
		deleteAllChangeHandlers id:#Krakatoa_LoaderParametersMonitor
		theBOs = for o in KrakatoaLoadersList collect o.baseobject --we have to monitor just the base objects to avoid updates on node PRS changes!
		when parameters theBOs change id:#Krakatoa_LoaderParametersMonitor do Krakatoa_GUI_ParticleLoaders.nodesChanged()
	)
	
	fn synchSelectionToScene =
	(
		callbacks.removeScripts id:#Krakatoa_LoaderSelectionMonitor
		max select none
		select (for i in lbx_particleLoadersInScene.selection where isValidNode KrakatoaLoadersList[i] collect KrakatoaLoadersList[i])
		registerSelectionCallback()
	)
	
	fn synchSelectionFromScene =
	(
		lbx_particleLoadersInScene.selection = (for o in selection where findItem KrakatoaLoadersList o > 0 collect findItem KrakatoaLoadersList o) as bitarray
	)
	
	fn getArrayDifference arr1 arr2 =
	(
		local array1 = for i in arr1 collect i
		local array2 = for i in arr2 collect i
		
		if array1.count > array2.count then
			for i = array2.count to 1 by -1 do 
			(
				theIndex = findItem array1 array2[i]
				if theIndex > 0 do 
				(
					deleteItem array2 i
					deleteItem array1 theIndex
				)	
			)
		else	
			for i = array1.count to 1 by -1 do 
			(
				local theIndex = findItem array2 array1[i]
				if theIndex > 0 do 
				(
					deleteItem array1 i
					deleteItem array2 theIndex
				)	
			)	
		
		if array1.count ==0 then
		(
			"OK"
		)
		else
		(
			sort (join array1 array2)
			local theNegatives = (for i in array1 where i < 1 collect i) 
			local thePositives = ((for i in array1 where i > 0 collect i) as bitarray) 
			local txt = "(" 
			if theNegatives.count > 0 do 
				txt += substring (theNegatives as string) 3 ((theNegatives as string).count-3)  
			if thePositives.numberset > 0 and theNegatives.count > 0 do txt+=", "
			if thePositives.numberset > 0 do txt += substring (thePositives as string) 3 ((thePositives as string).count-3) 
			txt += ")"
			txt
		)	
	)
	
	fn updateLoadersList =
	(
		if Krakatoa_GUI_ParticleLoaders.open do
		(
			local diskCount = 0
			local renderCount = 0
			local viewCount = 0
			
			KrakatoaLoadersList = for o in objects where classof o == KrakatoaPrtLoader collect o
			lbx_particleLoadersInScene.items = for o in KrakatoaLoadersList collect 
			(
				diskCount += o.delegate.getParticleCount()
				if o.enabledInRender AND not o.isHiddenInVpt do renderCount += o.delegate.getParticleCountRender()
				if o.enabledInView AND not o.isHiddenInVpt do viewCount += o.delegate.getParticleCountView() 
				local txt = " "
				case ddl_displayInfo.selection of
				(
					1: (
						txt += "(" + FranticParticleRenderMXS.addCommas ((o.delegate.getParticleCount()) as string) + ") "
						txt += o.fileList.count as string + ":"
						for i in o.fileList do txt+= fileNameFromPath i + ";"
					 )
					2: (
						txt += "Render:" + (if o.enabledInRender then "On" else "Off")
						if o.enabledInRender then
						(
							txt += "(" + (((o.delegate.getParticleCountRender()) as integer)as string) 
							txt += " | " + o.percentRenderer as string + "%) "
							txt += " Limit:" + (if o.useRenderLimit then ("On (" + o.RenderLimit as string + "K)") else "Off" )
							txt += case o.renderLoadMode of
							(
								1: " Load Every Nth Particle"
								2: " Load First N Particles"
								3: " Load Last N Particles"
								default: " ???"
							)							
						)	
					)		
					3: (
						txt += "Viewport:" + (if o.enabledInView then "On" else "Off")
						if o.enabledInView then
						(
							txt += "(" + (((o.delegate.getParticleCountView()) as integer)as string) 
							txt += " | " + o.percentViewport as string + "% -> "+ (o.percentViewport * o.percentRenderer * 0.01) as string +"%) "
							txt += " Limit:" + (if o.useViewportLimit then ("On (" + o.ViewportLimit  as string + "K)") else "Off" )
							txt += case o.viewLoadMode of
							(
								1: " Load Using Render Mode"
								2: " Load Every Nth Particle"
								3: " Load First N Particles"
								4: " Load Last N Particles"
								default: " ???"
							)
						)	
					)
					4: (
						txt += "Display As " 
						txt += case o.ViewportParticleDisplayMode of
						(
							1: "Small Dots"
							2: "Large Dots"
							3: "Velocities"
							4: "Normals"
							5: "Tangents"
							default: " ???"
						)						
					)					
					5: (
						txt += "Render:"
						txt += case o.particleColorSource of
						(
							1: "Saved Particle Colors"
							2: "Loader's Wireframe Color"
							3: "Loader's Material Color"
							default: " ???"
						)					
						txt += "  Viewport:"
						txt += case o.ViewportParticleColorSource of
						(
							1: "Color Using Render Mode"
							2: "Saved Particle Colors"
							3: "Loader's Wireframe Color"
							4: "Loader's Material Color"
							default: " ???"
						)

					)	
					6: (
						txt += "Frame Offset:" + (o.frameOffset as string)
						txt += if o.loadSingleFrame  then "  Load Single Frame Only" else "  Load Whole File Sequence"
					)	
	
					7: (
						--txt += "Load Particle Normals:" + (if o.loadParticleNormals then "On" else "Off")
						txt += "  Use Transformations:" + (if o.useTransform then "On" else "Off")
					)	
					default: (
						cnt = 0
						local theRenderRange 
						if ddl_displayInfo.selection == 8 then
						(
							if o.enablePlaybackGraph then
								theRenderRange = for i = animationrange.start to animationrange.end collect at time i (o.playbackGraphTime as integer +o.frameOffset ) 
							else
								theRenderRange = for i = animationrange.start to animationrange.end collect ((i.frame +o.frameOffset)  as integer )
						)
						if ddl_displayInfo.selection == 9 then
						(
							local currentSequence = #()
							case rendTimeType of
							(
								1: (
										currentSequence = #(currentTime.frame as integer) 
									)
								2: (
										currentSequence = for t in animationRange.start to animationRange.end by rendNthFrame collect (t.frame as integer)
									)
								3: (
										currentSequence = for t in rendStart to rendEnd by rendNthFrame collect (t.frame as integer)
									)
								4: (
										theFS = filterString rendPickupFrames "-"
										txt = "#{"
										for i = 1 to theFS.count-1 do txt += theFS[i]+ ".."
										txt += theFS[theFS.count] + "}"
										currentSequence = (execute txt) as array
										currentSequence = sort currentSequence 
									)	
							)
							if o.enablePlaybackGraph then
								theRenderRange = for i in currentSequence collect at time i (o.playbackGraphTime as integer +o.frameOffset) 
							else
								theRenderRange = for i in currentSequence collect (i+o.frameOffset) 
						)
						if o.limitToRange == true do
							theRenderRange = for i in theRenderRange where i >= o.rangeStartFrame and i <= o.rangeEndFrame collect i
								
						for f in o.fileList do
						(
							cnt += 1
							txt += " " + cnt as string + ":"
							if o.loadSingleFrame then 
							(
								if doesFileExist f then txt+="OK" else txt+="Missing Frame"
							)	
							else
							(
								local theFilePattern = FranticParticles.ReplaceSequenceNumberWithHashes f
								local theFS = filterString theFilePattern "#"
								theFilePattern = ""
								for i in theFS do theFilePattern += i + "*"
								local theFiles = getFiles theFilePattern
								local availableFrames = for i in theRenderRange where findItem theFiles (FranticParticles.ReplaceSequenceNumber f i) > 0 collect i
								txt += getArrayDifference theRenderRange availableFrames
							)
						)
					)			
					
				)	
				(if o.isHiddenInVpt then "--" else "+") + "["+o.name+"]"+ txt
			)	
			lbl_diskCount.text = "Disk: " + FranticParticleRenderMXS.addCommas (diskCount as string)
			Krakatoa_GUI_Channels.updateMemChannels()	
			lbl_renderCount.text = "Render: " + FranticParticleRenderMXS.addCommas ((renderCount as integer) as string) + " ("  + (renderCount * Krakatoa_GUI_Channels.MemoryBytesPerParticle / 1048576.0) as string+ " MB)"
			lbl_viewCount.text = "View: " + FranticParticleRenderMXS.addCommas ((viewCount as integer) as string)
			
			if chb_synchSelections.state do synchSelectionFromScene()
		)	
	)		
	
	on btn_hideSelected pressed do
	(
		hide (for i in lbx_particleLoadersInScene.selection collect KrakatoaLoadersList [i])
		updateLoadersList()
	)
	on btn_unhideSelected pressed do
	(
		unhide (for i in lbx_particleLoadersInScene.selection collect KrakatoaLoadersList [i])
		updateLoadersList()
	)
	
	on btn_selectHidden pressed do
	(
		updateLoadersList()
		lbx_particleLoadersInScene.selection = (for i = 1 to lbx_particleLoadersInScene.items.count where KrakatoaLoadersList[i].isHiddenInVpt collect i)
		if chb_synchSelections.state do 
			select (for i = 1 to lbx_particleLoadersInScene.items.count where KrakatoaLoadersList[i].isHiddenInVpt collect KrakatoaLoadersList[i])
	)			
	
	fn nodesChanged =
	(
		if Krakatoa_GUI_ParticleLoaders.open then
		(
			FranticParticles.LogDebug ("+Particle Loaders Rollout - NodesChanged Callback Executed.")
			updateLoadersList()
			registerWhenConstructMonitor()
		)
		else
			FranticParticles.LogDebug ("--Particle Loaders Rollout - NodesChanged Callback SUPPRESSED - Rollout Not Open!")
	)
	
	fn refresh_GUI =
	(
		try(Krakatoa_GUI_ParticleLoaders.open = FranticParticles.GetBoolProperty "GUI:ParticleLoadersRolloutOpen")catch()
		updateLoadersList()
	)
	
	on chb_synchSelections changed state do
	(
		refresh_GUI()
		if state do synchSelectionFromScene()
	)
	
	on lbx_particleLoadersInScene selectionEnd do
	(
		if chb_synchSelections.state do synchSelectionToScene()
	)
	
	on lbx_particleLoadersInScene doubleClicked itm do 
	(
		for i in lbx_particleLoadersInScene.selection do 
			FranticParticles.LogProgress (lbx_particleLoadersInScene.items[i])
	)	
	
	on btn_createLoader pressed do 
	(
		newLoader = try(execute "KrakatoaPrtLoader()")catch()
		updateLoadersList()
		lbx_particleLoadersInScene.selection = #{lbx_particleLoadersInScene.items.count}
		max modify mode
		if isValidNode newLoader do
		(
			select newLoader 
			local thePref = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior"
			if thePref != "3" do try(newLoader.params.btn_addFiles.pressed())catch()
		)	
	)
	
	on ddl_displayInfo selected itm do updateLoadersList()
	
	on btn_selectAll pressed do
	(
		updateLoadersList()
		lbx_particleLoadersInScene.selection = #{1..(lbx_particleLoadersInScene.items.count)}
		if chb_synchSelections.state do synchSelectionToScene()
	)
	
	on btn_deselectAll pressed do
	(
		updateLoadersList()
		lbx_particleLoadersInScene.selection = #{}
		if chb_synchSelections.state do synchSelectionToScene()
	)

	on btn_selectInvert pressed do
	(
		updateLoadersList()
		lbx_particleLoadersInScene.selection = -lbx_particleLoadersInScene.selection
		if chb_synchSelections.state do synchSelectionToScene()
	)	


--ENABLED/DISABLE IN VIEWPORT AND RENDERER
	on btn_enableInViewport pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].enabledInView = true)catch()
	)	
	on btn_disableInViewport pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].enabledInView = false)catch()
	)	
	on btn_enableInRender pressed do
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].enabledInRender = true)catch()
	)	
	on btn_disableInRender pressed do
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].enabledInRender = false)catch()
	)	

--ENABLED/DISABLE LIMIT IN VIEWPORT AND RENDERER
	on btn_enableLimitInViewport pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].useViewportLimit = true)catch()
	)	
	on btn_disableLimitInViewport pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].useViewportLimit= false)catch()
	)	
	on btn_enableLimitInRender pressed do
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].useRenderLimit= true)catch()
	)	
	on btn_disableLimitInRender pressed do
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].useRenderLimit= false)catch()
	)	

	on btn_setRenderLimit pressed do 
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].RenderLimit= spn_renderLimit.value)catch()
	)		

	on btn_SetViewportLimit pressed do 
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].ViewportLimit = spn_ViewportLimit.value)catch()
	)		
	
	
--MASS-CHANGE PARTICLE AND COLOR LOADING MODE IN VIEWPORT AND RENDERER		
	on btn_SetViewLoadMode pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].viewLoadMode = ddl_viewLoadMode.selection)catch()
	)
	
	on btn_SetRenderLoadMode pressed do
	(
		ddl_displayInfo.selection = 2
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].renderLoadMode = ddl_renderLoadMode.selection)catch()
	)		
	
	on btn_SetViewportParticleColorSource pressed do
	(
		ddl_displayInfo.selection = 5
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].ViewportParticleColorSource = ddl_ViewportParticleColorSource.selection)catch()
	)	
	
	on btn_SetParticleColorSource pressed do
	(
		ddl_displayInfo.selection = 5
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].particleColorSource = ddl_particleColorSource.selection)catch()
	)			
	


	on btn_viewportFraction pressed do
	(
		ddl_displayInfo.selection = 3
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].percentViewport = spn_viewportFraction.value)catch()
	)
	
	on btn_SetParticleDensitySource pressed do 
	(
		ddl_displayInfo.selection = 5
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].loadDensities = ckb_loadParticleDensities.state)catch()		
	)	
	
	on btn_SetViewportParticleDisplayMode pressed do
	(
		ddl_displayInfo.selection = 4
		for i in lbx_particleLoadersInScene.selection do try(KrakatoaLoadersList[i].ViewportParticleDisplayMode = ddl_ViewportParticleDisplayMode.selection)catch()	
	)
	
	
	
	on Krakatoa_GUI_ParticleLoaders rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ParticleLoadersRolloutOpen" val		
		if val then 
		(
			FranticParticles.LogDebug ("+Particle Loaders Rollout ROLLED DOWN.")
		)					
		else
			FranticParticles.LogDebug ("+Particle Loaders Rollout ROLLED UP.")	
	)			
		
	
	on Krakatoa_GUI_ParticleLoaders close do 
	(
		if Krakatoa_GUI_ParticleLoaders.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_ParticleLoaders.title "false"
			Krakatoa_GUI_ParticleLoaders.Refresh_GUI()
		)	
		 callbacks.removeScripts id:#Krakatoa_LoaderSelectionMonitor
		 callbacks.removeScripts id:#Krakatoa_LoaderCreationDeletionMonitor
		 deleteAllChangeHandlers id:#Krakatoa_LoaderParametersMonitor			
	)	

	on Krakatoa_GUI_ParticleLoaders open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_ParticleLoaders.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		
		callbacks.removeScripts id:#Krakatoa_LoaderSelectionMonitor
		registerSelectionCallback()

		callbacks.removeScripts id:#Krakatoa_LoaderCreationDeletionMonitor
		registerSceneNodeCallbacks()
		 
		registerWhenConstructMonitor()				
		FranticParticles.LogDebug ("+Particle Loaders Rollout OPENED.")			
	)			
	
)--end rollout

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--MATTE OBJECTS ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_MatteObjects "Matte Objects" category:80 width:457
(

	button btn_LoadSave_MatteObjects "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_MatteObjects  "Open Krakatoa Online Help..." width:408 height:14 align:#center offset:[0,-5] 
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_LoadSave_MatteObjects pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_MatteObjects
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_MatteObjects rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_MatteObjects
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)		
	
	on btn_Help_MatteObjects pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/matte_objects.php" ""		

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_MatteObjects
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_MatteObjects
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)	

	on Krakatoa_GUI_MatteObjects moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_MatteObjects.title (pos as string)
	)	
	

	checkbutton ckb_useMatteObjects ">Enable Matte Objects" across:3 width:148 align:#left offset:[-9,0] tooltip:"When checked, Matte Objects specified via Named Selection Sets will be considered during lighting and rendering." highlightcolor:KrakatoaSkinColorsStruct.Matte 
	--checkbutton ckb_useDepthMaps ">Use Depth Maps" width:148 align:#center tooltip:"When checked, Depth Maps will be used to determine particle visibility. When unchecked, each particle will be raytraced against Matte Objects." highlightcolor:KrakatoaSkinColorsStruct.Matte
	dropdownlist ddl_MatteObjectsMode width:148 align:#center offset:[1,0] items:#("Raytraced Depth Maps","Rasterized Depth Maps","Brute Force Raytracing")
	checkbutton ckb_saveMultipleLayers ">Save Multiple Layers" width:148 align:#right offset:[9,0] tooltip:"When checked, saves multiple layers for better anit-aliasing when compositing." highlightcolor:KrakatoaSkinColorsStruct.Matte

	group "Matte Object Anti-Aliasing Settings"
	(
		spinner spn_MatteRayDivisions "Ray Divisions:" range:[1,10,1] type:#integer fieldwidth:55 align:#right offset:[0,-5]
	)
	
	listbox lbx_allNamedSelectionSets "Named Selection Sets:" items:#() height:6 across:2 width:213 align:#left offset:[-9,0]
	listbox lbx_useNamedSelectionSets "Matte Objects Named Selection Sets:" items:#() height:6 width:213 align:#right offset:[9,0]
	
	button btn_update "Update Named Selection Set Lists" width:214 align:#left offset:[-9,-5] across:3 tooltip:"Update both Named Selection Sets lists manually to reflect name changes, new and deleted selection sets etc."
	button btn_selectInScene "Select Highlighted" width:106 align:#right offset:[46,-5] tooltip:"Select the objects in the scene stored in the currently highlighted Matte Objects Named Selection Set ."
	button btn_selectAllInScene "Select All" width:106 align:#right offset:[9,-5] tooltip:"Select the objects in the scene stored in all Matte Objects Named Selection Sets."

	button btn_selectionSetAdd ">" height:40 align:#center width:20 offset:[0,-110] tooltip:"Move the highlighted Named Selection Set to the Matte Objects Named Selection Sets list. All geometry objects in it will become matte objects."
	button btn_selectionSetRemove "<" height:40 align:#center offset:[0,-5] width:20 tooltip:"Remove the highlighted Named Selection Set from the Matte Objects Named Selection Sets list."
	
	edittext edt_createNewSelSet "NSS:" text:"KrakatoaMatteObjects" across:2 width:214 align:#left offset:[-2,28]
	button btn_createNewSelSet "Create/Update Matte Selection Set" width:214 align:#right offset:[0,28] height:18 tooltip:"Select objects, enter NSS name and press to create a new selection set. Select an existing NSS from the Matte Objects NSS list, select objects in the scene and press to update."

	group "Load Initial Depth Map File Sequence:"
	(
		dropdownlist ddl_DepthMapMode items:#("Camera Space Z Depth","Normalized Z Depth","Inverted Normalized Z Depth")  align:#left width:214 offset:[-4,-3] across:2
		spinner spn_DepthMapNear "Z Near:" range:[0,100000000,0] fieldwidth:100 align:#right offset:[3,-3] type:#worldunits
		checkbutton chk_useDepthMapFiles ">Use Depth Map File Sequence" width:214 align:#left offset:[-5,-3] across:2 highlightcolor:KrakatoaSkinColorsStruct.Matte
		spinner spn_DepthMapFar "Z Far:" range:[0,100000000,0] fieldwidth:100 align:#right offset:[3,-3] type:#worldunits
		
		button btn_depthMapFiles "..." width:16 height:20 offset:[-7,-2] align:#left across:3 
		edittext edt_depthMapFiles "" fieldwidth:405 align:#center offset:[-3,0] 
		button btn_ExploreDepthMapPath "E" align:#right width:16 height:20 offset:[5,-2] tooltip:"Open Current Path In Windows Explorer..."
	)
	
	fn saveSelectionSets =
	(
		local txt = "#("
		if lbx_useNamedSelectionSets.items.count > 0 do
		(
			for i = 1 to lbx_useNamedSelectionSets.items.count-1 do txt += "\"" + lbx_useNamedSelectionSets.items[i] as string + "\","
			txt += "\"" + lbx_useNamedSelectionSets.items[lbx_useNamedSelectionSets.items.count] as string + "\""
		)	
		txt += ")"
		FranticParticles.SetProperty "Matte:NamedSelectionSets" txt
	)			
	
	fn updateSelectionSets =
	(
		local theArray  = execute (FranticParticles.GetProperty "Matte:NamedSelectionSets")
		lbx_useNamedSelectionSets.items = theArray 
		lbx_allNamedSelectionSets.items = for i = 1 to selectionsets.count where findItem theArray (getNamedSelSetName i) == 0 collect (getNamedSelSetName i)
		saveSelectionSets()
		Krakatoa_GUI_Particles.updateParticlesList()
	)
	
	fn renamedSelectionSets theNames =
	(
		tempArray = lbx_useNamedSelectionSets.items
		for i = 1 to tempArray.count do if tempArray[i] == theNames[1] do tempArray[i] = theNames[2]
		lbx_useNamedSelectionSets.items = tempArray 
		updateSelectionSets()
	)

	on lbx_allNamedSelectionSets doubleClicked itm do
	(
		tempArray = lbx_useNamedSelectionSets.items
		append tempArray lbx_allNamedSelectionSets.selected 
		lbx_useNamedSelectionSets.items = tempArray
		saveSelectionSets()
		updateSelectionSets()
	)	

	on btn_selectionSetAdd pressed do 
	(		
		if lbx_allNamedSelectionSets.selection > 0 do
		(
			tempArray = lbx_useNamedSelectionSets.items
			append tempArray lbx_allNamedSelectionSets.selected 
			lbx_useNamedSelectionSets.items = tempArray
			saveSelectionSets()
			updateSelectionSets()				
		)	
	)
	
	on lbx_useNamedSelectionSets doubleClicked itm do
	(
		tempArray = lbx_useNamedSelectionSets.items
		deleteItem tempArray itm
		lbx_useNamedSelectionSets.items = tempArray
		saveSelectionSets()
		updateSelectionSets()				
	)
	
	on lbx_useNamedSelectionSets selected itm do edt_createNewSelSet.text = lbx_useNamedSelectionSets.selected
		
	
	on btn_selectionSetRemove pressed do 
	(		
		if lbx_useNamedSelectionSets.selection > 0 do
		(
			tempArray = lbx_useNamedSelectionSets.items
			deleteItem tempArray lbx_useNamedSelectionSets.selection
			lbx_useNamedSelectionSets.items = tempArray
			saveSelectionSets()
			updateSelectionSets()				
		)	
	)			
	on btn_update pressed do updateSelectionSets()
	
	on btn_selectAllInScene pressed do 
	(
		updateSelectionSets()	
		max select none
		for i = 1 to selectionsets.count where findItem lbx_useNamedSelectionSets.items (getNamedSelSetName i) != 0 do selectmore selectionsets[i]
	)	
	on btn_selectInScene pressed do 
	(
		updateSelectionSets()	
		max select none
		for i = 1 to selectionsets.count where lbx_useNamedSelectionSets.selected == (getNamedSelSetName i) do select selectionsets[i]
	)	
	
	on btn_createNewSelSet pressed do
	(
		if selection.count > 0 then
		(
			if edt_createNewSelSet.text != "" then
			(
				local theObjects = for o in selection where findItem geometryClass.classes (classof o) > 0 and classof o != TargetObject and classof o != KrakatoaPrtLoader and classof o != PF_Source collect o
				if theObjects.count > 0 then
				(
					selectionSets[edt_createNewSelSet.text] = theObjects 
					tempArray = lbx_useNamedSelectionSets.items
					if findItem tempArray edt_createNewSelSet.text == 0 do
					(
						append tempArray edt_createNewSelSet.text
						lbx_useNamedSelectionSets.items = tempArray
						saveSelectionSets()
					)	
					updateSelectionSets()
				)	
				else
					messagebox "The Current Selection Does Not Contain Any Valid Matte Objects\n" title:"Cannot Create Matte Objects Selection Set"
			)
			else
				messagebox "Please enter a valid name for the selection set\n" title:"Cannot Create Matte Objects Selection Set"
		)
		else		
			messagebox "Please select some Geometry Objects in the scene!" title:"Cannot Create Matte Objects Selection Set"
	)		

	on spn_MatteRayDivisions changed val do FranticParticles.SetProperty "Matte:RayDivisions" (val as string)
	on ckb_saveMultipleLayers changed state do FranticParticles.SetProperty "Matte:SaveMultipleLayers" (state as string)

	fn refresh_GUI = 
	(
		try(Krakatoa_GUI_MatteObjects.open = FranticParticles.GetBoolProperty "GUI:MatteObjectsRolloutOpen")catch()
		
--			edt_createNewSelSet.enabled = btn_createNewSelSet.enabled = btn_update.enabled = btn_selectInScene.enabled = btn_selectAllInScene.enabled = btn_selectionSetRemove.enabled = btn_selectionSetAdd.enabled = lbx_useNamedSelectionSets.enabled = lbx_allNamedSelectionSets.enabled = ((FranticParticles.GetProperty "Matte:MatteObjectMode") == "Named Selection Sets")
		
		--ckb_useDepthMaps.checked = FranticParticles.GetBoolProperty "UseDepthMaps"
		if FranticParticles.GetBoolProperty "UseDepthMaps" then
			if FranticParticles.GetBoolProperty "Matte:UseRayTracing" then
				ddl_MatteObjectsMode.selection = 1
			else
				ddl_MatteObjectsMode.selection = 2
		else 
			ddl_MatteObjectsMode.selection = 3
		
		chk_useDepthMapFiles.checked = FranticParticles.GetBoolProperty "Matte:UseDepthMapFiles" 
		edt_DepthMapFiles.text = FranticParticles.GetProperty "Matte:DepthMapFiles" 
		
		FranticParticleRenderMXS.SetDropDownValue ddl_DepthMapMode (FranticParticles.GetProperty "Matte:DepthMapMode")
		spn_DepthMapNear.value  = FranticParticles.GetFloatProperty "Matte:DepthMapNear" 
		spn_DepthMapFar.value = FranticParticles.GetFloatProperty "Matte:DepthMapFar" 
		spn_DepthMapNear.enabled = spn_DepthMapFar.enabled = ddl_DepthMapMode.selection > 1
		ckb_useMatteObjects.checked = FranticParticles.GetBoolProperty "Matte:UseMatteObjects"
		ckb_saveMultipleLayers.checked = FranticParticles.GetBoolProperty "Matte:SaveMultipleLayers"
		spn_MatteRayDivisions.value = FranticParticles.GetIntProperty "Matte:RayDivisions" 
		
		updateSelectionSets()
		callbacks.removeScripts id:#KrakatoaNamedSelectionSetMonitor 
		try --Works only in 3ds Max 9 and higher
		(
			callbacks.addScript #NamedSelSetCreated "try(Krakatoa_GUI_MatteObjects.updateSelectionSets())catch()" id:#KrakatoaNamedSelectionSetMonitor 
			callbacks.addScript #NamedSelSetDeleted "try(Krakatoa_GUI_MatteObjects.updateSelectionSets())catch()" id:#KrakatoaNamedSelectionSetMonitor 
			callbacks.addScript #NamedSelSetRenamed "try(Krakatoa_GUI_MatteObjects.renamedSelectionSets (callbacks.notificationParam()))catch()" id:#KrakatoaNamedSelectionSetMonitor 
		)catch()	
	)
	on Krakatoa_GUI_MatteObjects rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:MatteObjectsRolloutOpen" val
			if val then 
				FranticParticles.LogDebug ("+Matte Objects Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Matte Objects Rollout ROLLED UP.")	
	)

	on ckb_useMatteObjects changed state do 
	(
		FranticParticles.SetProperty "Matte:UseMatteObjects" state
		updateToolbarButtons()
		try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	)	
	
	on ckb_useMatteObjects rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "Matte:UseMatteObjects" ">Enable Matte Objects"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on edt_depthMapFiles changed val do FranticParticles.SetProperty "Matte:DepthMapFiles" val

	on ckb_saveMultipleLayers rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "Matte:SaveMultipleLayers" ">Save Multiple Layers"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		

	
	on btn_depthMapFiles pressed do (
		local newFile
		newFile = getOpenFileName caption:"Select the Depth Map Sequence to Load" filename:(FranticParticles.GetProperty "Matte:DepthMapFiles") types:"OpenEXR Files (*.exr)|*.exr|All(*.*)|*.*" history:"KrakatoaDepthMaps"
		if newFile != undefined do (
			FranticParticles.SetProperty "Matte:DepthMapFiles" newFile 
			refresh_GUI()
		)
		try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	)

	on ddl_DepthMapMode selected itm do 
	(
		FranticParticles.SetProperty "Matte:DepthMapMode" ddl_DepthMapMode.selected
		spn_DepthMapNear.enabled = spn_DepthMapFar.enabled = itm > 1
	)	
	
	on spn_DepthMapNear changed val do 
	(
		if val > spn_DepthMapFar.value do 
		(
			spn_DepthMapFar.value = val 
			FranticParticles.SetProperty "Matte:DepthMapFar" (val as string)
		)
		FranticParticles.SetProperty "Matte:DepthMapNear" (val as string)
	)	
	on spn_DepthMapFar changed val do 
	(
		if val < spn_DepthMapNear .value do 
		(
			spn_DepthMapNear.value = val
			FranticParticles.SetProperty "Matte:DepthMapFar" (val as string)
		)	
		FranticParticles.SetProperty "Matte:DepthMapFar" (val as string)
	)	

	/*
	on ckb_useDepthMaps changed state do (
		FranticParticles.SetProperty "UseDepthMaps" state 
		refresh_GUI()
--			Krakatoa_GUI_Main.refresh_GUI()
	)
	on ckb_useDepthMaps rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "UseDepthMaps" ">Use Depth Maps"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
*/

	on ddl_MatteObjectsMode selected itm do
	(
		case itm of
		(
			1: (
				FranticParticles.SetProperty "UseDepthMaps" "true"
				FranticParticles.SetProperty "Matte:UseRayTracing" "true"
			)
			2: (
				FranticParticles.SetProperty "UseDepthMaps" "true"
				FranticParticles.SetProperty "Matte:UseRayTracing" "false"
			)
			3: (
				FranticParticles.SetProperty "UseDepthMaps" "false"
				FranticParticles.SetProperty "Matte:UseRayTracing" "false"
			)
		)
	)
	
	
	
	on chk_useDepthMapFiles changed state do (
		FranticParticles.SetProperty "Matte:UseDepthMapFiles" state
		refresh_GUI()
	)	
	on chk_useDepthMapFiles rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "Matte:UseDepthMapFiles" ">Use Depth Map File Sequence"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		

	on Krakatoa_GUI_MatteObjects close do 
	(
		if Krakatoa_GUI_MatteObjects.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_MatteObjects.title "false"
			Krakatoa_GUI_MatteObjects.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_MatteObjects open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_MatteObjects.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Matte Objects Rollout OPENED.")			
	)			
	
)--end rollout


global Krakatoa_JobNameRCMenu 
rcmenu Krakatoa_JobNameRCMenu 
(
	local default = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineJobNameSource" 
	menuItem mnu_getMaxFileName "MAX Scene Name"
	menuItem mnu_getSavePath "Project_Sequence_Take from Save Path"
	separator sep_01
	subMenu "Set Default Behavior"
	(
		menuItem mnu_setMaxFileName "Use MAX Scene Name" checked:(default != "SavePath")
		menuItem mnu_setSavePath "Use Project_Sequence_Take from Save Path" checked:(default == "SavePath")
	)
	on mnu_getMaxFileName picked do
		Krakatoa_GUI_Partition.jobNameFromMaxName()
	on mnu_getSavePath picked do
		Krakatoa_GUI_Partition.jobNameFromSavePath()
	on mnu_setMaxFileName picked do
		setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineJobNameSource" "MaxSceneName"
	on mnu_setSavePath picked do
		setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineJobNameSource" "SavePath"
)

global Krakatoa_JobCommentRCMenu 
rcmenu Krakatoa_JobCommentRCMenu 
(
	local default = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineCommentSource" 
	menuItem mnu_default "Default Comment"
	menuItem mnu_getSavePath "Project_Sequence_Take from Save Path"
	separator sep_01
	subMenu "Set Default Behavior"
	(
		menuItem mnu_setdefault "Use Default Comment" checked:(default != "SavePath")
		menuItem mnu_setSavePath "Use Project_Sequence_Take from Save Path" checked:(default == "SavePath")
	)
	on mnu_default picked do
		Krakatoa_GUI_Partition.defaultComment ()
	on mnu_getSavePath picked do
		Krakatoa_GUI_Partition.CommentFromSavePath()
	on mnu_setdefault picked do
		setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineCommentSource" "Default"
	on mnu_setSavePath picked do
		setIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineCommentSource" "SavePath"
)

	
	



--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--PARTICLE FLOW PARTITIONING ROLLOUT	
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
rollout Krakatoa_GUI_Partition "Partitioning" category:40 width:457
(
	local KrakatoaIniPath = Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini"

	button btn_LoadSave_Partition "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_Partition "Open Krakatoa Online Help..." width:408 height:14 offset:[0,-5] align:#center
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_LoadSave_Partition pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Partition
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_Partition rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Partition
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	
	on btn_Help_Partition pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/particle_partitioning.php" ""		

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Partition
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Partition
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)			

	on Krakatoa_GUI_Partition moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Partition.title (pos as string)
	)			
	
	spinner spn_partitionCount "Partition Count: " range:[2,100,2] fieldwidth:50 type:#integer align:#left offset:[0,0] across:3
	spinner spn_PartitionStart "Partition Range From: " range:[1,100,1] type:#integer align:#center offset:[40,0] fieldwidth:50 
	spinner spn_PartitionEnd "To: " range:[1,100,1] type:#integer align:#right offset:[0,0] fieldwidth:50 

	group "Increment Random Seeds Of"
	(
		checkbutton ckb_incrementPositionRandomSeeds ">PFlow Position" align:#left width:106 height:20  across:4 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementSpawnRandomSeeds ">PFlow Spawn" align:#center width:106 height:20 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementSpeedRandomSeeds ">PFlow Speed " align:#center width:106 height:20 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementRotationRandomSeeds ">PFlow Rotation" align:#right width:106 height:20  highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		
		checkbutton ckb_incrementFumeFXRandomSeeds ">PFlow FumeFX" align:#left width:106 height:20 across:4 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementOtherRandomSeeds ">PFlow Others" align:#center width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementLegacyRandomSeeds ">Legacy Particles" align:#center width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementThinkingRandomSeeds ">ThinkingParticles" align:#right width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		
		checkbutton ckb_incrementBox3Geometry ">Box#3 Geometry" align:#left width:106 height:20 across:4 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementBox3Random  ">Box#3 Random" align:#center width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementBox3ScalarVector ">Box#3 Sclr/Vector" align:#center width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementBox3Icon ">Box#3 Icon" align:#right width:106 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning

		checkbutton ckb_incrementPRTModifiers ">PRT Loader Modifiers" align:#left width:214 height:20 across:2 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementGeometryModifiers ">Geometry Modifiers" align:#right width:214 height:20 offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		
		label lbl_exclude01 "NOTE: To exclude specific operators, events or objects, add NOSEED to their name."
		groupbox grp_exclude01 offset:[0,-27] height:25 width:430

		checkbutton ckb_incrementSelectedOnly ">Affect Seeds of Selected Objects Only" align:#left width:214 height:20 across:2 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
		checkbutton ckb_incrementBox3DiskCaches ">Increment Box#3 Disk Cache Filenames" align:#right width:214 height:20  highlightcolor:KrakatoaSkinColorsStruct.Partitioning
	)	
	
	--button btn_checkForMissingUVChannels "Test UV Channels"
	
	label lbl_placeHolder01 
	
	checkbutton ckb_skipExistingFiles ">Skip Existing Files" align:#left width:210 height:20 across:2 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
	dropdownlist ddl_deadlinePartitionMode items:#("One Job Only, Partitions As Tasks","One Job Per Partition, Frames As Tasks") align:#right width:210 

	
	button btn_saveCurrentPartitionLocally "Generate Partition Range Locally..." align:#left width:210 height:30 across:2 offset:[0,-3]
	button btn_submitCustomPartition "Submit Partition Range To Deadline" align:#right width:210 height:30 offset:[0,-3]
	
	button btn_savePartitionsLocally "Generate All Partitions Locally..." align:#left width:210 height:30 across:2 offset:[0,-3]
	button btn_submitPartitionJobs "Submit All Partitions To Deadline" align:#right width:210 height:30 offset:[0,-3]
	
	groupBox grp_partlocal "Local" width:220 height:110 offset:[-4,-110] across:2
	groupBox grp_partdeadline "Deadline" width:220 height:110 offset:[0,-110]
	
	progressbar prg_partprogress height:8 color:red align:#center
	progressbar prg_progress height:8 color:blue align:#center offset:[0,-3]
	label lbl_progress01 "" height:16 align:#center offset:[0,-4]
	label lbl_progress02 "" height:16 align:#center offset:[0,-4]
	
	group "Deadline Submission Settings"
	(
		edittext edt_jobname "Job Name:" fieldwidth:358 align:#left offset:[-2,0] across:2
		button btn_getJobNameMenu ">>" width:18 height:18 offset:[1,0] align:#right tooltip:"Open Menu to Set the Job Name to Max File Name or to Save Path Project/Sequence/Take..."

		edittext edt_comment "Comment:" fieldwidth:358 align:#left offset:[2,0] across:2
		button btn_getCommentMenu ">>" width:18 height:18 offset:[1,0] align:#right tooltip:"Open Menu to Set the Comment to Max File Name or to Save Path Project/Sequence/Take..."
		
		edittext edt_user "Name:" fieldwidth:130 align:#left offset:[18,0] across:2
		edittext edt_dept "Department:" fieldwidth:170 align:#right

		label lbl_category "Category:" align:#left offset:[3,3] across:2
		dropdownlist ddl_category items:#() align:#right width:380 offset:[3,0]

		label lbl_pools "Pool:" align:#left offset:[23,4] across:3
		dropdownList ddl_poollist "" width:196 align:#center offset:[-63,-2]
		checkbutton chk_onlypool ">Render Only On Machines In Pool" width:180 align:#right offset:[0,-3] highlightcolor:KrakatoaSkinColorsStruct.Partitioning

		label lbl_priority "Priority:" align:#left offset:[12,2] across:3
		progressbar sld_priority width:325 height:18 range:[0,100,50] type:#integer align:#center offset:[0,0]
		spinner spn_priority "" type:#integer fieldwidth:35 align:#right  offset:[0,1]
		
		spinner spn_machineLimit "Number of Machines Working Concurrently" range:[1,1000,1] type:#integer align:#left fieldwidth:35 offset:[-4,2] across:2 
		spinner spn_chunkSize "Frames Per Task: " range:[1,1000,1] type:#integer  align:#right  fieldwidth:35 offset:[-1,2]  --Render Task Chunk Size 

		spinner spn_MaxTasksPerSlave "Concurrent Tasks Per Machine: " range:[1,10,1] type:#integer align:#left fieldwidth:35 offset:[46,2] across:2 
		checkbutton chk_LimitTasksToNumberOfCpus ">Limit To Number Of CPUs" align:#right  offset:[0,-1]  width:180 highlightcolor:KrakatoaSkinColorsStruct.Partitioning
	)
	button btn_openDeadlineMonitor "Open Deadline Monitor..." align:#center width:446 --height:30 
	
	label lbl_getDeadline01 "DEADLINE WAS NOT DETECTED ON YOUR SYSTEM!" visible:false pos:[15,380]
	label lbl_getDeadline02 "NOTE: Deadline provides a FREE MODE supporting up to 2 NODES without limitations." visible:false pos:[15,405]
	label lbl_getDeadline03 "You could install Deadline in FREE MODE to take advantage of Krakatoa's Partitioning." visible:false pos:[15,430]
	label lbl_getDeadline04 "You can download Deadline from the link below:" visible:false pos:[15,455]
	hyperlink url_getDeadline01 "http://www.franticfilms.com/software/products/deadline/download/" address:"http://www.franticfilms.com/software/products/deadline/download/" visible:false pos:[15,480] color:blue hovercolor:red

	fn job_priority_update val =
	(
		if val <= 100 do
		(
			theRed = (255.0 - 255.0*val/100.0)*2.0
			if theRed > 255 do theRed = 255
			theGreen = 512.0*val/100.0
			if theGreen > 255 do theGreen = 255
			sld_priority.color = [theRed, theGreen, 0]
			sld_priority.value = spn_priority.value = val
		)
		val
	)		

	fn displayPoolsList =
	(
		if SMTDSettings.PoolsSort then
		(
			local tempArray = for i in SMTDSettings.Pools collect i
			ddl_poollist.items = sort tempArray 
		)	
		else
			ddl_poollist.items = SMTDSettings.Pools
			
		local theIndex = findItem ddl_poollist.items SMTDSettings.PoolName
		if theIndex > 0 then 
			ddl_poollist.selection = theIndex 
		else	
			ddl_poollist.selection = 1
	)	
	
	fn jobNameFromMaxName =
	(
		local theName = getFileNameFile maxFileName
		if theName == "" do theName = "Untitled 3ds Max Krakatoa Partition Job"
		SMTDSettings.jobName = edt_jobname.text = theName
	)		
	
	fn jobNameFromSavePath =
	(
		local theName = (FranticParticles.GetProperty "ParticleFilesProject") + "_" + FranticParticles.GetProperty "ParticleFilesSequence" + "_" + FranticParticles.GetProperty "ParticleFilesTake" 
		if theName != "__" do 
			SMTDSettings.jobName = edt_jobname.text = theName
	)
	
	on btn_getJobNameMenu pressed do popUpMenu Krakatoa_JobNameRCMenu pos:(mouse.ScreenPos) 
	on btn_getJobNameMenu rightclick do popUpMenu Krakatoa_JobNameRCMenu pos:(mouse.ScreenPos) 
	
	
	fn defaultComment =
	(
		edt_comment.text = SMTDSettings.Comment = ("3ds Max v" + ((maxVersion())[1]/1000.0) as string + " Krakatoa v"+ FranticParticles.Version +" Partition Submission")
	)	
	fn CommentFromSavePath =
	(
		local theName = (FranticParticles.GetProperty "ParticleFilesProject") + "_" + FranticParticles.GetProperty "ParticleFilesSequence" + "_" + FranticParticles.GetProperty "ParticleFilesTake" 
		if theName != "__" do 
			SMTDSettings.Comment = edt_comment.text = (theName + " Krakatoa v"+ FranticParticles.Version +" Partition Submission")
	)	

	on btn_getCommentMenu pressed do popUpMenu Krakatoa_JobCommentRCMenu pos:(mouse.ScreenPos) 
	on btn_getCommentMenu rightclick do popUpMenu Krakatoa_JobCommentRCMenu pos:(mouse.ScreenPos) 
	
	on edt_jobname entered txt do SMTDSettings.jobName = txt
	on edt_comment entered txt do SMTDSettings.comment = txt
	on edt_user entered txt do SMTDSettings.UserName = txt
	on edt_dept entered txt do setIniSetting SMTDPaths.InIFile "JobSettings"  "Department"  (SMTDSettings.Department = txt)
	on ddl_category selected itm do setIniSetting KrakatoaIniPath "JobSettings"  "Category"  (SMTDSettings.Category = ddl_category.selected)
	
	on chk_onlypool changed state do setIniSetting KrakatoaIniPath "JobSettings"  "PoolExclusive" ( (SMTDSettings.PoolExclusive = state) as string)
	on spn_priority changed value do setIniSetting KrakatoaIniPath "JobSettings"  "Priority" ( (SMTDSettings.Priority= (job_priority_update value)) as string )
	on sld_priority clicked value do setIniSetting KrakatoaIniPath "JobSettings"  "Priority" ( (SMTDSettings.Priority= (job_priority_update value)) as string )
	on ddl_poollist selected itm do setIniSetting KrakatoaIniPath "JobSettings"  "PoolName" (SMTDSettings.PoolName = ddl_poollist.selected) 
	on spn_machineLimit changed value do setIniSetting KrakatoaIniPath  "JobSettings"  "MachineLimit" ( (SMTDSettings.MachineLimit  = value) as string) 
	on spn_chunkSize changed value do setIniSetting KrakatoaIniPath  "JobSettings"  "ChunkSize" ( (SMTDSettings.ChunkSize = value) as string)

	--NOT AVAILABLE IN DEADLINE 2.6
	on spn_MaxTasksPerSlave changed value do 
	(
		try(setIniSetting KrakatoaIniPath  "JobSettings"  "MaxTasksPerSlave" ( (SMTDSettings.MaxTasksPerSlave = value) as string))catch()
	)	
	on chk_LimitTasksToNumberOfCpus changed value do 
	(
		try(setIniSetting KrakatoaIniPath  "JobSettings"  "LimitTasksToNumberOfCpus" ( (SMTDSettings.LimitTasksToNumberOfCpus = value) as string))catch()
	)
	
	on btn_openDeadlineMonitor pressed do 
	(
		if FranticParticleRenderMXS.DeadlineDetected == 2 do 
			try(shellLaunch "c:\\deadline\\bin\\DeadlineMonitor.exe" "")catch()
		if FranticParticleRenderMXS.DeadlineDetected == 3 do 
			try(shellLaunch (SMTDPaths.bindir + "DeadlineMonitor.exe") "")catch()
	)	
	
	/*
	fn SetAllFilePartitionCounts count = (
		for g in objects do (
			if classOf g == PF_Source do (
				for i = 1 to g.baseObject.numSubs do (
					local event = g.baseObject[i].object
					-- ((classOf event) == Event) returns false...
					if (classOf event) as string == "Event" do (
						for j = 1 to event.numSubs do (
							local operator = event[j].object
							if classOf operator == Birth_Particle_File do (
								FranticParticles.LogDebug ("Adjusting [" + operator as string + "]")
								operator.LoadFilePartition = true
								operator.FilePartitionTotal = count
							)
						)
					)
				)
			)
		)
	)
	*/
	
	local incrementPositionRandomSeeds 
	local incrementSpawnRandomSeeds 
	local incrementSpeedRandomSeeds 
	local incrementFumeFXRandomSeeds 
	local incrementRotationRandomSeeds 
	local incrementOtherRandomSeeds 
	local incrementLegacyRandomSeeds 
	local incrementThinkingRandomSeeds

	local IncrementBox3Geometry 
	local IncrementBox3Random
	local IncrementBox3ScalarVector
	local IncrementBox3Icon
	
	local IncrementPRTModifiers
	local IncrementGeometryModifiers
	
	local incrementBox3DiskCacheNames
	
	fn incrementSeedInPFlowOperator operator incrementValue=
	(
		if classOf operator == Cache_Disk and incrementBox3DiskCacheNames == true then
		(
			FranticParticles.LogProgress ("   >Adjusting [" + operator.name + "]")
			local theFilename = operator.Write_To_File 
			if theFilename != undefined then
			(
				if not matchpattern theFilename pattern:"*_part*of*_*" then
				(
					if incrementValue >= 0 then 
					(
						setAppData operator 20070719 theFilename
						theNewFile = FranticParticles.MakePartitionFilename theFilename (incrementValue+1) (FranticParticles.GetIntProperty "Partition:Count")
					)	
					else	
					(
						theNewFile = getAppData operator 20070719
						if theNewFile == undefined do theNewFile = theFilename
					)	
				)
				else
				(
					if incrementValue > 0 then 
					(
						theNewFile = FranticParticles.ReplacePartitionInFilename theFilename (incrementValue+1) 
					)	
					else	
					(
						theNewFile = getAppData operator 20070719
					)	
				)		
				operator.Write_To_File = theNewFile 
				FranticParticles.LogProgress ("    +File Name of Disk Cache Operator [" + operator.name + "] adjusted to ["+ getFileNameFile theNewFile + "].")
			)
			else
				FranticParticles.LogProgress ("    -Skipping Disk Cache Operator [" + operator.name + "] - No Filename Found!")
		)

		else 	if classOf operator == Birth_Particle_File then 
		(
			FranticParticles.LogProgress ("   >Adjusting [" + operator.name + "]")
			operator.LoadFilePartition = true
			operator.FilePartitionPart = operator.FilePartitionPart + incrementValue
			FranticParticles.LogProgress ("    +File Partition Part in Birth Particle File Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.FilePartitionPart as string + "].")
		) 
		else if isProperty operator "Random_Seed" then 
		(
			local operatorClass = (classOf operator) as string
			if  (matchPattern operatorClass pattern:"*position*")  then 
			(
				if incrementPositionRandomSeeds do
				(
					FranticParticles.LogProgress ("   >Adjusting Position Operator [" + operator.name + "]")
					operator.Random_Seed = operator.Random_Seed + incrementValue
					FranticParticles.LogProgress ("    +Random Seed in Position Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
				)	
			) 
			else if (matchPattern operatorClass pattern:"*spawn*")  then 
			(
				if incrementSpawnRandomSeeds do
				(
					FranticParticles.LogProgress ("   >Adjusting Spawn Operator [" + operator.name + "]")
					operator.Random_Seed = operator.Random_Seed + incrementValue
					FranticParticles.LogProgress ("    +Random Seed in Spawn Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
				)	
			) 
			else if (matchPattern operatorClass pattern:"*speed*")  then 
			(
				if incrementSpeedRandomSeeds do
				(
					FranticParticles.LogProgress ("   >Adjusting Speed Operator [" + operator.name + "]")
					operator.Random_Seed = operator.Random_Seed + incrementValue
					FranticParticles.LogProgress ("    +Random Seed in Speed Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
				)	
			)
			else if (matchPattern operatorClass pattern:"*rotation*")  then 
			(
				if incrementRotationRandomSeeds do
				(
					FranticParticles.LogProgress ("   >Adjusting Rotation Operator [" + operator.name + "]")
					operator.Random_Seed = operator.Random_Seed + incrementValue
					FranticParticles.LogProgress ("    +Random Seed in Rotation Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
				)	
			)
			else if (matchPattern operatorClass pattern:"*fumefx*")  then 
			(
				if incrementFumeFXRandomSeeds do
				(
					FranticParticles.LogProgress ("   >Adjusting FumeFX Operator [" + operator.name + "]")
					operator.Random_Seed = operator.Random_Seed + incrementValue
					FranticParticles.LogProgress ("    +Random Seed in FumeFX Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
				)	
			)
			else if incrementOtherRandomSeeds  then 
			(
				FranticParticles.LogProgress ("   >Adjusting Other Operator [" + operator.name + "]")
				operator.Random_Seed = operator.Random_Seed + incrementValue
				FranticParticles.LogProgress ("    +Random Seed in Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Random_Seed as string + "].")
			)
		) 
		else if operator != undefined and isProperty operator "Micro_Seed" then 
		(
			FranticParticles.LogProgress ("   >Adjusting Micro Seed in [" + operator.name + "]")
			operator.Micro_Seed = operator.Micro_Seed + incrementValue
			FranticParticles.LogProgress ("    +Micro Seed in Operator [" + operator.name + "] adjusted by ["+ incrementValue as string +"] to [" + operator.Micro_Seed as string + "].")
		)
		else if operator != undefined and isProperty operator "SubOperators" and operator.SubOperators.count > 0 then
		(
			FranticParticles.LogProgress ("   >Adjusting Sub-Operators in Box#3 Data Operator [" + operator.name + "]")
			for subOp in operator.SubOperators do
			(
				if classof subOp == geometryReferenceTarget and IncrementBox3Geometry do
				(
					local theSubOpName = subOp.getName()
					if matchpattern theSubOpName pattern:"*noseed*" then
						FranticParticles.LogProgress ("   >Skipping Geometry Sub-Operator - NOSEED Requested via Sub-Operator's Name...")
					else
					(
						FranticParticles.LogProgress ("   >Adjusting Geometry Sub-Operator...")
						subOp.random_seed = subOp.random_seed + incrementValue
						FranticParticles.LogProgress ("    +Random Seed in Geometry Sub-Operator adjusted by ["+ incrementValue as string +"] to [" + subOp.Random_Seed as string + "].")
					)	
				)
				if classof subOp == randomReferenceTarget and IncrementBox3Random do
				(
					local theSubOpName = subOp.getName()
					if matchpattern theSubOpName pattern:"*noseed*" then
						FranticParticles.LogProgress ("   >Skipping Random Sub-Operator - NOSEED Requested via Sub-Operator's Name...")
					else
					(
						FranticParticles.LogProgress ("   >Adjusting Random Sub-Operator...")
						subOp.random_seed = subOp.random_seed + incrementValue
						FranticParticles.LogProgress ("    +Random Seed in Random Sub-Operator adjusted by ["+ incrementValue as string +"] to [" + subOp.Random_Seed as string + "].")
					)	
				)	
				if (classof subOp == Scalar or classof subOp == Vector) and IncrementBox3ScalarVector do
				(
					local theSubOpName = subOp.getName()
					if matchpattern theSubOpName pattern:"*noseed*" then
						FranticParticles.LogProgress ("   >Skipping "+ (classof subOp) as string+ " Sub-Operator - NOSEED Requested via Sub-Operator's Name...")
					else
					(
						FranticParticles.LogProgress ("   >Adjusting "+ (classof subOp) as string+" Sub-Operator...")
						subOp.random_seed = subOp.random_seed + incrementValue
						FranticParticles.LogProgress ("    +Random Seed in "+ (classof subOp) as string+ " Sub-Operator adjusted by ["+ incrementValue as string +"] to [" + subOp.Random_Seed as string + "].")
					)	
				)	
				if classof subOp == Icon and IncrementBox3Icon do
				(
					local theSubOpName = subOp.getName()
					if matchpattern theSubOpName pattern:"*noseed*" then
						FranticParticles.LogProgress ("   >Skipping Icon Sub-Operator - NOSEED Requested via Sub-Operator's Name...")
					else
					(
						FranticParticles.LogProgress ("   >Adjusting Icon Sub-Operator...")
						subOp.random_seed = subOp.random_seed + incrementValue
						FranticParticles.LogProgress ("    +Random Seed in Icon Sub-Operator adjusted by ["+ incrementValue as string +"] to [" + subOp.Random_Seed as string + "].")
					)	
				)				
			)
		)
	)
	

	-- This function increments the partition
	fn IncrementAllPartitionValues incrementValue selectedOnly:false = 
	(
		try(Krakatoa_SeedIncrement_UserFunction incrementValue)catch() --try to call the global function - users can define this function to get notified when seeds change
		global Krakatoa_SeedIncrement_LastValue = incrementValue --set the global variable to the last seed increment.
	
		/*
		--CANNOT SKIP THIS STEP ANYMORE BECAUSE OF DISK CACHE PARTITION NAME SUPPORT
		if incrementValue == 0 then 
		(
			FranticParticles.LogProgress ("-Skipping Random Seeds Adjustment in " + (if selectedOnly then "Selected Objects" else "Scene Objects") + " - Zero Increment Requested." )
			return false
		)
		*/
		
		FranticParticles.LogProgress (">Adjusting Random Seeds in " + (if selectedOnly then "Selected Objects by [" else "Scene Objects by [")+ incrementValue as string + "]..." )
		incrementPositionRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementPositionRandomSeeds"
		incrementSpawnRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementSpawnRandomSeeds"
		incrementSpeedRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementSpeedRandomSeeds"
		incrementRotationRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementRotationRandomSeeds"
		
		incrementFumeFXRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementFumeFXRandomSeeds"
		incrementOtherRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementOtherRandomSeeds"
		incrementLegacyRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementLegacyRandomSeeds"
		incrementThinkingRandomSeeds = FranticParticles.GetBoolProperty "Partition:IncrementThinkingRandomSeeds"

		IncrementBox3Geometry = FranticParticles.GetBoolProperty "Partition:IncrementBox3Geometry"
		IncrementBox3Random= FranticParticles.GetBoolProperty "Partition:IncrementBox3Random"
		IncrementBox3ScalarVector= FranticParticles.GetBoolProperty "Partition:IncrementBox3ScalarVector"
		IncrementBox3Icon= FranticParticles.GetBoolProperty "Partition:IncrementBox3Icon"

		incrementBox3DiskCacheNames = FranticParticles.GetBoolProperty "Partition:IncrementBox3DiskCacheNames"
		
		IncrementPRTModifiers = FranticParticles.GetBoolProperty  "Partition:IncrementPRTModifiers" 
		IncrementGeometryModifiers = FranticParticles.GetBoolProperty  "Partition:IncrementGeometryModifiers" 		
		
		
		FranticParticles.LogProgress ("   *Increment PFlow Position Seeds:                        " + incrementPositionRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment PFlow Spawn Seeds:                           " + incrementSpawnRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment PFlow Speed Seeds:                           " + incrementSpeedRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment PFlow FumeFX Seeds:                          " + incrementFumeFXRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment PFlow Rotation Seeds:                        " + incrementRotationRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment PFlow Other Seeds:                           " + incrementOtherRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment Max Legacy Particles Seeds:                  " + incrementOtherRandomSeeds as string)
		FranticParticles.LogProgress ("   *Increment Thinking Particles Seeds:                    " + incrementOtherRandomSeeds as string)
		FranticParticles.LogProgress ("   " )
		FranticParticles.LogProgress ("   *Increment PFlow Box#3 Geometry Sub-Operators:          " + incrementBox3Geometry as string)
		FranticParticles.LogProgress ("   *Increment PFlow Box#3 Random Sub-Operators:            " + incrementBox3Random as string)
		FranticParticles.LogProgress ("   *Increment PFlow Box#3 Scalar and Vector Sub-Operators: " + incrementBox3ScalarVector as string)
		FranticParticles.LogProgress ("   *Increment PFlow Box#3 Icon Sub-Operators:              " + incrementBox3Icon as string)
		FranticParticles.LogProgress ("   " )
		FranticParticles.LogProgress ("   *Increment PRT Loader Modifiers:                        " + IncrementPRTModifiers as string)
		FranticParticles.LogProgress ("   *Increment Geometry Modifiers:                          " + IncrementGeometryModifiers as string)

		FranticParticles.LogProgress ("   *Increment PFlow Box#3 Disk Cache Filenames:            " + incrementBox3DiskCacheNames as string)
		

		
		local theObjects = if selectedOnly then selection as array else objects as array
		for g in theObjects do 
		(
			case classOf g of
			(
				PF_Source: 
				(
					if not matchPattern (g.name) pattern:"*noseed*" then
					(
						FranticParticles.LogProgress (" >Processing Operators in PFlow Source [" + g.name + "]")
						for j = 1 to g.numActions() do 
						(
							local operator = g.getAction j
							if not matchPattern operator.name pattern:"*noseed*" then
							(
								incrementSeedInPFlowOperator operator incrementValue
							)	
							else
								FranticParticles.LogProgress ("   -Skipping PFlow Operator [" + operator.name + "] - NOSEED Requested via Operator's Name...")
						)--end j loop	
						FranticParticles.LogProgress (" >Processing Events in PFlow Source [" + g.name + "]")
						for i = 1 to g.baseObject.numSubs do 
						(
							local event = g.baseObject[i]
							if matchpattern ((classOf event.object) as string) pattern:"Event" do 
							(
								if not matchPattern (event.name) pattern:"*noseed*" then
								(
									FranticParticles.LogProgress ("  >Processing Operators in PFlow Event [" + event.name + "]")
									for j = 1 to event.numActions() do 
									(
										local operator = event.getAction j
										if not matchPattern operator.name pattern:"*noseed*" then
										(
											incrementSeedInPFlowOperator operator incrementValue
										)	
										else
											FranticParticles.LogProgress ("   -Skipping PFlow Operator [" + operator.name + "] - NOSEED Requested via Operator's Name...")
									)--end j loop
								)
								else	
									FranticParticles.LogProgress ("  -Skipping All Operators in PFlow Event [" + event.name + "] - NOSEED Requested via Event's Name...")
							)--end if event event
						)--end i loop
					)		
					else	
						FranticParticles.LogProgress (" -Skipping All Events in PFlow [" + g.name + "] - NOSEED Requested via PF_Source's Name...")
				)--end pf_source case
				PCloud: (
							if incrementLegacyRandomSeeds then
							(
								if matchPattern (g.name) pattern:"*noseed*" then
									FranticParticles.LogProgress (" -Skipping PCloud [" + g.name + "] - NOSEED requested via Object's Name.")
								else
								(
									FranticParticles.LogProgress (" >Adjusting Random Seed in PCloud [" + g.name + "]")
									g.seed += incrementValue
									FranticParticles.LogProgress ("  +Random Seed in PCloud [" + g.name + "] adjusted by ["+ incrementValue as string +"] to [" + g.seed as string + "].")
								)	
							)	
						)
				Blizzard: (
							if incrementLegacyRandomSeeds then
							(
								if matchPattern (g.name) pattern:"*noseed*" then
									FranticParticles.LogProgress (" -Skipping Blizzard [" + g.name + "] - NOSEED requested via Object's Name.")
								else
								(
									FranticParticles.LogProgress (" >Adjusting Random Seed in Blizzard [" + g.name + "]")
									g.seed += incrementValue
									FranticParticles.LogProgress ("  +Random Seed in Blizzard [" + g.name + "] adjusted by ["+ incrementValue as string +"] to [" + g.seed as string + "].")
								)	
							)	
						)
				PArray: (
							if incrementLegacyRandomSeeds then
							(
								if matchPattern (g.name) pattern:"*noseed*" then
									FranticParticles.LogProgress (" -Skipping PArray [" + g.name + "] - NOSEED requested via Object's Name.")
								else
								(
									FranticParticles.LogProgress (" >Adjusting Random Seed in PArray [" + g.name + "]")
									g.seed += incrementValue
									FranticParticles.LogProgress ("  +Random Seed in PArray [" + g.name + "] adjusted by ["+ incrementValue as string +"] to [" + g.seed as string + "].")
								)	
							)	
						)
				SuperSpray: (
							if incrementLegacyRandomSeeds then
							(
								if matchPattern (g.name) pattern:"*noseed*" then
									FranticParticles.LogProgress (" -Skipping SuperSpray [" + g.name + "] - NOSEED requested via Object's Name.")
								else
								(
									FranticParticles.LogProgress (" >Adjusting Random Seed in SuperSpray [" + g.name + "]")
									g.seed += incrementValue
									FranticParticles.LogProgress ("  +Random Seed in SuperSpray [" + g.name + "] adjusted by ["+ incrementValue as string +"] to [" + g.seed as string + "].")
								)
							)	
						)
				Thinking: (
						if incrementThinkingRandomSeeds then
						(
							if matchPattern (g.name) pattern:"*noseed*" then
								FranticParticles.LogProgress (" -Skipping Thinking Particles [" + g.name + "] - NOSEED requested via Object's Name.")
							else
							(
								local theMD = g.MasterDynamic 
								for ds = 1 to theMD.DynamicSets.count do
								(
									if not matchPattern theMD.DynamicSets[ds].comment pattern:"*NOSEED*" then
									(
										for op = 1 to theMD.DynamicSets[ds].Operators.count do
										(
											theOp = theMD.DynamicSets[ds].Operators[op]
											if isProperty theOp "RandomSeed" do 
											(
												FranticParticles.LogProgress (" >Adjusting Random Seed in TP [" + g.name + "], Dynamic Set "+ ds as string +", Operator "+ op as string+"...")
												theOp.randomSeed += incrementValue
												FranticParticles.LogProgress ("  +Random Seed in TP Operator adjusted by ["+ incrementValue as string +"] to [" + theOp.randomSeed as string + "].")
											)	
										)--end op loop
									)
									else
										FranticParticles.LogProgress (" -Skipping TP [" + g.name + "] DynamicSet - NOSEED requested via DynamicSet's Comment.")
								)--end ds loop
							)--end if not noseed	
						)--end if TP on	
					)--end TP case
					KrakatoaPRTLoader: (
						if IncrementPRTModifiers then
						(
							if matchPattern (g.name) pattern:"*noseed*" then
								FranticParticles.LogProgress (" -Skipping PRT Loader [" + g.name + "] - NOSEED requested via Object's Name.")
							else
							(
								for m in g.modifiers where isProperty m #seed do
								(
									if matchPattern m.name pattern:"*noseed*" then
									(
										FranticParticles.LogProgress (" -Skipping Modifier ["+m as string+"] on [" + g.name + "] - NOSEED requested via Modifier's Name.")
									)
									else
									(
										FranticParticles.LogProgress (" >Adjusting Random Seed in Object [" + g.name + "], Modifier ["+ m as string +"]...")
										m.seed += incrementValue
										FranticParticles.LogProgress ("  +Random Seed in Object adjusted by ["+ incrementValue as string +"] to [" + m.Seed as string + "].")
									)
								)
							)
						)	
					)--end PRT Loader case
					default: (
						if IncrementGeometryModifiers then
						(
							if matchPattern (g.name) pattern:"*noseed*" then
								FranticParticles.LogProgress (" -Skipping Geometry Object [" + g.name + "] - NOSEED requested via Object's Name.")
							else
							(
								for m in g.modifiers where isProperty m #seed do
								(
									if matchPattern m.name pattern:"*noseed*" then
									(
										FranticParticles.LogProgress (" -Skipping Modifier ["+m as string+"] on [" + g.name + "] - NOSEED requested via Modifier's Name.")
									)
									else
									(
										FranticParticles.LogProgress (" >Adjusting Random Seed in Object [" + g.name + "], Modifier ["+ m as string +"]...")
										m.seed += incrementValue
										FranticParticles.LogProgress ("  +Random Seed in Object adjusted by ["+ incrementValue as string +"] to [" + m.Seed as string + "].")
									)
								)
							)
						)	
					)--end default handling of modifiers
			)--end case			
		)--end g loop
		FranticParticles.LogProgress (">Adjusting Random Seeds FINISHED.")
		true
	)--end fn
	
	fn GetFramesString = 
	(
		local ss = stringStream ""
		case rendTimeType of
		(
			1: format "%" (currentTime.frame as integer) to:ss
			2: format "% to %" animationRange.start animationRange.end to:ss
			3: format "% to %" rendStart rendEnd to:ss
			4: format "%" rendPickupFrames to:ss
		)
		ss as string
	)
	
	fn SubmissionSanityCheck = 
	(
		if FranticParticles.GetProperty "ParticleFiles" == "" do (
			messageBox "Please indicate a path to save the particles to." title:"Krakatoa"
			return false
		)
		
		if ddl_deadlinePartitionMode.selection > 1 do
		(
			local firstBirth = FranticParticleRenderMXS.GetEarliestBirthFrame()
			if sliderTime > firstBirth do 
			(
				local str = "3ds Max is going to refresh the particle sources once per partition.\n"
				str += "This may be unnecessary if you change the slider time to frame " + (firstBirth as string) + "\n\n"
				str += "Press [Yes] to change the time slider to frame "+ firstBirth as string+"\n"
				str += "Press [No] to continue on the current frame\n"
				str += "Press [Cancel] to cancel partitioning submission."
				local result = yesNoCancelBox str title:"WARNING!"
				if result== #yes do sliderTime = firstBirth
				if result == #cancel do return false
			)
		)	
		true
	)

	fn getINI theCategory theKey theDefault executeIt:true=
	(
		local result 
		if executeIt then
		(
			result = try(execute (getIniSetting KrakatoaIniPath theCategory theKey))catch(OK)
			if result == OK do result = theDefault
		)
		else 
		(
			result = (getIniSetting KrakatoaIniPath theCategory theKey)
			if result == "" do result = theDefault
		)	
		result
	)		
	
	fn SubmitJob partitionStart partitionEnd partCount partitionMode:#tasks PartitionRange:true timeout:3600 =
	(
		local initialArgs = ""
		
		SMTDSettings.DeadlineSubmissionSuccessful = false
		SMTDSettings.DeadlineSubmissionLastJobID = "failed"
		renderSceneDialog.Commit()

		local TempMaxFile = SMTDPaths.TempDir + maxFileName
		if maxFileName == "" do TempMaxFile += "untitled.max"
		if (doesFileExist TempMaxFile) do deleteFile TempMaxFile
		result = SMTDFunctions.SaveMaxFileCopy TempMaxFile
		if result != undefined do return result
		
		theFrameSequence = ""
		
--SET TASKS IN A SINGLE JOB TO CALCULATE ALL PARTITIONS USING A SCRIPT
		if partitionMode == #tasks do 
		(
			if PartitionRange then
			(	
				for i = partitionStart to partitionEnd-1 do theFrameSequence+= i as string + ","
				theFrameSequence += partitionEnd as string
			)
			else
			(
				for i = 1 to partCount-1 do theFrameSequence+= i as string + ","
				theFrameSequence += partCount as string
			)	
			
			oldMXS = SMTDSettings.SubmitAsMXSJob 
			oldMXSFile = SMTDSettings.MAXScriptFile 
			oldSingleTask = SMTDSettings.SingleTaskJob
			oldWSMode = SMTDSettings.ForceWorkstationMode 
			
			MAXScriptFile	= FranticParticles.KrakatoaHome + "Scripts\\KrakatoaPartitionTasksOnDeadline.ms"
				
			SMTDSettings.SubmitAsMXSJob = true
			SMTDSettings.MAXScriptFile = MAXScriptFile 
			SMTDSettings.SingleTaskJob = true
			SMTDSettings.ForceWorkstationMode = false
				
			if not doesFileExist MAXScriptFile do 
			(
				SMTDSettings.SubmitAsMXSJob = oldMXS 
				SMTDSettings.MAXScriptFile = oldMXSFile 
				SMTDSettings.SingleTaskJob = oldSingleTask 		
				SMTDSettings.ForceWorkstationMode = oldWSMode
				return #PartitionScriptNotFound
			)	
			
		)
--END TASK PER PARTITION
			
		local theOverridePath = FranticParticles.GetProperty "ParticleFiles"
		if ((SMTDFunctions.CreateSubmitInfoFile SMTDPaths.SubmitInfofile customFrameSequence:theFrameSequence customOutputFile:theOverridePath  ) != true) do return #SubmitInfoFileCreationFailed
		if ((SMTDFunctions.CreateJobInfoFile SMTDPaths.JobInfofile renderOutputOverride:theOverridePath ) != true) do return #JobInfoFileCreationFailed
		
		if not doesFileExist SMTDPaths.SubmitInfofile do return #SubmitInfoFileMissing
		if not doesFileExist SMTDPaths.JobInfofile do return #JobInfoFileMissing

		
		initialArgs += "\"" +SMTDPaths.SubmitInfofile + "\" \"" + SMTDPaths.JobInfofile  + "\" \"" + TempMaxFile  + "\" "
		
		if partitionMode == #tasks do 
		(				
			initialArgs += "\"" + MAXScriptFile + "\" "	

			SMTDSettings.SubmitAsMXSJob = oldMXS 
			SMTDSettings.MAXScriptFile = oldMXSFile 
			SMTDSettings.SingleTaskJob = oldSingleTask 		
			SMTDSettings.ForceWorkstationMode = oldWSMode
		)	
		
		local retCode = SMTDFunctions.waitForCommandToComplete initialArgs timeout

		SMTD_LastMessage = SMTDFunctions.getRenderMessage()
		if retCode == #success then
		(
			SMTDSettings.DeadlineSubmissionSuccessful = true
			SMTDFunctions.getJobIDFromMessage SMTD_LastMessage
			try(FF_AssetTracker_Functions.TrackDeadlineRender SMTDSettings.DeadlineSubmissionLastJobID)catch()
		)	
		retCode 
	)		
	
	fn SubmitOnePartitionJobToDeadline partitionStart partitionEnd quiet:false partitionMode:#tasks PartitionRange:true = 
	(
		if( (not quiet) AND (not SubmissionSanityCheck()) ) do
			return false

		-- Save some values that we change temporarily
		local savedRenderTarget = FranticParticles.GetProperty "RenderTarget"
		local savedParticleFiles = FranticParticles.GetProperty "ParticleFiles"	
		local savedJobName = SMTDSettings.jobName
		local savedOOM = SMTDSettings.OutOfOrderMethod
		local savedPreviewJob = SMTDSettings.RenderFramesPreviewJob 
		
		/*ENFORCE SETTINGS! - This is to avoid conflicts with SMTD GUI that might have been opened AFTER Krakatoa and could overwrite these values! */
		try(SMTDSettings.SequentialJob = true)catch() --available sequential rendering in Deadline 2.6 and up only!
		SMTDSettings.LimitEnabled = true --always enabled limit
		SMTDSettings.MachineLimit = getInI "JobSettings" "MachineLimit" SMTDSettings.MachineLimit --set the limit from the INI
		if SMTDSettings.MachineLimit == 0 do SMTDSettings.MachineLimit = 1
		
		SMTDSettings.RenderFramesPreviewJob = false
		SMTDSettings.OutOfOrderMethod = #normal
	
		-- Close the render scene dialog so we can change render properties
		renderSceneDialog.close()
		rendSaveFile = false			
		
		-- Don't want to save xml files for
		FranticParticles.SetProperty "RenderTarget" "Direct Render"
		
		local partitionCount = (FranticParticles.GetIntProperty "Partition:Count")
		if partitionMode == #tasks then
		(
			try(SMTDSettings.MaxTasksPerSlave = getInI "JobSettings" "MaxTasksPerSlave" SMTDSettings.MaxTasksPerSlave )catch()
			try(SMTDSettings.LimitTasksToNumberOfCpus = getInI "JobSettings" "LimitTasksToNumberOfCpus" SMTDSettings.LimitTasksToNumberOfCpus )catch()
			SMTDSettings.ChunkSize = 1
			if ckb_incrementSelectedOnly.checked then
				FranticParticles.SetProperty "Partition:AffectSeedsInObjects" ((for o in selection collect o.name) as string)
			else	
				FranticParticles.SetProperty "Partition:AffectSeedsInObjects" "#()"
			
			if PartitionRange then
			(
				SMTDSettings.jobName = savedJobName + " [RANGE "+(partitionStart as string) + " TO " + partitionEnd as string + " OF " + partitionCount as string +" PARTS] "
				partitionCount = partitionEnd - partitionStart + 1
			)	
			else	
				SMTDSettings.jobName = savedJobName + " ["+(partitionCount as string) + " PARTS] "
		)	
		else
		(
			SMTDSettings.ChunkSize = getInI "JobSettings" "ChunkSize" SMTDSettings.ChunkSize  --set the chunk size from the INI
			try(SMTDSettings.MaxTasksPerSlave = 1)catch()
			SMTDSettings.jobName = savedJobName + " [PART " + (partitionStart as string) + " OF " + (partitionCount as string) + "]"
			local partitionFilename = FranticParticles.MakePartitionFilename savedParticleFiles partitionStart partitionCount
			FranticParticles.SetProperty "ParticleFiles" partitionFilename
		)	
		
		local result = SubmitJob partitionStart partitionEnd partitionCount partitionMode:partitionMode PartitionRange:PartitionRange
			
		-- Restore all the partition values to their original
		FranticParticles.SetProperty "RenderTarget" savedRenderTarget
		FranticParticles.SetProperty "ParticleFiles" savedParticleFiles
		SMTDSettings.jobName = savedJobName
		SMTDSettings.OutOfOrderMethod = savedOOM
		SMTDSettings.RenderFramesPreviewJob = savedPreviewJob
		
		if( not quiet ) do (
			SMTD_LastMessage = SMTDFunctions.getRenderMessage()
			local strstr = SMTD_LastMessage as stringStream
			local txt = ""
			while not eof strstr do 
			(
				local theLine = (readline strstr)
				FranticParticles.LogProgress theLine
				txt += theLine + "\n"
			)	
		
			if( result == #success ) then
			(
				
				theMessage = "Deadline Submission SUCCESSFULL.\n" 
				theMessage += "Partitions Submitted: " + partitionCount as string  + "\n\n"
				theMessage += txt 
				MessageBox  theMessage title:"Krakatoa Deadline Submission"
			)	
			else
			(
				case result of
				(
					#PartitionScriptNotFound: 
					(
						theMessage = "Deadline Submission FAILED!\n\nCould not locate the MAXScript Component\n[KrakatoaPartitionTasksOnDeadline.ms]\n" 
					)	
					#SubmitInfoFileCreationFailed:
					(
						theMessage = "Deadline Submission FAILED!\n\nCould not create Submit Info File.\n" 
					)
					#JobInfoFileCreationFailed:
					(
						theMessage = "Deadline Submission FAILED!\n\nCould not create Job Info File.\n" 
					)
					#SubmitInfoFileMissing:
					(
						theMessage = "Deadline Submission FAILED!\n\nCould not find the Submit Info File.\n" 
					)
					#JobInfoFileMissing:
					(
						theMessage = "Deadline Submission FAILED!\n\nCould not find the Job Info File.\n" 						
					)
					default: 
					(
						theMessage = "Deadline Submission FAILED!\n\n" + txt
					)	
				)	
				MessageBox theMessage title:"Krakatoa Deadline Submission"
			)					
		)
		result == #success
	)
	
	fn checkForMissingUVChannels =
	(
		local activeChannelsSettings = FranticParticles.getProperty "ActiveParticleChannels"
		theFS = filterString activeChannelsSettings ","
		local theActiveChannels = #()
		for i = 1 to theFS.count by 3 do 
			append theActiveChannels theFS[i]
		
		local theChannels = FranticParticleRenderMXS.getSceneMappingChannelsUsed()
		local theMissingChannels = #()
		if theChannels[1] and (findItem theActiveChannels "TextureCoord") == 0 do append theMissingChannels "TextureCoord"
		for c in theChannels where c != 1 do 
		(
			local theName = "Mapping"+c as string
			if (findItem theActiveChannels theName) == 0 do 
				append theMissingChannels theName
		)	
		
		if theMissingChannels.count > 0 then
		(
			txt = "The following UV Channels have been requested via Particle Flow Operators or Box #3 SubOps\nbut are not enabled for saving in the Channels rollout.\n\n"
			for i in theMissingChannels do txt += i + "\n"
			txt +="\nPress YES to add these channels to the list of Channels To Save.\nPress NO to ignore this warning...\n"
			local answer = querybox txt title:"Potentially Missing Texture Channels!"
			if answer then
			(
				for i in theMissingChannels do 
					activeChannelsSettings += ","+ i + ",float32,3"
					
				--if matchPattern activeChannelsSettings pattern:"*," do activeChannelsSettings = substring activeChannelsSettings 1 (activeChannelsSettings.count-1)
				FranticParticles.setProperty "ActiveParticleChannels" activeChannelsSettings
				Krakatoa_GUI_Channels.refresh_GUI()
			)
		)
	)
	
	--on btn_checkForMissingUVChannels pressed do checkForMissingUVChannels()
	
	fn SubmitPartitionJobsToDeadline mode:#all = 
	(
		if( not SubmissionSanityCheck() ) do
			return false

		local partitionCount = (FranticParticles.GetIntProperty "Partition:Count")
		if mode==#all then
		(
			local startPartition = 1
			local endPartition = partitionCount 
			local numberOfPartitionsToProcess = partitionCount
		)
		else	
		(
			local startPartition = spn_PartitionStart.value
			local endPartition = spn_PartitionEnd.value
			local numberOfPartitionsToProcess = endPartition - startPartition + 1
		)		
		
		local partitionRange = spn_PartitionEnd.value - spn_PartitionStart.value + 1
		local theCountString = if mode == #all then 
			(partitionCount as string) 
		else 
			((numberOfPartitionsToProcess as string) + " of " + (partitionCount as string) + " ("+ startPartition as string + " to " + endPartition as string +")")
		local respository = if(SMTDSettings.CurrentRepository == "") then SMTDFunctions.GetNetworkRoot() else SMTDSettings.CurrentRepository
		local statusMsg =	"Submitting " + theCountString + " Partitions to Deadline.\n" +
							"Frames: " + GetFramesString() + "\n" +
							"Repository: " + respository  + "\n" +
							"Machine Limit: " + (SMTDSettings.MachineLimit as string) + "\n" +
							"Enforce Sequential Rendering: " + (SMTDSettings.SequentialJob as string) + "\n" +
							"Filename: " + (FranticParticles.GetProperty "ParticleFiles") + "\n"
		
		local theViewportCamera = viewport.getCamera()
		local oldMultiPassState = false
		if isValidNode theViewportCamera do 
		(
			try
			(
				oldMultiPassState = theViewportCamera.mpassEnabled 
				theViewportCamera.mpassEnabled = false
				if oldMultiPassState do FranticParticles.LogDebug "+Temporarily Disabled Viewport Camera MPass Effects To Avoid Multiple File Saving."
			)
			catch(FranticParticles.LogDebug "--Failed to Disable Viewport Camera MPass Effects To Avoid Multiple File Saving.")
		)			
		
		local partitionProgressCounter = 0
		for partitionNumber = startPartition  to endPartition do 
		(
			partitionProgressCounter+=1
			prg_progress.value = 100.0 * partitionProgressCounter / numberOfPartitionsToProcess 
			statusMsg += "Partition " + (partitionNumber as string) + " of " + (partitionCount as string) + ": "

			IncrementAllPartitionValues (partitionNumber-1) selectedOnly:ckb_incrementSelectedOnly.state
			
			if(SubmitOnePartitionJobToDeadline partitionNumber partitionNumber quiet:true partitionMode:#jobs PartitionRange:false) then 
				statusMsg += "Successfull\n" 
			else 
				statusMsg += "FAILED\n"
			
			IncrementAllPartitionValues -(partitionNumber-1) selectedOnly:ckb_incrementSelectedOnly.state
		)
		prg_progress.value = 0
		if isValidNode theViewportCamera do 
		(
			try
			(
				theViewportCamera.mpassEnabled = oldMultiPassState
				if oldMultiPassState do FranticParticles.LogDebug "+Re-enabled Viewport Camera MPass Effects."
			)
			catch()
		)				
		MessageBox statusMsg title:"Krakatoa Deadline Submission"
		true
	)
	
	fn updateDeadlineControls =
	(
		if FranticParticleRenderMXS.DeadlineDetected == 2 do
		(
			chk_onlypool.state = SMTDSettings.PoolExclusive
			chk_onlypool.enabled = true

			if SMTDSettings.Categories.count == 0 do SMTDFunctions.CollectCategories()
			ddl_category.items = SMTDSettings.Categories
			local theIndex = findItem SMTDSettings.Categories SMTDSettings.Category
			if theIndex == 0 then theIndex = 1
			ddl_category.selection = theIndex
			btn_openDeadlineMonitor.caption = "Open Deadline Monitor 2.x..."
			lbl_category.caption = "Category:"
		)
		if FranticParticleRenderMXS.DeadlineDetected == 3 do 
		(
			chk_onlypool.enabled = chk_onlypool.state = false
			try
			(
				if SMTDSettings.Groups.count == 0 do SMTDFunctions.CollectGroups()
				ddl_category.items = SMTDSettings.Groups
				local theIndex = findItem SMTDSettings.Groups SMTDSettings.Group
				if theIndex == 0 then theIndex = 1
				ddl_category.selection = theIndex
			)catch()	
			btn_openDeadlineMonitor.caption = "Open Deadline Monitor 3 or higher..."
			lbl_category.caption = "    Group:"
		)				
	)

	fn checkForDeadlineVersionMismatch =
	(
		if FranticParticleRenderMXS.DeadlineDetected == 2 and isProperty SMTDPaths #homedir then
		(
			local txt = "Deadline 2.x was requested in Preferences, but\nDeadline 3 or higher Function Libraries were found in memory!\n\n" 
			txt += "Most probably a Submit Max To Deadline script was launched after the initialization of Krakatoa.\n\n"
			txt += "Therefore, Krakatoa has been switched to Deadline 3 or higher Submission mode.\n\n"
			txt += "To enforce Deadline 2.x submission, either go to the Preferences rollout and press Detect Deadline Now\n"
			txt += "or launch the Submit Max To Deadline 2.7 script manually to reload the Function Libraries."
			messagebox txt title:"Deadline Version Mismatch!"
			FranticParticleRenderMXS.DeadlineDetected = 3
			updateDeadlineControls()
			false
		)
		else
		(
			if FranticParticleRenderMXS.DeadlineDetected == 3 and not isProperty SMTDPaths #homedir then
			(
				local txt = "Deadline 3 or higher was requested in Preferences, but\nDeadline 2.x Function Libraries were found in memory!\n\n" 
				txt += "Most probably a Submit Max To Deadline script was launched after the initialization of Krakatoa.\n\n"
				txt += "Therefore, Krakatoa has been switched to Deadline 2.x Submission mode.\n\n"
				txt += "To enforce Deadline 3 or higher submission, either go to the Preferences rollout and press Detect Deadline Now\n"
				txt += "or launch the Submit Max To Deadline 3 script manually to reload the Function Libraries."
				messagebox txt title:"Deadline Version Mismatch!"
				FranticParticleRenderMXS.DeadlineDetected = 2
				updateDeadlineControls()
				false
			)
			else
				true
		)
	)			
	
	fn refresh_GUI =
	(
		--FranticParticleRenderMXS.DeadlineDetected = 0  --force to no deadline for debugging purposes
		
		oldState = try(FranticParticles.GetBoolProperty "GUI:ParticlePartitioningRolloutOpen")catch(false)
		Krakatoa_GUI_Partition.open = oldState
		
		local enableSaveParticleFileControls = (FranticParticles.GetProperty "ParticleMode") == "Save Particles To File Sequence"
		
		spn_partitionCount.value = FranticParticles.GetIntProperty "Partition:Count"
		spn_PartitionStart.range = [1,spn_partitionCount.value,spn_PartitionStart.value]
		spn_PartitionEnd.range = [1,spn_partitionCount.value,spn_PartitionEnd.value]
		
		ckb_incrementPositionRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementPositionRandomSeeds"
		ckb_incrementSpawnRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementSpawnRandomSeeds"
		ckb_incrementSpeedRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementSpeedRandomSeeds"
		ckb_incrementRotationRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementRotationRandomSeeds"
		
		ckb_incrementFumeFXRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementFumeFXRandomSeeds"
		ckb_incrementOtherRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementOtherRandomSeeds"
		ckb_incrementLegacyRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementLegacyRandomSeeds"
		ckb_incrementThinkingRandomSeeds.checked = FranticParticles.GetBoolProperty "Partition:IncrementThinkingRandomSeeds"
		
		ckb_incrementBox3Geometry.checked = FranticParticles.GetBoolProperty "Partition:IncrementBox3Geometry" 
		ckb_incrementBox3Random.checked = FranticParticles.GetBoolProperty "Partition:IncrementBox3Random" 
		ckb_incrementBox3ScalarVector.checked = FranticParticles.GetBoolProperty "Partition:IncrementBox3ScalarVector" 
		ckb_incrementBox3Icon.checked = FranticParticles.GetBoolProperty "Partition:IncrementBox3Icon" 
		
		ckb_incrementPRTModifiers.checked = FranticParticles.GetBoolProperty "Partition:IncrementPRTModifiers"  
		ckb_incrementGeometryModifiers.checked = FranticParticles.GetBoolProperty "Partition:IncrementGeometryModifiers"  

		ckb_incrementBox3DiskCaches.state =  FranticParticles.GetBoolProperty "Partition:IncrementBox3DiskCacheNames"
		
		ckb_incrementSelectedOnly.checked = FranticParticles.GetBoolProperty "Partition:IncrementSelectedOnly"
		ckb_skipExistingFiles.checked = FranticParticles.GetBoolProperty "Partition:skipExistingFiles" 

		btn_openDeadlineMonitor.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableSaveParticleFileControls
		btn_submitPartitionJobs.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableSaveParticleFileControls
		btn_submitCustomPartition.enabled =  FranticParticleRenderMXS.DeadlineDetected > 0 and enableSaveParticleFileControls
		
		ckb_skipExistingFiles.enabled = btn_saveCurrentPartitionLocally.enabled = ckb_incrementSelectedOnly.enabled = btn_savePartitionsLocally.enabled = enableSaveParticleFileControls 
		ckb_incrementBox3DiskCaches.enabled = ckb_incrementLegacyRandomSeeds.enabled = ckb_incrementThinkingRandomSeeds.enabled = ckb_incrementRotationRandomSeeds.enabled = ckb_incrementFumeFXRandomSeeds.enabled = ckb_incrementOtherRandomSeeds.enabled = ckb_incrementPositionRandomSeeds.enabled = ckb_incrementSpawnRandomSeeds.enabled = ckb_incrementSpeedRandomSeeds.enabled = enableSaveParticleFileControls 
		ckb_incrementBox3Geometry.enabled = ckb_incrementBox3Random.enabled = ckb_incrementBox3ScalarVector.enabled = ckb_incrementBox3Icon.enabled = enableSaveParticleFileControls 
		spn_partitionCount.enabled = spn_PartitionStart.enabled = spn_PartitionEnd.enabled = enableSaveParticleFileControls 
		spn_MaxTasksPerSlave.enabled = chk_LimitTasksToNumberOfCpus.enabled = enableSaveParticleFileControls 

		
		if FranticParticleRenderMXS.DeadlineDetected > 0 then
		(
			--Overwrite some settings using the Krakatoa settings INI file:
			if FranticParticleRenderMXS.DeadlineDetected == 2 then
			(
				SMTDSettings.PoolExclusive = getInI "JobSettings" "PoolExclusive" SMTDSettings.PoolExclusive
			)	
			
			SMTDSettings.Priority = getInI "JobSettings" "Priority" SMTDSettings.Priority
			SMTDSettings.PoolName = getInI "JobSettings" "PoolName" SMTDSettings.PoolName executeIt:false
			SMTDSettings.Category = getInI "JobSettings" "Category" SMTDSettings.Category executeIt:false
			
			if SMTDSettings.Pools.count == 0 do SMTDFunctions.CollectPools()
			displayPoolsList()
			
			job_priority_update SMTDSettings.Priority
			
			local defaultMode = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineJobNameSource"
			if defaultMode == "SavePath" then 
				jobNameFromSavePath()
			else	
				jobNameFromMaxName()
		
			local defaultMode = getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaDeadlineSettings.ini") "Default" "DeadlineCommentSource"
			if defaultMode == "SavePath" then CommentFromSavePath() else defaultComment()
			
			edt_user.text = SMTDFunctions.GetDeadlineUser()
			SMTDSettings.UserName = edt_user.text
			
			edt_dept.text = SMTDSettings.Department
			
			spn_chunkSize.value = getInI "JobSettings" "ChunkSize" SMTDSettings.ChunkSize 
			
			if SMTDSettings.MachineLimit == 0 do SMTDSettings.MachineLimit = 1
			spn_machineLimit.value = getInI "JobSettings" "MachineLimit" SMTDSettings.MachineLimit
			
			ddl_deadlinePartitionMode.selection = getIni "JobSettings" "DeadlinePartitionMode" 1
			
			try(
				spn_MaxTasksPerSlave.value = getIni "JobSettings"  "MaxTasksPerSlave" SMTDSettings.MaxTasksPerSlave 
				chk_LimitTasksToNumberOfCpus.checked = getIni "JobSettings"  "LimitTasksToNumberOfCpus" SMTDSettings.LimitTasksToNumberOfCpus 
			)catch()
			
			ddl_deadlinePartitionMode.visible = spn_MaxTasksPerSlave.visible = chk_LimitTasksToNumberOfCpus.visible = true
			edt_jobname.visible = btn_getJobNameMenu.visible = btn_getCommentMenu.visible = edt_comment.visible = edt_user.visible = edt_dept.visible = ddl_category.visible = true
			lbl_pools.visible = ddl_poollist.visible = chk_onlypool.visible = sld_priority.visible = spn_priority.visible = true
			spn_machineLimit.visible = spn_chunkSize.visible = lbl_category.visible = true
			lbl_priority.visible = false
			
			lbl_getDeadline01.visible = lbl_getDeadline02.visible = lbl_getDeadline03.visible = lbl_getDeadline04.visible = url_getDeadline01.visible = false 
			
			btn_getJobNameMenu.enabled = btn_getCommentMenu.enabled = edt_jobname.enabled = edt_comment.enabled= edt_user.enabled= edt_dept.enabled= ddl_category.enabled= enableSaveParticleFileControls 
			lbl_pools.enabled= ddl_poollist.enabled= chk_onlypool.enabled= sld_priority.enabled= spn_priority.enabled= enableSaveParticleFileControls 
			spn_machineLimit.enabled = lbl_category.enabled= enableSaveParticleFileControls 
			lbl_priority.enabled= enableSaveParticleFileControls 
			lbl_getDeadline01.enabled= lbl_getDeadline02.enabled= lbl_getDeadline03.enabled= lbl_getDeadline04.enabled= url_getDeadline01.enabled= enableSaveParticleFileControls 
			ddl_deadlinePartitionMode.enabled = enableSaveParticleFileControls 
			deadline27installed =try(isProperty SMTDSettings "LimitTasksToNumberOfCpus")catch(false)
			spn_MaxTasksPerSlave.enabled = chk_LimitTasksToNumberOfCpus.enabled = (((getIni "JobSettings" "DeadlinePartitionMode" 1) == 1) AND deadline27installed AND enableSaveParticleFileControls ) 
			spn_chunkSize.enabled= (getIni "JobSettings" "DeadlinePartitionMode" 1) != 1
			
		)	
		else
		(
			ddl_deadlinePartitionMode.enabled = spn_MaxTasksPerSlave.visible = chk_LimitTasksToNumberOfCpus.visible = false
			edt_jobname.visible = btn_getJobNameMenu.visible = btn_getCommentMenu.visible = edt_comment.visible = edt_user.visible = edt_dept.visible = ddl_category.visible = false
			lbl_pools.visible = ddl_poollist.visible = chk_onlypool.visible = sld_priority.visible = spn_priority.visible = false
			spn_machineLimit.visible = spn_chunkSize.visible = lbl_category.visible = false
			lbl_priority.visible = false
			lbl_getDeadline01.visible = lbl_getDeadline02.visible = lbl_getDeadline03.visible = lbl_getDeadline04.visible = url_getDeadline01.visible = true 
		)
	)
	
	on ckb_incrementSelectedOnly changed state do FranticParticles.SetProperty "Partition:IncrementSelectedOnly" (state as string)
	on ckb_incrementBox3DiskCaches changed state do FranticParticles.SetProperty "Partition:IncrementBox3DiskCacheNames" (state as string)
	
	on ddl_deadlinePartitionMode selected itm do 
	(
		setIniSetting KrakatoaIniPath  "JobSettings"  "DeadlinePartitionMode" (itm as string) 
		Refresh_GUI()
	)	
	
	on Krakatoa_GUI_Partition rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ParticlePartitioningRolloutOpen" val
		if val then 
		(
			FranticParticles.LogDebug ("+Particle Partitioning Rollout ROLLED DOWN.")
			updateDeadlineControls()						
			checkForDeadlineVersionMismatch()
		)	
		else
			FranticParticles.LogDebug ("+Particle Partitioning Rollout ROLLED UP.")
	)	

	on spn_partitionCount changed val do 
	(
		FranticParticles.SetProperty "Partition:Count" val
		spn_PartitionStart.range = [1,val,spn_PartitionStart.value]
		spn_PartitionEnd.range = [1,val,spn_PartitionEnd.value]
	)	
	
	on spn_PartitionStart changed val do 
	(
		if spn_PartitionEnd.value < val do spn_PartitionEnd.value = val
	)
	
	on spn_PartitionEnd changed val do 
	(
		if spn_PartitionStart.value > val do spn_PartitionStart.value = val
	)
	
	
	fn savePartitionsLocally mode:#all=
	(
		FranticParticles.LogProgress ">Starting Local Partitions Saving..."
		local oldescapeEnabled = escapeEnabled 
		local oldSaveHistory = Krakatoa_GUI_Presets.chk_SaveRenderHistory.state
		local savedParticleFiles = FranticParticles.GetProperty "ParticleFiles"	
		Krakatoa_GUI_Presets.chk_SaveRenderHistory.state = false
		renderSceneDialog.close()
		local currentSequence = #()
		case rendTimeType of
		(
			1: (
					currentSequence = #(sliderTime.frame as integer) 
				)
			2: (
					currentSequence = for t in animationRange.start to animationRange.end by rendNthFrame collect (t.frame as integer)
				)
			3: (
					currentSequence = for t in rendStart to rendEnd by rendNthFrame collect (t.frame as integer)
				)
			4: (
					theFS = filterString rendPickupFrames "-"
					local txt = "#{"
					for i = 1 to theFS.count-1 do txt += theFS[i]+ ".."
					txt += theFS[theFS.count] + "}"
					currentSequence = (execute txt) as array
				)	
		)
		
		if currentSequence.count == 1 do 
		(
			local txt = ("You have set Krakatoa to Partition FRAME "+ currentSequence[1] as string +" ONLY!\n") 
			txt += "Note that Particle Flow would not update seeds correctly if saving a single frame,\n"
			txt += "so if you click [Yes], two frames - "+ currentSequence[1] as string + " and "+ (currentSequence[1]+1) as string +" will be saved instead.\n"
			txt += "\nClick [Yes] to use frames " +currentSequence[1] as string + " and "+ (currentSequence[1]+1) as string +" only\n"
			txt += "Click [No] to use the current scene range from "+ (animationRange.start.frame as integer) as string + " to "+ (animationRange.end.frame as integer) as string +" instead.\n"
			txt += "Click [Cancel] to abort Partitioning and change your settings."
			local q = yesNoCancelBox txt title:"KRAKATOA: Single Frame Partitioning"
			if q == #yes do append currentSequence (currentSequence[1]+1)
			if q == #no do currentSequence = for t in animationRange.start to animationRange.end by rendNthFrame collect (t.frame as integer)
			if q == #cancel do return ""
		)	
		
		escapeEnabled = false
		local wasCancelled  = false
		local partitionCount = (FranticParticles.GetIntProperty "Partition:Count")
		
		if mode==#all then
		(
			local startPartition = 1
			local endPartition = partitionCount 
			local numberOfPartitionsToProcess = partitionCount
		)
		else	
		(
			local startPartition = spn_PartitionStart.value
			local endPartition = spn_PartitionEnd.value
			local numberOfPartitionsToProcess = endPartition - startPartition + 1
		)
		
		local theBaseFullFileName = (FranticParticles.GetProperty "ParticleFiles")
		local theBasePath = getFileNamePath theBaseFullFileName
		local theBaseFilename = getFileNameFile theBaseFullFileName
		local theBaseFileExt = getFileNameType theBaseFullFileName
		if theBaseFileExt == "" do theBaseFileExt = ".prt"
		
		local totalNumberOfFrames = currentSequence.count * numberOfPartitionsToProcess 
		local framesSoFar = 0
		local lastFrameTime = 0
		local deleteExistingFiles = #prompt
		local ETAstartTime = timestamp()
	
		local theZeroCount = 4
		if matchPattern theBaseFileExt pattern:".bin" do theZeroCount = 5
		
		
		if theBaseFileName.count > 0 then 
		(
			--if the viewport is a camera view, remember its old mpass state and disable mpass effects
			local theViewportCamera = viewport.getCamera()
			local oldMultiPassState = false
			if isValidNode theViewportCamera do 
			(
				try
				(
					oldMultiPassState = theViewportCamera.mpassEnabled 
					theViewportCamera.mpassEnabled = false
					if oldMultiPassState do FranticParticles.LogDebug "+Temporarily Disabled Viewport Camera MPass Effects To Avoid Multiple File Saving."
				)catch(FranticParticles.LogDebug "--Failed to Disable Viewport Camera MPass Effects To Avoid Multiple File Saving.")	
			)				
			local partitionProgressCounter = 0
			for partitionNumber = startPartition  to endPartition do 
			(
				partitionProgressCounter += 1
				st = timestamp()
				theFilesToBackup = #()
				prg_progress.value = 100.0 * partitionProgressCounter / numberOfPartitionsToProcess 
				if matchpattern theBaseFilename pattern:"*part*of*" then
				(
					theIndex = 0
					for i = theBaseFilename.count-4 to 1 by -1 do 
					(
						if substring theBaseFilename i 5 == "_part" then
						(
							theIndex = i
							exit
						)	
					)
					theBaseFilename = substring theBaseFilename 1 (theIndex-1) 
				)
				IncrementAllPartitionValues (partitionNumber-1) selectedOnly:ckb_incrementSelectedOnly.state
				local partitionFilename = FranticParticles.MakePartitionFilename (theBasePath + theBaseFilename) partitionNumber partitionCount
				partitionFilename = partitionFilename + theBaseFileExt
				FranticParticles.SetProperty "ParticleFiles" partitionFilename
				
				theTotalCount = currentSequence.count 
				FranticParticles.LogProgress (localtime + " : Starting Partition "+ partitionNumber as string + " with " + theTotalCount  as string + " Frames...")
				cnt = 0
				local wasCancelled = false
				
				for t  in currentSequence do
				(
					st1 = timestamp()
					cnt += 1
					framesSoFar += 1
					prg_partprogress.value = ( 100.0 * cnt/theTotalCount)
					local timeSoFar = (timestamp() - ETAstartTime) * 0.001
					local eta =  timeSoFar / framesSoFar  *  (totalNumberOfFrames - framesSoFar)
					lbl_progress01.text = "Partition:" +  partitionNumber as string+ " ("+ (partitionNumber - startPartition + 1) as string + "/"+(endPartition - startPartition + 1) as string  + ") - Range:"+startPartition  as string +" to "+ endPartition as string + " - Frame:" + t as string + " ("+ cnt as string+ "/" + theTotalCount as string +") - Total Frames:" + framesSoFar as string + " of " + totalNumberOfFrames as string + ", " + (totalNumberOfFrames - framesSoFar) as string +" left."
					lbl_progress02.text = "Last Frame:" + (FranticParticleRenderMXS.convertToHMS lastFrameTime)+ " - Elapsed:"+ (FranticParticleRenderMXS.convertToHMS timeSoFar) as string +" - Remaining:" + (FranticParticleRenderMXS.convertToHMS eta) as string +" - Press Esc To Cancel."
					
					local goOn = true

					checkFilename = FranticParticles.ReplaceSequenceNumber partitionFilename t
					if ckb_skipExistingFiles.checked then
					(
						goOn = not (doesFileExist checkFilename)
					)	
					else
					(
						if deleteExistingFiles == #delete  do deleteFile checkFilename 
						if deleteExistingFiles == #prompt and doesFileExist checkFilename do 
						(
							local theYNC = yesNoCancelBox ("The Particle File \n[" + checkFilename + "]\n already exists.\n\nPress [Yes] if you want to overwrite this file AND ANY OTHER FILES that might exist in the partition.\nPress [No] to get prompted for EACH existing file.\nPress [Cancel] to cancel the partitioning!") title:"Krakatoa Partitioning: Overwrite Existing Files?"
							if theYNC == #cancel do 
							(
								goOn = false
								wasCancelled = true
								FranticParticles.LogProgress  ("-Local Partition Creation Canceled by User")
								exit
							)	
							if theYNC == #yes do 
							(
								deleteFile  checkFilename 
								deleteExistingFiles = #delete
							)
							if theYNC == #no do deleteExistingFiles = #defaultprompt
						)
					)	
					
					if goOn then
					(
						append theFilesToBackup checkFilename
						Krakatoa_IsRendering = true
						render fromFrame:t toFrame:t vfb:off cancelled:&wasCancelled --progress:true
						Krakatoa_IsRendering = false	
						lastFrameTime = (timestamp() - st1)/1000.0
						FranticParticles.LogProgress ("Partition " + partitionNumber as string +" Frame "+ (t as integer) as string +" Time: "+ FranticParticleRenderMXS.convertToHMS lastFrameTime) --output the frame duration
					)	
					else
						FranticParticles.LogProgress ("Partition " + partitionNumber as string +" Frame "+ (t as integer) as string +" Skipped - File Already Exists...") 
					
					if wasCancelled do 
					(
						FranticParticles.LogProgress  ("- "+localtime + " : Local Partition Creation Canceled by User in Partition " + partitionNumber as string + " Frame " + t as string)
						exit		
					)		
					options.showGCStatus = false
					gc light:true				
					options.showGCStatus = true	
				)--end t loop
				FranticParticles.LogProgress "Decrementing Seeds..."
				IncrementAllPartitionValues -(partitionNumber-1) selectedOnly:ckb_incrementSelectedOnly.state
				FranticParticles.SetProperty "ParticleFiles" savedParticleFiles 
				if not wasCancelled do 
					FranticParticles.LogProgress (localtime + " : Finished Partition "+ partitionNumber as string +" in "+ FranticParticleRenderMXS.convertToHMS ((timestamp() - st)/1000.0)) --output the task duration
				
				local theVal = execute (FranticParticles.GetProperty "Partition:BackupRootMode")
				if theVal == OK do theVal = 1
				if theVal > 1 do
				(
					local q = if wasCancelled then
						querybox ("Local Partitioning was cancelled, but a backup operation has been requested.\n\nClick [YES] to perform the Backup.\nClick [NO] to skip Backup and exit.") title:"Krakatoa: Cancel Backup Too?"
					else
						true	
					
					if q then 
					(
						FranticParticles.LogProgress (#("","COPY","MOVING")[theVal] +" of local partition files to backup directory requested!")
						local theBackupPath = Krakatoa_GUI_SaveParticles.getFilenameFromBackupRoot()
						makeDir theBackupPath all:true
						if doesFileExist theBackupPath then
						(
							FranticParticles.LogProgress ("+Backup Path [" + theBackupPath + "] is VALID.")
							local cnt = 0
							prg_partprogress.color = green
							for f in theFilesToBackup do
							(
								cnt += 1
								prg_partprogress.value = ( 100.0 * cnt/theFilesToBackup.count)
								local targetFile = (theBackupPath + fileNameFromPath f)
								lbl_progress01.text = #("","COPYING","MOVING")[theVal] + " " + filenameFromPath f
								lbl_progress02.text = "to " + theBackupPath 
								if doesFileExist targetFile do deleteFile targetFile 
								local result = copyFile f targetFile 
								if result == true then
								(
									if theVal == 3 do deleteFile f
									FranticParticles.LogProgress ("+" + #("","COPIED","MOVED")[theVal] +" ["+ f + "] to ["+ targetFile +"].")
								)	
								else
									FranticParticles.LogProgress ("--FAILED to " + #("","copy","move")[theVal] +" ["+ f + "] to ["+ targetFile +"].")
							)--end f loop
							prg_partprogress.color = red
						)
						else
							FranticParticles.LogProgress ("--Backup Path [" + theBackupPath + "] is not accessible.")
					)
					else		
						FranticParticles.LogProgress ("--User requested no backup.")
				)--end backup
				if wasCancelled do exit
			)--end partition loop
			prg_progress.value = 0
			prg_partprogress.value = 0
			if isValidNode theViewportCamera do --if the viewport is a camera and it haf mpass enabled, restore it
			(
				try
				(
					theViewportCamera.mpassEnabled = oldMultiPassState 
					if oldMultiPassState do FranticParticles.LogDebug "+Re-enabled Viewport Camera MPass Effects."
				)
				catch()
			)				
		)
		else
			messagebox "No Save Name Specified, Cannot Create Partitions!" title:"Krakatoa Partitions"
		--rendTimeType = oldRendTimeType
		--escapeEnabled = oldescapeEnabled
		Krakatoa_GUI_Presets.chk_SaveRenderHistory.state = oldSaveHistory 
		lbl_progress01.text = lbl_progress02.text = ""
	)	

	on btn_savePartitionsLocally pressed do 
	(
		checkForMissingUVChannels()
		savePartitionsLocally mode:#all
	)	
	on btn_saveCurrentPartitionLocally pressed do 
	(
		checkForMissingUVChannels()
		savePartitionsLocally mode:#one
	)	
	on ckb_skipExistingFiles changed state do FranticParticles.SetProperty "Partition:skipExistingFiles" (state as string)
	
	on ckb_incrementPositionRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementPositionRandomSeeds" state
	on ckb_incrementSpawnRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementSpawnRandomSeeds" state
	on ckb_incrementSpeedRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementSpeedRandomSeeds" state

	on ckb_incrementRotationRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementRotationRandomSeeds" state
	on ckb_incrementFumeFXRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementFumeFXRandomSeeds" state
	on ckb_incrementOtherRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementOtherRandomSeeds" state
	on ckb_incrementLegacyRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementLegacyRandomSeeds" state
	on ckb_incrementThinkingRandomSeeds changed state do FranticParticles.SetProperty "Partition:IncrementThinkingRandomSeeds" state
	
	on ckb_incrementBox3Geometry changed state do FranticParticles.SetProperty "Partition:IncrementBox3Geometry" state
	on ckb_incrementBox3Random changed state do FranticParticles.SetProperty "Partition:IncrementBox3Random" state
	on ckb_incrementBox3ScalarVector changed state do FranticParticles.SetProperty "Partition:IncrementBox3ScalarVector" state
	on ckb_incrementBox3Icon changed state do FranticParticles.SetProperty "Partition:IncrementBox3Icon" state		
		
	on ckb_incrementPRTModifiers changed state do FranticParticles.SetProperty "Partition:IncrementPRTModifiers" state
	on ckb_incrementGeometryModifiers changed state do FranticParticles.SetProperty "Partition:IncrementGeometryModifiers"  state
	
	on btn_submitPartitionJobs pressed do 
	(
		if checkForDeadlineVersionMismatch() then
		(
			checkForMissingUVChannels()
			--SetAllFilePartitionCounts (FranticParticles.GetIntProperty "Partition:Count")
			if ddl_deadlinePartitionMode.selection == 1 then
			(
				(SubmitOnePartitionJobToDeadline 2 spn_PartitionCount.value quiet:false partitionMode:#tasks PartitionRange:false)
			)
			else
				SubmitPartitionJobsToDeadline mode:#all
		)	
	)
	
	on btn_submitCustomPartition pressed do 
	(
		if checkForDeadlineVersionMismatch() then
		(
			checkForMissingUVChannels()
			if ddl_deadlinePartitionMode.selection == 1 then
			(
				(SubmitOnePartitionJobToDeadline spn_PartitionStart.value spn_PartitionEnd.value quiet:false partitionMode:#tasks PartitionRange:true)
			)
			else
				SubmitPartitionJobsToDeadline mode:#range
		)	
	)

	on Krakatoa_GUI_Partition close do 
	(
		if Krakatoa_GUI_Partition.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Partition.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Partition open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Partition.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		FranticParticleRenderMXS.DetectDeadline forceloading:false
		Refresh_GUI()
		FranticParticles.LogDebug ("+Partitioning Rollout OPENED.")			
	)			
)--end rollout


rollout Krakatoa_GUI_Shadows "Shadows On Geometry" rolledup:true category:90 width:457
(
	button btn_LoadSave_Shadows "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_Shadows "Open Krakatoa Online Help..." width:408 height:14 offset:[0,-5] align:#center 
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on Krakatoa_GUI_Shadows pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Shadows
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on Krakatoa_GUI_Shadows rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Shadows
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)		
	
	on btn_Help_Shadows pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/shadows_on_geometry.php" ""	

	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Shadows
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Shadows
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)			

	on Krakatoa_GUI_Shadows moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Shadows.title (pos as string)
	)	

	checkbutton chk_enableAttenuationMapSaving ">Save Attenuation Maps When Rendering" width:214 align:#left across:2 highlightcolor:KrakatoaSkinColorsStruct.Shadows
	button btn_runShadowUtility "Open Krakatoa Shadows Utility..." width:214 align:#right enabled:true 
	
	on btn_runShadowUtility pressed do 
		try(macros.run "Krakatoa" "KrakatoaShadows")catch(messagebox ("Failed To Locate Krakatoa Shadows Utility: " + getCurrentException()) title:"Krakatoa Error" )
		
	fn refresh_GUI =
	(
		chk_enableAttenuationMapSaving.state = FranticParticles.GetBoolProperty "EnableAttenuationMapSaving"
		Krakatoa_GUI_Shadows.open = FranticParticles.GetBoolProperty "GUI:ShadowsRolloutOpen" 
	)
	
	on chk_enableAttenuationMapSaving changed state do
	(
		FranticParticles.SetProperty "EnableAttenuationMapSaving" (state as string)
		try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	)	

	on chk_enableAttenuationMapSaving rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "EnableAttenuationMapSaving" ">Save Attenuation Maps When Rendering"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)	
	
	on Krakatoa_GUI_Shadows rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:ShadowsRolloutOpen" val
			if val then 
				FranticParticles.LogDebug ("+Shadows On Geometry Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Shadows On Geometry Rollout ROLLED UP.")
	)	
	
	on Krakatoa_GUI_Shadows close do 
	(
		if Krakatoa_GUI_Shadows.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Shadows.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Shadows open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Shadows.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Shadows On Geometry Rollout OPENED.")			
	)			
)
-------------------------------------- 
--PREFERENCES ROLLOUT	
-------------------------------------- 
rollout Krakatoa_GUI_Preferences "Preferences" rolledup:true category:110 width:457
(
	button btn_Help_Preferences "Open Krakatoa Online Help..." width:430 height:14 offset:[-10,-5] align:#left across:2
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_Help_Preferences pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/preferences.php" ""		
	
	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_Preferences
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_Preferences
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)		

	on Krakatoa_GUI_Preferences moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_Preferences.title (pos as string)
	)			

	group "Authorization"
	(
		button btn_getLicense "Acquire License..." width:214 across:2 align:#left  tooltip:"Attempts to acquire a license and switch Krakatoa to production mode, removing the Watermark from rendered images."
		button btn_releaseLicense "Release License (Evaluation Mode)" width:214 align:#right tooltip:"Releases the license and switches Krakatoa to Evaluation Mode - rendered images will have a Watermark."
	)
	
	group "Performance"
	(
		label lbl_sortingMethod "Particle Sorting Multi-threading Settings: " align:#left across:2 offset:[26,0]
		dropdownlist ddl_sortingThreads items:#("Use All CPUs ("+sysinfo.cpucount as string+")","Sort Using 1 Thread","Sort Using 2 Threads","Sort Using 4 Threads","Sort Using 8 Threads","Sort Using 16 Threads") width:214 align:#right offset:[0,-3]
	)

	group "Factory and User-Defined Startup Defaults "
	(
		button btn_SaveDefaults "Save Current Settings As User Defaults..." width:214 tooltip:"Store Current Settings as Initial Defaults for future Krakatoa Sessions." align:#left across:2
		button btn_ResetFactoryDefaults "Revert To Factory Defaults..." width:214 tooltip:"Remove Custom Settings and Restore Factory Defaults for future Krakatoa Sessions." align:#right

		checkbutton chk_UsePRTPreset ">Apply Preset To New PRT Loaders:" width:214 tooltip:"Store Current Settings as Initial Defaults for future Krakatoa Sessions." align:#left across:2 highlightcolor:KrakatoaSkinColorsStruct.Preferences
		dropdownlist ddl_PRTpresets items:#("") width:214 align:#right offset:[0,0] 

		checkbutton chk_LoadVFBExtensions ">Load 3ds Max 2009+ VFB Extensions On Startup" width:430 tooltip:"Load 3ds Max 2009 and higher Virtual Frame Buffer Extensions for Krakatoa." align:#center highlightcolor:KrakatoaSkinColorsStruct.Preferences enabled:false --((maxVersion())[1] > 10900)
	)
	
	group "Log Window"	
	(
		checkbutton chk_AutoOpenLogOnOutput ">Auto-Open Log Window On Output" width:214 across:2 align:#left highlightcolor:KrakatoaSkinColorsStruct.Preferences
		button btn_OpenLogWindow "Open The Log Window Now!" width:214 align:#right
	)	
	
	group "Particle Flow Systems"
	(
		checkbutton chk_autoincreasePflowSystemLimit ">Auto-Increase PFlow System Limit" width:214 across:2 align:#left tooltip:"By default, Particle Flow Systems are limited to only 100K particles. To work well with Krakatoa, the limit should be increased. Enable this checkbutton to increase the limit automatically." highlightcolor:KrakatoaSkinColorsStruct.Preferences
		button btn_increasePflowSystemLimit "Increase PFlow System Limit Now!" width:214 align:#right tooltip:"By default, Particle Flow Systems are limited to only 100K particles. To work well with Krakatoa, the limit should be increased. Press this button to increase the limit now."
	)
	
	group "Deadline Detection and Integration"
	(
		dropdownlist ddl_useDeadlineVersion items:#("Do Not Detect Deadline","Use Deadline 2.x","Use Deadline 3 or higher") width:214 across:2 align:#left 
		button btn_detectDeadlineNow "Detect Deadline Now!" width:214 align:#right tooltip:"Search for Deadline installations..."
	)
	
	group "User-Defined UI Behaviors"	
	(
		button btn_beginnerSettings "BEGINNER" width:140 across:3 align:#left
		button btn_advancedSettings "ADVANCED" width:140  align:#center
		button btn_expertSettings "EXPERT" width:140 align:#right
		
		dropdownlist ddl_blendedModeSwitch "When switching to and from 'Blended Z-Depth' or 'Blended Camera Distance' Color Mode," items:#("Warn Me About Changing '>Use Lights' And '>Post-Divide By Alpha' To Optimal Settings","Change '>Use Lights' And '>Post-Divide By Alpha' To Optimal Settings Without Warning","Do Not Change Settings") width:440 align:#center
		dropdownlist ddl_binFileSaving "When saving to RealFlow 4 BIN files with less than 5 trailing digits in the File Name," items:#("Warn Me About The Problem And Suggest To Fix Automatically","Fix Problem By Adding Trailing Zeros Without Warning","Do Not Do Anything") width:440 align:#center
		
		dropdownlist ddl_saveModeTogglesPartitionsRollout "When switching to and from 'Save Particles To File Sequence' Mode," items:#("Open and Close the 'Particle Partitioning' Rollout","Do NOT Open, But Do Close When Switching To 'Render Scene Particles'","Open, But Do NOT Close When Switching To 'Render Scene Particles'","Do NOT Change 'Particle Partitioning' Rollout Open/Close State At All.") width:440 align:#center
		dropdownlist ddl_createLoadersBehavior "When creating a new PRT Loader," items:#("Open File Dialog After Loader Creation At Current Save Path, If None - At Default Path","Open File Dialog After Loader Creation At Default Path","Do NOT Open File Dialog After Loader Creation.") width:440 align:#center

		button btn_DefaultPathHistory "H" width:15 height:20 offset:[-4,-4] align:#left across:4 tooltip:"Browse Default Loaders Path History..." 
		button btn_PickDefaultLoaderPath  "..." width:15 height:20 offset:[-95,-4] align:#left tooltip:"Select Path and File Name to Save Particle Files To. Particle Render Mode will be changed to Save Particles To File Sequence automatically if a valid path is specified."
		edittext edt_DefaultLoaderPath "Path" fieldwidth:358 align:#left offset:[-185,-2] 
		button btn_ExploreDefaultPath "E" align:#right width:16 height:20 offset:[4,-4] tooltip:"Open Root Path In Windows Explorer..."  
		
		dropdownlist ddl_addFileSequenceBehavior "When adding File Sequences to PRT Loader," items:#("Set ALL Sequences To Display In BOTH Viewport And Renderer","Set NO Sequences To Display In Viewport, ALL To Display In Renderer","Set ONLY FIRST Sequence To Display In Viewport,ALL In Renderer","Set ALL To Display NEITHER In Viewport NOR In Renderer") width:440 align:#center
	)	
	
	group "Custom Checkbutton Colors"
	(
		checkbutton ckb_useSkinColors ">Use Custom Checkbutton Colors" width:214 across:2 align:#left highlightcolor:KrakatoaSkinColorsStruct.Preferences
		button btn_updateColors "Update Colors Now (Restart GUI)..." width:214 align:#right 
		
		dropdownlist ddl_SkinColor items:#("Presets and History Rolllout", "Main Controls Rollout", "Channels Rollout", "Partitioning Rollout", "Scene Particles Rollout", "Particle Loaders Rollout", "Thinking Particles Rollout", "Matte Objects Rollout", "Shadows On Geometry Rollout", "APME Rollout","Preferences Rollout","VFB (3ds Max 2009+)")  align:#left width:214 across:2
		colorpicker clr_CheckbuttonColor "Checkbutton Color:" color:KrakatoaSkinColorsStruct.History fieldwidth:40 align:#right modal:false
		
		button btn_SaveSkinColors "Save Checkbutton Colors As Preset..." width:214 across:2 align:#left 
		button btn_LoadSkinColors "Load Checkbutton Colors From Preset..." width:214 align:#right 
	)
	
	fn getCurrentSkinColor theKey &theProperty =
	(
		local theValue = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "SkinColors" theKey)
		theProperty = if classof theValue == Color then theValue else (colorman.getColor #itemHilight)*255
	)
	
	fn setCurrentSkinColor theKey &theProperty theColor = 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "SkinColors" theKey  ((theProperty = theColor) as string)
	)
	
	fn updateSkinColorDisplay itm =
	(
		clr_CheckbuttonColor.color = case itm of
		(
			1: getCurrentSkinColor "History" &KrakatoaSkinColorsStruct.History
			2: getCurrentSkinColor "Main" &KrakatoaSkinColorsStruct.Main
			3: getCurrentSkinColor "Channels" &KrakatoaSkinColorsStruct.Channels
			4: getCurrentSkinColor "Partitioning" &KrakatoaSkinColorsStruct.Partitioning
			5: getCurrentSkinColor "Systems" &KrakatoaSkinColorsStruct.Systems
			6: getCurrentSkinColor "Loaders" &KrakatoaSkinColorsStruct.Loaders
			7: getCurrentSkinColor "Thinking" &KrakatoaSkinColorsStruct.Thinking
			8: getCurrentSkinColor "Matte" &KrakatoaSkinColorsStruct.Matte
			9: getCurrentSkinColor "Shadows" &KrakatoaSkinColorsStruct.Shadows
			10: getCurrentSkinColor "APME" &KrakatoaSkinColorsStruct.APME
			11: getCurrentSkinColor "Preferences" &KrakatoaSkinColorsStruct.Preferences
			12: getCurrentSkinColor "VFB" &KrakatoaSkinColorsStruct.VFB				
		)		
		Krakatoa_LoadSkinColors()
	)
	
	fn saveSkinColors =
	(
		makedir (getDir #plugcfg + "\\Krakatoa\\ColorPresets") all:true
		local theFile = getSaveFilename caption:"Select Custom Checkbutton Colors Preset Name to Save..." filename:(getDir #plugcfg + "\\Krakatoa\\ColorPresets\\Preset.kcp") types:"Krakatoa Color Preset (*.kcp)|*.kcp" history:"KrakatoaPresets"
		if theFile != undefined do
		(
			setIniSetting theFile "CheckbuttonColors" "History" ((getCurrentSkinColor "History" &KrakatoaSkinColorsStruct.History) as string)
			setIniSetting theFile "CheckbuttonColors" "Main" ((getCurrentSkinColor "Main" &KrakatoaSkinColorsStruct.Main) as string)
			setIniSetting theFile "CheckbuttonColors" "Channels" ((getCurrentSkinColor "Channels" &KrakatoaSkinColorsStruct.Channels) as string)
			setIniSetting theFile "CheckbuttonColors" "Partitioning" ((getCurrentSkinColor "Partitioning" &KrakatoaSkinColorsStruct.Partitioning) as string)
			setIniSetting theFile "CheckbuttonColors" "Systems" ((getCurrentSkinColor "Systems" &KrakatoaSkinColorsStruct.Systems) as string)
			setIniSetting theFile "CheckbuttonColors" "Loaders" ((getCurrentSkinColor "Loaders" &KrakatoaSkinColorsStruct.Loaders) as string)
			setIniSetting theFile "CheckbuttonColors" "Thinking" ((getCurrentSkinColor "Thinking" &KrakatoaSkinColorsStruct.Thinking) as string)
			setIniSetting theFile "CheckbuttonColors" "Matte" ((getCurrentSkinColor "Matte" &KrakatoaSkinColorsStruct.Matte) as string)
			setIniSetting theFile "CheckbuttonColors" "Shadows" ((getCurrentSkinColor "Shadows" &KrakatoaSkinColorsStruct.Shadows) as string)
			setIniSetting theFile "CheckbuttonColors" "APME" ((getCurrentSkinColor "APME" &KrakatoaSkinColorsStruct.APME) as string)
			setIniSetting theFile "CheckbuttonColors" "Preferences" ((getCurrentSkinColor "Preferences" &KrakatoaSkinColorsStruct.Preferences) as string)
			setIniSetting theFile "CheckbuttonColors" "VFB" ((getCurrentSkinColor "VFB" &KrakatoaSkinColorsStruct.VFB) as string)
		)
	)
	
	fn loadSkinColors =
	(
		makedir (getDir #plugcfg + "\\Krakatoa\\ColorPresets") all:true
		local theFile = getOpenFilename caption:"Select Custom Checkbutton Colors Preset Name to Load..." filename:(getDir #plugcfg + "\\Krakatoa\\ColorPresets\\") types:"Krakatoa Color Preset (*.kcp)|*.kcp" history:"KrakatoaPresets"
		if theFile != undefined do
		(
			try(setCurrentSkinColor "History" &KrakatoaSkinColorsStruct.History  (execute (getIniSetting theFile "CheckbuttonColors" "History")))catch()
			try(setCurrentSkinColor "Main" &KrakatoaSkinColorsStruct.Main (execute (getIniSetting theFile "CheckbuttonColors" "Main")))catch()
			try(setCurrentSkinColor "Channels" &KrakatoaSkinColorsStruct.Channels (execute (getIniSetting theFile "CheckbuttonColors" "Channels")))catch()
			try(setCurrentSkinColor "Partitioning" &KrakatoaSkinColorsStruct.Partitioning (execute (getIniSetting theFile "CheckbuttonColors" "Partitioning")))catch()
			try(setCurrentSkinColor "Systems" &KrakatoaSkinColorsStruct.Systems (execute (getIniSetting theFile "CheckbuttonColors" "Systems")))catch()
			try(setCurrentSkinColor "Loaders" &KrakatoaSkinColorsStruct.Loaders (execute (getIniSetting theFile "CheckbuttonColors" "Loaders")))catch()
			try(setCurrentSkinColor "Thinking" &KrakatoaSkinColorsStruct.Thinking (execute (getIniSetting theFile "CheckbuttonColors" "Thinking")))catch()
			try(setCurrentSkinColor "Matte" &KrakatoaSkinColorsStruct.Matte (execute (getIniSetting theFile "CheckbuttonColors" "Matte")))catch()
			try(setCurrentSkinColor "Shadows" &KrakatoaSkinColorsStruct.Shadows (execute (getIniSetting theFile "CheckbuttonColors" "Shadows")))catch()
			try(setCurrentSkinColor "APME" &KrakatoaSkinColorsStruct.APME (execute (getIniSetting theFile "CheckbuttonColors" "APME")))catch()
			try(setCurrentSkinColor "Preferences" &KrakatoaSkinColorsStruct.Preferences (execute (getIniSetting theFile "CheckbuttonColors" "Preferences")))catch()
			try(setCurrentSkinColor "VFB" &KrakatoaSkinColorsStruct.VFB (execute (getIniSetting theFile "CheckbuttonColors" "VFB")))catch()
			updateSkinColorDisplay ddl_SkinColor.selection
		)
	)			
	
	
	fn refresh_GUI =
	(			
		local KrakatoaPreferencesINI = (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" )
		
		try(Krakatoa_GUI_Preferences.open = FranticParticles.GetBoolProperty "GUI:PreferencesRolloutOpen")catch()
		try(ddl_blendedModeSwitch.selection = execute (getIniSetting KrakatoaPreferencesINI "Preferences" "BlendModeSwitch"))catch()
		try(ddl_binFileSaving.selection = execute (getIniSetting KrakatoaPreferencesINI "Preferences" "RealFlowBinFileSaving"))catch()
		try(ddl_saveModeTogglesPartitionsRollout.selection = execute (getIniSetting KrakatoaPreferencesINI "Preferences" "SaveModeTogglePartitionsRollout"))catch()
		try(ddl_createLoadersBehavior.selection = execute (getIniSetting KrakatoaPreferencesINI "Preferences" "CreateLoadersBehavior"))catch()
		try(ddl_addFileSequenceBehavior.selection = execute (getIniSetting KrakatoaPreferencesINI "Preferences" "AddFileSequenceBehavior"))catch()
		try(chk_autoincreasePflowSystemLimit.state = execute (getIniSetting KrakatoaPreferencesINI "System" "AutoIncreasePflowSystemLimit" ))catch(chk_autoincreasePflowSystemLimit.state = true)

		chk_LoadVFBExtensions.state = (getIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "Preferences" "LoadVFBExtensionsOnStartup") == "true"
		
		local theIndex = findItem #("0","1","2","4","8","16") (FranticParticles.getProperty "SortingThreads")
		if theIndex == 0 do theIndex = 1
		ddl_sortingThreads.selection = theIndex
		
		local theDeadlineVal = getIniSetting KrakatoaPreferencesINI "Deadline" "DetectDeadline"
		ddl_useDeadlineVersion.selection = case theDeadlineVal of
		(
			default: 1
			"2": 2
			"3": 3
		)
		
		edt_DefaultLoaderPath.text = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath")
		chk_AutoOpenLogOnOutput.state = FranticParticles.PopupLogWindowOnMessage 

		theFiles = getFiles (GetDir #plugcfg + "\\Krakatoa\\presets\\*.KPS")
		ddl_PRTpresets.items= join #() (for f in theFiles collect getFileNameFile f)
		theVal = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "PRTLoaders" "UsePreset")
		chk_UsePRTPreset.checked = if theVal != OK then theVal else false
		theIndex = findItem ddl_PRTpresets.items (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "PRTLoaders" "PresetName" )
		ddl_PRTpresets.selection = theIndex

		local theVal = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "SkinColors" "UseCustomColors")
		ckb_useSkinColors.checked = if theVal == OK then false else theVal

		local theVal = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "SkinColors" "LastSelection" )
		ddl_SkinColor.selection = if theVal == OK then 1 else theVal
		updateSkinColorDisplay ddl_SkinColor.selection
		
		btn_getLicense.enabled = try(not FranticParticles.HasValidLicense())catch(true)
		btn_releaseLicense.enabled = try(FranticParticles.HasValidLicense())catch(false)
		Krakatoa_Gui_floater.title = ("Krakatoa v" + FranticParticles.Version + " - Primary Floater " + (if try(FranticParticles.HasValidLicense())catch(false) then " - Licensed" else " - Evaluation Mode") )
	)	
	
	on chk_LoadVFBExtensions changed state do 
	(
		setIniSetting (GetDir #plugcfg + "\\Krakatoa\\KrakatoaPreferences.ini") "Preferences" "LoadVFBExtensionsOnStartup" (state as string)
	)	
	
	on btn_SaveDefaults pressed do 
	(
		if querybox "Do you want to SAVE the current Renderer Settings as initial DEFAULTS for future Krakatoa Sessions?" title:"Krakatoa: Save Defaults" then 
			FranticParticleRenderMXS.saveCustomDefaults()
	)
	
	on btn_ResetFactoryDefaults pressed do
	(
		if querybox "Do you want to RESET the initial DEFAULTS for future Krakatoa Sessions to the Factory Defaults?" title:"Krakatoa: Reset Factory Defaults" then 
		(
			deleteFile (Krakatoa_PresetsDirectory + "\\KrakatoaDefaults.bak") 
			renameFile (Krakatoa_PresetsDirectory + "\\KrakatoaDefaults.ini") (Krakatoa_PresetsDirectory + "\\KrakatoaDefaults.bak")
		)
	)
	
	on btn_detectDeadlineNow pressed do 
	(
		Krakatoa_GUI_Partition.open = false
		FranticParticleRenderMXS.detectDeadline timeout:2000 forceloading:true
	)

	on ddl_useDeadlineVersion selected itm do
	(
		local KrakatoaPreferencesINI = (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" )
		setIniSetting KrakatoaPreferencesINI "Deadline" "DetectDeadline"	(itm as string)
		Krakatoa_GUI_Partition.open = false
		FranticParticleRenderMXS.detectDeadline timeout:2000 forceloading:true
		if itm == 2 and FranticParticleRenderMXS.DeadlineDetected != 2 then 
			messagebox "WARNING:\nDeadline 2.x was NOT DETECTED on your system." title:"Krakatoa and Deadline Integration"
		if itm == 3 and FranticParticleRenderMXS.DeadlineDetected != 3 then 
			messagebox "WARNING:\nDeadline 3 or higher was NOT DETECTED on your system." title:"Krakatoa and Deadline Integration"
		Krakatoa_GUI_Partition.refresh_GUI()			
	)	
	
	on ckb_useSkinColors changed state do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "SkinColors" "UseCustomColors" ((KrakatoaSkinColorsStruct.UseCustomColors = state) as string)
	)
	
	on btn_updateColors pressed do
	(
		Krakatoa_LoadSkinColors()
		FranticParticleRenderMXS.OpenGUI()		
	)
	
	on ddl_SkinColor selected itm do
	(
		updateSkinColorDisplay itm
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" ) "SkinColors" "LastSelection" (itm as string)
	)
	
	on clr_CheckbuttonColor changed theColor do
	(
		case ddl_SkinColor.selection of
		(
			1: setCurrentSkinColor "History" &KrakatoaSkinColorsStruct.History  theColor
			2: setCurrentSkinColor "Main" &KrakatoaSkinColorsStruct.Main theColor
			3: setCurrentSkinColor "Channels" &KrakatoaSkinColorsStruct.Channels theColor
			4: setCurrentSkinColor "Partitioning" &KrakatoaSkinColorsStruct.Partitioning theColor
			5: setCurrentSkinColor "Systems" &KrakatoaSkinColorsStruct.Systems theColor
			6: setCurrentSkinColor "Loaders" &KrakatoaSkinColorsStruct.Loaders theColor
			7: setCurrentSkinColor "Thinking" &KrakatoaSkinColorsStruct.Thinking theColor
			8: setCurrentSkinColor "Matte" &KrakatoaSkinColorsStruct.Matte theColor
			9: setCurrentSkinColor "Shadows" &KrakatoaSkinColorsStruct.Shadows theColor
			10: setCurrentSkinColor "APME" &KrakatoaSkinColorsStruct.APME theColor
			11: setCurrentSkinColor "Preferences" &KrakatoaSkinColorsStruct.Preferences theColor
			12: setCurrentSkinColor "VFB" &KrakatoaSkinColorsStruct.VFB theColor
		)			
	)
	
	on btn_SaveSkinColors pressed do saveSkinColors()
	on btn_LoadSkinColors pressed do LoadSkinColors()
	
	on ddl_blendedModeSwitch selected itm do
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" (itm as string)
	on ddl_binFileSaving selected itm do
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" (itm as string)
	on ddl_saveModeTogglesPartitionsRollout selected itm do	
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" (itm as string)
	on ddl_createLoadersBehavior selected itm do
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" (ddl_createLoadersBehavior.selection as string)
	on ddl_addFileSequenceBehavior 	selected itm do
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" (ddl_addFileSequenceBehavior.selection as string)


	fn ddl_sortingThreads_SelectedFN itm =
	(
		FranticParticles.setProperty "SortingThreads" (#("0","1","2","4","8","16"))[itm]
	)
	
	on ddl_sortingThreads selected itm do
	(
		ddl_sortingThreads_SelectedFN itm
	)	
	
	on btn_increasePflowSystemLimit pressed do FranticParticleRenderMXS.increasePFlowSystemLimits()
	on chk_autoincreasePflowSystemLimit changed state  do
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "System" "AutoIncreasePflowSystemLimit" (state as string)

	on btn_getLicense pressed do 
	(
		try(FranticParticles.AcquireLicense())catch()
		refresh_GUI()
		Krakatoa_GUI_About.refresh_GUI()
	)

	on btn_releaseLicense pressed do 
	(
		try(FranticParticles.ReleaseLicense())catch()
		refresh_GUI()
		Krakatoa_GUI_About.refresh_GUI()
	)	
	
	on ddl_PRTpresets selected itm do
	(
		if itm > 0 do
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "PRTLoaders" "PresetName" ddl_PRTpresets.selected
			
	)
	
	on chk_UsePRTPreset changed state do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "PRTLoaders" "UsePreset" (state as string)
	)
	
	on btn_DefaultPathHistory pressed do
	( 
		Krakatoa_GUI_SaveParticles.allPaths = #()
		Krakatoa_GUI_SaveParticles.allValues = #()
		local theCacheFile = (Krakatoa_PresetsDirectory+"\\_HistoryCache.List")
		if not doesFileExist theCacheFile do Krakatoa_GUI_Presets.rebuildHistoryCache()
		createDialog Krakatoa_GUI_FileSortingProgress_Dialog 400 30		
		
		local theHistoryCache = openFile theCacheFile
		local theHistoryFiles = #()
		local cnt = 0
		while not eof theHistoryCache do 
		(
			cnt+=1
			local f =  ( Krakatoa_PresetsDirectory + "\\history\\" +  (readLine theHistoryCache) + ".KrakatoaSettings")
			if (thePath = getFileNamePath (getIniSetting f "SceneInfo" "ParticleFiles")) != "" and doesFileExist thePath and findItem Krakatoa_GUI_SaveParticles.allValues thePath == 0 do 
			(
				append Krakatoa_GUI_SaveParticles.allPaths (getIniSetting f "SceneInfo" "ParticleFiles")
				append Krakatoa_GUI_SaveParticles.allValues thePath
			)	
			Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Read "+ cnt as string+ " History Records, Collected " + Krakatoa_GUI_SaveParticles.allValues.count as string + " Unique Paths." 
		)	
		close theHistoryCache			
		destroyDialog Krakatoa_GUI_FileSortingProgress_Dialog 
			
		createDialog Krakatoa_GUI_History_Dialog 820 310 modal:true
		if Krakatoa_GUI_SaveParticles.historyValue != undefined do 
		(
			if not matchPattern Krakatoa_GUI_SaveParticles.historyValue pattern:"*\\" do
				Krakatoa_GUI_SaveParticles.historyValue += "\\"
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath" (edt_DefaultLoaderPath.text = Krakatoa_GUI_SaveParticles.historyValue)
		)	
	)	
	
	on btn_PickDefaultLoaderPath pressed do
	(
		local newDefaultPath = getSavePath caption:"Select the Particle File Sequence to Save" 
		if newDefaultPath != undefined do 
		(
			if not matchPattern newDefaultPath pattern:"*\\" do newDefaultPath += "\\"
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath" (edt_DefaultLoaderPath.text = newDefaultPath)
		)			
	)
	
	on edt_DefaultLoaderPath entered txt do
	(
		if doesFileExist txt then
		(
			if not matchPattern txt pattern:"*\\" do txt += "\\"
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath" txt
			edt_DefaultLoaderPath.text = txt
		)	
		else	
			edt_DefaultLoaderPath.text = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "DefaultLoaderPath" 
	)

	on btn_ExploreDefaultPath pressed do
	(
		if doesFileExist edt_DefaultLoaderPath.text then
			shellLaunch "explorer.exe" edt_DefaultLoaderPath.text
	)
	
	on chk_AutoOpenLogOnOutput changed state do FranticParticles.PopupLogWindowOnMessage = state
	on btn_OpenLogWindow pressed do FranticParticles.LogWindowVisible = true
	
	on Krakatoa_GUI_Preferences rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:PreferencesRolloutOpen" val
			if val then 
				FranticParticles.LogDebug ("+Preferences Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Preferences Rollout ROLLED UP.")
	)	
	
	on Krakatoa_GUI_Preferences close do 
	(
		if Krakatoa_GUI_Preferences.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Preferences.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_Preferences open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_Preferences.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Preferences Rollout OPENED.")			
	)			
	
	
	on btn_beginnerSettings pressed do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" "1"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" "1"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" "1"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" "1"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" "1"
		refresh_GUI()	
	)
	on btn_advancedSettings pressed do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" "2"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" "2"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" "2"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" "2"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" "2"
		refresh_GUI()	
	)	
	on btn_expertSettings pressed do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" "3"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" "3"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" "4"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" "3"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" "4" 
		refresh_GUI()	
	)	
)--end rollout

rollout Krakatoa_GUI_AmbientPME "Ambient PME" category:100 width:457
(
	local thePMEBitmap = bitmap 400 1
	local thePMEMasterBitmap = bitmap 440 20

	button btn_LoadSave_APME "<>" across:3 align:#left width:20 height:14 offset:[-10,-5] tooltip:"Load and Save Presets For This Rollout Only"
	button btn_Help_APME  "Open Krakatoa Online Help..." width:408 height:14 offset:[0,-5] align:#center 
	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."

	on btn_LoadSave_APME pressed do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_AmbientPME
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	on btn_LoadSave_APME rightClick do 
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_AmbientPME
		popupMenu Krakatoa_RCMenu_Struct.Load_Save_Rollout_RCMenu pos:mouse.screenpos
	)	
	
	on btn_Help_APME pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/ambient_pme.php" ""		
	
	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_AmbientPME
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_AmbientPME
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)			

	on Krakatoa_GUI_AmbientPME moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_AmbientPME.title (pos as string)
	)			

	checkbutton chk_PMEfreeMode "--" width:23 across:3 align:#left offset:[-10,0] tooltip:"Allow Negative Extinction Values (For Masking Purposes Only, NOT A VALID PHYSICAL BEHAVIOR!)" highlightcolor:KrakatoaSkinColorsStruct.APME
	checkbutton chk_useAmbientPME ">Use Ambient Participating Medium Extinction (APME)" width:400 align:#center offset:[0,0] tooltip:"Toggle Ambient Participating Medium Extinction On and Off." highlightcolor:KrakatoaSkinColorsStruct.APME
	button btn_PMEPresets ">>" width:23  align:#right offset:[10,0] tooltip:"Add, Remove and Load Ambient Participating Medium Extinction Preset Settings."

	checkbutton chk_PMELockSpinners ">Link Values" width:100 align:#left across:3 offset:[-10,-3] tooltip:"Link Values - one spinner changes all three spinners proportionally. All spinners must be set to NON-ZERO values!" enabled:false highlightcolor:KrakatoaSkinColorsStruct.APME
	button btn_PMEAlignSpinners "Align To Blue..." width:100 align:#center offset:[-72,-3] tooltip:"Synch Spinner Values - Red and Green will be set to the Blue Value."
	edittext edt_presetname "Preset Name:" text:"Preset" across:3 fieldwidth:175 align:#right offset:[10,0]

	spinner spn_ExtinctionRed "Red Extinction:" range:[0.0,10000.0,0.0] scale:0.1 fieldwidth:50 across:3 align:#left offset:[-10,3]
	spinner spn_ExtinctionGreen "Green Extinction:" range:[0.0,10000.0,0.0] scale:0.1 fieldwidth:50 align:#center offset:[0,3]
	spinner spn_ExtinctionBlue "Blue Extinction:" range:[0.0,10000.0,0.0] scale:0.1 fieldwidth:50 align:#right offset:[10,3]
	
	group "Extinction Explorer"
	(
		spinner spn_PMEStart "Start:" range:[0,1000000,0] fieldwidth:60 across:2 align:#left offset:[-3,0] type:#worldunits
		spinner spn_PMEDistance "Distance from Start:" range:[0,1000000,1000] fieldwidth:60 align:#right offset:[3,0] type:#worldunits
	
		label lbl_startColorPercent align:#left across:3 offset:[-3,0]
		label lbl_midColorPercent align:#center offset:[0,0]
		label lbl_endColorPercent align:#right offset:[3,0]
		
		colorpicker clr_PMEBaseColor "" color:white height:20 fieldwidth:18 align:#left offset:[-10,-4] modal:false across:3
		bitmap bmp_PMEdisplay bitmap:thePMEMasterBitmap width:400 height:21 align:#center offset:[2,-4]
		colorpicker clr_PMETarget "" color:white height:20 fieldwidth:18 align:#right offset:[8,-4] modal:false
		
		label lbl_startColor align:#left across:3 offset:[-3,-8]
		label lbl_midColor align:#center offset:[0,-8]
		label lbl_endColor align:#right offset:[3,-8]
		
	)
	
	group "Extinction By Object Volume:"	
	(
		listbox lbx_allNamedSelectionSets "Named Selection Sets:" items:#() height:6 across:2 width:204 align:#left
		listbox lbx_useNamedSelectionSets "APME Objects Named Selection Sets:" items:#() height:6 width:205 align:#right
		button btn_update "Update Named Selection Set Lists" width:214 align:#left offset:[0,-3] across:3 tooltip:"Update both Named Selection Sets lists manually to reflect name changes, new and deleted selection sets etc."
		button btn_selectInScene "Select Highlighted" width:106 align:#right offset:[37,-3] tooltip:"Select the objects in the scene stored in the currently highlighted APME Objects Named Selection Set ."
		button btn_selectAllInScene "Select All" width:106 align:#right offset:[1,-3] tooltip:"Select the objects in the scene stored in all APME Objects Named Selection Sets."

		button btn_selectionSetAdd ">" height:40 align:#center width:20 offset:[0,-112] tooltip:"Move the highlighted Named Selection Set to the Matte Objects Named Selection Sets list. All geometry objects in it will become APME objects."
		button btn_selectionSetRemove "<" height:40 align:#center offset:[0,-3] width:20 tooltip:"Remove the highlighted Named Selection Set from the APME Objects Named Selection Sets list."
		
		edittext edt_createNewSelSet "NSS:" text:"KrakatoaAPMEObjects" across:2 width:214 align:#left offset:[-2,30]
		button btn_createNewSelSet "Create/Update APME Selection Set" width:214 align:#right offset:[0,30] height:18 tooltip:"Select objects, enter NSS name and press to create a new selection set. Select an existing NSS from the PME Objects NSS list, select objects in the scene and press to update."
	)
	
	
	
	fn saveSelectionSets =
	(
		local txt = "#("
		if lbx_useNamedSelectionSets.items.count > 0 do
		(
			for i = 1 to lbx_useNamedSelectionSets.items.count-1 do txt += "\"" + lbx_useNamedSelectionSets.items[i] as string + "\","
			txt += "\"" + lbx_useNamedSelectionSets.items[lbx_useNamedSelectionSets.items.count] as string + "\""
		)	
		txt += ")"
		FranticParticles.SetProperty "PME:NamedSelectionSets" txt
	)			
	
	fn updateSelectionSets =
	(
		theArray = execute (FranticParticles.GetProperty "PME:NamedSelectionSets")
		lbx_useNamedSelectionSets.items = theArray
		lbx_allNamedSelectionSets.items = for i = 1 to selectionsets.count where findItem theArray (getNamedSelSetName i) == 0 collect (getNamedSelSetName i)
		saveSelectionSets()
		--Krakatoa_GUI_Particles.updateParticlesList()
	)
	
	fn renamedSelectionSets theNames =
	(
		tempArray = lbx_useNamedSelectionSets.items
		for i = 1 to tempArray.count do if tempArray[i] == theNames[1] do tempArray[i] = theNames[2]
		lbx_useNamedSelectionSets.items = tempArray 
		updateSelectionSets()
	)

	on lbx_allNamedSelectionSets doubleClicked itm do
	(
		tempArray = lbx_useNamedSelectionSets.items
		append tempArray lbx_allNamedSelectionSets.selected 
		lbx_useNamedSelectionSets.items = tempArray
		saveSelectionSets()
		updateSelectionSets()
	)	

	on btn_selectionSetAdd pressed do 
	(		
		if lbx_allNamedSelectionSets.selection > 0 do
		(
			tempArray = lbx_useNamedSelectionSets.items
			append tempArray lbx_allNamedSelectionSets.selected 
			lbx_useNamedSelectionSets.items = tempArray
			saveSelectionSets()
			updateSelectionSets()				
		)	
	)
	
	on lbx_useNamedSelectionSets doubleClicked itm do
	(
		tempArray = lbx_useNamedSelectionSets.items
		deleteItem tempArray itm
		lbx_useNamedSelectionSets.items = tempArray
		saveSelectionSets()
		updateSelectionSets()				
	)
	
	on lbx_useNamedSelectionSets selected itm do edt_createNewSelSet.text = lbx_useNamedSelectionSets.selected
		
	
	on btn_selectionSetRemove pressed do 
	(		
		if lbx_useNamedSelectionSets.selection > 0 do
		(
			tempArray = lbx_useNamedSelectionSets.items
			deleteItem tempArray lbx_useNamedSelectionSets.selection
			lbx_useNamedSelectionSets.items = tempArray
			saveSelectionSets()
			updateSelectionSets()				
		)	
	)			
	on btn_update pressed do updateSelectionSets()
	
	on btn_selectAllInScene pressed do 
	(
		updateSelectionSets()	
		max select none
		for i = 1 to selectionsets.count where findItem lbx_useNamedSelectionSets.items (getNamedSelSetName i) != 0 do selectmore selectionsets[i]
	)	
	on btn_selectInScene pressed do 
	(
		updateSelectionSets()	
		max select none
		for i = 1 to selectionsets.count where lbx_useNamedSelectionSets.selected == (getNamedSelSetName i) do select selectionsets[i]
	)	
	
	on btn_createNewSelSet pressed do
	(
		if selection.count > 0 then
		(
			if edt_createNewSelSet.text != "" then
			(
				local theObjects = for o in selection where findItem geometryClass.classes (classof o) > 0 and classof o != TargetObject and classof o != KrakatoaPrtLoader and classof o != PF_Source collect o
				if theObjects.count > 0 then
				(
					selectionSets[edt_createNewSelSet.text] = theObjects 
					tempArray = lbx_useNamedSelectionSets.items
					if findItem tempArray edt_createNewSelSet.text == 0 do
					(
						append tempArray edt_createNewSelSet.text
						lbx_useNamedSelectionSets.items = tempArray
						saveSelectionSets()
					)	
					updateSelectionSets()
				)	
				else
					messagebox "The Current Selection Does Not Contain Any Valid Geometry Objects\n" title:"Cannot Create APME Objects Selection Set"
			)
			else
				messagebox "Please enter a valid name for the selection set\n" title:"Cannot Create APME Objects Selection Set"
		)
		else		
			messagebox "Please select some Geometry Objects in the scene!" title:"Cannot Create APME Objects Selection Set"
	)			
	
	fn createPresetsRCMenu  =
	(
		presetName = "PMEPresets"
		presetsList = #(
				#("Clear Oceanic Water", 36.889, 11.75, 0.73),
				#("Polluted Oceanic Water", 66.1, 9.2, 8.4),
				#("Average Coastal Water", 100.0, 23.7, 33.3)
			)
		local builtInPresetsCount = presetsList.count
		local theKeys = for i in (getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName ) collect i
		searchList = for i in presetsList collect i[1]
		for k in theKeys do
		(
			try
			(
				val = execute (getIniSetting (Krakatoa_PresetsDirectory + "//KrakatoaPreferences.ini") presetName k)
				append presetsList #(k, val.x, val.y, val.z)
				append searchList k --(val.x as string + ", " +val.y as string + ", " + val.z as string)
			)catch()	
		)	

		theValue1 = Krakatoa_GUI_AmbientPME.spn_ExtinctionRed.value
		theValue2 = Krakatoa_GUI_AmbientPME.spn_ExtinctionGreen.value
		theValue3 = Krakatoa_GUI_AmbientPME.spn_ExtinctionBlue.value
		
		--searchValue =  (theValue1  as string + ", " +theValue2   as string + ", " + theValue3 as string)
		searchValue =edt_presetname.text
		storeValue = ("[" +theValue1  as string + "," +theValue2   as string + "," + theValue3 as string + "]")
		
		local txt = "rcmenu Presets_RCMenu\n(\n"
		
		if findItem searchList searchValue == 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add '" + searchValue +"'\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ searchValue +"\" \""+ storeValue +"\" \n"
			txt += "separator spr_01\n" 
		)	
		if findItem searchList searchValue > builtInPresetsCount do 
		(
			txt += "menuItem mnu_AddPreset \"Update '"+searchValue +  "'\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName + "\" \""+ searchValue +"\" \""+ storeValue +"\" \n"
			txt += "separator spr_02\n" 
		)
		
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i[1] + " ["+ i[2] as string + ","+ i[3] as string + "," + i[4] as string +"]\" \n" 
			txt += "on mnu_preset" + cnt as string + " picked do (\nKrakatoa_GUI_AmbientPME.spn_ExtinctionRed.changed (Krakatoa_GUI_AmbientPME.spn_ExtinctionRed.value = "+ i[2] as string +")\n"
			txt += "Krakatoa_GUI_AmbientPME.spn_ExtinctionGreen.changed (Krakatoa_GUI_AmbientPME.spn_ExtinctionGreen.value = "+ i[3] as string +")\n"
			txt += "Krakatoa_GUI_AmbientPME.edt_presetname.text = \""+ i[1] +"\"\n"
			txt += "Krakatoa_GUI_AmbientPME.spn_ExtinctionBlue.changed (Krakatoa_GUI_AmbientPME.spn_ExtinctionBlue.value = "+ i[4] as string +")\n)\n"
		)
		if findItem searchList searchValue > builtInPresetsCount do 
		(
			txt += "separator spr_09\n" 
			txt += "menuItem mnu_RemovePreset \"Remove '"+ searchValue  +"'\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (Krakatoa_PresetsDirectory + \"//KrakatoaPreferences.ini\") \""+ presetName +"\" \""+ searchValue as string +"\" \n"
		)	
		txt += ")\n"
		Krakatoa_RCMenu_Struct.Presets_RCMenu = execute txt
	)
	
	fn getExtinction =
	(
		local baseColor = clr_PMEBaseColor.color
		local theTargetColor = clr_PMETarget.color
		if clr_PMETarget.color.r == 0 and baseColor.r != 0 do clr_PMETarget.color.r = 0.0001
		if clr_PMETarget.color.g == 0 and baseColor.r != 0 do clr_PMETarget.color.g = 0.0001
		if clr_PMETarget.color.b == 0 and baseColor.r != 0 do clr_PMETarget.color.b = 0.0001
		
		local theDist = spn_PMEStart.value + spn_PMEDistance.value
		
		--Clamp Target Color Channels to Base Color Channels -We cannot get brighter!
		if theTargetColor.r > baseColor.r do theTargetColor.r = baseColor.r
		if theTargetColor.g > baseColor.g do theTargetColor.g = baseColor.g
		if theTargetColor.b > baseColor.b do theTargetColor.b = baseColor.b
		
		--Calculate the Extinctions for R, G and B channel
		minR = if baseColor.r > 0 then -(log (theTargetColor.r / baseColor.r) / theDist) else 0
		minG = if baseColor.g > 0 then -(log (theTargetColor.g / baseColor.g) / theDist) else 0
		minB = if baseColor.b > 0 then -(log (theTargetColor.b / baseColor.b) / theDist) else 0
		
		--If the result is very small, round it down to 0 (otherwise spinners show -0.0 which looks bad)
		if minR < 0.0001 do minR = 0
		if minG < 0.0001 do minG = 0
		if minB < 0.0001 do minB = 0
		[minR, minG, minB]
	)
	
	fn setExtinction = 
	(
		unitsMultiplier = case units.SystemType of
		(
			#inches:1
			#millimeters: 25.4
			#centimeters: 2.54
			#meters:0.0254
			#kilometers:0.0000254
			#feet:0.0833333
			#miles:0.0000157828
			default:1
		)
		local thePME = ([spn_ExtinctionRed.value, spn_ExtinctionGreen.value, spn_ExtinctionBlue.value]/10000.0 *3.53 / unitsMultiplier  ) -- 
		local deltaDist = spn_PMEDistance.value/400.0
		local baseColor = clr_PMEBaseColor.color
		local visibility_r, visibility_g, visibility_b
		for i = 0 to 399 do
		(
			visibility_r =  baseColor.r * exp( -thePME.x * (spn_PMEStart.value + i*deltaDist)   )
			visibility_g = baseColor.g * exp( -thePME.y * (spn_PMEStart.value + i*deltaDist)  )
			visibility_b = baseColor.b * exp( -thePME.z * (spn_PMEStart.value + i*deltaDist)  )
			setPixels thePMEBitmap [i,0] #( ([visibility_r,visibility_g,visibility_b]) )
			if i == 0 do lbl_startColor.text = "Reference:" + [visibility_r,visibility_g,visibility_b] as string
		)	
		if visibility_r > 255 do visibility_r = 255
		if visibility_g > 255 do visibility_g = 255
		if visibility_b> 255 do visibility_b = 255
		
		clr_PMETarget.color =  [visibility_r,visibility_g,visibility_b] 
		lbl_endColor.text = "Target:" + [visibility_r,visibility_g,visibility_b] as string
		
		lbl_startColorPercent.text = "Lost: R:"+ \
			(if baseColor.r > 0 then (100.0- visibility_r / baseColor.r  * 100.0) as string else "0") + "% G:" + \
			(if baseColor.g > 0 then (100.0- visibility_g / baseColor.g  * 100.0) as string else "0") + "% B:" + \
			(if baseColor.b > 0 then (100.0- visibility_b / baseColor.b  * 100.0) as string else "0") + "%"
		lbl_endColorPercent.text = "Left: R:"+ \
			(if baseColor.r > 0 then (visibility_r / baseColor.r  * 100.0) as string else "100") + "% G:" + \
			(if baseColor.g > 0 then (visibility_g / baseColor.g  * 100.0) as string else "100") + "% B:" + \
			(if baseColor.b > 0 then (visibility_b / baseColor.b  * 100.0) as string else "100") + "%"
		
		copy thePMEBitmap thePMEMasterBitmap
		bmp_PMEdisplay.bitmap = thePMEMasterBitmap
		FranticParticles.SetProperty "AmbientParticipatingMediumExtinction" (thePME  as string)
		FranticParticles.SetProperty "ExtinctionRed" (spn_ExtinctionRed.value as string)
		FranticParticles.SetProperty "ExtinctionGreen" (spn_ExtinctionGreen.value as string)
		FranticParticles.SetProperty "ExtinctionBlue" (spn_ExtinctionBlue.value as string)
		FranticParticles.SetProperty "ExtinctionStart" (spn_PMEStart.value as string)
		FranticParticles.SetProperty "ExtinctionDistance" (spn_PMEDistance.value as string)
		chk_PMELockSpinners.enabled = spn_ExtinctionBlue.value != 0 and spn_ExtinctionRed.value != 0 and spn_ExtinctionGreen.value != 0 
	)
	
	on clr_PMETarget changed clr do
	(
		unitsMultiplier = case units.SystemType of
		(
			#inches:1
			#millimeters: 25.4
			#centimeters: 2.54
			#meters:0.0254
			#kilometers:0.0000254
			#feet:0.0833333
			#miles:0.0000157828
			default:1
		)		
		result = (getExtinction()) * 10000.0 / 3.53 * unitsMultiplier 
		spn_ExtinctionRed.value = result.x 
		spn_ExtinctionGreen.value = result.y 
		spn_ExtinctionBlue.value = result.z 
		setExtinction()
	)
	
	fn updateFreeMode state =
	(
		if state then 
		(
			spn_ExtinctionRed.range = [-10000.0,10000.0,spn_ExtinctionRed.value]
			spn_ExtinctionGreen.range = [-10000.0,10000.0,spn_ExtinctionGreen.value]
			spn_ExtinctionBlue.range = [-10000.0,10000.0,spn_ExtinctionBlue.value]
			clr_PMETarget.enabled = false
		)
		else
		(
			spn_ExtinctionRed.range = [0.0,10000.0,if spn_ExtinctionRed.value >= 0 then spn_ExtinctionRed.value else 0]
			spn_ExtinctionGreen.range = [0.0,10000.0,if spn_ExtinctionGreen.value >= 0 then spn_ExtinctionGreen.value else 0]
			spn_ExtinctionBlue.range = [0.0,10000.0,if spn_ExtinctionBlue.value >= 0 then spn_ExtinctionBlue.value else 0]
			clr_PMETarget.enabled = true
		)
	)
	
	on chk_PMEfreeMode changed state do
	(
		FranticParticles.SetProperty "PME:FreeMode" (state as string)
		updateFreeMode state
		setExtinction()	
	)		
	on chk_PMEfreeMode rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "PME:FreeMode" "--"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)			

	local redToBlueExtFactor
	local greenToBlueExtFactor
	local redToGreenExtFactor

	on chk_PMELockSpinners changed state do
	(
		if spn_ExtinctionBlue.value == 0 or spn_ExtinctionRed.value == 0 or spn_ExtinctionGreen.value == 0 then
		(
			chk_PMELockSpinners.state = false
			chk_PMELockSpinners.enabled = false
		)
		else
		(
			redToBlueExtFactor = spn_ExtinctionRed.value / spn_ExtinctionBlue.value
			greenToBlueExtFactor = spn_ExtinctionGreen.value / spn_ExtinctionBlue.value
		)	
	)
	
	on spn_ExtinctionRed changed val do 
	(
		if chk_PMELockSpinners.checked then
		(
			spn_ExtinctionBlue.value = spn_ExtinctionRed.value / redToBlueExtFactor 
			spn_ExtinctionGreen.value =  spn_ExtinctionBlue.value * greenToBlueExtFactor
		)
		setExtinction()
	)	
	on spn_ExtinctionGreen changed val do 
	(
		if chk_PMELockSpinners.checked then
		(
			spn_ExtinctionBlue.value = spn_ExtinctionGreen.value / greenToBlueExtFactor 
			spn_ExtinctionRed.value = spn_ExtinctionBlue.value * redToBlueExtFactor
		)		
		setExtinction()
	)	
	on spn_ExtinctionBlue changed val do
	(
		if chk_PMELockSpinners.checked then
		(
			spn_ExtinctionGreen.value = spn_ExtinctionBlue.value  * greenToBlueExtFactor
			spn_ExtinctionRed.value = spn_ExtinctionBlue.value * redToBlueExtFactor 
		)		
		setExtinction()
	)	

	on btn_PMEAlignSpinners pressed do
	(		
		spn_ExtinctionRed.value = spn_ExtinctionGreen.value = spn_ExtinctionBlue.value
		greenToBlueExtFactor = redToBlueExtFactor = 1.0
		setExtinction()
	)
	
	
	on spn_PMEStart changed val do setExtinction()
	on spn_PMEDistance changed val do setExtinction()
	on clr_PMEBaseColor changed val do 
	(
		FranticParticles.SetProperty  "PME:ReferenceColor" (val as string)
		setExtinction()	
	)	
	on chk_useAmbientPME changed state do 
	(
		FranticParticles.SetProperty "PME:UseExtinction" (state as string) 
		setExtinction()	
		updateToolbarButtons()
		try(Krakatoa_VFB_Overlay_Rollout.Refresh_GUI())catch()
	)	
	
	on chk_useAmbientPME rightClick do 
	(
		Krakatoa_GUI_Main.createDefaultsRCMenu "PME:UseExtinction" ">Use APME"
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos		
	)		
	
	on btn_PMEPresets pressed do 
	(
		createPresetsRCMenu()
		popUpMenu Krakatoa_RCMenu_Struct.Presets_RCMenu position:mouse.screenPos
	)
	
	fn refresh_GUI =
	(
		try(Krakatoa_GUI_AmbientPME.open = FranticParticles.GetBoolProperty "GUI:AmbientPMERolloutOpen")catch()

		chk_PMEfreeMode.state = (FranticParticles.GetBoolProperty "PME:FreeMode")
		updateFreeMode chk_PMEfreeMode.state 
		spn_ExtinctionRed.value = (FranticParticles.GetFloatProperty "ExtinctionRed") 
		spn_ExtinctionGreen.value = (FranticParticles.GetFloatProperty "ExtinctionGreen") 
		spn_ExtinctionBlue.value = (FranticParticles.GetFloatProperty "ExtinctionBlue") 
		chk_useAmbientPME.state = (FranticParticles.GetBoolProperty "PME:UseExtinction") 
		spn_PMEStart.value = (FranticParticles.GetFloatProperty "ExtinctionStart")
		spn_PMEDistance.value = (FranticParticles.GetFloatProperty "ExtinctionDistance" )
		clr_PMEBaseColor.color = (execute (FranticParticles.GetProperty  "PME:ReferenceColor"))
		
		setExtinction()	
		
		--ddl_PMEMode.selection = FindItem #("raytrace","all") (FranticParticles.GetProperty "PME:CalculationMode")
		updateSelectionSets()
		
		callbacks.removeScripts id:#KrakatoaPMENamedSelectionSetMonitor 
		try --Works only in 3ds Max 9 and higher
		(
			callbacks.addScript #NamedSelSetCreated "try(Krakatoa_GUI_AmbientPME.updateSelectionSets())catch()" id:#KrakatoaPMENamedSelectionSetMonitor 
			callbacks.addScript #NamedSelSetDeleted "try(Krakatoa_GUI_AmbientPME.updateSelectionSets())catch()" id:#KrakatoaPMENamedSelectionSetMonitor 
			callbacks.addScript #NamedSelSetRenamed "try(Krakatoa_GUI_AmbientPME.renamedSelectionSets (callbacks.notificationParam()))catch()" id:#KrakatoaPMENamedSelectionSetMonitor 
		)catch()	
	)
	on Krakatoa_GUI_AmbientPME rolledUp val do 
	(
		FranticParticles.SetProperty "GUI:AmbientPMERolloutOpen" val
			if val then 
				FranticParticles.LogDebug ("+Ambient PME Rollout ROLLED DOWN.")
			else
				FranticParticles.LogDebug ("+Ambient PME Rollout ROLLED UP.")	
	)		

	on Krakatoa_GUI_AmbientPME close do 
	(
		if Krakatoa_GUI_AmbientPME.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_AmbientPME.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_AmbientPME open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_AmbientPME.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+Ambient PME Rollout OPENED.")			
	)			
)--end rollout

-------------------------------------- 
--ABOUT ROLLOUT	
-------------------------------------- 
rollout Krakatoa_GUI_About "About" rolledup:true category:130 width:456
(
	button btn_Help_About "Open Krakatoa Online Help..." width:430 height:14 offset:[-10,-5] align:#left across:2
	on btn_Help_About pressed do shellLaunch "http://www.franticfilms.com/software/support/krakatoa/about.php" ""		

	button btn_Float_Rollout ">" height:14 width:20 offset:[10,-5] align:#right tooltip:"Float/Dock the Rollout. Right-Click for Menu..."
	
	on btn_Float_Rollout pressed do
	(
		FranticParticleRenderMXS.FloatRolloutButtonPressed Krakatoa_GUI_About
	)		
	on btn_Float_Rollout rightClick do
	(
		Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu_CurrentRollout = Krakatoa_GUI_About
		popupMenu Krakatoa_RCMenu_Struct.Float_Rollout_RCMenu pos:mouse.screenpos
	)				

	on Krakatoa_GUI_About moved pos do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" Krakatoa_GUI_About.title (pos as string)
	)	
	
	group "Krakatoa Copyrights and Contacts:" 
	(
		label lbl_Krakatoa_01 "" align:#left
		label lbl_Krakatoa_10 "KRAKATOA - Volumetric Particle Renderer." align:#left
		label lbl_Krakatoa_20 "" align:#left
		label lbl_Krakatoa_30 "" align:#left
		label lbl_Krakatoa_40 "" align:#left
		label lbl_Krakatoa_41 "All Rights Reserved." align:#left
		
		hyperlink url_02 "http://software.franticfilms.com/" address:"http://software.franticfilms.com/"  align:#left 
	)
	label lbl_Krakatoa_42 "" align:#left
	

	group "Frantic Software Development team:" 
	(
		label lbl_Krakatoa_49 "" align:#left
		
		label lbl_Krakatoa_50 "Concept, Research and Original Implementation: ..........................................................." align:#left across:2 
		label lbl_Krakatoa_51 " Mark Wiebe" align:#right			

		label lbl_Krakatoa_55 "Senior Software Developer: ..............................................................................................." align:#left across:2 
		label lbl_Krakatoa_56 " Darcy Harrison" align:#right

		label lbl_Krakatoa_57 "PFlow Operators Developer: ................................................................................" align:#left across:2 
		label lbl_Krakatoa_58 " Mike Yurick" align:#right
		
		label lbl_Krakatoa_60 "User Interface, Scripting and Documentation:................................................................. " align:#left across:2 
		label lbl_Krakatoa_61 " Borislav Petrov" align:#right
		
		label lbl_Krakatoa_65 "v1.0 Beta Management and Documentation: .................................................................... " align:#left across:2 
		label lbl_Krakatoa_66 " David Marks" align:#right
	)
	imgtag bmp_logo width:160 height:120 pos:[285,40] style:#bmp_center transparent:(color 192 192 192)	
	
	fn refresh_GUI = (
		--Krakatoa_GUI_About.open = false --always close the About rollout
			lbl_Krakatoa_20.text = ("Version: " + FranticParticles.Version + (if try((FranticParticles.HasValidLicense()))catch(false) then " - Licensed." else " - Evaluation Mode."))
			lbl_Krakatoa_40.text = ("Krakatoa - Copyright "+ (bit.intaschar 169) +"2004-2009 by Frantic Films,")				
		
	)
	
	local theLogoBitmap, theLogoBitmap2 
	fn updateLogo theBlue =
	(
		try(
			theLogoBitmap = (openbitmap (FranticParticles.KrakatoaHome +"\\Icons\\Krakatoa_logo_alpha.tga"))
			theBGColor = (colorman.getColor #background)*255
			theForeColor = (white - theBGColor + color 0 0 theBlue) * 0.5
			theLogoBitmap2 = bitmap theLogoBitmap.width theLogoBitmap.height
			for y = 0 to theLogoBitmap.height-1 do
			(
				thePixels = getPixels theLogoBitmap [0,y] theLogoBitmap.width
				for i = 1 to thePixels.count do
					thePixels[i] = (theForeColor * (thePixels[i].a/255.0)) + (theBGColor * (1.0 - thePixels[i].a/255.0))
				setPixels theLogoBitmap2 [0,y] thePixels 
			)
			bmp_logo.bitmap = theLogoBitmap2
			theLogoBitmap2 = theLogoBitmap = undefined
			gc light:true
			url_02.color = url_03.color = url_06.color = url_07.color = theForeColor 
			url_02.hoverColor = url_03.hoverColor = url_06.hoverColor = url_07.hoverColor = theForeColor * 1.2
		)	
		catch()		
	)
	
	
--		on bmp_logo lbuttondown thePoint theFlagd do updateLogo (length thePoint+100)
	
	on Krakatoa_GUI_About rolledUp val do 
	(
		--FranticParticles.SetProperty "GUI:AboutRolloutOpen" val
		if val then 
		(
			updateLogo 200
			FranticParticles.LogDebug ("+About Rollout ROLLED DOWN.")
		)	
		else
		(
			FranticParticles.LogDebug ("+About Rollout ROLLED UP.")			
		)	
	)	

	on Krakatoa_GUI_About close do 
	(
		if Krakatoa_GUI_About.inDialog and not Krakatoa_Closing_Floater then
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_About.title "false"
			Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		)	
	)	

	on Krakatoa_GUI_About open do 
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_About.title "true"
		Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()
		
		Refresh_GUI()
		FranticParticles.LogDebug ("+About Rollout OPENED.")			
	)			
)--end rollout


-----------------------------------------------------------------------------------------------------------------------------------------------------------
--Render Scene Dialog Floater - related code starts here
-----------------------------------------------------------------------------------------------------------------------------------------------------------
 
struct FranticParticleRenderMXSStruct (

DeadlineDetected = 0,
tagCounter = 0,
lastFrameRenderStartTime = 0,
lastFrameRenderEndTime = 0,
lockSecondaryToPrimaryFloater = true,
LoadSave_SingleRollout = undefined,
PresetFilterString = "",	
	
fn closerRolloutFloaters debugMessage:"Closed"=
(
--	if (classof renderers.current) != Krakatoa do 
	(
		try
		(
			closeRolloutFloater Krakatoa_Gui_floater
			FranticParticles.logDebug (">Krakatoa GUI Floater " + debugMessage)
		)catch()
		try
		(
			closeRolloutFloater Krakatoa_Gui_floater_2
			FranticParticles.logDebug (">Krakatoa Secondary Floater " + debugMessage)
		)catch()
		FranticParticles.LogWindowVisible = false
		updateToolbarButtons()
	)
),	

fn getParticlesFromScene =
(
	/*
	local theObjects = objects as array
	local renderPFG = FranticParticle.getBoolProperty "RenderParticleFlowGeometry" 
	local renderPFB = FranticParticle.getBoolProperty "RenderParticleFlowBBox" 
	local renderPFP = FranticParticle.getBoolProperty "RenderParticleFlowPhantom" 
	local renderGV = FranticParticle.getBoolProperty "RenderParticleFlowPhantom" 
	local renderLP = FranticParticle.getBoolProperty "RenderMaxParticles" 
	local renderTP = FranticParticle.getBoolProperty "RenderThinkingParticles" 
	local renderPRT = FranticParticle.getBoolProperty "RenderKrakatoaLoaders" 
	local renderOP = FranticParticle.getBoolProperty "RenderFumeFX" 
	
	for o in theObjects where \
		findItem GeometryClass.classes (classof o) > 0 AND \
		(classof o == PF_Source AND  ) OR \
		(classof o == Krakatoa_PRTLoader AND true )
	
	collect o
	*/
),

fn getMatteObjectsFromScene =
(
	
),

fn getAPMEObjectsFromScene =
(
	
),

fn isGeoVolume obj =
(
	(for m in obj.modifiers where m.classid as string == "#(323984483, 912984833)" AND m.enabled collect m).count > 0
),

fn getGeoVolumeEstimatedCount obj=
(
	try(
		local theGeoModifiers = for m in obj.modifiers where m.classid as string == "#(323984483, 912984833)" AND m.enabled collect m
		local theVolumeCount = "???"
		local theTM = (inverse obj.transform) 
		local theMin = (nodeLocalBoundingBox obj)[1] * theTM 
		local theMax = (nodeLocalBoundingBox obj)[2] * theTM
		local theBox = theMax-theMin
		local theSize = theBox / theGeoModifiers[1].particleSpacing 
		local theMaxCount = (floor (theSize.x+0.5) * floor (theSize.y+0.5) * floor (theSize.z+0.5) ) as integer
		local theMeshVolume = FranticParticleRenderMXS.CalculateVolume obj
		local theBoxVolume = theBox.x * theBox.y * theBox.z
		
		theVolumeCount = (theMaxCount * (theMeshVolume / abs theBoxVolume)) as integer
		FranticParticleRenderMXS.addCommas (theVolumeCount as string)
	)catch("???")	
),

fn GetDeadlineNetworkRoot =
(
	local theNetworkRoot = ""
	try 
	(
		local fileHandle = openFile( "c:/deadline/deadline.ini" )
		if fileHandle != undefined then
		(
			while not eof fileHandle do
			(
				local fileLine = readLine fileHandle 
				local index = findString fileLine "NetworkRoot="
				if index == 1 do theNetworkRoot = (substring fileLine 13 (fileLine.count-1)) 
			)
			close fileHandle 
		)
	) catch()
	theNetworkRoot 
),

fn DetectDeadline timeout:1000 forceloading:false = (
	FranticParticles.LogProgress ">Detecting Deadline Render Manager..."
	FranticParticleRenderMXS.DeadlineDetected = 0

	local KrakatoaPreferencesINI = (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini" )
	local theDetectValue = getIniSetting KrakatoaPreferencesINI "Deadline" "DetectDeadline"
	
	--if Deadline detection was explicitly disabled, return without checking.
	if theDetectValue == "1" do 
	(
		FranticParticles.LogProgress "  -Deadline Support is Explicitly DISABLED. Use Preferences Rollout to change..."
		return false
	)	
	
	--If Deadline functionality is already loaded in Max, figure out which version it was without reloading and if it was the one we wanted:
	if forceloading == false and SMTDPaths != undefined then 
	(
		if isProperty SMTDPaths #HomeDir and theDetectValue == "3" do
		(
			FranticParticles.LogProgress "  +Submit Max To Deadline Functions 3 or higher ALREADY LOADED!"
			FranticParticleRenderMXS.DeadlineDetected = 3
			return true	
		)	
		if not isProperty SMTDPaths #HomeDir and theDetectValue == "2" do
		(
			FranticParticles.LogProgress "  +Submit Max To Deadline Functions 2.x ALREADY LOADED!"
			FranticParticleRenderMXS.DeadlineDetected = 2
			return true
		)
		forceloading = true
	)
	try(destroyDialog SMTD_MainRollout)catch() --close the SMTD Dialog if open
	
	if theDetectValue == "" or theDetectValue == "3" do
	(
		--Try to detect Deadline 3.x 
		try
		(
			local result = -2
				
			local submitOutputFile = sysInfo.tempdir + "submitOutput.txt"
			local submitExitCodeFile = sysInfo.tempdir + "submitExitCode.txt"
			
			deleteFile submitOutputFile
			deleteFile submitExitCodeFile
					
			local commandArguments = "-outputfiles \"" + submitOutputFile + "\" \"" + submitExitCodeFile + "\" -getrepositoryroot"
			ShellLaunch "deadlinecommandbg.exe" commandArguments
					
			local startTimeStamp = timestamp()
			local ready = false
			while not ready do
			(
				sleep 0.15
				if doesFileExist submitExitCodeFile do
				(
					local theFile = openFile submitExitCodeFile
					try(result = readValue theFile)catch(result = -2)
					try(close theFile)catch()
					ready = true
				)	
				if timestamp() - startTimeStamp > timeout then 
				(
					result = -3
					ready = true
				)	
			)
			
			if result == 0 then
			(
				local resultFile = OpenFile submitOutputFile
				local resultMsg = ""
				if (resultFile != undefined) do
				(
					try(resultMsg = readLine resultFile)catch()
					try(close resultFile)catch()
				)
				local deadlineRoot = resultMsg
				FranticParticles.LogProgress "  +Deadline Render Manager 3 or higher DETECTED on your system!"
				if SMTDFunctions == undefined or forceloading==true or theDetectValue == "" then 
				(
					local deadlineSubmitFunctions = deadlineRoot + "\\submission\\3dsmax\\SubmitMaxToDeadline_Functions.ms"
					if deadlineRoot != "" and (doesFileExist deadlineSubmitFunctions) then 
					(
						try
						(
							fileIn deadlineSubmitFunctions
							SMTDFunctions.loadSettings()
							FranticParticleRenderMXS.DeadlineDetected = 3
							FranticParticles.LogProgress "  +Submit Max To Deadline Functions 3 or higher LOADED!"
							if theDetectValue == "" do 
							(
								setIniSetting KrakatoaPreferencesINI "Deadline" "DetectDeadline" "3"
								theDetectValue = "3"
								FranticParticles.LogProgress "  +Deadline 3 or higher set as DEFAULT Preference! Use Preferences Rollout to change..."	
							)	
						)
						catch
						(
							FranticParticles.LogProgress "  -FAILED to Load Submit Max To Deadline Functions 3 or higher!"
						)
					) 
				) 
			)
		)catch()
	)--end if search for Deadline 3.0
	
	if theDetectValue == "" or theDetectValue == "2" do
	(
		--try to get the Deadline 2.x Network Root
		if doesFileExist "c:/deadline/deadline.ini" do 
		(
			FranticParticles.LogProgress "  +Deadline Render Manager 2.x DETECTED on your system!"
			-- Run the deadline functions script to make sure we have the functions we need later.
			if SMTDFunctions == undefined or forceloading == true or theDetectValue == "" then 
			(
				local deadlineRoot = FranticParticleRenderMXS.GetDeadlineNetworkRoot()
				local deadlineSubmitFunctions = deadlineRoot + "\\submission\\3dsmax\\SubmitMaxToDeadline_Functions.ms"
				if deadlineRoot != "" and (doesFileExist deadlineSubmitFunctions) then 
				(
					try
					(
						fileIn deadlineSubmitFunctions
						SMTDFunctions.loadSettings()
						FranticParticleRenderMXS.DeadlineDetected = 2
						FranticParticles.LogProgress "  +Submit Max To Deadline Functions LOADED!"
						if theDetectValue == "" do 
						(
							setIniSetting KrakatoaPreferencesINI "Deadline" "DetectDeadline" "2"		
							FranticParticles.LogProgress "  +Deadline 2.x set as DEFAULT Preference! Use Preferences Rollout to change..."	
						)	
					)
					catch
					(
						FranticParticles.LogProgress "  -FAILED to Load Submit Max To Deadline Functions!"
					)
				) 
			) 
		)	
	)	
	if FranticParticleRenderMXS.DeadlineDetected < 2 then
		FranticParticles.LogWarning "  -FAILED to Detect any version of Deadline Render Manager."
),

fn LeadingZeros value count =
(
	local theStr = value as string
	local theCount = count-(theStr.count)
	if theCount < 1 then "" else substring "00000000000" 1 theCount
),

fn addCommas txt =
(
	theDot = findString txt "."
	if theDot == undefined then 
	(
		newTxt = "" 
		
		theDot = txt.count
	)	
	else 
	(
		newTxt = substring txt theDot -1
		theDot -= 1
	)
	cnt = 0
	for i = theDot to 1 by -1 do
	(
		cnt +=1
		newTxt = txt[i] + newTxt
		if cnt == 3 and i > 1 and txt[i-1] != "-" do 
		(
			newTxt = "," + newTxt
			cnt = 0
		)	
	)
	newTxt
),

fn CalculateVolume obj = 
( 
	local Volume= 0.0 
	local Center= [0.0, 0.0, 0.0] 
	local theMesh = snapshotasmesh obj
	local numFaces = theMesh.numfaces 
	for i = 1 to numFaces do 
	( 
	local Face= getFace theMesh i 
	local vert2 = getVert theMesh Face.z 
	local vert1 = getVert theMesh Face.y 
	local vert0 = getVert theMesh Face.x 
	local dV = Dot (Cross (vert1 - vert0) (vert2 - vert0)) vert0
	Volume+= dV 
	Center+= (vert0 + vert1 + vert2) * dV 
	) 
	delete theMesh
	Volume /= 6 
),

fn convertToHMS theTimeInSec precision:#integer =
(
	theHours = (floor (theTimeInSec/3600) ) as integer
	theMinutes = (floor ((theTimeInSec- theHours*3600)/60) as integer)
	if precision == #integer then
		theSeconds = (theTimeInSec - theHours*3600 - theMinutes * 60) as integer
	else
		theSeconds = (theTimeInSec - theHours*3600 - theMinutes * 60) 
	theHoursString = theHours as string
	if theHoursString.count == 1 do theHoursString = "0" + theHoursString 
	theMinutesString = theMinutes as string
	if theMinutesString .count == 1 do theMinutesString = "0" + theMinutesString 
	theSecondsString = theSeconds as string
	if theSecondsString .count == 1 do theSecondsString = "0" + theSecondsString 
	theHoursString + ":" + theMinutesString + ":" + theSecondsString 
),

------------------------------------------
--REFRESH ALL UI CONTROLS IN ALL ROLLOUTS
------------------------------------------
fn GlobalRefreshGUI = (
	FranticParticles.LogDebug ">Global Refresh GUI Called..."
	if Krakatoa_Gui_floater != undefined and Krakatoa_Gui_floater.open then 
	(
		Krakatoa_GUI_Presets.refresh_GUI()
		Krakatoa_GUI_Channels.refresh_GUI()
		Krakatoa_GUI_ThinkingParticles.refresh_GUI()
		
		Krakatoa_GUI_Partition.refresh_GUI()
		Krakatoa_GUI_ParticleLoaders.refresh_GUI()
		if Krakatoa_GUI_Target != undefined do
			Krakatoa_GUI_Target.refresh_GUI()
		Krakatoa_GUI_MatteObjects.refresh_GUI()
		Krakatoa_GUI_Preferences.refresh_GUI()
		Krakatoa_GUI_Particles.refresh_GUI()
		Krakatoa_GUI_Notes.refresh_GUI()
		Krakatoa_GUI_About.refresh_GUI()
		Krakatoa_GUI_AmbientPME.refresh_GUI()
		Krakatoa_GUI_Main.refresh_GUI()
		--Krakatoa_GUI_Main.scrollPos = 0
		FranticParticles.LogDebug "  +Global Refresh GUI Finished."
	)
	else
		FranticParticles.LogDebug "  -No Refresh - GUI Floater Not Open."
),

fn initDefaultSetting theKey theDefault =
(
	if  Krakatoa_IsRendering != true then
	(
		local theVal = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaDefaults.ini")  "Defaults"  theKey
		if theVal == "" then 
		(
			theVal = theDefault
			FranticParticles.LogDebug ("  >Initializing ["+ theKey+"] to DEFAULT value ["  + theVal + "]")
		)
		else	
			FranticParticles.LogDebug ("  >Initializing ["+ theKey+"] to custom value ["  + theVal + "]")
	)
	else
		theVal = theDefault		
	FranticParticles.AddProperty theKey theVal
),

------------------------------------------
--INITIALIZES THE SETTINGS IN A NEW RENDERER INSTANCE
------------------------------------------
-- The properties map is fairly strict about property names, and any property that gets used has to first
-- be added with AddProperty before it can be accessed.  
-- The custom initDefaultSetting() method calls AddProperty and also makes sure the setting is set to factory or user default value.
-- By doing this strict checking, typos in properties can be caught immediately instead of forming unnoticed bugs.
fn InitRenderer =
(
		local st = timestamp()
		FranticParticles.LogProgress (">Initializing Krakatoa Renderer v" + FranticParticles.Version + "...")
		-- Settings for Main Controls

		FranticParticleRenderMXS.initDefaultSetting "UseLighting" "false"
		FranticParticleRenderMXS.initDefaultSetting "BackgroundColor" "(color 0 0 0 0)"
		FranticParticleRenderMXS.initDefaultSetting "UseEnvironmentColor" "true"	
		FranticParticleRenderMXS.initDefaultSetting "UseEnvironmentReflections" "false"	
		FranticParticleRenderMXS.initDefaultSetting "UseFilterColor" "false"
	
		FranticParticleRenderMXS.initDefaultSetting "UseGlobalColorOverride" "false"
		FranticParticleRenderMXS.initDefaultSetting "ParticleColorSource" "Choose Color" 
		FranticParticleRenderMXS.initDefaultSetting "ChosenColor" "(color 255 255 255)"
		FranticParticleRenderMXS.initDefaultSetting "PostDivideByAlpha" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "Density:LinkLightingAndRenderingDensity" "true"
		FranticParticleRenderMXS.initDefaultSetting "Density:DensityMethod" "Volumetric Density" 
		FranticParticleRenderMXS.initDefaultSetting "DensityScalingSource" "Material Opacity" 
		FranticParticleRenderMXS.initDefaultSetting "Density:DensityPerParticle" "5"
		FranticParticleRenderMXS.initDefaultSetting "Density:DensityExponent" "-1" 
		
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Density:DensityMethod" "Volumetric Density" 
		FranticParticleRenderMXS.initDefaultSetting "Lighting:DensityScalingSource" "No Scaling" 
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Density:DensityPerParticle" "5"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Density:DensityExponent" "-1"

		FranticParticleRenderMXS.initDefaultSetting "RenderingMethod" "Particle Rendering"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:RenderingMethod" "Particle Rendering"
		
		FranticParticleRenderMXS.initDefaultSetting "VoxelSize" "0.5"
		FranticParticleRenderMXS.initDefaultSetting "VoxelFilterRadius" "1"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:VoxelSize" "0.5"
		FranticParticleRenderMXS.initDefaultSetting "Voxel:NumDensitySamples" "2"
		FranticParticleRenderMXS.initDefaultSetting "Voxel:NumLightSamples" "2"
		FranticParticleRenderMXS.initDefaultSetting "PhaseFunction" "Isotropic"
		FranticParticleRenderMXS.initDefaultSetting "PhaseEccentricity" "0"
		
		FranticParticleRenderMXS.initDefaultSetting "UseDepthMaps" "true"
		FranticParticleRenderMXS.initDefaultSetting "DrawPointFilter" "Bilinear" 
		FranticParticleRenderMXS.initDefaultSetting "AttenuationLookupFilter" "Bicubic" 
--		FranticParticleRenderMXS.initDefaultSetting "SortingMethod" "FranticThreaded" 
		FranticParticleRenderMXS.initDefaultSetting "SortingThreads" "0" 
	
		FranticParticleRenderMXS.initDefaultSetting "EnableMotionBlur" "false"
		FranticParticleRenderMXS.initDefaultSetting "EnableDepthOfField" "false"
		FranticParticleRenderMXS.initDefaultSetting "EnableAttenuationMapSaving" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "MotionBlurSegments" "2"
		FranticParticleRenderMXS.initDefaultSetting "JitteredMotionBlur" "false"
		FranticParticleRenderMXS.initDefaultSetting "DeformationMotionBlur" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "ShutterAngleInDegrees" "180"
		FranticParticleRenderMXS.initDefaultSetting "ShutterBias" "0"
		FranticParticleRenderMXS.initDefaultSetting "DepthOfFieldSampleRate" "0.1" --lowered from 1.0 to 0.1 as it was too slow for preview renders

		FranticParticleRenderMXS.initDefaultSetting "IgnoreMissingParticles" "false"

		FranticParticleRenderMXS.initDefaultSetting "RenderParticleFlowGeometry" "true"
		FranticParticleRenderMXS.initDefaultSetting "RenderParticleFlowBBox" "false"
		FranticParticleRenderMXS.initDefaultSetting "RenderParticleFlowPhantom" "true"
		FranticParticleRenderMXS.initDefaultSetting "RenderFumeFX" "true"
		
		FranticParticleRenderMXS.initDefaultSetting "RenderMaxParticles" "true"
		FranticParticleRenderMXS.initDefaultSetting "RenderThinkingParticles" "true"
		FranticParticleRenderMXS.initDefaultSetting "RenderGeometryVertices" "false"
		FranticParticleRenderMXS.initDefaultSetting "RenderKrakatoaLoaders" "true"
		FranticParticleRenderMXS.initDefaultSetting "RenderGeometryVolumes" "true"
		
		FranticParticleRenderMXS.initDefaultSetting "GlobalParticlePercentage" "100.0"
		
	
--		FranticParticleRenderMXS.initDefaultSetting "Lighting:Specular:Enabled" "false"
--		FranticParticleRenderMXS.initDefaultSetting "Lighting:Tangents:Enabled" "false"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Specular:Glossiness" "10.0"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Specular:Level" "100.0"
--		FranticParticleRenderMXS.initDefaultSetting "Lighting:Diffuse:Level" "100.0"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Specular:Anisotropy" "0.0"
		FranticParticleRenderMXS.initDefaultSetting "Lighting:Reflectance:Level" "100.0"
		
		FranticParticleRenderMXS.initDefaultSetting "EnableParticleCache" "false" 
		FranticParticleRenderMXS.initDefaultSetting "EnableLightingCache" "false"
		FranticParticleRenderMXS.initDefaultSetting "CacheLastFrame" "true"
		FranticParticleRenderMXS.initDefaultSetting "UseCacheInSlaveMode" "false"
		
		-- Settings for Particle Data	
		FranticParticleRenderMXS.initDefaultSetting "ParticleMode" "Render Scene Particles"
		FranticParticleRenderMXS.initDefaultSetting "ParticleFiles" ""
	
		--Advanced File Controls
		FranticParticles.AddProperty "ParticleFilesBase" ""
		FranticParticles.AddProperty "ParticleFilesProject" ""
		FranticParticles.AddProperty "ParticleFilesSequence" ""
		FranticParticles.AddProperty "ParticleFilesTake" ""
		FranticParticles.AddProperty "ParticleFilesName" ""		
		
		-- Settings for Particle Partitioning
		FranticParticleRenderMXS.initDefaultSetting "Partition:Count" "10"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementPositionRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementSpawnRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementSpeedRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementRotationRandomSeeds" "true"
		
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementFumeFXRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementOtherRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementLegacyRandomSeeds" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementThinkingRandomSeeds" "true"

		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementBox3Geometry" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementBox3Random" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementBox3ScalarVector" "true"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementBox3Icon" "true"
		
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementPRTModifiers" "false"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementGeometryModifiers" "false"
		
		
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementBox3DiskCacheNames" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "Partition:AffectSeedsInObjects" "#()"
		FranticParticleRenderMXS.initDefaultSetting "Partition:IncrementSelectedOnly" "false"
		FranticParticleRenderMXS.initDefaultSetting "Partition:skipExistingFiles" "false"	
		FranticParticleRenderMXS.initDefaultSetting "Partition:BackupRootMode" "1"	
		FranticParticleRenderMXS.initDefaultSetting "Partition:BackupRoot" ""	
			
		--Channels
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Velocity" "float16"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Color" "float32"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Density" "float16"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Normal" "float16"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Tangent" "float16"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:Lighting" "float16"
		FranticParticleRenderMXS.initDefaultSetting "Memory:Channel:MBlurTime" "float16"
		
		FranticParticleRenderMXS.initDefaultSetting "InactiveParticleChannels" "Age,int32,1,Orientation,float32,4,TextureCoord,float16,3,MaterialIndex,int32,1"
		FranticParticleRenderMXS.initDefaultSetting "ActiveParticleChannels" "Position,float32,3,Velocity,float16,3,Color,float16,3,Density,float16,1,Normal,float16,3,ID,int32,1"
		
		FranticParticleRenderMXS.initDefaultSetting "ParticleCountMemoryCalculator:Count" "100.0"
		
		
		--Settings for Thinking Particles Groups:
		FranticParticleRenderMXS.initDefaultSetting "InactiveTPGroups" ""
		
		-- Settings for Render Target
		FranticParticleRenderMXS.initDefaultSetting "RenderTarget" "Direct Render"
		FranticParticleRenderMXS.initDefaultSetting "XMLOutputFiles" ""
	
		-- Settings for Matte Objects
		FranticParticleRenderMXS.initDefaultSetting "Matte:UseMatteObjects" "true"
		FranticParticleRenderMXS.initDefaultSetting "Matte:DepthMapFiles" ""
		FranticParticleRenderMXS.initDefaultSetting "Matte:UseDepthMapFiles" "false"
		FranticParticleRenderMXS.initDefaultSetting "Matte:DepthMapNear" "0.0"
		FranticParticleRenderMXS.initDefaultSetting "Matte:DepthMapFar" "1000.0"
		FranticParticleRenderMXS.initDefaultSetting "Matte:DepthMapMode" "Camera Space Z Depth"
		FranticParticleRenderMXS.initDefaultSetting "Matte:NamedSelectionSets" "#()"
		FranticParticleRenderMXS.initDefaultSetting "Matte:RayDivisions" "1"
		FranticParticleRenderMXS.initDefaultSetting "Matte:SaveMultipleLayers" "false"
		FranticParticleRenderMXS.initDefaultSetting "Matte:UseRayTracing" "false" --fixme: temporary
		FranticParticleRenderMXS.initDefaultSetting "Matte:DepthMapMode" "Scanline" 
		
		--APME Settings
		FranticParticleRenderMXS.initDefaultSetting "AmbientParticipatingMediumExtinction" "0,0,0"
		FranticParticleRenderMXS.initDefaultSetting "ExtinctionRed" "0"
		FranticParticleRenderMXS.initDefaultSetting "ExtinctionGreen" "0"
		FranticParticleRenderMXS.initDefaultSetting "ExtinctionBlue" "0"		
		FranticParticleRenderMXS.initDefaultSetting "ExtinctionStart" "0"		
		FranticParticleRenderMXS.initDefaultSetting "ExtinctionDistance" "1000.0"	
		FranticParticleRenderMXS.initDefaultSetting "PME:NamedSelectionSets" "#()"	
		FranticParticleRenderMXS.initDefaultSetting "PME:FreeMode" "false"	
		FranticParticleRenderMXS.initDefaultSetting "PME:UseExtinction" "false"	
		FranticParticleRenderMXS.initDefaultSetting "PME:ReferenceColor" "color 255 255 255"			
		
		-- Settings for the GUI
		FranticParticles.AddProperty "GUI:Position" undefined
		FranticParticleRenderMXS.initDefaultSetting "GUI:Size" "[470,700]"
		
		FranticParticleRenderMXS.initDefaultSetting "GUI:PresetsRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:MainControlsRolloutOpen" "true"
		
		FranticParticleRenderMXS.initDefaultSetting "GUI:SaveParticlesRolloutOpen" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "GUI:ParticlePartitioningRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:ParticleSystemsRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:ShadowsRolloutOpen" "false"

		FranticParticleRenderMXS.initDefaultSetting "GUI:ParticleChannelsRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:ThinkingParticlesRolloutOpen" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "GUI:ParticleLoadersRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:MatteObjectsRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:RenderTargetRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:AboutRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:PreferencesRolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:AmbientPMERolloutOpen" "false"
		FranticParticleRenderMXS.initDefaultSetting "GUI:UserNotesRolloutOpen" "false"
		
		--Settings for the Presets and User Notes
		FranticParticleRenderMXS.initDefaultSetting "Presets:SaveRenderHistory" "true"
		FranticParticleRenderMXS.initDefaultSetting "Presets:SaveImageSample" "true" 
		FranticParticleRenderMXS.initDefaultSetting "UserNotes" ""
	
		-- Loading in these settings requires a global GUI refresh
		--FranticParticleRenderMXS.GlobalRefreshGUI()

		FranticParticleRenderMXS.initDefaultSetting "ForceWatermark" "false"
		
		FranticParticleRenderMXS.initDefaultSetting "VFB:InteractiveUpdate" "false"
		FranticParticleRenderMXS.initDefaultSetting "VFB:InteractiveUpdateThreshold" "2000"		
		
		local reManager = maxOps.GetCurRenderElementMgr()
		try(reManager.RemoveAllRenderElements())catch()
		
		FranticParticles.LogProgress ("  +Krakatoa Renderer INITIALIZED in " + (timestamp() - st) as string + " milliseconds.")
),

fn saveCustomProperty theKey =
(
	setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaDefaults.ini")  "Defaults"  theKey (FranticParticles.GetProperty theKey)
),

fn saveCustomDefaults =
(
	FranticParticleRenderMXS.saveCustomProperty "Density:LinkLightingAndRenderingDensity"  
	FranticParticleRenderMXS.saveCustomProperty "Density:DensityMethod" 
	FranticParticleRenderMXS.saveCustomProperty "DensityScalingSource"
	FranticParticleRenderMXS.saveCustomProperty "Density:DensityPerParticle" 
	FranticParticleRenderMXS.saveCustomProperty "Density:DensityExponent" 
	
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Density:DensityMethod" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:DensityScalingSource" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Density:DensityPerParticle" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Density:DensityExponent" 
	
	FranticParticleRenderMXS.saveCustomProperty "RenderingMethod" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:RenderingMethod" 
	
	FranticParticleRenderMXS.saveCustomProperty "VoxelSize"
	FranticParticleRenderMXS.saveCustomProperty "VoxelFilterRadius"
	FranticParticleRenderMXS.saveCustomProperty "Lighting:VoxelSize"
	FranticParticleRenderMXS.saveCustomProperty "Voxel:NumDensitySamples"
	FranticParticleRenderMXS.saveCustomProperty "Voxel:NumLightSamples"
	FranticParticleRenderMXS.saveCustomProperty "PhaseFunction"
	FranticParticleRenderMXS.saveCustomProperty "PhaseEccentricity"
	
	FranticParticleRenderMXS.saveCustomProperty "UseDepthMaps" 
	FranticParticleRenderMXS.saveCustomProperty "DrawPointFilter"  
	FranticParticleRenderMXS.saveCustomProperty "AttenuationLookupFilter" 
	FranticParticleRenderMXS.saveCustomProperty "SortingThreads" 
	
	FranticParticleRenderMXS.saveCustomProperty "EnableMotionBlur"  
	FranticParticleRenderMXS.saveCustomProperty "EnableDepthOfField" 
	FranticParticleRenderMXS.saveCustomProperty "EnableAttenuationMapSaving" 
	
	FranticParticleRenderMXS.saveCustomProperty "MotionBlurSegments" 
	FranticParticleRenderMXS.saveCustomProperty "JitteredMotionBlur" 
	FranticParticleRenderMXS.saveCustomProperty "DeformationMotionBlur" 
	FranticParticleRenderMXS.saveCustomProperty "DepthOfFieldSampleRate"  
	FranticParticleRenderMXS.saveCustomProperty "AmbientParticipatingMediumExtinction" 
	FranticParticleRenderMXS.saveCustomProperty "ExtinctionRed" 
	FranticParticleRenderMXS.saveCustomProperty "ExtinctionGreen" 
	FranticParticleRenderMXS.saveCustomProperty "ExtinctionBlue" 
	FranticParticleRenderMXS.saveCustomProperty "ExtinctionStart" 	
	FranticParticleRenderMXS.saveCustomProperty "ExtinctionDistance" 	
	FranticParticleRenderMXS.saveCustomProperty "PME:NamedSelectionSets"  
	FranticParticleRenderMXS.saveCustomProperty "PME:FreeMode"  
	FranticParticleRenderMXS.saveCustomProperty "PME:UseExtinction" 	
	FranticParticleRenderMXS.saveCustomProperty "PME:ReferenceColor" 	
	
	FranticParticleRenderMXS.saveCustomProperty "UseLighting" 
	FranticParticleRenderMXS.saveCustomProperty "ParticleColorSource" 
	FranticParticleRenderMXS.saveCustomProperty "BackgroundColor" 
	FranticParticleRenderMXS.saveCustomProperty "UseEnvironmentColor" 
	FranticParticleRenderMXS.saveCustomProperty "UseEnvironmentReflections"
	FranticParticleRenderMXS.saveCustomProperty "UseFilterColor"


	
	FranticParticleRenderMXS.saveCustomProperty "ChosenColor"  
	FranticParticleRenderMXS.saveCustomProperty "PostDivideByAlpha" 
	FranticParticleRenderMXS.saveCustomProperty "ShutterAngleInDegrees" 
	FranticParticleRenderMXS.saveCustomProperty "ShutterBias" 
	FranticParticleRenderMXS.saveCustomProperty "UseGlobalColorOverride" 

	FranticParticleRenderMXS.saveCustomProperty "RenderParticleFlowGeometry" 
	FranticParticleRenderMXS.saveCustomProperty "RenderParticleFlowBBox" 
	FranticParticleRenderMXS.saveCustomProperty "RenderParticleFlowPhantom" 
	FranticParticleRenderMXS.saveCustomProperty "RenderFumeFX" 
	
	FranticParticleRenderMXS.saveCustomProperty "RenderMaxParticles" 
	FranticParticleRenderMXS.saveCustomProperty "RenderThinkingParticles" 
	FranticParticleRenderMXS.saveCustomProperty "RenderGeometryVertices" 
	FranticParticleRenderMXS.saveCustomProperty "RenderKrakatoaLoaders" 
	FranticParticleRenderMXS.saveCustomProperty "RenderGeometryVolumes" 
	
	FranticParticleRenderMXS.saveCustomProperty "IgnoreMissingParticles"
	

	FranticParticleRenderMXS.saveCustomProperty "GlobalParticlePercentage" 

--	FranticParticleRenderMXS.saveCustomProperty "Lighting:Specular:Enabled"
--    FranticParticleRenderMXS.saveCustomProperty "Lighting:Tangents:Enabled"
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Specular:Glossiness" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Specular:Level"
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Specular:Anisotropy"
--	FranticParticleRenderMXS.saveCustomProperty "Lighting:Diffuse:Level" 
	FranticParticleRenderMXS.saveCustomProperty "Lighting:Reflectance:Level"
	
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Velocity" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Color" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Density" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Normal" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Tangent" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:Lighting" 
	FranticParticleRenderMXS.saveCustomProperty "Memory:Channel:MBlurTime" 
	
	FranticParticleRenderMXS.saveCustomProperty "EnableParticleCache" 
	FranticParticleRenderMXS.saveCustomProperty "EnableLightingCache" 
	FranticParticleRenderMXS.saveCustomProperty "CacheLastFrame" 
	
	-- Settings for Render Target
	FranticParticleRenderMXS.saveCustomProperty "RenderTarget" 
	FranticParticleRenderMXS.saveCustomProperty "XMLOutputFiles" 
	-- Settings for Particle Data	
	FranticParticleRenderMXS.saveCustomProperty "ParticleMode" 
	FranticParticleRenderMXS.saveCustomProperty "ParticleFiles" 
	--Advanced File Controls
	
	
	-- Settings for Matte Objects
	FranticParticleRenderMXS.saveCustomProperty "Matte:UseMatteObjects" 
	FranticParticleRenderMXS.saveCustomProperty "Matte:DepthMapFiles" 
	FranticParticleRenderMXS.saveCustomProperty "Matte:UseDepthMapFiles" 
	FranticParticleRenderMXS.saveCustomProperty "Matte:NamedSelectionSets"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:DepthMapNear"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:DepthMapFar"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:DepthMapMode"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:RayDivisions"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:SaveMultipleLayers"  
	FranticParticleRenderMXS.saveCustomProperty "Matte:UseRayTracing" --fixme: temporary
	FranticParticleRenderMXS.saveCustomProperty "Matte:DepthMapMode" 
	
	-- Settings for Particle Partitioning
	FranticParticleRenderMXS.saveCustomProperty "Partition:Count" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementPositionRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementSpawnRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementSpeedRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementRotationRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementFumeFXRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementOtherRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementLegacyRandomSeeds" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementThinkingRandomSeeds" 

	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementBox3DiskCacheNames" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementPRTModifiers" 
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementGeometryModifiers" 
	
	FranticParticleRenderMXS.saveCustomProperty "Partition:IncrementSelectedOnly"
	FranticParticleRenderMXS.saveCustomProperty "Partition:skipExistingFiles"
	
	FranticParticleRenderMXS.saveCustomProperty "Partition:BackupRootMode"
	FranticParticleRenderMXS.saveCustomProperty "Partition:BackupRoot" 
	
	FranticParticleRenderMXS.saveCustomProperty "GUI:PresetsRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:UserNotesRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:MainControlsRolloutOpen" 

	FranticParticleRenderMXS.saveCustomProperty "GUI:ParticleChannelsRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:ThinkingParticlesRolloutOpen" 
	
	FranticParticleRenderMXS.saveCustomProperty "GUI:ParticlePartitioningRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:ParticleSystemsRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:ShadowsRolloutOpen" 
	
	FranticParticleRenderMXS.saveCustomProperty "GUI:ParticleLoadersRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:MatteObjectsRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:RenderTargetRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:AboutRolloutOpen" 
	FranticParticleRenderMXS.saveCustomProperty "GUI:AmbientPMERolloutOpen" 
	
	--Settings for the Presets
	FranticParticleRenderMXS.saveCustomProperty "Presets:SaveRenderHistory" 
	FranticParticleRenderMXS.saveCustomProperty "Presets:SaveImageSample" 
	FranticParticleRenderMXS.saveCustomProperty "UserNotes" 
	
	FranticParticleRenderMXS.saveCustomProperty "GUI:Size" 
	
),

------------------------------------------
--POST LOAD EVENT FOR BACKWARDS COMPATIBILITY FIXES
------------------------------------------
fn PostLoadEvent =
(
	-- Loading a new file requires a global GUI refresh
	local st = timestamp()
	FranticParticleRenderMXS.GlobalRefreshGUI()
	FranticParticles.LogDebug ("  +PostLoadEvent Function FINISHED in " + (timestamp()-st) as string + " milliseconds.")
),

fn increasePFlowSystemLimits =
(
	FranticParticles.LogDebug ">Setting System Limit of all Particle Flow Emitters to 100 Million Particles..."
	cnt = 0
	for o in objects where classof o == PF_Source do 
	(
		if o.Particle_Amount_Limit < 100000000 do o.Particle_Amount_Limit = 100000000
		cnt += 1
	)	
	case of
	(
		(cnt == 0): (FranticParticles.LogDebug ("  -No Particle Flow Emitters found.")	)
		(cnt == 1): (FranticParticles.LogDebug ("  +One Particle Flow Emitter Processed.") )
		default: (FranticParticles.LogDebug ("  +"+ cnt as string +" Particle Flow Emitters Processed.") )
	)
		
),

-------------------------------------- 
--CALLED ON SAVE?
------------------------------------- 
fn CloseGUI =
(
	FranticParticles.LogDebug ">CloseGUI Function Called. Not implemented."
),


fn CancelGUI =
(
	FranticParticles.LogDebug ">CancelGUI Function Called. Not implemented."
),

-- This function sets the dropdown selection value to the item which matches the given string input.
-- The purpose of this is to store all drop down list items as text labels instead of integers, so we can
-- change the ordering and add new items in the middle without breaking compatibility.
fn SetDropDownValue dropDown value = (
	local i, valueToSet = 1
	for i = 1 to dropDown.items.count do (
		if value == dropDown.items[i] do (
			valueToSet = i
		)
	)
	dropDown.selection = valueToSet
),

-------------------------------------- 
--HELPER FUNCTIONS
--------------------------------------
fn GetEarliestBirthFrame = (
	FranticParticles.LogDebug ">GetEarliestBirthFrame Function Called."
	local emit_start = 99999999	--arbitrarily large number
	
	--Traverse each particle source.
	for o in objects where (classof o == PF_Source) do(

		--Traverse all the active(ie. fertile && renderable) Events
		for i = 1 to o.getNumInitialActionLists() do (
			local event = o.getInitialActionList i
			if( event.isActivated() and (event.isActionActive 1) == 1 ) do (
				
				--Check for a birth operator in operator slot 1
				local birth_op = (event.getAction 1)
				if(birth_op.isFertile()) do (
					local cur_start = try( (event.getAction 1).Emit_Start / TicksPerFrame )catch( emit_start )
					if( cur_start < emit_start ) do emit_start = cur_start
				)
			)
		)--1 to o.getNumInitialActionLists()
	)--o in objects
	if emit_start == 99999999 do return 0 --if the large number was not changed, we can as well use 0
	emit_start as integer
),

fn getSceneMappingChannelsUsed =
(
	local theMappingChannelsUsed = #{}
	
	try(
		local theObjects = getClassInstances OutputStandard
		if theObjects.count > 0 do
			theMappingChannelsUsed += (for i in theObjects where i.Data_Type==9 collect i.Map_Channel) as bitarray
	)catch()
	
	try(
		theObjects = getClassInstances mapping
		if theObjects.count > 0 do
			theMappingChannelsUsed += (for i in theObjects collect i.Map_Channel) as bitarray
	)catch()

	try(
		theObjects = getClassInstances Mapping_Object
			for o in theObjects do
				theMappingChannelsUsed += (for i = 1 to 32 where o.Acquire_From_Mapping_Channels[i] collect i) as bitarray
	)catch()
	theMappingChannelsUsed	
),

----------------------------------------------------------
--Preset Saving And Loading Functions
----------------------------------------------------------
fn saveRolloutPreset theRollout thePresetFile =
(
	FranticParticles.LogDebug (">Saving Settings of " + theRollout as string)

	local doNotShowThese = #(
			Krakatoa_GUI_Partition.edt_jobname,
			Krakatoa_GUI_Partition.edt_comment,
			Krakatoa_GUI_Partition.edt_user ,
			Krakatoa_GUI_Partition.edt_dept ,
			Krakatoa_GUI_Partition.ddl_category,
			Krakatoa_GUI_Partition.ddl_poollist,
			Krakatoa_GUI_Partition.chk_onlypool,
			Krakatoa_GUI_Partition.sld_priority,
			Krakatoa_GUI_Partition.spn_priority,
			Krakatoa_GUI_Partition.spn_chunkSize, 
			Krakatoa_GUI_Partition.spn_machineLimit,
			
			Krakatoa_GUI_Channels.spn_particleCount,
			Krakatoa_GUI_Channels.spn_MemoryUsage,
			
			Krakatoa_GUI_MatteObjects.edt_createNewSelSet,
			Krakatoa_GUI_AmbientPME.edt_createNewSelSet
	)
	
	
	for i in theRollout.controls do 
	(
		try
		(
			if findItem doNotShowThese i == 0 do
			(
				case (classof i) of
				(
					SpinnerControl: setIniSetting thePresetFile theRollout.name i.name (i.value as string)
					CheckButtonControl: setIniSetting thePresetFile theRollout.name i.name (i.state as string)
					ColorPickerControl: setIniSetting thePresetFile theRollout.name i.name (i.color as string)
					ComboBoxControl: setIniSetting thePresetFile theRollout.name i.name (i.selected as string)
					ListBoxControl: (
									if i == Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do
									(
										txt = "#("
										if i.items.count > 0 do
										(
											for j = 1 to i.items.count-1 do txt += "\"" + i.items[j] as string + "\","
											txt += "\"" + i.items[i.items.count] as string + "\""
										)	
										txt += ")"
										setIniSetting thePresetFile theRollout.name i.name txt 
									)	
								)
					PickerControl: (
								)	
					MultiListBoxControl: (
		
									)
					EditTextControl: (
									if i != Krakatoa_GUI_Notes.edt_userNotes AND i != Krakatoa_GUI_MatteObjects.edt_createNewSelSet do 
										setIniSetting thePresetFile theRollout.name i.name i.text 
									)
				)--end case
			)--end if	
		)catch()	
	)--end i loop
	FranticParticles.LogDebug "  +Rollout Settings SAVED."	
),
fn loadRolloutPreset theRollout thePresetFile =
(
	FranticParticles.LogDebug (">Loading Settings of " + theRollout as string)
	for i in theRollout.controls do 
	(
		theValue = getIniSetting thePresetFile theRollout.name i.name
		case (classof i) of
		(
			SpinnerControl: (
							if theValue != "" do try(i.set (i.value = execute theValue))catch()
						)
			CheckButtonControl: (
							if theValue != "" do try(i.changed (i.state = execute theValue))catch()
						)			
			ColorPickerControl: (
							if theValue != "" do try(i.changed (i.color = execute theValue))catch()
						)	
			PickerControl: (
						)							
			MultiListBoxControl: (
							)						
			ComboBoxControl: (
							if theValue != "" do 
							(
								try(
									theFN = execute (theRollout.name +"." + i.name + "_SelectedFN")
									theFN (i.selection = findItem i.items theValue)
								)catch()
							)			
						)	
			ListBoxControl: (
							if i == Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do
							(
								try(Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets.items = execute theValue; Krakatoa_GUI_MatteObjects.saveSelectionSets() )catch()
							)	
						)						
			EditTextControl: 
			(
				if i != Krakatoa_GUI_Notes.edt_userNotes AND i != Krakatoa_GUI_MatteObjects.edt_createNewSelSet do
					i.entered (i.text = TheValue)
			)
		)
	)	
	theRollout.Refresh_GUI()
	FranticParticles.LogDebug "  +Rollout Presets LOADED."	
),

fn framePreRender =
(
	FranticParticleRenderMXS.lastFrameRenderStartTime = timestamp()
),

fn framePostRender =
(
	FranticParticleRenderMXS.lastFrameRenderEndTime = timestamp()
),

fn saveSceneInfo thePresetFile =
(
	FranticParticles.LogDebug (">Saving Scene Info to [" + fileNameFromPath thePresetFile +"]...")
	renderSceneDialog.commit()
	setIniSetting thePresetFile "SceneInfo" "Path" maxFilePath
	setIniSetting thePresetFile "SceneInfo" "Name" maxFileName
	setIniSetting thePresetFile "SceneInfo" "Date" localtime
	setIniSetting thePresetFile "SceneInfo" "Output" rendOutputFileName
	setIniSetting thePresetFile "SceneInfo" "Build" FranticParticles.Version


	local theGeoVolumes = (for o in objects where findItem GeometryClass.classes (classof o) > 0 AND FranticParticleRenderMXS.isGeoVolume o AND classof o != TargetObject AND classof o != Thinking AND classof o != ParticleGroup AND o.renderable AND classof o != PF_Source AND classof o != KrakatoaPrtLoader collect o)
	local objectCount = "Lights:" + ((for o in objects where findItem light.classes (classof o) > 0 collect o).count as string)
	objectCount += ", Geometry:" + ((for o in objects where classof o != TargetObject AND findItem geometryClass.classes (classof o) > 0 AND classof o != PF_Source AND classof o != ParticleGroup AND classof o != KrakatoaPRTLoader and classof o != Thinking and findItem theGeoVolumes o == 0 collect o).count as string)
	
	local thePFlowEmitters = (for o in objects where classof o == PF_Source collect o)
	objectCount += ", PFlows:" + (thePFlowEmitters.count as string)
	
	local theThinking = for o in objects where classof o == Thinking collect o
	objectCount += ", Thinking:" + (theThinking.count as string)

	local thePRTLoaders = (for o in objects where classof o == KrakatoaPrtLoader collect o)
	objectCount += ", PrtLoaders:" + (thePRTLoaders.count as string)

	objectCount += ", GeoVolumes:" + (theGeoVolumes.count as string)

	setIniSetting thePresetFile "SceneInfo" "Objects" objectCount 
	
	for pfs in thePFlowEmitters do
	(
		actualAmount = requestedAmount = pfs.numParticles() / pfs.Quantity_Viewport * pfs.Quantity_Render
		if requestedAmount > pfs.Particle_Amount_Limit do actualAmount = pfs.Particle_Amount_Limit
		setIniSetting thePresetFile "SceneInfo" ("PFSource:" + pfs.name) (" render:"+actualAmount as string + " req:" + requestedAmount as string + " limit:" +  pfs.Particle_Amount_Limit as string)
	)	
	
	theNotes = try((FranticParticles.GetProperty "UserNotes") as stringStream)catch("" as stringStream)
	cnt = 0
	while not eof theNotes do
	(
		cnt += 1
		setIniSetting thePresetFile "SceneInfo" ("Note " + cnt as string) (readLine theNotes)
	)
	FranticParticles.LogDebug "+Scene Info SAVED."
),


fn savePresetAll thePresetFile =
(
	FranticParticles.LogDebug (">Saving Preset File [" + fileNameFromPath thePresetFile +"]...")
	--for r in Krakatoa_Gui_floater.rollouts where r != Krakatoa_GUI_Presets and r != Krakatoa_GUI_About and r != Krakatoa_GUI_Notes AND r != Krakatoa_GUI_ParticleLoaders do 
	local allRollouts = #(
			Krakatoa_GUI_Main, 
			Krakatoa_GUI_SaveParticles,
			Krakatoa_GUI_Channels, 
			Krakatoa_GUI_Partition, 
			Krakatoa_GUI_ThinkingParticles,
			Krakatoa_GUI_MatteObjects, 
			Krakatoa_GUI_Shadows,
			Krakatoa_GUI_AmbientPME
		)		
	for r in allRollouts do
	(
		FranticParticleRenderMXS.saveRolloutPreset r thePresetFile 
	)	
	FranticParticleRenderMXS.saveSceneInfo thePresetFile
	FranticParticles.LogDebug "  +Preset File SAVED."
),

fn loadPresetAll thePresetFile =
(
	FranticParticles.LogDebug (">Loading Preset File [" + fileNameFromPath thePresetFile +"]...")
	local allRollouts = #(
			Krakatoa_GUI_Main, 
			Krakatoa_GUI_SaveParticles,
			Krakatoa_GUI_Channels, 
			Krakatoa_GUI_Partition, 
			Krakatoa_GUI_ThinkingParticles,
			Krakatoa_GUI_MatteObjects, 
			Krakatoa_GUI_Shadows,
			Krakatoa_GUI_AmbientPME
			--Krakatoa_GUI_Preferences
		)		
	for r in allRollouts do	
	(
		FranticParticleRenderMXS.loadRolloutPreset r thePresetFile 
	)	
	FranticParticles.LogDebug "  +Preset File LOADED."
),

fn fixTimeString txt =
(
	local badStrings = "\\/:. "
	for i = 1 to txt.count do 
		if findString badStrings txt[i] != undefined do txt[i] = "_"
	txt	
),

fn saveRenderHistory =
(
	local st = timestamp()
	Krakatoa_GUI_Main.refreshCacheStatus()
	Krakatoa_GUI_Channels.updateMemChannels()
	if Krakatoa_GUI_Presets.chk_SaveRenderHistory.state then --Krakatoa_Gui_floater.open and 
	(
		FranticParticles.LogDebug (">Saving Render History...")
		theFile = getFileNameFile maxFileName + "_" + FranticParticleRenderMXS.fixTimeString localtime 
		theHistoryFile = Krakatoa_PresetsDirectory + "\\history\\" + theFile + ".KrakatoaSettings"
		
		savePresetAll theHistoryFile 
		saveSceneInfo theHistoryFile 
		
		if not doesFileExist (Krakatoa_PresetsDirectory+"\\_HistoryCache.List") do 
			Krakatoa_GUI_Presets.rebuildHistoryCache()
		try
		(
			FranticParticles.LogDebug ("  >Adding Render History To Cache...")
			theCache = openFile (Krakatoa_PresetsDirectory+"\\_HistoryCache.List") mode:"at"
			format "%\n" (getFileNameFile theHistoryFile) to:theCache
			close theCache
		)catch(FranticParticles.LogDebug ("  -Failed to add History File to CACHE."))	
		
		if FranticParticles.GetBoolProperty "Presets:SaveImageSample" AND FranticParticles.GetProperty "ParticleMode" == "Render Scene Particles" then
		(
			local theLastImage = getLastRenderedImage()
			theLastImage.filename = Krakatoa_PresetsDirectory + "\\samples\\" + theFile + ".exr"
			save theLastImage
			close theLastImage
			setIniSetting theHistoryFile "SampleImage" "Filename" (theFile + ".exr")
			setIniSetting theHistoryFile "SceneInfo" "RenderTime" (((timestamp()-FranticParticleRenderMXS.lastFrameRenderStartTime)/1000.0) as string + " sec.")
--			delete theLastImage --this was causing an early exit from the function!
			theLastImage = undefined
			gc light:true
		)
		else
		(
			setIniSetting theHistoryFile "SceneInfo" "SaveTime" (((FranticParticleRenderMXS.lastFrameRenderEndTime-FranticParticleRenderMXS.lastFrameRenderStartTime)/1000.0) as string + " sec." )
			setIniSetting theHistoryFile "SceneInfo" "ParticleFiles" (FranticParticles.GetProperty "ParticleFiles")
			setIniSetting theHistoryFile "SceneInfo" "ParticleFilesBase" (FranticParticles.GetProperty "ParticleFilesBase")
			setIniSetting theHistoryFile "SceneInfo" "ParticleFilesProject" (FranticParticles.GetProperty "ParticleFilesProject")
			setIniSetting theHistoryFile "SceneInfo" "ParticleFilesSequence" (FranticParticles.GetProperty "ParticleFilesSequence")
			setIniSetting theHistoryFile "SceneInfo" "ParticleFilesTake" (FranticParticles.GetProperty "ParticleFilesTake")
			setIniSetting theHistoryFile "SceneInfo" "ParticleFilesName" (FranticParticles.GetProperty "ParticleFilesName")
		)	
		
		local r=sysinfo.getSystemMemoryInfo()
		for i=2 to 7 do r[i] /= (1024*1024.)
		setIniSetting theHistoryFile "SceneInfo" "UsedMemory" ((r[1] as float) as string + "%")
		setIniSetting theHistoryFile "SceneInfo" "PhysicalMemory" ("Total:" + r[2] as string + " MB   Used:" + (r[2]-r[3]) as string + " MB   Free:" + r[3] as string + " MB")
		setIniSetting theHistoryFile "SceneInfo" "VirtualMemory" ("Total:" + r[6] as string + " MB   Used:" + (r[6]-r[7]) as string + " MB   Free:" + r[7] as string + " MB")
		setIniSetting theHistoryFile "SceneInfo" "PageFileSize" ("Total:" + r[4] as string + " MB   Used:" + (r[4]-r[5]) as string + " MB   Free:" + r[5] as string + " MB")
		
		r=sysinfo.getMAXMemoryInfo()
		for i=2 to 9 do r[i] /= (1024*1024.)
		setIniSetting theHistoryFile "SceneInfo" "PageFaultsCount" ((r[1] as integer) as string)
		setIniSetting theHistoryFile "SceneInfo" "WorkingSet" ("Size:" + r[3] as string + " MB   Peak:" + r[2] as string + " MB")
		setIniSetting theHistoryFile "SceneInfo" "PagedPool" ("Size:" + r[5] as string + " MB   Peak:" + r[4] as string + " MB")
		setIniSetting theHistoryFile "SceneInfo" "NonPagedPool" ("Size:" + r[7] as string + " MB   Peak:" + r[6] as string + " MB")
		setIniSetting theHistoryFile "SceneInfo" "PageFileUseage" ("Size:" + r[8] as string + " MB   Peak:" + r[9] as string + " MB")
		
	
		try(Krakatoa_GUI_Presets.btn_update.pressed())catch()
		FranticParticles.LogDebug ("  +Render History SAVED in " + (timestamp()-st) as string + " milliseconds.")
	)
	else
	(
		FranticParticles.LogDebug ("  -Render History NOT SAVED!")
	)	
),

fn initTreeView tv =
(
	local st = timestamp()
	FranticParticles.LogDebug (">Initializing TreeView...")
	tv.nodes.Clear()
	tv.checkboxes = true
	Krakatoa_DoExportTable = #()
	Krakatoa_ObjectsTable = #()
	tagCounter = 0
	FranticParticles.LogDebug ("  +TreeView INITIALIZED in " + (timestamp()-st) as string + " milliseconds." )
),

fn addChildren tv theNode theChildren theParent =
(
	for c in theChildren do
	(
		if classof c == RolloutClass then 
		(
			tagCounter += 1
			newNode = theNode.Nodes.add c.title
			newNode.checked = if FranticParticleRenderMXS.LoadSave_SingleRollout == undefined then true else FranticParticleRenderMXS.LoadSave_SingleRollout == c
			Krakatoa_DoExportTable[tagCounter] = newNode.checked
			
			newNode.forecolor = (dotNetClass "System.Drawing.Color").fromARGB 0 0 100 
			Krakatoa_ObjectsTable[tagCounter] = #(undefined, c)
			newNode.tag = dotNetMXSValue tagCounter 	
			FranticParticleRenderMXS.addChildren tv newNode c.controls c
		)
		goOn = true
		theControlClass = classof c 
		if theControlClass == SpinnerControl or theControlClass == CheckButtonControl or theControlClass == ColorPickerControl or theControlClass == EditTextControl or theControlClass == ComboBoxControl or theControlClass == MultiListBoxControl or theControlClass == PickerControl or theControlClass == ListBoxControl do
		(
			if Krakatoa_PresetDialogMode == #load or Krakatoa_PresetDialogMode == #loadHistory then
			(
				theKeys = getIniSetting Krakatoa_PresetIniFile theParent.name
				if findItem theKeys c.name > 0 then 
					theValueString = getIniSetting Krakatoa_PresetIniFile theParent.name c.name
				else
					GoOn = false
			)	
			else
			(
				case theControlClass of 
				(
					SpinnerControl: theValueString = c.value as string
					CheckButtonControl: theValueString = c.state as string
					ColorPickerControl: theValueString = c.color as string
					PickerControl: theValueString = if c.object!=undefined then c.object.name else "Pick Node"
					ListBoxControl: (
									theValueString = c.items as string
									if c != Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do GoOn = false
								)	
					MultiListBoxControl: (
						GoOn = false
					)
					EditTextControl: theValueString = c.text 
					ComboBoxControl: theValueString = c.selected
					default: (GoOn = false)
				)--end case
			)	
			doNotShowThese = #(
					Krakatoa_GUI_Partition.edt_jobname,
					Krakatoa_GUI_Partition.edt_comment,
					Krakatoa_GUI_Partition.edt_user ,
					Krakatoa_GUI_Partition.edt_dept ,
					Krakatoa_GUI_Partition.ddl_category,
					Krakatoa_GUI_Partition.ddl_poollist,
					Krakatoa_GUI_Partition.chk_onlypool,
					Krakatoa_GUI_Partition.sld_priority,
					Krakatoa_GUI_Partition.spn_priority,
					Krakatoa_GUI_Partition.spn_chunkSize, 
					Krakatoa_GUI_Partition.spn_machineLimit,
					Krakatoa_GUI_MatteObjects.edt_createNewSelSet
			)
			
			if findItem doNotShowThese c > 0 do GoOn = false
			if GoOn then
			(
				if c.caption == "" then txt = c.name else txt = trimLeft c.caption				
				if matchPattern txt pattern:"ddl_*" do txt = substring txt 5 -1
				if matchPattern txt pattern:"lbx_*" do txt = substring txt 5 -1
				txt += " ["+ theValueString +"]"
				
				newNode = theNode.Nodes.add txt 
				newNode.checked = true
				tagCounter += 1
				Krakatoa_ObjectsTable[tagCounter] = #(theParent , c)
				Krakatoa_DoExportTable[tagCounter] = true
				newNode.tag = dotNetMXSValue tagCounter 
			)--end if goOn
		)--end if class	
	)--end c loop
),

fn fillInTreeView tv =
(
	local st = timestamp()
	FranticParticles.LogDebug (">Populating TreeView...")
	theRoot = tv.nodes.add "" 
	case Krakatoa_PresetDialogMode of
	(
		#save: 
			(
				theRoot.text = "SAVE Krakatoa Render Dialog Preset"
				theRoot.forecolor = (dotNetClass "System.Drawing.Color").fromARGB 200 0 0 
			)	
		#load: 
			(
				if Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected != undefined then 
					theRoot.text = "LOAD Krakatoa Render Dialog Preset [" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + "]"
				else	
					theRoot.text = "NO RENDER PRESETS FOUND!"
				theRoot.forecolor = (dotNetClass "System.Drawing.Color").fromARGB 0 100 0 
			)	
		#loadHistory: 
			(
				if Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected != undefined then 
					theRoot.text = "LOAD Krakatoa Render History [" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + "]"
				else	
					theRoot.text = "NO RENDER HISTORY FILES FOUND!"
				theRoot.forecolor = (dotNetClass "System.Drawing.Color").fromARGB 0 100 0  
			)						
	)	
	theRoot.checked = true
	
	tagCounter += 1
	Krakatoa_ObjectsTable[tagCounter] = #(undefined,Krakatoa_Gui_floater)
	Krakatoa_DoExportTable[tagCounter] = false
	local rootNodes = #(
		Krakatoa_GUI_Main, 
		Krakatoa_GUI_SaveParticles,
		Krakatoa_GUI_Channels, 
		Krakatoa_GUI_Partition, 
		Krakatoa_GUI_ThinkingParticles,
		Krakatoa_GUI_MatteObjects, 
		Krakatoa_GUI_Shadows,
		Krakatoa_GUI_AmbientPME
	)
	
	--if Krakatoa_PresetDialogMode == #save and FranticParticleRenderMXS.LoadSave_SingleRollout != undefined and classof FranticParticleRenderMXS.LoadSave_SingleRollout== RolloutClass do
		--rootNodes = #(FranticParticleRenderMXS.LoadSave_SingleRollout)
	
	if Krakatoa_PresetDialogMode == #save do
	(
		FranticParticleRenderMXS.addChildren tv theRoot rootNodes Krakatoa_Gui_floater 
	)	
	if Krakatoa_PresetDialogMode == #load or Krakatoa_PresetDialogMode == #loadHistory do
	(
		if Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected != undefined then 
		(
			theCategories = getIniSetting Krakatoa_PresetIniFile 
			rootNodes = for o in rootNodes where findItem theCategories o.name > 0 collect o
			FranticParticleRenderMXS.addChildren tv theRoot rootNodes Krakatoa_Gui_floater 
		)	
	)	
	theRoot.tag = dotNetMXSValue tagCounter 			
	theRoot.expand()
	FranticParticles.LogDebug ("  +TreeView POPULATED in " + (timestamp()-st) as string + " milliseconds." )
),

fn loadSaveButtonPressed =
(
	if Krakatoa_PresetDialogMode == #save do
	(
		deleteFile Krakatoa_PresetIniFile
		exportCurrentRollout = false
		for o = 1 to Krakatoa_ObjectsTable.count do
		(
			theRollout = Krakatoa_ObjectsTable[o][1]
			theControl = Krakatoa_ObjectsTable[o][2]
			if theRollout == undefined do exportCurrentRollout = Krakatoa_DoExportTable[o]
			if exportCurrentRollout and theRollout != undefined and Krakatoa_DoExportTable[o] == true do
			(
				case (classof theControl) of
				(
					SpinnerControl: setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name (theControl.value as string)
					CheckButtonControl: setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name (theControl.state as string)
					ColorPickerControl: setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name (theControl.color as string)
					ComboBoxControl: setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name theControl.selected
					ListBoxControl: (
							if theControl == Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do
							(
								txt = "#("
								if theControl.items.count > 0 do
								(
									for i = 1 to theControl.items.count-1 do txt += "\"" + theControl.items[i] as string + "\","
									txt += "\"" + theControl.items[theControl.items.count] as string + "\""
								)	
								txt += ")"
								setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name txt 
							)	
						)					
					PickerControl: (
								)								
					MultiListBoxControl: (
									)
					
					EditTextControl: (
										if theControl != Krakatoa_GUI_Notes.edt_userNotes AND theControl != Krakatoa_GUI_MatteObjects.edt_createNewSelSet then
											setIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name theControl.text
									)	
				)--end case
			)
		)--end o loop
		FranticParticleRenderMXS.saveSceneInfo Krakatoa_PresetIniFile	
		try(Krakatoa_GUI_Presets.btn_update.pressed())catch()		
		FranticParticleRenderMXS.LoadSave_SingleRollout = undefined
	)--end save
		
	if Krakatoa_PresetDialogMode == #load or Krakatoa_PresetDialogMode == #loadHistory do
	(
			exportCurrentRollout = false
			for o = 1 to Krakatoa_ObjectsTable.count do
			(
				theRollout = Krakatoa_ObjectsTable[o][1]
				theControl = Krakatoa_ObjectsTable[o][2]
				if theRollout == undefined do exportCurrentRollout = Krakatoa_DoExportTable[o]
				if exportCurrentRollout and theRollout != undefined and Krakatoa_DoExportTable[o] == true do
				(
					theValue = getIniSetting Krakatoa_PresetIniFile theRollout.name theControl.name
					case (classof theControl) of
					(
						SpinnerControl: (
										if theValue != "" do try(theControl.changed (theControl.value = execute theValue))catch()
									)
						CheckButtonControl: (
										if theValue != "" do try(theControl.changed (theControl.state = execute theValue))catch()
									)			
						ColorPickerControl: (
										if theValue != "" do try(theControl.changed (theControl.color = execute theValue))catch()
									)	
						PickerControl: (
									)												
						MultiListBoxControl: (
										)												
						ComboBoxControl: (
										if theValue != "" do 
										(
											try(
												theFN = execute (theRollout.name +"." + theControl.name + "_SelectedFN")
												theFN (theControl.selection = findItem theControl.items theValue)
											)catch()
										)			
									)		
						ListBoxControl: (
							if theControl == Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets do
							(
								try(Krakatoa_GUI_MatteObjects.lbx_useNamedSelectionSets.items = execute theValue; Krakatoa_GUI_MatteObjects.saveSelectionSets())catch()
							)	
						)		
						EditTextControl: 
						(
							if theControl != Krakatoa_GUI_Notes.edt_userNotes AND theControl  != Krakatoa_GUI_MatteObjects.edt_createNewSelSet do
								try(theControl.changed (theControl.text = theValue))catch()
						)					
					)	
				)
			)--end o loop
			local allRollouts = #(
				Krakatoa_GUI_Main, 
				Krakatoa_GUI_SaveParticles,
				Krakatoa_GUI_Channels, 
				Krakatoa_GUI_Partition, 
				Krakatoa_GUI_ThinkingParticles,
				Krakatoa_GUI_MatteObjects, 
				Krakatoa_GUI_Shadows,
				Krakatoa_GUI_AmbientPME
			)				
			for i in allRollouts do try(i.Refresh_GUI())catch()
	)--end load
	try(destroyDialog Krakatoa_SavePresetDialog)catch()
),

fn compareFN v1 v2 valArray: =
(
	if valArray[v1] > valArray[v2] then 1 else -1
),

fn sortFilesByDate theFiles feedback:#none=
(
	if theFiles.count == 0 do return #()
	
	local theYearIndex = 3 --init. a variable to store the position of the year
	local theMonthIndex = 1 --init. a variable to store the position of the month
	local theDayIndex = 2 --init. a variable to store the position of the day
	--collect all creation dates as string-filtered arrays
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Collecting File Creation Dates..."
	theFileDates = for f in theFiles collect filterString (getFileCreateDate f) " /\\:.;_"
	
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Collecting Indices For Sorting..."
	indexArray = for i = 1 to theFileDates.count collect i --collect indices for qsorting
	
	--add a leading zero to any entries with just 1 character
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Adding Leading Zeros..."
	for f = 1 to theFileDates.count do for i = 1 to theFileDates[f].count do if theFileDates[f][i].count == 1 do theFileDates[f][i] = "0" + theFileDates[f][i]
	--add 12 to the hours if the last entry is PM
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Converting to 24 Hours Format..."
	for f = 1 to theFileDates.count where try(matchPattern theFileDates[f][7] pattern:"PM")catch(false) do theFileDates[f][4] = (execute theFileDates[f][4] + 12) as string
	--go through all elements of the first date and find the position of the entry with 4 digits - that should be the year
	
--REMOVED, CREATION DATE APPEARS TO BE CONSISTENT BETWEEN WINDOWS INSTALLATIONS
	--for i = 1 to theFileDates[1].count where theFileDates[1][i].count == 4 do theYearIndex = i
	
--REMOVED, CREATION DATE APPEARS TO BE CONSISTENT BETWEEN WINDOWS INSTALLATIONS
	--go through all arrays until a monthIndex is resolved
	/*
	for f in theFileDates while theMonthIndex == 0 do
	(
		case theYearIndex of
		(
			1: ( --if the year is the first entry, look for second and third entry greater than 12 - that would be the day
				if execute f[2] > 12 do (theMonthIndex = 3; theDayIndex = 2)
				if execute f[3] > 12 do (theMonthIndex = 2; theDayIndex = 3)
			)
			3: (--if the year is the third entry, lool for first and second entry greater than 12 - that would be the day
				if execute f[1] > 12 do (theMonthIndex = 2; theDayIndex = 1)
				if execute f[2] > 12 do (theMonthIndex = 1; theDayIndex = 2)
			)
		)--end case
	)--end f loop
	*/
	--now collect all 6 elements based on the indices we detected as a single string - year first, then month, then day, then time
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Building Array For Sorting..."
	theFileDates = for f in theFileDates collect f[theYearIndex]+f[theMonthIndex]+f[theDayIndex]+f[4]+f[5]+f[6]
	--qsort the index array by passing the array of date strings as value array for comparisson
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Sorting History By Creation Date..."
	qsort indexArray FranticParticleRenderMXS.compareFN valArray:theFileDates
	--finally, use the sorted index array to collect and return the files in the inverse creation order - newest on top:
	if feedback == #history do Krakatoa_GUI_FileSortingProgress_Dialog.lbl_feedback.text = "Collecting Sorted Results..."
	for i in indexArray collect theFiles[i]
),

fn presetToLoadDDLSelected itm =
(
	if itm > 0 then
	(
		if Krakatoa_PresetDialogMode == #load do 
			Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "\\presets\\" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + ".KrakatoaPreset")
			
		if Krakatoa_PresetDialogMode == #loadHistory do 
			Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "\\history\\" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + ".KrakatoaSettings")
		
		if doesFileExist Krakatoa_PresetIniFile then
		(
			Krakatoa_SavePresetDialog.btn_loadsave.enabled = true
			--FranticParticleRenderMXS.initTreeView Krakatoa_SavePresetDialog.dn_tv 
		)	
		else
		(
			Krakatoa_SavePresetDialog.btn_loadsave.enabled = false
		)	
	)	
	else	
	(
		Krakatoa_PresetIniFile = ""
		Krakatoa_SavePresetDialog.btn_loadsave.enabled = false
	)	
	FranticParticleRenderMXS.initTreeView Krakatoa_SavePresetDialog.dn_tv 
	FranticParticleRenderMXS.fillInTreeView Krakatoa_SavePresetDialog.dn_tv 
),

fn loadSaveDialogOpen =
(
	local st = timestamp()
	FranticParticles.LogDebug (">Opening Load/Save Dialog...")
	case Krakatoa_PresetDialogMode of
	(
		#load: (
				Krakatoa_SavePresetDialog.title = "Krakatoa: LOAD Render Preset"
				Krakatoa_SavePresetDialog.btn_loadsave.caption = "LOAD PRESET..." 
				Krakatoa_SavePresetDialog.lbl_edittext.text = "Filter Pattern:"
				theFiles = getFiles (Krakatoa_PresetsDirectory + "\\presets\\"+ FranticParticleRenderMXS.PresetFilterString +"*.KrakatoaPreset")
				if theFiles.count == 0 then 
				(
					Krakatoa_SavePresetDialog.btn_loadsave.enabled = false
					Krakatoa_SavePresetDialog.ddl_presetsToLoad.items = #()
				)	
				else
				(
					theFiles = FranticParticleRenderMXS.sortFilesByDate theFiles 
					Krakatoa_SavePresetDialog.ddl_presetsToLoad.items = for f in theFiles collect getFileNameFile f
					if Krakatoa_GUI_Presets.rad_files01.state == 1 then
					(
						try		
							Krakatoa_SavePresetDialog.ddl_presetsToLoad.selection = findItem Krakatoa_SavePresetDialog.ddl_presetsToLoad.items Krakatoa_GUI_Presets.ddl_historyFiles01.selected
						catch
							Krakatoa_SavePresetDialog.ddl_presetsToLoad.selection = 1
					)
					else
						Krakatoa_SavePresetDialog.ddl_presetsToLoad.selection = 1
					Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "\\presets\\" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + ".KrakatoaPreset")
				)	
				FranticParticles.LogDebug ("  +Load Preset Dialog OPENED in " + (timestamp()-st) as string + " milliseconds.")
			)
		#loadHistory: (
				Krakatoa_SavePresetDialog.title = "Krakatoa: LOAD Render History Settings:"
				Krakatoa_SavePresetDialog.btn_loadsave.caption = "LOAD HISTORY..." 
				Krakatoa_SavePresetDialog.lbl_edittext.text = "Filter Pattern:"
				theFiles = getFiles (Krakatoa_PresetsDirectory + "\\history\\"+FranticParticleRenderMXS.PresetFilterString+ "*.KrakatoaSettings")
				if theFiles.count == 0 then 
				(
					Krakatoa_SavePresetDialog.btn_loadsave.enabled = false
					Krakatoa_SavePresetDialog.ddl_presetsToLoad.items = #()
				)	
				else
				(
					theFiles = FranticParticleRenderMXS.sortFilesByDate theFiles 
					Krakatoa_SavePresetDialog.ddl_presetsToLoad.items = for f in theFiles collect getFileNameFile f
					Krakatoa_SavePresetDialog.ddl_presetsToLoad.selection = 1	
					if Krakatoa_GUI_Presets.open and Krakatoa_GUI_Presets.rad_files01.state == 2 do
						try		
							Krakatoa_SavePresetDialog.ddl_presetsToLoad.selection = findItem Krakatoa_SavePresetDialog.ddl_presetsToLoad.items Krakatoa_GUI_Presets.ddl_historyFiles01.selected
						catch()
								
					Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "\\history\\" + Krakatoa_SavePresetDialog.ddl_presetsToLoad.selected + ".KrakatoaSettings")
					FranticParticles.LogDebug ("  +Load History Dialog OPENED in " + (timestamp()-st) as string + " milliseconds.")
				)	
			)					
		#save: (
				theFiles = getFiles (Krakatoa_PresetsDirectory + "\\presets\\*.KrakatoaPreset")
				theFiles = FranticParticleRenderMXS.sortFilesByDate theFiles 
				Krakatoa_SavePresetDialog.ddl_presetsToLoad.items = for f in theFiles collect getFileNameFile f
			
				Krakatoa_SavePresetDialog.title = "Krakatoa: SAVE Render Preset"
				Krakatoa_SavePresetDialog.btn_loadsave.caption = "SAVE PRESET..." 
				Krakatoa_SavePresetDialog.lbl_edittext.text = "Preset Name:"
				local thePresetFileName = if maxFileName != "" then (getFileNameFile maxFileName) else "Preset"
				if FranticParticleRenderMXS.LoadSave_SingleRollout != undefined do thePresetFileName += "_" + FranticParticleRenderMXS.fixTimeString FranticParticleRenderMXS.LoadSave_SingleRollout.title
				Krakatoa_SavePresetDialog.edt_presetsToSave.text = thePresetFileName
				Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "\\presets\\" + Krakatoa_SavePresetDialog.edt_presetsToSave.text + ".KrakatoaPreset")
				FranticParticles.LogDebug ("  +Save Preset Dialog OPENED in " + (timestamp()-st) as string + " milliseconds.")
			)
	)		
),

fn displaySavePresetDialog =
(
	local st = timestamp()
	try(destroyDialog Krakatoa_SavePresetDialog)catch()
	rollout Krakatoa_SavePresetDialog "" 
	(
		dotNetControl dn_tv "TreeView" width:590 height:590 align:#center
		
		button btn_cancel "Cancel" height:40 width:60 align:#left across:2 offset:[-5,-3]
		button btn_loadsave "SAVE PRESET..." height:40 width:100 align:#right offset:[5,-3]
		label lbl_edittext "Filter Pattern:" pos:[75,598]
		edittext edt_presetsToSave text:"" width:347 pos:[136,597]
		dropdownlist ddl_presetsToLoad width:410 pos:[75,616]
			
		on btn_cancel pressed do try(destroyDialog Krakatoa_SavePresetDialog)catch()

		on btn_loadsave pressed do FranticParticleRenderMXS.loadSaveButtonPressed()

		on dn_tv AfterCheck arg do
			if arg.node.tag != undefined do 
				Krakatoa_DoExportTable[arg.node.tag.value] = arg.node.checked

		on edt_presetsToSave entered txt do 
		(
			if Krakatoa_PresetDialogMode == #save then
				Krakatoa_PresetIniFile = (Krakatoa_PresetsDirectory + "/presets/" + txt + ".KrakatoaPreset") 
		)
		
		on edt_presetsToSave changed txt do 
		(
			if Krakatoa_PresetDialogMode != #save then
			(
				FranticParticleRenderMXS.PresetFilterString = txt
				FranticParticleRenderMXS.loadSaveDialogOpen()
				FranticParticleRenderMXS.presetToLoadDDLSelected ddl_presetsToLoad.selection
			)				
		)		
		
		on ddl_presetsToLoad selected itm do 
		(
			if Krakatoa_PresetDialogMode == #save then
				edt_presetsToSave.entered (edt_presetsToSave.text = ddl_presetsToLoad.selected)
			else
				FranticParticleRenderMXS.presetToLoadDDLSelected itm
		)	
			
		on Krakatoa_SavePresetDialog open do 
		(
			if Krakatoa_PresetDialogMode != #save do edt_presetsToSave.text = FranticParticleRenderMXS.PresetFilterString 
			FranticParticleRenderMXS.loadSaveDialogOpen()
			FranticParticleRenderMXS.initTreeView dn_tv
			FranticParticleRenderMXS.fillInTreeView dn_tv
		)
	)
	createDialog Krakatoa_SavePresetDialog 600 640 --modal:true	
	FranticParticles.LogDebug ("  +Dialog Using DotNet TreeView Control CREATED in " + (timestamp()-st) as string + " milliseconds.")

),


fn compareSettings theFile1 theFile2 =
(
	FranticParticles.LogDebug ">CompareSettings Function Called."
	FranticParticles.LogDebug ("   File 1: [" + filenamefrompath theFile1 + "]")
	FranticParticles.LogDebug ("   File 2: [" + filenamefrompath theFile2 + "]")
	
	theDiffsArray = #()
	theCats1 = for i in getIniSetting theFile1 where i != "SceneInfo" and i != "SampleImage" collect i
	theCats2 = for i in getIniSetting theFile2 where i != "SceneInfo" and i != "SampleImage" collect i
	for c in theCats1 do
	(
		theKeys1 = (getIniSetting theFile1 c)
		theKeys2 = (getIniSetting theFile2 c)
		for k in theKeys1 do
		(
			theVal1 = getIniSetting theFile1 c k
			if findItem theKeys2 k == 0 then
			(
				append theDiffsArray #(c, k, theVal1, "no such key" )
			)
			else
			(
				theVal2 = getIniSetting theFile2 c k
				if theVal1 != theVal2 then
					append theDiffsArray #(c, k, theVal1, theVal2)
			)	
		)
		for k in theKeys2 do
		(
			theVal2 = getIniSetting theFile2 c k
			if findItem theKeys1 k == 0 then
				append theDiffsArray #(c, k, "no such key", theVal2 )
		)	
	)	
	for c in theCats2 do
	(
		if findItem theCats1 c == 0 then
		(
			theKeys2 = (getIniSetting theFile2 c)
			for k in theKeys2 do
			(
				theVal2 = getIniSetting theFile2 c k
				append theDiffsArray #(c, k, "no such key", theVal2 )
			)	
		)
	)
	case of
	(
		(theDiffsArray.count == 0): (FranticParticles.LogDebug ("  +CompareSettings Function Finished. No Differences Found."))
		(theDiffsArray.count == 1): (FranticParticles.LogDebug ("  +CompareSettings Function Finished. One Difference Found."))
		(theDiffsArray.count > 1): (FranticParticles.LogDebug ("  +CompareSettings Function Finished. " + theDiffsArray.count as string +" Differences Found."))
	)	
	theDiffsArray 
),

fn floatOrDockRollout theRollout forceMode:#none =
(
	local currentVisibility = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" theRollout.title ) 
	
	--if currentVisibility == false then return false
	local currentState =  execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" theRollout.title ) 
	if currentState == OK do currentState = true
		
	if (currentState and forceMode == #none) or forceMode == #float then --if it is docked and no forcing was requested, or if floating was requested,
	(
		try(removeRollout theRollout Krakatoa_Gui_floater)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater_2)catch()
		try(destroyDialog theRollout)catch()
		local thePos = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDialogPositions" theRollout.title) 
		if thePos != OK then
		(
			local theDesktop = sysInfo.DesktopSize
			if thePos.x > theDesktop.x-470 do thePos.x = theDesktop.x - 470
			if thePos.y > theDesktop.y-400 do thePos.y = theDesktop.y - 400
			if thePos.x < 0 do thePos.x = 0
			if thePos.y < 0 do thePos.y = 0	
			createDialog theRollout style:#(#style_titlebar,#style_minimizebox,#style_sysmenu) pos:thePos
		)	
		else
			createDialog theRollout style:#(#style_titlebar,#style_minimizebox,#style_sysmenu)
		
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" theRollout.title "false"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" theRollout.title "true"
		theRollout.btn_Float_Rollout.text = "<"
		try(if Krakatoa_Gui_floater_2.rollouts.count == 0 do closeRolloutFloater Krakatoa_Gui_floater_2)catch()
	)
	if (not currentState and forceMode == #none) or forceMode == #dock then --if floater and no docking requested, or if docking was forces,
	(
		try(destroyDialog theRollout)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater_2)catch()
		
		addRollout theRollout Krakatoa_Gui_floater
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" theRollout.title "true"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" theRollout.title "1"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" theRollout.title "true"
		theRollout.btn_Float_Rollout.text = ">"
		try(if Krakatoa_Gui_floater_2.rollouts.count == 0 do closeRolloutFloater Krakatoa_Gui_floater_2)catch()
	)
	if forceMode == #dock2 then --if docking to Secondary Floater was forces,
	(
		try(destroyDialog theRollout)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater_2)catch()
		
		if Krakatoa_Gui_floater_2 == undefined or Krakatoa_Gui_floater_2.open == false do 
		(
			theSize = execute (FranticParticles.GetProperty "GUI:Size")	
			Krakatoa_Gui_floater_2 = NewRolloutFloater ("Krakatoa v" + FranticParticles.Version +" - Secondary Floater") theSize.x theSize.y (Krakatoa_Gui_floater.pos.x+theSize.x+14)  Krakatoa_Gui_floater.pos.y
		)	
		addRollout theRollout Krakatoa_Gui_floater_2
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" theRollout.title "true"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" theRollout.title "2"
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" theRollout.title "true"
		theRollout.btn_Float_Rollout.text = "<"
	)	
),

fn FloatRolloutButtonPressed theRollout =
(
	if keyboard.shiftPressed then 
	(	
		if theRollout.inDialog then
			FranticParticleRenderMXS.floatOrDockRollout theRollout forceMode:#dock2
		else if findItem Krakatoa_GUI_Floater.rollouts theRollout == 0 then
			FranticParticleRenderMXS.floatOrDockRollout theRollout forceMode:#dock
		else if findItem Krakatoa_GUI_Floater_2.rollouts theRollout == 0 do
			FranticParticleRenderMXS.floatOrDockRollout theRollout forceMode:#dock2
	)	
	else if keyboard.controlPressed then
	(
		try(destroyDialog theRollout)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater)catch()
		try(removeRollout theRollout Krakatoa_Gui_floater_2)catch()		
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" theRollout.title "false"
		try(if Krakatoa_Gui_floater_2.rollouts.count == 0 do closeRolloutFloater Krakatoa_Gui_floater_2)catch()
	)
	else
		FranticParticleRenderMXS.floatOrDockRollout theRollout
	Krakatoa_CustomizeRollouts_Dialog.Refresh_GUI()			
),

--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
--DEFINE ALL UI ROLLOUTS
--------------------------------------------------------------------------------------------------------------------------------------------------------------------	
fn OpenGUI initOnly:false=
(

	local openGUIst = timestamp()
	FranticParticles.LogProgress ("                                                                 ")
	FranticParticles.LogProgress ("-----"+ localtime + "--------------------------")
	FranticParticles.LogProgress ">Opening Krakatoa GUI..."

	-- This option enables alpha version controls, which aren't for the release version of Krakatoa yet.
	local alphaFeatureControls = false
	
	if alphaFeatureControls then 
		FranticParticles.LogDebug ("  +Alpha Features ENABLED...")
	else	
		FranticParticles.LogDebug ("  -Alpha Features DISABLED.")
	
	if renderers.current.classid as string != "#(-1204370534, -399920359)" then
	(
		FranticParticles.LogDebug ("  -Current Renderer is not Krakatoa - it is "+ (classof renderers.current) as string  )
		if doesFileExist ((getdir #renderpresets) + "\\backup_last_krakatoa_settings.rps") then
		(
			local txt = "The Production Renderer must be set to Krakatoa to access the Krakatoa GUI.\n\n"
			txt +="The current Production Renderer is [" + (classof renderers.current) as string +"]\n\n"
			txt +="The current Renderer's settings will be saved as Render Preset 'backup_pre_krakatoa_assignment.rps'\n"
			txt +="and can be easily restored by using the 'Switch Back From Krakatoa To Previous Renderer' icon.\n\n"
			
			txt +="Press [Yes] to load the last known Krakatoa settings saved in 'backup_last_krakatoa_settings.rps'\n"
			txt +="Press [No] to set Krakatoa as the current renderer using the default settings.\n"
			txt +="Press [Cancel] to leave "+ (classof renderers.current) as string + " as the current renderer.\n"
 			local q = yesNoCancelBox txt  title:("Switch To Krakatoa v" + FranticParticles.Version)
			
			case q of 
			(
				#yes: (
					RenderPresets.Save 0 ((getdir #renderpresets) + "\\backup_pre_krakatoa_assignment.rps") #{1,4..64} 
					FranticParticles.LogDebug ("  +Current Renderer's settings backed up.")
					renderpresets.LoadAll 0 ((getdir #renderpresets) + "\\backup_last_krakatoa_settings.rps" )		
					if renderers.current.classid as string != "#(-1204370534, -399920359)" then 
					(
						FranticParticles.LogDebug ("  -Failed to load last Krakatoa settings from preset.")
						return 0
					)
					else	
					(
						FranticParticles.LogDebug ("  +Current Renderer set to Krakatoa using last known settings.")
					)	
				)
				#no: (
					RenderPresets.Save 0 ((getdir #renderpresets) + "\\backup_pre_krakatoa_assignment.rps") #{1,4..64} 			
					FranticParticles.LogDebug ("  +Current Renderer's settings backed up.")
					renderers.current = Krakatoa()
					FranticParticles.LogDebug ("  +Current Renderer set to Krakatoa with default settings.")
				)
				#cancel: 
				( 
					FranticParticles.LogDebug ("  -Krakatoa assignment cancelled by user.")
					return 0 
				)
			)	
		)
		else
		(
			local q = querybox ("Production Renderer must be set to Krakatoa to access its GUI.\nThe current renderer is ["+ (classof renderers.current) as string +"]\nDo you want to set Krakatoa as your renderer?\n\nThe current renderer's settings will be saved as Render Preset\n'backup_pre_krakatoa_assignment.rps'.") title:"Switch To Krakatoa"
			if q then 
			(
				RenderPresets.Save 0 ((getdir #renderpresets) + "\\backup_pre_krakatoa_assignment.rps") #{1,4..64} 
				FranticParticles.LogDebug ("  +Current Renderer's settings backed up.")
				renderers.current = Krakatoa()
				FranticParticles.LogDebug ("  +Current Renderer set to Krakatoa with default settings.")
			)	
			else
			(
				FranticParticles.LogDebug ("  -Krakatoa assignment cancelled by user.")
				return 0
			)	
		)	
	)
	try(destroyDialog Krakatoa_SavePresetDialog)catch()
	
	--DetectDeadline()
	
	--MAKE SURE THE PREFERENCES ARE INITIALIZED TO BEGINNER MODE THE FIRST TIME KRAKATOA IS RUN
	if getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" == "" do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "BlendModeSwitch" "1"
		FranticParticles.LogDebug "+Blend Mode Switch Preference Set To BEGINNER Setting."
	)		
	if getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" == "" do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "RealFlowBinFileSaving" "1"
		FranticParticles.LogDebug "+RealFlow4 BIN Files Saving Preference Set To BEGINNER Setting."
	)		
	if getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" == "" do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "SaveModeTogglePartitionsRollout" "2"
		FranticParticles.LogDebug "+Save Mode Toggle Partition Rollout Preference Set To ADVANCED Setting."
	)
	if getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" == "" do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior" "1"	
		FranticParticles.LogDebug "+Create Loaders Behavior Preference Set To BEGINNER Setting."
	)	
	if getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" == "" do
	(
		setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "AddFileSequenceBehavior" "1"	
		FranticParticles.LogDebug "+Add File Sequence To Loaders Behavior Preference Set To BEGINNER Setting."
	)	
	
	if  initOnly then
	(
		FranticParticles.LogProgress ("+Krakatoa GUI INITIALIZED in " + (timestamp() - openGUIst) as string + "ms."  )
	)
	else
	(
		try(closeRolloutFloater Krakatoa_Gui_floater) catch()
		theSize = execute (FranticParticles.GetProperty "GUI:Size")	
		local theTitle =  ("Krakatoa v" + FranticParticles.Version + (if try(FranticParticles.HasValidLicense())catch(false) then " - Licensed" else " - Evaluation Mode") + " - Primary Floater "  )
		try	
		(
			thePos = (FranticParticles.GetProperty "GUI:Position")
			Krakatoa_gui_pos = execute thePos
			--Check the current desktop size and adjust if dialog is out of the window...
			local theDesktop = sysInfo.DesktopSize
			if Krakatoa_gui_pos.x > theDesktop.x-470 do 
			(
				Krakatoa_gui_pos.x = theDesktop.x - 470
				FranticParticles.LogDebug "+Adjusted Horizontal Position To Desktop Size."
			)	
			if Krakatoa_gui_pos.x < 0 do 
			(
				Krakatoa_gui_pos.x = 0
				FranticParticles.LogDebug "+Adjusted Horizontal Position Back Into Desktop View."
			)	
			if Krakatoa_gui_pos.y > theDesktop.y-400 do 
			(
				Krakatoa_gui_pos.y = theDesktop.y - 400
				FranticParticles.LogDebug "+Adjusted Vertical Position To Desktop Size."
			)	
			if Krakatoa_gui_pos.y < 0 do 
			(
				Krakatoa_gui_pos.x = 0
				FranticParticles.LogDebug "+Adjusted Vertical Position Back Into Desktop View."
			)	
			
			Krakatoa_Gui_floater = newRolloutFloater theTitle theSize.x theSize.y Krakatoa_gui_pos.x Krakatoa_gui_pos.y
			FranticParticles.LogDebug "+Created Krakatoa GUI Floater At Last Position Stored In Renderer."
		) catch	
		(
			Krakatoa_gui_pos = execute (getINIsetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Dialog" "Position")
			if Krakatoa_gui_pos != OK then
			(
				local theDesktop = sysInfo.DesktopSize
				if Krakatoa_gui_pos.x > theDesktop.x-470 do 
				(
					Krakatoa_gui_pos.x = theDesktop.x - 470
					FranticParticles.LogDebug "+Adjusted Horizontal Position To Desktop Size."
				)	
				if Krakatoa_gui_pos.x < 0 do 
				(
					Krakatoa_gui_pos.x = 0
					FranticParticles.LogDebug "+Adjusted Horizontal Position Back Into Desktop View."
				)	
				if Krakatoa_gui_pos.y > theDesktop.y-400 do 
				(
					Krakatoa_gui_pos.y = theDesktop.y - 400
					FranticParticles.LogDebug "+Adjusted Vertical Position To Desktop Size."
				)	
				if Krakatoa_gui_pos.y < 0 do 
				(
					Krakatoa_gui_pos.x = 0
					FranticParticles.LogDebug "+Adjusted Vertical Position Back Into Desktop View."
				)	
				
				Krakatoa_Gui_floater = newRolloutFloater theTitle theSize.x theSize.y Krakatoa_gui_pos.x Krakatoa_gui_pos.y
				FranticParticles.LogDebug "+Created Krakatoa GUI Floater At Last Position Stored In INI File."
			)
			else
			(		
				Krakatoa_Gui_floater = newRolloutFloater theTitle  theSize.x theSize.y	
				FranticParticles.LogDebug "+Created Krakatoa GUI Floater At Default Position"
			)	
		)
		
		addRollout Krakatoa_CustomizeRollouts_Dialog Krakatoa_Gui_floater
		
		local allRollouts = #(
			Krakatoa_GUI_Main, 
			Krakatoa_GUI_SaveParticles,
			Krakatoa_GUI_Channels, 
			Krakatoa_GUI_Partition, 
			Krakatoa_GUI_Particles,
			Krakatoa_GUI_ParticleLoaders, 
			Krakatoa_GUI_MatteObjects, 
			Krakatoa_GUI_Shadows,
			Krakatoa_GUI_AmbientPME, 
			Krakatoa_GUI_Preferences, 
			Krakatoa_GUI_Notes, 
			Krakatoa_GUI_About,
			Krakatoa_GUI_Presets
		)			
		if findItem geometryClass.classes thinking > 0  then 
		(
			append allRollouts Krakatoa_GUI_ThinkingParticles
		)
		else
		(
			setIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" Krakatoa_GUI_ThinkingParticles.title "false"
		)
		
		for i in allRollouts do
		(
			local theState = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutVisible" i.title)
			if theState == OK do theState = true
			if theState do
			(
				local theDockedState = execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDocked" i.title)
				if theDockedState == OK do theDockedState = true
				local theDockHost = (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "RolloutDockHost" i.title)
				if theDockHost == "" do theDockHost = "1"
					
				if theDockedState then
				(	
						if theDockHost == "2" then
							FranticParticleRenderMXS.floatOrDockRollout i forceMode:#dock2
						else	
							FranticParticleRenderMXS.floatOrDockRollout i forceMode:#dock
				)
				else
					FranticParticleRenderMXS.floatOrDockRollout i forceMode:#float
				FranticParticles.LogDebug ("+Added '" + i.title +"' Rollout to Krakatoa GUI Floater.")
			)	
		)
		
		FranticParticles.LogDebug ">Unregistering Krakatoa Render History Callbacks..."
		callbacks.removeScripts id:#KrakatoaRenderHistory
		FranticParticles.LogDebug ">Registering Krakatoa Render History Callbacks..."
		callbacks.addScript #preRenderFrame "try(FranticParticleRenderMXS.framePreRender()) catch()" id:#KrakatoaRenderHistory
		callbacks.addScript #postRender "try(FranticParticleRenderMXS.framePostRender()) catch(); try(FranticParticleRenderMXS.saveRenderHistory()) catch()" id:#KrakatoaRenderHistory
		if Krakatoa_GUI_Presets.open do Krakatoa_GUI_Presets.compareSettings()

		global KrakatoaGuiOpen = true
		updateToolbarButtons()
		try(if execute (getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "System" "AutoIncreasePflowSystemLimit" ) then FranticParticleRenderMXS.increasePFlowSystemLimits())catch(FranticParticleRenderMXS.increasePFlowSystemLimits())
		FranticParticles.LogProgress ("+Krakatoa GUI Floater OPENED in " + (timestamp() - openGUIst) as string + "ms."  )
	)--end if initOnly
)--end OpenGUI fn
	
) -- end FranticParticleRenderMXSStruct

FranticParticleRenderMXS = FranticParticleRenderMXSStruct()


macroScript KrakatoaGUI category:"Krakatoa" tooltip:"Toggle Krakatoa Scripted GUI On/Off" buttontext:"Krakatoa GUI" icon:#("Krakatoa",1)
(
	global KrakatoaGuiOpen
	if KrakatoaGuiOpen== undefined do KrakatoaGuiOpen= true
	on isChecked return try(Krakatoa_Gui_floater.open And KrakatoaGuiOpen)catch(false)
	on execute do
	(
		if try(Krakatoa_Gui_floater.open)catch(false) then
			try(closeRolloutFloater Krakatoa_Gui_floater)catch()
		else
			try(FranticParticleRenderMXS.OpenGUI() )catch(messagebox ("Failed To Launch Krakatoa GUI:\n" + getCurrentException()) title:"Krakatoa Error")
	)
)

macroScript RemoveKrakatoa category:"Krakatoa" tooltip:"Switch Back From Krakatoa To Previous Renderer" buttontext:"Krakatoa GUI" icon:#("Krakatoa",6)
(
	if classof renderers.current == Krakatoa then
	(
		local lastRendererPresetFilename  = ((getdir #renderpresets) + "\\backup_pre_krakatoa_assignment.rps")
		if doesFileExist lastRendererPresetFilename then
		(
			local theLastRendererName = renderpresets.MapIndexToCategory  lastRendererPresetFilename  32
			local theQuery = querybox ("Are you sure you want to remove Krakatoa from the Production Renderer slot\nand switch to the last known settings of ["+theLastRendererName+"]?\n\nA backup of your current Krakatoa settings will be saved as 'backup_last_krakatoa_settings.rps'") title:"Krakatoa: Switch To Previous Renderer"
			if theQuery then
			(
				RenderPresets.Save 0 ((getdir #renderpresets) + "\\backup_last_krakatoa_settings.rps") #{1,4..64} 
				renderpresets.LoadAll 0 lastRendererPresetFilename 
				messagebox ("Switched to last known renderer ["+ (classof renderers.current) as string +"]") title:"Krakatoa: Switch To Previous Renderer"
			)	
		)	
		else
		(
			local theQuery = querybox "No previously saved Render Preset found.\n\nSwitch to Default Scanline Renderer?" title:"Krakatoa: Switch To Previous Renderer"
			if theQuery do 
				renderers.current = Default_Scanline_Renderer()	
		)	
	)	
	else
		messagebox ("The current renderer is already set to  ["+ (classof renderers.current) as string + "].") title:"Krakatoa: Switch To Previous Renderer"
)

macroScript KrakatoaLog category:"Krakatoa" tooltip:"Toggle Krakatoa Log Window On/Off" buttontext:"Krakatoa Log Window" icon:#("Krakatoa",2)
(
	on isChecked return try(FranticParticles.LogWindowVisible)catch(false)
	on execute do
	(
		try(FranticParticles.LogWindowVisible = not FranticParticles.LogWindowVisible)catch()
	)
)

macroScript KrakatoaAutoLog category:"Krakatoa" tooltip:"Auto-Open Log Window On Output On/Off" buttontext:"Krakatoa Auto-Open Log" icon:#("Krakatoa",3)
(
	on isChecked return try(FranticParticles.PopupLogWindowOnMessage )catch(false)
	on execute do
	(
		try(FranticParticles.PopupLogWindowOnMessage = not FranticParticles.PopupLogWindowOnMessage )catch()
	)
)

macroScript ToggleMeditLock category:"Krakatoa" tooltip:"Toggle Material Editor Renderer Lock To Production Renderer" icon:#("Maintoolbar",66)
(
	on isChecked return renderers.medit_locked
	on execute do renderers.medit_locked = not renderers.medit_locked
)

macroScript PRTLoader category:"Krakatoa" tooltip:"PRT Loader - hold SHIFT to create at Origin" icon:#("Krakatoa",7)
(
	on isChecked return (mcrUtils.IsCreating KrakatoaPRTLoader)
	on execute do 
	(
		if keyboard.shiftPressed then
		(
			local newLoader = KrakatoaPRTLoader()
			if isValidNode newLoader do
			(
				select newLoader 
				local thePref = getIniSetting (Krakatoa_PresetsDirectory + "\\KrakatoaPreferences.ini") "Preferences" "CreateLoadersBehavior"
				if thePref != "3" do try(newLoader.params.btn_addFiles.pressed())catch()
			)				
			max modify mode
		)	
		else
			StartObjectCreation KrakatoaPRTLoader
	)	
)

macroScript GeoVolume category:"Krakatoa" tooltip:"GeoVolume - hold SHIFT to Instance among Selection" icon:#("Krakatoa",8)
(
	on isEnabled return (selection.count > 0)
	on execute do 
	(
		local legacyParticles = #(PArray, PCloud, SuperSpray, Blizzard, Snow, Spray)
		
		local theObjects = (for o in objects where findItem GeometryClass.classes (classof o) > 0 AND classof o != TargetObject AND classof o != ParticleGroup AND findItem legacyParticles (classof o) == 0 AND classof o != PF_Source AND classof o != KrakatoaPrtLoader collect o)
		if keyboard.shiftPressed then
		(
			local newModifier = KrakatoaGeoVolume()
			for o in theObjects where (for m in o.modifiers where classof m == KrakatoaGeoVolume collect m).count == 0 do
				addModifier o newModifier
			max modify mode
		)	
		else
		(
			for o in theObjects where (for m in o.modifiers where classof m == KrakatoaGeoVolume collect m).count == 0 do
				addModifier o (KrakatoaGeoVolume())
			max modify mode
		)
	)	
)