plugin geometry Stoke
name:"Stoke"
category:"Thinkbox"
classid:#(0x2cf34591, 0x38e6602)
extends:StokeBase
replaceui:true
(
	
	local paramsRollout, paramsDisplayRollout, paramsDistributionRollout, paramsVelocityFieldRollout, cacheParamsRollout
	local availableChannels = #()
	local availableChannelNames = #()
	local lockUpdates = false
	local RCMenuSourceObject
	
	fn defineRCMenu =
	(
		rcmenu Stoke_Object_RCMenu
		(
			menuItem mnu_toggleHidden "Hide Object" checked:( if isValidNode RCMenuSourceObject then RCMenuSourceObject.isHidden else false )
			separator sep_10
			menuItem mnu_select "Select Object..."
			
			on mnu_toggleHidden picked do
			(
				if isValidNode RCMenuSourceObject do RCMenuSourceObject.ishidden = not RCMenuSourceObject.ishidden 
			)
			
			on mnu_select picked do
			(
				if isValidNode RCMenuSourceObject do select RCMenuSourceObject
			)
		)	
		Stoke_Object_RCMenu			
	)		
	
	
	parameters cacheParams rollout:cacheParamsRollout
	(
		outputPath type:#filename default:(systemTools.getEnvVariable "temp") ui:edt_outputPath
		
		saveResultsToDisk type:#boolean default:false ui:chk_saveResultsToDisk
		cacheResultsInMemory type:#boolean default:true ui:chk_cacheResultsInMemory
		memoryCacheStep type:#integer default:1 animatable:false ui:spn_memoryCacheStep
		
		useSaveRange type:#boolean default:false animatable:false ui:chk_useSaveRange
		diskSaveStartTime type:#integer default:0 animatable:false ui:spn_diskSaveStartTime
		diskSaveEndTime type:#integer default:100 animatable:false ui:spn_diskSaveEndTime
		
		useCacheRange type:#boolean default:false animatable:false ui:chk_useCacheRange
		memoryCacheStartTime type:#integer default:0 animatable:false ui:spn_memoryCacheStartTime
		memoryCacheEndTime type:#integer default:100 animatable:false ui:spn_memoryCacheEndTime

		on saveResultsToDisk set val do
		(
			--if not val and not cacheResultsInMemory do cacheResultsInMemory = true
		)
		on cacheResultsInMemory set val do
		(
			--if not val and not saveResultsToDisk do saveResultsToDisk = true
		)	
		on useCacheRange set val do cacheParamsRollout.updateUI()
		on useSaveRange set val do cacheParamsRollout.updateUI()
		
		on diskSaveStartTime set val do if diskSaveStartTime > diskSaveEndTime do diskSaveEndTime = diskSaveStartTime
		on diskSaveEndTime set val do if diskSaveStartTime > diskSaveEndTime do diskSaveStartTime = diskSaveEndTime

		on memoryCacheStartTime set val do if memoryCacheStartTime > memoryCacheEndTime do memoryCacheEndTime = memoryCacheStartTime
		on memoryCacheEndTime set val do if memoryCacheStartTime > memoryCacheEndTime do memoryCacheStartTime = memoryCacheEndTime
		
	)
		
	parameters params rollout:paramsRollout
	(
		startTime type:#integer default:0 animatable:false ui:spn_startTime 
		endTime type:#integer default:100 animatable:false ui:spn_endTime
		
		emitStartTime type:#integer default:0 animatable:false ui:spn_emitStartTime
		emitEndTime type:#integer default:100 animatable:false ui:spn_emitEndTime
		
		rateMode type:#integer default:1 ui:ddl_rateMode
		rate type:#integer default:100 ui:spn_rate
		
		updateViews type:#boolean default:false animatable:false ui:chk_updateViews
		updateViewsEvery type:#integer default:5 ui:spn_updateViewsEvery
		--openFolderAfterSim type:#boolean default:false ui:chk_openFolderAfterSim
		
		
		on rate set val do paramsRollout.updateUI()
		on startTime set val do if startTime > endTime do endTime = startTime
		on endTime set val do if startTime > endTime do startTime = endTime

		on emitStartTime set val do if emitStartTime > emitEndTime do emitEndTime = emitStartTime
		on emitEndTime set val do if emitStartTime > emitEndTime do emitStartTime = emitEndTime
			

	)
	
	parameters paramsLifespan rollout:paramsLifespanRollout
	(
		lifeSpan type:#integer default:25.0 ui:spn_lifeSpan
		lifeSpanVar type:#integer default:5.0 ui:spn_lifeSpanVar
		useLifeSpan type:#boolean default:false animatable:false ui:chk_useLifeSpan
	)
	
	parameters paramsDistribution rollout:paramsDistributionRollout
	(
		useViewportParticles type:#boolean default:false ui:chk_useViewportParticles
		jitterRadius type:#float default:1.0 --ui:spn_jitterRadius
		distMode type:#integer default:1 --ui:rad_distributionMode
		distSources type:#nodeTab tabSizeVariable:true
		distRates type:#intTab tabSizeVariable:true
		distSourcesSelectionType type:#stringTab tabSizeVariable:true
		distJitterRadius type:#floatTab tabSizeVariable:true
		distSeedAsRate type:#boolTab tabSizeVariable:true
		distVolumeSpacing type:#floatTab tabSizeVariable:true animatable:false
		activeDistSource type:#nodeTab tabSizeVariable:true 
		perObjectRate type:#integer default:1000 ui:spn_perObjectRate animatable:false
		perObjectJitter type:#float default:1.0 ui:spn_perObjectJitter animatable:false
		perObjectVolumeSpacing type:#float default:1.0 ui:spn_perObjectVolumeSpacing animatable:false
		
		randomSeed type:#integer default:12345 ui:spn_randomSeed
		incrementRandomSeed type:#boolean default:true ui:chk_incrementRandomSeed
		channelsToSave type:#stringTab tabSizeVariable:true
		geometryMode type:#stringTab tabSizeVariable:true
		
		on perObjectRate set val do
		(
			if not lockUpdates do 
				paramsDistributionRollout.updatePerObjectRate()
		)			
	)
	
	parameters paramsVelocityField rollout:paramsVelocityFieldRollout
	(
		VelocitySources type:#nodeTab tabSizeVariable:true
		activeVelocitySources type:#nodeTab tabSizeVariable:true
		velocityScales type:#floatTab tabSizeVariable:true 
		--useGridSize type:#boolean default:true --ui:chk_useGridSize
		gridSize type:#worldunits default:10.0 ui:spn_gridSize animatable:false
		gridPadding type:#integer default:5 ui:spn_gridPadding animatable:false
		fluidMotion type:#boolean default:true ui:chk_fluidMotion animatable:false
		VelocityScale type:#float default:1.0 ui:spn_VelocityScale animatable:false
		on VelocityScale set val do
		(
				paramsVelocityFieldRollout.updatePerObjectScale()
		)			
	)
	
	parameters paramsDisplay rollout:paramsDisplayRollout
	(
		viewPercentage type:#float default:100 ui:spn_viewPercentage
		viewLimitEnabled type:#boolean default:false ui:chk_viewLimitEnabled
		viewLimit type:#integer default:1000 animatable:false ui:spn_viewLimit
		
		ViewVectorNormalize type:#boolean default:false ui:chk_ViewVectorNormalize
		viewVectorScale type:#float default:1.0 ui:spn_viewVectorScale 
		iconSize type:#float default:30.0 ui:spn_iconSize
		
		on viewVectorScale set val do this.delegate.viewportVectorScale = val
		on ViewVectorNormalize set val do this.delegate.viewportVectorNormalize = val
		
		on iconSize set val do this.delegate.iconSize = val
		on viewPercentage set val do 
		(
			this.delegate.ViewportPercentage = val
		)
		on viewLimit set val do
		(
			this.delegate.ViewportLimit = val
		)
		on viewLimitEnabled set val do
		(
			this.delegate.UseViewportLimit = val
		)
		
	)
	
	fn createPresetsRCMenu type:#renderpercent =
	(
		local isTime = false
		case type of
		(
			#startTime : (
						presetName = "startTime"
						theParameter = "startTime"
						isTime = true
					)	
			#endTime : (
						presetName = "endTime"
						theParameter = "endTime"
						isTime = true
					)	
			#emitStartTime : (
						presetName = "emitStartTime"
						theParameter = "emitStartTime"
						isTime = true
					)	
			#emitEndTime : (
						presetName = "emitEndTime"
						theParameter = "emitEndTime"
						isTime = true
					)						
			#rate: (
						presetName = "rate"
						theParameter = "rate"
					)						
			#JitterRadius: (
						presetName = "JitterRadius"
						theParameter = "JitterRadius"
					)	
			#randomSeed: (
						presetName = "randomSeed"
						theParameter = "randomSeed"
					)
			#VelocityScale: (
						presetName = "VelocityScale"
						theParameter = "VelocityScale"
				)
			#gridSize: (
						presetName = "gridSize"
						theParameter = "gridSize"				
				)
			#gridPadding: (
						presetName = "gridPadding"
						theParameter = "gridPadding"				
			)
			#viewPercentage: (
						presetName = "viewPercentage"
						theParameter = "viewPercentage"				
				)
			#viewLimit: (
						presetName = "viewLimit"
						theParameter = "viewLimit"				
				)
			#iconSize: (
						presetName = "iconSize"
						theParameter = "iconSize"				
				)		
			#lifeSpan: (
						presetName = "lifeSpan"
						theParameter = "lifeSpan"				
				)	
			#lifeSpanVar: (
						presetName = "lifeSpanVar"
						theParameter = "lifeSpanVar"				
				)	
			#updateViewsEvery: (
						presetName = "updateViewsEvery"
						theParameter = "updateViewsEvery"				
			)
			#viewVectorScale : (
						presetName = "viewVectorScale"
						theParameter = "viewVectorScale"					
			)
			#perObjectRate : (
						presetName = "perObjectRate"
						theParameter = "perObjectRate"					
			)
			#memoryCacheStep: (
						presetName = "memoryCacheStep"
						theParameter = "memoryCacheStep"
			)
			#memoryCacheStartTime: (
						presetName = "memoryCacheStartTime"
						theParameter = "memoryCacheStartTime"
						isTime = true
			)
			#memoryCacheEndTime: (
						presetName = "memoryCacheEndTime"
						theParameter = "memoryCacheEndTime"
						isTime = true
			)
			#diskSaveStartTime: (
						presetName = "diskSaveStartTime"
						theParameter = "diskSaveStartTime"
						isTime = true
			)
			#diskSaveEndTime: (
						presetName = "diskSaveEndTime"
						theParameter = "diskSaveEndTime"
						isTime = true
			)			
			#perObjectJitter: (
						presetName = "perObjectJitter"
						theParameter = "perObjectJitter"				
			)
			#perObjectVolumeSpacing: (
						presetName = "perObjectVolumeSpacing"
						theParameter = "perObjectVolumeSpacing"				
			)
		)
		local presetsList = #()
		local theKeys = for i in (getIniSetting (getDir #plugcfg + "//StokePreferences.ini") presetName  ) collect (execute i)
		sort theKeys 
		if theKeys.count == 0 then 
		(
			theKeys = case type of
			(
				#startTime : #(0,1)
				#endTime : #(1,30,50,60,100)
				#emitStartTime : #(0,1)
				#emitEndTime : #(1,30,50,60,100)
				#rate: #(10,100,1000,10000)
				#JitterRadius: #(0.01,0.1,1.0)
				#randomSeed: #(1,10000,12345)
				#VelocityScale: #(0.1,0.5,1.0,2.0)
				#gridSize: #(1.0,2.0,3.0,5.0,8.0,10.0,20.0,50.0)
				#gridPadding: #(3,5,8,10)
				#viewPercentage: #(1.0,10.0,50.0,100.0)
				#viewLimit: #(10,100,1000,2000,5000)
				#iconSize: #(1.0,10.0,30.0,50.0,100.0)
				#lifespan: #(10,20,30,40,50,60,70,80,90,100)
				#lifespanVar: #(0,5,10,15,20,25,30)
				#updateViewsEvery: #(1,2,3,5,10,20)
				#viewVectorScale: #(1.0,2.0,10.0,24.0,25.0,30.0)
				#perObjectRate: #(100,1000,2000,5000,10000,100000,1000000)
				#memoryCacheStep: #(1,2,3,5,10,15,20)
				#memoryCacheStartTime: #(0,50,100)
				#memoryCacheEndTime: #(0,50,100)
				#diskSaveStartTime: #(0,50,100)
				#diskSaveEndTime: #(0,50,100)
				#perObjectJitter: #(1.0,10.0,100.0,10000.0)
				#perObjectVolumeSpacing: #(1.0,2.0,5.0,10.0)
			)
			for i in theKeys do
				setIniSetting (getDir #plugcfg + "//StokePreferences.ini") presetName (i as string) (i as string)
		)
		for k in theKeys do
			if findItem presetsList theValue == 0 do append presetsList k

		theValue = execute ("selection[1]." + theParameter)
		global Stoke_Presets_RCMenu
		local txt = "rcmenu Stoke_Presets_RCMenu\n(\n"
		
		if isTime do
		(
			txt += "menuItem mnu_StartFrame \""+ (animationrange.start.frame as integer) as string+" - Start Frame \"\n" 
			txt += "on mnu_StartFrame picked do selection[1]."+ theParameter +" = "+ (animationrange.start.frame as integer) as string +"\n"

			txt += "menuItem mnu_CurrentFrame \""+ (sliderTime.frame as integer) as string+" - Current Frame\"\n" 
			txt += "on mnu_CurrentFrame picked do selection[1]."+ theParameter +" = "+ (sliderTime.frame as integer) as string +"\n"

			txt += "menuItem mnu_EndFrame \""+ (animationrange.end.frame as integer) as string+" - End Frame\"\n" 
			txt += "on mnu_EndFrame picked do selection[1]."+ theParameter +" = "+ (animationrange.end.frame as integer) as string +"\n"
			
			txt += "separator spr_10\n" 
		)			
			
		if findItem presetsList theValue == 0 do 
		(
			txt += "menuItem mnu_AddPreset \"Add "+ theValue as string+"\"\n" 
			txt += "on mnu_AddPreset picked do setIniSetting (getDir #plugcfg + \"//StokePreferences.ini\") \""+ presetName + "\" \""+ theValue as string +"\" \""+ theValue as string +"\" \n"
			txt += "separator spr_20\n" 
		)	
		

		
		cnt = 0
		for i in presetsList do
		(
			cnt += 1
			txt += "menuItem mnu_preset"+ cnt as string +" \"" + i as string + "\" \n" 
			txt += "on mnu_preset" + cnt as string + " picked do selection[1]."+ theParameter +" = "+ i as string +"\n"
		)
		
		if findItem presetsList theValue != 0 do 
		(
			txt += "separator spr_100\n" 
			txt += "menuItem mnu_RemovePreset \"Remove "+ theValue as string+"\"\n" 
			txt += "on mnu_RemovePreset picked do delIniSetting (getDir #plugcfg + \"//StokePreferences.ini\") \""+ presetName +"\" \""+ theValue as string +"\" \n"
		)	
		txt += ")\n"
		execute txt
	)		
	
	fn getListViewSelection lv =
	(
		try
			sort (for i = 1 to lv.items.count where lv.items.item[i-1].Selected collect i)
		catch
			#()
	)	
	
	fn setListViewSelection lv theSel =
	(
		try
		(
			for i = 1 to lv.items.count do lv.items.item[i-1].Selected = false
			for i in theSel do lv.items.item[i-1].Selected = true
		)catch()
	)	
	
	rollout helpRollout "Help" rolledup:true
	(
		label lbl_about01 "STOKE Particle Reflow Tools"
		label lbl_about10 " 2013 Thinkbox Software"
		label lbl_about20 ""
		label lbl_licensed ""
		
		button btn_openOnlineHelp "Open Online Help..." width:156 align:#center offset:[0,0] enabled:true
		button btn_configureLicense "Configure License..." width:156 align:#center offset:[0,-3] enabled:false
		label lbl_logLevel "Log Level:" across:2 align:#left offset:[-5,0]
		dropdownlist ddl_loggingLevel items:#("None","Error","Warning","Progress","Stats","Debug") width:100 align:#right offset:[11,-3]
		
		on ddl_loggingLevel selected itm do
		(
			ReflowGlobal.LoggingLevel = ddl_loggingLevel.selected as name
		)
		
		on btn_openOnlineHelp pressed do 
		(
			shellLaunch "http://www.thinkboxsoftware.com/stoke/" ""
		)
		on helpRollout open do
		(
			lbl_licensed.text = if ReflowGlobal.Licensed then "LICENSED" else "UNLICENSED"
				
			lbl_about20.text = try("Version " + ReflowGlobal.Version)catch("")
			
			ddl_loggingLevel.selection = findItem (for i in ddl_loggingLevel.items collect i as name) ReflowGlobal.LoggingLevel
		)
	)
	
	rollout cacheParamsRollout "Saving and Caching"
	(
		button btn_getOutputPath "..." width:16 height:18 align:#left across:2 offset:[-10,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,11,11,11,11) tooltip:"Left-Click to select an output folder.\n\nRight-Click to Explore the folder."
		edittext edt_outputPath offset:[10,-3] fieldwidth:140 align:#right
		
		group "Disk Saving Options"
		(
			checkbutton chk_saveResultsToDisk ">Save Simulation To PRT" offset:[-6,-2] align:#left width:130 height:22 across:2 tooltip:"The particle simulation will be saved to a PRT file sequence.\n\nIt can be loaded using a Krakatoa PRT Loader."
			button btn_createPRTLoader "+" width:18 height:22 align:#right offset:[6,-2] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,13,13,13,13) tooltip:"Click to create a new Krakatoa PRT Loader object with the current PRT sequence."
			
			checkbutton chk_useSaveRange ">Use" offset:[-11,-4] across:3 width:33 height:35 tooltip:"When checked, PRT files will be saved only within the specified Time Range.\n\nIf unchecked, a PRT file will be saved for every simulated frame.\n\nFor example, you can use this to pre-roll the simulation and only save the last few relevant frames."
			spinner spn_diskSaveStartTime "From:" fieldwidth:50 range:[-100000,1000000,0] type:#integer align:#right offset:[34,-3] tooltip:"Defines the FIRST frame to save a PRT file if the >Use option is checked."
			button btn_diskSaveStartTime_Preset ">" width:18 height:16 align:#right offset:[7,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the FIRST frame to save a PRT file if the >Use option is checked."
			
			spinner spn_diskSaveEndTime "To:" fieldwidth:50 range:[-100000,1000000,0] type:#integer align:#right offset:[56,-21] across:2 tooltip:"Defines the LAST frame to save a PRT file if the >Use option is checked."
			button btn_diskSaveEndTime_Preset ">" width:18 height:16 align:#right offset:[6,-21] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the LAST frame to save a PRT file if the >Use option is checked."
		)
		
		label lbl_memorycacheoptions "" offset:[0,-22]
		group "Memory Cache Options"
		(
			checkbutton chk_cacheResultsInMemory ">Cache In Memory" offset:[-6,-4] align:#left width:130 height:22 across:2 tooltip:"The particles will be stored in a Memory Cache and played back quickly without reading from disk."
			button btn_clearParticleCache "X" width:18 height:22 align:#right offset:[6,-4] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,14,14,14,14) tooltip:"Click to CLEAR the Memory Cache.\n\nYou will be prompted to confirm this action with a Yes/No dialog."
			
			checkbutton chk_useCacheRange ">Use" offset:[-11,-4] across:3 width:33 height:35 tooltip:"When checked, particle data will be cached only within the specified Time Range.\n\nIf unchecked, particle data will be saved for every simulated frame according to the Cache Every Nth value."
			spinner spn_memoryCacheStartTime "From:" fieldwidth:50 range:[-100000,1000000,0] type:#integer align:#right offset:[34,-3] tooltip:"Defines the FIRST frame to cache particle data if the >Use option is checked."
			button btn_memoryCacheStartTime_Preset ">" width:18 height:16 align:#right offset:[7,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the FIRST frame to cache particle data if the >Use option is checked."
			
			spinner spn_memoryCacheEndTime "To:" fieldwidth:50 range:[-100000,1000000,0] type:#integer align:#right offset:[56,-21] across:2 tooltip:"Defines the LAST frame to cache particle data if the >Use option is checked."
			button btn_memoryCacheEndTime_Preset ">" width:18 height:16 align:#right offset:[6,-21] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the LAST frame to cache particle data if the >Use option is checked."
			
			spinner spn_memoryCacheStep "Cache Every Nth:" fieldwidth:30 range:[1,20,1] type:#integer align:#right offset:[56,-3] across:2 tooltip:"Defines the Memory Cache step.\n\nStoke can interpolate the velocities by ID between frames, so storing a sub-set of frames is often enough to get a fair idea of the simulation's look."
			button btn_memoryCacheStep_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the Memory Cache step.\n\nStoke can interpolate the velocities by ID between frames, so storing a sub-set of frames is often enough to get a fair idea of the simulation's look."
		)
		
		on btn_clearParticleCache pressed do
		(
			if (querybox "Are you sure you want to CLEAR the Stoke Memory Cache?\n\nThis operation cannot be undone.\nYou will have to resimulate the particles." title:"CLEAR Stoke Memory Cache") do
			(
				this.delegate.ClearParticleCache()
				sliderTime += 1f
				sliderTime -= 1f
				gc light:true
			)
		)
		
		on btn_createPRTLoader pressed do
		(
			local outPath = outputPath + "\\StokeOutput\\" + (getFileNameFile maxFileName)+ "\\" +selection[1].name + "\\"
			local loaderObject = KrakatoaPRTLoader name:(uniquename ("PRTL_"+selection[1].name + "_"))
			loaderObject.fileList = #(( outPath+"StokeSimulation_0001.prt" ))
			loaderObject.fileListFlags = #(3)
			--loaderObject.viewLoadMode = viewMode+1
			--loaderObject.enabledInView = viewEnabled
			loaderObject.percentViewport = viewPercentage
			loaderObject.useViewportLimit = true
			loaderObject.viewportLimit = viewLimit
			loaderObject.viewportParticleDisplayMode = 3
			loaderObject.wirecolor = color 255 200 100		
			select loaderObject				
		)		
		
		on btn_getOutputPath pressed do
		(
			theNewPath = getSavePath initialDir:outputPath
			if theNewPath != undefined do outputPath = theNewPath
			if outputPath == "" do outputPath = (systemTools.getEnvVariable "temp")
		)
		
		on edt_outputPath entered txt do
		(
			if doesFileExist txt do outputPath = txt
			if txt == "" do outputPath = (systemTools.getEnvVariable "temp")
		)
		
		on btn_getOutputPath rightClick do
		(
			local outPath = outputPath + "\\StokeOutput\\" + (getFileNameFile maxFileName)
			if doesFileExist outPath then
				shellLaunch "explorer.exe" outPath
			else
			(
				outPath = outputPath + "\\StokeOutput\\" 
				if doesFileExist outPath then 
					shellLaunch "explorer.exe" outPath
				else
					shellLaunch "explorer.exe" outputPath
			)
		)	
		
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)		

		on btn_memoryCacheStep_Preset pressed do popupPresetMenu #memoryCacheStep
		on btn_memoryCacheStep_Preset rightclick do popupPresetMenu #memoryCacheStep
			
		on btn_memoryCacheStartTime_Preset pressed do popupPresetMenu #memoryCacheStartTime
		on btn_memoryCacheStartTime_Preset rightclick do popupPresetMenu #memoryCacheStartTime		

		on btn_memoryCacheEndTime_Preset pressed do popupPresetMenu #memoryCacheEndTime
		on btn_memoryCacheEndTime_Preset rightclick do popupPresetMenu #memoryCacheEndTime		
			
		on btn_diskSaveStartTime_Preset pressed do popupPresetMenu #diskSaveStartTime
		on btn_diskSaveStartTime_Preset rightclick do popupPresetMenu #diskSaveStartTime		

		on btn_diskSaveEndTime_Preset pressed do popupPresetMenu #diskSaveEndTime
		on btn_diskSaveEndTime_Preset rightclick do popupPresetMenu #diskSaveEndTime			
		
		fn updateUI =
		(
			spn_memoryCacheStartTime.enabled = btn_memoryCacheStartTime_Preset.enabled = spn_memoryCacheEndTime.enabled = btn_memoryCacheEndTime_Preset.enabled = useCacheRange
			spn_diskSaveStartTime.enabled = btn_diskSaveStartTime_Preset.enabled = spn_diskSaveEndTime.enabled = btn_diskSaveEndTime_Preset.enabled = useSaveRange
			btn_createPRTLoader.enabled = FranticParticles != undefined
		)
		
		on cacheParamsRollout open do
		(
			updateUI()
		)
	)
	
	rollout paramsRollout "Simulation"
	(
--		label lbl_simoptions "" offset:[0,-22]
		group "Simulation Options"
		(
			button btn_simulate "SIMULATE" width:150 height:30 enabled:false align:#center offset:[0,-4]
			
			spinner spn_startTime "Sim. Start:" range:[-100000,1000000,0]  type:#integer fieldwidth:50 offset:[56,-3] across:2 align:#right tooltip:"Defines the first frame of the simulation."
			button btn_startTime_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2)
			
			spinner spn_endTime "Sim. End:" range:[-100000,1000000,0]  type:#integer fieldwidth:50 offset:[56,-3] across:2 align:#right tooltip:"Defines the last frame of the simulation."
			button btn_endTime_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2)
			
			checkbox chk_updateViews "View Updates" offset:[-5,-3] across:3 align:#left tooltip:"When checked, the simulation results will be displayed in the viewport to preview the process.\n\nUse the value to the right to specify how often to refresh the viewport."
			spinner spn_updateViewsEvery "" type:#integer range:[1,100,1] fieldwidth:30 offset:[34,-3] align:#right tooltip:"Specifies how many frames to skip before updating the viewport during Simulation."
			button btn_updateViewsEvery_Preset ">" width:18 height:16 align:#right offset:[7,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Set how many frames to skip before updating the viewport during Simulation."
			
			--checkbox chk_openFolderAfterSim "Open Folder When Done" offset:[0,-3]
		)
		
		label lbl_birthoptions "" offset:[0,-22]
		group "Particle Birth:"
		(
			spinner spn_emitStartTime "Emit Start:" range:[-100000,1000000,0]  type:#integer fieldwidth:50 offset:[56,-3] across:2 align:#right tooltip:"Defines the first frame of particle emission.\n\nUse this to define an Emission Range as a sub-set of the Simulation Range.\n\nNote that you can alternatively keyframe the Rate value to gradually start and stop emission as often as you want within the Emission Range."
			button btn_emitStartTime_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the first frame of particle emission.\n\nUse this to define an Emission Range as a sub-set of the Simulation Range.\n\nNote that you can alternatively keyframe the Rate value to gradually start and stop emission as often as you want within the Emission Range."
			
			spinner spn_emitEndTime "Emit End:" range:[-100000,1000000,0]  type:#integer fieldwidth:50 offset:[56,-3] across:2 align:#right tooltip:"Defines the last frame of particle emission.\n\nUse this to define an Emission Range as a sub-set of the Simulation Range.\n\nNote that you can alternatively keyframe the Rate value to gradually start and stop emission as often as you want within the Emission Range."
			button btn_emitEndTime_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the last frame of particle emission.\n\nUse this to define an Emission Range as a sub-set of the Simulation Range.\n\nNote that you can alternatively keyframe the Rate value to gradually start and stop emission as often as you want within the Emission Range."
			
			dropdownlist ddl_rateMode items:#("Total Rate, Relative Split","Total Rate, Equally Split","Total Rate, Every Source","Absolute Per-Source Rate") width:148 align:#center offset:[1,-3]
			
			spinner spn_rate "Rate/Frame:" range:[0,10E8,1000]  type:#integer fieldwidth:50 offset:[56,-3] across:2 align:#right tooltip:"Defines the number of particles to emit per Emission Range Frame.\n\nNote that you can keyframe this value to gradually start and stop emission as often as you want within the Emission Range."
			button btn_Rate_Preset ">" width:18 height:16 align:#right offset:[6,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the number of particles to emit per Emission Range Frame.\n\nNote that you can keyframe this value to gradually start and stop emission as often as you want within the Emission Range."
			
			edittext edt_totalCount "Total Count:" text:"100000" readOnly:true fieldwidth:77 align:#right offset:[6,-2]
		)
		
		
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)
		
		on btn_updateViewsEvery_Preset pressed do popupPresetMenu #updateViewsEvery
		on btn_updateViewsEvery_Preset rightclick do popupPresetMenu #updateViewsEvery
		on btn_startTime_Preset pressed do popupPresetMenu #startTime
		on btn_startTime_Preset rightclick do popupPresetMenu #startTime
		on btn_endTime_Preset pressed do popupPresetMenu #endTime
		on btn_endTime_Preset rightclick do popupPresetMenu #endTime
		on btn_emitStartTime_Preset pressed do popupPresetMenu #emitStartTime
		on btn_emitStartTime_Preset rightclick do popupPresetMenu #emitStartTime
		on btn_emitEndTime_Preset pressed do popupPresetMenu #emitEndTime
		on btn_emitEndTime_Preset rightclick do popupPresetMenu #emitEndTime
		on btn_Rate_Preset pressed do popupPresetMenu #rate
		on btn_Rate_Preset rightclick do popupPresetMenu #rate
			
		fn updateRateTooltip =
		(
			case ddl_rateMode.selection of
			(
				default: (
					ddl_rateMode.tooltip = "Emit the total number of particles per frame specified by the global 'Rate/Frame' value.\n\nSplit that amount between all selected Distribution Sources to produce the proportional rates based on the per-source absolute Rates."
					btn_rate_preset.enabled = spn_rate.enabled = true
				)
				2: (
					ddl_rateMode.tooltip = "For EACH Distribution Source, emit the SAME number of particles per frame by splitting the global 'Rate/Frame' value equally between the active sources.\n\nFor example, if Rate/Frame is 1000 and 5 Sources are selected, emit 200 particles from each object.\n\nThis will ignore the per-source Rates."
					btn_rate_preset.enabled = spn_rate.enabled = true
				)
				3: (
					ddl_rateMode.tooltip = "For EACH Distribution Source, emit the SAME number of particles per frame specified by the global 'Rate/Frame' value.\n\nFor example, if Rate/Frame is 100 and 3 Sources are selected, emit 300 particles, 100 from each.\n\nThis will ignore the per-source Rates."
					btn_rate_preset.enabled = spn_rate.enabled = true
				)
				4: (
					ddl_rateMode.tooltip = "Emit the number of particles specified by each Distribution Source's Rate.\n\nIgnore the global 'Rate/Frame' value."
					btn_rate_preset.enabled = spn_rate.enabled = false
				)
			)
		)
		
		fn updateUI =
		(
			btn_simulate.enabled = (for i in activeDistSource where isValidNode i collect i).count > 0 and  (for i in activeVelocitySources where isValidNode i collect i).count > 0 

			local activeEmittersCount = 0
			for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do activeEmittersCount += 1
			local totalValue = 0
			for t =emitStartTime to emitEndTime do
			(	
				at time t 				
				(
					local totalRates = 0.0
					for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do totalRates += distRates[o]
					for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do
					(
						totalValue+= case rateMode of
						(
							1: (floor (((((distRates[o] as float)/totalRates)*rate))+0.5) ) as integer
							2: (floor (((1.0*rate)/activeEmittersCount)+0.5) ) as integer
							3: rate
							4: distRates[o]
							default: 0
						)			
					)
				)
			)--end t loop
			edt_totalCount.text = totalValue as string
		)	
		
		on ddl_rateMode selected itm do 
		(
			updateRateTooltip()
			updateUI()
			paramsDistributionRollout.refreshRateValues()
		)
		
		on spn_emitStartTime changed val do updateUI()
		on spn_emitEndTime changed val do updateUI()
		on spn_rate changed val do 
		(
			updateUI()
			paramsDistributionRollout.refreshRateValues()
		)

		on paramsRollout open do updateUI()
		
		
		on btn_simulate pressed do
		(
			if not ReflowGlobal.Licensed do
			(
				messagebox "STOKE MX requires a license to perform a particle simulation,\nbut no valid Stoke license could be found.\n\nPlease email sales@thinkboxsoftware.com to request a license."  title:"No License Found!"
				return false
			)
			
			outPath = outputPath + "\\StokeOutput\\" + (getFileNameFile maxFileName)+ "\\" +selection[1].name + "\\"
			makeDir outPath all:true
			if not doesFileExist outPath do 
			(
				format "--STOKE: Failed To Create Path: [%] \n" outPath
				return false
			)
			
			local particleGenerators = #()
			
			local theChannelsToOutput = #()
			local alreadyProcessed = #()
			local isParticleEmitter = #()
			
			local memoryCacheCounter = 0
			
			local theIDAllocator = ReflowGlobal.CreateIDAllocator()
			--showInterface theIDAllocator
			
			at time startTime 
			(
				local totalRates = 0.0
				local activeEmittersCount = 0
				for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do 
				(
					totalRates += distRates[o]
					activeEmittersCount += 1
				)
				
				for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do 
				(
					local theType = ReflowGlobal.GetSourceType DistSources[o]
					theJitterValue = distJitterRadius[o]
					if classof theJitterValue != Float do theJitterValue = 0.0
					
					case theType of
					(
						#particles: 
						(
							local pg = ReflowGlobal.CreateKrakatoaGenerator DistSources[o] JitterRadius:theJitterValue IgnoreIDs:false
							local theChannels = for i in pg.AvailableChannels collect filterString i " []"
							isParticleEmitter[o] = true
							--showInterface pg
						)
						#geometry:
						(
							local theGeometryMode = geometryMode[o]
							if theGeometryMode == undefined or theGeometryMode == "" do theGeometryMode = "Surface"
								
							local theVSpacing= distVolumeSpacing[o]
							if theVSpacing == undefined do theVSpacing = 1.0
							if theVSpacing < 0.01 do theVSpacing = 0.01
								
							local pg = ReflowGlobal.CreateGeometryGenerator DistSources[o] mode:theGeometryMode SelectionType:(DistSourcesSelectionType[o] as string) VolumeSpacing:theVSpacing VertexJitterRadius:theJitterValue
							local theChannels = for i in pg.AvailableChannels collect filterString i " []"
							isParticleEmitter[o] = false
						)
					)
					for aChannel in theChannels where findItem channelsToSave aChannel[1] > 0 do
					(
						if findItem alreadyProcessed aChannel[1] == 0 do
						(
							local theResult = aChannel[1] + " "
							theResult += case of
							(
								(matchPattern aChannel[2] pattern:"float*"): "float32"
								(matchPattern aChannel[2] pattern:"int*"): "int32"
								default: aChannel[2]
							)
							if aChannel[3] != undefined then
								theResult += "[" +aChannel[3] as string + "]"
							else
								theResult += "[1]"

							append theChannelsToOutput theResult
							append alreadyProcessed aChannel[1]
						)
					)
					if startTime >= emitStartTime and startTime <= emitEndTime then
					(
						if isParticleEmitter[o] == true and distSeedAsRate[o] == true then
							pg.GeneratorRate = -1
						else
						(
							case rateMode of
							(
								1: pg.GeneratorRate = if totalRates != 0 then ((floor ( 0.5 + (((distRates[o] as float)/totalRates)*rate))) as integer) else 0
								2: pg.GeneratorRate = (floor ((1.0*rate/activeEmittersCount))+0.5) as integer
								3: pg.GeneratorRate = rate
								4: pg.GeneratorRate = distRates[o]
								default: 0
							)
						)
					)
					else
						pg.GeneratorRate = 0
					pg.InitialLifespan = [ 1.0*(lifeSpan-lifeSpanVar) / FrameRate, 1.0*(lifeSpan+lifeSpanVar) / FrameRate ]
					pg.RandomSeed = randomSeed + (if incrementRandomSeed then startTime as integer else 0) + o
					pg.DiffusionConstant = theJitterValue
					pg.IDAllocator = theIDAllocator
					particleGenerators[o] = pg
					--showInterface pg
				)
			)--end at time 
			
			if not useViewportParticles do 
				ReflowGlobal.BeginRenderMode activeDistSource
			
			local theFields = #()
			
			for i = 1 to VelocitySources.count where findItem activeVelocitySources VelocitySources[i] > 0 and isValidNode VelocitySources[i] do 
			(
				local theField = if ReflowGlobal.GetSourceType VelocitySources[i] == #particles then 
					ReflowGlobal.CreateParticleVelocityField VelocitySources[i] gridSize BoundsPadding:gridPadding RemoveDivergence:fluidMotion
				else
					ReflowGlobal.CreateReflowField VelocitySources[i]
				theField.VelocityScale = VelocityScales[i]
				append theFields theField
			)
			
			local theReflowField = if theFields.count == 1 then ( theFields[1] ) else ( ReflowGlobal.CreateAdditiveVelocityField theFields )
			
			local theAdvector = ReflowGlobal.CreateAdvector "RK2"
			local theParticleSet = ReflowGlobal.CreateParticleSet theChannelsToOutput
			--showInterface theParticleSet

			for pg in particleGenerators where pg != undefined do pg.InitialVelocityField = theReflowField
			
			this.delegate.ClearParticleCache()
			gc light:true
			
			local updateCounter = 0
			local st = timestamp()
			progressStart "Simulating..."
			
			local advectTime = 0.0
			local advanceTime = 0.0
			local generateTime  = 0.0
			
			theReflowField.ResetSimulation()
			for pg in particleGenerators where pg != undefined do pg.ResetSimulation()
					
			try
			(
				--Generate the initial set of particles for the first frame. They will be jittered in time then
				--advected using pg.InitialVelocityField to move them to age 0.0
				generateSt = timestamp()
				for pg in particleGenerators where pg != undefined do pg.GenerateNextParticles theParticleSet
				generateTime += (timestamp()-generateSt)/1000.0
				
				if saveResultsToDisk do 
					if useSaveRange then
						if startTime >= diskSaveStartTime and startTime <= diskSaveEndTime do					
							ReflowGlobal.WriteParticleSet theParticleSet ( outPath+"StokeSimulation_"+(formattedPrint startTime format:"04d")+".prt" )
					else
						ReflowGlobal.WriteParticleSet theParticleSet ( outPath+"StokeSimulation_"+(formattedPrint startTime format:"04d")+".prt" )
				
				if cacheResultsInMemory do
				(
					if useCacheRange then 
						if startTime >= memoryCacheStartTime and startTime <= memoryCacheEndTime do 
							this.delegate.AddParticleSet ( theParticleSet.Clone() ) startTime
					else
						this.delegate.AddParticleSet ( theParticleSet.Clone() ) startTime
				)
			)
			catch
			(
				format "--STOKE Error: % \n" ( getCurrentException() )
				if saveResultsToDisk do 
					deleteFile ( outPath+"StokeSimulation_"+(formattedPrint simFrame format:"04d")+".prt" )
			)
			
			updateCounter += 1
			if updateViews do 
				if updateViewsEvery == updateCounter do
				(
					sliderTime = startTime
					updateCounter = 0
				)
			
			for simFrame = startTime+1 to endTime do 
			(
				at time simFrame 
				(
					totalRates = 0.0
					activeEmittersCount = 0
					for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do 
					(
						totalRates += distRates[o]
						activeEmittersCount += 1
					)				
					
					for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do 
					(
						if simFrame >= emitStartTime and simFrame <= emitEndTime then
						(
							if isParticleEmitter[o] == true and distSeedAsRate[o] == true then 
								particleGenerators[o].GeneratorRate = -1
							else
							(
								case rateMode of
								(
									1: particleGenerators[o].GeneratorRate = if totalRates != 0 then ((floor ( 0.5 + (((distRates[o] as float)/totalRates)*rate))) as integer) else 0
									2: particleGenerators[o].GeneratorRate = (floor ((1.0*rate/activeEmittersCount))+0.5) as integer
									3: particleGenerators[o].GeneratorRate = rate
									4: particleGenerators[o].GeneratorRate = distRates[o]
									default: 0
								)
							)
							theJitterValue = distJitterRadius[o]
							if classof theDCValue != Float do theJitterValue = 1.0
							particleGenerators[o].DiffusionConstant = theJitterValue
							particleGenerators[o].RandomSeed = randomSeed + (if incrementRandomSeed then simFrame as integer else 0) + o
						)
						else
						(
							particleGenerators[o].GeneratorRate = 0
						)
					)
					
					cnt = 0
					for i = 1 to VelocitySources.count where findItem activeVelocitySources VelocitySources[i] > 0 and isValidNode VelocitySources[i] do 
					(
						cnt += 1
						theFields[cnt].VelocityScale = VelocityScales[i]
					)
					theReflowField = if theFields.count == 1 then ( theFields[1] ) else ( ReflowGlobal.CreateAdditiveVelocityField theFields )					
				)
				try
				(
					--Advance the particles to the next frame
					advectst = timestamp()
					ReflowGlobal.AdvectParticleSet theParticleSet theAdvector theReflowField (1.0 / FrameRate)
					advectTime += ((timestamp()-advectst)/1000.0)
					
					--Generate particles born before the next frame
					generateSt = timestamp()
					for pg in particleGenerators where pg != undefined do pg.GenerateNextParticles theParticleSet
					generateTime += (timestamp()-generateSt)/1000.0
					
					--Delete any particles that died before the next frame
					if useLifeSpan do theParticleSet.DeleteDeadParticles()
					
					--Advance the velocity field to the next frame
					advanceSt = timestamp()
					theReflowField.AdvanceSimulation()
					advanceTime += ((timestamp()-advanceSt)/1000.0)

					
					if saveResultsToDisk do 
						if useSaveRange then
							if simFrame >= diskSaveStartTime and simFrame <= diskSaveEndTime do					
								ReflowGlobal.WriteParticleSet theParticleSet ( outPath+"StokeSimulation_"+(formattedPrint simFrame format:"04d")+".prt" )
						else
							ReflowGlobal.WriteParticleSet theParticleSet ( outPath+"StokeSimulation_"+(formattedPrint simFrame format:"04d")+".prt" )					
					
					memoryCacheCounter += 1
					if cacheResultsInMemory and memoryCacheCounter == memoryCacheStep do
					(
						memoryCacheCounter = 0
						if useCacheRange then 
							if simFrame >= memoryCacheStartTime and simFrame <= memoryCacheEndTime do 
								this.delegate.AddParticleSet ( theParticleSet.Clone() ) simFrame						
						else
							this.delegate.AddParticleSet ( theParticleSet.Clone() ) simFrame						
					)
				)
				catch
				( 
					format "--STOKE Error: % \n" ( getCurrentException() )
					if saveResultsToDisk do 
						deleteFile ( outPath+"StokeSimulation_"+(formattedPrint simFrame format:"04d")+".prt" )
				)
				updateCounter += 1
				if updateViews do 
					if updateViewsEvery == updateCounter do
					(
						sliderTime = simFrame
						updateCounter = 0
					)
				
				if not (progressUpdate (100.0*(simFrame-startTime)/(endTime-startTime))) do exit
			)--end sim loop

			local et = timestamp()
			local theTimeString = ("Time: "+((et-st)/1000.0) as string +" sec." )
			pushPrompt theTimeString 
			format "--STOKE %\n" theTimeString 
			
			-- NB! Must call EndRenderMode with same list as BeginRenderMode
			if not useViewportParticles do 
				ReflowGlobal.EndRenderMode activeDistSource
			
			oldPercent = this.delegate.ViewportPercentage
			this.delegate.ViewportPercentage = 0
			this.delegate.ViewportPercentage = oldPercent
			paramsDisplayRollout.updateUI()
			
			progressEnd()			
			
			format "--advectTime = %\n" advectTime 
			format "--advanceTime = %\n" advanceTime 
			format "--generateTime = %\n\n" generateTime  
			
			--if openFolderAfterSim do shellLaunch "explorer.exe" outPath
		)
	)
	
	rollout paramsLifespanRollout "Particle Lifespan"
	(
		checkbox chk_useLifeSpan "Delete 'Dead' Particles" offset:[-5,-4] across:2 tooltip:"When checked, particles with Age greater than the Lifespan will be deleted during the simulation.\n\nWhen unchecked, the Age and Lifespan will still be generated, but not used to delete particles during the simulation.\nYou could use a Magma and a Krakatoa Delete modifier to delete post-simulation."
		button btn_AgeLifespanPresets "^" width:18 height:18 align:#right offset:[10,-4] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,19,19,20,20) tooltip:"Add Krakatoa Magma and Delete modifiers to dynamically delete particles by Age and LifeSpan."
		
		spinner spn_lifeSpan "Lifespan:" range:[1,1000000,25] type:#integer fieldwidth:50 offset:[60,-3] across:2 align:#right tooltip:"Defines the base value of the Lifespan.\n\nThis value is generated at Birth Time and is used to delete particles whose Age is greater than the LifeSpan when the 'Use Lifespan' checkbox is checked."
		button btn_lifeSpan_Preset ">" width:18 height:16 align:#right offset:[10,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the base value of the Lifespan.\n\nThis value is generated at Birth Time and is used to delete particles whose Age is greater than the LifeSpan when the 'Use Lifespan' checkbox is checked."
		
		spinner spn_lifeSpanVar "Variation:" range:[0,1000,5] type:#integer fieldwidth:50 offset:[60,-3] across:2 align:#right tooltip:"Defines the variation value of the Lifespan.\n\nThis value is used to produce a random variation of the Lifespan at Birth Time.\n\nIt is used as a +/- variation, in other words a Base Lifespan of 25 with a Variation of 5 will produce random values between 20 and 30."
		button btn_lifeSpanVar_Preset ">" width:18 height:16 align:#right offset:[10,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the variation value of the Lifespan.\n\nThis value is used to produce a random variation of the Lifespan at Birth Time.\n\nIt is used as a +/- variation, in other words a Base Lifespan of 25 with a Variation of 5 will produce random values between 20 and 30."
		
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)		
		
		fn updateButtonVisibility =
		(
			btn_AgeLifespanPresets.visible = FranticParticles != undefined
			btn_AgeLifespanPresets.enabled = selection.count > 0 and not ((for m in selection[1].modifiers where ((classof m == MagmaModifier and m.name == "Magma_SelectByAge") OR (classof m == KrakatoaDeleteModifier and m.name == "DeleteByAge")) collect m).count == 2)
		)
		
		on btn_AgeLifespanPresets pressed do
		(
			local theMagma = MagmaModifier name:"Magma_SelectByAge"
			modPanel.addModToSelection theMagma
			modPanel.addModToSelection (KrakatoaDeleteModifier name:"DeleteByAge")
			modPanel.setCurrentObject selection[1].baseobject
			
			local magmaNode = theMagma.magmaHolder
			magmaNode.AutomaticRenameOFF = true
			
			node0 = magmaNode.createNode "Output" 
			magmaNode.setNodeProperty node0 "channelName" "Selection"
			magmaNode.setNodeProperty node0 "channelType" "float32"
			node1 = magmaNode.createNode "InputChannel" 
			magmaNode.setNodeProperty node1 "channelName" "Age"
			node2 = magmaNode.createNode "InputChannel" 
			magmaNode.setNodeProperty node2 "channelName" "LifeSpan"
			node3 = magmaNode.createNode "Greater" 
			magmaNode.setNodeInputDefaultValue node3 2 0.0
			node4 = magmaNode.createNode "ToFloat" 
			magmaNode.setNodeInput node0 1 node4 1
			magmaNode.setNodeInput node3 1 node1 1
			magmaNode.setNodeInput node3 2 node2 1
			magmaNode.setNodeInput node4 1 node3 1
			
			local theNodes = #(node0,node1,node2,node3,node4)
			local thePositions = #([100,100], [470,30],[470,90], [610,20], [750,0])
			for i = 1 to theNodes.count do 
			(
				magmaNode.DeclareExtensionProperty theNodes[i] "Position"
				magmaNode.SetNodeProperty theNodes[i] "Position"  thePositions[i]
			)
		)

		on btn_lifeSpan_Preset pressed do popupPresetMenu #lifeSpan
		on btn_lifeSpan_Preset rightclick do popupPresetMenu #lifeSpan
		on btn_lifeSpanVar_Preset pressed do popupPresetMenu #lifeSpanVar
		on btn_lifeSpanVar_Preset rightclick do popupPresetMenu #lifeSpanVar
			
		on paramsLifespanRollout open do
		(
			updateButtonVisibility()
		)
	)	
	
	rollout paramsDistributionRollout "Distribution"
	(
		fn filterPRTObjects obj =
		(
			findItem GeometryClass.classes (classof obj.baseobject) > 0 AND findItem distSources obj == 0 and obj != selection[1] and findItem #(targetObject, FumeFX) (classof obj.baseobject) == 0
		)
		pickbutton pck_pickObjects "Pick..." width:45 align:#left across:3 offset:[-12,-5] height:18 filter:filterPRTObjects tooltip:"Pick a Distribution Object in the scene.\n\nSupported objects are all PRT objects including PRT Loader, PRT Volume, PRT Surface, PRT FumeFX, PRT Hair, PRT Maker and PRT Source."
		button btn_addByName "By Name..." width:62 align:#center offset:[-2,-5] height:18 tooltip:"Pick Distribution Objects by name from a list."
		button btn_removeSelectedSources "Remove" width:50 align:#right offset:[12,-5] height:18 tooltip:"Remove the highlighted object from the list."

		dotNetControl dnc_distributionSources "ListView" width:158 align:#center height:120 offset:[0,-4]

		spinner spn_perObjectJitter "Jitter Radius:" type:#float range:[0,100000,10] fieldwidth:50 offset:[61,-3] across:2 align:#right tooltip:"Define the Random Jitter Radius .\n\nSpecifying 0 will disable the position randomization."
		button btn_perObjectJitter_Preset ">" width:18 height:16 align:#right offset:[11,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Define the Random Jitter Radius .\n\nSpecifying 0 will disable the position randomization."
		
		spinner spn_perObjectRate "Source Rate:" type:#integer range:[0,10^8,1000] across:2 fieldwidth:50 offset:[61,-3] align:#right tooltip:"Defines the Emission Rate of the highlight distribution source objects."
		button btn_perObjectRate_Preset ">" width:18 height:16 align:#right offset:[11,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the Emission Rate of the highlight distribution source objects."

		spinner spn_perObjectVolumeSpacing "Volume Spacing:" type:#float range:[0.01,100000.0,1] across:2 fieldwidth:50 offset:[61,-3] align:#right tooltip:"Defines the Mesh Volume Spacing."
		button btn_perObjectVolumeSpacing_Preset ">" width:18 height:16 align:#right offset:[11,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Defines the Mesh Volume Spacing."
		
		checkbox chk_autoRate "Use Seed Count As Rate" offset:[-10,-22] align:#left

		dropdownlist ddl_geometryMode items:#("Surface","Volume","Vertices","Edges") offset:[-10,-3] width:60 align:#left across:2 tooltip:"Defines the Mesh Distribution Mode."
		dropdownlist ddl_selectionMode items:#("All Faces","Face Selection","Vertex Soft Sel.") offset:[12,-3] width:98 align:#right tooltip:"Controls the Mesh Distribution use of the whole object, or its Face, Edge and Vertex Selections."
		
		dotNetControl dnc_availableChannels "ListView" width:158 align:#center height:120 offset:[0,-1]

		checkbox chk_useViewportParticles "Emit From Viewport Particles" offset:[-10,-2] tooltip:"When unchecked, the render time particles of Distribution Sources will be used to seed simulation particles.\n\nWhen checked, the viewport particles will be used as seeds."

		checkbox chk_incrementRandomSeed "Vary Randomness Over Time" offset:[-10,-2] tooltip:"When checked, the Random Seed will be incremented by each frame.\n\nWhen unchecked, the same Random Seed will be used on every frame, unless explicitly keyframed."
		spinner spn_randomSeed "Random Seed:" type:#integer range:[0,1000000,12345] fieldwidth:50 offset:[61,-2] across:2 tooltip:"Controls the random distribution particle selection.\n\nChanging this value will change the random pattern when picking particles to emit from."
		button btn_randomSeed_Preset ">" width:18 height:16 align:#right offset:[11,-2] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Controls the random distribution particle selection.\n\nChanging this value will change the random pattern when picking particles to emit from."
		
			
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)		
		
		fn getSourceChannelsList =
		(
			availableChannels = #()
			availableChannelNames = #()

			for aSource in activeDistSource where isValidNode aSource do
			(
				local pg =	if ReflowGlobal.GetSourceType aSource  == #particles then  --if classof aSource.baseobject == KrakatoaPRTLoader or matchPattern ((classof aSource.baseobject) as string) pattern:"PRT_*" then
					ReflowGlobal.CreateKrakatoaGenerator aSource
				else
					ReflowGlobal.CreateGeometryGenerator aSource
				local theChannels = for i in pg.AvailableChannels collect filterString i " []"				
				tempArray = for aChannel in theChannels where findItem #("Position","Velocity","Age","LifeSpan","ID") aChannel[1] == 0 collect 
				(
					local theResult = case of
					(
						(matchPattern aChannel[2] pattern:"float*"): "float32"
						(matchPattern aChannel[2] pattern:"int*"): "int32"
						default: aChannel[2]
					)
					if aChannel[3] != undefined and aChannel[3] != 1 then
						theResult += "[" +aChannel[3] as string + "]"
					else
						theResult += "" --"[1]"
					#(aChannel[1],theResult)
				)
				for aChannel in tempArray where findItem availableChannelNames aChannel[1] == 0 do 
				(
					append availableChannelNames aChannel[1]
					append availableChannels aChannel
				)
			)
			availableChannels
		)
		
		local dn_distribution_bg, dn_channels_bg, prtColor, surfaceColor, volumeColor, vertColor, edgeColor, grayColor, pflowColor
		local VectorColor, FloatColor, IntColor
		fn getUIColors =
		(
			local textColor = ( ((colorman.getcolor #text) as color)*255)
			local maxBgColor = (((colorman.getcolor #window)) as color)*255
			
			local blackColor = (dotNetClass "System.Drawing.Color").fromARGB textColor.r textColor.g textColor.b
			if maxBgColor.v >= 160 then
			(
				dn_distribution_bg = (dotNetClass "System.Drawing.Color").fromARGB 240 235 230 
				dn_channels_bg = (dotNetClass "System.Drawing.Color").fromARGB 220 230 220
				prtColor =  (dotNetClass "System.Drawing.Color").fromARGB 0 0 0
				surfaceColor =  (dotNetClass "System.Drawing.Color").fromARGB 0 100 0
				volumeColor =  (dotNetClass "System.Drawing.Color").fromARGB 0 0 200 
				vertColor = (dotNetClass "System.Drawing.Color").fromARGB 0 100 150 
				edgeColor = (dotNetClass "System.Drawing.Color").fromARGB 200 0 200 
				grayColor = (dotNetClass "System.Drawing.Color").fromARGB 180 180 180
				pflowColor =  (dotNetClass "System.Drawing.Color").fromARGB 100 0 0		

				VectorColor = (dotNetClass "System.Drawing.Color").fromARGB 0 0 0
				FloatColor = (dotNetClass "System.Drawing.Color").fromARGB 0 100 0
				IntColor = (dotNetClass "System.Drawing.Color").fromARGB 0 0 150				
			)
			else
			(
				dn_distribution_bg = (dotNetClass "System.Drawing.Color").fromARGB 80 70 70 
				dn_channels_bg = (dotNetClass "System.Drawing.Color").fromARGB 70 80 70

				prtColor =  (dotNetClass "System.Drawing.Color").fromARGB 255 255 255
				surfaceColor =  (dotNetClass "System.Drawing.Color").fromARGB 200 255 200
				volumeColor =  (dotNetClass "System.Drawing.Color").fromARGB 200 200 255 
				vertColor = (dotNetClass "System.Drawing.Color").fromARGB 150 220 255 
				edgeColor = (dotNetClass "System.Drawing.Color").fromARGB 255 200 255 
				grayColor = (dotNetClass "System.Drawing.Color").fromARGB 200 200 200
				pflowColor =  (dotNetClass "System.Drawing.Color").fromARGB 255 100 100		

				VectorColor = (dotNetClass "System.Drawing.Color").fromARGB 255 255 255
				FloatColor = (dotNetClass "System.Drawing.Color").fromARGB 200 255 200
				IntColor = (dotNetClass "System.Drawing.Color").fromARGB 200 200 255					
			)			
		)
		
		
		fn initDistListView =
		(
			layout_def = #( #("Source",90),  #("Rate",50), #("Emit From",60), #("Sub-Set",60),#("Jitter",60), #("Spacing",60))
			lv = dnc_distributionSources
			lv.Clear()
			lv.backColor = dn_distribution_bg
			lv.View = (dotNetClass "System.Windows.Forms.View").Details
			lv.gridLines = true 
			lv.fullRowSelect = true
			lv.checkboxes = true
			lv.hideSelection = false
			lv.ShowItemToolTips = true				
			lv.MultiSelect = false
			--showProperties lv
			for i in layout_def do lv.Columns.add i[1] i[2]
		)		
		
		fn initChannelsListView =
		(
			layout_def = #( #("Channel",92), #("Format",60) )
			lv = dnc_availableChannels
			lv.Clear()
			lv.backColor = dn_channels_bg
			lv.View = (dotNetClass "System.Windows.Forms.View").Details
			lv.gridLines = true 
			lv.fullRowSelect = true
			lv.checkboxes = true
			lv.hideSelection = false
			lv.ShowItemToolTips = true
			for i in layout_def do lv.Columns.add i[1] i[2]
		)


		
		fn updateObjectsList =
		(
			try
			(
				local theSel = getListViewSelection dnc_distributionSources
				local lv = dnc_distributionSources
				lv.items.Clear()
				local theRange = #()
				for i = 1 to distSources.count do
				(
					local theObj = distSources[i]
					theName = (if isValidNode theObj then theObj.name else "<Deleted>")
					local li = dotNetObject "System.Windows.Forms.ListViewItem" theName
					case (ReflowGlobal.GetSourceType DistSources[i]) of
					(
						#particles: (
							li.forecolor = prtColor
							li.tag = "prt"
						)
						#geometry:
						(
							li.forecolor = case geometryMode[i]  of
							(
								default: surfaceColor
								"Volume": volumeColor
								"Vertices": vertColor
								"Edges": edgeColor
							)
							li.tag = "mesh"
						)
						default:
						(
							li.forecolor = grayColor
							li.tag = "none"
						)
					)
					li.checked = findItem activeDistSource theObj > 0 and isValidNode theObj 
					local subLi = li.SubItems.add (distRates[i] as string)			
					local subLi = li.SubItems.add ""
					local subLi = li.SubItems.add ""
					local subLi = li.SubItems.add ""
					local subLi = li.SubItems.add ""
					append theRange li
				)
				lv.Items.AddRange theRange 			
				paramsDistributionRollout.refreshRateValues()
				setListViewSelection dnc_distributionSources theSel						
			)catch()
		)
		
		fn refreshRateValues =
		(
			if rateMode == 1 then
			(
				local totalRates = 0.0
				local activeEmittersCount = 0
				for o = 1 to DistSources.count where isValidNode DistSources[o] and findItem activeDistSource DistSources[o] > 0 do 
				(
					totalRates += distRates[o]
					activeEmittersCount += 1
				)
				try(dnc_distributionSources.columns.item[1].Text = "Ratio")catch()
			)
			else
			(
				try(dnc_distributionSources.columns.item[1].Text = "Rate")catch()
			)
			--btn_perObjectRate_Preset.enabled = spn_perObjectRate.enabled = findItem #(1,4) rateMode > 0 and not chk_autoRate.state
			--btn_perObjectRate_Preset.visible = spn_perObjectRate.visible = rateMode != 1
			
			for i = 1 to distSources.count do
			(
				local theValue = if distSeedAsRate[i] == true then
				(
					"Auto"
				)
				else
				(
					case rateMode of
					(
						1: (
							if totalRates == 0 or findItem activeDistSource DistSources[i] == 0 then 
								"0.0%"							
							else 
								(((floor ((distRates[i] as float)/totalRates*1000))/10.0) ) as string + "%" 
							
						)
						2: (((floor ((1.0*rate/activeDistSource.count)+0.5)) as integer )as string)
						3: (rate as string)
						default: (distRates[i] as string)
					)
				)
				
				try(dnc_distributionSources.items.item[i-1].subItems.Item[1].Text = theValue)catch()
				
		
				local theJRString = if classof distJitterRadius[i] != Float then "1.0" else distJitterRadius[i] as string
				local theVSString = if classof distVolumeSpacing[i] != Float then "1.0" else distVolumeSpacing[i] as string

				local isMesh = true
				local theModeString = geometryMode[i] 
				if theModeString == undefined do theModeString = "Surface"
					
				local theSelString = case distSourcesSelectionType[i] of
				(
					default: ("All ")
					"VertexSelection": "Vertex Soft Selection"
					"FaceSelection": 
					(
						case theModeString of
						(
							"Edges": "Edge Selection" 
							"Surface": "Face Selection"
							default: "All"
						)
					)
				)				
				
				try
				(
					isMesh = dnc_distributionSources.items.item[i-1].tag == "mesh"
					if not isMesh do theModeString = "Particles"
					local theTooltipText = (if isValidNode distSources[i] then distSources[i].name else "<Deleted>") + "\n\n"
					
					theTooltipText += "Emit From: " + theModeString  
					if theModeString == "Volume" then 
						theTooltipText += ", Spacing: " + theVSString  + "\n"
					else
						theTooltipText += "\n"
					if isMesh do theTooltipText += "Sub-Set: " + theSelString + "\n"
					theTooltipText += "Rate: " 
					theTooltipText += if distSeedAsRate[i] == true then "Auto" else (distRates[i] as string + (if rateMode == 1 then (" ("+theValue+")") else "" ))
					theTooltipText += "\n"
					theTooltipText += "Jitter: " + theJRString  + "\n"
						
					dnc_distributionSources.items.item[i-1].TooltipText = theTooltipText
				)catch()
				try(dnc_distributionSources.items.item[i-1].subItems.Item[2].Text = theModeString )catch()				
				local theSelString = case distSourcesSelectionType[i] of
				(
					default: "All"
					"VertexSelection": 
					(
						if theModeString == "Volume" then "All" else "Vert SS"
					)
					"FaceSelection": 
					(
						case theModeString of 
						(
							"Edges": "Edge Sel." 
							"Surface": "Face Sel."
							default: "All"
						)
					)
				)	
				try
				(
					dnc_distributionSources.items.item[i-1].subItems.Item[3].Text = theSelString
					
					if isMesh then 
					(
						dnc_distributionSources.items.item[i-1].forecolor = case geometryMode[i]  of
						(
							default: surfaceColor
							"Volume": volumeColor
							"Vertices": vertColor
							"Edges": edgeColor
						)				
					)
					else
					(
						dnc_distributionSources.items.item[i-1].forecolor = prtColor
					)
				)catch()	
				local theVal = distJitterRadius[i]
				if theVal == undefined do theVal = 10.0
				try(dnc_distributionSources.items.item[i-1].subItems.Item[4].Text = theVal as string)catch()

				local theVal = distVolumeSpacing[i]
				if theVal == undefined do theVal = 1.0
				if theVal < 0.01 do theVal = "(0.01)"
				if not isMesh do theVal = "N/A"
				try(dnc_distributionSources.items.item[i-1].subItems.Item[5].Text = theVal as string)catch()
				
			)--end i loop
		)

		fn updateChannelsList =
		(
			local lv = dnc_availableChannels
			lv.items.Clear()
			local theRange = #()
			for aChannel in availableChannels do
			(
				local li = dotNetObject "System.Windows.Forms.ListViewItem" aChannel[1]
				li.tooltiptext = (aChannel[1] + " " + aChannel[2])
				li.checked = findItem channelsToSave aChannel[1] > 0
				li.forecolor = case of
				(
					default: FloatColor
					(matchPattern aChannel[2] pattern:"float32*3*"): VectorColor 
					(matchPattern aChannel[2] pattern:"int*"): IntColor
				)
				local subLi = li.SubItems.add aChannel[2]
				append theRange li
			)
			lv.Items.AddRange theRange 					
		)

		fn updateControlVisibility = 
		(
			local isInCreateMode = getCommandPanelTaskMode() == #create
			spn_perObjectRate.enabled = btn_perObjectRate_Preset.enabled = spn_perObjectJitter.enabled = btn_perObjectJitter_Preset.enabled = not isInCreateMode
			pck_pickObjects.enabled = btn_addByName.enabled = btn_removeSelectedSources.enabled = spn_perObjectVolumeSpacing.enabled = btn_perObjectVolumeSpacing_Preset.enabled = ddl_geometryMode.enabled = ddl_selectionMode.enabled = not isInCreateMode
			
			local isMesh = false
			local isParticles = false
			local theSel = getListViewSelection dnc_distributionSources
			if theSel.count > 0 then
			(
				isMesh = dnc_distributionSources.items.item[theSel[1]-1].tag == "mesh"
				isParticles = not isMesh
				spn_perObjectRate.visible = btn_perObjectRate_Preset.visible = spn_perObjectJitter.visible = btn_perObjectJitter_Preset.visible = true
				spn_perObjectVolumeSpacing.visible = btn_perObjectVolumeSpacing_Preset.visible = ddl_geometryMode.visible = ddl_selectionMode.visible = isMesh
				if isMesh then
				(
					dnc_availableChannels.pos = [2,218]
					dnc_availableChannels.height = 124
				)
				else
				(
					dnc_availableChannels.pos = [2,194]
					dnc_availableChannels.height = 148
				)
				chk_autoRate.visible = isParticles
			)
			else
			(
				ddl_selectionMode.visible = ddl_geometryMode.visible = chk_autoRate.visible = spn_perObjectVolumeSpacing.visible = btn_perObjectVolumeSpacing_Preset.visible = false
				spn_perObjectRate.visible = btn_perObjectRate_Preset.visible = spn_perObjectJitter.visible = btn_perObjectJitter_Preset.visible = false
				dnc_availableChannels.pos = [2,140]
				dnc_availableChannels.height = 202
			)
			
		)
		
		fn updateUI =
		(
			getSourceChannelsList()
			updateControlVisibility()
		)
		
		on btn_randomSeed_Preset pressed do popupPresetMenu #randomSeed
		on btn_randomSeed_Preset rightclick do popupPresetMenu #randomSeed
		
		on btn_JitterRadius_Preset pressed do popupPresetMenu #JitterRadius
		on btn_JitterRadius_Preset rightclick do popupPresetMenu #JitterRadius
			
		on btn_perObjectRate_Preset pressed do popupPresetMenu #perObjectRate
		on btn_perObjectRate_Preset rightclick do popupPresetMenu #perObjectRate
			
		on btn_perObjectJitter_Preset pressed do popupPresetMenu #perObjectJitter
		on btn_perObjectJitter_Preset rightclick do popupPresetMenu #perObjectJitter
			
		on btn_perObjectVolumeSpacing_Preset pressed do popupPresetMenu #perObjectVolumeSpacing
		on btn_perObjectVolumeSpacing_Preset rightclick do popupPresetMenu #perObjectVolumeSpacing
			
		fn updatePerObjectRate =
		(
			if not lockUpdates do 
			(
				local theSel = getListViewSelection dnc_distributionSources
				for i in theSel do
				(
					distRates[i] = perObjectRate
				)
				refreshRateValues()
				setListViewSelection dnc_distributionSources theSel			
			)
		)
			
		on spn_perObjectRate changed val do
		(
			updatePerObjectRate()
		)
		
		fn updatePerObjectSpacing =
		(
			if not lockUpdates do 
			(
				local theSel = getListViewSelection dnc_distributionSources
				for i in theSel do
				(
					distVolumeSpacing[i] = perObjectVolumeSpacing
				)
				refreshRateValues()
				setListViewSelection dnc_distributionSources theSel			
			)
		)
		
		on spn_perObjectVolumeSpacing changed val do 
		(
			updatePerObjectSpacing()
		)
		
		fn updateperObjectJitter =
		(
			if not lockUpdates do 
			(
				local theSel = getListViewSelection dnc_distributionSources
				for i in theSel do
				(
					distJitterRadius[i] = perObjectJitter
				)
				refreshRateValues()
				setListViewSelection dnc_distributionSources theSel			
			)			
		)
		
		fn updatePerObjectControls =
		(
			ddl_geometryMode.enabled = btn_perObjectRate_Preset.enabled = spn_perObjectRate.enabled = ddl_selectionMode.enabled = chk_autoRate.enabled = false
			lockUpdates = true
			local theSel = getListViewSelection dnc_distributionSources
			if theSel.count > 0 do 
			(
				perObjectRate = distRates[theSel[1]]
				theVal = distJitterRadius[theSel[1]]
				if theVal == undefined do theVal =10.0
				perObjectJitter = theVal
				
				theVal = distVolumeSpacing[theSel[1]]
				if theVal == undefined do theVal =1.0
				perObjectVolumeSpacing = theVal
				
				theIndex = findItem #("Surface","Volume","Vertices","Edges") geometryMode[theSel[1]]
				if theIndex == 0 do theIndex = 1
				ddl_geometryMode.selection = theIndex	
				
				case theIndex of
				(
					default: (
						ddl_selectionMode.items = #("All Faces","Vertex Soft Sel.","Face Selection")
						theIndex2 = findItem #("","VertexSelection","FaceSelection") distSourcesSelectionType[theSel[1]]
					)
					2: (
						ddl_selectionMode.items = #("All")
						theIndex2 = 1
					)
					3: (
						ddl_selectionMode.items = #("All","Vertex Soft Sel.")
						theIndex2 = findItem #("","VertexSelection") distSourcesSelectionType[theSel[1]]
					)
					4: (
						ddl_selectionMode.items = #("All","Vertex Soft Sel.","Edge Selection")
						theIndex2 = findItem #("","VertexSelection","FaceSelection") distSourcesSelectionType[theSel[1]]
					)
				)
				if theIndex2 == 0 do theIndex2 = 1
				ddl_selectionMode.selection = theIndex2
				
				
				ddl_geometryMode.enabled = ddl_selectionMode.enabled = dnc_distributionSources.items.item[theSel[1]-1].Tag == "mesh"
				
				
				chk_autoRate.enabled = dnc_distributionSources.items.item[theSel[1]-1].Tag == "prt"
				chk_autoRate.state = distSeedAsRate[theSel[1]] == true
				btn_perObjectRate_Preset.enabled = spn_perObjectRate.enabled = findItem #(1,4) rateMode > 0 AND not chk_autoRate.state
			)
			lockUpdates = false
		)		
		
		on spn_perObjectJitter changed val do
		(
			updateperObjectJitter()
		)
		
		on chk_autoRate changed state do
		(
			if not lockUpdates do 
			(
				local theSel = getListViewSelection dnc_distributionSources
				for i in theSel do
				(
					distSeedAsRate[i] = state
				)
				refreshRateValues()
				updatePerObjectControls()
				setListViewSelection dnc_distributionSources theSel			
			)			
		)		
		
		
		on dnc_distributionSources mouseClick arg do 
		(
			local theSel = getListViewSelection dnc_distributionSources
			if theSel.count > 0 and arg.Button == arg.Button.Right do
			(
				RCMenuSourceObject = distSources[theSel[1]]
				local theMenu = defineRCMenu()
				popupMenu theMenu pos:mouse.screenpos
			)
		)
		
		on dnc_distributionSources mouseUp arg do 
		(
			updateControlVisibility()
			updatePerObjectControls()
		)
		
		on dnc_distributionSources ItemChecked arg do
		(
			local newArray = #()
			for i = 0 to dnc_distributionSources.items.count-1 do
			(
				try(if dnc_distributionSources.items.item[i].checked do append newArray distSources[i+1])catch()
			)
			activeDistSource = newArray
			paramsRollout.updateUI()
			getSourceChannelsList()
			updateChannelsList()
			updateControlVisibility()
			refreshRateValues()
			
		)		
		
		on dnc_availableChannels ItemChecked arg do
		(
			local newArray = #()
			for i = 0 to dnc_availableChannels.items.count-1 do
			(
				try(if dnc_availableChannels.items.item[i].checked do appendIfUnique newArray dnc_availableChannels.items.item[i].Text)catch()
			)
			channelsToSave = newArray
		)
		
		on ddl_selectionMode selected itm do
		(
			local theSel = getListViewSelection dnc_distributionSources
			for i in theSel do
			(
				case geometryMode[i] of
				(
					default: distSourcesSelectionType[i] = #("","VertexSelection","FaceSelection")[itm]
					2: distSourcesSelectionType[i] = 1 
					3: distSourcesSelectionType[i] = #("","VertexSelection")[itm]
				)
			)
			refreshRateValues()	
		)
		
		on ddl_geometryMode selected itm do
		(
			local theSel = getListViewSelection dnc_distributionSources
			for i in theSel do
			(
				geometryMode[i] = #("Surface","Volume","Vertices","Edges")[itm]
			)
			refreshRateValues()		
			updatePerObjectControls()				
		)

		
		
		on pck_pickObjects picked obj do 
		(
			if obj != undefined do
			(
				local theType = (ReflowGlobal.GetSourceType obj )
				if theType != #invalid do
				(
					if classof obj == PF_Source do
					(
						local PossibleParticleGroups = for o in refs.dependents obj where classof o == ParticleGroup AND isProperty o #name collect o
						if PossibleParticleGroups.count > 0 do obj = PossibleParticleGroups[1] 
					)					
					append distSources obj
					append activeDistSource obj
					append distRates perObjectRate
					append distSourcesSelectionType ""
					
					if theType == #geometry then
					(
						append distJitterRadius 0.0
						local theBBox = obj.max-obj.min
						local theMaxSize = amax #(theBBox.x, theBBox.y, theBBox.z)
						append distVolumeSpacing (theMaxSize/50.0)						
					)
					else
					(
						append distJitterRadius 0.0
						append distVolumeSpacing 1.0
					)

					updateObjectsList()
					getSourceChannelsList()
					updateChannelsList()
				)
			)
		)
		
		on btn_addByName pressed do
		(
			theNodes = selectByName filter:filterPRTObjects multiple:true
			if theNodes != undefined do
			(
				for obj in theNodes do 
				(
					local theType = (ReflowGlobal.GetSourceType obj)
					if theType != #invalid do
					(
						if classof obj == PF_Source do
						(
							local PossibleParticleGroups = for o in refs.dependents obj where classof o == ParticleGroup AND isProperty o #name collect o
							if PossibleParticleGroups.count > 0 do obj = PossibleParticleGroups[1] 
						)						
						append distSources obj
						append activeDistSource obj
						append distRates perObjectRate
						append distSourcesSelectionType ""
						if theType == #geometry then
							append distJitterRadius 0.0
						else
							append distJitterRadius perObjectJitter					

						local theBBox = obj.max-obj.min
						local theMaxSize = amax #(theBBox.x, theBBox.y, theBBox.z)
						append distVolumeSpacing (theMaxSize/50.0)
					)
				)
				updateObjectsList()
				getSourceChannelsList()
				updateChannelsList()
			)
		)
		
		on btn_removeSelectedSources pressed do
		(
			local theSel = getListViewSelection dnc_distributionSources
			if theSel.count > 0 do
			(
				deleteItem distSources theSel[1]
				deleteItem distRates theSel[1]
				deleteItem distSourcesSelectionType theSel[1]
				deleteItem distJitterRadius theSel[1]
				deleteItem distVolumeSpacing theSel[1]
				
				updateObjectsList()
				getSourceChannelsList()
				updateChannelsList()
				paramsRollout.updateUI()
			)
		)	
		
		on rad_distributionMode changed state do updateUI()
		
		fn updateObjectsListAnimation =
		(
			refreshRateValues()
		)

		
		on paramsDistributionRollout open do 
		(
			updateUI()
			getUIColors()
			initDistListView()
			updateObjectsList()
			
			initChannelsListView()
			updateChannelsList()
			
			updatePerObjectControls()
			
			registerTimeCallback updateObjectsListAnimation
		)
		
		on paramsDistributionRollout close do
		(
			unregisterTimeCallback updateObjectsListAnimation
		)
	)	

	
	rollout paramsVelocityFieldRollout "Velocity Field"
	(
		fn filterSources obj = findItem VelocitySources obj == 0 and findItem #(PF_Source,KrakatoaPRTLoader,PRT_Hair,PushSpaceWarp,Vortex,Motor,Drag,PBomb,Path_Follow,Gravity,Wind, Spacedisplace,SIMEmber,FumeFX,Stoke, Spray, Snow, SuperSpray, Blizzard, PArray, PCloud, Thinking) (classof obj.baseobject) > 0 and obj != selection[1]
			pickbutton pck_pickObjects "Pick..." width:45 align:#left across:3 offset:[-12,-5] height:18 filter:filterSources tooltip:"Pick a Velocity Field Source from the scene.\n\nValid objects are Max Force SpaceWarps, FumeFX Simulations and SIM Ember objects."
			button btn_addByName "By Name..." width:62 align:#center offset:[-2,-5] height:18 tooltip:"Pick Velocity Field Source by name from a list."
			button btn_removeSelectedSources "Remove" width:50 align:#right offset:[12,-5] height:18 tooltip:"Remove the highlighted object from the list."

			dotNetControl dnc_VelocitySources "ListView" width:158 align:#center height:120 offset:[0,-4]			
			
			spinner spn_VelocityScale "Velocity Scale:" range:[0,10000,1.0] fieldwidth:50 enabled:true across:2 offset:[60,-2] tooltip:"Scale the Velocity before applying it to the simulation.\n\nA value of 1.0 will use the Velocity as read from the source object."
			button btn_VelocityScale_Preset ">" width:18 height:16 align:#right offset:[10,-2] enabled:true images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Scale the Velocity before applying it to the simulation.\n\nA value of 1.0 will use the Velocity as read from the source object."

		group "Velocity From Particles" 	(
			--checkbox chk_useGridSize "" across:3 enabled:false align:#left offset:[0,-2] visible:false
			spinner spn_gridSize "Grid Spacing:" range:[1.0,10000.0,10.0] fieldWidth:45 enabled:true offset:[55,-2] across:2 type:#worldunits tooltip:"Set the Voxel Size in the Grid used to convert particle velocities to a Velocity Field.\n\nThe Grid dimensions will be set adaptively based on the bounding box of the particle system."
			button btn_gridSize_Preset ">" width:18 height:16 align:#right offset:[5,-2] enabled:true images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Set the Voxel Size in the Grid used to convert particle velocities to a Velocity Field.\n\nThe Grid dimensions will be set adaptively based on the bounding box of the particle system."

			spinner spn_gridPadding "Grid Padding:" range:[1,100,5] fieldWidth:45 enabled:true offset:[55,-3] across:2 type:#integer tooltip:"Set the Number of Voxels to add to each side of the Adaptive Grid used to convert particle Velocities to a Velocity Field."
			button btn_gridPadding_Preset ">" width:18 height:16 align:#right offset:[5,-3] enabled:true images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Set the Number of Voxels to add to each side of the Adaptive Grid used to convert particle Velocities to a Velocity Field."
			
			checkbox chk_fluidMotion "Create Fluid Motion" offset:[-5,-3]
		)
		
		local dn_velocity_bg, dn_velocity_fg
		fn getUIColors =
		(
			local maxBgColor = (((colorman.getcolor #window)) as color)*255
			if maxBgColor.v >= 160 then
			(
				dn_velocity_bg = (dotNetClass "System.Drawing.Color").fromARGB 220 220 230 
				dn_velocity_fg  = (dotNetClass "System.Drawing.Color").fromARGB 0 0 0
			)
			else
			(
				dn_velocity_bg = (dotNetClass "System.Drawing.Color").fromARGB 70 70 80 
				dn_velocity_fg  = (dotNetClass "System.Drawing.Color").fromARGB 255 255 255
			)			
		)
		
		
		fn initDistListView =
		(
			getUIColors()
			layout_def = #( #("Velocity Source",105), #("Scale",47))
			lv = dnc_VelocitySources
			lv.Clear()
			lv.backColor = dn_velocity_bg
			lv.View = (dotNetClass "System.Windows.Forms.View").Details
			lv.gridLines = true 
			lv.fullRowSelect = true
			lv.checkboxes = true
			lv.hideSelection = false
			lv.ShowItemToolTips = true			
			lv.multiSelect = false
			for i in layout_def do lv.Columns.add i[1] i[2]
		)			
		
		fn updateVelocityList =
		(
			try(
				local theSel = getListViewSelection dnc_VelocitySources
				local lv = dnc_VelocitySources
				lv.items.Clear()
				local theRange = #()
				for i = 1 to VelocitySources.count do
				(
					local theObj = VelocitySources[i]
					local theName = (if isValidNode theObj then theObj.name else "<Deleted>")
					local li = dotNetObject "System.Windows.Forms.ListViewItem" theName
					local theTooltipText = theName + "\n"
					theTooltipText += "Scale: " + (velocityScales[i] as string)+"\n\n"
					local thePropNames = case classof theObj.baseobject of
					(				
						SimEmber: #(#Spacing, #VelocitySpacing, #ViewSpacing, #TimeResolution, #Discretize, #VelocitySolver, #BoundsType, #BoundsMin, #BoundsMax, #StartTime)
						FumeFX: #(#GridSpacing, #Width, #Length, #Height, #velocityScale, #StartFrame, #EndFrame, #PlayFrom, #Playto, #Offset)
						Thinking: #()
						default: if isValidNode theObj then getPropNames theObj.baseobject else #()
					)
					for p in thePropNames do
					(
						theTooltipText += p as string + ": " + (getProperty theObj.baseobject p) as string + "\n"
					)
					li.tooltiptext = theTooltipText
					li.checked = findItem activeVelocitySources theObj > 0 and isValidNode theObj 
					li.forecolor = dn_velocity_fg
					local subLi = li.SubItems.add (velocityScales[i] as string)
					append theRange li
				)
				lv.Items.AddRange theRange 			
				setListViewSelection dnc_VelocitySources theSel						
			)catch()
		)
		
		fn refreshScaleValues =
		(
			for i = 1 to VelocitySources.count do
			(
				try(dnc_VelocitySources.items.item[i-1].subItems.Item[1].Text = (velocityScales[i] as string))catch()
			)
		)

		fn updatePerObjectScale =
		(
			local theSel = getListViewSelection dnc_VelocitySources
			for i in theSel do
			(
				velocityScales[i] = velocityScale
			)
			refreshScaleValues()
		)
			
		on spn_VelocityScale changed val do
		(
			updatePerObjectScale()
		)		
		
		on pck_pickObjects picked obj do 
		(
			if obj != undefined do
			(
				if classof obj == PF_Source do
				(
					local PossibleParticleGroups = for o in refs.dependents obj where classof o == ParticleGroup AND isProperty o #name collect o
					if PossibleParticleGroups.count > 0 do obj = PossibleParticleGroups[1] 
				)
				append VelocitySources obj
				append activeVelocitySources obj
				append velocityScales 1.0
				updateVelocityList()
			)
		)
		
		on btn_addByName pressed do
		(
			theNodes = selectByName filter:filterSources multiple:true
			if theNodes != undefined do
			(
				for obj in theNodes do 
				(
					if classof obj == PF_Source do
					(
						local PossibleParticleGroups = for o in refs.dependents obj where classof o == ParticleGroup AND isProperty o #name collect o
						if PossibleParticleGroups.count > 0 do obj = PossibleParticleGroups[1] 
					)
					append VelocitySources obj
					append activeVelocitySources obj
					append velocityScales 1.0
				)
				updateVelocityList()
			)
		)
		
		on btn_removeSelectedSources pressed do
		(
			local theSel = getListViewSelection dnc_VelocitySources
			if theSel.count > 0 do
			(
				--deleteItem VelocitySources theSel[1]
				--deleteItem activeVelocitySources theSel[1]
				
				local theControllers = for i = 1 to velocityScales.count collect
				(
					try( this[("velocityScales_"+ (i-1) as string)].controller ) catch (velocityScales[i])
				)
				local tempArray = for o in VelocitySources collect o
				local tempArray2 = for o in activeVelocitySources collect o
				local tempArray3 = for o in velocityScales collect o
				
				for i = theSel.count to 1 by -1 do
				(
					local theItemToDelete = tempArray[theSel[i]]
					local theIndex = findItem tempArray2 theItemToDelete
					if theIndex > 0 do 
					(
						deleteItem tempArray2 theIndex
						activeVelocitySources = for o in tempArray2 collect o
					)
					deleteItem tempArray theSel[i]
					deleteItem tempArray3 theSel[i]
					deleteItem theControllers theSel[i]
				)
				 for i = 1 to velocityScales.count do
				 (
					 if classof theControllers[i] == Bezier_Float then
						try( this[("velocityScales_"+ (i-1) as string)].controller = theControllers[i]) catch ()
					 else
						try(velocityScales[i] = theControllers[i])catch()
				 )
				VelocitySources = for o in tempArray collect o
				velocityScales = for o in tempArray3 collect o

				updateVelocityList()
				paramsRollout.updateUI()
			)
		)			
		
		on dnc_VelocitySources mouseClick arg do
		(
			local theSel = getListViewSelection dnc_VelocitySources
			if theSel.count > 0 do 
			(
				velocityScale = velocityScales[theSel[1]]
				if arg.Button == arg.Button.Right do
				(
					RCMenuSourceObject = VelocitySources[theSel[1]]
					local theMenu = defineRCMenu()
					popupMenu theMenu pos:mouse.screenpos
				)
			)
		)
		
		on dnc_VelocitySources ItemChecked arg do
		(
			local newArray = #()
			for i = 0 to dnc_VelocitySources.items.count-1 do
			(
				try(if dnc_VelocitySources.items.item[i].checked do append newArray VelocitySources[i+1])catch()
			)
			activeVelocitySources = newArray
			paramsRollout.updateUI()

		)		
		on dnc_VelocitySources mouseUp arg do
		(
			local theSel = getListViewSelection dnc_VelocitySources
			spn_VelocityScale.enabled = theSel.count > 0
		)
				
		
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)			
		
		on btn_VelocityScale_Preset pressed do popupPresetMenu #VelocityScale
		on btn_VelocityScale_Preset rightclick do popupPresetMenu #VelocityScale
			
		on btn_gridSize_Preset pressed do popupPresetMenu #gridSize
		on btn_gridSize_Preset rightclick do popupPresetMenu #gridSize
			
		on btn_gridPadding_Preset pressed do popupPresetMenu #gridPadding
		on btn_gridPadding_Preset rightclick do popupPresetMenu #gridPadding		
			
		fn updateUI =
		(
			local isInCreateMode = getCommandPanelTaskMode() == #create
			pck_pickObjects.enabled = btn_addByName.enabled = btn_removeSelectedSources.enabled = not isInCreateMode			
			spn_VelocityScale.enabled = false
			initDistListView()
			updateVelocityList()		
		)
		
		fn updateObjectsListAnimation =
		(		
			refreshScaleValues()
		)
			
		
		on paramsVelocityFieldRollout open do 
		(
			updateUI()
			registerTimeCallback updateObjectsListAnimation	
		)
		on paramsVelocityFieldRollout close do 
		(
			unregisterTimeCallback updateObjectsListAnimation	
		)		
	)	
	
	rollout paramsTimingRollout "Retiming"
	(
		checkbox chk_UsePlaybackTime "Use Graph" across:3 offset:[-8,-3]
		spinner spn_PlaybackTime "" range:[-1000000,1000000,0] type:#float fieldwidth:50 offset:[38,-2] controller:this.delegate.Playbacktime.controller
		button btn_PlaybackTime_Preset ">" width:18 height:16 align:#right offset:[11,-2] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Set the value of the Playback Graph spinner."
		
		checkbox chk_UsePlaybackInterpolation "Use Playback Interpolation" offset:[-8,-3]
		
		on chk_UsePlaybackTime changed val do this.delegate.UsePlaybackTime = val
		on spn_PlaybackTime changed val do this.delegate.PlaybackTime = val
			
		fn playbackgraph_currentSegment mode =
		(
			try(deleteKeys this.delegate.PlaybackTime.controller #allKeys)catch()
			local theCtrl = this.delegate.PlaybackTime.controller = bezier_float()
			case mode of
			(
				#linear:
				(
					theKey = addNewKey theCtrl animationrange.start
					theKey.value = animationrange.start.frame
					theKey.inTangentType = theKey.outTangentType = #linear
					
					theKey = addNewKey theCtrl animationrange.end
					theKey.value = animationrange.end.frame
					theKey.inTangentType = theKey.outTangentType = #linear
					
					setBeforeORT theCtrl #linear
					setAfterORT theCtrl #linear
				)	
				#accel:
				(
					theKey = addNewKey theCtrl animationrange.start
					theKey.value = animationrange.start.frame
					theKey.inTangentType = theKey.outTangentType = #slow
					
					theKey = addNewKey theCtrl animationrange.end
					theKey.value = animationrange.end.frame
					theKey.inTangentType = theKey.outTangentType = #fast
					
					setBeforeORT theCtrl #linear
					setAfterORT theCtrl #linear
				)
				#decel:
				(
					theKey = addNewKey theCtrl animationrange.start
					theKey.value = animationrange.start.frame
					theKey.inTangentType = theKey.outTangentType = #fast
					
					theKey = addNewKey theCtrl animationrange.end
					theKey.value = animationrange.end.frame
					theKey.inTangentType = theKey.outTangentType = #slow
					
					setBeforeORT theCtrl #linear
					setAfterORT theCtrl #linear
				)		

				#pingpong:
				(
					theKey = addNewKey theCtrl animationrange.start
					theKey.value = animationrange.start.frame
					theKey.inTangentType = theKey.outTangentType = #auto
					
					theKey = addNewKey theCtrl (animationrange.start.frame + ((animationrange.end.frame - animationrange.start.frame)/2))
					theKey.value = animationrange.end.frame
					theKey.inTangentType = theKey.outTangentType = #auto
					
					theKey = addNewKey theCtrl animationrange.end
					theKey.value = animationrange.start.frame
					theKey.inTangentType = theKey.outTangentType = #auto
					
					setBeforeORT theCtrl #linear
					setAfterORT theCtrl #linear
				)	
			)
		)
		
		fn playbackgraph_invertAnimation =
		(
			local theCtrl = try(this.delegate.PlaybackTime.controller)catch(undefined)
			if theCtrl != undefined do
			(
				try(reverseTime theCtrl theCtrl.keys[1].time theCtrl.keys[theCtrl.keys.count].time  #incLeft #incRight)catch()
			)	
		)	
		
		fn playbackgraph_deleteAnimation = 
		(
			local theCtrl = try(this.delegate.PlaybackTime.controller)catch(undefined)
			if theCtrl != undefined do
				try(deleteKeys theCtrl #allKeys)catch()
		)		
			
		fn openPlaybackMenu =
		(
			rcmenu Stoke_PlaybackTime_Presets_RCMenu 
			(
				menuitem mnu_playbackgraph_currentSegment_Linear "Create LINEAR Playback Keys"
				menuitem mnu_playbackgraph_currentSegment_Accelerate "Create ACCELERATION Playback Keys"
				menuitem mnu_playbackgraph_currentSegment_Decelerate "Create DECELERATION Playback Keys"
				menuitem mnu_playbackgraph_currentSegment_PingPong "Create PING-PONG Playback Keys"
				separator sep_10 
				subMenu "Out-Of-Range Types"
				(
					menuitem mnu_playbackgraph_ORT_Before_Constant "Before CONSTANT" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #constant)catch(false))
					menuitem mnu_playbackgraph_ORT_Before_Cycle "Before CYCLE" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #cycle)catch(false))
					menuitem mnu_playbackgraph_ORT_Before_Loop "Before LOOP" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #loop)catch(false))
					menuitem mnu_playbackgraph_ORT_Before_PingPong "Before PING PONG" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #pingpong)catch(false))
					menuitem mnu_playbackgraph_ORT_Before_Linear "Before LINEAR" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #linear)catch(false))
					menuitem mnu_playbackgraph_ORT_Before_Repeat "Before RELATIVE REPEAT" checked:(try(getBeforeORT this.delegate.PlaybackTime.controller == #relativerepeat)catch(false))
					separator sep_100
					menuitem mnu_playbackgraph_ORT_After_Constant "After CONSTANT" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #constant)catch(false))
					menuitem mnu_playbackgraph_ORT_After_Cycle "After CYCLE" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #cycle)catch(false))
					menuitem mnu_playbackgraph_ORT_After_Loop "After LOOP" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #loop)catch(false))
					menuitem mnu_playbackgraph_ORT_After_PingPong "After PING PONG" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #pingpong)catch(false))
					menuitem mnu_playbackgraph_ORT_After_Linear "After LINEAR" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #linear)catch(false))
					menuitem mnu_playbackgraph_ORT_After_Repeat "After RELATIVE REPEAT" checked:(try(getAfterORT this.delegate.PlaybackTime.controller == #relativerepeat)catch(false))
				)
				separator sep_20 
				menuitem mnu_playbackgraph_invertAnimation "INVERT Existing Animation"
				separator sep_30 
				menuitem mnu_playbackgraph_deleteAnimation "DELETE Existing Animation"
				
				on mnu_playbackgraph_ORT_Before_Constant picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #constant)catch()
				on mnu_playbackgraph_ORT_Before_Cycle picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #cycle)catch()
				on mnu_playbackgraph_ORT_Before_Loop picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #loop)catch()
				on mnu_playbackgraph_ORT_Before_PingPong picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #pingpong)catch()
				on mnu_playbackgraph_ORT_Before_Linear picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #linear)catch()
				on mnu_playbackgraph_ORT_Before_Repeat picked do
					try(setBeforeORT this.delegate.PlaybackTime.controller #relativerepeat)catch()
				
				on mnu_playbackgraph_ORT_After_Constant picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #constant)catch()
				on mnu_playbackgraph_ORT_After_Cycle picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #cycle)catch()
				on mnu_playbackgraph_ORT_After_Loop picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #loop)catch()
				on mnu_playbackgraph_ORT_After_PingPong picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #pingpong)catch()
				on mnu_playbackgraph_ORT_After_Linear picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #linear)catch()
				on mnu_playbackgraph_ORT_After_Repeat picked do
					try(setAfterORT this.delegate.PlaybackTime.controller #relativerepeat)catch()				
				
				on mnu_playbackgraph_currentSegment_Linear picked do 
				(
					playbackgraph_currentSegment #linear
				)
				on mnu_playbackgraph_currentSegment_Accelerate picked do
				(
					playbackgraph_currentSegment #accel
				)
				on mnu_playbackgraph_currentSegment_Decelerate picked do
				(
					playbackgraph_currentSegment #decel
				)
				on mnu_playbackgraph_currentSegment_PingPong picked do 
				(
					playbackgraph_currentSegment #pingpong
				)
				
				on mnu_playbackgraph_invertAnimation picked do
				(					
					playbackgraph_invertAnimation()
				)
				on mnu_playbackgraph_deleteAnimation picked do 
				(
					playbackgraph_deleteAnimation()
				)
			)		
			popUpMenu Stoke_PlaybackTime_Presets_RCMenu position:mouse.screenPos	
		)
			
		on btn_PlaybackTime_Preset pressed do openPlaybackMenu()
		on btn_PlaybackTime_Preset rightclick do openPlaybackMenu()
		
		on chk_UsePlaybackInterpolation changed val do this.delegate.UsePlaybackInterpolation = val
			
		on paramsTimingRollout open do
		(
			chk_UsePlaybackTime.state = this.delegate.UsePlaybackTime
			chk_UsePlaybackInterpolation.state = this.delegate.UsePlaybackInterpolation
		)
	)	
	

	rollout paramsDisplayRollout "Viewport Display"
	(
		spinner spn_viewPercentage "Percent:" range:[0,100,100] fieldwidth:45 offset:[60,-3] across:2 tooltip:"Display a fraction of the simulated particles in the viewport."
		button btn_viewPercentage_Preset ">" width:18 height:16 align:#right offset:[10,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Display a fraction of the simulated particles in the viewport."
		
		checkbox chk_viewLimitEnabled "" across:3 align:#left offset:[-10,-4] tooltip:"When checked, the simulated particles will be displayed in the viewport."
		spinner spn_viewLimit "Limit x1000:" range:[1,10000,1000] fieldwidth:45 type:#integer offset:[38,-3] tooltip:"Limit the display to this value multoplied by 1000 to avoid very slow viewport display."
		button btn_viewLimit_Preset ">" width:18 height:16 align:#right offset:[11,-3] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Limit the display to this value multoplied by 1000 to avoid very slow viewport display."

		label lbl_colorSource "Color:" across:2 align:#left offset:[2,3] tooltip:"Set the Color Source"
		dropdownlist ddl_colorSource items:#("Object Color","Color","Velocity","Normal","Tangent") align:#right width:114 offset:[11,-1]

		label lbl_displayVectorSource "Display:" across:2 align:#left offset:[-7,0]
		dropdownlist ddl_displayVectorSource items:#("Large Dots","Velocity") align:#right width:114 offset:[11,-4]
		
		checkbox chk_ViewVectorNormalize "Norm." offset:[-10,-3] across:3 tooltip:"Normalize the Vector channel before displaying it."
		spinner spn_viewVectorScale "Len.:" range:[0,1000,1.0] fieldwidth:45 offset:[38,-2] tooltip:"Scale the Vector channel before displaying it."
		button btn_viewVectorScale_Preset ">" width:18 height:16 align:#right offset:[11,-2] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Scale the Vector channel before displaying it."
		
		
		spinner spn_iconSize "Icon Size:" range:[0.0,10000.0,30.0] fieldwidth:45 across:2 offset:[60,2] tooltip:"Set the size of the STOKE Viewport Icon."
		button btn_iconSize_Preset ">" width:18 height:16 align:#right offset:[10,2] images:#(Stoke_PresetsArrowBitmap,Stoke_PresetsArrowBitmap, 32,1,1,2,2) tooltip:"Set the size of the STOKE Viewport Icon."
		
		
		fn popupPresetMenu type =
		(
			createPresetsRCMenu type:type
			popUpMenu Stoke_Presets_RCMenu position:mouse.screenPos		
		)			
		
		on btn_viewPercentage_Preset pressed do popupPresetMenu #viewPercentage
		on btn_viewPercentage_Preset rightclick do popupPresetMenu #viewPercentage
			
		on btn_viewLimit_Preset pressed do popupPresetMenu #viewLimit
		on btn_viewLimit_Preset rightclick do popupPresetMenu #viewLimit
			
		on btn_iconSize_Preset pressed do popupPresetMenu #iconSize
		on btn_iconSize_Preset rightclick do popupPresetMenu #iconSize
			
		on btn_viewVectorScale_Preset pressed do  popupPresetMenu #viewVectorScale
		on btn_viewVectorScale_Preset rightclick do  popupPresetMenu #viewVectorScale
			
		on ddl_displayVectorSource selected itm do
		(
			this.delegate.ViewportVectorChannel = case of
			(
				1: ""
				default: ddl_displayVectorSource.selected
			)
		)
		on ddl_colorSource selected itm do
		(
			this.delegate.ViewportColorChannel = ddl_colorSource.selected 
		)
		
		fn updateUI =
		(
			theVectors = for aChannel in availableChannels where matchPattern aChannel[2] pattern:"float*[3]" and findItem channelsToSave aChannel[1] > 0 collect aChannel[1]
			ddl_colorSource.items = join #("Color","Velocity") theVectors
			ddl_displayVectorSource.items = join #("Large Dots","Velocity") theVectors
			
			local theIndex = findItem ddl_displayVectorSource.items this.delegate.ViewportVectorChannel
			if theIndex == 0 do theIndex = 1
			ddl_displayVectorSource.selection = theIndex
			
			local theIndex = findItem ddl_colorSource.items this.delegate.ViewportColorChannel
			if theIndex == 0 do theIndex = 1
			ddl_colorSource.selection = theIndex
		)
		
		on paramsDisplayRollout open do
		(
			updateUI()
		)
	)	
	
	
	on create do
	(
		this.delegate.Playbacktime.controller = bezier_float()
	)
	on load do
	(
		if this.delegate.Playbacktime.controller == undefined do 
			this.delegate.Playbacktime.controller = bezier_float()
	)
	
	
	/*on create do
	(
		180K --Time: 26.471 sec.
		.
		1MP - 201.012 sec.  PFLOW FFX FOLLOW - 1:58 = 118 sec.
		1MP - 121.402 sec from PRTV (Time: 28.961 sec. pure sim time)
	
		10MP PFlow 162 sec  
		10 MP Stoke: 274.747 sec.
	
		100 MP PFlow STS: 	Total 00h 30m 50.172s	Called 1 times	 Avg 00h 30m 50.172s
	
		MULTITHREADED STOKE 0.3:
		--Pure sim time, Rate 1,000: STOKE Time: 23.189 sec.
		--Pure sim time, Rate 10,000: STOKE Time: 30.365 sec.
		--Pure sim time, Rate 100,000: PRTFFX STOKE 10 MP 298.645 sec.
	
		
		--Pure sim time, Rate 100,000: 10 MP Stoke: 80.051 sec.
		--Pure sim time, Rate 1,000,000: 100 MP Stoke: 803.802 sec.
	
	)	*/
	
)


macroScript Stoke category:"Thinkbox" tooltip:"Create Stoke Object. Hold SHIFT to create at World Origin." icon:#("stoke",1)
(
	if keyboard.shiftpressed then
	(
		local theObj = Stoke pos:[0,0,0] iconSize:1.0 wirecolor:(color 255 225 125)
		theObj.startTime = animationrange.start
		theObj.endTime = animationrange.end
		select theObj
		max modify mode
	)
	else
	(
		tool StokeCreator
		(
			on mousePoint clickno do
			(
				case clickno of
				(
					1:
					(
						in coordsys grid theObj=Stoke pos:gridPoint wirecolor:(color 255 225 125)
						theObj.startTime = animationrange.start
						theObj.endTime = animationrange.end
						select theObj
						max modify mode
						#stop
					)
				)
			)
		)
		startTool StokeCreator
	)
)