# Sample Draft script:  Layer Extraction
# Extract the layers from a (sequence of) multi-layer exr(s) and save them as separate images.  
# This script assumes that all images in the sequence have the same layers as the first.

import Draft
import sys	# To access commmand line arguments.  Deadline sends script parameters as command line arguments.
from DraftParamParser import *	# Functions to process command line arguments for Draft.

# The argument name/types we're expecting from the command line arguments or Deadline.
expectedTypes = dict()
expectedTypes[ 'inFile' ] = '<string>'
expectedTypes[ 'outFile' ] = '<string>'
#expectedTypes[ 'frameList' ] = '<string>'	# ****** uncomment this line if you want the parameter to be mandatory rather than optional

# Parse the command line arguments.
params = ParseCommandLine( expectedTypes, sys.argv )	# params now contains a dictionary of the parameters initialized to values from the command line arguments.
inFilePattern = params['inFile']	# The pattern that the input files follow, for example frame_name_###.ext, where ### represents a three digit frame number.
outFilePattern = params['outFile']

frames = [ None ]
currFile = None
if 'frameList' in params:
	frames = FrameRangeToFrames( params['frameList'] )	# Get a list of the individual frames we are to process
	currFile = ReplaceFilenameHashesWithNumber( inFilePattern, frames[0] )
else:
	currFile = inFilePattern	# Only one file to process, name same as pattern
frame = Draft.Image.ReadFromFile( currFile )
unprocChannels = frame.GetChannelNames()

# Create a dictionary of layers, with the layer name as the key, and the value is the list of channels.
channelMap = { 'red': 'R', 'green': 'G', 'blue': 'B', 'alpha': 'A', 'r': 'R', 'g': 'G', 'b': 'B', 'a': 'A' }
layers = {}
for uc in unprocChannels:
	if string.rfind( uc, '.' ) >= 0:
		( layer, channel ) = string.rsplit( uc, '.', 1 )
	else:
		( layer, channel ) = ( None, uc )
	if channel.lower() in channelMap:
		if layer in layers:
			layers[ layer ].append( channel )
		else:
			layers[ layer ] = [ channel ]
	else:
		print "Ignoring the following layer.channel: ", uc, " (channel not recognized as RGBA)"

# Process each of the frames in the list of frames (including the first, which hasn't yet been processed).
progressCounter = 0;
for currFrame in frames:
	# Read in the frame.
	if currFrame is not None:
		currFile = ReplaceFilenameHashesWithNumber( inFilePattern, currFrame )
	frame = Draft.Image.ReadFromFile( currFile )
	
	# Extract the layers from the image, saving each as a separate image.
	for ( layer, channels ) in layers.items():
		prefix = ''
		if layer is not None:
			prefix = layer + '.'
		channelList = [ prefix + channel for channel in channels ]
		imgLayer = Draft.Image.CreateImage( frame.width, frame.height, channelList )
		imgLayer.Copy( frame, channels = channelList )
		
		# Rename the channels to RGB(A).
		for channel in channels:
			if prefix + channel != channelMap[ channel.lower() ]:
				imgLayer.RenameChannel( prefix + channel, channelMap[ channel.lower() ] )
		
		# Write the layer as an image, adding the layer name to the filename.
		currOutFile = None
		if currFrame is not None:
			currOutFile = ReplaceFilenameHashesWithNumber( outFilePattern, currFrame )
		else:
			currOutFile = outFilePattern
		if layer is not None:
			if string.rfind( currOutFile, '_' ) >= 0:
				( first, second ) = string.rsplit( currOutFile, '_', 1 )
				currOutFile = first + '_' + layer + '_' + second
			else:
				( root, ext ) = os.path.splitext( currOutFile )
				currOutFile = root + '_' + layer + ext
		imgLayer.WriteToFile( currOutFile )
	
	progressCounter = progressCounter + 1
	progress = progressCounter * 100 / len( frames )
	print( "Progress: %i%%" % progress )