﻿import Draft


imgWidth = 1920
imgHeight = 1080
leftMargin = .25
bottomMargin = .75
textLead = 70.0/1080.0
color1 = Draft.ColorRGBA( 0.953, 0.866, 0.796, 1.0 )
color2 = Draft.ColorRGBA( 0.362, 0.973, 0.549, 1.0 )

# section text
#
annInfo = Draft.AnnotationInfo()

#
# COMMENT -- to test replace the path and/or the typeface to a valid one
#
annInfo.FontType = "/usr/share/fonts/truetype/msttcorefonts/Impact.ttf"
annInfo.PointSize = 60
annInfo.Padding = 0.8
annInfo.Color = color1

slate = Draft.Image.CreateImage( imgWidth, imgHeight )
slate.SetToColor( Draft.ColorRGBA( 0.0, 0.0, 0.0, 1.0 ) )

annotation = Draft.Image.CreateAnnotation( "Section 01", annInfo )
slate.CompositeWithPositionAndAnchor( annotation, leftMargin, bottomMargin, Draft.Anchor.SouthEast, Draft.CompositeOperator.OverCompositeOp )

annInfo.Color = color2
annotation = Draft.Image.CreateAnnotation( "some text [same font size]", annInfo )
slate.CompositeWithPositionAndAnchor( annotation, leftMargin + .02, bottomMargin, Draft.Anchor.SouthWest, Draft.CompositeOperator.OverCompositeOp )

annInfo.Color = color1
annotation = Draft.Image.CreateAnnotation( "Section 02", annInfo )
slate.CompositeWithPositionAndAnchor( annotation, leftMargin, bottomMargin - textLead, Draft.Anchor.SouthEast, Draft.CompositeOperator.OverCompositeOp )

annInfo.PointSize = 40
annInfo.Color = color2
annotation = Draft.Image.CreateAnnotation( "some text [different font size]", annInfo )
slate.CompositeWithPositionAndAnchor( annotation, leftMargin + .02, bottomMargin - textLead, Draft.Anchor.SouthWest, Draft.CompositeOperator.OverCompositeOp )

#
# COMMENT -- to test replace the path to a valid one
#
slate.WriteToFile( "/W/Projects/97_KAMU/70_Out/test.png" )