import re

from System.IO import *
from System.Text import *

from Deadline.Events import *
from Deadline.Scripting import *

######################################################################
## This is the function that Deadline calls to get an instance of the
## main DeadlineEventListener class.
######################################################################
def GetDeadlineEventListener():
	return MyEvent()


def CleanupDeadlineEventListener(eventListener):
    eventListener.Cleanup()

######################################################################
## This is the main DeadlineEventListener class for MyEvent.
######################################################################
class MyEvent (DeadlineEventListener):
	
	def __init__( self ):
		self.OnJobFinishedCallback += self.OnJobFinished


	def Cleanup( self ):
			del self.OnJobFinishedCallback
	
	def OnJobFinished( self, job ):
		
		imageSettings = self.GetConfigEntryWithDefault( "DraftTemplate", "" ).strip()



		# Only submit a QT job for finished Nuke jobs, and only if a QT settings file has been set.
		if job.JobPlugin != "DraftTileAssembler":
			return
			
		outputDirectories = job.JobOutputDirectories
		outputFilenames = job.JobOutputFileNames
		paddingRegex = re.compile("[^\\?#]*([\\?#]+).*")
		
		# Submit a QT job for each output sequence.
		for i in range( 0, len(outputFilenames) ):
			
			outputDirectory = outputDirectories[i]
			outputFilename = outputFilenames[i]
			outputPath = Path.Combine(outputDirectory,outputFilename).replace("//","/")
			
			# Swap out the padding character for an actual frame.
			m = re.match(paddingRegex,outputPath)
			if( m != None):
				padding = m.group(1)
				frame = StringUtils.ToZeroPaddedString(job.JobFramesList[0],len(padding),False)
				outputPath = outputPath.replace( padding, frame )
			
			inputFilename = outputPath
			imageFilename = Path.ChangeExtension( FrameUtils.GetFilenameWithoutPadding( inputFilename ), ".jpg" )
			imageName = Path.GetFileNameWithoutExtension( imageFilename )
			imageFrames = job.JobFrames
			
			# Create job info file.
			jobInfoFilename = Path.Combine( ClientUtils.GetDeadlineTempPath(), "Resize_job_info.job" )
			writer = StreamWriter( jobInfoFilename, False, Encoding.Unicode )
			writer.WriteLine( "Plugin=DraftPlugin" )

			writer.WriteLine( "Name=%s" % imageName )
			writer.WriteLine( "Comment=Auto-submitted Resize" )
			writer.WriteLine( "Department=%s" % job.JobDepartment )
			writer.WriteLine( "Pool=%s" % job.JobPool )
			writer.WriteLine( "Group=%s" % job.JobGroup )
			writer.WriteLine( "Priority=%s" % job.JobPriority )
			writer.WriteLine( "MachineLimit=1" )
			writer.WriteLine( "Frames=%s" % imageFrames )
			writer.WriteLine( "ChunkSize=100000" )
			writer.WriteLine( "OutputFilename0=%s" % imageFilename )
			#writer.WriteLine( "JobDependency0=%s" % job.JobDependency)



			writer.Close()
			
			# Create plugin info file.
			pluginInfoFilename = Path.Combine( ClientUtils.GetDeadlineTempPath(), "Resize_plugin_info.job" )
			writer = StreamWriter( pluginInfoFilename, False, Encoding.Unicode )

			writer.WriteLine( 'ScriptArg0=resolution="1"' )
			writer.WriteLine( 'ScriptArg1=codec="jpeg"' )
			writer.WriteLine( 'ScriptArg10=quickType="createImages"' )
			writer.WriteLine( 'ScriptArg11=isDistributed="False"' )
			writer.WriteLine( 'ScriptArg12=frameList="0"' )
			writer.WriteLine( 'ScriptArg12=batchmode="true"' )
			writer.WriteLine( 'ScriptArg13=SubmitQuickDraft="False"' )
			writer.WriteLine( 'ScriptArg2=colorSpaceIn="Identity"' )
			writer.WriteLine( 'ScriptArg3=colorSpaceOut="Identity"' )
			writer.WriteLine( 'ScriptArg4=DraftExtension="jpg' )
			writer.WriteLine( 'ScriptArg5=annotationsImageString="None"' )
			writer.WriteLine( 'ScriptArg6=annotationsResWidthString="None"' )
			writer.WriteLine( 'ScriptArg7=annotationsResWidthString="None"' )
			writer.WriteLine( 'ScriptArg8=annotationsFramePaddingSize="None"' )
			writer.WriteLine( 'ScriptArg9=quality="85"' )
			writer.WriteLine( 'scriptFile=\\\\wks15\\repo\\events/DraftEventPlugin/DraftQuickSubmission\\QuickDraft.py' )




			#ExtraInfoKeyValue0=DraftFrameRate=24
			#ExtraInfoKeyValue1=DraftColorSpaceIn=Identity
			#ExtraInfoKeyValue2=DraftExtension=jpg
			#ExtraInfoKeyValue3=DraftCodec=jpeg
			#ExtraInfoKeyValue4=DraftQuality=85
			#ExtraInfoKeyValue5=DraftType=image
			#ExtraInfoKeyValue6=DraftColorSpaceOut=Identity
			#ExtraInfoKeyValue7=DraftResolution=1
			#ExtraInfoKeyValue8=SubmitQuickDraft=True
 

			#writer.WriteLine( "InputImages=%s" % inputFilename )
			#writer.WriteLine( "OutputFile=%s" % imageFilename )



			writer.Close()
			
			# Now submit the job.
			ClientUtils.ExecuteCommand( (jobInfoFilename,pluginInfoFilename,imageSettings) )

