import re

from System.IO import *
from System.Text import *

from Deadline.Events import *
from Deadline.Scripting import *

######################################################################
## This is the function that Deadline calls to get an instance of the
## main DeadlineEventListener class.
######################################################################
def GetDeadlineEventListener():
	return MyEvent()


def CleanupDeadlineEventListener(eventListener):
    eventListener.Cleanup()

######################################################################
## This is the main DeadlineEventListener class for MyEvent.
######################################################################
class MyEvent (DeadlineEventListener):
	
	def __init__( self ):
		self.OnJobFinishedCallback += self.OnJobFinished


	def Cleanup( self ):
			del self.OnJobFinishedCallback
	
	def OnJobFinished( self, job ):
		
		imageSettings = self.GetConfigEntryWithDefault( "DraftTemplate", "" ).strip()
		
		# Only submit a QT job for finished Nuke jobs, and only if a QT settings file has been set.
		if job.JobPlugin != "DraftTileAssembler":
			return
			
		outputDirectories = job.JobOutputDirectories
		outputFilenames = job.JobOutputFileNames
		paddingRegex = re.compile("[^\\?#]*([\\?#]+).*")
		
		# Submit a QT job for each output sequence.
		for i in range( 0, len(outputFilenames) ):
			
			outputDirectory = outputDirectories[i]
			outputFilename = outputFilenames[i]
			outputPath = Path.Combine(outputDirectory,outputFilename).replace("//","/")
			
			# Swap out the padding character for an actual frame.
			m = re.match(paddingRegex,outputPath)
			if( m != None):
				padding = m.group(1)
				frame = StringUtils.ToZeroPaddedString(job.JobFramesList[0],len(padding),False)
				outputPath = outputPath.replace( padding, frame )
			
			inputFilename = outputPath
			imageFilename = Path.ChangeExtension( FrameUtils.GetFilenameWithoutPadding( inputFilename ), ".jpg" )
			imageName = Path.GetFileNameWithoutExtension( imageFilename )
			imageFrames = job.JobFrames
			
			# Create job info file.
			jobInfoFilename = Path.Combine( ClientUtils.GetDeadlineTempPath(), "pikcellsResize_job_info.job" )
			writer = StreamWriter( jobInfoFilename, False, Encoding.Unicode )
			writer.WriteLine( "Plugin=DraftPlugin" )

			writer.WriteLine( "Name=%s" % imageName )
			writer.WriteLine( "Comment=Auto-submitted Resize" )
			writer.WriteLine( "Department=%s" % job.JobDepartment )
			writer.WriteLine( "Pool=%s" % job.JobPool )
			writer.WriteLine( "Group=%s" % job.JobGroup )
			writer.WriteLine( "Priority=%s" % job.JobPriority )
			writer.WriteLine( "MachineLimit=1" )
			writer.WriteLine( "Frames=%s" % imageFrames )
			writer.WriteLine( "ChunkSize=100000" )
			#writer.WriteLine( "OutputFilename0=%s" % imageFilename )
			#writer.WriteLine( "ExtraInfoKeyValue0=codec=jpeg" )
			#writer.WriteLine( "ExtraInfoKeyValue1=DraftType=image" )
			#writer.WriteLine( "ExtraInfoKeyValue2=resolution=1" )
			#writer.WriteLine( "ExtraInfoKeyValue3=quality=85" )








			writer.Close()
			
			# Create plugin info file.
			pluginInfoFilename = Path.Combine( ClientUtils.GetDeadlineTempPath(), "pikcellsResize_plugin_info.job" )
			writer = StreamWriter( pluginInfoFilename, False, Encoding.Unicode )
			writer.WriteLine( "InputImages=%s" % inputFilename )
			writer.WriteLine( "OutputFile=%s" % imageFilename )

			#writer.WriteLine( "ScriptArg1=codec=jpeg" )
			#writer.WriteLine( "ExtraInfoKeyValue8=SubmitQuickDraft=True" )
			#writer.WriteLine( "ScriptArg4=quality=85" )
			#writer.WriteLine( "ScriptArg4=quality=85" )




			#writer.WriteLine( "scriptFile='\\wks15\repo\events\DraftEventPlugin\DraftQuickSubmission\QuickDraft.py'" )




			writer.Close()
			
			# Now submit the job.
			ClientUtils.ExecuteCommand( (jobInfoFilename,pluginInfoFilename,imageSettings, ExtraInfoKeyValue0=codec=jpeg ) )

