import os
import sys
import subprocess

def CallDeadlineCommand( arguments, background=True, readStdout=True ):
    # On OSX, we look for the DEADLINE_PATH file. On other platforms, we use the environment variable.
    if os.path.exists( "/Users/Shared/Thinkbox/DEADLINE_PATH" ):
        with file( "/Users/Shared/Thinkbox/DEADLINE_PATH" ) as f: deadlineBin = f.read().strip()
        deadlineCommand = os.path.join( deadlineBin, "deadlinecommand" )
    else:
        deadlineBin = os.environ['DEADLINE_PATH']
        if os.name == 'nt':
            deadlineCommand = os.path.join( deadlineBin, "deadlinecommand.exe" )
        else:
            deadlineCommand = os.path.join( deadlineBin, "deadlinecommand" )

    startupinfo = None
    if background and os.name == 'nt':
        # Python 2.6 has subprocess.STARTF_USESHOWWINDOW, and Python 2.7 has subprocess._subprocess.STARTF_USESHOWWINDOW, so check for both.
        if hasattr( subprocess, '_subprocess' ) and hasattr( subprocess._subprocess, 'STARTF_USESHOWWINDOW' ):
            startupinfo = subprocess.STARTUPINFO()
            startupinfo.dwFlags |= subprocess._subprocess.STARTF_USESHOWWINDOW
        elif hasattr( subprocess, 'STARTF_USESHOWWINDOW' ):
            startupinfo = subprocess.STARTUPINFO()
            startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
    
    arguments.insert( 0, deadlineCommand)
    
    stdoutPipe = None
    if readStdout:
        stdoutPipe=subprocess.PIPE
        
    # Specifying PIPE for all handles to workaround a Python bug on Windows. The unused handles are then closed immediatley afterwards.
    proc = subprocess.Popen(arguments, cwd=deadlineBin, stdin=subprocess.PIPE, stdout=stdoutPipe, stderr=subprocess.PIPE, startupinfo=startupinfo)
    proc.stdin.close()
    proc.stderr.close()

    output = ""
    if readStdout:
        output = proc.stdout.read()
    return output

def submitSoftImageScriptJob( script, mainFunction, args  ):
    jobInfoFile = os.path.join(tempDir, "SoftImageScriptJobInfo.job")
    fileHandle = open( jobInfoFile, "w" )
    try:
        fileHandle.write( "Plugin=SoftImage\n" )
        fileHandle.write( "Name=%s [Script Job]\n" % os.path.basename(script) )
        fileHandle.write( "Frames=1\n" )
        fileHandle.write( "ChunkSize=1\n" ) 
        
    finally:
        fileHandle.close()
    
    pluginInfo = os.path.join(tempDir, "SoftImageScriptPluginInfo.job")
    fileHandle = open( pluginInfo, "w" )
    try:
        fileHandle.write( "Version=12\n" )#insert your version here
        fileHandle.write( "ScriptJob=True\n" )
        fileHandle.write( "ScriptMain=%s\n" % mainFunction )
        for i in range(len(args)):
            if " " in args[i]:
                args[i] = "\""+args[i]+"\""
        fileHandle.write( "ScriptArgs=%s\n" % " ".join(args) )
        
    finally:
        fileHandle.close()
        
    arguments = [jobInfoFile,pluginInfo,script]
    print CallDeadlineCommand( arguments )
    

if __name__ == '__main__':
    
    args = sys.argv
    if len(args) < 2:
        print "Usage python MayaScriptJobSubmitter.py script mainFunction arg1=Val1 arg2=val2 ..."
        quit()
    script = args[1]
    mainFunction = args[2]
    Arguments = args[3:]
    
    homeDir = CallDeadlineCommand( ["-GetCurrentUserHomeDirectory",] ).strip()
    tempDir = os.path.join(homeDir, "temp")
    submitSoftImageScriptJob( script, mainFunction, Arguments )

    
