(
	----------------------------------------------------------------------
	-- KRAKATOA MAGMAFLOW EDITOR
	-- Version 2.0.0
	--
	-- Copyright  2004-2011 Thinkbox Software
	-- All rights reserved.
	----------------------------------------------------------------------
	
	local MagmaFlowEditor_Rollout --holds the local rollout for the editor dialog
	local magma --contains the MagmaHolder to be edited
	local MagmaFlowEditor_isInitializing = false --a flag to notify functions when the editor is being initalized so certain operations can be suspended
	local MagmaFlowEditor_DebugRollout 
	local NodeBitmapsCache = #()
	
	local trackID = (random 10000 10000000) as string + "_" + (random 10000 10000000) as string
	
	--MAGMAFLOW SETTINGS STRUCT - holds all editor settings in a struct. ToDo: Save/Load Presets
	global MagmaFlowSettingsStruct
	struct MagmaFlowSettingsStruct 
	(
		NodeWidth = 120,
		SnapToGrid = true,
		GridSizeX = 10,
		GridSizeY = 10,
		DepotPlacement = #bottomrollupreverse,
		DepotNodeWidth = 80,
		DepotShowBLOPs = true,
		DepotShowCategories = true,
		DepotAutoCollapseOnDragAndDrop = true,
		nodeInsertSocket = 1,
		nodeInsertMode = true,
		AutoReorderToggle = false,
		AutoReorderPattern = #row,
		AllowSocketFlipping = true,
		UnconnectedNodesPlacement = #left,
		AllowSubtreeCollapsing = true,
		AutoZoomExtents = false,
		DebugModeOn = false,
		NodeYSpace = 10,
		NodeXSpace = 10,
		NumEditingBLOPs = 0,
		playbackDuration = 5.0,
		isPickingChannelFromNode = undefined,
		insertNodeIntoFlow = false,
		showTextureMapSample = false,
		showColorSwatchSample = false,
		showInputSocketName = true,
		showInputSocketValue = true,
		DrawShadows = false,
		ElbowSize = 60
	)
	MagmaFlowSettings = MagmaFlowSettingsStruct()
	
	local theIniFileLocation = ""
	
	fn loadDefaultSettings =
	(
		local theIniFile = (theIniFileLocation +"MagmaFlowEditor_Preferences.ini")	
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "DepotNodeWidth" )
		MagmaFlowSettings.DepotNodeWidth = if theVal != OK then theVal else 80
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeWidth")
		MagmaFlowSettings.NodeWidth = if theVal != OK then theVal else 120
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeXSpace" )
		MagmaFlowSettings.NodeXSpace = if theVal != OK then theVal else 20
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeYSpace" )
		MagmaFlowSettings.NodeYSpace = if theVal != OK then theVal else 20
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "GridXSpacing" )
		MagmaFlowSettings.GridSizeX = if theVal != OK then theVal else 10
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "GridYSpacing" )
		MagmaFlowSettings.GridSizeY = if theVal != OK then theVal else 10
			
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "ElbowSize")
		MagmaFlowSettings.ElbowSize = if theVal != OK then theVal else 35		
			
		local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "DrawShadows" )
		MagmaFlowSettings.DrawShadows = theVal == True
	)
	

	MagmaFlowEditor_Functions.loadColorScheme (theIniFileLocation + "MagmaFlowEditor_CurrentColorScheme.ini")
	--local theElbowBitmap = openBitmap (FranticParticles.KrakatoaHome + "\\Icons\\Krakatoa_MagmaFlow_Elbow_Node.png")
	
	local channelsList = #()
	local sortedChannelsList = #()		
	local editorNodeCount = 0
	local NodeCreationMenuPosition = [0,0]
	
	local CurrentIntController = bezier_float()
	local CurrentFloatController = bezier_float()
	local CurrentVectorController = Point3_xyz()
	
	local EditableBlopStack = #()

	local LastUndoRecordNumber = 0
	local UndoRecordNames = #()
	local MagmaFlowEditor_UniqueUndoID = (random 1 100000) as string + "_" + (random 1 100000) as string
	
	local DebugOverlayArray = #()
	
	local theInputSocketNames = #()
	local theOutputSocketNames = #()
	
	local allBlopNames = #()
	local allBlopDescriptions = #()
	
	local theUserFolder = ""
	
	rollout MagmaFlowEditor_DebugRollout "Krakatoa MagmaFlow 2.0 Debugger"
	(
		local resultsArray = #()
		
		spinner spn_first "First:" range:[1,10^9,1] type:#integer fieldwidth:60 across:2 pos:[1,1] scale:1000
		spinner spn_count "Count:" range:[1,10000,1000] type:#integer fieldwidth:60 pos:[120,1] scale:100
		button btn_updateme "UPDATE" width:100 pos:[250,0] height:18
		
		dotNetControl dnc_datalistview "ListView" pos:[0,18]  width:1200 height:400 
			
		fn initDataListView =
		(
			local lv = dnc_datalistview
			local layout_def = #(#("Index",40))
			if resultsArray.count > 0 do
			(
				for i in resultsArray[1] do 
				(
					local theNodeType = magma.getNodeType i[1]
					--format "% %\n" theNodeType  i
					local columnName = (i[1] as string + ":" + theNodeType)
					if theNodeType as name == #InputChannel do columnName += ":"+ magma.getNodeProperty i[1] "channelName"
					local theColumnWidth = 0
					if theNodeType as name == #InputGeometry then
					(
						theColumnWidth = (5+((magma.getNodeProperty i[1] "node") as string).count) * 6
						--print theColumnWidth 
					)
					else
						for k = 2 to i.count do theColumnWidth+= ((i[k] as string).count + ((magma.GetNodeOutputDescription i[1] (k-1)) as string).count + 1 )* 6
					if theColumnWidth < 60 do theColumnWidth = 60
					append layout_def #(columnName, theColumnWidth)
				)
			)
			lv.Clear()
			lv.backColor = (dotNetClass "System.Drawing.Color").fromARGB 221 221 225
			lv.View = (dotNetClass "System.Windows.Forms.View").Details
			lv.gridLines = true 
			lv.fullRowSelect = true 
			lv.MultiSelect = false
			lv.checkboxes = false
			lv.hideSelection = false		
			--showProperties lv
			for i in layout_def do
				lv.Columns.add i[1]  i[2]
		) 		
		
		fn compileFlow =
		(
			local channelsArray = #()
			local channelNames = #()
			resultsArray = #()
			for i = 1 to editorNodeCount do 
			(
				local theID = magma.getNodeID i
				if (magma.getNodeType theID) as name == #InputChannel do
				(
					local theChannelName = magma.getNodeProperty theID "channelName"
					local theVal = 0 --try (magma.GetNodeProperty theID "DebugValue")catch(undefined)
					--if theVal == undefined do 
					if theChannelName != "Index" do --don't add Index channel to the list!
					(
						local theChannels = MagmaFlowEditor_Functions.loadChannelsList()
						local theChannelNames = for j in theChannels collect j[1]
						local theIndex = findItem theChannelNames theChannelName
						if theIndex > 0 then
						(
							--format "theChannels = %\n" theChannels[theIndex]
							theVal = case theChannels[theIndex][3] of
							(
								1: (if matchPattern theChannels[theIndex][2] pattern:"int*" then 0 else 0.0)
								2: [0,0]
								default: [0,0,0] 
								4: [0,0,0,1]
							)
						)
						--magma.DeclareExtensionProperty theID "DebugValue"
						--magma.SetNodeProperty theID "DebugValue" theVal
						append channelsArray #(theChannelName, theVal)
						append channelNames theChannelName
					)--end if index
				)--end if channel
			)--end i loop
			local PRTObject = (refs.dependentNodes magma)[1]
			if isValidNode PRTObject do
			(
				local oldStates = for m in PRTObject.modifiers collect m.enabled
				local theModIndex = 0
				for i = 1 to PRTObject.modifiers.count where classof PRTObject.modifiers[i] == MagmaModifier and PRTObject.modifiers[i].MagmaHolder == magma do theModIndex = i
				for i = 1 to theModIndex do PRTObject.modifiers[i].enabled = false
				--for m in PRTObject.modifiers where classof m == MagmaModifier do m.enabled	= false
				classof PRTObject
				local currentStream = FranticParticles.GetPRTObjectIStream PRTObject
				if currentStream != undefined do
				(
					local theCount = currentStream.getCount()
					if theCount == undefined do theCount = spn_count.value
					theCount = amin #(theCount, spn_count.value)
					
					local theStreamChannels = currentStream.getChannels()
					local resultArray = #()
					theParticleRecord = #()
					currentStream.skipParticles (spn_first.value-1)
					for aParticle = 1 to theCount while theParticleRecord != undefined do
					(
						theParticleRecord = currentStream.readParticle()
						if theParticleRecord != undefined do
						(
							for c = 1 to theStreamChannels.count do
							(
								local theIndex = findItem channelNames theStreamChannels[c][1]
								if theIndex > 0 then 
									channelsArray[theIndex][2] = theParticleRecord[c]
								else
								(
									append channelNames theStreamChannels[c][1]
									append channelsArray #(theStreamChannels[c][1], theParticleRecord[c])
								)
							)
							--format "channelsArray = %\n" channelsArray 
							local result = try(magma.CompileAndExecute channelsArray aParticle true)catch(for i = 1 to editorNodeCount collect #(magma.getNodeId i, getCurrentException()  ))
							append resultsArray result
						)
					)
					currentStream.close()
				)
				for m = 1 to PRTObject.modifiers.count do PRTObject.modifiers[m].enabled = oldStates[m]
			)
			resultsArray
		)
		
		fn populateDataListView =
		(
			local lv = dnc_datalistview
			local theRange = #()
			lv.Update()
			lv.SuspendLayout()
			local cnt = spn_first.value-1
			for i = 1 to resultsArray.count do
			(
				local li = dotNetObject "System.Windows.Forms.ListViewItem" ((cnt+i) as string) 
				for j in resultsArray[i] do
				(
					local theNodeType = magma.getNodeType j[1]
					if theNodeType as name == #InputGeometry then
					(
						txt = "Geometry:"+((magma.getNodeProperty j[1] "nodes") as string)
					)
					else if theNodeType as name == #InputParticles then
					(
						txt = "Particles:"+((magma.getNodeProperty j[1] "nodes") as string)
					)
					else if theNodeType as name == #InputObject then
					(
						txt = "Object:"+((magma.getNodeProperty j[1] "objects") as string)
					)
					else
					(
						local txt = ""
						if j.count > 2 then
							for k = 2 to j.count do
							(
								local theOutputName = (magma.GetNodeOutputDescription j[1] (k-1)) --if j.count > 2 then (magma.GetNodeOutputDescription j[1] (k-1)) + ":" else ""
								txt += theOutputName +":"+(j[k] as string)  + "  "
							)
						else
							txt = (j[2] as string)
					)
					local subLi = li.SubItems.add txt
				)
				append theRange li
			)
			lv.Items.AddRange theRange 
			lv.ResumeLayout false
		)
		
		fn resizeDialog size =
		(
			dnc_datalistview.pos = [0,18]
			dnc_datalistview.width = size.x
			dnc_datalistview.height = size.y-18
		)
			
		on dnc_datalistview ColumnClick args do
		(
			if args.column > 0 do
			(
				theID = resultsArray[1][args.column][1]
				for i = 1 to magma.getNumNodes() where magma.getNodeID i == theID do 
				(
					MagmaFlowEditor_Rollout.setSelectedNodes #(i)
					MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
					MagmaFlowEditor_Rollout.UpdateNavigator()
				)
			)
		)		
		
		on dnc_datalistview ItemSelectionChanged args do
		( 
			if dnc_datalistview.items.item[args.item.index].selected then 
				DebugOverlayArray = ResultsArray[args.item.index+1]
			else
				DebugOverlayArray = #()
		)
		
		
		on MagmaFlowEditor_DebugRollout resized size do
		(
			resizeDialog size
		)
		
		on MagmaFlowEditor_DebugRollout close do
		(
			MagmaFlowSettings.DebugModeOn = false
		)
		
		fn updateDialog =
		(
			compileFlow()
			initDataListView()
			populateDataListView()
		)
		
		on btn_updateme pressed do updateDialog()
		
		on spn_first changed val do
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")	
			setIniSetting theIniFile "Debugger" "First" (val as string)
			updateDialog()
		)
		on spn_count changed val do
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")	
			setIniSetting theIniFile "Debugger" "Count" (val as string)
			updateDialog()
		)		
		
		on MagmaFlowEditor_DebugRollout open do
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")	
			theVal = execute (getIniSetting theIniFile "Debugger" "First" )
			if theVal == OK do theVal = 1
			spn_first.value = theVal
			theVal = execute (getIniSetting theIniFile "Debugger" "Count" )
			if theVal == OK do theVal = 100
			spn_count.value = theVal
			
			compileFlow()
			initDataListView()
			populateDataListView()
			local theNodesString = ""
			local theNodes = refs.dependentNodes magma
			for i = 1 to theNodes.count do 
			(
				theNodesString += theNodes[i].name 
				theMods = for j in refs.dependents magma where classof j == MagmaModifier collect j.name
				for j = 1 to theMods.count do
					theNodesString += "." + theMods[1]+" "
				if i < theNodes.count do theNodesString += " | "
			)
			local txt = "KRAKATOA"
			if MagmaFlowEditor_Functions.IsGenome magma do txt = "GENOME"
			txt +=" MagmaFlow - Debugger " + theNodesString
			MagmaFlowEditor_DebugRollout.title = txt 
		)
	)
	
	rollout MagmaFlowEditor_NodeNameRollout "Name and User Notes" category:50
	(
		label lbl_nodeName "Node Name:" align:#left offset:[-10,-5]
		edittext edt_nodeName width:162 offset:[-4,-4] align:#center
		label lbl_userNotes "User Notes:" align:#left offset:[-10,-2]
		edittext edt_userNotes width:162 height:80 offset:[-4,-4] align:#center
		
		on edt_nodeName entered txt do 
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			MagmaFlowEditor_Functions.setUIProperty magma theID "Name" txt
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord ("Change Node Name To [" +txt +"]")
			MagmaFlowEditor_Rollout.exposeControlsToModifier()
		)		

		on edt_userNotes entered txt do 
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			MagmaFlowEditor_Functions.setUIProperty magma theID "Notes" txt
			
			MagmaFlowEditor_Rollout.createUndoRecord ("Edited User Notes.")
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.exposeControlsToModifier()
		)		
		
		fn RolloutOpen =
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local txt = MagmaFlowEditor_Functions.getNodeName magma theID
			if txt == undefined do txt = magma.getNodeType theID
			edt_nodeName.text = txt
			
			local theUserNotes = MagmaFlowEditor_Functions.getUIProperty magma theID "Notes" 
			if theUserNotes == undefined do theUserNotes  = ""
			edt_userNotes.text = theUserNotes
			
		)
		
		on MagmaFlowEditor_NodeNameRollout open do
		(
			RolloutOpen()
		)
		
		on MagmaFlowEditor_NodeNameRollout rolledup state do
		(
			if not MagmaFlowEditor_isInitializing do
			(
				setIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "MagmaEditor" "NodeNameRolloutRolledup" (state as string)
			)
		)
	)		
	
	local MagmaFlowEditor_OptionsRollout
	rcmenu MagmaFlowEditor_OptionsRollout_Menu 
	(
		menuItem mnu_loadDefault "GET Default Value"
		separator sep_10
		menuItem mnu_setCurrentValueAsDefault "SET DEFAULT For New Modifiers To The Current Value"
		separator sep_20
		menuItem mnu_resetToFactoryDefault "RESET DEFAULT For New Modifiers To Factory Default Value"
		on mnu_setCurrentValueAsDefault picked do MagmaFlowEditor_OptionsRollout.setCurrentValueAsDefault()
		on mnu_loadDefault picked do MagmaFlowEditor_OptionsRollout.loadDefault()
		on mnu_resetToFactoryDefault picked do MagmaFlowEditor_OptionsRollout.resetToFactoryDefault()
	)
	
	local MagmaFlowEditor_FilePresetsRollout
	local currentFolder = ""
	local currentPreset = "Custom"
	
	rollout MagmaFlowEditor_FilePresetsRollout "Preset Flows Explorer" category:1000
	(
		local theFoldersList = #()
		local theFilesList = #()

		button btn_exploreFolder "Explore Presets Folder..." width:160 align:#center offset:[0,-4]
		listbox ddl_PresetFolders items:#() width:160 align:#center height:5 offset:[0,-4]
		listbox ddl_currentPreset items:#() width:160 align:#center height:10 offset:[0,-5]
		dropdownlist ddl_formats items:#("Magma 1 (*.KMF)", "Magma 2 (*.MagmaScript)") width:160 align:#center selection:2 offset:[1,-5]

		edittext edt_notes " User Notes:" fieldwidth:160 align:#center height:100 offset:[0,0] labelontop:true
		
		fn updateNotes =
		(
			if ddl_currentPreset.selection == 1 then
			(
				edt_notes.text = magma.note
				edt_notes.readOnly = false
			)
			else 
			(
				local txt = ""
				if ddl_currentPreset.selection > 1 do
				(
					try
					(
						local theFileHandle = openFile theFilesList[ddl_currentPreset.selection]	
						if theFileHandle != undefined then 
						(
							skipToString theFileHandle "magmaNode.note=" 
							if not eof theFileHandle do txt = execute (readLine theFileHandle )
							close theFileHandle 
						)
					)catch()
				)	
				edt_notes.text = txt
				edt_notes.readOnly = true
			)
		)
		
		on edt_notes entered txt do
		(
			if ddl_currentPreset.selection == 1 do
				magma.note = edt_notes.text 
		)
		
		on btn_exploreFolder pressed do
		(
			local thePath = if ddl_PresetFolders.selection == 1 then 
				(theUserFolder + "\\MagmaFlows\\") 
			else
				(theUserFolder + "\\MagmaFlows\\"+theFoldersList[ddl_PresetFolders.selection]+"\\") 
			shellLaunch thePath ""
		)

		fn updateFlowFolders =
		(
			local theDirectories = (getDirectories (theUserFolder+ "\\MagmaFlows\\*"))
			theDirectories = for i in theDirectories collect 
			(
				local theFS = (filterString i "\\")
				local theDir = theFS[theFS.count]
				if matchPattern theDir pattern:"BlackOps" or matchPattern theDir pattern:"Temp" then dontcollect else theDir
			)
			theFoldersList = join #("[MagmaFlows Root Folder]") theDirectories
			ddl_PresetFolders.items = theFoldersList 
			local theIndex = findItem theFoldersList currentFolder
			if theIndex == 0 do theIndex = 1
			ddl_PresetFolders.selection = theIndex
			updateNotes()
		)
		
		fn updateFlowList =
		(
			local theType = if ddl_formats.selection == 2 then ".MagmaScript" else ".KMF"
			local theFiles = if ddl_PresetFolders.selection == 1 then 
				(getFiles (theUserFolder+ "\\MagmaFlows\\*"+theType ) )
			else
				(getFiles (theUserFolder+ "\\MagmaFlows\\"+theFoldersList[ddl_PresetFolders.selection]+"\\*"+theType ) )
			
			theFilesList =  join #("[Custom Flow]") theFiles 
			ddl_currentPreset.items = (for f in theFilesList collect getFileNameFile f)
			local theIndex = findItem ddl_currentPreset.items currentPreset
			if theIndex == 0 do theIndex = 1
			ddl_currentPreset.selection = theIndex	
			updateNotes()
		)
		
		on ddl_PresetFolders selected itm do
		(
			currentFolder = ddl_PresetFolders.selected
			updateFlowList()
			currentPreset =  "Custom"
		)
		
		on ddl_formats selected itm do 
		(
			updateFlowList()
		)
		
		on ddl_currentPreset selected itm do
		(
			updateNotes()
		)
		
		on ddl_currentPreset doubleClicked itm do
		(
			local thePath = theUserFolder+ "\\MagmaFlows\\Temp\\"
			makeDir thePath all:true
			if itm > 1 then
			(
				if currentPreset == "Custom" do 
				(
					local theFileToSave = (thePath + trackID as string +".MagmaScript")
					if theFileToSave != undefined do
					(
						for i = 1 to magma.NumEditingBLOPs() do magma.PopEditableBLOP() --get out to top level
						local theFlowScript = MagmaFlowEditor_Functions.emitMAXScriptCode magma
						local theFileHandle = createFile theFileToSave 
						format "%\n" theFlowScript to:theFileHandle 
						close theFileHandle
						for i in EditableBlopStack do magma.pushEditableBLOP i
					)					
				)
				
				currentPreset = ddl_currentPreset.selected
				currentFolder = ddl_PresetFolders.selected
				
				magma.Reset()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				
				if matchPattern (getFilenameType theFilesList[itm] ) pattern:".KMF" then
				(
					MagmaFlowEditor_Functions.convertKMF magma theFile:theFilesList[itm] 
				)
				else
				(
					::magmaNode = magma
					fileIn theFilesList[itm]					
				)

				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
				--MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
				MagmaFlowEditor_Rollout.createUndoRecord ("Load Preset ["+filenameFromPath theFilesList[itm] +"]")
			)
			else if itm == 1 and doesFileExist (thePath + trackID as string +".MagmaScript") do
			(
				currentPreset =  "Custom"
				magma.Reset()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				::magmaNode = magma
				fileIn (thePath + trackID as string +".MagmaScript")
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
				--MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
				MagmaFlowEditor_Rollout.createUndoRecord "Restore Custom Flow"
			)
		)

		on MagmaFlowEditor_FilePresetsRollout open do
		(
			updateFlowFolders()
			updateFlowList()
			local theIndex = findItem ddl_currentPreset.items currentPreset
			if theIndex == 0 do theIndex = 1
			ddl_currentPreset.selection = theIndex
			local theIndex = findItem ddl_PresetFolders.items currentFolder
			if theIndex == 0 do theIndex = 1
			ddl_PresetFolders.selection = theIndex
			updateNotes()
		)		
	)
	
	
	rollout MagmaFlowEditor_OptionsRollout "Display Options" category:600
	(
		local currentPropertyForMenu = #none
		spinner spn_DepotNodeWidth "Depot Width:" type:#integer fieldwidth:40 scale:10 range:[60,120,80] across:2 align:#right offset:[55,0]
		button btn_DepotNodeWidth ">>" width:20 height:20 align:#right offset:[10,-3]
		
		spinner spn_nodeWidth "Node Width:" type:#integer fieldwidth:40 scale:10 range:[60,300,120] across:2 align:#right offset:[55,0]
		button btn_nodeWidth ">>" width:20 height:20 align:#right offset:[10,-3]
		spinner spn_ElbowSize "Elbow Node Size:" type:#integer fieldwidth:40 scale:5 range:[30,100,35] across:2 align:#right offset:[55,0]
		button btn_ElbowSize ">>" width:20 height:20 align:#right offset:[10,-3]
		
		
		spinner spn_NodeXSpace "Node X Spacing:" type:#integer fieldwidth:40 scale:10 range:[0,100,10] across:2 align:#right offset:[55,0]
		button btn_NodeXSpace ">>" width:20 height:20 align:#right offset:[10,-3]
		spinner spn_NodeYSpace "Node Y Spacing:" type:#integer fieldwidth:40 scale:10 range:[0,100,10] across:2 align:#right offset:[55,0]
		button btn_NodeYSpace ">>" width:20 height:20 align:#right offset:[10,-3]
		spinner spn_GridXSpacing "Grid X Spacing:" type:#integer fieldwidth:40 scale:5 range:[5,50,10] across:2 align:#right offset:[55,0]
		button btn_ridXSpacing ">>" width:20 height:20 align:#right offset:[10,-3]
		spinner spn_GridYSpacing "Grid Y Spacing:" type:#integer fieldwidth:40 scale:5 range:[5,50,10] across:2 align:#right offset:[55,0]
		button btn_GridYSpacing ">>" width:20 height:20 align:#right offset:[10,-3]
		
		checkbox chk_drawShadows "Draw Node Shadows" across:2
		button btn_DrawShadows ">>" width:20 height:20 align:#right offset:[10,-3]

		
		group "Color Scheme"
		(
			button btn_editColorScheme "EDIT..." width:74 align:#left offset:[-5,0] across:2
			button btn_resetColorScheme "RESET..." width:74 offset:[5,0] align:#right
			button btn_saveColorScheme "SAVE..." width:74 align:#left offset:[-5,0] across:2
			button btn_loadColorScheme "LOAD..." width:74 align:#right offset:[5,0] 
		)
		
		fn setCurrentValueAsDefault =
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")
			case currentPropertyForMenu of
			(
				#DepotNodeWidth: setIniSetting theIniFile "ParticleChannelEditor" "DepotNodeWidth" (spn_DepotNodeWidth.value as string)
				#NodeWidth: setIniSetting theIniFile "ParticleChannelEditor" "NodeWidth" (spn_nodeWidth.value as string)
				#NodeXSpace: setIniSetting theIniFile "ParticleChannelEditor" "NodeXSpace" (spn_NodeXSpace.value as string)
				#NodeYSpace: setIniSetting theIniFile "ParticleChannelEditor" "NodeYSpace" (spn_NodeYSpace.value as string)
				#GridXSpacing: setIniSetting theIniFile "ParticleChannelEditor" "GridXSpacing" (spn_GridXSpacing.value as string)
				#GridYSpacing: setIniSetting theIniFile "ParticleChannelEditor" "GridYSpacing" (spn_GridYSpacing.value as string)
				#ElbowSize: setIniSetting theIniFile "ParticleChannelEditor" "ElbowSize" (spn_ElbowSize.value as string) 
				#DrawShadows: setIniSetting theIniFile "ParticleChannelEditor" "DrawShadows" (chk_DrawShadows.state as string) 
			)
		)
		fn loadDefault =
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")
			case currentPropertyForMenu of
			(
				#DepotNodeWidth: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "DepotNodeWidth" )
					MagmaFlowSettings.DepotNodeWidth = spn_DepotNodeWidth.value = if theVal != OK then theVal else 80
				)
				#NodeWidth: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeWidth")
					MagmaFlowSettings.NodeWidth = spn_nodeWidth.value = if theVal != OK then theVal else 120
				)
				#ElbowSize: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "ElbowSize")
					MagmaFlowSettings.ElbowSize = spn_ElbowSize.value = if theVal != OK then theVal else 35
				) 
				
				#NodeXSpace: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeXSpace" )
					MagmaFlowSettings.NodeXSpace = spn_NodeXSpace.value = if theVal != OK then theVal else 20
				)
				#NodeYSpace: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "NodeYSpace" )
					MagmaFlowSettings.NodeYSpace = spn_NodeYSpace.value = if theVal != OK then theVal else 20
				)
				#GridXSpacing: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "GridXSpacing" )
					MagmaFlowSettings.GridSizeX = spn_GridXSpacing.value = if theVal != OK then theVal else 10
				)
				#GridYSpacing: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "GridYSpacing" )
					MagmaFlowSettings.GridSizeY = spn_GridYSpacing.value = if theVal != OK then theVal else 10
				)
				#DrawShadows: 
				(
					local theVal = execute (getIniSetting theIniFile "ParticleChannelEditor" "DrawShadows" )
					MagmaFlowSettings.DrawShadows = chk_DrawShadows.state = theVal == True
				)				
			)		
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
			MagmaFlowEditor_Rollout.showGrid MagmaFlowSettings.SnapToGrid
			MagmaFlowEditor_Rollout.hc.drawShadows = MagmaFlowSettings.DrawShadows
			MagmaFlowEditor_Rollout.createNodeTree init:true			
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
		)
		fn resetToFactoryDefault =
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")
			case currentPropertyForMenu of
			(
				#DepotNodeWidth: setIniSetting theIniFile "ParticleChannelEditor" "DepotNodeWidth" ""
				#NodeWidth: setIniSetting theIniFile "ParticleChannelEditor" "NodeWidth" ""
				#ElbowSize: setIniSetting theIniFile "ParticleChannelEditor" "ElbowSize" ""
				#NodeXSpace: setIniSetting theIniFile "ParticleChannelEditor" "NodeXSpace" ""
				#NodeYSpace: setIniSetting theIniFile "ParticleChannelEditor" "NodeYSpace" ""
				#GridXSpacing: setIniSetting theIniFile "ParticleChannelEditor" "GridXSpacing" ""
				#GridYSpacing: setIniSetting theIniFile "ParticleChannelEditor" "GridYSpacing" ""
				#DrawShadows: setIniSetting theIniFile "ParticleChannelEditor" "DrawShadows" ""
			)		
			loadDefault()
		)
		
		on btn_DepotNodeWidth pressed do
		(
			currentPropertyForMenu = #DepotNodeWidth
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)
		on btn_nodeWidth pressed do
		(
			currentPropertyForMenu = #nodeWidth
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_ElbowSize pressed do
		(
			currentPropertyForMenu = #elbowSize
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_NodeXSpace pressed do
		(
			currentPropertyForMenu = #NodeXSpace
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_NodeYSpace pressed do
		(
			currentPropertyForMenu = #NodeYSpace
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_ridXSpacing pressed do
		(
			currentPropertyForMenu = #GridXSpacing
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_GridYSpacing pressed do
		(
			currentPropertyForMenu = #GridYSpacing
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_DrawShadows pressed do
		(
			currentPropertyForMenu = #DrawShadows
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		
		on btn_DepotNodeWidth rightClick do
		(
			currentPropertyForMenu = #DepotNodeWidth
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)
		on btn_nodeWidth rightClick do
		(
			currentPropertyForMenu = #nodeWidth
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_ElbowSize rightClick do
		(
			currentPropertyForMenu = #elbowSize
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_NodeXSpace rightClick do
		(
			currentPropertyForMenu = #NodeXSpace
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_NodeYSpace rightClick do
		(
			currentPropertyForMenu = #NodeYSpace
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_ridXSpacing rightClick do
		(
			currentPropertyForMenu = #GridXSpacing
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_GridYSpacing rightClick do
		(
			currentPropertyForMenu = #GridYSpacing
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)		
		on btn_DrawShadows rightClick do
		(
			currentPropertyForMenu = #DrawShadows
			popupmenu MagmaFlowEditor_OptionsRollout_Menu pos:mouse.screenpos
		)			
				
		on btn_resetColorScheme pressed do
		(
			if (querybox "Are you sure you want to RESET the\nMagmaFlow Editor's Color Scheme to Factory Defaults?\n\nThis operation CANNOT be undone!\nYou can click [No] and SAVE the Color Scheme first!" title:"Really RESET Colors?") do
			(
				deleteFile (theIniFileLocation + "MagmaFlowEditor_CurrentColorScheme.ini")
				::MagmaFlowColors = ::MagmaFlowColorsStruct()
				MagmaFlowEditor_Rollout.createNodeTree init:true
			)
		)
		on btn_saveColorScheme pressed do
		(
			makeDir (theUserFolder+"\\ColorSchemes\\") all:true
			local theFile = getSaveFileName filename:(theUserFolder+"\\ColorSchemes\\Colors") types:"MagmaFlow Color Scheme (*.MagmaFlowColors)|*.MagmaFlowColors"
			if theFile != undefined do 
			(
				MagmaFlowEditor_Functions.saveColorScheme theFile
			)
		)
		on btn_loadColorScheme pressed do
		(
			makeDir (theUserFolder+"\\ColorSchemes\\") all:true
			local theFile = getOpenFileName filename:(theUserFolder+"\\ColorSchemes\\*.MagmaFlowColors") types:"MagmaFlow Color Scheme (*.MagmaFlowColors)|*.MagmaFlowColors"
			if theFile != undefined do 
			(			
				MagmaFlowEditor_Functions.loadColorScheme theFile
				MagmaFlowEditor_Rollout.createNodeTree init:true
			)
		)		
		on btn_editColorScheme pressed do
		(
			global MagmaFlowEditor_CurrentColorScheme = ::MagmaFlowColors 
			local theRollout = MagmaFlowEditor_Functions.createColorOptionsDialog ::MagmaFlowColors
			createDialog theRollout width:240 modal:true
			if ::MagmaFlowEditor_CurrentColorScheme != undefined do 
			(
				::MagmaFlowColors = ::MagmaFlowEditor_CurrentColorScheme
				MagmaFlowEditor_Functions.saveColorScheme (theIniFileLocation + "MagmaFlowEditor_CurrentColorScheme.ini")
				MagmaFlowEditor_Rollout.showGrid MagmaFlowSettings.SnapToGrid
			)
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)
		on spn_nodeWidth changed val do 
		(
			MagmaFlowSettings.NodeWidth = val
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)
		on spn_elbowSize changed val do 
		(
			MagmaFlowSettings.ElbowSize = val
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)		
		on spn_NodeXSpace changed val do 
		(
			MagmaFlowSettings.NodeXSpace = val
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)
		on spn_NodeYSpace changed val do 
		(
			MagmaFlowSettings.NodeYSpace = val
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)	
		on spn_GridXSpacing changed val do
		(
			MagmaFlowSettings.GridSizeX = val
			MagmaFlowEditor_Rollout.showGrid MagmaFlowSettings.SnapToGrid
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)
		on spn_GridYSpacing changed val do
		(
			MagmaFlowSettings.GridSizeY = val
			MagmaFlowEditor_Rollout.showGrid MagmaFlowSettings.SnapToGrid
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)
		
		on spn_DepotNodeWidth changed val do 
		(
			MagmaFlowSettings.DepotNodeWidth = val
			MagmaFlowEditor_Rollout.createDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)	

		on chk_drawShadows changed state do
		(
			MagmaFlowEditor_Rollout.hc.drawShadows = MagmaFlowSettings.DrawShadows = state
			MagmaFlowEditor_Rollout.hc.redrawView
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings
		)
		
		on MagmaFlowEditor_OptionsRollout open do
		(
			try(btn_nodeWidth.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_ElbowSize.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_NodeXSpace.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_NodeYSpace.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_DepotNodeWidth.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_ridXSpacing.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_GridYSpacing.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			try(btn_DrawShadows.images = #(Krakatoa_PresetsArrowBitmap,Krakatoa_PresetsArrowBitmap, 32,1,1,2,2))catch()
			
			spn_nodeWidth.value = MagmaFlowSettings.NodeWidth
			spn_elbowSize.value = MagmaFlowSettings.ElbowSize
			spn_NodeXSpace.value = MagmaFlowSettings.NodeXSpace
			spn_NodeYSpace.value = MagmaFlowSettings.NodeYSpace
			spn_DepotNodeWidth.value = MagmaFlowSettings.DepotNodeWidth
			spn_GridXSpacing.value  = MagmaFlowSettings.GridSizeX
			spn_GridYSpacing.value  = MagmaFlowSettings.GridSizeY
			chk_DrawShadows.state = MagmaFlowSettings.DrawShadows
				
		)
	)
	
	
	rollout MagmaFlowEditor_CloseEditableBLOP "BLOP" category:60
	(
		button btn_endBLOP "Exit BLOP Editing" width:160 align:#center height:30 offset:[0,-5]
		
		on btn_endBLOP pressed do
		(
			if (magma.NumEditingBLOPs() > 0) do
			(
				magma.PopEditableBLOP()
				deleteItem EditableBlopStack EditableBlopStack.count
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
			)
		)
	)
	
	rollout MagmaFlowEditor_EditableBLOP "BLOP" category:100
	(
		local inputSocketsMap = #()
		button btn_editBLOP "Edit BLOP..." width:160 align:#center height:25 offset:[0,-5]

		button btn_loadBLOP "LOAD BLOP..." width:80  align:#left across:2 height:25 offset:[-10,-3]
		button btn_saveBLOP "SAVE BLOP..." width:80 align:#right height:25 offset:[10,-3]
		
		button btn_exploreBLOPs "Explore BLOP Folder..." width:160 align:#center offset:[0,-3]
		
		label lbl_void01 offset:[0,-22]
		group "Input Sockets:"
		(
			button btn_addInput "Add" across:3 width:50 height:18 align:#left offset:[-7,-3] tooltip:"Add New Input" 
			button btn_addInputSeparator "Separator"  width:55 height:18 align:#center offset:[0,-3] tooltip:"Insert Separator after the selected Input"
			button btn_removeInput "Remove" width:50 height:18 align:#right offset:[7,-3] tooltip:"Remove Input"
			
			listbox lbx_inputs height:6 width:156 align:#center offset:[0,-5]
			edittext edt_inputName fieldwidth:155 align:#center offset:[-3,-6]

			button btn_moveInputUp "Move Up" across:2 width:77 height:18 align:#left offset:[-7,-5] tooltip:"Move Socket Up"
			button btn_moveInputDown "Move Down"  width:77 height:18 align:#right offset:[7,-5] tooltip:"Move Socket Down"
		)
		label lbl_void02 offset:[0,-22]
		group "Output Sockets:"
		(
			button btn_addOutput "Add" across:2 width:77 height:18 align:#left offset:[-7,-3] tooltip:"Add New Output"
			--button btn_addOutputSeparator "Separator"  width:55 height:18 align:#center offset:[0,-3] tooltip:"Insert Separator after the selected Output" enabled:false
			button btn_removeOutput "Remove" width:77 height:18 align:#right offset:[7,-3] tooltip:"Remove Output"
			
			listbox lbx_outputs  height:4 width:156 align:#center offset:[0,-5]
			edittext edt_outputName fieldwidth:155 align:#center offset:[-3,-6]

			button btn_moveOutputUp "Move Up" across:2 width:77 height:18 align:#left offset:[-7,-5] tooltip:"Move Socket Up" 
			button btn_moveOutputDown "Move Down"  width:77 height:18 align:#right offset:[7,-5] tooltip:"Move Socket Down" 
		)
		
		fn updateLists =
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local separatorLocations = magma.getNodeProperty theID "InputSocketSeparators" 
			if separatorLocations == undefined then separatorLocations = #()
			local tempArray = #()
			inputSocketsMap = #()
			for i = 1 to magma.getNumNodeInputs theID do
			(
				local theSocketName = magma.getNodeProperty theID ("BLOPInputSocketName"+i as string)
				if theSocketName == undefined do theSocketName = "Input " + i as string
				append tempArray theSocketName
				append inputSocketsMap i
				if findItem separatorLocations i > 0 do 
				(
					append inputSocketsMap -i
					append tempArray "-------------------------------------"
				)
			)
			lbx_inputs.items = tempArray
			
			lbx_inputs.selection = 1
			edt_inputName.text = if lbx_inputs.selected != undefined then lbx_inputs.selected else ""
			lbx_outputs.items = for i = 1 to magma.getNumNodeOutputs theID collect
			(
				local theSocketName = magma.getNodeProperty theID ("BLOPOutputSocketName" + i as string)
				if theSocketName == undefined do theSocketName = "Output " + i as string
				theSocketName
			)		
			lbx_outputs.selection = 1
			edt_outputName.text = if lbx_outputs.selected != undefined then lbx_outputs.selected else ""
		)
		
		on btn_saveBLOP pressed do
		(
			local theBLOPName = "Definition"
			local theSel = MagmaFlowEditor_Rollout.getSelectedNodes()
			if theSel.count == 1 do 
			(
				local lastID = magma.getNodeID theSel[theSel.count]
				if lastID > -1 do
				(
					local lastName = magma.getNodeProperty lastID "Name"
					if lastName != undefined and lastName  != "" do theBLOPName = lastName
				)
			)
			makeDir (theUserFolder+ "\\BlackOps\\") all:true
			local theFileName = getSaveFileName filename:(theUserFolder+ "\\BlackOps\\"+theBLOPName+".MagmaBLOP") types:"MagmaFlow BLOP (*.MagmaBLOP)|*.MagmaBLOP"
			if theFileName != undefined do
			(
				local theFile = createFile theFileName
				local theString = MagmaFlowEditor_Functions.emitMAXScriptCode magma specificNodes:#(MagmaFlowEditor_Rollout.lastNodeClick) isUndo:false
				format "%\n" theString to:theFile
				close theFile
				MagmaFlowEditor_Rollout.createDepot()
			)
		)
		
		on btn_exploreBLOPs pressed do
		(
			makeDir (theUserFolder+ "\\BlackOps\\") all:true
			shellLaunch (theUserFolder+ "\\BlackOps\\") ""
		)
		
		on btn_loadBLOP pressed do
		(
			makeDir (theUserFolder+ "\\BlackOps\\") all:true
			local theFileName = getOpenFileName filename:(theUserFolder+ "\\BlackOps\\*.MagmaBLOP") types:"Magma 2.x BLOP (*.MagmaBLOP)|*.MagmaBLOP|Magma 1.x BLOP (*.KCB)|*.KCB"
			if theFileName != undefined do
			(
				local oldID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				local oldPos = magma.getNodeProperty oldID "Position"
				local extendedProps = magma.GetExtensionPropertyNames oldID
				local oldPropValues = for i in extendedProps collect magma.getNodeProperty oldID i
				local oldInputs = for i = 1 to magma.getNumNodeInputs oldID collect magma.getNodeInput oldID i
				
				local oldCount = magma.getNumNodes()
				::magmaNode = magma
				
				if matchPattern (getFileNameType theFileName) pattern:".MagmaBLOP" then
				(
					fileIn theFileName
				)
				
				if matchPattern (getFileNameType theFileName) pattern:".KCB" then
				(
					global KrakatoaChannelEditor_BlackOpData
					fileIn theFileName
					local theNodesList = #()
					local theNodeDef = #("BlackOP",#(),#(getFileNameFile theFileName, KrakatoaChannelEditor_BlackOpData),#([0,0]))
					theNodesList[1] = MagmaFlowEditor_Functions.convertKMFBLOP magma theNodesList theNodeDef
					for c = 1 to theNodeDef[2].count where theNodeDef[2][c] != undefined and theNodeDef[2][c] > 0 do
					(
						local connectToNode = theNodesList[theNodeDef[2][c]]
						local OutputConnection = theMagmaHolder.getNodeProperty connectToNode "Internal_OutputSelection"
						if OutputConnection == undefined do OutputConnection = 1
						theMagmaHolder.SetNodeInput theNodesList[i][1] c connectToNode OutputConnection
					)
					MagmaFlowEditor_Functions.connectKMFBLOP magma theNodesList[1] theNodeDef 					
				)					
				
				local newID = magma.getNodeID (magma.getNumNodes())
				magma.replaceNode 	oldID newID 
				magma.setNodeProperty oldID "Position" oldPos
					
				for i = 1 to extendedProps.count where extendedProps[i] != "InputSocketSeparators" and not matchPattern  extendedProps[i] pattern:"BLOPInputSocketName*" do 
				(
					magma.DeclareExtensionProperty oldID extendedProps[i]
					magma.setNodeProperty oldID extendedProps[i] oldPropValues[i] 
				)
				for i = 1 to magma.getNumNodeInputs oldID do
				(
					if oldInputs[i] != undefined do magma.setNodeInput oldID i oldInputs[i][1] oldInputs[i][2]
				)

				magma.declareExtensionProperty oldID "Name" 
				magma.setNodeProperty oldID "Name" (getFileNameFile theFileName)
				
				MagmaFlowEditor_Rollout.createNodeTree init:true
				updateLists()	
				MagmaFlowEditor_NodeNameRollout.RolloutOpen()
			)
		)		
		

		
		on lbx_inputs selected itm do 
		(
			if inputSocketsMap[itm] == -1 then
			(
				edt_inputName.enabled = false
				edt_inputName.text = ""
			)
			else
			(
				edt_inputName.enabled = true
				edt_inputName.text = lbx_inputs.selected
			)
		)
		on lbx_outputs selected itm do edt_outputName.text = lbx_outputs.selected
			
		on edt_inputName entered txt do 
		(
			if lbx_inputs.selection > 0 do
			(
				local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				local theName = ("BLOPInputSocketName" + inputSocketsMap[lbx_inputs.selection] as string)
				magma.declareExtensionProperty theID theName 
				magma.setNodeProperty theID theName txt
				local temp = lbx_inputs.items
				temp[lbx_inputs.selection]=txt
				lbx_inputs.items = temp
				MagmaFlowEditor_Rollout.createNodeTree init:false
			)
		)
		on edt_outputName entered txt do 
		(
			if lbx_outputs.selection > 0 do
			(
				local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				local theName = ("BLOPOutputSocketName" + lbx_outputs.selection as string)
				magma.declareExtensionProperty theID theName 
				magma.setNodeProperty theID theName txt
				local temp = lbx_outputs.items
				temp[lbx_outputs.selection]=txt
				lbx_outputs.items= temp
				MagmaFlowEditor_Rollout.createNodeTree init:false
			)
		)		
		
		on btn_addInput pressed do
		(
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			magma.setNumNodeInputs theID ((magma.getNumNodeInputs theID)+1)
			MagmaFlowEditor_Rollout.createNodeTree init:true
			updateLists()
			lbx_inputs.selection = lbx_inputs.items.count
		)
		
		on btn_addInputSeparator pressed do
		(
			local oldSelection = lbx_inputs.selection
			if inputSocketsMap[lbx_inputs.selection] > 0 do
			(
				local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				local separatorLocations = magma.getNodeProperty theID "InputSocketSeparators" 
				if separatorLocations == undefined then separatorLocations = #()
				if findItem separatorLocations inputSocketsMap[lbx_inputs.selection] == 0 do
				(
					append separatorLocations inputSocketsMap[lbx_inputs.selection]
					magma.declareExtensionProperty theID "InputSocketSeparators"
					magma.setNodeProperty theID "InputSocketSeparators" separatorLocations
					MagmaFlowEditor_Rollout.createNodeTree init:false
					updateLists()
					lbx_inputs.selection = oldSelection+1
				)
			)
		)		
		
		on btn_removeInput pressed do
		(
			local oldSelection = lbx_inputs.selection
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if inputSocketsMap[lbx_inputs.selection] < 0 then
			(
				local separatorLocations = magma.getNodeProperty theID "InputSocketSeparators" 
				deleteItem separatorLocations (findItem separatorLocations (abs inputSocketsMap[lbx_inputs.selection]))
				magma.setNodeProperty theID "InputSocketSeparators" separatorLocations
				MagmaFlowEditor_Rollout.createNodeTree init:false
				updateLists()
				lbx_inputs.selection = oldSelection-1
			)
			else
			(
				local socketToDelete = inputSocketsMap[lbx_inputs.selection]
				local numSockets = magma.getNumNodeInputs theID 
				magma.pushEditableBLOP theID
				for i = 1 to magma.getNumNodes() do
				(
					local theID2 = magma.getNodeID i
					for c = 1 to magma.getNumNodeInputs theID2 do
					(
						local oldWire = magma.getNodeInput theID2 c
						if oldWire[1] == (magma.GetNodeInput (magma.CurrentBLOP) socketToDelete)[1] and oldWire[2] == socketToDelete do
							magma.setNodeInput theID2 c -1 1 --remove wire
						for j = socketToDelete+1 to numSockets do
							if oldWire[1] == (magma.GetNodeInput (magma.CurrentBLOP) j)[1] and oldWire[2] == j do
								magma.setNodeInput theID2 c (magma.GetNodeInput (magma.CurrentBLOP) (j-1))[1] (j-1) --move all others up
					)--end c loop
				)--end i loop
				magma.popEditableBLOP()
				for j = socketToDelete+1 to numSockets do
				(
					local theSocketName = magma.getNodeProperty theID ("BLOPInputSocketName"+j as string)
					if theSocketName != undefined do 
					(
						magma.declareExtensionProperty theID ("BLOPInputSocketName"+(j-1) as string)
						magma.setNodeProperty theID ("BLOPInputSocketName"+(j-1) as string) theSocketName
					)
				)
				magma.setNumNodeInputs theID (numSockets-1)
				MagmaFlowEditor_Rollout.createNodeTree init:true
				updateLists()
				lbx_inputs.selection = lbx_inputs.items.count			
			)
		)
		
		fn moveSeparator theID oldSelection dir:-1 =
		(
			local separatorLocations = magma.getNodeProperty theID "InputSocketSeparators" 
			if (dir == -1 and (abs inputSocketsMap[oldSelection]) > 1) OR (dir == 1 and (abs inputSocketsMap[oldSelection]) < magma.getNumNodeInputs theID ) do 
			(
				deleteItem separatorLocations (findItem separatorLocations (abs inputSocketsMap[oldSelection]))
				append separatorLocations ( (abs inputSocketsMap[oldSelection]) + dir )
				separatorLocations = for j in separatorLocations where j > 0 collect j
				magma.setNodeProperty theID "InputSocketSeparators" (sort separatorLocations)
				MagmaFlowEditor_Rollout.createNodeTree init:false
				updateLists()
				lbx_inputs.selection = oldSelection + dir 
			)
		)
		
		fn moveSocket theID oldSelection dir:-1 =
		(
			local currentSocket = inputSocketsMap[oldSelection]
			local otherSocket = inputSocketsMap[oldSelection+dir]
			local tempName1 = magma.getNodeProperty theID ("BLOPInputSocketName"+currentSocket as string)
			local tempName2 = magma.getNodeProperty theID ("BLOPInputSocketName"+otherSocket as string)
			
			magma.DeclareExtensionProperty theID ("BLOPInputSocketName"+otherSocket as string) 
			magma.setNodeProperty theID ("BLOPInputSocketName"+otherSocket as string) tempName1 
			magma.DeclareExtensionProperty theID ("BLOPInputSocketName"+currentSocket as string) 
			magma.setNodeProperty theID ("BLOPInputSocketName"+currentSocket as string) tempName2

			magma.pushEditableBLOP theID
			for i = 1 to magma.getNumNodes() do
			(
				local theID2 = magma.getNodeID i
				for c = 1 to magma.getNumNodeInputs theID2 do
				(
					local oldWire = magma.getNodeInput theID2 c
					if oldWire[1] == (magma.GetNodeInput (magma.CurrentBLOP) currentSocket)[1] and oldWire[2] == currentSocket then
						magma.setNodeInput theID2 c (magma.GetNodeInput (magma.CurrentBLOP) (otherSocket))[1] (otherSocket) 
					else
						if oldWire[1] == (magma.GetNodeInput (magma.CurrentBLOP) otherSocket)[1] and oldWire[2] == otherSocket then
							magma.setNodeInput theID2 c (magma.GetNodeInput (magma.CurrentBLOP) (currentSocket))[1] (currentSocket) 
				)--end c loop
			)--end i loop
			magma.popEditableBLOP()
			updateLists()
		)
		
		fn moveOutputSocket theID oldSelection dir:-1 =
		(
			local tempName1 = magma.getNodeProperty theID ("BLOPOutputSocketName"+oldSelection as string)
			local tempName2 = magma.getNodeProperty theID ("BLOPOutputSocketName"+(oldSelection+dir) as string)
			--if tempName1 != undefined do
			(
				magma.DeclareExtensionProperty theID ("BLOPOutputSocketName"+(oldSelection+dir) as string) 
				magma.setNodeProperty theID ("BLOPOutputSocketName"+(oldSelection+dir) as string) tempName1 
			)
			--if tempName2 != undefined do
			(
				magma.DeclareExtensionProperty theID ("BLOPOutputSocketName"+oldSelection as string) 
				magma.setNodeProperty theID ("BLOPOutputSocketName"+oldSelection as string) tempName2
			)
			
			magma.pushEditableBLOP theID
			local out1 = magma.getOutput oldSelection
			local out2 = magma.getOutput (oldSelection+dir)
			magma.setOutput (oldSelection+dir) out1[1] out1[2]
			magma.setOutput (oldSelection) out2[1] out2[2]
			magma.popEditableBLOP()
			updateLists()			
		)
		
		on btn_moveInputUp pressed do
		(
			local oldSelection = lbx_inputs.selection
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if inputSocketsMap[lbx_inputs.selection] < 0 then
			(
				moveSeparator theID oldSelection dir:-1
			)
			else
			(
				if lbx_inputs.selection > 1 do
				(
					if inputSocketsMap[oldSelection-1] < 0 then
					(
						moveSeparator theID (oldSelection-1) dir:1
						lbx_inputs.selection = oldSelection-1 
					)
					else
					(
						moveSocket theID oldSelection dir:-1
						lbx_inputs.selection = oldSelection-1 
					)
				)
			)
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		on btn_moveInputDown pressed do
		(
			local oldSelection = lbx_inputs.selection
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if inputSocketsMap[lbx_inputs.selection] < 0 then
			(
				moveSeparator theID oldSelection dir:1
			)			
			else
			(
				if lbx_inputs.selection < lbx_inputs.items.count do
				(
					if inputSocketsMap[oldSelection+1] < 0 then
					(
						moveSeparator theID (oldSelection+1) dir:-1
						lbx_inputs.selection = oldSelection+1 
					)
					else
					(
						moveSocket theID oldSelection dir:1
						lbx_inputs.selection = oldSelection+1 
					)
				)
			)
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)		
		
		on btn_moveOutputUp pressed do
		(
			local oldSelection = lbx_outputs.selection
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if lbx_outputs.selection > 1 do
			(
				moveOutputSocket theID oldSelection dir:-1
				lbx_outputs.selection = oldSelection-1 
				magma.popEditableBLOP()
				MagmaFlowEditor_Rollout.createNodeTree init:false
			)
		)
		on btn_moveOutputDown pressed do
		(
			local oldSelection = lbx_outputs.selection
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if lbx_outputs.selection <  lbx_outputs.items.count do
			(
				moveOutputSocket theID oldSelection dir:1
				lbx_outputs.selection = oldSelection+1 
				magma.popEditableBLOP()
				MagmaFlowEditor_Rollout.createNodeTree init:false
			)
		)	
		
		on btn_addOutput pressed do
		(
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			magma.setNumNodeOutputs theID ((magma.getNumNodeOutputs theID)+1)
			MagmaFlowEditor_Rollout.createNodeTree init:true
			updateLists()
			lbx_outputs.selection = lbx_outputs.items.count
		)		
		
		on btn_removeOutput pressed do
		(
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			magma.setNumNodeOutputs theID ((magma.getNumNodeOutputs theID)-1)
			MagmaFlowEditor_Rollout.createNodeTree init:true
			updateLists()
			lbx_outputs.selection = lbx_outputs.items.count		
		)		

		on btn_editBLOP pressed do
		(
			local theID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			append EditableBlopStack theID
			magma.PushEditableBLOP theID 
			MagmaFlowEditor_Rollout.restorePanAndZoom()
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
			MagmaFlowEditor_Rollout.createUndoRecord ("Edit BLOP [" + theID as string+"]")
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.autoReorderFlow()			
		)
		
		fn RolloutOpen =
		(
			updateLists()
		)
		
		on MagmaFlowEditor_EditableBLOP open do
		(
			RolloutOpen()
		)
	)
	
	
	rollout MagmaFlowEditor_OperatorRollout "Operator" category:100
	(
		dropdownlist ddl_category width:70 align:#left offset:[-12,-3] height:20 across:2
		dropdownlist ddl_type width:94 align:#right offset:[12,-3] height:20 
		
		checkbox chk_enabled "Enable" align:#left offset:[-5,-3] across:2 
		checkbox chk_collapsed "Collapse" offset:[8,-3] align:#right
		--checkbox chk_hideUnconnectedOutputs "Hide Unconnected Outputs" offset:[-5,-3]
		

		fn updateType =
		(
			MagmaFlowEditor_Rollout.createNodeTree init:true
			--KrakatoaChannelNodeEditor_OperatorDescriptionRollout.updateDescription()
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			
			--btn_convertToFloat.visible = ddl_category.selected == "Logic and Comparison" and ddl_type.selected != "Switch"
			setFocus MagmaFlowEditor_Rollout.hc			
		)
		
		fn updateCategories =
		(
			ddl_category.items = MagmaFlowEditor_Rollout.DepotCategories
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			if theID >= 0 do
			(
				local theNodeType = magma.getNodeType theID
				local theNodeCategory = magma.GetNodeTypeCategory theNodeType
				local theIndex = findItem MagmaFlowEditor_Rollout.DepotCategories theNodeCategory
				ddl_category.selection = theIndex
				local theArray = MagmaFlowEditor_Rollout.DepotDefinition[theIndex]
				ddl_type.items = for i = 2 to theArray.count collect theArray[i][2]
				local theIndex2 = findItem ddl_type.items theNodeType
				ddl_type.selection = theIndex2
			)
		)	
		

		on chk_enabled changed state do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.setNodeProperty theID "enabled" (not (magma.getNodeProperty theID "enabled"))
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		
		on chk_collapsed changed state do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.DeclareExtensionProperty theID "Collapsed" 
			local theState = magma.GetNodeProperty theID "Collapsed"  
			if theState == undefined do theState = false
			theState = not theState 			
			magma.setNodeProperty theID "Collapsed" theState
			MagmaFlowEditor_Rollout.collapseBranches()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)		
		
		/*
		on chk_hideUnconnectedOutputs changed state do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.DeclareExtensionProperty theID "HideUnconnectedOutputs" 
			local theState = magma.GetNodeProperty theID "HideUnconnectedOutputs"  
			if theState == undefined do theState = false
			theState = not theState 
			magma.SetNodeProperty theID "HideUnconnectedOutputs" theState 
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		*/	
		
		fn replaceNode =
		(
			if ddl_type.selected != undefined do MagmaFlowEditor_NodeNameRollout.edt_nodeName.text = ddl_type.selected
			local theOldID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			
			local extendedProps = magma.GetExtensionPropertyNames theOldID --#("Name","Position","Internal_Position","Collapsed","Selected","Notes","Exposed")
			if extendedProps == undefined do extendedProps=#()
			local oldPropValues = for i in extendedProps collect magma.getNodeProperty theOldID i
			
			local theOldConnections = for c = 1 to magma.GetNumNodeInputs theOldID collect magma.GetNodeInput theOldID c
			local theOldOutputConnections = magmaFlowEditor_Functions.GetConnectedNodes magma theOldID 
			local theOldSockets = for i = 1 to magma.GetNumNodeInputs theOldID collect #(magma.GetNodeInputDescription theOldID i, magma.getNodeInputDefaultValue theOldID i)
			
			theNewID = magma.CreateNode ddl_type.selected
			magma.ReplaceNode theOldID theNewID
			
			if ddl_type.selected as name == #InputValue do
			(
				local theCtrl = bezier_float(); theCtrl.value = 1.0
				magma.SetNodeProperty theOldID "controller" theCtrl
			)

			for i = 1 to extendedProps.count do 
			(
				if extendedProps[i] != "DefaultsType" do
				(
					magma.DeclareExtensionProperty theOldID extendedProps[i]
					magma.setNodeProperty theOldID extendedProps[i] oldPropValues[i] 
				)
			)
			
			--Copy defaults of matching input sockets:
			for i = 1 to magma.getNumNodeInputs theOldID do
				for j = 1 to theOldSockets.count do
					if theOldSockets[j][1] == magma.GetNodeInputDescription theOldID i and classof (magma.getNodeInputDefaultValue theOldID i) == theOldSockets[j][2] do
						magma.setNodeInputDefaultValue theOldID i theOldSockets[j][2]
					
					
			MagmaFlowEditor_Functions.setUIProperty magma theOldID "Name" ddl_type.selected
			
			for c = 1 to magma.GetNumNodeInputs theOldID where theOldConnections[c] != undefined do
				magma.SetNodeInput theOldID c theOldConnections[c][1] theOldConnections[c][2]
			
			for c = 1 to magma.getNumNodeOutputs theOldID where theOldOutputConnections[c] != undefined do
				for j = 1 to theOldOutputConnections[c].count do
					magma.SetNodeInput theOldOutputConnections[c][j][1] theOldOutputConnections[c][j][2] theOldID c
				
			updateType()
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord "Change Operator Type"			
		)
		
		on ddl_type selected itm do
		(
			replaceNode()
		)		
		on ddl_category selected itm do
		(
			local theArray = MagmaFlowEditor_Rollout.DepotDefinition[itm]
			ddl_type.items = for i = 2 to theArray.count collect theArray[i][2]
			ddl_type.selection = 1
			replaceNode()
		)		
		
		fn updateGUI =
		(
			theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			chk_enabled.state = (magma.getNodeProperty theID "enabled")
			chk_collapsed.state = (magma.getNodeProperty theID "Collapsed") == true
			--chk_hideUnconnectedOutputs.state = (magma.getNodeProperty theID "HideUnconnectedOutputs") == true
		)
		
		fn RolloutOpen =
		(
			updateCategories()
			updateGUI()
			--updateSubRollouts()
			--KrakatoaChannelNodeEditor_OperatorDescriptionRollout.updateDescription()
		)			
		
		on MagmaFlowEditor_OperatorRollout open do
		(
			RolloutOpen()
		)
		
	)
	
	rollout MagmaFlowEditor_OutputRollout "Output" category:100
	(
		checkbox chk_enabled "Enable" align:#left offset:[-5,-3] across:2 
		checkbox chk_collapsed "Collapse" offset:[8,-3] align:#right
		
		label lbl_channelName " Channel Name:" align:#left offset:[-10,-5]
		edittext edt_ChannelName fieldwidth:160 align:#center offset:[-1,-3]
		edittext lbl_isUsedByKrakatoa "" fieldwidth:160 align:#center offset:[-1,-3] readonly:true
		listbox ddl_ChannelType " Standard Channel Names:" items:#() width:160 align:#center
		listbox ddl_ChannelData " Data Type:" items:#() height:4 width:100 align:#left across:2 offset:[-10,0]
		listbox ddl_ChannelArity " Arity:" items:#("1","2","3","4") height:4 width:60 align:#right offset:[10,0]
		
		
		dropdownlist ddl_sortingOptions " Channel List Sorting:" items:#("Factory Default Order","By Usage Frequency","Alphabetical","Alphabetical, Mapping Last","Int>Float>Vector>Quat","Integers Only","Floats Only","Vectors Only","Quaternions Only","PRT Maker Channels Only","PRT Hair Channels Only","Frost Channels Only","FumeFX Channels Only","RealFlow Channels Only","Naiad Channels Only") offset:[0,0] width:160 height:20 align:#center
		
		fn updateGUI =
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			chk_enabled.state = (magma.getNodeProperty theID "enabled")
			chk_collapsed.state = (magma.getNodeProperty theID "Collapsed") == true
		)
			
		
		fn getChannelDataAndArity =
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local theName = magma.getNodeProperty theID "channelName"
			local theType = magma.getNodeProperty theID "channelType"
			local theFS = filterString theType "[]"
			theType = theFS[1]
			local theArity = theFS[2] --if classof (magma.getNodeProperty theID "controller").value == Point3 then 3 else 1
			if theArity == undefined do theArity = 1
			
			if MagmaFlowEditor_Functions.isRenderElement magma then
			(
				ddl_ChannelData.items = #("float16","float32")
				ddl_ChannelArity.enabled = false
				ddl_ChannelArity.selection = 3
				edt_ChannelName.text = "RenderElement"
				edt_ChannelName.enabled = false
				ddl_ChannelType.visible = false
				ddl_sortingOptions.visible = false
			)
			else 
			(
				ddl_ChannelType.visible = true
				edt_ChannelName.enabled = true
				ddl_sortingOptions.visible = true
				if findItem ddl_ChannelType.items theName == 0 then --custom channel!
				(
					ddl_ChannelData.items = #("float16","float32","int8","int16","int32","uint8","uint16","uint32")
					ddl_ChannelArity.enabled = true
				)
				else
				(
					ddl_ChannelArity.enabled = false
					if matchPattern theType pattern:"float*" then
						ddl_ChannelData.items = #("float16","float32","float64")
					else if matchPattern theType pattern:"int*" then
						ddl_ChannelData.items = #("int8","int16","int32","int64")
					else if matchPattern theType pattern:"uint*" then
						ddl_ChannelData.items = #("uint8","uint16","uint32","uint64")
				)
			)
			ddl_ChannelData.selection = findItem ddl_ChannelData.items theType			
			ddl_ChannelArity.selection = findItem ddl_ChannelArity.items (theArity as string)
		)
		
		fn updateDataDepth =
		(
			theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			if ddl_ChannelArity.selection > 1 then
				magma.setNodeProperty theID "channelType" (ddl_ChannelData.selected+"["+ddl_ChannelArity.selected +"]")
			else
				magma.setNodeProperty theID "channelType" ddl_ChannelData.selected
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			--if MagmaFlowEditor_Rollout.chk_autoUpdateModifier.checked do KrakatoaChannelsEditor_Functions.updateParentModifier()
		)
		
		fn updateDataArity =
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local theType = magma.getNodeProperty theID "channelType"
			local theFS = filterString theType "[]"
			theType = theFS[1]+"["+ddl_ChannelArity.selected+"]"
			magma.setNodeProperty theID "channelType" theType 
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
		)
		
		fn updateSelection =
		(
			local theVal = execute (getIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "OutputNode" "ChannelSorting" )
			if theVal == OK do theVal = 1
			ddl_sortingOptions.selection = theVal
			
			ddl_ChannelType.items  = MagmaFlowEditor_Functions.getSortedChannelsList channelsList ddl_sortingOptions.selection theIniFileLocation includeCustom:false nodeType:#output
			local theChannelName = (filterString (magma.getNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "channelName") ": ")[1]
			local theIndex = findItem ddl_ChannelType.items theChannelName 
			ddl_ChannelType.selection = theIndex
			getChannelDataAndArity()
			updateGUI()
		)
		
		fn getUsedByRendererState =
		(
			if MagmaFlowEditor_Functions.IsModifier magma then
			(
				if renderers.current.classid as string == "#(-1204370534, -399920359)" then --if Krakatoa is the Renderer
				(
					try(
						Krakatoa_GUI_Channels.updateMemChannels()
						lbl_isUsedByKrakatoa.text = if (for i in Krakatoa_GUI_Channels.activeMemChannels where matchPattern i[1] pattern:edt_ChannelName.text collect i).count == 1 then
							"Will Be Stored In PCache" 
						else 
							"Not Cacheable"
					)catch(lbl_isUsedByKrakatoa.text = "Failed To Acquire Renderer Info")	
				)
				else lbl_isUsedByKrakatoa.text = "Current Renderer Not Krakatoa"
			)
			else if MagmaFlowEditor_Functions.IsGenome magma then
				lbl_isUsedByKrakatoa.text = "TriMesh Channel"
			else
				lbl_isUsedByKrakatoa.text = "Will Output As Render Element"
		)		
		
		/*
		fn getUsedByRendererState =
		(
			if MagmaFlowEditor_Functions.isRenderElement magma then
			(
				if renderers.current.classid as string == "#(-1204370534, -399920359)" do --if Krakatoa is the Renderer
				(
					try(
						Krakatoa_GUI_Channels.updateMemChannels()
						lbl_isUsedByKrakatoa.text = if (for i in Krakatoa_GUI_Channels.activeMemChannels where matchPattern i[1] pattern:edt_ChannelName.text collect i).count == 1 then
							"Will Be Stored In PCache" 
						else 
							"Not Cacheable"
					)catch(lbl_isUsedByKrakatoa.text = "")	
				)
			)
			else
				lbl_isUsedByKrakatoa.text = "Will Output As Render Element"
		)
		*/
		
		on chk_enabled changed state do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.setNodeProperty theID "enabled" (not (magma.getNodeProperty theID "enabled"))
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		
		on chk_collapsed changed state do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.DeclareExtensionProperty theID "Collapsed" 
			local theState = magma.GetNodeProperty theID "Collapsed"  
			if theState == undefined do theState = false
			theState = not theState 			
			magma.setNodeProperty theID "Collapsed" theState
			MagmaFlowEditor_Rollout.collapseBranches()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)			
		
		on ddl_sortingOptions selected itm do
		(
			setIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "OutputNode" "ChannelSorting" (itm as string)
			updateSelection()
			getUsedByRendererState()
		)				
		


		on edt_ChannelName entered txt do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local txt = MagmaFlowEditor_Functions.purifyChannelName txt
			local theIndex = findItem ddl_ChannelType.items txt
			if theIndex > 0 then
			(
				magma.setNodeProperty theID "channelName" txt
			)
			else
				magma.setNodeProperty theID "channelName" txt
			
			updateSelection()
			MagmaFlowEditor_Rollout.createUndoRecord ("Enter Output Channel Name ["+ txt +"]")
			MagmaFlowEditor_Rollout.createNodeTree init:false
			edt_ChannelName.text = txt
			getUsedByRendererState()
			MagmaFlowEditor_Rollout.debugFlow()
		)

		
		on ddl_ChannelType selected itm do
		(
			edt_ChannelName.text = ddl_ChannelType.selected
			--local theTypeArray = for i = 1 to 3 collect sortedChannelsList[itm][i]
			/*	
			if MagmaFlowEditor_Functions.isRenderElement magma false do  
			(
				theTypeArray[2] = "float16"
				theTypeArray[3] = 3
			)
			*/
			--KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][3] = deepCopy theTypeArray
			
			--updateDataDepth()
			
			--magma.ReplaceNode theOldID theNewID
			
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.setNodeProperty theID "channelName" ddl_ChannelType.selected
			
			local theIndex = 0
			for i = 1 to ChannelsList.count where ChannelsList[i][1] == ddl_ChannelType.selected do theIndex = i
			if theIndex > 0 do
			(
				--print theIndex
				--print ChannelsList
				if ChannelsList[theIndex][3] > 1 then
					magma.setNodeProperty theID "channelType" (ChannelsList[theIndex][2] + "[" +ChannelsList[theIndex][3] as string + "]")
				else
					magma.setNodeProperty theID "channelType" ChannelsList[theIndex][2]
			)
			
			theVal = execute (getIniSetting (theIniFileLocation + "MagmaFlowOutputChannelsUsageHistory.ini") "UsageHistory" ddl_ChannelType.selected)
			if theVal == OK do theVal = 0
			theVal += 1
			setIniSetting (theIniFileLocation + "MagmaFlowOutputChannelsUsageHistory.ini") "UsageHistory" ddl_ChannelType.selected (theVal as string)
				
			updateSelection()
			getUsedByRendererState()
			getChannelDataAndArity()
			MagmaFlowEditor_Rollout.createUndoRecord ("Output Channel Name ["+ ddl_ChannelType.selected +"]")
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
			MagmaFlowEditor_Rollout.updateModifierName()
		)

		
		on ddl_ChannelData selected itm do
		(
			updateDataDepth()
			MagmaFlowEditor_Rollout.createUndoRecord ("Output Channel Data ["+ddl_ChannelData.selected + "]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)
		
		on ddl_ChannelArity selected itm do
		(
			updateDataArity()
			MagmaFlowEditor_Rollout.createUndoRecord ("Output Channel Arity ["+ddl_ChannelArity.selected + "]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)		

		
		fn RolloutOpen =
		(
			local theSource = #kcm
			if not MagmaFlowEditor_Functions.IsModifier magma do theSource = #relement
			if MagmaFlowEditor_Functions.IsGenome magma do theSource = #genome
			channelsList = MagmaFlowEditor_Functions.loadChannelsList mode:#output source:theSource
			edt_ChannelName.text = (filterString (magma.getNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "channelName") ": ")[1]
			ddl_ChannelType.items  = MagmaFlowEditor_Functions.getSortedChannelsList channelsList ddl_sortingOptions.selection theIniFileLocation includeCustom:false
			updateSelection()
			getUsedByRendererState()
		)
		
		on MagmaFlowEditor_OutputRollout open do
		(
			RolloutOpen()
		)
	)
	
	rollout MagmaFlowEditor_InputChannelRollout "Input Channel" category:100
	(
		--group "Input Node Settings:"	(
			dropdownlist ddl_ValueType height:25 items:#() width:160 align:#center offset:[0,-3]
			edittext edt_ChannelName fieldwidth:159 offset:[-3,-3] align:#center
			edittext lbl_channelInfo "" offset:[-3,-4] align:#center readonly:true fieldwidth:159
			edittext lbl_isUsedByKrakatoa "" offset:[-3,-4] align:#center readonly:true fieldwidth:159
			dropdownlist ddl_sortingOptions items:#("Factory Default Order","By Usage Frequency","Alphabetical","Alphabetical, Mapping Last","Int>Float>Vector>Quat","Integers Only","Floats Only","Vectors Only","Quaternions Only","PRT Maker Channels Only","PRT Hair Channels Only","Frost Channels Only","FumeFX Channels Only","RealFlow Channels Only","Naiad Channels Only") offset:[0,0] width:160 height:20 align:#center --"Channel List Sorting:"

			checkbutton btn_matchChannelFrom "Match Channel From Node..." width:160 offset:[0,-3] align:#center tooltip:"Set the Channel by picking an existing InputChannel or Output node..."
			button btn_convertToFloat "Convert To Float" width:160 offset:[0,-3] align:#center tooltip:"Insert a ToFloat Operator to convert the Input value to a Floating Point value."
			button btn_convertToVector "Convert To Vector" width:160 align:#center offset:[0,-25] tooltip:"Insert a ToVector Operator to convert the Input value to a Vector value."
			
			button btn_convertVectorX "Extract X" width:53 across:3 offset:[-10,-25] align:#left tooltip:"Insert a Breakout Operator to extract the X component of the Vector value."
			button btn_convertVectorY "Extract Y" width:54 align:#center offset:[0,-25] tooltip:"Insert a Breakout Operator to extract the Y component of the Vector value."
			button btn_convertVectorZ "Extract Z" width:53 align:#right offset:[9,-25] tooltip:"Insert a Breakout Operator to extract the Z component of the Vector value."

			button btn_transformToWorld "To World" width:80 across:2 offset:[-10,-3] align:#left tooltip:"Insert a ToWorld Operator to transform the Vector to world space."
			button btn_transformToView "To Camera" width:80 align:#right offset:[10,-3] tooltip:"Insert a ToView Operator to transform the Vector to view space."

		--button btn_sameChannelAsOutput "Same Channel As Output" width:152 tooltip:"Switches the Input to the same Channel as the current Output Node."		
		--)
		
		fn getUsedByRendererState =
		(
			if MagmaFlowEditor_Functions.IsModifier magma then
			(
				if renderers.current.classid as string == "#(-1204370534, -399920359)" then --if Krakatoa is the Renderer
				(
					try(
						Krakatoa_GUI_Channels.updateMemChannels()
						lbl_isUsedByKrakatoa.text = if (for i in Krakatoa_GUI_Channels.activeMemChannels where matchPattern i[1] pattern:edt_ChannelName.text collect i).count == 1 then
							"Will Be Stored In PCache" 
						else 
							"Not Cacheable"
					)catch(lbl_isUsedByKrakatoa.text = "Failed To Acquire Renderer Info")	
				)
				else lbl_isUsedByKrakatoa.text = "Current Renderer Not Krakatoa"
			)
			else if MagmaFlowEditor_Functions.IsGenome magma then
				lbl_isUsedByKrakatoa.text = "TriMesh Channel"
			else
				lbl_isUsedByKrakatoa.text = "Will Output As Render Element"
		)		
		
		fn updateControls =
		(
			ddl_ValueType.items =  MagmaFlowEditor_Functions.getSortedChannelsList channelsList ddl_sortingOptions.selection theIniFileLocation
--			edt_ChannelName.text = magma.GetNodeProperty MagmaFlowEditor_Rollout.nodeIDMap[MagmaFlowEditor_Rollout.lastNodeClick] "channelName"
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			edt_ChannelName.text = magma.GetNodeProperty theID "channelName"

--			local theChannelName = magma.GetNodeProperty MagmaFlowEditor_Rollout.nodeIDMap[MagmaFlowEditor_Rollout.lastNodeClick] "channelName"
			local theChannelName = magma.GetNodeProperty theID "channelName"
			
			local theIndex = findItem ddl_ValueType.items theChannelName
			if theIndex == 0 do 
			(
				theIndex = 1
				edt_ChannelName.visible = true
			)					
			ddl_ValueType.selection = theIndex
			lbl_channelInfo.text = "User-Defined Channel Name"
			for i in channelsList where i[1] == theChannelName do 
			(
				btn_convertToVector.visible = i[3] == 1 and not matchPattern i[2] pattern:"int*"
				btn_convertToFloat.visible = matchPattern i[2] pattern:"int*" and i[3] == 1
				btn_transformToWorld.visible = btn_transformToView.visible = btn_convertVectorX.visible = btn_convertVectorY.visible = btn_convertVectorZ.visible = i[3] == 3
				lbl_channelInfo.text = i[4]
			)
			if theIndex == 1 do 
			(
				btn_convertToFloat.visible = btn_convertToVector.visible = btn_convertVectorX.visible = btn_convertVectorY.visible = btn_convertVectorZ.visible = false
			)
			getUsedByRendererState()			
		)
		
		on edt_ChannelName entered txt do
		(
			txt = MagmaFlowEditor_Functions.purifyChannelName txt
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.setNodeProperty theID "channelName" txt
			updateControls()
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord ("Enter Channel Name ["+ txt +"]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			edt_ChannelName.text = txt
		)		
		
		on btn_matchChannelFrom changed state do
		(
			if state then
			(
				MagmaFlowSettings.isPickingChannelFromNode = MagmaFlowEditor_Rollout.lastNodeClick
			)
			else
			(
				MagmaFlowSettings.isPickingChannelFromNode = undefined
			)
		)

		on ddl_sortingOptions selected itm do
		(
			updateControls()
			setIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "InputNode" "ChannelSorting" (itm as string)
		)		
		
		fn ddl_ValueType_SelectedFN itm =
		(
			if itm > 1 then
			(
				local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				magma.setNodeProperty theID "channelName" ddl_ValueType.selected
				--KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][3][2] = KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][4][9] = KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][4][8] = ddl_ValueType.selected
				updateControls()
				MagmaFlowEditor_Rollout.createNodeTree init:false
				MagmaFlowEditor_Rollout.createUndoRecord ("Channel [" + ddl_ValueType.selected + "]")
				MagmaFlowEditor_Rollout.updateMagmaHolder()
				setFocus MagmaFlowEditor_Rollout.hc		
				edt_ChannelName.visible = false
				theVal = execute (getIniSetting (theIniFileLocation + "MagmaFlowInputChannelsUsageHistory.ini") "UsageHistory" ddl_ValueType.selected)
				if theVal == OK do theVal = 0
				theVal += 1
				setIniSetting (theIniFileLocation + "MagmaFlowInputChannelsUsageHistory.ini") "UsageHistory" ddl_ValueType.selected (theVal as string)
				updateControls()
			)	
			else
			(
				edt_ChannelName.visible = true
				--KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][4][9] = KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][3][2] 
				edt_ChannelName.text = "<enter name here>"
				updateControls()
				--ddl_ValueType.selection = findItem ddl_ValueType.items KrakatoaChannelEditor_DisplayNodeTreeData[MagmaFlowEditor_Rollout.lastNodeClick][3][2]
			)	
			MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			updateControls()
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.createUndoRecord ("Value Type [" + ddl_ValueType.selected + "]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			setFocus MagmaFlowEditor_Rollout.hc
			MagmaFlowEditor_Rollout.debugFlow()
			--MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
		)
		
		on btn_convertVectorX pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:1 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		on btn_convertVectorY pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:2 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		on btn_convertVectorZ pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:3 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)			
		
		on btn_transformToWorld pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToWorld" mode:#button
			if magma.getNodeType currentID == "InputChannel" do 
			(
				if magma.getNodeProperty currentID "channelName" == "Normal" then 
					magma.setNodeProperty newID "inputType" "Normal"
				else 	if magma.getNodeProperty currentID "channelName" != "Position" do 
					magma.setNodeProperty newID "inputType" "Vector"
			)
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		on btn_transformToView pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToCamera" mode:#button
			if magma.getNodeType currentID == "InputChannel" do 
			(
				if magma.getNodeProperty currentID "channelName" == "Normal" then 
					magma.setNodeProperty newID "inputType" "Normal"
				else 	if magma.getNodeProperty currentID "channelName" != "Position" do 
					magma.setNodeProperty newID "inputType" "Vector"
			)
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		on btn_convertToVector pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToVector" mode:#button
			magma.setNodeInput newID 1 currentID 1
			magma.setNodeInput newID 2 currentID 1
			magma.setNodeInput newID 3 currentID 1
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		on btn_convertToFloat pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToFloat" mode:#button
			magma.setNodeInput newID 1 currentID 1
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		
		
		on ddl_ValueType selected itm do 
		(
			ddl_ValueType_SelectedFN itm
		)			

		fn RolloutOpen =
		(
			local theSource = #kcm
			if not MagmaFlowEditor_Functions.IsModifier magma do theSource = #relement
			if MagmaFlowEditor_Functions.IsGenome magma do theSource = #genome
			channelsList = MagmaFlowEditor_Functions.loadChannelsList mode:#input source:theSource
			
			local theVal = execute (getIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "InputNode" "ChannelSorting" )
			if theVal == OK do theVal = 1
			ddl_sortingOptions.selection = theVal
			updateControls()
		)
		
		on MagmaFlowEditor_InputChannelRollout open do
		(
			RolloutOpen()
		)		
		
	)
	
	rollout MagmaFlowEditor_InputValueRollout "Input Value" category:100
	(
		local theCtrl
		checkbox chk_exposed "Exposed" align:#left offset:[-3,0] across:2
		dropdownlist ddl_ValueType items:#("Vector","Float","Integer") width:80 align:#right offset:[3,-3] 
		
		spinner spn_valueInt "Integer:" range:[-1000000000,1000000000,0] visible:false offset:[0,21] type:#integer controller:CurrentIntController
		spinner spn_value "Float:" range:[-1000000000,1000000000,0] visible:false offset:[0,-21] controller:CurrentFloatController scale:0.01
		
		spinner spn_x "X:" range:[-1000000000,1000000000,0] offset:[0,-42] visible:false controller:CurrentVectorController[1].controller scale:0.01
		spinner spn_y "Y:" range:[-1000000000,1000000000,0] visible:false controller:CurrentVectorController[2].controller scale:0.01
		spinner spn_z "Z:" range:[-1000000000,1000000000,0] visible:false controller:CurrentVectorController[3].controller scale:0.01
		colorpicker clr_color "As Color:" align:#right fieldwidth:72 height:18 color:white offset:[0,0] visible:true alpha:true modal:false 
		colorpicker clr_colorComplementary "Complement:" align:#right fieldwidth:72 height:14 color:black offset:[0,-3] visible:true alpha:true modal:false
		
		button btn_convertToFloat "Convert To Float" width:150 align:#center  tooltip:"Insert a ToFloat Operator to convert the Input value to a Floating Point value."
		button btn_convertToVector "Convert To Vector" width:150 align:#center  offset:[0,-26] tooltip:"Insert a ToVector Operator to convert the Input value to a Vector value."
		button btn_convertVectorX "Extract X" width:50 across:3 offset:[-5,-26] align:#left tooltip:"Insert a Breakout Operator to extract the X component of the Vector value."
		button btn_convertVectorY "Extract Y" width:50 align:#center offset:[0,-26] tooltip:"Insert a Breakout Operator to extract the Y component of the Vector value."
		button btn_convertVectorZ "Extract Z" width:50 align:#right offset:[5,-26] tooltip:"Insert a Breakout Operator to extract the Z component of the Vector value."
		button btn_transformToWorld "To World" width:75 across:2 offset:[-5,-3] align:#left tooltip:"Insert a ToWorld Operator to transform the Vector to world space."
		button btn_transformToView "To Camera" width:75 align:#right offset:[5,-3] tooltip:"Insert a ToView Operator to transform the Vector to view space."
		
		fn updateControls =
		(
			with animate off 
			(
				chk_exposed.state = (magma.getNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "Exposed" ) == true
				theCtrl = magma.GetNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "controller"
				local theCtrlIsInt = magma.GetNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "forceInteger"
				
				if classof theCtrl.value == Point3 do ddl_ValueType.selection = 1  
				if classof theCtrl.value == Float and theCtrlIsInt == false do ddl_ValueType.selection = 2
				if classof theCtrl.value == Float and theCtrlIsInt == true do ddl_ValueType.selection = 3
					
				case ddl_ValueType.selected of
				(
					"Integer" : (
						chk_exposed.visible = btn_convertToFloat.visible = spn_valueInt.visible = ddl_ValueType.visible = true
						spn_value.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = clr_colorComplementary.visible = false
						btn_convertToVector.visible = btn_transformToWorld.visible = btn_transformToView.visible = btn_convertVectorX.visible = btn_convertVectorY.visible = btn_convertVectorZ.visible = false
						spn_valueInt.enabled = true 
						)						
					"Float": (
						chk_exposed.visible = btn_convertToVector.visible = ddl_ValueType.visible = spn_value.visible = true
						spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = clr_colorComplementary.visible = false
						btn_convertToFloat.visible = btn_transformToWorld.visible = btn_transformToView.visible = btn_convertVectorX.visible = btn_convertVectorY.visible = btn_convertVectorZ.visible = false
						spn_value.enabled = true 
						)
					"Vector": (
						chk_exposed.visible = ddl_ValueType.visible = spn_x.visible = spn_y.visible = spn_z.visible = clr_color.visible = clr_colorComplementary.visible = true
						btn_convertToVector.visible = btn_convertToFloat.visible = spn_valueInt.visible = spn_value.visible  = false
						clr_color.color = theCtrl.value*255 
						clr_colorComplementary.color = white - clr_color.color
						spn_x.value = theCtrl.value.x
						spn_y.value = theCtrl.value.y
						spn_z.value = theCtrl.value.z
						btn_transformToWorld.visible = btn_transformToView.visible = btn_convertVectorX.visible = btn_convertVectorY.visible = btn_convertVectorZ.visible = true
						spn_x.enabled = spn_y.enabled = spn_z.enabled = (classof theCtrl == point3_xyz)
					)
				)	
			)--end animate off
		)
		
		on btn_convertVectorX pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:1 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		on btn_convertVectorY pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:2 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		on btn_convertVectorZ pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowEditor_Rollout.createNode "Breakout" insertOutSocket:3 mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		on btn_transformToWorld pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToWorld" mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		on btn_transformToView pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToCamera" mode:#button
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		
		on btn_convertToFloat pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToFloat" mode:#button
			magma.setNodeInput newID 1 currentID 1
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)		
		
		on btn_convertToVector pressed do
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToVector" mode:#button
			magma.setNodeInput newID 1 currentID 1
			magma.setNodeInput newID 2 currentID 1
			magma.setNodeInput newID 3 currentID 1
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		
		on chk_exposed changed state do
		(
			local ID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			magma.DeclareExtensionProperty ID "Exposed"
			magma.setNodeProperty ID "Exposed" state
			MagmaFlowEditor_Rollout.exposeControlsToModifier()
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord (if state then "Exposed Control" else "Unexposed Control")
		)
		

		on spn_valueInt changed val do
		(
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
			local ID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			if magma.getNodeProperty ID "Exposed" == true do
			(
				theMod = for i in refs.Dependents magma where isProperty i #MagmaHolder collect i
				if theMod.count > 0 do 
				(
					if theMod[1].KCM_CA.params.open do
					(
						modPanel.setCurrentObject theMod[1]
					)
				)
			)
		)		
		on spn_valueInt entered do
		(
			--storeValues()
			MagmaFlowEditor_Rollout.createUndoRecord ("Integer Value [" + spn_valueInt.value as string + "]")
			MagmaFlowEditor_Rollout.debugFlow()
		)
		
		on spn_value changed val do
		(
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)
		on spn_value entered do
		(
			--storeValues()
			MagmaFlowEditor_Rollout.createUndoRecord ("Float Value [" + spn_value.value as string + "]")
			MagmaFlowEditor_Rollout.debugFlow()
		)		
		
		on spn_x changed val do
		(
			with animate off 
			(
				clr_color.color.r = val*255
				clr_colorComplementary.color = white - clr_color.color
			)
			MagmaFlowEditor_Rollout.createNodeTree init:false
			with animate off MagmaFlowEditor_Rollout.updateMagmaHolder()			
			MagmaFlowEditor_Rollout.debugFlow()
		)
		on spn_x entered do
		(
			--storeValues()
			MagmaFlowEditor_Rollout.createUndoRecord ("Vector X Value [" + spn_x.value as string + "]")
			MagmaFlowEditor_Rollout.debugFlow()
		)			
		
		on spn_y changed val do
		(
			with animate off 
			(
				clr_color.color.g = val*255
				clr_colorComplementary.color = white - clr_color.color
			)
			MagmaFlowEditor_Rollout.createNodeTree init:false
			with animate off MagmaFlowEditor_Rollout.updateMagmaHolder()			
			MagmaFlowEditor_Rollout.debugFlow()
		)
		on spn_y entered do
		(
			--storeValues()
			MagmaFlowEditor_Rollout.createUndoRecord ("Vector Y Value [" + spn_y.value as string + "]")
			MagmaFlowEditor_Rollout.debugFlow()
		)			
		
		on spn_z changed val do
		(
			with animate off 
			(
				clr_color.color.b = val*255
				clr_colorComplementary.color = white - clr_color.color
			)
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)	
		on spn_z entered do
		(
			--storeValues()
			MagmaFlowEditor_Rollout.createUndoRecord ("Vector Z Value [" + spn_z.value as string + "]")
			MagmaFlowEditor_Rollout.debugFlow()
		)			
		
		on clr_color changed val do
		(
			theCtrl.value = clr_color.color/255.0
			spn_x.value = clr_color.color.r/255.0
			spn_y.value = clr_color.color.g/255.0
			spn_z.value = clr_color.color.b/255.0
			clr_colorComplementary.color = white - clr_color.color
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord ("Color ["+ (val as Point3) as string + "]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)
		
		on clr_colorComplementary changed val do
		(
			clr_color.color = white - val
			theCtrl.value = clr_color.color/255.0
			
			spn_x.value = clr_color.color.r/255.0
			spn_y.value = clr_color.color.g/255.0
			spn_z.value = clr_color.color.b/255.0
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord ("Color ["+ (clr_color.color as Point3) as string + "]")
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			MagmaFlowEditor_Rollout.debugFlow()
		)	

		
		fn ddl_ValueType_SelectedFN itm =
		(
			local needExposureUpdate = false
			local theOldID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			local oldValClass = classof (magma.getNodeProperty theOldID "controller").value
			local theOldType = #Float
			if oldValClass == Point3 then 
				theOldType = #Vector
			else
				if (magma.getNodeProperty theOldID "forceInteger") == true do theOldType = #Integer
			
			if theOldType == #Integer and ddl_ValueType.selected as name == #Float or theOldType == #Float and ddl_ValueType.selected as name == #Integer then
			(
				magma.SetNodeProperty theOldID "forceInteger" (ddl_ValueType.selected as name == #Integer)
			)
			else if theOldType != ddl_ValueType.selected as name do
			(
				local extendedProps = magma.GetExtensionPropertyNames theOldID --#("Position" , "Internal_Position", "Collapsed", "Selected", "Exposed", "Name", "Notes")
				local oldPropValues = for p in extendedProps collect magma.getNodeProperty theOldID p
				
				local oldConnections = magmaFlowEditor_Functions.GetConnectedNodes magma theOldID
				
				theNewID = magma.CreateNode "InputValue"
				theOldCtrl = magma.GetNodeProperty theOldID "controller"
				magma.ReplaceNode theOldID theNewID
				
				case ddl_ValueType.selected as name of
				(
					#Float:
					(
						local theCtrl = bezier_float(); theCtrl.value = 1.0
						if classof theOldCtrl == Point3_xyz do theCtrl = copy theOldCtrl[1].controller
						magma.SetNodeProperty theOldID "controller" theCtrl
					)
					#Integer:
					(
						local theCtrl = bezier_float(); theCtrl.value = 1.0
						if classof theOldCtrl == Point3_xyz do theCtrl = copy theOldCtrl[1].controller
						magma.SetNodeProperty theOldID "controller" theCtrl
						magma.SetNodeProperty theOldID "forceInteger" true
					)
					#Vector:
					(
						local theCtrl = point3_xyz(); theCtrl.value = [0,0,0]
						if classof theOldCtrl == bezier_float do 
						(
							theCtrl[1].controller = copy theOldCtrl
							theCtrl[2].controller = copy theOldCtrl
							theCtrl[3].controller = copy theOldCtrl
						)
						magma.SetNodeProperty theOldID "controller" theCtrl
					)							
				)							
				
				for i = 1 to extendedProps.count do 
				(
					magma.DeclareExtensionProperty theOldID extendedProps[i]
					magma.setNodeProperty theOldID extendedProps[i] oldPropValues[i]
					if extendedProps[i] == "Exposed" and oldPropValues[i] == true do needExposureUpdate = true
				)
				
				magma.DeclareExtensionProperty theOldID "Position" 
				
				for c = 1 to oldConnections.count do
					for j in oldConnections[c] do 
						magma.setNodeInput j[1] j[2] theOldID c
				
			)
			MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			updateControls()
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.createUndoRecord ("Value Type [" + ddl_ValueType.selected + "]")
			if needExposureUpdate do MagmaFlowEditor_Rollout.exposeControlsToModifier()
			MagmaFlowEditor_Rollout.updateMagmaHolder()
			setFocus MagmaFlowEditor_Rollout.hc
			MagmaFlowEditor_Rollout.debugFlow()
		)
		
		
		on ddl_ValueType selected itm do 
		(
			ddl_ValueType_SelectedFN itm
		)			
		
		fn RolloutOpen =
		(
			updateControls()
		)
		
		on MagmaFlowEditor_InputValueRollout open do
		(
			RolloutOpen()
		)
	)
	
	rcmenu MagmaFlowEditor_Zoom_RCMenu
	(
		menuItem mnu_resetPanAndZoom "Reset Pan and Zoom"
		separator sep_10
		menuItem mnu_resetPan "Reset Pan"
		menuItem mnu_resetZoom "Reset Zoom"
		separator sep_20
		menuItem mnu_zoomSelected "Zoom Selected"
		menuItem mnu_zoomExtents "Zoom Extents"

		on mnu_resetPanAndZoom picked do
		(
			MagmaFlowEditor_Rollout.resetPanFactor update:false  createUndo:false
			MagmaFlowEditor_Rollout.resetZoomFactor update:false createUndo:false
			MagmaFlowEditor_Rollout.createUndoRecord ("Reset Pan and Zoom")			
			MagmaFlowEditor_Rollout.createNodeTree init:false			
			MagmaFlowEditor_Rollout.updateNavigator fullUpdate:false
			MagmaFlowEditor_Rollout.storePanAndZoom()
		)
		on mnu_resetPan picked do
		(
			MagmaFlowEditor_Rollout.resetPanFactor()
			MagmaFlowEditor_Rollout.storePanAndZoom() 

		)
		on mnu_resetZoom picked do
		(
			MagmaFlowEditor_Rollout.resetZoomFactor()
			MagmaFlowEditor_Rollout.storePanAndZoom()
		)
		on mnu_zoomSelected picked do
		(
			MagmaFlowEditor_Rollout.ZoomExtentsSelected()
			MagmaFlowEditor_Rollout.storePanAndZoom()
		)
		on mnu_zoomExtents picked do
		(
			MagmaFlowEditor_Rollout.ZoomExtents()
			MagmaFlowEditor_Rollout.storePanAndZoom()
		)		
	)
	
	rcmenu MagmaFlowEditor_Rollout_MainMenu
	(
		fn CanPasteFromWindowsClipboard = 
		(
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*"			
		)
		
		fn CanPasteFromWindowsClipboardAndKeepWires =
		(
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*" AND trackID == ::magmaClipBoardId
		)			
		
		subMenu "File"
		(
			menuitem mnu_new "&New..."
			separator sep_file_10
			menuitem mnu_replacemxs "Load And &Replace MAXScript Flow..."
			menuitem mnu_mergemxs "Load And &Merge MAXScript Flow..."
			separator sep_file_20
			menuitem mnu_open "&Import Magma 1.x KMF Flow..."
			separator sep_file_30
			menuitem mnu_exportasmxs "Save &Flow As MAXScript..."
			menuItem mnu_exportSelectedAsMXS "Save &Selected Nodes As MAXScript..."
			separator sep_file_40
			menuItem mnu_exploreFolder "&Explore Flows Folder..."
			separator sep_file_50
			menuitem mnu_close "&Close... (Ctrl+Q)"
		)
		subMenu "Edit"
		(
			menuitem mnu_undo "Undo (Ctrl+Z)" enabled:MagmaFlowEditor_Rollout.btn_undo.enabled
			menuitem mnu_redo "Redo (Ctrl+Y)" enabled:MagmaFlowEditor_Rollout.btn_redo.enabled
			separator sep_10
			menuItem mnu_copyToClipboard "Copy (Ctrl+C)" enabled:((MagmaFlowEditor_Rollout.getSelectedNodes()).count > 0)
			menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" enabled:(CanPasteFromWindowsClipboard())
			menuItem mnu_pasteFromClipboardAndKeepWires "Paste And Preserve Connections (Ctrl+Alt+V)" enabled:(CanPasteFromWindowsClipboardAndKeepWires())
			separator sep_20
			menuitem mnu_insertMode "Branch/Insert Mode Toggle (Ins)" checked:(MagmaFlowSettings.nodeInsertMode != true)
			separator sep_25
			menuitem mnu_selectAllNodes "Select All Nodes (Ctrl+A)" 
			menuitem mnu_invertSelection "Invert Selection (Ctrl+I)"
			menuitem mnu_deselectAllNodes "Deselect All Nodes (Ctrl+D)" 
			separator sep_30
			menuitem mnu_selectUnconnectedNodes "Select Unconnected Nodes (Ctrl+U)" 
			/*
			menuitem mnu_selectDisabledNodes "Select Disabled Nodes (Ctrl+Shift+U)" 
			menuitem mnu_selectInputNodesOnly "Select All Input Nodes" 
			menuitem mnu_selectOperatorNodesOnly "Select All Operator Nodes" 
			menuitem mnu_selectBlackOpNodesOnly "Select All BlackOp Nodes" 
			separator sep_40
			menuitem mnu_growSelectionChildren "Grow Selection - Add Children (Shift+PgDn)" 
			menuitem mnu_growSelectionParents "Grow Selection - Add Parents (Shift+PgUp)" 
*/				
			separator sep_50
			menuitem mnu_exitBlop "Exit BLOP Editing" enabled:(MagmaFlowSettings.NumEditingBLOPs > 0)
			separator sep_60
			menuitem mnu_deleteSelectedNodes "Delete Selected Nodes (Del)"
		)
		
		
		
		subMenu "View"
		(
			menuitem mnu_autoReorderToggle "Auto-Reorder - Toggle (Ctrl+R)" checked:MagmaFlowSettings.AutoReorderToggle 
			menuitem mnu_acceptAutoOrder "Accept Auto-Reorder Results as Free Order (Ctrl+Shift+R)" enabled:MagmaFlowSettings.AutoReorderToggle 
			
			/*			
			subMenu "Reorder Patterns..."
			(
				menuitem mnu_autoReorderRow "Row Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #row)
				menuitem mnu_autoReorderAlignToTop "Top Aligned Row Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #rowtopalign)
				menuitem mnu_AutoReorderWeighted "Weighted Row Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #rowweighted)
				menuitem mnu_autoReorderPyramidal "Pyramidal Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #pyramidal)
				menuitem mnu_autoReorderTree "Tree Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #tree)
				menuitem mnu_autoReorderVTree "Vertical Tree Pattern" checked:(MagmaFlowSettings.AutoReorderPattern == #vtree)
			)	
			

			menuitem mnu_AllowSocketFlipping "Allow Socket Auto-Flipping On Reorder - Toggle" checked:MagmaFlowSettings.AllowSocketFlipping
			subMenu "Flip Sockets Of..."
			(
				menuitem mnu_InputsLeft "All Input Nodes Out Sockets Left" 
				menuitem mnu_InputsRight "All Input Nodes Out Sockets Right" 
				menuitem mnu_OperatorsLeft "All Operator Nodes Out Sockets Left" 
				menuitem mnu_OperatorsRight "All Operator Nodes Out Sockets Right" 
			)

			*/
			separator sep_110
			subMenu "Unconnected Nodes Auto-Placement..."
			(
				menuItem mnu_nodesLeft "Left Side Of Flow" checked: (MagmaFlowSettings.UnconnectedNodesPlacement == #left)
				--menuItem mnu_nodesRight "Right Side Of Flow" checked: (MagmaFlowSettings.UnconnectedNodesPlacement == #right)
				menuItem mnu_nodesBottom "Bottom Of Flow" checked: (MagmaFlowSettings.UnconnectedNodesPlacement == #bottom)
			)		
			
			separator sep_120
			menuItem mnu_showInputSocketName "Show NAMES Of Connected Input Sockets" checked:(MagmaFlowSettings.showInputSocketName == true)
			menuItem mnu_showInputSocketValue "Show VALUES Of Connected Input Socket" checked:(MagmaFlowSettings.showInputSocketValue == true)
			
			menuItem mnu_showTextureMapSample "Show Texture Map SAMPLES In Nodes" checked:(MagmaFlowSettings.showTextureMapSample == true)
			menuItem mnu_showColorSwatchSample "Show COLOR SWATCHES In InputVector Nodes" checked:(MagmaFlowSettings.showColorSwatchSample == true)
			
			menuItem mnu_AllowSubtreeCollapsing "Allow Sub-Tree COLLAPSING On Double-Click" checked:(MagmaFlowSettings.AllowSubtreeCollapsing == true)
			
			
			separator sep_130
			menuItem mnu_AlignAllNodesToGrid "ALIGN All Nodes To Grid (Shift+Ctrl+A)" 
			menuItem mnu_SnapToGrid "SNAP To Grid - Toggle (Ctrl+G)" checked:MagmaFlowSettings.SnapToGrid
			
			/*
			separator sep_140
			menuitem mnu_AutoZoomExtents "Auto-Zoom Extents - Toggle" checked:MagmaFlowSettings.AutoZoomExtents
			menuItem mnu_ZoomExtents "Zoom Extents (Z)"
			menuItem mnu_ZoomExtentsSelected "Zoom Extents Selected (Shift+Z)"			
			separator sep_150
			menuItem mnu_resetZoom "Reset Zoom (X)"
			menuitem mnu_resetPan "Reset Pan (Shift+X)"
			*/
			
			
			separator sep_160
			subMenu "Depot Display..."
			(
				menuItem mnu_DepotOff "Depot Off" checked: (MagmaFlowSettings.DepotPlacement == #off)
				menuItem mnu_DepotLeft "Depot On Left" checked: (MagmaFlowSettings.DepotPlacement == #left)
				menuItem mnu_DepotBottom "Depot At Bottom" checked: (MagmaFlowSettings.DepotPlacement == #bottom)
				--menuItem mnu_DepotBottomRollup "Depot At Bottom - Rollup" checked: (MagmaFlowSettings.DepotPlacement == #bottomrollup)
				menuItem mnu_DepotBottomRollupReverse "Depot At Bottom - Rollup" checked: (MagmaFlowSettings.DepotPlacement == #bottomrollupreverse)
				separator sep_180
				menuItem mnu_DepotShowBLOPs "Show BlackOp Categories In Depot" checked:MagmaFlowSettings.DepotShowBLOPs
				separator sep_185
				menuItem mnu_DepotShowCategories "Use Depot Categories" checked:MagmaFlowSettings.DepotShowCategories
				menuItem mnu_DepotAutoCollapseOnDragAndDrop "Auto-Collapse Categories On DragAndDrop" checked:MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop
			)	
		)

		on mnu_DepotAutoCollapseOnDragAndDrop picked do 
		(
			MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop = not MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)	

		on mnu_DepotShowCategories picked do 
		(
			MagmaFlowSettings.DepotShowCategories = not MagmaFlowSettings.DepotShowCategories
			if not MagmaFlowSettings.DepotShowCategories and (MagmaFlowSettings.DepotPlacement == #bottomrollup or MagmaFlowSettings.DepotPlacement == #bottomrollupreverse) do 
			(
				MagmaFlowSettings.DepotPlacement = #bottom
			)	
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)			
		
		on mnu_nodesLeft picked do 
		(
			MagmaFlowSettings.UnconnectedNodesPlacement = #left
			MagmaFlowEditor_Rollout.autoReorderFlow()
			MagmaFlowEditor_Rollout.updateNavigator()
		)
		on mnu_nodesBottom picked do 
		(
			MagmaFlowSettings.UnconnectedNodesPlacement = #bottom
			MagmaFlowEditor_Rollout.autoReorderFlow()
			MagmaFlowEditor_Rollout.updateNavigator()
		)
		
		on mnu_selectAllNodes picked do MagmaFlowEditor_Rollout.selectAllNodes()
		on mnu_invertSelection picked do MagmaFlowEditor_Rollout.invertSelection()
		on mnu_deselectAllNodes picked do MagmaFlowEditor_Rollout.deselectAllNodes()
		on mnu_selectUnconnectedNodes picked do MagmaFlowEditor_Rollout.selectUnconnectedNodes()
		
		on mnu_AllowSubtreeCollapsing picked do
		(
			MagmaFlowSettings.AllowSubtreeCollapsing  = not MagmaFlowSettings.AllowSubtreeCollapsing
			MagmaFlowEditor_Rollout.collapseBranches()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)
		
		on mnu_showTextureMapSample picked do 
		(
			MagmaFlowSettings.showTextureMapSample = not MagmaFlowSettings.showTextureMapSample 
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow()
			MagmaFlowEditor_Rollout.updateNavigator()
		)
		on mnu_showColorSwatchSample picked do 
		(
			MagmaFlowSettings.showColorSwatchSample = not MagmaFlowSettings.showColorSwatchSample 
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.autoReorderFlow()
			MagmaFlowEditor_Rollout.updateNavigator()
		)
		
		on mnu_showInputSocketName picked do 
		(
			MagmaFlowSettings.showInputSocketName = not MagmaFlowSettings.showInputSocketName 
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		on mnu_showInputSocketValue picked do 
		(
			MagmaFlowSettings.showInputSocketValue = not MagmaFlowSettings.showInputSocketValue
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)
		
		on mnu_close picked do
		(
			destroyDialog MagmaFlowEditor_Rollout
		)
		
		on mnu_new picked do
		(
			if (querybox "Are you sure you want to reset the flow and start a NEW one?" title:"New Flow?") do
			(
				magma.reset()
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.createUndoRecord "New Flow"
			)
		)
		
		on mnu_open picked do
		(
			makeDir (theUserFolder+ "\\MagmaFlows\\") all:true
			local theFileName = getOpenFileName caption:"Load Krakatoa MagmaFlow File" filename:(theUserFolder + "\\MagmaFlows\\") types:"Krakatoa MagmaFlow File (*.KMF)|*.KMF|All Files (*.*)|*.*" historyCategory:"MagmaFlows"
			if theFileName != undefined do
			(
				for i in EditableBlopStack do magma.PopEditableBLOP()
				EditableBlopStack = #()				
				MagmaFlowEditor_Functions.convertKMF magma theFile:theFileName 
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.autoReorderFlow()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.createUndoRecord ("Load Flow ["+filenameFromPath theFileName+"]")
			)
		)

		on mnu_AlignAllNodesToGrid picked do MagmaFlowEditor_Rollout.alignAllNodesToGrid()
		on mnu_autoReorderFlow picked do MagmaFlowEditor_Rollout.reorder_dot()
		
		on mnu_exitBlop picked do
		(
			if (magma.NumEditingBLOPs() > 0) do
			(
				magma.PopEditableBLOP()
				deleteItem EditableBlopStack EditableBlopStack.count
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
			)
		)

		on mnu_insertMode picked do 
		(
			MagmaFlowEditor_Rollout.toggleInsertMode()
			--MagmaFlowEditor_Rollout.updateEditorTitle()
		)

		on mnu_exportasmxs picked do 
		(
			makeDir (theUserFolder+ "\\MagmaFlows\\") all:true
			local theFileToSave = getSaveFileName filename:(theUserFolder+ "\\MagmaFlows\\Flow") types:"Magma Script (*.MagmaScript)|*.MagmaScript" historyCategory:"MagmaFlows"
			if theFileToSave != undefined do
			(
				for i = 1 to magma.NumEditingBLOPs() do magma.PopEditableBLOP() --get out to top level
				local theFlowScript = MagmaFlowEditor_Functions.emitMAXScriptCode magma
				local theFileHandle = createFile theFileToSave 
				format "%\n" theFlowScript to:theFileHandle 
				close theFileHandle
				for i in EditableBlopStack do magma.pushEditableBLOP i		
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()					
			)
		)
		on mnu_exportSelectedAsMXS picked do 
		(
			local theSelection = MagmaFlowEditor_Rollout.getSelectedNodes()
			if theSelection.count > 0 do
			(
				makeDir (theUserFolder+ "\\MagmaFlows\\") all:true
				local theFileToSave = getSaveFileName filename:(theUserFolder + "\\MagmaFlows\\FlowComponent") types:"Magma Script (*.MagmaScript)|*.MagmaScript" historyCategory:"MagmaFlows"
				if theFileToSave != undefined do
				(
					local theFlowScript = MagmaFlowEditor_Functions.emitMAXScriptCode magma specificNodes:theSelection
					local theFileHandle = createFile theFileToSave 
					format "%\n" theFlowScript to:theFileHandle 
					close theFileHandle
					MagmaFlowEditor_Rollout.displaySelectedNodeProperties()	
				)
			)
		)		
		
		on mnu_exploreFolder picked do
		(
			local theDir = (theUserFolder+ "\\MagmaFlows\\")
			makeDir theDir all:true
			shellLaunch theDir ""
		)
		
		on mnu_undo  picked do MagmaFlowEditor_Rollout.undoLastStep()
		on mnu_redo picked do MagmaFlowEditor_Rollout.redoLastStep()
		
		on mnu_copyToClipboard  picked do
			MagmaFlowEditor_Rollout.copySelectionToClipboard()
		
		on mnu_pasteFromClipboard picked do
			MagmaFlowEditor_Rollout.pasteSelectionFromClipboard preserveWires:false
		
		on mnu_pasteFromClipboardAndKeepWires picked do
			MagmaFlowEditor_Rollout.pasteSelectionFromClipboard preserveWires:true
		
		on mnu_replacemxs picked do
		(
			makeDir (theUserFolder+ "\\MagmaFlows\\") all:true
			local theFileToLoad = getOpenFileName filename:(theUserFolder + "\\MagmaFlows\\") types:"Magma Script (*.MagmaScript)|*.MagmaScript" historyCategory:"MagmaFlows"
			if theFileToLoad != undefined do
			(
				magma.Reset()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				::magmaNode = magma
				fileIn theFileToLoad
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
				MagmaFlowEditor_Rollout.createUndoRecord ("Load Flow ["+filenameFromPath theFileToLoad+"]")
			)
		)
		on mnu_mergemxs picked do
		(
			makeDir (theUserFolder+ "\\MagmaFlows\\") all:true
			local theFileToLoad = getOpenFileName filename:(theUserFolder + "\\MagmaFlows\\") types:"Magma Script (*.MagmaScript)|*.MagmaScript" historyCategory:"MagmaFlows"
			if theFileToLoad != undefined do
			(
				local oldCount = magma.getNumNodes()
				::magmaNode = magma
				fileIn theFileToLoad
				for i = oldCount+1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					magma.setNodeProperty theID "Position" ((magma.getNodeProperty theID "Position")+[0,100])
				)
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
				MagmaFlowEditor_Rollout.createUndoRecord ("Merge Flow ["+filenameFromPath theFileToLoad+"]")
			)
		)		
		
		on mnu_DepotOff picked do 
		(
			MagmaFlowSettings.DepotPlacement = #off
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)
		on mnu_DepotLeft picked do 
		(
			MagmaFlowSettings.DepotPlacement = #left
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)		
		on mnu_DepotBottom picked do 
		(
			MagmaFlowSettings.DepotPlacement = #bottom
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)	
		on mnu_DepotBottomRollup picked do 
		(
			MagmaFlowSettings.DepotPlacement = #bottomrollup
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)	
		on mnu_DepotBottomRollupReverse picked do 
		(
			MagmaFlowSettings.DepotPlacement = #bottomrollupreverse
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true
		)			
		
		subMenu "Expose"
		(
			menuitem mnu_selectExposedInputs "SELECT Exposed Inputs"
			menuitem mnu_UnExposeSelectedInputs "UNEXPOSE Selected Inputs"
			menuitem mnu_ExposeSelectedInputs "EXPOSE Selected Inputs"
			separator sep_200
			menuitem mnu_updateExposedInputs "UPDATE Exposed Inputs"
			--separator sep_300
			--menuitem mnu_autoRenameModifier "AUTO-RENAME Modifier" checked:(try(not magma.AutomaticRenameOFF)catch(true))
		)
		
		/*
		on mnu_autoRenameModifier picked do
		(
			try
			(
				magma.AutomaticRenameOFF = not magma.AutomaticRenameOFF
				MagmaFlowEditor_Rollout.UpdateMagmaHolder()
			)catch()
		)
		*/
		
		on mnu_ExposeSelectedInputs picked do
		(
			MagmaFlowEditor_Rollout.exposeControlsToModifier()
		)
		
		on mnu_selectExposedInputs picked do MagmaFlowEditor_Rollout.selectExposedInputs()
		on mnu_UnExposeSelectedInputs picked do MagmaFlowEditor_Rollout.exposeSelectedInputs newState:false
		on mnu_ExposeSelectedInputs picked do MagmaFlowEditor_Rollout.exposeSelectedInputs newState:true
		on mnu_updateExposedInputs picked do MagmaFlowEditor_Rollout.exposeControlsToModifier()
		
		
		
		
		/*
		subMenu "Macro"
		(
			menuItem mnu_convertUndoBufferToRecording "Save Undo Buffer As A Macro Recording..."
			separator sep_222
			menuItem mnu_LoadMacroRecording "Load Macro Recording..."
			separator sep_226
			menuitem mnu_EditMacro "Edit Macro" enabled:(KrakatoaChannelEditor_MacroRecording.count > 0)
		)
		*/
		subMenu "Debug"
		(
			menuItem mnu_debugFlow "Debug Mode" checked:MagmaFlowSettings.DebugModeOn
			menuItem mnu_updateDebugDialog "Force Debug Dialog Update" enabled:MagmaFlowSettings.DebugModeOn
		)		
		on mnu_updateDebugDialog picked do MagmaFlowEditor_DebugRollout.updateDialog()
		
		on mnu_debugFlow picked do 
		(
			MagmaFlowSettings.DebugModeOn = not MagmaFlowSettings.DebugModeOn
			MagmaFlowEditor_Rollout.debugFlow()
		)
		
		on mnu_AutoReorderToggle picked do
		(
			MagmaFlowEditor_Rollout.ReorderToggle()
		)
		
		on mnu_acceptAutoOrder picked do
		(
			MagmaFlowEditor_Rollout.AcceptReorderedFlow()
		)
	)
	
	rcmenu InsertNode_RCMenu
	(
		menuitem mnu_insertNodeIntoFlow "Insert Into Flow - Enable, then Click a Free Operator to Insert..." checked:MagmaFlowSettings.insertNodeIntoFlow
		on mnu_insertNodeIntoFlow  picked do
		(
			MagmaFlowSettings.insertNodeIntoFlow = not MagmaFlowSettings.insertNodeIntoFlow
		)
	)
	
	rcmenu AddNode_RCMenu 
	(
		fn isBlopEditing = (MagmaFlowSettings.NumEditingBLOPs > 0)
		fn CanPasteFromWindowsClipboard =
		(
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*" 
		)
		fn CanPasteFromWindowsClipboardAndKeepWires =
		(
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*" AND trackID == ::magmaClipBoardId
		)		
		
		menuitem mnu_exitBlop "Exit BLOP Editing" filter:isBlopEditing
		separator sep_10 filter:isBlopEditing
		menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" enabled:(CanPasteFromWindowsClipboard())
		menuItem mnu_pasteFromClipboardAndKeepWires "Paste And Preserve Connections (Ctrl+Alt+V)" enabled:(CanPasteFromWindowsClipboardAndKeepWires())
		separator sep_20 
		menuItem mnu_addOutputNode "Create Output Node (Ctrl+O)" 
		separator sep_30 	
		menuItem mnu_createAnyNode "Create Nodes Menu... (`)" 
			
		on mnu_pasteFromClipboard  picked do
			MagmaFlowEditor_Rollout.pasteSelectionFromClipboard preserveWires:false
		on mnu_pasteFromClipboardAndKeepWires  picked do
			MagmaFlowEditor_Rollout.pasteSelectionFromClipboard preserveWires:true
		
		on mnu_addOutputNode picked do
		(
			MagmaFlowEditor_Rollout.addNewOutputChannel()
			setFocus MagmaFlowEditor_Rollout.hc
		)
		
		on mnu_createAnyNode picked do
		(
			MagmaFlowEditor_Rollout.showRCMenu #allNodes
		)
		
		on mnu_exitBlop picked do
		(
			if (magma.NumEditingBLOPs() > 0) do
			(
				magma.PopEditableBLOP()
				deleteItem EditableBlopStack EditableBlopStack.count
				MagmaFlowEditor_Rollout.restorePanAndZoom()
				MagmaFlowEditor_Rollout.createNodeTree init:true
				MagmaFlowEditor_Rollout.updateEditorTitle()
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
			)
		)		
	)
	rcmenu DepotNode_RCMenu
	(
		fn categoriesOn = (MagmaFlowSettings.DepotShowCategories)
		menuItem mnu_DepotOff "Depot Off" checked: (MagmaFlowSettings.DepotPlacement == #off)
		menuItem mnu_DepotLeft "Depot On Left" checked: (MagmaFlowSettings.DepotPlacement == #left)
		menuItem mnu_DepotBottom "Depot At Bottom" checked: (MagmaFlowSettings.DepotPlacement == #bottom)
		--menuItem mnu_DepotBottomRollup "Depot At Bottom - Rollup" checked: (MagmaFlowSettings.DepotPlacement == #bottomrollup)
		menuItem mnu_DepotBottomRollupReverse "Depot At Bottom - Rollup" checked: (MagmaFlowSettings.DepotPlacement == #bottomrollupreverse)
		separator sep_10
		menuItem mnu_DepotShowBLOPs "Show BlackOp Categories In Depot" checked:MagmaFlowSettings.DepotShowBLOPs
		separator sep_20
		menuItem mnu_DepotShowCategories "Use Depot Categories" checked:MagmaFlowSettings.DepotShowCategories
		menuItem mnu_DepotAutoCollapseOnDragAndDrop "Auto-Collapse Categories On DragAndDrop" checked:MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop
		separator sep_30 filter:categoriesOn
		menuItem mnu_expandAllCategories "Expand All Categories (Shift+Click Category)" filter:categoriesOn
		menuItem mnu_collapseAllCategories "Collapse All Categories (Ctrl+Shift+Click Category)" filter:categoriesOn
		
		on mnu_collapseAllCategories picked do
		(
			for j = 1 to MagmaFlowEditor_Rollout.DepotDefinition.count where MagmaFlowEditor_Rollout.DepotDefinition[j][1][1]  == "HEAD" do
				MagmaFlowEditor_Rollout.DepotDefinition[j][1][6] = false
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
			--if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false			
		)

		on mnu_expandAllCategories picked do
		(
			for j = 1 to MagmaFlowEditor_Rollout.DepotDefinition.count where MagmaFlowEditor_Rollout.DepotDefinition[j][1][1]  == "HEAD" do
				MagmaFlowEditor_Rollout.DepotDefinition[j][1][6] = true
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
			--if AutoZoomExtents do KrakatoaChannelNodeEditor_Rollout.zoomExtents createUndo:false
		)		
		
		
		on mnu_DepotShowCategories picked do 
		(
			MagmaFlowSettings.DepotShowCategories = not MagmaFlowSettings.DepotShowCategories
			if not MagmaFlowSettings.DepotShowCategories and (MagmaFlowSettings.DepotPlacement == #bottomrollup or MagmaFlowSettings.DepotPlacement == #bottomrollupreverse) do 
			(
				MagmaFlowSettings.DepotPlacement = #bottom
			)	
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)		

		on mnu_DepotAutoCollapseOnDragAndDrop picked do 
		(
			MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop = not MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)			
		
		on mnu_DepotShowBLOPs picked do 
		(
			MagmaFlowSettings.DepotShowBLOPs = not MagmaFlowSettings.DepotShowBLOPs
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)			
		
		on mnu_DepotOff picked do 
		(
			MagmaFlowSettings.DepotPlacement = #off
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)	
		on mnu_DepotLeft picked do 
		(
			MagmaFlowSettings.DepotPlacement = #left
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)	
		on mnu_DepotBottom picked do 
		(
			MagmaFlowSettings.DepotPlacement = #bottom
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)			
		on mnu_DepotBottomRollup picked do
		(
			MagmaFlowSettings.DepotPlacement = #bottomrollup
			MagmaFlowSettings.DepotShowCategories = true
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)
		on mnu_DepotBottomRollupReverse picked do
		(
			MagmaFlowSettings.DepotPlacement = #bottomrollupreverse
			MagmaFlowSettings.DepotShowCategories = true
			MagmaFlowEditor_Rollout.CreateDepot()
			MagmaFlowEditor_Rollout.updateDepotDefinition()
			MagmaFlowEditor_Rollout.createNodeTree init:true			
		)	
	)	
	
	rcmenu EditNode_RCMenu 
	(
		fn isOperatorUnderMouse = true --( (MagmaFlowEditor_Rollout.lastNodeClick > 0 and (magma.GetNodeType (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)) == "Operator") )
		fn isInputUnderMouse = true --( (KrakatoaChannelNodeEditor_Rollout.lastNodeClick > 1 and KrakatoaChannelEditor_DisplayNodeTreeData[KrakatoaChannelNodeEditor_Rollout.lastNodeClick][1] == "Input") )
		fn anythingSelected =((MagmaFlowEditor_Rollout.getSelectedNodes()).count > 0)
		fn moreThanOneSelected = ((MagmaFlowEditor_Rollout.getSelectedNodes()).count > 1)
		fn canExposeControl = try((magma.GetNodeType (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)) == "InputValue") catch(false)
		fn isBlackopUnderMouse = try((magma.GetNodeType (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)) == "BLOP")catch(false)
		fn isBlackopOrSelection = isBlackopUnderMouse() or anythingSelected()
		fn canPaste =
		(
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*" 
		)
		fn canPasteOrSelected = (canPaste() or anythingSelected())
		fn isInBlackOpEditingMode = false --(KrakatoaChannelEditor_NodeTreeEditingLevel.count > 0)
		fn moreThanOneSelectedOrBLOP = (moreThanOneSelected() or isBlackopUnderMouse())
		
		menuItem mnu_endEditingBLOP "Exit BlackOp Editing Mode" filter:isInBlackOpEditingMode
		separator sep_1 filter:isInBlackOpEditingMode
		
		menuItem mnu_editBLOP "Edit BlackOp" filter:isBlackopUnderMouse
		--menuItem mnu_closeBLOP "Close BlackOp" filter:isBlackopOpen
			
		menuItem mnu_addNewBLOPInline "[BlackOp] From Selection" filter:anythingSelected
		--menuItem mnu_saveBLOPDefinition "Save Selection As BlackOP" filter:anythingSelected
		menuItem mnu_explodeBLOP "Explode BlackOp" filter:isBlackopUnderMouse
		separator sep_10 filter:isBlackopOrSelection
		
		menuItem mnu_exposeControl "Expose Control" filter:canExposeControl  checked:(try(magma.getNodeProperty (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick) "Exposed" == true)catch(false))
		menuitem mnu_selectExposedInputs "Select Exposed Inputs"
		subMenu "Expose Selected..." filter:anythingSelected
		(
			menuitem mnu_UnExposeSelectedInputs "Unexpose Selected Inputs"
			menuitem mnu_ExposeSelectedInputs "Expose Selected Inputs"
			separator sep_500
			menuitem mnu_updateExposedInputs "Update Exposed Inputs"
		)
		
		separator sep_2 --filter:canExposeControl
		
		menuItem mnu_disconnectAllInputs "Disconnect All Inputs of This Node"	
		menuItem mnu_disconnectAllOutputs "Disconnect All Outputs of This Node"	
		menuItem mnu_disconnectAllInputsOutputs "Disconnect All Inputs and Outputs of This Node"	
		separator sep_50  filter:anythingSelected
		menuItem mnu_disconnectAllInputsSel "Disconnect All Inputs of Selected Nodes"	filter:anythingSelected
		menuItem mnu_disconnectAllOutputsSel "Disconnect All Outputs of Selected Nodes" filter:anythingSelected
		menuItem mnu_disconnectAllInputsOutputsSel "Disconnect All Inputs and Outputs of Selected Nodes" filter:anythingSelected
		
		separator sep_100 --filter:isBlackopOrSelection
		
		menuItem mnu_copyToClipboard "Copy Selected Nodes (Ctrl+C)" filter:anythingSelected
		menuItem mnu_pasteFromClipboard "Paste (Ctrl+V)" filter:canPaste
		
		separator sep_200 filter:canPasteOrSelected
		menuItem mnu_swapInputs "Swap First Two Inputs (Ctrl+W)" filter:isOperatorUnderMouse
		menuItem mnu_swapLastInputs "Swap Last Two Inputs (Shift+Ctrl+W)" filter:isOperatorUnderMouse
		separator sep_300 filter:isOperatorUnderMouse
		
		menuItem mnu_flipSocketPosition "Flip Socket Position" --filter:isInputUnderMouse
		separator sep_310 --filter:isInputUnderMouse
		
		menuItem mnu_toggleNode "Toggle Node On/Off"		
		menuItem mnu_toggleNodeSel "Toggle Selected Nodes On/Off (Ctrl+P)"		

		separator sep_400

		
		menuItem mnu_deleteNode "Delete Node Under Mouse Pointer"	
		menuItem mnu_deleteSelectedNodes "Delete Selected Nodes (Del.)" filter:anythingSelected
		

		on mnu_editBLOP  picked do 
		(
			local theID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			append EditableBlopStack theID
			magma.PushEditableBLOP theID
			MagmaFlowEditor_Rollout.restorePanAndZoom()
			MagmaFlowEditor_Rollout.createNodeTree init:true
			MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true
			MagmaFlowEditor_Rollout.createUndoRecord ("Edit BLOP [" + theID as string+"]")
			MagmaFlowEditor_Rollout.createNodeTree init:false
		)

		on mnu_flipSocketPosition picked do
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			magma.DeclareExtensionProperty theID "FlipSocketPosition"
			local oldValue = magma.getNodeProperty theID "FlipSocketPosition"
			if oldValue == undefined do oldValue = false
			oldValue = not oldValue 
			magma.setNodeProperty theID "FlipSocketPosition" oldValue 
			MagmaFlowEditor_Rollout.createNodeTree init:false
			MagmaFlowEditor_Rollout.createUndoRecord "Flip Socket Position"	
		)
		
		on mnu_UnExposeSelectedInputs picked do
			MagmaFlowEditor_Rollout.exposeSelectedInputs newState:false
		on mnu_ExposeSelectedInputs picked do
			MagmaFlowEditor_Rollout.exposeSelectedInputs newState:true
		on mnu_updateExposedInputs picked do
			MagmaFlowEditor_Rollout.exposeControlsToModifier()
		on mnu_selectExposedInputs picked do
			MagmaFlowEditor_Rollout.selectExposedInputs()		
		
		on mnu_explodeBLOP picked do 
		(
			local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
			if theID != undefined do MagmaFlowEditor_Rollout.explodeBLOP theID
		)

		on mnu_addNewBLOPInline picked do
			MagmaFlowEditor_Rollout.createBLOPInline creationType:#rcmenu 		

		on mnu_disconnectAllInputs picked do
			MagmaFlowEditor_Rollout.disconnectAllInputs Single:true
		
		on mnu_disconnectAllOutputs picked do
			MagmaFlowEditor_Rollout.disconnectAllOutputs Single:true
		
		on mnu_disconnectAllInputsOutputs picked do
		(
			MagmaFlowEditor_Rollout.disconnectAllInputs Single:true
			MagmaFlowEditor_Rollout.disconnectAllOutputs Single:true
		)

		on mnu_disconnectAllInputsSel picked do
			MagmaFlowEditor_Rollout.disconnectAllInputs Single:false
		
		on mnu_disconnectAllOutputsSel picked do
			MagmaFlowEditor_Rollout.disconnectAllOutputs Single:false
		
		on mnu_disconnectAllInputsOutputsSel  picked do
		(
			MagmaFlowEditor_Rollout.disconnectAllInputs Single:false
			MagmaFlowEditor_Rollout.disconnectAllOutputs Single:false
		)

		on mnu_copyToClipboard  picked do
			MagmaFlowEditor_Rollout.copySelectionToClipboard()
		
		on mnu_pasteFromClipboard  picked do
			MagmaFlowEditor_Rollout.pasteSelectionFromClipboard()		

		on mnu_swapInputs picked do MagmaFlowEditor_Rollout.swapInputsOrder Single:true
		on mnu_swapLastInputs picked do MagmaFlowEditor_Rollout.swapInputsOrder Single:true Last:true

		on mnu_toggleNode picked do
			MagmaFlowEditor_Rollout.setPassThrough Single:true
		on mnu_toggleNodeSel picked do
			MagmaFlowEditor_Rollout.setPassThrough Single:false
		
		on mnu_exposeControl picked do
		(
			if MagmaFlowEditor_Rollout.lastNodeClick > 1 do
			(
				local ID = (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
				magma.DeclareExtensionProperty ID "Exposed"
				local state = magma.getNodeProperty ID "Exposed" 
				if state == undefined do state = true
				state = not state
				magma.setNodeProperty ID "Exposed" state
				MagmaFlowEditor_Rollout.exposeControlsToModifier()
				MagmaFlowEditor_Rollout.createNodeTree init:false
				MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
			)
		)
		
		on mnu_deleteNode picked do
		(
			local needUpdate = false
			local needExpose = false
			if MagmaFlowEditor_Rollout.lastNodeClick > 1 do
			(
				local theID = magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick
				if theID != undefined do --if the ID is valid, in other words not a Depot item
				(
					local theType = magma.getNodeType theID
					if theType != undefined do --and theType != "OutputConnector" and theType != "Output" do
					(
						needUpdate = true
						if magma.getNodeProperty theID "Exposed" == true do needExpose = true
						magma.deleteNode theID
						for i = 1 to magma.getNumNodes() do
						(
							local theIDtoCheck = magma.getNodeID i
							for c = 1 to magma.getNumNodeInputs theIDtoCheck do
								if (magma.getNodeInput theIDtoCheck c)[1] == theID do 
									magma.setNodeInput theIDtoCheck c -1 1
						)--end i loop
					)--end if type	
				)--end if ID 
				if needExpose == true do MagmaFlowEditor_Rollout.exposeControlsToModifier()
				if needUpdate do
				(
					--createUndoRecord ("Delete Node")				
					MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
					--if AutoZoomExtents do zoomExtents createUndo:false
					MagmaFlowEditor_Rollout.displaySelectedNodeProperties()
				)	
				MagmaFlowEditor_Rollout.createNodeTree init:true		
				MagmaFlowEditor_Rollout.updateNavigator fullUpdate:true				
			)	
		)
		on mnu_deleteSelectedNodes picked do
		(
			MagmaFlowEditor_Rollout.deleteSelectedNodes()
		)		
	)	
	
	
	rollout MagmaFlowEditor_Rollout "Krakatoa MagamFlow Editor" width:1000 height:700
	(
		--LOCAL VARIABLE DEFINITIONS
		local currentMagmaNode
		local drawDepot, getSelectedNodes, setSelectedNodes, displaySelectedNodeProperties, updateMagmaHolder, createNodeTree, updateEditorTitle
		local storePanAndZoom, restorePanAndZoom, autoReorderFlow, updateNavigator, alignAllNodesToGrid, exposeControlsToModifier, toggleInsertMode
		local createUndoRecord, undoLastStep, redoLastStep, CollapseBranches, updateInsertMode
		local showRCMenu
		local NodeIDMap = #()
		local lastSelection = #(0)
		local lastSelectionBeforeClick = #()
		local lastMouseClick = [0,0]
		local lastNodeClick = -1
		local DepotNodes = #()
		local DepotDefinition = #()		
		local DepotCategories = #()
		local leftDepotMargin = 0
		local DisableDragAndDrop = false
		local lastInfoMessage = ""
		local ConnectToEmpty_fromID = -1
		local ConnectToEmpty_Index = -1
		local ConnectToEmpty_SocketType = #none
		local lastWireSelection = #()
		
		local dotnetSystemInfo = dotNetClass "System.Windows.Forms.SystemInformation"
		
		ThinkboxSchematicControl hc "" width:800 height:600 pos:[0,0] 
		progressbar prg_bar width:176 height:6 pos:[0,0] color:red value:100 visible:false
		subRollout NodePropsSR width:180 height:600 pos:[800,0]
		bitmap bmp_navigator width:180 height:100 pos:[800,0]
		edittext edt_log width:800 pos:[0,0]
		
		button btn_Undo "Undo" width:39 height:18 tooltip:"Click to Undo; Right-Click to display Undo History"
		button btn_Redo "Redo" width:39 height:18 tooltip:"Click to Redo; Right-Click to display Redo History"
		
		
		checkbutton chk_autoUpdateModifier ">AUTO" width:61 height:20  pos:[800,1] 
		button btn_updateModifier "UPDATE" width:118 height:20  pos:[860,1] 

		button btn_RecorderToStart "|<" width:25 height:25 visible:false
		button btn_RecorderBackOneStep "<<" width:25 height:25 visible:false
		checkbutton chk_RecorderPlay "|>"  width:25 height:25 visible:false
		button btn_RecorderForwardOneStep ">>" width:25 height:25 visible:false
		button btn_RecorderToEnd ">|"width:25 height:25 visible:false
		button btn_RecorderClose "Close" width:50 height:25 visible:false
		


		fn saveSettings =
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")
			setIniSetting theIniFile "Depot" "Placement" (MagmaFlowSettings.DepotPlacement as string)
			setIniSetting theIniFile "Depot" "NodeWidth" (MagmaFlowSettings.DepotNodeWidth as string)
			setIniSetting theIniFile "Depot" "ShowCategories" (MagmaFlowSettings.DepotShowCategories as string)
			setIniSetting theIniFile "Depot" "AutoCollapseOnDragAndDrop" (MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop as string)
			setIniSetting theIniFile "Options" "UnconnectedNodesPlacement" (MagmaFlowSettings.UnconnectedNodesPlacement as string)
		)
		
		fn loadSettings =
		(
			local theIniFile = (theIniFileLocation + "MagmaFlowEditor_Preferences.ini")
			
			local theVal = getIniSetting theIniFile "Depot" "Placement" 
			if theVal == "" do theVal = #bottomrollupreverse
			MagmaFlowSettings.DepotPlacement = theVal as name
			if MagmaFlowSettings.DepotPlacement == #bottomrollup do MagmaFlowSettings.DepotPlacement = #bottomrollupreverse --bottomrollup is currently removed
			
			local theVal = execute (getIniSetting theIniFile "Depot" "NodeWidth" )
			if theVal == OK do theVal = 80
			MagmaFlowSettings.DepotNodeWidth = theVal
			
			local theVal = execute (getIniSetting theIniFile "Depot" "ShowCategories" )
			if theVal == OK do theVal = true
			MagmaFlowSettings.DepotShowCategories = theVal 
			
			local theVal = execute (getIniSetting theIniFile "Depot" "AutoCollapseOnDragAndDrop" )
			if theVal == OK do theVal = true
			MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop = theVal 

			local theVal = (getIniSetting theIniFile "Options" "UnconnectedNodesPlacement" )
			if theVal == "" do theVal = "bottom"
			MagmaFlowSettings.UnconnectedNodesPlacement = theVal as name
		)

		fn updateErrorLog =
		(
			local theError = substituteString magma.lastErrorMessage "\n" " |"
			theError = substituteString theError "\t" " "
			try(edt_log.text = theError)catch(edt_log.text = "")
		)
		
		fn updateModifierName =
		(
			local theMod = (for i in refs.dependents magma where classof i == MagmaModifier collect i)[1]
			if theMod != undefined and not magma.AutomaticRenameOFF do
			(
				local theName = "Magma"
				for i = 1 to magma.getNumNodes() where magma.getNodeType (magma.getNodeID i) == "Output" do
					theName += "_"+substring (magma.getNodeProperty (magma.getNodeID i) "channelName") 1 3
				theMod.name = theName
				if modPanel.getCurrentObject() == theMod do modPanel.setCurrentObject theMod
			)
		)
		
		fn updateMagmaHolder init:true updateName:true update:true =
		(
			if magma.autoUpdate do 
			(
				magma.autoUpdate = magma.autoUpdate
				local theNodes = for i in refs.dependentNodes magma where classof i.baseobject == KrakatoaPRTLoader do try(i.delegate.InvalidateObjectSpaceCache())catch()
				--if updateName do updateModifierName()
			)
			redrawViews()
			if update do createNodeTree init:init
		)

		fn getMouseInSchematicView mode:#default =
		(
			lastMouseClick = if mode == #rcmenu then  --if the rcmenu was invoked, use its position for node creation
				NodeCreationMenuPosition
			else
				mouse.screenpos
			local theHeightOffset = try(dotnetSystemInfo.CaptionHeight + dotnetSystemInfo.MenuHeight + dotnetSystemInfo.FrameBorderSize.height)catch(50)
			if MagmaFlowEditor_Rollout.inViewport do 
				theHeightOffset = try(dotnetSystemInfo.MenuHeight+0)catch(19)
			local theWidthOffset = try(dotnetSystemInfo.FrameBorderSize.width)catch(3)
			(lastMouseClick - (getDialogPos MagmaFlowEditor_Rollout))-[theWidthOffset,theHeightOffset]
		)

		fn getOutputSocketName theID theIndex =
		(
			try
			(
			if theID < 0 do return "???"
			local theType = try(magma.getNodeType theID)catch("???")
			case theType as name of
			(
				#BLOPSocket:
				(
					theInputSocketNames[theIndex] as string
				)
				#BLOP:
				(
					local theSocketName = magma.getNodeProperty theID ("BLOPOutputSocketName"+theIndex as string)
					if theSocketName != undefined then theSocketName else ("Output "+theIndex as string + " ")
				)					
				#elbow: 
				(
					theOtherID = magma.getNodeInput theID 1
					getOutputSocketName theOtherID[1] theOtherID[2]
				)
				#inputChannel: magma.GetNodeProperty theID "channelName"
				#inputTexmap: (
					local theVal = magma.GetNodeProperty theID "texmap"
					if theVal == undefined then
						"<none>"
					else
						theVal as string
				)
				#inputValue: 
				( 
					local theVal = (magma.GetNodeProperty theID "controller").value 
					local isInt = (magma.GetNodeProperty theID "forceInteger") == true
					if classof theVal == Point3 then 
						"Vector:" + theVal as string
					else if isInt then 
						"Integer:" + (theVal as integer) as string
					else 
						"Float:" + theVal as string
				)
				#fromWorld: ("ObjectSpace ["+ (magma.getNodeProperty theID "inputType")[1] + "]")
				#toWorld: ("WorldSpace ["+ (magma.getNodeProperty theID "inputType")[1] + "]")
				#fromCamera: ("FromCamera ["+ (magma.getNodeProperty theID "inputType")[1] + "]")
				#toCamera: ("CameraSpace ["+ (magma.getNodeProperty theID "inputType")[1] + "]")
				#fromSpace: ( try ((magma.GetNodeProperty theID "node").name + "["+ (magma.getNodeProperty theID "inputType")[1] + "]" )catch("<None>" + "["+ (magma.getNodeProperty theID "inputType")[1] + "]") )
				#toSpace: ( try ((magma.GetNodeProperty theID "node").name + "["+ (magma.getNodeProperty theID "inputType")[1] + "]" )catch("<None>" + "["+ (magma.getNodeProperty theID "inputType")[1] + "]") )
				default: (
					if theType as name == #inputGeometry and theIndex == 1 then
					(
						local theNodes = (magma.GetNodeProperty theID "nodes")
						if theNodes == undefined do theNodes = #()
						
						if theNodes.count == 1 and isValidNode theNodes[1] then 
							theNodes[1].name
						else if theNodes.count == 0 then 
							"<None>" 
						else theNodes.count as string + " Geo.Objects"
					)
					else if theType as name == #inputObject and theIndex == 1 then 
					(
						( try ((magma.GetNodeProperty theID "object").name  )catch("<None>") )
					)
					else if theType as name == #inputParticles and theIndex == 1 then 
					(
						( try ((magma.GetNodeProperty theID "node").name  )catch("<None>") )
					)
					else
						magma.GetNodeOutputDescription theID theIndex 
				)
			)
			)catch("???")
		)
		
		fn getInputSocketName theID theSocket =
		(
			try(
			local OutOutputIndex = (magma.GetNodeInput theID theSocket)
			local theName = ""
			local theSocketName  = ""
			local theType = (magma.getNodeType theID) as name
			if theType == #BLOP then
			(
				theSocketName = magma.getNodeProperty theID ("BLOPInputSocketName"+theSocket as string)
				if theSocketName == undefined do theSocketName = "Input "  + theSocket as string
			)		
			else
			(
				theSocketName = magma.GetNodeInputDescription theID theSocket
				if theSocketName == undefined do theSocketName = ("Input "+ theSocket as string)
			)
			if MagmaFlowSettings.showInputSocketName do theName = theSocketName
			if OutOutputIndex[1] == -1 then 
			(
				theName = theSocketName
				local theDefaultValue = magma.getNodeInputDefaultValue theID theSocket
				if theDefaultValue != undefined do 
				(
					if not MagmaFlowSettings.showInputSocketName do theName = ""
					theName += " "+ theDefaultValue as string + ""
				)
			)
			else
			(
				if MagmaFlowSettings.showInputSocketValue do 
				(
					if MagmaFlowSettings.showInputSocketName do theName += " ("
					theName += getOutputSocketName OutOutputIndex[1] OutOutputIndex[2]
					if MagmaFlowSettings.showInputSocketName do theName += ")"
				)
			)
			)catch(theName = "???")
			theName
		)
		
		fn getInputSocketColor theID theSocket =
		(
			local OutOutputIndex = (magma.GetNodeInput theID theSocket)[1]
			local hasDefault = (magma.GetNodeInputDefaultValue theID theSocket) != undefined
			if OutOutputIndex == -1 then 
				if hasDefault then MagmaFlowColors.HasDefaultSocketColor else MagmaFlowColors.NeedsConnectionSocketColor 
			else
			(
				theType = try( (magma.getNodeType OutOutputIndex) as name )catch(#error)
				case theType of 
				(
					default: MagmaFlowColors.StandardSocketColor
					/*
					#InputValue: (
						local theVal = (magma.GetNodeProperty OutOutputIndex "controller").value 
						local isInt = magma.getNodeProperty OutOutputIndex "forceInteger"
						case classof theVal of
						(
							default: (if isInt then MagmaFlowColors.IntegerSocketColor else MagmaFlowColors.FloatSocketColor )
							Point3: MagmaFlowColors.VectorSocketColor
						)
					)
					#InputChannel: (
						MagmaFlowColors.StandardSocketColor
					)*/
					#error: MagmaFlowColors.ErrorSocketColor 
				)
			)
		)
		
		fn getOutputSocketColor theID theSocket =
		(
			for c = 1 to magma.getNumNodeInputs theID do
			(
				local OutOutputIndex = (magma.GetNodeInput theID c)[1]
				local hasDefault = (magma.GetNodeInputDefaultValue theID c) != undefined
				if OutOutputIndex == -1 then 
					if not hasDefault do return MagmaFlowColors.NeedsConnectionSocketColor 
			)
			
			theConnectedNodes = #()
			for i = 1 to magma.getNumNodes() do
			(
				theID2 = magma.getNodeID i
				for c = 1 to magma.getNumNodeInputs theID2 do
				(
					local theWire = magma.getNodeInput theID2 c 
					if theWire != undefined do
					(
						if theWire[1] == theID and theWire[2] == theSocket do append theConnectedNodes #(theID2,c)
					)
				)
			)
			
			--local theConnected = (magma.GetConnectedNodes theID)[theSocket]
			local theConnected = (magmaFlowEditor_Functions.getConnectedNodes magma theID)[theSocket]
			if theConnected == undefined do theConnected  = #()
			
			local theOutputConnections = #()
			for c in theConnected do 
			(
				local theWire = magma.getNodeInput c[1] c[2]
				theOutputConnections[theWire[2]] = c
			)
			if theOutputConnections[theSocket] != undefined then
			(
				if theOutputConnections[theSocket][1] < 0 then 
					color 0 100	0
				else
				(
					if magma.getNodeType theID == "InputValue" then
					(
						if (classof (magma.getNodeProperty theID "controller").value) == Float then
						(
							if magma.getNodeProperty theID "forceInteger" == true then
								MagmaFlowColors.IntegerSocketColor
							else
								MagmaFlowColors.FloatSocketColor 
						)
						else
							MagmaFlowColors.VectorSocketColor
					)
					else
						MagmaFlowColors.StandardSocketColor
				)
				--catch(MagmaFlowColors.StandardSocketColor)
			)else --MagmaFlowColors.StandardSocketColor
			if theConnectedNodes.count > 0 then
				color 140 140 200
			else
				color 0 150 0
		)		

		fn stampChildBranchConnected theChild theParent =
		(
			local parentState = magma.getNodeProperty theParent "Internal_NodeConnected" == true
			magma.setNodeProperty theChild "Internal_NodeConnected" parentState
			for c = 1 to magma.getNumNodeInputs theChild do
			(
				local theWire = magma.getNodeInput theChild c
				if theWire != undefined and theWire[1] > -1 do
				(
					stampChildBranchConnected theWire[1] theChild
				)
			)
		)			
		
		fn UpdateConnectivityInfo =
		(
			for i = 1 to magma.getNumNodes() do
			(
				local theID = magma.getNodeID i
				magma.declareExtensionProperty theID "Internal_NodeConnected"
				magma.setNodeProperty theID "Internal_NodeConnected" false
				--magma.declareExtensionProperty theID "Internal_ConnectedNodes"
				--magma.setNodeProperty theID "Internal_ConnectedNodes" #()
			)

			if magma.NumEditingBLOPs() > 0 then
			(
				local numBLOPOutputs = magma.GetNumNodeOutputs (magma.CurrentBLOP)
				for i = 1 to numBLOPOutputs do
				(				
					local theConnection = magma.getOutput i --get the output i
					local theConnectedID = theConnection[1] --get the ID of the node that is connected
					--format "% theConnection=% theConnectedID=%\n" i theConnection theConnectedID
					if theConnectedID != undefined and theConnectedID > -1 do
					(
						try
						(
							magma.setNodeProperty theConnectedID "Internal_NodeConnected" true
							for c = 1 to magma.getNumNodeInputs theConnectedID do
							(
								local theWire = magma.getNodeInput theConnectedID c
								if theWire != undefined and theWire[1] > -1 do
								(
									stampChildBranchConnected theWire[1] theConnectedID
								)
							)
						)
						catch
						(
							magma.setOutput i -1 -1 --fix BLOP Output Socket connected to deleted node
						)
					)
				)
			)
			else			
			(
				for i = 1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					--format "ID: %  Type: % Wire: %\n" theID ( magma.getNodeType theID) (magma.getNodeInput theID 1)
					if magma.getNodeType theID == "Output" do 
					(
						magma.setNodeProperty theID "Internal_NodeConnected" true
						local theWire = magma.getNodeInput theID 1
						if theWire != undefined and theWire[1] > -1 do
						(
							stampChildBranchConnected theWire[1] theID
						)
					)--end if output
				)
			)
		)		
	
		fn updateWireColorsOnly =
		(
			local st = timestamp()
			local nodeCount = magma.GetNumNodes()
			for n = 1 to nodeCount do 
			(
				local theID = magma.GetNodeID n
				local nodeNumber = theID as string
				local theType = magma.GetNodeType theID
				hc.activeNode = n
				
				local isSelected = (magma.getNodeProperty theID "Selected") == true
				
				local theOutCount = magma.GetNumNodeOutputs theID
				if theType == "Output" do theOutCount  = 0		
				local actualOutCount = theOutCount
				
				local isConnectedInFlow = magma.getNodeProperty theID "Internal_NodeConnected"
				if isConnectedInFlow == undefined do isConnectedInFlow = false				
				
				local st2 = timestamp()
				local theInCount = magma.GetNumNodeInputs theID
				
				--CREATE OUTPUT SOCKETS:
				local st2 = timestamp()
				local actualOutIndex = 0
				for i = 1 to theOutCount do
				(
					hc.activeSocket = theInCount + i
					hc.connectionColor = if i == MagmaFlowSettings.nodeInsertSocket and isSelected then
						MagmaFlowColors.HighlightedSocketColor * (if isConnectedInFlow then 1.0 else 0.75)
					else
						MagmaFlowColors.StandardSocketColor * (if isConnectedInFlow then 1.0 else MagmaFlowColors.DimmUnconnectedNode)
				)
			)--end node creation loop
			
			FranticParticles.LogDebug ("MagmaFlow: Update WIRES Only Took "+((timestamp()-st)) as string + " ms." )
			

			hc.redrawView
		)
		
		fn createNodeTree init:false specificNodeId: =
		(
			local st = timestamp()
			NodeIDMap = #()
			if init do UpdateConnectivityInfo()
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree UpdateConnectivityInfo() Call Took "+((timestamp()-st)) as string + " ms." )
			
			--CLEAR THE DISPLAY IF INITIALIZING:
			if init do
			(
				for i = hc.getNodeCount to 1 by -1 do 
				(
					hc.activeNode = i	
					hc.deleteActiveNode
				)
			)	

			local currentX = 100
			local currentY = 100
			local outputsCounter = 0
			
			local st1 = timestamp()
			local nodeCount = magma.GetNumNodes()
			for n = 1 to nodeCount do 
			(
				st2 = timestamp()
				local theID = magma.GetNodeID n
				if specificNodeId == unsupplied or specificNodeId == theID do
				(
					local nodeNumber = theID as string
					local isExposed = (magma.getNodeProperty theID "Exposed") == true
					
					NodeIDMap[n] = theID
					local theType = magma.GetNodeType theID

					if init do hc.addNode
					hc.activeNode = n
					hc.showMiniBitmap = false
					
					local theNodeName = ""
					if isExposed do theNodeName += "E"
					theNodeName +=nodeNumber + ":"	
					
					local theNameString = MagmaFlowEditor_Functions.getNodeName magma theID
					if theNameString == undefined then 
						theNodeName += theType
					else
						theNodeName += theNameString
					if (matchPattern theType pattern:"Output") do  theNodeName += " "+(outputsCounter+1) as string
					
					
					theNodeName += if magma.getNodeProperty theID "enabled" then "" else " [OFF]"
					
					hc.nodeName =  theNodeName
					if theType == "Elbow" do 	
					(
						case of
						(
							(MagmaFlowSettings.ElbowSize < 35): hc.nodeName = ""
							(MagmaFlowSettings.ElbowSize < 55): hc.nodeName = nodeNumber
							default:()
						)
					)
					local thePos = if MagmaFlowSettings.AutoReorderToggle then 
						(MagmaFlowEditor_Functions.getUIProperty magma theID "Internal_Position")
					else 
						(MagmaFlowEditor_Functions.getUIProperty magma theID "Position")
					hc.activeNodePos = if thePos == undefined then
					(
						if not (matchPattern theType pattern:"Output") do
							currentX += MagmaFlowSettings.NodeWidth + MagmaFlowSettings.NodeXSpace
						[currentX, currentY]
					)
					else
						thePos
					
					local isSelected = (magma.getNodeProperty theID "Selected") == true
					local isCollapsed = (magma.getNodeProperty theID "Collapsed") == true 
					local isBranchCollapsed = (magma.getNodeProperty theID "Internal_BranchCollapsed") == true
					hc.isSelected = isSelected
					hc.activeNodeCollapsed = isCollapsed
					if isBranchCollapsed do hc.activeNodePos = [-10000,-10000]
					
					--CUSTOM DISPLAY SETTINGS
					local theColorMultiplier = if magma.getNodeProperty theID "enabled" then 1.0 else 0.5
					local theColor = color 255 200 200 
					hc.drawLayer = 2
					hc.showBitmapOnly = false
					case of
					(
						(theType as name == #Missing): 
						(
							theColor = MagmaFlowColors.MissingNode
						)
						(matchPattern theType pattern:"Output"): 
						(
							--hc.isCollapsible = false
							hc.viewAlign = 1
							hc.viewAlignOffset = [0,outputsCounter*50]
							outputsCounter += 1
							theColor = MagmaFlowColors.OutputNode 
						)
						(theType as name == #InputValue): 
						(
							local theVal = (magma.GetNodeProperty theID "controller").value 
							local isInt = magma.getNodeProperty theID "forceInteger"
							theColor = case classof theVal of
							(
								default: (if isInt then MagmaFlowColors.InputIntValueNode else MagmaFlowColors.InputFloatValueNode )
								Point3: MagmaFlowColors.InputVectorValueNode
							)
							if MagmaFlowSettings.showColorSwatchSample and classof theVal == Point3 then
							(
								local theNodeBitmap = bitmap 2 2 color:(theVal*255)
								hc.bitmapSize = [20,20]
								hc.NodeBitmap = theNodeBitmap
							)
							else
								hc.NodeBitmap = undefined							
						)
						(theType as name == #InputChannel): 
						(
							theColor = MagmaFlowColors.InputChannelNode 
						)
						(theType as name == #InputGeometry): 
						(
							theColor = MagmaFlowColors.InputGeometryNode 
						)
						(theType as name == #InputParticles):
						(
							theColor = MagmaFlowColors.InputParticlesNode
						)
						(theType as name == #InputObject):
						(
							theColor = MagmaFlowColors.InputObjectNode
						)
						(theType as name == #InputScript):
						(
							theColor = MagmaFlowColors.InputScriptNode
						)
						(theType as name == #Elbow):
						(
							--hc.nodeBitmap = theElbowBitmap
							--hc.showBitmapOnly = true
						)
						(theType as name == #InputTexmap):
						(
							theColor = MagmaFlowColors.InputTextureNode
							if MagmaFlowSettings.showTextureMapSample then
							(
								local theNodeBitmap = NodeBitmapsCache[theID+1]
								local theMap = magma.getNodeProperty theID "texmap"
								if theNodeBitmap == undefined and theMap != undefined then --
								(
									theNodeBitmap = renderMap theMap size:[MagmaFlowSettings.NodeWidth-6,MagmaFlowSettings.NodeWidth-6] scale:250 filter:true display:false filename:(GetDir #temp + "\\MagmaFlow_temp.bmp")
									hc.bitmapSize = [MagmaFlowSettings.NodeWidth,MagmaFlowSettings.NodeWidth]
									hc.NodeBitmap = theNodeBitmap
									hc.showMiniBitmap = true
								)
								else
									hc.NodeBitmap = undefined
							)
							else hc.NodeBitmap = undefined
						)
						(theType as name == #BLOP): 
						(
							theColor = MagmaFlowColors.EditableBLOPNode  
						)
						default: 
						(
							case magma.GetNodeTypeCategory theType of 
							(	
								"Logic": theColor = MagmaFlowColors.LogicOperatorNode
								"Object": theColor = MagmaFlowColors.ObjectOperatorNode
								default: theColor = MagmaFlowColors.OperatorNode   
							)
						)
					)
					
					local isConnectedInFlow = magma.getNodeProperty theID "Internal_NodeConnected"
					if isConnectedInFlow == undefined do isConnectedInFlow = false
					/*
					local theExistingConnection = magma.getConnectedNodes theID
					if theExistingConnection.count > 0 and (for j in theExistingConnection where j.count > 0 collect j).count == 0 do isConnectedInFlow = false
					*/
					if not isConnectedInFlow do theColor *= MagmaFlowColors.DimmUnconnectedNode
					hc.nodeColor = theColor * theColorMultiplier
					--FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Node Creation Block Took "+((timestamp()-st2)) as string + " ms." )
					
					
					
					--HIGHLIGHT ERROR:
					if theID == magma.lastErrorNode and theID > -1 do hc.nodeColor = color 255 80 80
						
					/*FIXME: This code is slow, speed it up! */
					--local st2 = timestamp()	
					--local theExistingConnection = (magmaFlowEditor_Functions.getConnectedNodes magma theID)
					--FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree getConnectedNodes Call Took "+((timestamp()-st2)) as string + " ms." )
					local theOutCount = magma.GetNumNodeOutputs theID
					--if theOutCount == 0 do theOutCount  = 1
					if theType == "Output" do theOutCount  = 0		
					
					
					local actualOutCount = 0
					/*
					if magma.getNodeProperty theID "HideUnconnectedOutputs" == true then
						for i = 1 to theOutCount where theExistingConnection[i].count > 0 do actualOutCount += 1
					else
					*/
					actualOutCount= theOutCount
					
					
					local st2 = timestamp()
					--CREATE INPUT SOCKETS:
					local theInCount = magma.GetNumNodeInputs theID
					local inputSocketPos = 5+actualOutCount*15
					local separatorLocations= magma.getNodeProperty theID "InputSocketSeparators" 
					if separatorLocations == undefined then separatorLocations = #() --else separatorLocations = execute separatorLocations
					for i = 1 to theInCount do 
					(
						inputSocketPos += 15
						if init do hc.addInSocket
						hc.activeSocket = i
						hc.socketName = getInputSocketName theID i
						
						--FIXME: This is DOG SLOW, need faster code to determine socket colors
						hc.connectionColor = (getInputSocketColor theID i) * (if isConnectedInFlow then 1.0 else MagmaFlowColors.DimmUnconnectedNode)
						
						--hc.connectionColor = MagmaFlowColors.FloatSocketColor * (if isConnectedInFlow then 1.0 else MagmaFlowColors.DimmUnconnectedNode)
						hc.socketPosition = [5,inputSocketPos]
						if theType == "Elbow" then
						(
							hc.socketPosition = [4,MagmaFlowSettings.ElbowSize/2-3]
							hc.socketName = ""
						)
						if theType == "Output" do 
						(
							local theChannelName = magma.getNodeProperty theID "channelName"
							local theChannelType = magma.getNodeProperty theID "channelType"
							hc.socketName = theChannelType 
							hc.socketPosition = [5,inputSocketPos]
							hc.nodeName = theID as string + ":OUT:" + theChannelName
						)
						if findItem separatorLocations i > 0 do inputSocketPos+=10
					)
					inputSocketPos+=15
					--FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Create Input Sockets Block Took "+((timestamp()-st2)) as string + " ms." )
					
					--CREATE OUTPUT SOCKETS:
					local st2 = timestamp()
					local actualOutIndex = 0
					for i = 1 to theOutCount do
					(
						if init do hc.addOutSocket
						hc.activeSocket = theInCount + i
						local socketIsFlipped = if MagmaFlowSettings.AutoReorderToggle == true then false else (magma.getNodeProperty theID "FlipSocketPosition" == true)
						if theType == "Elbow" do socketIsFlipped = false
						hc.activeSocketFlipped = socketIsFlipped
						
						/*
						local theExistingConnection = (magmaFlowEditor_Functions.getConnectedNodes magma theID)
						if magma.getNodeProperty theID "HideUnconnectedOutputs" != true OR theExistingConnection[i].count > 0 then
						*/
						(
							actualOutIndex += 1
							if theType == "Elbow" then
								hc.socketPosition = [MagmaFlowSettings.NodeWidth-20,MagmaFlowSettings.ElbowSize/2-3]
							else
								if socketIsFlipped then
									hc.socketPosition = [5,5+actualOutIndex*15]
								else
									hc.socketPosition = [MagmaFlowSettings.NodeWidth-20,5+actualOutIndex*15]
							hc.socketName = (getOutputSocketName theID i) +" "
						)
						/*else
						(
							hc.socketPosition = [MagmaFlowSettings.NodeWidth-20,3]
							hc.socketName = ""
						)*/
						hc.activeSocketShowValue = false
						
						hc.connectionColor = if i == MagmaFlowSettings.nodeInsertSocket and isSelected then
							MagmaFlowColors.HighlightedSocketColor * (if isConnectedInFlow then 1.0 else 0.75)
						else
							MagmaFlowColors.StandardSocketColor * (if isConnectedInFlow then 1.0 else MagmaFlowColors.DimmUnconnectedNode)
							--(getOutputSocketColor theID i)* (if isConnectedInFlow then 1.0 else MagmaFlowColors.DimmUnconnectedNode)
					)
					--FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Create Output Sockets Block Took "+((timestamp()-st2)) as string + " ms." )
					
					
					
					local theSize = if theType != "Output" then [MagmaFlowSettings.NodeWidth,inputSocketPos] else [MagmaFlowSettings.NodeWidth,35] 
					if theType == "Elbow" do 	
					(
						theSize = [MagmaFlowSettings.ElbowSize,MagmaFlowSettings.ElbowSize]
						hc.nodeNameOffset  = [0,MagmaFlowSettings.ElbowSize/5]
						hc.edgeSize = 100
						hc.activeNodeCollapsed = false
						hc.isCollapsible = true
						hc.nodeCollapsedSize = theSize
						hc.socketName = ""
					)
					hc.nodeSize = theSize
				)--end if specific ID
				hc.nodeCollapsedSize = [hc.nodeSize.x,25]				
			)--end node creation loop
			
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree N Loop Took "+((timestamp()-st1)) as string + " ms." )
			
			editorNodeCount = nodeCount
			
			--BLOP INPUTS AND OUTPUTS
			local st2 = timestamp()
			local BlopCount = magma.NumEditingBLOPs()
			if BlopCount > 0 do
			(
				local numBLOPInputs = magma.GetNumNodeInputs (magma.CurrentBLOP)
				local numBLOPOutputs = magma.GetNumNodeOutputs (magma.CurrentBLOP)
				local BLOPInputID = (magma.GetNodeInput (magma.CurrentBLOP) 1)[1]
				
				local currentBLOPID = EditableBlopStack[BlopCount]
				magma.PopEditableBlop()
				
				theInputSocketNames = for i = 1 to numBLOPInputs collect
				(
					local theSocketName = magma.getNodeProperty currentBLOPID ("BLOPInputSocketName"+i as string)
					if theSocketName == undefined do theSocketName = "Input " + i as string
					theSocketName	
				)
				local separatorLocations = magma.getNodeProperty currentBLOPID "InputSocketSeparators" 
				if separatorLocations == undefined then separatorLocations = #() 
				
				theOutputSocketNames = for i = 1 to magma.getNumNodeOutputs currentBLOPID collect
				(
					local theSocketName = magma.getNodeProperty currentBLOPID ("BLOPOutputSocketName" + i as string)
					if theSocketName == undefined do theSocketName = "Output " + i as string
					theSocketName
				)					
				magma.PushEditableBlop currentBLOPID
				
				if init do hc.addNode
				editorNodeCount += 1
				NodeIDMap[editorNodeCount] = BLOPInputID
				hc.activeNode = editorNodeCount
				hc.nodeName = "BLOP INPUTS"
				hc.isCollapsible = false
				hc.viewAlign = -1
				if MagmaFlowSettings.DepotPlacement == #left do 
					hc.viewAlignOffset = [MagmaFlowSettings.DepotNodeWidth,0]
				hc.nodeColor = color 200 255 200	
				local InputSocketPos = 5
				for i = 1 to numBLOPInputs do
				(
					if init do hc.addOutSocket
					InputSocketPos += 15
					hc.activeSocket = i
					hc.socketName = theInputSocketNames[i]+" " 
					hc.activeSocketShowValue = false
					hc.connectionColor = MagmaFlowColors.StandardSocketColor
					hc.socketPosition = [MagmaFlowSettings.NodeWidth-20, InputSocketPos]
					if findItem separatorLocations i > 0 do InputSocketPos += 10
				)
				hc.nodeSize = [MagmaFlowSettings.NodeWidth , 15+InputSocketPos]

				if init do hc.addNode
				editorNodeCount += 1
				NodeIDMap[editorNodeCount] = -1
				hc.activeNode = editorNodeCount
				hc.nodeName = "BLOP OUTPUTS"
				hc.isCollapsible = false
				hc.viewAlign = 1
				hc.nodeColor = color 200 255 200	
				hc.nodeSize = [MagmaFlowSettings.NodeWidth , 20+15*numBLOPOutputs]
				
				for i = 1 to numBLOPOutputs do
				(
					hc.activeNode = editorNodeCount
					if init do hc.addInSocket
					hc.activeSocket = i
					hc.socketName = theOutputSocketNames[i]-- "Output " + i as string 
					hc.activeSocketShowValue = false
					hc.connectionColor = color 0 0 200		
					hc.socketPosition = [5,5+i*15]
					if init do 
					(
						local theConnection = magma.getOutput i
						local theConnectedID = theConnection[1]
						local theNodeIndex = findItem NodeIDMap theConnectedID
						local numOuts = try(magma.getNumNodeOutputs theConnectedID)catch(0)
						hc.activeNode = theNodeIndex --set the active node to the downstream connected node 
						hc.activeSocket = hc.getSocketCount-numOuts+theConnection[2] --set the active socket to the desired output socket
						hc.toggleConnection = [editorNodeCount,i]	--create a connection to the upstream node's connection c
					)
				)
			)		
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree BLOP Block Took "+((timestamp()-st2)) as string + " ms." )			
			local st2 = timestamp()
			--RECREATE CONNECTIONS
			if init do 
			(			
				for n = 1 to nodeCount do --loop through all nodes in the flow
				(
					local theID = magma.GetNodeID n --get the ID of the current node
					local isBranchCollapsed = (magma.getNodeProperty theID "Internal_BranchCollapsed") == true OR (magma.getNodeProperty theID "Collapsed") == true and MagmaFlowSettings.AllowSubtreeCollapsing == true
					if not isBranchCollapsed do
					(
						for c = 1 to magma.GetNumNodeInputs theID do --get the number of inputs of the current node
						( 
							local theConnection = (magma.GetNodeInput theID c)
							if theConnection[1] >= 0 then
							(
								if (magma.getNodeProperty theConnection[1] "Internal_BranchCollapsed") != true do --AND (magma.getNodeProperty theConnection[1] "Collapsed") != true do
								(
									local theNodeIndex = findItem NodeIDMap theConnection[1] --find what node in the schematic flow it corresponds to
									if theNodeIndex > 0 do
									(
										local numOuts = magma.getNumNodeOutputs theConnection[1] 
										if magma.getNodeType theConnection[1] == "Breakout" do numOuts = 3
										--if (magma.getNodeType theConnection[1]) as name == #BLOPSocket do numOuts = magma.getNumNodeInputs theConnection[1]
										--format "Upstream: %  ID: %  Connection: %  theConnection: %  theNodeIndex: %  NumOuts:%\n" n theID c theConnection theNodeIndex NumOuts
										hc.activeNode = theNodeIndex --set the active node to the downstream connected node 
										hc.activeSocket = hc.getSocketCount-numOuts+theConnection[2] --set the active socket to its output (last socket)
										hc.toggleConnection = [n,c]	--create a connection to the upstream node's connection c
									)
								)
							)
						)--end c loop
					)--end if branch collapsed
				)--end connection creation
			)
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Recreate Connections Took "+((timestamp()-st2)) as string + " ms." )
			
			local st2 = timestamp()
			drawDepot init:init
			if init do 
			(
				hc.addNode
				hc.activeNode = hc.getNodeCount
				hc.nodeColor = color 240 250 255
				hc.nodeName = "NOTES:"
				hc.nodeSize = [30,20]
				hc.ActiveNodePos = [-1000,-1000]
				hc.drawLayer = 100
				for i = 1 to 10 do 
				(
					hc.addInSocket
					hc.activeSocket = i
					hc.socketPosition = [3,3]
					hc.socketLabelOffset = [-10,5+i*13]
					hc.socketName = ""
					hc.connectionColor = color 240 250 255
				)
			)			
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Draw Depot Took "+((timestamp()-st2)) as string + " ms." )
			
			MagmaFlowSettings.NumEditingBLOPs = magma.NumEditingBLOPs()
			st2 = timestamp()
			updateErrorLog()
			updateEditorTitle()
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree Update Error Log and Title Bar Took "+((timestamp()-st2)) as string + " ms." )
			hc.redrawView	
			FranticParticles.LogDebug ("MagmaFlow: CreateNodeTree init:"+init as string+" Took "+((timestamp()-st)) as string + " ms." )
			
			
		)--end createNodeTree fn
		
		fn debugFlow =
		(
			if MagmaFlowSettings.DebugModeOn == true then
			(
				if not MagmaFlowEditor_DebugRollout.open do
				(
					local thePos = getDialogPos MagmaFlowEditor_Rollout + [0,MagmaFlowEditor_Rollout.height+50]
					createDialog MagmaFlowEditor_DebugRollout MagmaFlowEditor_Rollout.width 400 thePos.x thePos.y style:#(#style_titlebar, #style_border, #style_sysmenu, #style_resizing, #style_minimizebox, #style_maximizebox)
					MagmaFlowEditor_DebugRollout.resizeDialog [MagmaFlowEditor_Rollout.width, 400]
				)
				MagmaFlowEditor_DebugRollout.updateDialog()
			)
			else
			(
				try(destroyDialog MagmaFlowEditor_DebugRollout)catch()
			)
			
		)
		
-----------------------------------------
--CREATE NODE
-----------------------------------------		
		fn sortNodesByXPosition v1 v2 valArray: =
		(
			local v1i = valArray[v1]
			local v2i = valArray[v2]
			if v1i < v2i then -1 else 1
		)
		
		fn connectNodes theSelection =
		(
			local success = false
			if theSelection.count > 1 do
			(
				local thePositions = for i in theSelection collect 
				(
					hc.activeNode = i
					hc.activeNodePos.x
				)
				theIndices = for i = 1 to theSelection.count collect i
				qsort theIndices  sortNodesByXPosition valArray:thePositions
				local theNodes = for i in theIndices collect magma.getNodeID theSelection[i]
				theSelection = for i in theIndices collect theSelection[i]
					
				--format "theNodes=%\n" theNodes
				
				for m = 2 to theSelection.count do
				(
					local maxNode = theNodes[m]
					local numIns = magma.getNumNodeInputs maxNode
					for c = 1 to numIns do
					(
						local theConnection = magma.getNodeInput maxNode c
						if theConnection[1] == -1 do --if unconnected
						(						
							theDescription = magma.getNodeInputDescription maxNode c
							if matchPattern theDescription pattern:"Lookup Point*" do theDescription = "Pos"
							if matchPattern theDescription pattern:"Ray Origin*" do theDescription = "Pos"	
							if matchPattern theDescription pattern:"Ray Direction*" do theDescription = "InputValue"	
								
							local done = false
							for n = 1 to m-1 while not done do
							(
								local aNode = theNodes[n]
								local numOuts = magma.getNumNodeOutputs aNode
								for o = 1 to numOuts while not done do
								(
									if matchPattern (substituteString (magma.getNodeOutputDescription aNode o) " " "") pattern:("*"+theDescription+"*") do
									(
										magma.setNodeInput maxNode c aNode o
										done = true
										success = true
									)
								)
							)
						)--end if
					)--end c loop
				)
				if not success and theNodes.count == 2 and magma.getNumNodeOutputs theNodes[1] == 1 do --if connecting by description failed and the left node has only one output,
				(
					local done = false
					for c = 1 to magma.getNumNodeInputs theNodes[2] while not done do
					(
						local theConnection = magma.getNodeInput theNodes[2] c
						if theConnection[1] == -1 do 
						(
							magma.setNodeInput theNodes[2] c theNodes[1] 1
							done = true		
							success	= true
						)
					)
				)
			)--end if 2 selected
			updateMagmaHolder()
			--createNodeTree init:false
			debugFlow()
			success
		)
		
		fn insertNodeIntoExistingFlow theInsertID =
		(
			if magma.getNumNodeInputs theInsertID > 0 and magma.getNumNodeOutputs theInsertID > 0 and lastWireSelection[1] != undefined do
			(
				if (magma.getNodeInput theInsertID 1)[1] == -1 do
				(
					--format "lastWireSelection=%\n" lastWireSelection
					local theNode2 = (magma.getNodeID lastWireSelection[3])
					local theNode1 = (magma.getNodeID lastWireSelection[1])
					if theNode1 == theInsertID do 
						theNode1 = (magma.getNodeID (lastWireSelection[1]+1))
					if theNode1 == -1 and magma.NumEditingBLOPs() > 0 then
					(
						existingNodeInput = magma.getNodeInput theNode2 lastWireSelection[4]
						magma.setNodeInput theInsertID 1 existingNodeInput[1] existingNodeInput[2]
						magma.setNodeInput theNode2  lastWireSelection[4] theInsertID 1
						createNodeTree init:true						
					)
					else
					(
						local theOutCount = magma.getNumNodeOutputs theNode1
						local pos1 = magma.getNodeProperty theNode1 "Position" + [0,20+theOutCount*15]
						if magma.getNodeType theNode2 == "Output" then
						(
							local cnt = 0
							for j = 1 to magma.getNumNodes() while magma.getNodeID j != theNode2 do if magma.getNodeType (magma.getNodeID j) == "Output" do cnt+= 1
							local pos2 = ([hc.width-MagmaFlowSettings.NodeWidth, 40+(cnt-1)*60]-hc.pan)/hc.zoom
						)
						else
						(
							local theOutCount = magma.getNumNodeOutputs theNode2
							local pos2 = (magma.getNodeProperty theNode2 "Position") + [0,20+theOutCount*15]
						)							
						local theMidPos = (pos1 + pos2) / 2.0 - [0,30]
						magma.setNodeInput theInsertID 1  theNode1  (lastWireSelection[2]-(magma.getNumNodeInputs theNode1))
						magma.setNodeInput theNode2  lastWireSelection[4] theInsertID 1
						magma.setNodeProperty theInsertID "Position" theMidPos
						createNodeTree init:true
					)
				)
			)
			lastWireSelection = #()
			MagmaFlowSettings.insertNodeIntoFlow = false
		)		
		
		fn connectSelectedNodes =
		(
			local theSelection = getSelectedNodes()
			--format "lastWireSelection=%\n" lastWireSelection
			if lastWireSelection.count > 0 and theSelection.count == 1 then
			(
				local theInsertID = magma.getNodeID theSelection[1]
				insertNodeIntoExistingFlow theInsertID
			)
			else
				connectNodes theSelection
		)		
		
		fn createNode theNodeType valueType:#float defaultValue:1.0 channelName:"Color" channelType:"float16[3]" insertOutSocket:1 mode:#keyboard=
		(
			local existingSelection = getSelectedNodes()
			local allSelectedAreInputs = true
			theMouse = (((getMouseInSchematicView mode:mode) - [MagmaFlowSettings.NodeWidth/2, 10]  - hc.pan ) / hc.zoom)
			local theNewNode = try(magma.createNode theNodeType)catch(undefined)
			if theNewNode != undefined do
			(
				case theNodeType as name of
				(
					#Output:
					(
						setSelectedNodes #()
						magma.SetNodeProperty theNewNode "channelName" channelName
						magma.SetNodeProperty theNewNode "channelType" channelType
						nodeType = #output
					)
					#Missing:
					(
						magma.setNumNodeInputs theNewNode 1
						magma.setNumNodeOutputs theNewNode 1
					)
					#InputValue:
					(
						case valueType of
						(
							default:
							(
								local theCtrl = bezier_float()
								theCtrl.value = defaultValue
								magma.SetNodeProperty theNewNode "controller" theCtrl
								--format "%\n" (magma.GetNodeProperty theNewNode "controller")
								--magma.SetNodeProperty theNewNode "forceInteger" false
							)
							#integer:
							(
								local theCtrl = bezier_float()
								theCtrl.value = defaultValue
								magma.SetNodeProperty theNewNode "controller" theCtrl
								magma.SetNodeProperty theNewNode "forceInteger" true
							)
							#vector:
							(
								local theCtrl = point3_xyz()
								theCtrl.value = defaultValue
								magma.SetNodeProperty theNewNode "controller" theCtrl
							)
						)
						nodeType = #input
					)
					#InputChannel:
					(
						if channelName == "Normal" and MagmaFlowEditor_Functions.IsGenome magma do channelName = "VertexNormal"
						magma.SetNodeProperty theNewNode "channelName" channelName
						nodeType = #input
					)
					#InputParticles:
					(
						nodeType = #input
					)		
					#InputGeometry:
					(
						nodeType = #input
					)					
					#InputObject:
					(
						nodeType = #input
					)						
					default: 
					(
						nodeType = #operator
					)
				)--end case

				if mode == #button then
				(
					if existingSelection.count > 0 then
					(
						local thePos = [0,0]
						for i in existingSelection do thePos += (magma.getNodeProperty (magma.getNodeID i) "Position")
						thePos /= existingSelection.count
						thePos+= [MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace,0]
					)
					else
						thePos = theMouse
				)
				else if mode == #keyboard then
				(
					if existingSelection.count > 0 then
					(
						allSelectedAreInputs = true
						for i in existingSelection where not matchPattern (magma.getNodeType (magma.getNodeID i)) pattern:"*Input*" do allSelectedAreInputs  = false
						local thePos = [0,0]
						local theMaxY = 0
						for i in existingSelection do 
						(
							theNPos = (magma.getNodeProperty (magma.getNodeID i) "Position")
							thePos += theNPos
							hc.activeNode = i
							if theNPos.y+hc.nodeSize.y > theMaxY do theMaxY = theNPos.y+hc.nodeSize.y
						)
						thePos /= existingSelection.count
							
						if allSelectedAreInputs and nodeType == #input then
						(
							thePos.y = theMaxY+MagmaFlowSettings.NodeYSpace
						)
						else
						(
							
							if nodeType == #input then
								thePos -= [MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace,0]
							else
								thePos += [MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace,0]
						)
					)
					else
						thePos = theMouse
				)
				else if mode == #dragwire then
					thePos = theMouse
				else
					thePos = theMouse
				
				MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Position" thePos
				MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Selected" true				
				
				createNodeTree init:true
				
				if ConnectToEmpty_fromID == -1 and ConnectToEmpty_Index > -1 and ConnectToEmpty_SocketType == #input then
				(
					--Connecting BLOP
					try(magma.SetOutput ConnectToEmpty_Index theNewNode 1)catch()
					ConnectToEmpty_Index = -1		
					ConnectToEmpty_SocketType = #none
				)
				else
				if ConnectToEmpty_fromID > -1 and ConnectToEmpty_Index > -1 then
				(
					if ConnectToEmpty_SocketType == #input then
						try(magma.setNodeInput ConnectToEmpty_fromID ConnectToEmpty_Index theNewNode 1)catch()
					else					
					(
						local theIndex1 = MagmaFlowEditor_Functions.getIndexByID magma ConnectToEmpty_fromID
						local theIndex2 = MagmaFlowEditor_Functions.getIndexByID magma theNewNode
						local selectionIndices = getSelectedNodes()
						if findItem selectionIndices theIndex1 == 0 do append selectionIndices theIndex1 
						if findItem selectionIndices theIndex2 == 0 do append selectionIndices theIndex2
						local AutoConnectResult = false
						--if theIndex1 > 0 and theIndex2 > 0 do AutoConnectResult = connectNodes selectionIndices
						if not AutoConnectResult then
						(
							magma.setNodeInput theNewNode 1 ConnectToEmpty_fromID ConnectToEmpty_Index 
							if magma.getNodeType theNewNode == "Output" do
							(
								local theOutputName = (magma.GetNodeOutputDescription ConnectToEmpty_fromID ConnectToEmpty_Index )
								local theChannels = MagmaFlowEditor_Functions.loadChannelsList()
								local theChannelNames = for j in theChannels collect j[1]
								local theIndex = findItem theChannelNames theOutputName							
								if theIndex > 0 do 
								(
									--format "Setting Output To %\n" theChannels[theIndex][1]
									magma.setNodeProperty theNewNode "channelName" theChannels[theIndex][1]
									magma.setNodeProperty theNewNode "channelType" (theChannels[theIndex][2]+"["+theChannels[theIndex][3] as string+"]")
								)
							)
						)
					)
					setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
					ConnectToEmpty_fromID = -1
					ConnectToEmpty_Index = -1
				)
				else
				(
					--AUTO-CONNECT NODES
					if theNewNode > -1 do
					(
						if nodeType == #operator do
						(
							if lastWireSelection.count > 0 then
							(
								insertNodeIntoExistingFlow theNewNode
							)
							else
							(
								local theSocketCount = magma.getNumNodeInputs theNewNode
								
								if theNodeType == "Switch" then
								(
									local done = false
									for c = existingSelection.count to 1 by -1 while not done do
									(
										local theExistingID = magma.getNodeID existingSelection[c]
										local theExistingType = magma.getNodeType theExistingID
										local isBoolean = magma.GetNodeTypeCategory theExistingType == "Logic" and theExistingType != "Mux" and theExistingType != "Switch"
										if isBoolean do 
										(
											try(magma.SetNodeInput theNewNode 3 theExistingID 1)catch()	
											MagmaFlowEditor_Functions.setUIProperty magma theExistingID "Selected" false
											deleteItem existingSelection c
											done = true
										)
									)
								)
								for c = 1 to existingSelection.count while c <= theSocketCount do
								(
									local theID = magma.getNodeID existingSelection[c]
									if magma.getNodeType theID != "Output" then
									(
										if MagmaFlowSettings.nodeInsertMode == true then
										(
											local theExistingConnection = (magmaFlowEditor_Functions.getConnectedNodes magma theID)
											if MagmaFlowSettings.nodeInsertSocket > 0 then 
												theExistingConnection = theExistingConnection[MagmaFlowSettings.nodeInsertSocket]
											else 
												theExistingConnection = undefined
											if theExistingConnection != undefined and theExistingConnection.count > 0 do 
											(
												--Connect upstream nodes to the new node if there are existing connections
												for j in theExistingConnection do 
												(
													try(
														magma.setNodeInput j[1] j[2] theNewNode 1
													)catch()
												)
												
												if theExistingConnection[1][1] != undefined do
												(
													if magma.getNodeType theExistingConnection[1][1] == "Output" then --figure out relative position to Output node
													(
														local cnt = 0
														for j = 1 to magma.getNumNodes() while magma.getNodeID j != theExistingConnection[1][1] do if magma.getNodeType (magma.getNodeID j) == "Output" do cnt+= 1
														local pos1 = ([hc.width-MagmaFlowSettings.NodeWidth, 40+(cnt-1)*60]-hc.pan)/hc.zoom
													)
													else
													(
														local theOutCount = magma.getNumNodeOutputs theExistingConnection[1][1]
														local pos1 = (magma.getNodeProperty theExistingConnection[1][1] "Position") + [0,18+(theOutCount-1+theExistingConnection[1][2])*15]
														--format "pos1 = %\n" pos1
													)
													local pos2 = (magma.getNodeProperty theID "Position")
													local theMidPosition = (pos1 + pos2)/2.0
													--format "theMidPosition = %\n" theMidPosition
													magma.setNodeProperty theNewNode "Position" theMidPosition
												)
											)
											if MagmaFlowSettings.nodeInsertSocket > 0 then
												try(magma.SetNodeInput theNewNode c theID MagmaFlowSettings.nodeInsertSocket)catch()
											else
												try(magma.SetNodeInput theNewNode c theID 1)catch()									
										)
										else
										(
											try(magma.SetNodeInput theNewNode c theID MagmaFlowSettings.nodeInsertSocket)catch()
										)
									)--end not Output
									else
									(
										--if the Output node has nothing connected into it, connect to the first output socket of the new node
										if (magma.getNodeInput theID 1)[1] == -1 do magma.setNodeInput theID 1 theNewNode 1
									)
									MagmaFlowEditor_Functions.setUIProperty magma theID "Selected" false
								)		
								--format "END Trying to connect to existing selection...\n"
							)
							MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Selected" true
						)
						if nodeType == #input do
						(
							
							local done = false
							for c = 1 to existingSelection.count do
							(
								local theID = magma.getNodeID existingSelection[c]
								local theSocketCount = magma.getNumNodeInputs theID
								done = false
								for i = 1 to theSocketCount while not done do
								(
									local theInput = magma.getNodeInput theID i
									--format "theInput = %\n" theInput 
									if theInput[1] < 0 do
									(
										magma.SetNodeInput theID i theNewNode 1
										newPos = (magma.getNodeProperty theID "Position") + [-(MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace), (i-1)*50]
										MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Position" newPos
										done = true
									)
								)
							)
							
							if mode == #keyboard then
							(
								if existingSelection.count == 1 and magma.getNodeType (magma.getNodeId existingSelection[1]) == "Output" then
								(
									setSelectedNodes #()
									MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Selected" true
								)
								else
								(
									setSelectedNodes existingSelection
									MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Selected" allSelectedAreInputs
								)
							)
							else
							(
								setSelectedNodes #()
								MagmaFlowEditor_Functions.setUIProperty magma theNewNode "Selected" true
							)							
							if not done do 
							(	
								
							)
						)
					)
				)--end if new node valid
			)
			updateMagmaHolder update:true
			autoReorderFlow update:false
			debugFlow()
			updateNavigator()
			createUndoRecord ("Created Node ["	+theNodeType +"]")
			displaySelectedNodeProperties()	
			MagmaFlowSettings.nodeInsertMode = not keyboard.shiftpressed 
			MagmaFlowSettings.nodeInsertSocket = 0
			toggleInsertMode update:false
			createNodeTree init:false specificNodeId:theNewNode
			theNewNode
		)		
		
		fn addNewOutputChannel =
		(
			local tabuChannels = #()
			for i = 1 to magma.getNumNodes() where magma.getNodeType (magma.getNodeID i) == "Output" do
				appendIfUnique tabuChannels (magma.getNodeProperty (magma.getNodeID i) "channelName")
			if not MagmaFlowEditor_Functions.IsModifier magma and not MagmaFlowEditor_Functions.IsGenome magma  and tabuChannels.count > 0 do return false
				
			local channelsList = MagmaFlowEditor_Functions.loadChannelsList mode:#output
			local channelsList2 = MagmaFlowEditor_Functions.getSortedChannelsList channelsList 2 theIniFileLocation includeCustom:false nodeType:#output
			channelsList2 = for i in channelsList2 where findItem tabuChannels i == 0 collect i
			local theType = "float16[3]"
			for i in channelsList where i[1] == channelsList2[1] do theType = i[2]+"["+i[3] as string+"]"
			MagmaFlowEditor_Rollout.createNode "Output" channelName:channelsList2[1] channelType:theType
			createNodeTree init:true
		)		
		
		
-----------------------------------------
--BLOP HANDLING
-----------------------------------------
		fn createBLOPInline =
		(
			theSel = getSelectedNodes()
			if theSel.count > 0 do
			(
				local theAveragePos = [0,0]
				local theIDs = for i in theSel collect 
				(
					theID = magma.getNodeID i
					theAveragePos += magma.getNodeProperty theID "Position"
					theID 
				)
				if theSel.count > 0 do theAveragePos /= theSel.count
				local lastError = ""
				local theResult = try(magma.CreateBlopFrom theIDs)catch(lastError = getCurrentException(); undefined)
				if theResult != undefined then
				(
					magma.declareExtensionProperty theResult "Position"
					magma.setNodeProperty theResult "Position" theAveragePos
					createNodeTree init:true
					updateNavigator()
					debugFlow()
					createUndoRecord "Created BLOP from Selection"	
					undoLastStep()
					redoLastStep()
				)
				else
				(
					edt_log.text = substituteString lastError "\n" "  "
				)
			)
		)
		
		fn explodeBLOP nodeID =
		(
			magma.ExplodeBlop nodeID
			createUndoRecord "Explode BLOP"	
			createNodeTree init:true
			updateNavigator()
			debugFlow()
		)
		
-----------------------------------------
--DEPOT HANDLING
-----------------------------------------
		local RCMenus = #()
		local RCMenuNames = #()
		fn createDepot =
		(
			allBlopNames = #()
			allBlopDescriptions = #()
			
			DepotCategories= #()
			for i = 1 to magma.GetNumNodeTypes() do
			(
				theCat = try(magma.GetNodeTypeCategory (magma.GetNodeTypeName i))catch("")
				if findItem DepotCategories theCat == 0 do append DepotCategories theCat
			)
			sort DepotCategories
			DepotDefinition = #()
			RCMenus = #()
			RCMenuNames = #()
			local theNodeTypeNames = for i = 1 to magma.GetNumNodeTypes() where findItem #("BLOPSocket") (magma.GetNodeTypeName i) == 0 collect (magma.GetNodeTypeName i)
			sort theNodeTypeNames
			
			local theNodesMenu = "" as stringstream
			format "rcmenu allNodes_menu (\n" to:theNodesMenu
			
			for c in DepotCategories do
			(
				theCatNodes = for i in theNodeTypeNames where try(magma.GetNodeTypeCategory i == c)catch(false) collect 
				(
					local theColor = case i as name of
					(
						#Output: MagmaFlowColors.OutputNode
						#InputValue: MagmaFlowColors.InputVectorValueNode
						#InputChannel: MagmaFlowColors.InputChannelNode
						#InputGeometry: MagmaFlowColors.InputGeometryNode
						#InputParticles: MagmaFlowColors.InputParticlesNode
						#InputObject: MagmaFlowColors.InputObjectNode
						#InputScript: MagmaFlowColors.InputScriptNode
						#BLOP: MagmaFlowColors.EditableBLOPNode
						default: 
						(
							case c of 
							(
								"Logic": MagmaFlowColors.LogicOperatorNode 
								"Object": MagmaFlowColors.ObjectOperatorNode
								default: MagmaFlowColors.OperatorNode
							)
						)
					)
					#(c, i , theColor, [0,0], c+": "+ i, true, i)
				)
				if c == "BLOP" do
				(
					local theRootBlops = sort (getFiles (theUserFolder+ "\\BlackOps\\*.MagmaBLOP"))
					for f in theRootBlops do
					(
						local theName = getFileNameFile f
						append theCatNodes #(c, theName, MagmaFlowColors.EditableBLOPNode, [0,0], c+": "+theName, true, theName, (substituteString f "\\" "/") )
						append allBlopNames theName
						local theFileHandle = openFile f
						local theLine = f
						if theFileHandle != undefined do
						(
							skipToString theFileHandle "\"Notes\" " 
							if not eof theFileHandle do theLine = substituteString (readLine theFileHandle) "\\n" " "
						)
						close theFileHandle
						append allBlopDescriptions theLine
					)
					local theSubDirs = getDirectories (theUserFolder+ "\\BlackOps\\*")
					for d in theSubDirs do
					(
						local theName = filterString d "\\"
						theName=theName[theName.count]
						if MagmaFlowSettings.DepotShowBLOPs do
							append theCatNodes #("SUBHEAD", theName , MagmaFlowColors.HeaderColor ,[0,0], "Category: "+d ,true)
						local theBlops = sort (getFiles (d+"*.MagmaBLOP"))
						for f in theBlops do
						(
							local theName = getFileNameFile f
							append theCatNodes #(c, theName, MagmaFlowColors.EditableBLOPNode, [0,0], c+": "+theName, true, theName, (substituteString f "\\" "/"))
							append allBlopNames theName
							local theFileHandle = openFile f
							local theLine = f
							if theFileHandle != undefined do
							(
								skipToString theFileHandle "\"Notes\" " 
								if not eof theFileHandle do theLine = substituteString (readLine theFileHandle) "\\n" " "
							)
							close theFileHandle
							append allBlopDescriptions theLine
						)						
					)
				)
				
				local theUsedLetters=#()
				local theTabuLetter = c[1]
				if c == "Trigonometry" then theTabuLetter = "G"
				append theUsedLetters (bit.charAsInt theTabuLetter)
				for i = 1 to theCatNodes.count do ---where theCatNodes[i][1] != "SUBHEAD"
				(
					local done = false
					local theName = theCatNodes[i][2]
					if theName == "QuatToVectors" then
					(
						append theUsedLetters (bit.charAsInt "Q")
						theCatNodes[i][7] = "&QuatToVectors"
					)
					else
					(
						for j = theName.count to 1 by -1 while not done do
						(
							local theASCII = bit.charAsInt theName[j]
							if theASCII <= 90 and findItem theUsedLetters theASCII == 0 do 
							(
								append theUsedLetters theASCII
								theCatNodes[i][7] = substring theName 1 (j-1) + "&" + substring theName j -1
								done = true
							)
						)--end j loop
						for j = 1 to theName.count while not done do
						(
							local theASCII = bit.charAsInt theName[j]
							if theASCII > 90 do theASCII -= 32
							if findItem theUsedLetters theASCII == 0 do 
							(
								append theUsedLetters theASCII
								theCatNodes[i][7] = substring theName 1 (j-1) + "&" + substring theName j -1
								done = true
							)
						)--end j loop
					)
				)
				--format "theUsedLetters=%\n" theUsedLetters
				--format "theCatNodes = %\n" theCatNodes
				
				local theMenu = "" as stringstream
				format "rcmenu %_menu (\n" c to:theMenu
				format "submenu \"%\" (\n" c to:theNodesMenu
				local theSubMenu1 = "" as stringStream
				local theSubMenu2 = "" as stringStream
				
				local needClosing = false
				local cnt = 0
				local theCurrentEditorIndex = (for i = 1 to MagmaFlowEditor_CurrentEditors.count where MagmaFlowEditor_CurrentEditors[i] != undefined and MagmaFlowEditor_CurrentEditors[i][1] == magma collect i)[1]
				for i in theCatNodes do
				(
					cnt += 1
					local theTitle = i[2]
					if theTitle as name == #InputValue then
					(
						format "separator sep_inputValue \n" to:theSubMenu1
						for j in #(#("Integer","I&nteger",1),#("Float","&Float",1.0),#("Vector","&Vector",[0,0,0])) do
						(
							format "menuitem mnu_%_%_% \"InputValue:%\" \n" c cnt j[1] j[2] to:theSubMenu1
							format "on mnu_%_%_% picked do (\n" c cnt j[1] to:theSubMenu2
							format "MagmaFlowEditor_CurrentEditors[%][2].createNode \"%\" valueType:#% defaultValue:% mode:#rcmenu\n"  theCurrentEditorIndex i[2] j[1] j[3] to:theSubMenu2
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n"  theCurrentEditorIndex to:theSubMenu2
							format ")\n" to:theSubMenu2
						)
					)
					else
					(
						if i[1] != "SUBHEAD" then
						(
							format "menuitem mnu_%_% \"%\" \n" c cnt i[7] to:theSubMenu1
							format "on mnu_%_% picked do (\n" c cnt to:theSubMenu2
							if i[1] == "BLOP" and i[2] != "BLOP" then
							(
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeBLOP \"%\"\n"  theCurrentEditorIndex  i[8] to:theSubMenu2
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n"  theCurrentEditorIndex to:theSubMenu2
							)
							else
							(
								format "MagmaFlowEditor_CurrentEditors[%][2].createNode \"%\" mode:#rcmenu\n"  theCurrentEditorIndex i[2] to:theSubMenu2
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n"  theCurrentEditorIndex to:theSubMenu2
							)
							format ")\n" to:theSubMenu2
						)
						else
						(
							if needClosing do format ")\n" to:theSubMenu1
							format "subMenu \"%\" (\n" i[7] to:theSubMenu1
							needClosing = true
						)
					)
				)
				if needClosing do format ")\n" to:theSubMenu1

				format "%" (theSubMenu1 as string) to:theMenu
				format "%" (theSubMenu2 as string) to:theMenu
				format ")\n" to:theMenu
				
				format "%" (theSubMenu1 as string) to:theNodesMenu
				format ")\n" to:theNodesMenu
				format "%" (theSubMenu2 as string) to:theNodesMenu
				
				append RCMenuNames (c as name)
				append RCMenus (execute (theMenu as string))
				local catName = c
				if catName == "Trigonometry" and MagmaFlowSettings.DepotNodeWidth < 80 do catName = "Trigonom."
				append DepotDefinition (join #(#("HEAD", catName , MagmaFlowColors.HeaderColor ,[0,0], "Category: "+c ,false)) theCatNodes)
					
			)--end c loop
			
			format ")\n" to:theNodesMenu
			append RCMenuNames #allNodes
			append RCMenus (execute (theNodesMenu as string))
			--format "%\n" (theNodesMenu as string)
		)
		
		fn updateDepotDefinition =
		(
			--print "--DepotDefinition:"
			--print DepotDefinition
			DepotNodes = #()
			if MagmaFlowSettings.DepotShowCategories == true then
			(
				for i in DepotDefinition do 
				(
					if i[1][1] == "HEAD" do
						if i[1][6] == true then
							for j = 1 to i.count do append DepotNodes (deepCopy i[j])
						else
							append DepotNodes (deepCopy i[1])
				)		
			)
			else
			(
				for i in DepotDefinition do 
					for j = 2 to i.count do append DepotNodes (deepCopy i[j])
			)	
			--print "--DepotNodes:"
			--print DepotNodes
		)		
		
		fn prepareDepotForDragAndDrop =
		(
			if MagmaFlowSettings.DepotPlacement == #off do return false
			for i = 1 to DepotNodes.count do
			(
				hc.activeNode = editorNodeCount+i
				DepotNodes[i][4] = hc.activeNodePos
			)				
		)		
		
		fn createNodeBLOP theSourceFile =
		(
			::magmaNode = magma
			fileIn theSourceFile 
			local newID = magma.getNodeID (magma.getNumNodes())
			local theMouse = (((getMouseInSchematicView mode:#keyboard) - [MagmaFlowSettings.NodeWidth/2, 10]  - hc.pan ) / hc.zoom)
			MagmaFlowEditor_Functions.setUIProperty magma newID "Position" theMouse
			MagmaFlowEditor_Functions.setUIProperty magma newID "Selected" true
			MagmaFlowEditor_Functions.setUIProperty magma newID "Name" (getFileNameFile theSourceFile)
			exposeControlsToModifier()
		)
		
		fn handleDepotDragAndDrop =
		(
			local returnValue = false
			if MagmaFlowSettings.DepotPlacement == #off do return false
			for i = 1 to DepotNodes.count do
			(
				hc.activeNode = editorNodeCount+i
				if DepotNodes[i][1] != "HEAD" and DepotNodes[i][1] != "SUBHEAD" and DepotNodes[i][4] != undefined do
				(
					if (MagmaFlowSettings.DepotPlacement==#left and hc.activeNodePos.x > DepotNodes[i][4].x) or ((MagmaFlowSettings.DepotPlacement==#bottom or MagmaFlowSettings.DepotPlacement==#bottomrollup or MagmaFlowSettings.DepotPlacement==#bottomrollupreverse )and hc.activeNodePos.y < DepotNodes[i][4].y) do
					(
						lastMouseClick = getMouseInSchematicView() - [MagmaFlowSettings.NodeWidth/2,0]
						local result = (hc.findNodeByPos = getMouseInSchematicView())							
						if result  <= magma.getNumNodes() do lastSelectionBeforeClick = #(result )
						setSelectedNodes lastSelectionBeforeClick
						if DepotNodes[i][1] == "BLOP" then
						(
							if DepotNodes[i][2]  == "BLOP" then
							(
								createNode DepotNodes[i][2] 
							)
							else
							(
								createNodeBLOP DepotNodes[i][8]
							)
						)
						else
						(
							createNode DepotNodes[i][2] 
						)
						returnValue = true
						if MagmaFlowSettings.DepotAutoCollapseOnDragAndDrop do
						(
							createDepot()
							updateDepotDefinition()
						)
						createNodeTree init:true					
						exit
					)
				)
				hc.activeNodePos = DepotNodes[i][4]
			)		
			hc.redrawView		
			returnValue			
		)		
		
		fn drawDepot init:false lock:false =
		(
			updateDepotDefinition()
			if hc.height == undefined do return false --bail out if the helium control is not defined (editor is not open!)
			leftDepotMargin = 0
			if MagmaFlowSettings.DepotPlacement == #off do return false
				
			if MagmaFlowSettings.DepotPlacement == #bottom do
			(
				local DepotX = 0
				local theHCount = (hc.width/MagmaFlowSettings.DepotNodeWidth/hc.zoom) 
				local theVCount = ceil (DepotNodes.count/theHCount)
				local DepotY = (hc.height-(18+(theVCount*18/hc.zoom)))
			)
			if MagmaFlowSettings.DepotPlacement == #left do
			(
				local DepotX = 0
				local DepotY = 0
				leftDepotMargin = MagmaFlowSettings.DepotNodeWidth
			)
			
			if MagmaFlowSettings.DepotPlacement == #bottomrollup do
			(
				local DepotX = 0
				local theHCount = depotDefinition.count
				local ArrayCnt = 1
				local theVCount = if depotDefinition[ArrayCnt][1][6] then depotDefinition[ArrayCnt].count else 1
				local DepotY = (hc.height-(18+theVCount*18/hc.zoom))
			)
			if MagmaFlowSettings.DepotPlacement == #bottomrollupreverse do
			(
				local DepotX = 0
				local theHCount = depotDefinition.count
				local ArrayCnt = 1
				local theVCount = if depotDefinition[ArrayCnt][1][6] then depotDefinition[ArrayCnt].count else 1
				local DepotY = (hc.height-36)
			)	
			
			theNodeCount = editorNodeCount --magma.getNumNodes()
			for i = 1 to DepotNodes.count do
			(
				if init do hc.addNode
				hc.activeNode = theNodeCount+i
				hc.nodeName = DepotNodes[i][2]
				hc.nodeColor = DepotNodes[i][3] * (if DepotNodes[i][1]=="HEAD" then (if DepotNodes[i][6] == true then 1.0 else 0.0) else 1.0)
				hc.nodeSize = [(MagmaFlowSettings.DepotNodeWidth-2)/hc.zoom,15/hc.zoom]
				hc.nodeCollapsedSize = hc.nodeSize 
				hc.isCollapsible  = false
				try(hc.drawLayer = 3)catch()
				try
				(
					if lock then 
					(
						hc.viewAlign = -1
						hc.viewAlignOffset = [DepotX, DepotY]
					)
					else					
					(
						hc.viewAlign = 0
					)
					hc.activeNodePosRelative = [DepotX, DepotY]
				)
				catch(hc.activeNodePosRelative = [DepotX, DepotY])
				case MagmaFlowSettings.DepotPlacement of
				(
					#bottom: (
						DepotX += MagmaFlowSettings.DepotNodeWidth
						if DepotX > hc.width-MagmaFlowSettings.DepotNodeWidth  do
						(
							DepotX = 0
							DepotY+=18
						)
					)
					#left:
					(
						DepotY += 18
						if DepotY > hc.height-20 do
						(
							DepotX += MagmaFlowSettings.DepotNodeWidth
							leftDepotMargin = depotX+MagmaFlowSettings.DepotNodeWidth
							DepotY=0
						)
					)	
					/*
					#bottomrollup:
					(
						--format "depotDefinition=%\n" depotDefinition
						--format "DepotNodes=%\n" DepotNodes
						
						DepotY += 18
						if try(DepotNodes[i+1][1] == "HEAD" or DepotNodes[i+1][1] == "SUBHEAD")catch(false) do
						(
							DepotX += MagmaFlowSettings.DepotNodeWidth
							ArrayCnt += 1
							local subCategories = 1
							local theSubHeadsArray =#()
							if DepotNodes[i+1][1] == "HEAD" then 
							(
								--format "depotDefinition[ArrayCnt]=%\n" depotDefinition[ArrayCnt]
								local subHeadCount = 0
								if depotDefinition[ArrayCnt] != undefined do
								(
									for j = 1 to depotDefinition[ArrayCnt].count do
									(
										subHeadCount+=1
										if depotDefinition[ArrayCnt][j][1] == "SUBHEAD" then
										(
											append theSubHeadsArray (subHeadCount-1)
											subHeadCount = 0
										)
									)
									if theSubHeadsArray.count == 0 do theSubHeadsArray[1] = depotDefinition[ArrayCnt].count
									theVCount = if depotDefinition[ArrayCnt][1][6] then theSubHeadsArray[subCategories] else 1
								)
							)
							else if DepotNodes[i+1][1] == "SUBHEAD" then
							(
								subCategories +=1
								theVCount = theSubHeadsArray[subCategories]
							)
							DepotY = (hc.height-(18+theVCount*18/hc.zoom))						
						)					
					)	
					*/
					#bottomrollupreverse:
					(
						DepotY -= 18
						if try(DepotNodes[i+1][1] == "HEAD" or DepotNodes[i+1][1] == "SUBHEAD")catch(false) do
						(
							DepotX += MagmaFlowSettings.DepotNodeWidth
							ArrayCnt += 1
							theVCount =1 -- if try(DepotNodes[i+1][1] == "HEAD" and depotDefinition[ArrayCnt][1][6])catch(false) then depotDefinition[ArrayCnt].count else 1
							DepotY = (hc.height-36)						
						)					
					)	
				)--end case
			)
			hc.redrawView				
		)		

-----------------------------------------
--NODE SELECTION HANDLING
-----------------------------------------
		fn getSelectedNodes =
		(
			if magma != undefined then
			(
				for i = 1 to editorNodeCount collect
				(
					hc.activeNode = i	
					if hc.isSelected == true then i else dontcollect
				)
			)
			else #()
		)
		
		fn setSelectedNodes theSel =
		(
			local theCount = magma.getNumNodes()
			for i = 1 to theCount do
			(
				theID = magma.getNodeID i
				if theID > -1 do 
				(
					magma.DeclareExtensionProperty theID "Selected" 
					magma.setNodeProperty theID "Selected" false
				)
			)			
			for i in theSel where i <= theCount do
			(
				theID = magma.getNodeID i
				if theID > -1 do 
				(
					magma.setNodeProperty theID "Selected" true
				)
			)
			createNodeTree init:false
		)
		
		fn selectAllNodes =
		(
			theSel = (for i = 1 to magma.getNumNodes() collect i)
			setSelectedNodes theSel 
			createUndoRecord "Select All Nodes"				
		)		

		fn deselectAllNodes =
		(
			theSel = #()
			setSelectedNodes theSel 
			createUndoRecord "Deselect All Nodes"				
		)
		
		fn invertSelection =
		(
			local theSel = (getSelectedNodes()) as bitarray
			setSelectedNodes ((#{1..editorNodeCount} - theSel) as array)
			createUndoRecord "Invert Node Selection"
		)
		
		fn selectUnconnectedNodes =
		(
			local theSel = for i = 1 to magma.getNumNodes() where magma.getNodeProperty (magma.getNodeID i) "Internal_NodeConnected" == false collect i
			if theSel.count > 0 do
			(
				setSelectedNodes theSel
				createUndoRecord ("Select "+theSel.count as string+ " Unconnected Node" + (if theSel.count == 1 then "" else "s"))
			)
		)
		/*
		fn selectUnconnectedNodes =
		(
			FlagUnconnectedNodes()
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][4][7] == false collect i)
			--format "%\n" theIndices
			setSelectedNodesInData theIndices 
			createNodeTree init:false
			case theIndices.count of
			(
				1: createUndoRecord ("Select One Unconnected Node")
				0: createUndoRecord ("No Unconnected Nodes Selected")
				default: createUndoRecord ("Select "+theIndices.count as string +" Unconnected Nodes")
			)
		)
		
		fn selectDisabledNodes =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][5] == false collect i)
			setSelectedNodesInData theIndices 
			createNodeTree init:false
			case theIndices.count of
			(
				1: createUndoRecord ("Select One Disabled Node")
				0: createUndoRecord ("No Disabled Nodes Selected")
				default: createUndoRecord ("Select "+theIndices.count as string +" Disabled Nodes")
			)			
		)
		
		fn selectOperatorNodesOnly =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Operator" collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One Operator Node")
				0:	createUndoRecord ("No Operator Nodes Selected")
				default:	createUndoRecord ("Select "+theIndices.count as string +" Operator Nodes")
			)	
		)

		fn selectInputNodesOnly =
		(
			local theIndices = (for i = 2 to KrakatoaChannelEditor_DisplayNodeTreeData.count where KrakatoaChannelEditor_DisplayNodeTreeData[i][1] == "Input" collect i)
			setSelectedNodesInData theIndices
			createNodeTree init:false
			case theIndices.count of
			(
				1:	createUndoRecord ("Select One Input Node")
				0:	createUndoRecord ("No Input Nodes Selected")
				default:	createUndoRecord ("Select "+theIndices.count as string +" Input Nodes")
			)	
		)
		*/
		
		fn getSelectedDepotButton =
		(
			for i = editorNodeCount+1 to hc.getNodeCount-1 collect
			(
				hc.activeNode = i
				if hc.isSelected == true then i-editorNodeCount else dontcollect
			)
		)
		
		fn getDepotSelection =
		(
			for i = editorNodeCount+1 to hc.getNodeCount-1 collect
			(
				hc.activeNode = i
				if hc.isSelected == true then i else dontcollect
			)
		)
		
		fn setUndoRedoEnable = 
		(
			btn_redo.enabled = LastUndoRecordNumber < (getFiles (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+MagmaFlowEditor_UniqueUndoID+".*")).count 
			btn_undo.enabled = LastUndoRecordNumber > 1
		)
		
		fn createUndoRecord undoText =
		(
			lastInfoMessage = undoText
			hc.setInfo = lastInfoMessage 
			--format "NumEditingBLOPs = %\n" (magma.NumEditingBLOPs())
			for i = 1 to magma.NumEditingBLOPs() do magma.PopEditableBLOP() --get out to top level
			::MagmaFlowEditor_EditableBlopStack = for i in EditableBlopStack collect i
			
			local theFlowScript = MagmaFlowEditor_Functions.emitMAXScriptCode magma isUndo:true
			
			makeDir (theIniFileLocation + "MagmaFlowUndoRecords\\") all:true
			local theCount = (getFiles (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+MagmaFlowEditor_UniqueUndoID+".*")).count
			if LastUndoRecordNumber < theCount do 
			(
				for i = LastUndoRecordNumber+1 to theCount do
				(
					deleteFile (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+ MagmaFlowEditor_UniqueUndoID+"." + i as string)
				)
			)
			LastUndoRecordNumber +=1
			UndoRecordNames[LastUndoRecordNumber] = undoText
			
			local theFileName = theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+ MagmaFlowEditor_UniqueUndoID+ "." + LastUndoRecordNumber as string
			local theFileHandle = createFile theFileName
			
			with PrintAllElements true	format "%\n" theFlowScript to:theFileHandle 
			format "global MagmaFlowEditor_PlaybackDuration = %\n" MagmaFlowSettings.playbackDuration to:theFileHandle 
			format "global MagmaFlowEditor_UndoRecordName = \"%\"\n" undoText to:theFileHandle 
			format "global MagmaFlowEditor_PanAndZoom = #(%,%)\n" hc.pan hc.zoom to:theFileHandle 
			
			close theFileHandle
			
			--navigate down to the previous editing level
			--format "CurrentBLOP=%\n" magma.CurrentBLOP
			--format "EditableBlopStack = %\n" EditableBlopStack
			for i in EditableBlopStack do magma.pushEditableBLOP i
				
			setUndoRedoEnable()
		)
		
		fn undoLastStep =
		(
			local oldExposure = #()
			local newExposure = #()
			if LastUndoRecordNumber > 1 do
			(
				LastUndoRecordNumber -= 1
				oldExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
				try
				(
					magma.reset()
					::magmaNode = magma
					fileIn (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+MagmaFlowEditor_UniqueUndoID+"." + LastUndoRecordNumber as string)
					EditableBlopStack = deepCopy ::MagmaFlowEditor_EditBLOPHistory
					--for i in EditableBlopStack do magma.PushEditableBlop i
					newExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
					createNodeTree init:true
				)catch()
				try(hc.setInfo = "Undo '" + UndoRecordNames[LastUndoRecordNumber+1]+"'")catch()
				try(hc.pan = ::MagmaFlowEditor_PanAndZoom[1])catch()
				try(hc.zoom = ::MagmaFlowEditor_PanAndZoom[2])catch()
				createNodeTree init:false
				edt_log.text = ""
				setUndoRedoEnable()
				updateMagmaHolder update:false
				displaySelectedNodeProperties()
				if oldExposure.count > 0 or newExposure.count > 0 do exposeControlsToModifier()
				updateEditorTitle()
				autoReorderFlow createUndo:false
				debugFlow()
			)
		)	

		fn redoLastStep =
		(
			local oldExposure = #()
			local newExposure = #()
			if LastUndoRecordNumber < (getFiles (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+MagmaFlowEditor_UniqueUndoID+".*")).count do
			(
				LastUndoRecordNumber += 1
				try
				(
					oldExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
					magma.reset()
					::magmaNode = magma
					fileIn (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+ MagmaFlowEditor_UniqueUndoID+ "." + LastUndoRecordNumber as string)
					EditableBlopStack =  deepCopy ::MagmaFlowEditor_EditBLOPHistory
					--for i in EditableBlopStack do magma.PushEditableBlop i
					KrakatoaChannelEditor_DisplayNodeTreeData = deepCopy KrakatoaChannelEditor_NodeTreeData
					newExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
					createNodeTree init:true				
				)catch()
			
				try(hc.setInfo = "Redo '" + UndoRecordNames[LastUndoRecordNumber]+"'")catch()
				try(hc.pan = ::MagmaFlowEditor_PanAndZoom[1])catch()
				try(hc.zoom = ::MagmaFlowEditor_PanAndZoom[2])catch()
				setUndoRedoEnable()
				displaySelectedNodeProperties()
				updateMagmaHolder update:false
				if oldExposure.count > 0 or newExposure.count > 0 do exposeControlsToModifier()
				updateEditorTitle()
				autoReorderFlow createUndo:false
				debugFlow()
			)
		)		
		
		fn undoToRecord theRecord mode:#undo=
		(
			local oldExposure = #()
			local newExposure = #()
			try
			(
				oldExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
				magma.reset()
				::magmaNode = magma
				if mode == #undo then
				(
					LastUndoRecordNumber = theRecord-1
					local prefix = "Undo To '"
				)
				else
				(
					LastUndoRecordNumber = theRecord
					local prefix = "Redo To '"
				)
				
				fileIn (theIniFileLocation + "MagmaFlowUndoRecords\\UndoRecord_"+ MagmaFlowEditor_UniqueUndoID+ "." + LastUndoRecordNumber as string)
				EditableBlopStack = deepCopy ::MagmaFlowEditor_EditBLOPHistory
				--for i in EditableBlopStack do magma.PushEditableBlop i
				
				newExposure = sort (for i = 1 to magma.GetNumNodes() where (magma.getNodeProperty (magma.getNodeID i) "Exposed") == true collect (magma.getNodeID i))
				createNodeTree init:true
			)catch()
			try(hc.setInfo =  prefix+UndoRecordNames[LastUndoRecordNumber]+"'")catch()
			try(hc.pan = ::MagmaFlowEditor_PanAndZoom[1])catch()
			try(hc.zoom = ::MagmaFlowEditor_PanAndZoom[2])catch()
			setUndoRedoEnable()		
			createNodeTree init:false
			edt_log.text = ""
			updateMagmaHolder update:false
			displaySelectedNodeProperties()		
			if oldExposure.count > 0 or newExposure.count > 0 do exposeControlsToModifier()
			updateEditorTitle()
			autoReorderFlow createUndo:false
			debugFlow()
		)
				
		fn createUndoRCMenu =
		(
			global MagmaFlowEditor_UndoRCMenu
			local txt = "rcmenu MagmaFlowEditor_UndoRCMenu (\n"
			for i = LastUndoRecordNumber to 2 by -1 do
			(
				txt += "menuItem mnu_"+ i as string + " \"" + UndoRecordNames[i] + "\"\n"
				txt += "on mnu_"+ i as string + " picked do (for i in ::MagmaFlowEditor_CurrentEditors where i[5] == \""+ MagmaFlowEditor_UniqueUndoID +"\" do i[2].undoToRecord "+ i as string + " mode:#undo)\n"
			)	
			txt += ")\n"
			execute txt
		)
		
		fn createRedoRCMenu =
		(
			global MagmaFlowEditor_UndoRCMenu
			local txt = "rcmenu MagmaFlowEditor_UndoRCMenu (\n"
			for i = LastUndoRecordNumber+1 to UndoRecordNames.count do
			(
				txt += "menuItem mnu_"+ i as string + " \"" + UndoRecordNames[i] + "\"\n"
				txt += "on mnu_"+ i as string + " picked do (for i in ::MagmaFlowEditor_CurrentEditors where i[5] == \""+ MagmaFlowEditor_UniqueUndoID +"\" do i[2].undoToRecord "+ i as string + " mode:#redo)\n"
			)	
			txt += ")\n"
			execute txt
		)		
		
		on btn_Undo pressed do undoLastStep()
		on btn_Redo pressed do redoLastStep()
		
		on btn_Undo rightClick do 
		(
			createUndoRCMenu()
			popupMenu MagmaFlowEditor_UndoRCMenu pos:mouse.screenpos
		)	
		on btn_Redo rightClick do 
		(
			createRedoRCMenu()
			popupMenu MagmaFlowEditor_UndoRCMenu pos:mouse.screenpos
		)			
		
		
		local oldCollapseList = #()
		local newCollapseList = #()
		fn updateNodeSelection createUndo:true = 
		(
			local needCollapseUpdate = false
			CollapseBranches()
			oldCollapseList = for i in newCollapseList collect i
			newCollapseList = #()
			hc.drawLastIndex = 1
			for i = editorNodeCount to 1 by -1 do 
			(
				local theID = magma.getNodeID i
				--if magma.getNodeProperty theID "Internal_BranchCollapsed" != true do
				(
					hc.activeNode = i	
					if hc.activeNodePos != [-10000,-10000] do
					(
						if hc.isSelected do 
						(
							hc.drawLastIndex = i
							if MagmaFlowSettings.SnapToGrid == true and not MagmaFlowSettings.AutoReorderToggle do
							(
								local thePos = hc.activeNodePos
								thePos.x = (floor (thePos.x/MagmaFlowSettings.GridSizeX+0.5))*MagmaFlowSettings.GridSizeX
								thePos.y = (floor (thePos.y/MagmaFlowSettings.GridSizeY+0.5))*MagmaFlowSettings.GridSizeY
								hc.activeNodePos = thePos
							)
						)	
						
						if MagmaFlowSettings.AutoReorderToggle then 
							MagmaFlowEditor_Functions.setUIProperty magma theID "Internal_Position" (hc.activeNodePos)
						else
							MagmaFlowEditor_Functions.setUIProperty magma theID "Position" (hc.activeNodePos)
					)
					MagmaFlowEditor_Functions.setUIProperty magma theID "Selected" (hc.isSelected)
					MagmaFlowEditor_Functions.setUIProperty magma theID "Collapsed" (hc.activeNodeCollapsed)
					if (hc.activeNodeCollapsed) do 
					(
						--needCollapseUpdate = true
						append newCollapseList i
					)
					--if theNodeInvisibilityList[i] == false do KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = hc.activeNodePos
					--KrakatoaChannelEditor_DisplayNodeTreeData[i][4][2] = hc.activeNodeCollapsed 
					--KrakatoaChannelEditor_DisplayNodeTreeData[i][4][3] = hc.isSelected 
				)
			)
			
			if lastSelection as string != (getSelectedNodes()) as string do
			(
				lastSelection = getSelectedNodes()
				if createUndo do 
					case of
					(
						(lastSelection.count == 0): createUndoRecord ("Select No Nodes")
						(lastSelection.count == 1): createUndoRecord ("Select "+ (try(magma.GetNodeType NodeIDMap[lastSelection[1]])catch("BLOP Inputs"))   + " Node")
						(lastSelection.count > 1): createUndoRecord ("Select "+lastSelection.count as string+ " Nodes")
					)	
				displaySelectedNodeProperties()
			)
			with PrintAllElements on
			(
				if newCollapseList as string != oldCollapseList as string then
				(
					collapseBranches()
					createNodeTree init:true
				)
			)
			hc.redrawView
		)		
		
		
		fn alignAllNodesToGrid createUndo:true =
		(
			for i = 1 to magma.getNumNodes() do 
			(
				hc.activeNode = i	
				thePos = hc.activeNodePos
				thePos.x = (floor (thePos.x/MagmaFlowSettings.GridSizeX+0.5))*MagmaFlowSettings.GridSizeX
				thePos.y = (floor (thePos.y/MagmaFlowSettings.GridSizeY+0.5))*MagmaFlowSettings.GridSizeY
				hc.activeNodePos = thePos
				magma.setNodeProperty (magma.getNodeID i) "Position" thePos
				magma.setNodeProperty (magma.getNodeID i) "Internal_Position" thePos
				--KrakatoaChannelEditor_DisplayNodeTreeData[i][4][1] = hc.activeNodePos
			)	
			createNodeTree init:false
			--if createUndo do createUndoRecord ("Align All Nodes To Grid (" + GridSizeX as string + "x" + GridSizeY as string+")")
		)
		
		fn showGrid enabled =
		(
			local theX = MagmaFlowSettings.GridSizeX*hc.zoom
			local theY = MagmaFlowSettings.GridSizeY*hc.zoom

			local theBitmap = bitmap theX theY color:MagmaFlowColors.EditorBackgroundColor 
			
			if enabled and hc.zoom > 0.9 do
			(
				thePixels = for i = 1 to theX collect MagmaFlowColors.GridColor
				setPixels theBitmap [0,0] thePixels
				for i = 1 to theY do 
					setPixels theBitmap [0,i-1] #(MagmaFlowColors.GridColor)
			)
			
			hc.backgroundBitmap = theBitmap
			hc.tileBackground = true
		)
		

		fn toggleSnapToGrid =
		(
			MagmaFlowSettings.SnapToGrid = not MagmaFlowSettings.SnapToGrid
			setIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "Grid" "SnapToGrid" (MagmaFlowSettings.SnapToGrid as string)
			showGrid MagmaFlowSettings.SnapToGrid
			hc.redrawView			
		)			
		
		fn initSchematicView =
		(
			hc.drawShadows = MagmaFlowSettings.DrawShadows
			hc.allowZoom  = true
			hc.zoomAboutMouse = false
			hc.drawMenuBars = true
			hc.allowUIDelete = true
			hc.showInfo = true
			hc.setInfo = ""
			hc.pan = [0,0]
		)
		
		
		fn openCurveEditor theID =
		(
			local existingEditors = (for i in ::MagmaFlowEditor_CurrentCurveEditors where i[1] == magma and i[2] == theID collect i)
			if existingEditors.count == 0 then
			(
				magma.declareExtensionProperty theID "CurveEditorPosition"
				local thePos = magma.getNodeProperty theID "CurveEditorPosition"
				local CurveControlEditor = fileIn (FranticParticles.KrakatoaHome + "Scripts\\Krakatoa_MagmaFlowCurveEditor.ms")
				::MagmaFlowEditor_CurrentMagmaHolder = magma
				::MagmaFlowEditor_CurrentMagmaNode = theID
				if thePos == undefined then
					createDialog CurveControlEditor 480 500
				else
					createDialog CurveControlEditor 480 500 thePos.x thePos.y
				
				CurveControlEditor.title = "Curve Editor - ID " + theID as string
				append ::MagmaFlowEditor_CurrentCurveEditors #(magma, theID, CurveControlEditor, MagmaFlowEditor_Rollout)
			)
			else
				setFocus (existingEditors[1][3])
		)
		
		fn closeAllCurveEditors =
		(
			for i = ::MagmaFlowEditor_CurrentCurveEditors.count to 1 by -1 where ::MagmaFlowEditor_CurrentCurveEditors[i][4] == MagmaFlowEditor_Rollout do 
			(
				try(destroyDialog MagmaFlowEditor_CurrentCurveEditors[i][3])catch()
			)
		)
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--EXPOSE CONTROLS FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		local theCADef, theCADef2, theCADef3, theCADCnt, theCALevel, theColorPickersToUpdate
		
		fn exposeSubLevel =
		(
			local txt1 = ""
			local txt2 = ""
			local txt3 = ""
			for i = 1 to magma.getNumNodes() do
			(
				local id = magma.getNodeID i
				if magma.getNodeProperty id "Exposed" == true AND  findItem #(#InputGeometry, #InputObject, #InputParticles) ((magma.getNodeType id) as name) > 0 do
				(
					local theNameString1, theNameString2, theTooltip1, theTooltip2
					
					local theName = MagmaFlowEditor_Functions.getNodeName magma id 
					local theTooltip = magma.getNodeProperty id "Notes"
					local theClassString = "object"
					if theTooltip == undefined do theTooltip = theName
					(
						local theNameString = "Pick Scene Object..."
						case (magma.getNodeType ID) as name of
						(
							default: (
								txt2 +=  "fn pickObjectsFilter"+id as string+" obj = ( true ) \n"
							)
							#InputGeometry: 
							(
								txt2 += "fn pickObjectsFilter"+id  as string+" obj = (findItem ::MagmaFlowEditor_GlobalPickFilterArray"+id as string+" obj == 0 AND findItem GeometryClass.classes (classof obj) > 0 AND classof obj != targetObject and  findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) == 0 )\n"
								theClassString = "nodes"
								theNameString = "Get by Name"
								theNameString2 = "Pick in Scene"
								theTooltip = "Get multiple Objects by name..."
								theTooltip2 = "Get one Object by clicking in the viewport..."
							)
							#InputParticles: 
							(
								txt2 += "fn pickObjectsFilter"+id  as string+" obj = ( findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) > 0 and findItem ::MagmaFlowEditor_GlobalPickFilterArray"+id as string+" obj == 0)\n" 
								theNameString = "Pick Particle Object..."
								theClassString = "node"
							)
						)
						--local theName = theNameString
						if theClassString == "nodes" then
						(
							theCADCnt+=1
							txt2 += "group \""+id  as string + ": "+theName+"\" (\n"
							txt2 += "button btn_node1_"+id as string+" \""+theNameString+"\" width:75 offset:[-7,-4] align:#left across:2 tooltip:\""+theTooltip+"\" \n"     
							txt2 += "pickbutton btn_node2_"+id as string+" \""+theNameString2+"\" width:75 offset:[7,-4] align:#right tooltip:\""+theTooltip2+"\" filter:pickObjectsFilter"+id as string+"\n"     
							
							txt2 += "multilistbox lbx_nodes"+id as string+" width:150 align:#center offset:[0,-4] \n"  
							txt2 += "button btn_removenodes"+id as string+" \"Remove Nodes\" width:150 align:#center offset:[0,-4] tooltip:\"Remove highlighted nodes from the input's list...\" \n" 
							txt2 += ")\n"
							
							txt2 += "fn updateNodesList"+id as string+" = (\n" 
							txt2 += "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 += "local allNodes = theMod.getNodeProperty "+id as string+" \"nodes\" \n"     
							txt2 += "::MagmaFlowEditor_GlobalPickFilterArray"+id as string+" = allNodes \n"
							txt2 += "lbx_nodes"+id as string+".items =  for i in allNodes collect if isValidNode i then i.name else \"<deleted>\" \n"  
							txt2 +=  ")\n" 
							
							txt2 +=  "on btn_removenodes"+id as string+" pressed do (\n" 
							txt2 +=  "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 +=  "local theNodes = theMod.getNodeProperty "+id as string+" \"nodes\" \n" 
							txt2 +=  "local theSel = lbx_nodes"+id as string+".selection as array \n" 
							txt2 +=  "for i = theSel.count to 1 by -1 do deleteItem theNodes theSel[i] \n" 
							txt2 +=  "theMod.setNodeProperty "+id as string+" \"nodes\" theNodes\n"  
							txt2 +=  "updateNodesList"+id as string+"()\n" 
							txt2 +=  "updateMod sel:true\n" 
							txt2 +=  ")\n" 
							
							txt3 +=  "updateNodesList"+id as string+"()\n" 
							
							txt2 +=  "on btn_node1_"+id as string+" pressed do (\n"  
							txt2 +=  "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 +=  "local allNodes = theMod.getNodeProperty "+id as string+" \"nodes\" \n"    
							txt2 += "::MagmaFlowEditor_GlobalPickFilterArray"+id as string+" = allNodes \n"							
							txt2 +=  "local theNodes = selectByName title:\""+theNameString+"\" filter:pickObjectsFilter"+id as string+" showHidden:false single:false \n"   
							txt2 +=  "if theNodes != undefined do (\nfor o in theNodes do appendIfUnique allNodes o\n" 
							txt2 +=  "theMod.setNodeProperty "+id as string+" \"nodes\" allNodes\n"
							txt2 +=  "updateMod sel:true\n" 
							txt2 +=  "updateNodesList"+id as string+"()))\n" 
							
							txt2 +=  "on btn_node2_"+id as string+" picked obj do (\n"  
							txt2 +=  "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 +=  "local allNodes = theMod.getNodeProperty "+id as string+" \"nodes\" \n"    
							txt2 += "::MagmaFlowEditor_GlobalPickFilterArray"+id as string+" = allNodes \n"							
							txt2 +=  "if obj != undefined do (\nappendIfUnique allNodes obj\n" 
							txt2 +=  "theMod.setNodeProperty "+id as string+" \"nodes\" allNodes\n"
							txt2 +=  "updateMod sel:true\n" 
							txt2 +=  "updateNodesList"+id as string+"()))\n" 							
						)
						else
						(
							theCADCnt+=1
							txt2 += "group \""+id  as string + ": "+theName+"\" (\n"
							txt2 += "pickbutton btn_node"+id as string+" \""+theNameString+"\" width:150 align:#center offset:[0,-4] tooltip:\""+theNameString+"\" filter:pickObjectsFilter"+id as string+"\n"     
							txt2 +=  ")\n" 
							
							txt2 += "fn updatePickButton"+id as string+" = (\n"
							txt2 += "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 += "local theNode = theMod.getNodeProperty "+id as string+" \""+theClassString+"\" \n"     
							--txt2 += "print theNode \n"     
							
							txt2 += "btn_node"+id as string+".caption =  if isValidNode theNode then theNode.name else \""+theNameString+"\" \n"  
							txt2 +=  ")\n" 							

							txt3 +=  "updatePickButton"+id as string+"()\n" 
							
							txt2 +=  "on btn_node"+id as string+" picked theNode do (\n"  
							txt2 +=  "local theMod = (custAttributes.getOwner this).magmaHolder\n"
							txt2 +=  "if isValidNode theNode do (\n" 
							txt2 +=  "theMod.setNodeProperty "+id as string+" \""+theClassString+"\" theNode\n"
							txt2 +=  "updateMod sel:true\n" 
							txt2 +=  "updatePickButton"+id as string+"()))\n" 
						)						
					)						
				)
				if magma.getNodeProperty id "Exposed" == true AND magma.getNodeType id == "InputValue" do
				(
					local theName = MagmaFlowEditor_Functions.getNodeName magma id 
					local theTooltip = magma.getNodeProperty id "Notes"
					if theTooltip == undefined do theTooltip = id as string + ": "+ theName
					
					if classof (magma.getNodeProperty id "controller").value == Float and magma.getNodeProperty id "forceInteger" == false do
					(
						theCADCnt+=1
						txt1 += "float_"+id as string+ " type:#float ui:spn_"+id as string+" default:1 \n"
						txt2 += "spinner spn_"+id as string+" \""+id as string + ": "+theName+": \" type:#float align:#right fieldwidth:50 range:[-100000,100000,0] scale:0.01 offset:[12,-2] tooltip:\""+ theTooltip+"\"\n"
						txt2 += "on spn_"+id as string+" changed val do updateMod()\n"
					)--end if
					if classof (magma.getNodeProperty id "controller").value == Float and magma.getNodeProperty id "forceInteger" == true do
					(
						theUpstreamNode = MagmaFlowEditor_Functions.getConnectedNodes magma id
						-- format "theUpstreamNode =%\n" theUpstreamNode 
						if theUpstreamNode[1].count == 1 do
						case of
						(
							(magma.getNodeType theUpstreamNode[1][1][1] == "Mux" AND theUpstreamNode[1][1][2] == magma.getNumNodeInputs theUpstreamNode[1][1][1]):
							(
								local theMuxID = theUpstreamNode[1][1][1]
								local theItems = #()
								for m = 1 to (magma.getNumNodeInputs theMuxID)-1 do
								(
									theInput = magma.getNodeInput theMuxID m
									if theInput[1] > -1 then
									(
										local theInName = magma.getNodeProperty theInput[1] "Name"
										if theInName == undefined do theInName = magma.getNodeType theInput[1]
										theTooltip = magma.getNodeProperty theInput[1] "Notes"
									)
									else 
										theInName = "<Unconnected>"
									append theItems ((m-1) as string +":"+theInName)
								)
								theCADCnt+=1
								txt1 += "int_"+id as string+ " type:#integer default:1 \n"
								--txt1 += "on int_"+id as string + " get val do params.updateUI()\n"
								
								with PrintAllElements on txt2 += "listbox ddl_"+id as string+" \""+id as string + ": "+theName+": \" align:#center width:150 offset:[0,-2] items:"+theItems as string+" height:"+theItems.count as string+"\n"
								txt2 += "on ddl_"+id as string+" selected val do (\n"
								txt2 += "int_"+id as string+" = val-1\n"
								txt2 += "updateMod()\n"
								txt2 += ")\n"
								txt3 += "ddl_"+id as string+".selection = int_"+id as string +"+1\n"
							)
							(magma.getNodeType theUpstreamNode[1][1][1] == "Switch" AND theUpstreamNode[1][1][2] == magma.getNumNodeInputs theUpstreamNode[1][1][1]):
							(
								local theMuxID = theUpstreamNode[1][1][1]
								theCADCnt+=1
								txt1 += "int_"+id as string+ " type:#integer default:1 \n"
								txt1 += "on int_"+id as string + " set val do print val\n"
								
								txt2 += "checkbutton chk_"+id as string+" \">"+id as string + ": "+theName+"\" align:#center width:150 offset:[0,-2] tooltip:\""+theTooltip+"\"\n"
								txt2 += "on chk_"+id as string+" changed val do (\n"
								txt2 += "int_"+id as string+" = if val then 1 else 0\n"
								txt2 += "updateMod()\n"
								txt2 += ")\n"
								txt3 += "chk_"+id as string+".state = (int_"+id as string +" != 0)\n"
							)							
							default:
							(
								theCADCnt+=1
								txt1 += "int_"+id as string+ " type:#integer ui:spn_"+id as string+" default:1 \n"
								local theTooltip = magma.getNodeProperty id "Notes"
								if theTooltip == undefined do theTooltip = theName
								txt2 += "spinner spn_"+id as string+" \""+id as string + ": "+theName+": \" type:#integer align:#right fieldwidth:50 range:[-100000,100000,1] offset:[12,-2] tooltip:\""+ theTooltip+"\"\n"
								txt2 += "on spn_"+id as string+" changed val do updateMod()\n"
							)
						)
					)--end i loop
					if classof (magma.getNodeProperty id "controller").value == Point3 do
					(
						txt2 += "group \""+id as string + ": "+theName+"\"(\n"

						theCADCnt+=1				
						txt1 += "vect_"+id as string+"_"+theCADCnt as string+ " type:#float ui:spn_"+id as string+"_"+theCADCnt as string+"\n"
						
						txt2 += "spinner spn_"+id as string+"_"+theCADCnt as string+" \"X: \" type:#float range:[-1000000,1000000,0] align:#right fieldwidth:50 offset:[5,-3] scale:0.01 tooltip:\""+ theTooltip+"\"\n"
						
						theCADCnt+=1
						txt1 += "vect_"+id as string+"_"+theCADCnt as string+ " type:#float ui:spn_"+id as string+"_"+theCADCnt as string+"\n"
						txt2 += "spinner spn_"+id as string+"_"+theCADCnt as string+" \"Y: \" type:#float range:[-1000000,1000000,0] align:#right fieldwidth:50 offset:[5,-3] scale:0.01 tooltip:\""+ theTooltip+"\"\n"
						
						theCADCnt+=1
						txt1 += "vect_"+id as string+"_"+theCADCnt as string+ " type:#float ui:spn_"+id as string+"_"+theCADCnt as string+"\n"
						txt1 += "fullvect_"+id as string+"_"+theCADCnt as string+ " type:#color animatable:false\n" 
						
						txt2 += "spinner spn_"+id as string+"_"+theCADCnt as string+" \"Z: \" type:#float range:[-1000000,1000000,0] align:#right fieldwidth:50 offset:[5,-3] scale:0.01 tooltip:\""+ theTooltip+"\"\n"

						txt2 += "colorpicker clr_"+id as string+"_"+theCADCnt as string+" \"\" align:#left offset:[-5,-56] height:50 width:48 alpha:true modal:true tooltip:\""+ theTooltip+"\"\n"
						append theColorPickersToUpdate #(id,theCADCnt)

						txt2 += ")--end group\n"
						
						txt2 += "on clr_"+id as string+"_"+theCADCnt as string+" changed val do (\n"
						txt2 += "vect_"+id as string+"_"+(theCADCnt-2) as string+ " = val.r/255.0\n"
						txt2 += "vect_"+id as string+"_"+(theCADCnt-1) as string+ " = val.g/255.0\n"
						txt2 += "vect_"+id as string+"_"+(theCADCnt) as string+ " = val.b/255.0\n"
						txt2 += "updateMod()\n"
						txt2 += ")\n"
						
						txt1 += "on vect_"+id as string+"_"+(theCADCnt-2) as string+ " get val do (\n"
						txt1 += "theColor = [val,vect_"+id as string+"_"+(theCADCnt-1) as string+ ",vect_"+id as string+"_"+(theCADCnt) as string+" ]*255.0\n"
						txt1 += "params.clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt1 += "val)\n"

						txt1 += "on vect_"+id as string+"_"+(theCADCnt-1) as string+ " get val do (\n"
						txt1 += "theColor = [vect_"+id as string+"_"+(theCADCnt-2) as string+ ",val,vect_"+id as string+"_"+(theCADCnt) as string+" ]*255.0\n"
						txt1 += "params.clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt1 += "val)\n"
						
						txt1 += "on vect_"+id as string+"_"+(theCADCnt) as string+ " get val do (\n"
						txt1 += "theColor = [vect_"+id as string+"_"+(theCADCnt-2) as string+ ",vect_"+id as string+"_"+(theCADCnt-1) as string+",val]*255.0\n"
						txt1 += "params.clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt1 += "val)\n"				
						
						txt2 += "on spn_"+id as string+"_"+(theCADCnt-2) as string+" changed val do (\n"
						txt2 += "local theColor = clr_"+id as string+"_"+theCADCnt as string +".color \n"
						txt2 += "theColor.r = val*255.0\n"
						txt2 += "clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt2 += "fullvect_"+id as string+"_"+theCADCnt as string+ " = theColor\n"				
						txt2 += "updateMod()\n)\n"
						
						txt2 += "on spn_"+id as string+"_"+(theCADCnt-1) as string+" changed val do (\n"
						txt2 += "local theColor = clr_"+id as string+"_"+theCADCnt as string +".color \n"
						txt2 += "theColor.g = val*255.0\n"

						txt2 += "clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt2 += "updateMod()\n)\n"				
						
						txt2 += "on spn_"+id as string+"_"+(theCADCnt) as string+" changed val do (\n"
						txt2 += "local theColor = clr_"+id as string+"_"+theCADCnt as string +".color \n"
						txt2 += "theColor.b = val*255.0\n"
						
						txt2 += "clr_"+id as string+"_"+theCADCnt as string+ ".color = theColor\n"
						txt2 += "updateMod()\n)\n"					
						
					)--end vector		
				)--end if exposed
			)--end i loop	
			#(txt1, txt2, txt3)
		)
		
		fn exposeBLOPsRecursively =
		(
			for i = 1 to magma.getNumNodes() do
			(
				local id = magma.getNodeID i
				if magma.getNodeType id == "BLOP" do
				(
					magma.pushEditableBLOP id
					local theName = magma.getNodeProperty id "Name"
					if theName == undefined do theName = "BLOP"
					theCADCntBefore = theCADCnt
					local result = exposeSubLevel()
					if theCADCnt != theCADCntBefore do 
					(
						theCALevel += 1
						theCADef2 += "checkbutton btn_level_"+theCALevel as string + " \""+ id as string + ": "+ theName + "\" width:164 border:false align:#center offset:[0,-2] highlightcolor:((colorman.getColor #background)*200) height:18 checked:true tooltip:\"Exposed Controls of BLOP\n"+ id as string+": "+theName+"\"\n "
						theCADef2 += "on btn_level_"+theCALevel as string + " changed state do btn_level_"+theCALevel as string + ".state = true\n "
					)
					theCADef += result[1]
					theCADef2 += result[2]
					theCADef3 += result[3]
					exposeBLOPsRecursively()
					magma.popEditableBLOP()
				)
			)
		)
		
		fn connectCAControllers theCAName theMod =
		(
			for i = 1 to magma.getNumNodes() do
			(
				local id = magma.getNodeID i
				if magma.getNodeProperty id "Exposed" == true AND magma.getNodeType id == "InputValue" do
				(
					local theController = (magma.getNodeProperty id "controller")
					if classof theController.value == Float do
					(
						theCADCnt+=1
						theMod.custAttributes[theCAName][theCADCnt].value = theController.value
						theMod.custAttributes[theCAName][theCADCnt].controller = theController
					)	
					if classof theController.value == Point3 do
					(
						if classof theController == Point3_XYZ then
						(
							theCADCnt+=1
							theMod.custAttributes[theCAName][theCADCnt].value = theController[1].controller.value
							theMod.custAttributes[theCAName][theCADCnt].controller = theController[1].controller
							theCADCnt+=1
							theMod.custAttributes[theCAName][theCADCnt].value = theController[2].controller.value
							theMod.custAttributes[theCAName][theCADCnt].controller = theController[2].controller
							theCADCnt+=1
							theMod.custAttributes[theCAName][theCADCnt].value = theController[3].controller.value
							theMod.custAttributes[theCAName][theCADCnt].controller = theController[3].controller
						)
						else
						(
							theCADCnt+=3
						)
					)	
				)
			)	
		)
		
		fn connectBLOPsRecursively theCAName theMod =
		(
			for i = 1 to magma.getNumNodes() do
			(
				local id = magma.getNodeID i
				if magma.getNodeType id == "BLOP" do
				(
					magma.pushEditableBLOP id
					connectCAControllers theCAName theMod
					connectBLOPsRecursively theCAName theMod
					magma.popEditableBLOP()
				)
			)			
		)
		
		fn exposeControlsToModifier =
		(
			theMod = (for i in refs.dependents magma where isKindOf i MagmaModifier or isKindOf i GeometryMagmaChannels collect i)[1]
			if theMod == undefined do return false
				
			theCALevel = 0
				
			KrakatoaChannelEditor_IsUpdatingExposure = true
			--KrakatoaChannelsEditor_Functions.updateParentModifier suppressRedraw:true
			
			try(modpanel.setCurrentObject theMod)catch()
			try(deleteItem theMod.custAttributes ("KCM_CA" as name)	)catch()
			
			try(modpanel.setCurrentObject theMod)catch()
			theCADef2 = "rollout params \"Exposed Parameters\" category:10000\n("
			
			theCADef2 += "fn updateMod sel:false= (\n"
			theCADef2 += "local theMod = (custAttributes.getOwner this).magmaHolder\n"
			theCADef2 += "local done = false\n"
			theCADef2 += "for i in MagmaFlowEditor_CurrentEditors where i != undefined AND i[1] == theMod AND i[2].open while not done do (\n"
			theCADef2 += "i[2].updateMagmaHolder updateName:false\n"
			theCADef2 += "if i[4].open do (\n"
			theCADef2 += "i[4].updateControls()\n"
			theCADef2 += "i[2].createNodeTree init:false\n"
			theCADef2 += "done = true\n"
			theCADef2 += ")\n"
			theCADef2 += "if sel == true do (i[2].displaySelectedNodeProperties())\n"
			theCADef2 += "if not done and theMod.autoUpdate do theMod.autoUpdate = theMod.autoUpdate \n"
			theCADef2 += "))\n"
			
			theCADef3 = "fn updateUI = ( \n"
			
			theCADef = "KCM_CA_DEF = attributes KCM_CA (\n"
			theCADef += "local params \n"
			theCADef += "parameters main rollout:params ( \n"
			
			theColorPickersToUpdate = #()
			
			theCADCnt = 0
			
			for j = 1 to magma.NumEditingBLOPs() do magma.PopEditableBLOP()
			
			local result = exposeSubLevel()
			theCADef += result[1]
			theCADef2 += result[2]
			theCADef3 += result[3]
			
			exposeBLOPsRecursively()

			theCADef += ")--end main params\n"
			
			for j in theColorPickersToUpdate do
			(
				theCADef3 += "fullvect_"+j[1] as string +"_"+j[2] as string +" = clr_"+j[1] as string + "_"+j[2] as string+".color = [vect_"+j[1] as string +"_"+(j[2]-2) as string+",vect_"+j[1] as string +"_"+(j[2]-1) as string+", vect_"+j[1] as string +"_"+j[2] as string+"]*255.0 \n"
			)
			
			
			theCADef3 += ")--end updateUI\n"
			theCADef3 += "on params open do updateUI()\n"

			theCADef2 += theCADef3 
			theCADef2 += ")--end rollout\n"
			theCADef2 += ")--end def\n"
			
			if theCADCnt > 0 do
			(
				--print (theCADef+theCADef2)
				KCM_CA_DEF = execute (theCADef+theCADef2)
				custAttributes.add theMod KCM_CA_DEF
				local theCAName = ("KCM_CA" as name)
				
				max modify mode
				try(modPanel.setCurrentObject theMod)catch()

				theCADCnt = 0

				connectCAControllers theCAName theMod
				connectBLOPsRecursively theCAName theMod
				
				for i in EditableBlopStack do magma.pushEditableBLOP i

				try(modpanel.setCurrentObject theMod)catch()
				setFocus KrakatoaChannelNodeEditor_Rollout.hc
			)
			KrakatoaChannelEditor_IsUpdatingExposure = false
		)		
		
		fn exposeSelectedInputs newState:true =
		(
			local needUpdate = false
			local theSel = getSelectedNodes()
			for i in theSel do
			(
				local ID = magma.getNodeID i
				local theType = magma.getNodeType ID
				if theType as name == #InputValue do
				(
					magma.DeclareExtensionProperty ID "Exposed"
					magma.setNodeProperty ID "Exposed" newState
					needUpdate = true
				)
			)
			if needUpdate do
			(
				exposeControlsToModifier()
				createNodeTree init:false
			)
			displaySelectedNodeProperties()
		)
		
		fn selectExposedInputs =
		(
			local theSel = #()
			for i = 1 to magma.getNumNodes() do
			(
				local ID = magma.getNodeID i
--				local theType = magma.getNodeType ID
--				if theType == #InputValue do
					if magma.getNodeProperty ID "Exposed" == true do
						append theSel i
			)
			--format "theSel=%\n" theSel
			setSelectedNodes theSel
		)
		
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--NODE PROPERTIES FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		fn getObjectInputNode ID type =
		(
			local result = undefined
			for i = 1 to magma.getNumNodeInputs ID do
			(
				local theInput = (magma.getNodeInput ID i)
				--format "theInput = %\n" theInput 
				if theInput != undefined and theInput[1] > -1 do
				(
					if type == #prt and (magma.getNodeType theInput[1]) == "InputParticles" do result = magma.getNodeProperty theInput[1] "node"
					if type == #prop and (magma.getNodeType theInput[1]) == "InputObject" do result = magma.getNodeProperty theInput[1] "object"
					if type == #geo and (magma.getNodeType theInput[1]) == "InputGeometry" do result = (magma.getNodeProperty theInput[1] "nodes")[1]
				)
			)
			result
		)
		
		fn insertConvertToFloat =
		(
			MagmaFlowSettings.nodeInsertMode = true
			local currentID =  (magma.getNodeID MagmaFlowEditor_Rollout.lastNodeClick)
			local newID = MagmaFlowEditor_Rollout.createNode "ToFloat" mode:#button
			magma.setNodeInput newID 1 currentID 1
			MagmaFlowEditor_Rollout.setSelectedNodes #(MagmaFlowEditor_Rollout.lastNodeClick)
			MagmaFlowEditor_Rollout.updateMagmaHolder init:true
		)
		
		local DynamicPropertiesRollout
		fn createDynamicPropertiesRollout ID =
		(
			if ID >-1 then 
			(
				local properties = ( for i = 1 to magma.GetNumNodeProperties ID collect 
				( 
					local theFS = (filterstring (magma.GetNodePropertyInfo ID i) " :")
					local propName = theFS[1]
					local propType = theFS[2]
					#((magma.GetNodePropertyInfo id i), propName, magma.getNodeProperty id propName, propType ) 
				)
				)
				local theCurrentEditorIndex = (for i = 1 to MagmaFlowEditor_CurrentEditors.count where MagmaFlowEditor_CurrentEditors[i][1] == magma collect i)[1]
				MagmaFlowEditor_CurrentEditors[theCurrentEditorIndex][3] = ID
				
				local txt =  "" as stringStream
				format "rollout DynamicPropertiesRolloutGlobal \"Properties and Actions\" category:120 (\n" to:txt
				local cnt = 0
				local hasControls = false
				
				if findItem #(#Equal,#Greater,#GreaterOrEqual,#Less, #LessOrEqual) ((magma.GetNodeType ID) as name) > 0 do
				(
					format "button btn_convertToFloat \"Convert To Float\" width:160 offset:[0,-3] align:#center tooltip:\"Insert a ToFloat Operator to convert the Boolean value to a Floating Point value.\" \n" to:txt
					format "on btn_convertToFloat pressed do MagmaFlowEditor_CurrentEditors[%][2].insertConvertToFloat() \n" theCurrentEditorIndex to:txt
					hasControls = true
				)

				
				for p in properties do
				(
					cnt +=1
					local displayName = ""
					for i = 1 to p[2].count do 
					(
						if bit.charasint p[2][i] >= 65 and bit.charasint p[2][i] <= 90 do displayName += " "
						displayName += p[2][i]
					)
					if bit.charasint displayName[1] >= 97 and bit.charasint displayName[1] <= 122 do displayName[1] = bit.intAsChar ((bit.charAsInt displayName[1]) - 32)
					--format "% %\n" p[2] p[4]
					if not matchPattern p[2] pattern:"enabled" do
					(
						local acceptedValues = magma.GetNodePropertyAcceptedValues ID p[2]
						--format "acceptedValues = %\n" acceptedValues 
						if matchPattern p[4] pattern:"String" and classof acceptedValues == Array then
						(
							local theValue = magma.getNodeProperty ID p[2]
							format "label lbl_% \"%:\" align:#left across:2 offset:[-10,0]\n" cnt displayName to:txt
							format "dropdownlist ddl_% items:% align:#right offset:[10,-3] selection:%\n" cnt acceptedValues (findItem acceptedValues theValue) to:txt
							format "on ddl_% selected itm do (\n" cnt to:txt
							format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" ddl_%.selected \n"  theCurrentEditorIndex theCurrentEditorIndex p[2] cnt to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false\n" theCurrentEditorIndex  to:txt 							
							format ")\n" to:txt
							hasControls = true
						)
						else if matchPattern p[4] pattern:"CSV" and magma.getNodeType ID != "InputTexmap" then
						(
							local theType = magma.GetNodeType ID
							if findItem #("FaceQuery", "ParticleQuery", "PropertyQuery", "ParticleSumRadius", "ParticleSumCount") theType > 0 then
							(
								local theVal = filterString p[3] ", "
								local lastConnection = 0
								local theConnections = MagmaFlowEditor_Functions.getConnectedNodes magma ID 
								for i = 1 to theConnections.count where theConnections[i].count > 0 do lastConnection = i
								local thePossibleVal = #()
								local theObject = undefined
								local maxCount = 10
								case of
								(
									(theType == "FaceQuery") : 
									(
										thePossibleVal = #("Selection","Normal","SmoothingGroup","MaterialID")
										theObject = getObjectInputNode ID #geo
										if isValidNode theObject do
										(
											local theMesh = snapShotAsMesh theObject
											if meshop.getMapSupport theMesh 0 do append thePossibleVal "Color"
											if meshop.getMapSupport theMesh 1 do append thePossibleVal "TextureCoord"
											for m = 2 to 99 where meshop.getMapSupport theMesh m do append thePossibleVal ("Mapping"+m as string)
											delete theMesh
										)
										maxCount = thePossibleVal.count-1
										if maxCount < 3 do maxCount = 3
										thePossibleVal = for i in thePossibleVal where findItem theVal i == 0 collect i
										theListName = " Exposed Mesh Channels:"
									)
									(theType == "ParticleQuery" OR theType =="ParticleSumRadius" OR theType == "ParticleSumCount"): 
									(
										channelsList = MagmaFlowEditor_Functions.loadChannelsList mode:#input
										thePossibleVal = MagmaFlowEditor_Functions.getSortedChannelsList channelsList 3 theIniFileLocation --#("Position","Color","Normal","Velocity")
										maxCount = thePossibleVal.count-1
										thePossibleVal = for i in thePossibleVal where findItem theVal i == 0 and not matchPattern i pattern:"[*]" collect i
										theListName = " Exposed Particle Channels:"
										theObject = getObjectInputNode ID #prt
										if isValidNode theObject and magma.getNodeProperty ID "ShowAvailableChannelsOnly" == true do
										(
											try
											(
												local currentStream = FranticParticles.GetPRTObjectIStream theObject
												theChannels = currentStream.GetChannels()
												theChannelNames = for i in theChannels collect i[1]
												currentStream.close()
												maxCount = theChannelNames.count-1
												thePossibleVal = for i in theChannelNames where findItem theVal i == 0 collect i
											)catch()
										)
									)
									(theType == "PropertyQuery" ) : 
									(
										thePossibleVal = #("Pos","Rotation","Scale","Center") --,"Visibility"
										theObject = getObjectInputNode ID #prop
										if isValidNode theObject do
										(
											local theProps = getPropNames theObject
											for p in theProps do append thePossibleVal (p as string)
											for m in theObject.modifiers do
											(
												theProps = getPropNames m
												for p in theProps do
												append thePossibleVal ("modifiers[#"+m.name+"]."+p as string)
											)
										)
										maxCount = thePossibleVal.count-1
										thePossibleVal = sort (for i in thePossibleVal where findItem theVal i == 0 collect i)
										theListName = " Exposed Object Properties:"
									)								
								)
								with printAllElements on format "listbox lbx_on_% \"%\" items:% width:164 align:#center height:% offset:[0,-5] \n" cnt theListName theVal (amin #(maxCount,4)) to:txt
								format "edittext edt_property_% align:#left offset:[-15,-5] fieldwidth:163  \n" cnt  to:txt
								format "button btn_on_% \"Add...\" across:2 width:82 align:#left offset:[-12,-5] tooltip:\"Press to Expose the Mesh Channel selected in the drop-down list\" \n" cnt to:txt
								format "button btn_off_% \"Remove...\" width:82 align:#right offset:[12,-5] tooltip:\"Press to Un-expose the Channel selected in the list box.\"\n" cnt to:txt
								if (theType == "ParticleQuery" OR theType == "NParticlesAvg" OR theType =="ParticleSumRadius" OR theType == "ParticleSumCount" OR theType == "ParticleKernel" ) do
								(
									format "checkbutton chk_ShowAvailableChannelsOnly \">Available Channels Only\" align:#center width:164 offset:[0,-4] checked:%\n" (magma.getNodeProperty ID "ShowAvailableChannelsOnly" == true) to:txt
									format "on chk_ShowAvailableChannelsOnly changed state do (\n" to:txt
									format "MagmaFlowEditor_CurrentEditors[%][1].DeclareExtensionProperty MagmaFlowEditor_CurrentEditors[%][3] \"ShowAvailableChannelsOnly\" \n" theCurrentEditorIndex theCurrentEditorIndex to:txt
									format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"ShowAvailableChannelsOnly\" state\n" theCurrentEditorIndex theCurrentEditorIndex to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].displaySelectedNodeProperties()\n" theCurrentEditorIndex  to:txt 
									format ")\n" to:txt
								)
								with printAllElements on format "dropdownlist lbx_off_% items:% width:164 align:#center height:10 offset:[0,-5] tooltip:\"Select a pre-defined Channel from the list and press [Add...] to Expose as Output...\"\n" cnt thePossibleVal to:txt --(amin #(maxCount,10)) 

									
								format "fn updateCSVProperty = (\n" to:txt
								format "local txt = \"\"\n" to:txt
								format "for i = 1 to lbx_on_%.items.count-1 do txt += lbx_on_%.items[i] + \",\" \n" cnt cnt to:txt
								format "if lbx_on_%.items.count > 0 do txt += lbx_on_%.items[lbx_on_%.items.count] \n" cnt cnt cnt to:txt
								format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" txt \n" theCurrentEditorIndex theCurrentEditorIndex p[2] to:txt
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n" theCurrentEditorIndex  to:txt 							
								format ")\n" to:txt
									
								format "on edt_property_% entered txt do (" cnt to:txt
								format "lbx_on_%.items = append lbx_on_%.items txt\n" cnt cnt to:txt								
								format "updateCSVProperty())\n" to:txt
									
								format "fn addToList itm = (\n" to:txt
								format "if itm > 0 and itm <=  lbx_off_%.items.count do (\n" cnt to:txt
								format "lbx_on_%.items = (append lbx_on_%.items lbx_off_%.selected)\n" cnt cnt cnt to:txt
								format "lbx_off_%.items = sort (deleteItem lbx_off_%.items itm)\n" cnt cnt to:txt
								format "updateCSVProperty()))\n" to:txt

								format "fn removeFromList itm = (\n" to:txt
								format "if itm > 0 and lbx_on_%.items.count > 0 and lbx_on_%.items.count-1 >= % do (\n" cnt cnt lastConnection to:txt
								format "lbx_off_%.items = sort (if findItem lbx_off_%.items lbx_on_%.selected == 0 then append lbx_off_%.items lbx_on_%.selected else lbx_off_%.items)\n" cnt cnt cnt cnt cnt cnt to:txt
								format "if itm > 0 do lbx_on_%.items = (deleteItem lbx_on_%.items itm)\n" cnt cnt to:txt
								format "updateCSVProperty()))\n" to:txt
									
								format "on lbx_off_% doubleClicked itm do addToList itm\n" cnt to:txt
								format "on lbx_on_% selected itm do edt_property_%.text = lbx_on_%.selected\n" cnt cnt cnt to:txt
								
								format "on btn_on_% pressed do addToList lbx_off_%.selection\n" cnt cnt to:txt
								
								format "on lbx_on_% doubleClicked itm do removeFromList itm\n" cnt to:txt
								format "on btn_off_% pressed do removeFromList lbx_on_%.selection\n" cnt cnt to:txt
									
								hasControls = true
							)
							else
							(
								format "edittext edt_% \"%:\" labelOnTop:true text:\"%\" width:160 align:#center\n" cnt displayName p[3] to:txt
								format "on edt_% entered txt do MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" txt \n" cnt theCurrentEditorIndex theCurrentEditorIndex p[2] to:txt
								hasControls = true
							)
						)
						else if matchPattern p[4] pattern:"String" then
						(
							format "edittext edt_% \"%:\" labelOnTop:true text:\"%\" width:160 height:128 align:#center\n" cnt displayName p[3] to:txt
							format "on edt_% entered txt do MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" txt \n" cnt theCurrentEditorIndex theCurrentEditorIndex p[2] to:txt
							hasControls = true
						)
						else if matchPattern p[4] pattern:"Texmap" then
						(
							format "mapbutton map_% \"%\" width:160 align:#center\n" cnt (if p[3] != undefined then (p[3].name + " ("+(classof p[3]) as string +")") else "<Add Texture Map>") to:txt
							format "button btn_mapToMEdit \"Put To MEdit\" width:80 align:#left offset:[-10,-3] across:2\n" to:txt
							format "button btn_RemoveMap \"Remove Map\" width:80 align:#right offset:[10,-3] \n" to:txt

							format "on btn_mapToMEdit pressed do (\n" to:txt
							format "local theMap = ::MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"texmap\" \n" theCurrentEditorIndex theCurrentEditorIndex to:txt
							format "if theMap != undefined do meditMaterials[medit.GetActiveMtlSlot()] = theMap)\n" to:txt
							
							format "on btn_RemoveMap pressed do (\n" to:txt
							format "::MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"texmap\" undefined \n" theCurrentEditorIndex theCurrentEditorIndex to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false\n" theCurrentEditorIndex  to:txt 							
							format  ")\n" to:txt
							
							format "on map_% picked aMap do (\n" cnt to:txt
							format "map_%.caption = if aMap == undefined then \"<Add Texture Map>\" else aMap.name + \" (\" + (classof aMap) as string + \")\" \n" cnt to:txt
							format  "::MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"%\" aMap\n"  theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false\n" theCurrentEditorIndex  to:txt 							
							format  ")\n" to:txt
							
							format "group \"Explicit Channel Inputs:\" (" to:txt
							format "checkbox chk_exposePosition \"Position\" offset:[-5,-3] across:2\n" to:txt
							format "checkbox chk_exposeVertexColor \"Vertex Color\" offset:[-14,-3]\n" to:txt
							
							format "checkbox chk_exposeNormal \"Normal\" offset:[-5,-3] across:2\n" to:txt
							format "checkbox chk_exposeTextureCoord \"TextureCoord\" offset:[-14,-3]\n" to:txt

							format "listbox lbx_on_% \" Additional Mapping Channels:\" width:154 align:#center height:3 offset:[0,-1] \n" cnt to:txt
							format "button btn_on_% \"Add...\" across:2 width:76 align:#left offset:[-6,-5]\n" cnt to:txt
							format "button btn_off_% \"Remove...\" width:76 align:#right offset:[6,-5]\n" cnt to:txt
							format "listbox lbx_off_% width:154 align:#center height:5 offset:[0,-5]\n" cnt to:txt
							format ")\n" to:txt
							
							format "fn updateTexmapChannel = (\n" to:txt
							format "local theChannelsString = ::MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"channels\" \n" theCurrentEditorIndex  theCurrentEditorIndex to:txt
							format "if theChannelsString == undefined do theChannelsString = \"\" \n" to:txt
							format "local theChannels = sort (filterString theChannelsString \",\") \n" to:txt
							format "chk_exposePosition.checked = findItem theChannels \"Position\" > 0\n" to:txt
							format "chk_exposeNormal.checked = findItem theChannels \"Normal\" > 0 \n" to:txt
							format "chk_exposeVertexColor.checked = findItem theChannels \"Color\" > 0 \n" to:txt
							format "chk_exposeTextureCoord.checked = findItem theChannels \"TextureCoord\" > 0 \n" to:txt

							format "local theVal = for c in theChannels where matchPattern c pattern:\"Mapping*\" collect c \n" to:txt
							format "local thePossibleVal = for i = 2 to 99 where (theName = \"Mapping\"+i as string; findItem theVal theName == 0) collect theName\n" to:txt
							format "lbx_on_%.items =  theVal \n" cnt to:txt
							format "lbx_off_%.items = thePossibleVal \n" cnt to:txt
							format ")\n" to:txt							
							
							format "fn setTexmapChannel theChannel theState = (\n" to:txt
							--format "::MagmaFlowEditor_CurrentEditors[%][1].declareExtensionProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"channels\"\n" theCurrentEditorIndex  theCurrentEditorIndex to:txt
							format "local theChannelsString = ::MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"channels\" \n" theCurrentEditorIndex  theCurrentEditorIndex to:txt
							format "if theChannelsString == undefined do theChannelsString = \"\" \n" to:txt
							format "theChannels = filterString theChannelsString \",\" \n" to:txt
							format "if theState and findItem theChannels theChannel == 0 do append theChannels theChannel\n" to:txt
							format "if not theState and findItem theChannels theChannel > 0 do deleteItem theChannels (findItem theChannels theChannel)\n" to:txt
							format "theChannelsString = \"\" \n" to:txt
							format "sort theChannels\n" to:txt
							format "for i = 1 to theChannels.count-1 do theChannelsString += theChannels[i]+\",\" \n" to:txt
							format "if theChannels.count > 0 do theChannelsString += theChannels[theChannels.count] \n" to:txt
							format "::MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty ::MagmaFlowEditor_CurrentEditors[%][3] \"channels\" theChannelsString\n" theCurrentEditorIndex  theCurrentEditorIndex to:txt
							format "updateTexmapChannel()\n" to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n" theCurrentEditorIndex  to:txt 							
							format ")\n" to:txt



							
							format "on chk_exposePosition changed state do setTexmapChannel \"Position\" state\n" to:txt
							format "on chk_exposeNormal changed state do setTexmapChannel \"Normal\" state\n" to:txt
							format "on chk_exposeVertexColor changed state do setTexmapChannel \"Color\" state\n" to:txt
							format "on chk_exposeTextureCoord changed state do setTexmapChannel \"TextureCoord\" state\n" to:txt
							
							format "on lbx_on_% doubleClicked itm do setTexmapChannel lbx_on_%.selected false\n" cnt cnt to:txt
							format "on lbx_off_% doubleClicked itm do setTexmapChannel lbx_off_%.selected true\n" cnt cnt to:txt
							format "on btn_on_% pressed do setTexmapChannel lbx_off_%.selected true\n" cnt cnt to:txt
							format "on btn_off_% pressed do setTexmapChannel lbx_on_%.selected false\n" cnt cnt to:txt
							
							format "on DynamicPropertiesRolloutGlobal open do updateTexmapChannel()\n" to:txt
							
							hasControls = true
						)
						else if matchPattern p[2] pattern:"curve" and matchPattern p[4] pattern:"class" then
						(
							format "local theCI = MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"curve\" \n" theCurrentEditorIndex theCurrentEditorIndex to:txt
							format "button btn_% \"Open Curve Editor...\" width:160 align:#center height:30 offset:[0,-4] \n" cnt to:txt
							format "CurveControl crv_CurveControl width:160 height:120 align:#center offset:[0,-2] numCurves:1 visible:true enabled:false uiflags:#(#drawBG,#drawgrid,#ruler) x_range:(theCI.getDomain())\n" to:txt
							
							format "on btn_% pressed do (\n" cnt to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].openCurveEditor %\n" theCurrentEditorIndex ID to:txt
							format  ")\n" to:txt
							format "on DynamicPropertiesRolloutGlobal open do (\n" to:txt
							format "::MagmaFlowEditor_CurrentCurveThumbnail = crv_CurveControl\n" to:txt
							format "::MagmaFlowEditor_CurrentEditor = MagmaFlowEditor_CurrentEditors[%][2] \n"theCurrentEditorIndex  to:txt
							format "MagmaFlowEditor_Functions.loadControlCurves crv_CurveControl theCI \n" to:txt
							format  ")\n" to:txt
							hasControls = true
						)
						else if matchPattern p[2] pattern:"nodes" and matchPattern p[4] pattern:"class" then
						(
							local theNameString1 = "Get by Name..."
							local theNameString2 = "Pick in Scene..."
							local theTooltip1 = "Get multiple Objects by name..."
							local theTooltip2 = "Get one Object by clicking in the viewport..."
							case (magma.getNodeType ID) as name of
							(
								default: (
									format "fn pickObjectsFilter% obj = ( true ) \n" cnt to:txt
								)
								#InputGeometry: 
								(
									format "fn pickObjectsFilter% obj = (findItem ::MagmaFlowEditor_GlobalPickFilterArray% obj == 0 AND findItem GeometryClass.classes (classof obj) > 0 and classof obj != targetObject and  findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) == 0 )\n" cnt cnt to:txt
									--theNameString1 = "Get Objects..."
									theTooltip1 = "Get multiple Geometry Objects by name..."
									theTooltip2 = "Get one Geometry Object by clicking in the viewport..."
								)
								/*#InputParticles: 
								(
									format "fn pickObjectsFilter% obj = ( findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) > 0 )\n" cnt to:txt
									theNameString = "Pick Particle Objects..."
								)*/
							)
							local theName1 = theNameString1
							local theName2 = theNameString2
							format "checkbox chk_exposed \"Exposed\" align:#left offset:[-3,0] \n" to:txt
							format "on chk_exposed changed state do	( \n" to:txt
							format "local theMod = MagmaFlowEditor_CurrentEditors[%][1] \n" theCurrentEditorIndex to:txt
							format "theMod.DeclareExtensionProperty MagmaFlowEditor_CurrentEditors[%][3] \"Exposed\" \n" theCurrentEditorIndex to:txt
							format "theMod.setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"Exposed\" state \n" theCurrentEditorIndex to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].exposeControlsToModifier() \n" theCurrentEditorIndex to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false \n" theCurrentEditorIndex to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createUndoRecord (if state then \"Exposed Control\" else \"Unexposed Control\")) \n" theCurrentEditorIndex to:txt
							
							format "button btn_node1_% \"%\" width:82 align:#left tooltip:\"%\" across:2 offset:[-12,-1]\n" cnt theName1 theTooltip1  to:txt
							format "pickbutton btn_node2_% \"%\" width:82 align:#right tooltip:\"%\" offset:[12,-1] filter:pickObjectsFilter% \n" cnt theName2 theTooltip2 cnt to:txt
							
							format "multilistbox lbx_node% width:164 align:#center offset:[0,-3]\n" cnt to:txt
							format "button btn_removenodes% \"Remove Nodes\" width:164 offset:[0,-4] align:#center tooltip:\"Remove highlighted nodes from the input's list...\" \n" cnt to:txt
							format "fn updateNodesList = (\n" to:txt
							format "local allNodes = MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" \n" theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "::MagmaFlowEditor_GlobalPickFilterArray% = allNodes\n" cnt to:txt
							format "lbx_node%.items =  for i in allNodes collect if isValidNode i then i.name else \"<deleted>\" \n" cnt to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false\n" theCurrentEditorIndex  to:txt 	
							format "chk_exposed.state = (MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"Exposed\") == true \n" theCurrentEditorIndex theCurrentEditorIndex to:txt
							format "try(modPanel.setCurrentObject (modPanel.getCurrentObject()))catch()\n" to:txt 	
							format ")\n" to:txt
							format "on btn_removenodes% pressed do (\n" cnt to:txt
							format "local theNodes = MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" \n" theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "local theSel = lbx_node%.selection as array \n" cnt to:txt
							format "for i = theSel.count to 1 by -1 do deleteItem theNodes theSel[i] \n" to:txt
							format "format \"\%\" theNodes \n" to:txt
							format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" theNodes\n"  theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "updateNodesList()\n" to:txt
							format ")\n" to:txt
							format "on DynamicPropertiesRolloutGlobal open do updateNodesList()\n" to:txt
							
							format "on btn_node1_% pressed do (\n" cnt to:txt
							format "local allNodes = MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" \n" theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "::MagmaFlowEditor_GlobalPickFilterArray% = allNodes\n" cnt to:txt
							format "local theNodes = selectByName title:\"%\" filter:pickObjectsFilter% showHidden:false single:false \n"  theNameString1 cnt to:txt
							format "if theNodes != undefined do (\nfor o in theNodes do appendIfUnique allNodes o\n" to:txt
							format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" allNodes\n"  theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "updateNodesList()) )\n" to:txt
							
							format "on btn_node2_% picked obj do (\n" cnt to:txt
							format "local allNodes = MagmaFlowEditor_CurrentEditors[%][1].getNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" \n" theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "if obj != undefined do (\n appendIfUnique allNodes obj\n" to:txt
							format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" allNodes\n"  theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "updateNodesList()) )\n" to:txt							
							hasControls = true
						)
						else if matchPattern p[4] pattern:"node" then
						(
							local theNameString = "Pick Scene Object..."
							case (magma.getNodeType ID) as name of
							(
								default: (
									format "fn pickObjectFilter obj = ( true ) \n" to:txt
								)
								#InputGeometry: 
								(
									format "fn pickObjectFilter obj = ( findItem GeometryClass.classes (classof obj) > 0 and classof obj != targetObject and  findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) == 0 )\n" to:txt
									theNameString = "Pick Geometry Object..."
								)
								#InputParticles: 
								(
									format "fn pickObjectFilter obj = ( findItem #(PF_Source,PRT_Volume,PRT_FumeFX,KrakatoaPRTLoader,PRT_Source,PRT_Maker,PRT_Hair) (classof obj.baseobject) > 0 )\n" to:txt
									theNameString = "Pick Particle Object..."
								)
							)
							local theName = if isValidNode p[3] then p[3].name else theNameString
							--format "label lbl_% \"%:\" align:#left \n" cnt displayName to:txt
							if findItem #(#InputGeometry, #InputParticles, #InputObject) ((magma.getNodeType id) as name) > 0 do
							(
								format "checkbox chk_exposed \"Exposed\" align:#left offset:[-3,0] checked:% \n" (magma.getNodeProperty id "Exposed" == true) to:txt
								format "on chk_exposed changed state do	( \n" to:txt
								format "local theMod = MagmaFlowEditor_CurrentEditors[%][1] \n" theCurrentEditorIndex to:txt
								format "theMod.DeclareExtensionProperty MagmaFlowEditor_CurrentEditors[%][3] \"Exposed\" \n" theCurrentEditorIndex to:txt
								format "theMod.setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"Exposed\" state \n" theCurrentEditorIndex to:txt
								format "MagmaFlowEditor_CurrentEditors[%][2].exposeControlsToModifier() \n" theCurrentEditorIndex to:txt
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false \n" theCurrentEditorIndex to:txt
								format "MagmaFlowEditor_CurrentEditors[%][2].createUndoRecord (if state then \"Exposed Control\" else \"Unexposed Control\")) \n" theCurrentEditorIndex to:txt
							)
							
							format "pickbutton pck_node% \"%\" width:164 align:#center tooltip:\"%\" filter:pickObjectFilter\n" cnt theName theName  to:txt
							format "on pck_node% picked obj do (\n" cnt to:txt
							format "if isValidNode obj do (\n" to:txt
							format "pck_node%.caption = obj.name\n" cnt to:txt
							format "pck_node%.tooltip = obj.name\n" cnt to:txt
							format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" obj\n"  theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:false\n" theCurrentEditorIndex  to:txt 
							format "try(modPanel.setCurrentObject (modPanel.getCurrentObject()))catch()\n" to:txt 	
							format "))\n" to:txt
							hasControls = true
						)
						else 
						(
							if matchPattern p[4] pattern:"int" do
							(
								format "spinner spn_% \"%:\" type:#integer fieldwidth:50 range:[0,100,%] \n" cnt displayName p[3] to:txt
								format "on spn_% changed val do MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" val \n" cnt theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
								hasControls = true
							)
							if matchPattern p[4] pattern:"float" do
							(
								format "spinner spn_% \"%:\" type:#float fieldwidth:50 range:[-100000,100000,%] \n" cnt displayName p[3] to:txt
								format "on spn_% changed val do MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" val \n" cnt theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
								hasControls = true
							)		
							if matchPattern p[4] pattern:"vector" do
							(
								--format "spinner spn_% \"%:\" type:#float fieldwidth:50 range:[1,100,%] \n" cnt p[2] p[3] to:txt
								--format "on spn_% changed val do MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" val \n" cnt theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
							)		
							if matchPattern p[4] pattern:"bool" do
							(
								format "checkbutton chk_% \">%\" checked:% width:150 align:#center \n" cnt displayName p[3]  to:txt
								format "on chk_% changed val do ( \n" cnt to:txt
								format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"%\" val \n" theCurrentEditorIndex  theCurrentEditorIndex p[2] to:txt
								format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n" theCurrentEditorIndex  to:txt 
								format ")\n" to:txt
							)								
						)
					)
				)
				if magma.getNodeType ID == "Mux" do
				(
					format "spinner spn_muxcount \"Number Inputs:\" type:#integer fieldwidth:50 range:[3,1000,%] \n" (magma.getNumNodeInputs ID) to:txt
					format "on spn_muxcount changed val do (\n" to:txt
					format "local oldControl = MagmaFlowEditor_CurrentEditors[%][1].getNodeInput MagmaFlowEditor_CurrentEditors[%][3] (MagmaFlowEditor_CurrentEditors[%][1].getNumNodeInputs MagmaFlowEditor_CurrentEditors[%][3]) \n" theCurrentEditorIndex theCurrentEditorIndex theCurrentEditorIndex theCurrentEditorIndex to:txt 
					format "MagmaFlowEditor_CurrentEditors[%][1].setNodeInput MagmaFlowEditor_CurrentEditors[%][3] (MagmaFlowEditor_CurrentEditors[%][1].getNumNodeInputs MagmaFlowEditor_CurrentEditors[%][3]) -1 1\n" theCurrentEditorIndex theCurrentEditorIndex theCurrentEditorIndex theCurrentEditorIndex to:txt 
					format "MagmaFlowEditor_CurrentEditors[%][1].setNumNodeInputs MagmaFlowEditor_CurrentEditors[%][3] val \n" theCurrentEditorIndex  theCurrentEditorIndex to:txt
					format "MagmaFlowEditor_CurrentEditors[%][1].setNodeInput MagmaFlowEditor_CurrentEditors[%][3] val oldControl[1] oldControl[2]\n" theCurrentEditorIndex theCurrentEditorIndex to:txt 
					format "MagmaFlowEditor_CurrentEditors[%][2].updateNavigator()\n" theCurrentEditorIndex  to:txt 
					format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true)\n" theCurrentEditorIndex  to:txt 
					hasControls = true
				)
				
				local theVals = for i = 1 to magma.getNumNodeInputs ID where (val = magma.getNodeInputDefaultValue ID i) != undefined and (magma.getNodeInput ID i)[1] < 0 collect i
				
				if theVals.count > 0 do
				(
					hasControls = true
					local theValueClassOverride = magma.getNodeProperty ID "DefaultsType" 
					
					if theValueClassOverride != undefined then
						theValueClassOverride  = theValueClassOverride  as name
					else 
					(
						if findItem #("TransformByQuat", "VectorsToQuat","ToVector", "Blend","Clamp","FaceQuery","MeshQuery","ParticleSumCount","ParticleSumRadius","MatrixMulVec") (magma.getNodeType ID) == 0 do --,"Greater","Less","GreaterOrEqual","LessOrEqual"
						(
							theValueClassOverride = ((classof ( magma.getNodeInputDefaultValue ID theVals[1])) as string) as name
							--format "theValueClassOverride = %\n" theValueClassOverride
						)
					)
					if theValueClassOverride == #point3 do theValueClassOverride = #Vector
					format "group \"Input Defaults\"(\n" to:txt
					if theValueClassOverride != undefined do
					(
						format "label lbl_defaultType \"Value Type:\" align:#left across:2\n" to:txt
						format "dropdownlist ddl_defaultType items:#(\"Integer\",\"Float\",\"Vector\") width:80 align:#right offset:[0,-3] selection:%\n" (findItem #(#Integer,#Float,#Vector) theValueClassOverride) to:txt
						format "on ddl_defaultType selected itm do (\n" to:txt
						format "MagmaFlowEditor_CurrentEditors[%][1].DeclareExtensionProperty MagmaFlowEditor_CurrentEditors[%][3] \"DefaultsType\"\n"  theCurrentEditorIndex  theCurrentEditorIndex to:txt
						format "MagmaFlowEditor_CurrentEditors[%][1].setNodeProperty MagmaFlowEditor_CurrentEditors[%][3] \"DefaultsType\" ddl_defaultType.selected\n"  theCurrentEditorIndex  theCurrentEditorIndex to:txt
						format "MagmaFlowEditor_CurrentEditors[%][2].displaySelectedNodeProperties()\n" theCurrentEditorIndex  to:txt 
						format "MagmaFlowEditor_CurrentEditors[%][2].createNodeTree init:true\n" theCurrentEditorIndex  to:txt 
						format ")\n" to:txt
					)
					
					for i = 1 to magma.getNumNodeInputs ID where (val = magma.getNodeInputDefaultValue ID i) != undefined do
					(
						local isConnected = (magma.getNodeInput ID i)[1] > -1 
						if not isConnected do
						(
							local theValueClass = ((classof val) as string) as name
							if theValueClassOverride != undefined do
							(
								theValueClassOverride = theValueClassOverride as name
								if (theValueClass == #Float or  theValueClass == #Integer) and theValueClassOverride == #Vector then
								(
									val = [val,val,val]
									magma.SetNodeInputDefaultValue ID i val 
								)
								else if (theValueClass == #Vector or theValueClass == #Point3) and (theValueClassOverride == #Float or theValueClassOverride == #Integer) then
								(
									val = val.x
									magma.SetNodeInputDefaultValue ID i val 
								)
								else if (theValueClass == #Integer) and (theValueClassOverride == #Float) do
								(
									val = val * 1.0
									magma.SetNodeInputDefaultValue ID i val 				
								)
								
								if theValueClassOverride == #Integer do
								(
									val = (floor (val +0.5)) as integer
									magma.SetNodeInputDefaultValue ID i val 
								)
								
								theValueClass = theValueClassOverride
							)
							if theValueClass == #Float then
								(
									local theName = magma.GetNodeInputDescription ID i
									if theName == undefined do theName = "Input"									
									format "spinner spn_default% \"%:%:\" type:#float fieldwidth:45 range:[-100000000,100000000,%] \n" i  i theName val to:txt
									format "on spn_default% changed val do (\n" i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % val\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
									format ")\n" to:txt
								)
								else if theValueClass == #Integer then
								(
									local theName = magma.GetNodeInputDescription ID i
									if theName == undefined do theName = "Input"									
									format "spinner spn_default% \"%:%:\" type:#integer fieldwidth:45 range:[-100000000,100000000,%] \n" i  i theName val to:txt
									format "on spn_default% changed val do (\n" i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % val\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
									format ")\n" to:txt									
								)
								else if theValueClass == #Vector or theValueClass == #Point3 or theValueClass == #Quat do
								(
									local theSocketName = magma.GetNodeInputDescription ID i
									local theNameString = "X"
									if matchPattern theSocketName pattern:"*Color*" do theNameString = "R"
									if matchPattern theSocketName pattern:"*Texture*" do theNameString = "U"
										
									format "groupbox grp_box% \"% : %:\" align:#center width:150 height:% \n" i i theSocketName (if theValueClass == #Quat then 100 else 70) to:txt									
									format "spinner spn_default%X \"%:\" type:#float fieldwidth:50 range:[-100000000,100000000,%] offset:[0,-%] \n" i theNameString val.x (if theValueClass == #Quat then 90 else 60) to:txt
									format "on spn_default%X changed val do (\n" i to:txt
									format "local oldVal = MagmaFlowEditor_CurrentEditors[%][1].GetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] %\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									if theValueClass == #Quat then
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % (Quat val oldVal.y oldVal.z oldVal.w)\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									else
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % [val, oldVal.y, oldVal.z]\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
									format ")\n" to:txt
									
									local theNameString = "Y"
									if matchPattern theSocketName pattern:"*Color*" do theNameString = "G"
									if matchPattern theSocketName pattern:"*Texture*" do theNameString = "V"
									
									format "spinner spn_default%Y \"%:\" type:#float fieldwidth:50 range:[-100000000,100000000,%] offset:[0,-3]\n" i theNameString val.y to:txt
									format "on spn_default%Y changed val do (\n" i to:txt
									format "local oldVal = MagmaFlowEditor_CurrentEditors[%][1].GetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] %\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									if theValueClass == #Quat then
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % (Quat oldVal.x val oldVal.z oldVal.w)\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									else
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % [oldVal.x, val, oldVal.z]\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
									format ")\n" to:txt
									
									local theNameString = "Z"
									if matchPattern theSocketName pattern:"*Color*" do theNameString = "B"
									if matchPattern theSocketName pattern:"*Texture*" do theNameString = "W"
									
									format "spinner spn_default%Z \"%:\" type:#float fieldwidth:50 range:[-100000000,100000000,%] offset:[0,-3]\n" i theNameString val.z to:txt
									format "on spn_default%Z changed val do (\n" i to:txt
									format "local oldVal = MagmaFlowEditor_CurrentEditors[%][1].GetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] %\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									if theValueClass == #Quat then
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % (Quat oldVal.x oldVal.y val oldVal.w)\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									else
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % [oldVal.x, oldVal.y, val]\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
									format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
									format ")\n" to:txt
									
									if theValueClass == #Quat do
									(
										local theNameString = "W"
										format "spinner spn_default%W \"%:\" type:#float fieldwidth:50 range:[-100000000,100000000,%] offset:[0,-3]\n" i theNameString val.w to:txt
										format "on spn_default%W changed val do (\n" i to:txt
										format "local oldVal = MagmaFlowEditor_CurrentEditors[%][1].GetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] %\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
										format "MagmaFlowEditor_CurrentEditors[%][1].SetNodeInputDefaultValue MagmaFlowEditor_CurrentEditors[%][3] % (quat oldVal.x oldVal.y oldVal.z val)\n"  theCurrentEditorIndex  theCurrentEditorIndex i to:txt
										format "MagmaFlowEditor_CurrentEditors[%][2].updateMagmaHolder()\n" theCurrentEditorIndex to:txt
										format ")\n" to:txt
									)
								)
						
						)
					)
					format ")\n" to:txt
				)		
				if not hasControls do format "label lbl_nocontols \"No Controls Exposed\" \n" to:txt
				format ")\n" to:txt
				DynamicPropertiesRollout = copy (execute (txt as string))
			)
			else false
		)
		
		
		fn displaySelectedNodeProperties =
		(
			local st = timestamp()
			FranticParticles.LogDebug "MagamFlow: displaySelectedNodeProperties() Called."
			if hc.selectedNodeIndex > 0 and hc.selectedNodeIndex <= (editorNodeCount) and hc.getSelectionCount == 1 then --hc.getNodeCount 
			(
				lastNodeClick = hc.selectedNodeIndex 
				local theID = magma.getNodeID lastNodeClick
				/*
				if MagmaFlowSettings.DebugModeOn do
				(
					addSubRollout NodePropsSR MagmaFlowEditor_GraphOutputRollout rolledup:false
				)
				*/
				local theNameState = execute (getIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "MagmaEditor" "NodeNameRolloutRolledup")
				if theNameState == OK do theNameState = false
				local theType = try(magma.getNodeType theID)catch("BLOPSocket")
				case theType as name of
				(
					#InputValue: 
					(
						for i = NodePropsSR.rollouts.count to 1 by -1 where NodePropsSR.rollouts[i] != MagmaFlowEditor_NodeNameRollout and NodePropsSR.rollouts[i] != MagmaFlowEditor_OperatorRollout and NodePropsSR.rollouts[i]  != MagmaFlowEditor_OptionsRollout do  --and NodePropsSR.rollouts[i]  != MagmaFlowEditor_FilePresetsRollout 
							removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
						
						local tempController = magma.getNodeProperty theID "controller"
						local tempControllerIsInteger = magma.getNodeProperty theID "forceInteger"
						
						if classof tempController.value == Float and tempControllerIsInteger == false do 
						(
							CurrentFloatController  = tempController
							CurrentIntController = bezier_float()
							CurrentVectorController = point3_xyz()
						)
						if classof tempController.value == Float and tempControllerIsInteger == true do 
						(
							CurrentFloatController  = bezier_float()
							CurrentIntController = tempController 
							CurrentVectorController = point3_xyz()
						)
						if classof tempController.value == Point3 do 
						(
							CurrentFloatController  = bezier_float()
							CurrentIntController =  bezier_float()
							if classof tempController == point3_xyz then
								CurrentVectorController = tempController 
							else 
								CurrentVectorController = Point3_xyz()
						)
						
						MagmaFlowEditor_isInitializing = true
						addSubRollout NodePropsSR MagmaFlowEditor_NodeNameRollout rolledup:(not theNameState)
						MagmaFlowEditor_NodeNameRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_OperatorRollout rolledup:false
						MagmaFlowEditor_OperatorRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_InputValueRollout rolledup:false
						MagmaFlowEditor_InputValueRollout.RolloutOpen()

						MagmaFlowEditor_isInitializing = false
					)
					#InputChannel:
					(
						MagmaFlowEditor_isInitializing = true
						for i = NodePropsSR.rollouts.count to 1 by -1 where NodePropsSR.rollouts[i] != MagmaFlowEditor_NodeNameRollout and NodePropsSR.rollouts[i] != MagmaFlowEditor_OperatorRollout and NodePropsSR.rollouts[i]  != MagmaFlowEditor_OptionsRollout   do 
							removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
						
						addSubRollout NodePropsSR MagmaFlowEditor_NodeNameRollout rolledup:(not theNameState)
						MagmaFlowEditor_NodeNameRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_OperatorRollout rolledup:false
						MagmaFlowEditor_OperatorRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_InputChannelRollout rolledup:false
						MagmaFlowEditor_InputChannelRollout.RolloutOpen()
						
						MagmaFlowEditor_isInitializing = false
					)
					#BLOPSocket: ()
					
					default: 
					(
						MagmaFlowEditor_isInitializing = true
						for i = NodePropsSR.rollouts.count to 1 by -1 where NodePropsSR.rollouts[i] != MagmaFlowEditor_NodeNameRollout and NodePropsSR.rollouts[i] != MagmaFlowEditor_OperatorRollout and NodePropsSR.rollouts[i]  != MagmaFlowEditor_OptionsRollout  do 
							removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
						
						addSubRollout NodePropsSR MagmaFlowEditor_NodeNameRollout rolledup:(not theNameState)
						MagmaFlowEditor_NodeNameRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_OperatorRollout rolledup:false
						MagmaFlowEditor_OperatorRollout.RolloutOpen()
						createDynamicPropertiesRollout theID
						addSubRollout NodePropsSR DynamicPropertiesRollout rolledup:false
						MagmaFlowEditor_isInitializing = false
					)		
					#BLOP:
					(
						MagmaFlowEditor_isInitializing = true
						for i = NodePropsSR.rollouts.count to 1 by -1 where NodePropsSR.rollouts[i] != MagmaFlowEditor_NodeNameRollout and NodePropsSR.rollouts[i] != MagmaFlowEditor_EditableBLOP and NodePropsSR.rollouts[i]  != MagmaFlowEditor_OptionsRollout do 
							removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
						
						addSubRollout NodePropsSR MagmaFlowEditor_NodeNameRollout rolledup:(not theNameState)
						MagmaFlowEditor_NodeNameRollout.RolloutOpen()
						addSubRollout NodePropsSR MagmaFlowEditor_EditableBLOP rolledup:false
						MagmaFlowEditor_EditableBLOP.RolloutOpen()
						MagmaFlowEditor_isInitializing = false
					)
					
					#Output: 
					(
						for i = NodePropsSR.rollouts.count to 1 by -1 where NodePropsSR.rollouts[i] != MagmaFlowEditor_OutputRollout and NodePropsSR.rollouts[i]  != MagmaFlowEditor_OptionsRollout do 
							removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
						
						addSubRollout NodePropsSR MagmaFlowEditor_OutputRollout rolledup:false
						MagmaFlowEditor_OutputRollout.RolloutOpen()
					)				
				)
			)		
			else
			(
				for i = NodePropsSR.rollouts.count to 1 by -1 do 
					removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
				if EditableBlopStack.count == 0 do addSubRollout NodePropsSR MagmaFlowEditor_FilePresetsRollout rolledup:false
			)
			if EditableBlopStack.count > 0 then 
				addSubRollout NodePropsSR MagmaFlowEditor_CloseEditableBLOP
			else
				removeSubRollout NodePropsSR MagmaFlowEditor_CloseEditableBLOP

			addSubRollout NodePropsSR MagmaFlowEditor_OptionsRollout rolledup:true
			
			setFocus hc
			
			FranticParticles.LogDebug ("MagamFlow: displaySelectedNodeProperties() Took "+ (timestamp()-st) as string + " ms.")

		)--end display selected properties fn 
		
		fn displayOptions =
		(
			for i = NodePropsSR.rollouts.count to 1 by -1 do 
				removeSubRollout NodePropsSR NodePropsSR.rollouts[i]
			addSubRollout NodePropsSR MagmaFlowEditor_OptionsRollout rolledup:false
		)

--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--REORDER FLOW FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

		fn stampChild theChild theParent =
		(
			local theChildOrderX = magma.getNodeProperty theChild "Internal_OrderX"
			local theParentOrderX = magma.getNodeProperty theParent "Internal_OrderX"
			local theChildOrderY = magma.getNodeProperty theChild "Internal_OrderY"
			local theParentOrderY = magma.getNodeProperty theParent "Internal_OrderY"
			if theChildOrderX != undefined and theChildOrderY != undefined and theParentOrderX != undefined and theParentOrderY != undefined do 
			(
				local theNewOrderX = theParentOrderX+1
				if theNewOrderX > theChildOrderX do 
					magma.setNodeProperty theChild "Internal_OrderX" theNewOrderX

				local theNewOrderY = theParentOrderY
					magma.setNodeProperty theChild "Internal_OrderY" theNewOrderY
				
				for c = 1 to magma.getNumNodeInputs theChild do
				(
					local theWire = magma.getNodeInput theChild c
					if theWire != undefined and theWire[1] > -1 do
					(
						stampChild theWire[1] theChild
					)
				)
			)
		)
		
		fn compareFN v1 v2 valArray: =
		(
			local v1i = valArray[v1]
			local v2i = valArray[v2]
			if v1i > v2i then 1 else -1
		)
 
		fn reorder_dot =
		(
			local nodeIDMapArray = #()
			local theOutputIndex = 0
			local maxPosY = 0
			local maxPosX = 0
			
			for i = 1 to magma.getNumNodes() do
			(
				local theID = magma.getNodeID i
				magma.DeclareExtensionProperty theID "Internal_Position"
				magma.DeclareExtensionProperty theID "Internal_OrderX"
				magma.DeclareExtensionProperty theID "Internal_OrderY"
				magma.setNodeProperty theID "Internal_OrderX" 0
				magma.setNodeProperty theID "Internal_OrderY" 0
				append nodeIDMapArray theID
			)
			if magma.NumEditingBLOPs() > 0 then
			(
				local numBLOPOutputs = magma.GetNumNodeOutputs (magma.CurrentBLOP)
				for i = 1 to numBLOPOutputs do
				(
					theOutputIndex = i
					local theID = (magma.GetOutput i)[1]
					if theID > -1 do
					(
						magma.setNodeProperty theID "Internal_OrderX" 2
						magma.setNodeProperty theID "Internal_OrderY" i
						for j = 1 to magma.getNumNodeInputs theID do
						(
							local theWire = magma.getNodeInput theID j
							if theWire != undefined and theWire[1] > -1 do
							(
								stampChild theWire[1] theID
							)
						)--end j loop
					)--end if					
				)--end i loop
			)
			else 
			(
				for i = 1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					if magma.getNodeType theID == "Output" do 
					(
						theOutputIndex +=1
						magma.setNodeProperty theID "Internal_OrderX" 1
						magma.setNodeProperty theID "Internal_OrderY" theOutputIndex
						local theWire = magma.getNodeInput theID 1
						if theWire != undefined and theWire[1] > -1 do
						(
							stampChild theWire[1] theID
						)
					)--end if output
				)--end i loop
			)
			local reorderLastLevelX = amax (for i = 1 to magma.getNumNodes() collect (theVal = (magma.getNodeProperty (magma.getNodeID i) "Internal_OrderX"); if theVal != undefined then theVal else dontcollect) )
			if reorderLastLevelX == undefined do reorderLastLevelX = 0
			local theNodesArray = for i = 1 to reorderLastLevelX collect #()
			for i = 1 to magma.getNumNodes() do --for every node in the current X level
			(
				local theID = magma.getNodeID i
				if magma.getNodeType theID != "Output" do 
				(
					local theOrderX = magma.getNodeProperty theID "Internal_OrderX"
					local theOrderY = magma.getNodeProperty theID "Internal_OrderY"
					if theOrderX > 0 do --if it is a connected one
					(
						if theNodesArray[theOrderX] == undefined do theNodesArray[theOrderX] = #()
						append theNodesArray[theOrderX] #(i, theID, theOrderX, theOrderY)
					)
				)
			)
			--First we process the column 2, directly connected to Outputs. Since an output has one input only, there is always one node per output!
			local currentYOffset = 0
			for j = 1 to theOutputIndex do
			(
				theUpNodes = theNodesArray[2]
				if theUpNodes != undefined do
				(
					for n in theUpNodes do
					(
						if n[4] == j do
						(
							thePos = [hc.width-n[3]*(MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace), currentYOffset]
							magma.setNodeProperty n[2] "Internal_Position" thePos				
							hc.activeNode = n[1]
							local theNodeSizeY = hc.nodeSize.y
							if MagmaFlowSettings.showTextureMapSample and magma.getNodeProperty n[2] "texmap" != undefined do theNodeSizeY += hc.nodeSize.x
							if MagmaFlowSettings.showColorSwatchSample and (magma.getNodeType n[2]) as name== #InputValue and classof (magma.getNodeProperty n[2] "controller").value  == Point3 do theNodeSizeY += 20
								
							currentYOffset += theNodeSizeY + MagmaFlowSettings.NodeYSpace						
							
							if currentYOffset > maxPosY do maxPosY = currentYOffset
							if thePos.x > maxPosX do maxPosX = thePos.x
							
						)
					)
					--currentYOffset += MagmaFlowSettings.NodeYSpace*4						
				)
			)

			--Now we process one column at a time, relative to the previous one
			for i = 3 to theNodesArray.count do --loop through each column
			(
				local sortArray = #()
				for n in theNodesArray[i] do
				(
					local theSortFactors = #()
					theWires = (magmaFlowEditor_Functions.GetConnectedNodes magma n[2])
					theWires2 = #()
					for w in theWires do join theWires2 w
					for w in theWires2 where magma.getNodeProperty w[1] "Internal_OrderX" == (i-1) do --collect the wires going to the previous column
					(
						local thePos = (magma.getNodeProperty w[1] "Internal_Position").y
						local theOutCount = magma.getNumNodeOutputs w[1]
						local theNodeSizeY = hc.nodeSize.y
						local theTextureOffset = 0
						if MagmaFlowSettings.showTextureMapSample and magma.getNodeProperty w[1] "texmap" != undefined do theTextureOffset= MagmaFlowSettings.NodeWidth
						if MagmaFlowSettings.showColorSwatchSample and (magma.getNodeType w[1]) as name== #InputValue and classof (magma.getNodeProperty w[1] "controller").value  == Point3 do theTextureOffset = 20
							
						local theInSocketPos = 20+theTextureOffset+(theOutCount-1+w[2])*15
						append theSortFactors (thePos + theInSocketPos - 20 ) --collect the factor based on parent node Y and socket
					)
					append sortArray (amin theSortFactors) --collect the min. sort factor to represent the current node
				)
				local sortIndexArray = for k = 1 to theNodesArray[i].count collect k
				qsort sortIndexArray compareFN valArray:sortArray
				local currentYOffset = 0
				for k in sortIndexArray do
				(
					n = theNodesArray[i][k]
					local thePos = [hc.width-n[3]*(MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace), currentYOffset]
					
					if thePos.y < sortArray[k] do 
					(
						currentYOffset += sortArray[k]-thePos.y
						thePos.y = sortArray[k]
					)
					magma.setNodeProperty n[2] "Internal_Position" thePos		
						
					hc.activeNode = n[1]
					local theNodeSizeY = hc.nodeSize.y
					if MagmaFlowSettings.showTextureMapSample and magma.getNodeProperty n[2] "texmap" != undefined do theNodeSizeY += hc.nodeSize.x
					if MagmaFlowSettings.showColorSwatchSample and (magma.getNodeType n[2]) as name== #InputValue and classof (magma.getNodeProperty n[2] "controller").value  == Point3 do theNodeSizeY += 20
						
					currentYOffset += theNodeSizeY + MagmaFlowSettings.NodeYSpace				
					if currentYOffset > maxPosY do maxPosY = currentYOffset
					if thePos.x > maxPosX do maxPosX = thePos.x
				)
			)
			
			--Finally, process the unconnected nodes and put them on the far left side or bottom of the editor
			
			if MagmaFlowSettings.UnconnectedNodesPlacement == #bottom do
			(
				local currentYOffset = maxPosY --+ MagmaFlowSettings.NodeYSpace
				local currentXOffset = hc.width - MagmaFlowSettings.NodeWidth - MagmaFlowSettings.NodeXSpace	
				for i = 1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					local theOrderX = magma.getNodeProperty theID "Internal_OrderX"
					if theOrderX == 0 do
					(
						thePos = [currentXOffset, currentYOffset]
						magma.setNodeProperty theID "Internal_Position" thePos
						hc.activeNode = i
						currentXOffset -= MagmaFlowSettings.NodeWidth + MagmaFlowSettings.NodeXSpace	
					)
				)
			)
			
			if MagmaFlowSettings.UnconnectedNodesPlacement == #left do
			(
				local currentYOffset = 0
				for i = 1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					local theOrderX = magma.getNodeProperty theID "Internal_OrderX"
					if theOrderX == 0 do
					(
						thePos = [hc.width-(reorderLastLevelX+1)*(MagmaFlowSettings.NodeWidth+MagmaFlowSettings.NodeXSpace), currentYOffset]
						magma.setNodeProperty theID "Internal_Position" thePos
						hc.activeNode = i
						local theNodeSizeY = hc.nodeSize.y
						if MagmaFlowSettings.showTextureMapSample and magma.getNodeProperty theID "texmap" != undefined do theNodeSizeY += hc.nodeSize.x
						if MagmaFlowSettings.showColorSwatchSample and (magma.getNodeType theID) as name== #InputValue and classof (magma.getNodeProperty theID "controller").value  == Point3 do theNodeSizeY += 20
						currentYOffset += theNodeSizeY + MagmaFlowSettings.NodeYSpace	
					)
				)
			)
			createNodeTree init:true
		)

		fn autoReorderFlow update:true = 
		(
			local st = timestamp()
			if MagmaFlowSettings.AutoReorderToggle == true do 
			(
				reorder_dot()
			)
			FranticParticles.LogDebug ("MagmaFlow: Reorder Flow Took "+((timestamp()-st)) as string + " ms." )
			if update do createNodeTree init:false
		)
		fn ReorderToggle = 
		(
			MagmaFlowSettings.AutoReorderToggle = not MagmaFlowSettings.AutoReorderToggle
			setIniSetting (theIniFileLocation + "MagmaFlowEditor_Preferences.ini") "AutoReorder" "Toggle" (MagmaFlowSettings.AutoReorderToggle as string)
			updateEditorTitle()
			autoReorderFlow()
			updateNavigator()			
		)
		
		fn AcceptReorderedFlow =
		(
			autoReorderFlow()
			for i = 1 to magma.getNumNodes() do
			(
				theID = magma.getNodeID i
				thePos = magma.getNodeProperty theID "Internal_Position"
				if thePos != undefined do magma.setNodeProperty theID "Position" thePos
			)
			createNodeTree init:false
			MagmaFlowSettings.autoReorderToggle = false
			updateEditorTitle()
			updateNavigator()	
		)
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--CONNECTIVITY COLLAPSE BRANCH FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
		
		fn stampChildBranchCollapsed theChild theParent =
		(
			local parentState1 = magma.getNodeProperty theParent "Collapsed" == true
			local parentState2 = magma.getNodeProperty theParent "Internal_BranchCollapsed" == true
			magma.setNodeProperty theChild "Internal_BranchCollapsed" (parentState1 OR parentState2)
			for c = 1 to magma.getNumNodeInputs theChild do
			(
				local theWire = magma.getNodeInput theChild c
				if theWire != undefined and theWire[1] > -1 do
				(
					stampChildBranchCollapsed theWire[1] theChild
				)
			)
		)		
		
		fn stampChildBranchUncollapsed theChild =
		(
			magma.setNodeProperty theChild "Internal_BranchCollapsed" false
			for c = 1 to magma.getNumNodeInputs theChild do
			(
				local theWire = magma.getNodeInput theChild c
				if theWire != undefined and theWire[1] > -1 do
				(
					stampChildBranchUncollapsed theWire[1] 
				)
			)
		)
		
		fn CollapseBranches =
		(
			for i = 1 to magma.getNumNodes() do
			(
				local theID = magma.getNodeID i
				magma.declareExtensionProperty theID "Internal_BranchCollapsed"
				magma.setNodeProperty theID "Internal_BranchCollapsed" false
			)
			if MagmaFlowSettings.AllowSubtreeCollapsing do
			(
				if magma.NumEditingBLOPs() > 0 then
				(
					local numBLOPOutputs = magma.GetNumNodeOutputs (magma.CurrentBLOP)
					for i = 1 to numBLOPOutputs do
					(				
						local theConnection = magma.getOutput i 
						local theConnectedID = theConnection[1] 
						if theConnectedID != undefined and theConnectedID > -1 do
						(
							try
							(
								for c = 1 to magma.getNumNodeInputs theConnectedID do
								(
									local theWire = magma.getNodeInput theConnectedID c
									if theWire != undefined and theWire[1] > -1 do
										stampChildBranchCollapsed theWire[1] theConnectedID
								)
							)catch()
						)
					)
				)
				else --top level			
				(
					for i = 1 to magma.getNumNodes() do
					(
						local theID = magma.getNodeID i
						if magma.getNodeType theID == "Output" do 
						(
							local theWire = magma.getNodeInput theID 1
							if theWire != undefined and theWire[1] > -1 do
								stampChildBranchCollapsed theWire[1] theID
						)--end if output
					)
				)
				for i = 1 to magma.getNumNodes() do
				(
					local theID = magma.getNodeID i
					if magma.getNodeProperty theID "Internal_BranchCollapsed" == true do
					(
						local parentLinks = MagmaFlowEditor_Functions.getConnectedNodes magma theID
						for c in parentLinks do
							for j in c do
								if magma.getNodeProperty j[1] "Internal_BranchCollapsed" != true and magma.getNodeProperty j[1] "Collapsed" != true  do 
									stampChildBranchUncollapsed theID
					)
				)
			)
		)
		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--PAN AND ZOOM FUNCTIONS		
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

		local bBoxSize, theBBoxCenter, theMin
		local navigatorBitmapBlank
		local navigatorBitmapBackground
		local navigatorBitmapForeground
		
		fn initNavigator =
		(
			navigatorBitmapBlank = bitmap 180 100 color:MagmaFlowColors.EditorBackgroundColor
			navigatorBitmapBackground = bitmap 180 100
			navigatorBitmapForeground = bitmap 180 100
		)
		
		fn updateNavigatorBackground =
		(
			copy navigatorBitmapBlank navigatorBitmapBackground 
			local allPositions = #()
			local minX = 1000000
			local minY = 1000000
			local maxX = -1000000
			local maxY = -1000000
			for i = 1 to magma.getNumNodes() do
			(
				local theID = magma.getNodeID i
				local isBranchCollapsed = (magma.getNodeProperty theID "Internal_BranchCollapsed") == true	
				if not isBranchCollapsed do
				(
					hc.activeNode = i
					local thePos = hc.activeNodePos --magma.getNodeProperty theID "Position"
					local theType = magma.getNodeType theID
					if theType != "Output" do
					(
						local theNodeSize = hc.nodeSize
						if theType == "InputTexmap" and MagmaFlowSettings.showTextureMapSample and magma.getNodeProperty theID "texmap" != undefined do 
							theNodeSize+=[0,theNodeSize.x]
						append allPositions #(thePos, theNodeSize, if hc.isSelected then white else hc.nodeColor)
						if thePos.x > maxX do maxX = thePos.x
						if thePos.x < minX do minX = thePos.x
						if thePos.y > maxY do maxY = thePos.y
						if thePos.y < minY do minY = thePos.y
					)
				)
			)
			maxX += 140
			minX -= 20
			maxY += 140
			minY -= 20
			theMin = [minX,minY]
			theMax = [maxX, maxY]
			bBoxSize = theMax-theMin
			theColor = blue
			for i = 1 to allPositions.count do
			(
				thePos = allPositions[i][1]
				relPos1 = ((thePos - theMin) / bboxSize)*[180,100]
				relPos2 = ((thePos - theMin + allPositions[i][2]) / bboxSize)*[180,100]
				local theColors1 = for j = relPos1.x to relPos2.x collect allPositions[i][3]*0.6
				local theColors2 = for j = relPos1.x to relPos2.x collect allPositions[i][3]*0.9
				local titleHeight = relPos1.y + 2
				for j = relPos1.y to relPos2.y do
					setPixels navigatorBitmapBackground [relPos1.x, j] (if j <= titleHeight then theColors1 else theColors2)
			)			
		)
		
		fn updateNavigator fullUpdate:true=
		(
			if fullUpdate do updateNavigatorBackground()
			
			copy navigatorBitmapBackground navigatorBitmapForeground
			--format "Pan:%  Zoom:%\n" hc.pan hc.zoom
			--format "theMin: %  bboxSize: %\n" theMin bboxSize
			local theUpperLeft = ((-hc.pan - theMin) /bboxSize / hc.zoom)*[180,100] 
			local theBottomRight = (((-hc.pan - theMin + [hc.width, hc.height]) / hc.zoom )/ bboxSize)*[180,100] 
			theBBoxCenter = (theUpperLeft+(theBottomRight-theUpperLeft)*0.5)
			
			if theUpperLeft.x <=0 do theUpperLeft.x = 0
			if theBottomRight.x >= 179 do theBottomRight.x = 179
			if theUpperLeft.y <=0 do theUpperLeft.y = 0
			if theBottomRight.y >= 99 do theBottomRight.y = 99
				
			theColors = for i = theUpperLeft.x to theBottomRight.x collect blue
			if theUpperLeft.y != 0 do setPixels navigatorBitmapForeground theUpperLeft theColors
			if theBottomRight.y != 99 do setPixels navigatorBitmapForeground [theUpperLeft.x,theBottomRight.y] theColors
			for i = theUpperLeft.y to theBottomRight.y do 
			(
				if theUpperLeft.x != 0 do setPixels navigatorBitmapForeground [theUpperLeft.x,i] #(blue)
				if theBottomRight.x != 179 do setPixels navigatorBitmapForeground [theBottomRight.x,i] #(blue)
			)
			bmp_navigator.bitmap = navigatorBitmapForeground
			--format "Pan: %   Zoom: %\n" hc.pan hc.zoom
		)
		
		fn moveNavigatorWindow pos =
		(
			--format "pos = %  TheCenter = %\n" pos theBBoxCenter
			theOffset = (pos - theBBoxCenter)/[180,100]*bBoxSize --convert imgtag pixels to real pixels
			--format "theOffset  = %\n" theOffset
			hc.pan -= theOffset * hc.zoom
			updateNavigator fullUpdate:false
			createNodeTree init:false			
		)
		
		local leftMouseDown = false
		on MagmaFlowEditor_Rollout lbuttondown pos do
		(
			thePos = pos - bmp_navigator.pos
			if thePos.x >= 0 and thePos.y >= 0 and thePos.x < 180 and thePos.y < 100 do
			(
				leftMouseDown = true
				moveNavigatorWindow thePos			
			)
		)
		on MagmaFlowEditor_Rollout lbuttonup pos do
		(
			leftMouseDown = false
		)
		
		on MagmaFlowEditor_Rollout rbuttondown pos do
		(
			popupMenu MagmaFlowEditor_Zoom_RCMenu pos:mouse.screenpos
		)
		
		on MagmaFlowEditor_Rollout mousemove pos do
		(
			if leftMouseDown do
			(
				thePos = pos - bmp_navigator.pos
				moveNavigatorWindow thePos
			)
		)		
		
		
		fn resetPanFactor update:true createUndo:true=
		(
			hc.pan = [0,0]
			if createUndo do createUndoRecord ("Reset Pan")
			if update do
			(
				createNodeTree init:false
				updateNavigator fullUpdate:false						
			)
		)		
		
		fn resetZoomFactor update:true createUndo:true=
		(
			hc.zoom = 1
			if createUndo do createUndoRecord ("Reset Zoom")
			if update do
			(
				createNodeTree init:false
				updateNavigator fullUpdate:false			
			)
		)
		
		fn ZoomExtents createUndo:true=
		(
			local minX = 1000000
			local maxX =-1000000
			local minY = 1000000
			local maxY =-1000000
			
			local theCount = editorNodeCount
			if theCount > 1 then
			(
				for i = 1 to theCount do
				(
					local theType = magma.getNodeType (NodeIDMap[i])
					if theType != Output do
					(
						hc.activeNode = i
						local theVal = hc.activeNodePos
						if theVal.x+150 > maxX do maxX = theVal.x+150
						if theVal.y+100 > maxY do maxY = theVal.y+100
						if theVal.x < minX do minX = theVal.x 
						if theVal.y < minY do minY = theVal.y
					)
				)
				minY -=40
				theBBoxX = maxX-minX
				theBBoxY = maxY-minY
				local theHCWidth = hc.width-leftDepotMargin
				hc.zoom = amin #(1.0*theHCWidth/theBBoxX,1.0*hc.height/theBBoxY)
				if hc.zoom > 1.5 do hc.zoom = 1.5
				hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
			)
			else
			(
				hc.zoom = 1.0
				hc.pan = [0,0]
			)
			createNodeTree init:false
			if createUndo do createUndoRecord ("Zoom Extents")
			updateNavigator fullUpdate:false
		)
		
		fn ZoomExtentsSelected createUndo:true =
		(
			local minX = 1000000
			local maxX =-1000000
			local minY = 1000000
			local maxY =-1000000
			local doZoom = 0
			
			local theCount = editorNodeCount
			if theCount > 1 then
			(
				for i = 1 to theCount do
				(
					local theType = magma.getNodeType (magma.getNodeID i)
					if theType != Output do
					(					
						hc.ActiveNode = i
						if hc.isSelected do
						(
							doZoom += 1
							local theVal = hc.activeNodePos
							if theVal.x+150 > maxX do maxX = theVal.x+150
							if theVal.y+100 > maxY do maxY = theVal.y+100
							if theVal.x < minX do minX = theVal.x 
							if theVal.y < minY do minY = theVal.y
						)		
					)
				)
				if doZoom > 1 do
				(
					minY -=40
					theBBoxX = maxX-minX
					theBBoxY = maxY-minY
					hcWidth = hc.width-leftDepotMargin
					hc.zoom = amin #(1.0*hcWidth/theBBoxX,1.0*hc.height/theBBoxY)
					if hc.zoom > 1.5 do hc.zoom = 1.5
					hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
				)
				if doZoom == 1 do 
				(
					minY -= 40
					--minX -= hc.width/4
					theBBoxX = maxX-minX
					theBBoxY = maxY-minY			
					hc.zoom = amin #(1.0*hc.width/theBBoxX,1.0*hc.height/theBBoxY)					
					if hc.zoom > 1.5 do hc.zoom = 1.5
					hc.pan = -[minX,minY]*hc.zoom + [leftDepotMargin,0]
				)
			)
			createNodeTree init:false
			if createUndo do createUndoRecord ("Zoom Extents Selected")
			updateNavigator fullUpdate:false
		)		
		
		
		
------------------------------------------------------------		
--SCHEMATIC CONTROLS EVENT HANDLERS		
------------------------------------------------------------		
		on hc connectionChanged fromNodeIndex toNodeIndex toSocketID fromSocketID status toSocketCount do
		(
			if status == 1 then --CONNECTED
			(
				toID = NodeIDMap[toNodeIndex]
				fromID = NodeIDMap[fromNodeIndex]
				
				if toID == undefined or fromID == undefined do --if one of these is undefined, try to rebuild the NodeIDMap and try again.
				(
					createNodeTree init:false
					toID = NodeIDMap[toNodeIndex]
					fromID = NodeIDMap[fromNodeIndex]
				)
				
				FranticParticles.LogDebug ("NodeIDMap=" + (with PrintAllElements on (NodeIDMap as string)))
				FranticParticles.LogDebug ("toNodeIndex=" + toNodeIndex as string + " fromNodeIndex="+ fromNodeIndex as string + " toID="+toID as string + " fromID="+ fromID as string  )
				
				--format "NodeIDMap=%\n" NodeIDMap
				--format "toNodeIndex=%\n" toNodeIndex
				--format "fromNodeIndex=%\n" fromNodeIndex
				
				--format "toID=%\n" toID
				--format "fromID=%\n" fromID				
				
				if magma.getNodeType fromID == "BLOPSocket" then
				(
					if toID == -1 then
					(
						magma.SetOutput toSocketID fromID fromSocketID
						MagmaFlowEditor_Rollout.createUndoRecord ("Connect ["+ fromID as string + "," + fromSocketID as string + "] to [BLOP Output " + toSocketID as string +"]" )
					)
					else
					(
						magma.SetNodeInput toID toSocketID fromID fromSocketID
						MagmaFlowEditor_Rollout.createUndoRecord ("Connect ["+ fromID as string + "," + fromSocketID as string + "] to ["+ toID as string + "," + toSocketID as string +"]" )
					)
				)
				else
				(
					if toID == -1 then
					(
						local fromNodeOutputIndex = fromSocketID - magma.GetNumNodeInputs fromID
						magma.setOutput toSocketID fromID fromNodeOutputIndex
						MagmaFlowEditor_Rollout.createUndoRecord ("Connect ["+ fromID as string + "," + fromNodeOutputIndex as string+"] to [Output,"+ toSocketID as string + "]"  )
					)
					else
					(
						local fromNodeOutputIndex = fromSocketID - magma.GetNumNodeInputs fromID
						try
						(
							magma.SetNodeInput toID toSocketID fromID fromNodeOutputIndex
							MagmaFlowEditor_Rollout.createUndoRecord ("Connect ["+ fromID as string + "," + fromNodeOutputIndex as string+"] to [" +toID as string + "," + toSocketID as string + "]" )
						)catch()
					)
				)
			)
			else  --DISCONNECTED
			(
				toID = NodeIDMap[toNodeIndex] 
				if toID > -1 then
				(
					local oldConnection = magma.GetNodeInput toID toSocketID
					magma.SetNodeInput toID toSocketID -1 1
					MagmaFlowEditor_Rollout.createUndoRecord ("Disconnect [" + oldConnection[1] as string + "," + oldConnection[2] as string + "] from ["+ toID as string + ","+toSocketID as string+"] ")
				)
				else
				(
					local oldConnection = magma.GetOutput toSocketID
					magma.setOutput toSocketID -1 1
					MagmaFlowEditor_Rollout.createUndoRecord ("Disconnect [" + oldConnection[1] as string + "," + oldConnection[2] as string + "] from [BLOP Output "+toSocketID as string+"] ")
				)
				
			)
			updateMagmaHolder()
			--createNodeTree init:true
			autoReorderFlow createUndo:false
			displaySelectedNodeProperties()
			createNodeTree init:false
		)		
		
		on hc connectToEmpty nodeIndex socketIndex socketType do
		(
			ConnectToEmpty_fromID = NodeIDMap[nodeIndex]
			if ConnectToEmpty_fromID == undefined do return false
			if ConnectToEmpty_fromID == -1 then
			(
				ConnectToEmpty_Index = socketIndex 
				showRCMenu #allNodes
				ConnectToEmpty_SocketType = #input
			)
			else
			(
				local theFromSocket = (magma.getNodeInput ConnectToEmpty_fromID socketIndex)[1]
				if  theFromSocket == undefined or theFromSocket > -1 do return false
				local numInputs = (magma.GetNumNodeInputs ConnectToEmpty_fromID)
				if socketIndex <= numInputs then
				(
					ConnectToEmpty_Index = socketIndex 
					ConnectToEmpty_SocketType = #input
					if magma.getNodeType ConnectToEmpty_fromID == "BLOPSocket" do ConnectToEmpty_SocketType = #output
					if matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Object" then
					(
						local theNewNode = createNode "InputObject" mode:#dragwire
						setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
						displaySelectedNodeProperties()
					)
					else if matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Geometry" then
					(
						local theNewNode = createNode "InputGeometry"	mode:#dragwire
						setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
						displaySelectedNodeProperties()
					)
					else if matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Ray Direction (WS)" then
					(
						if keyboard.controlPressed then
							showRCMenu #allNodes
						else					
						(
							local theNewNode = createNode "InputValue" mode:#dragwire
							local theCtrl = point3_xyz(); theCtrl.value = [0,0,-1]
							magma.SetNodeProperty theNewNode "controller" theCtrl		
							setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
							displaySelectedNodeProperties()							
						)
					)
					else if matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Lookup Point (WS)" or matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Ray Origin (WS)"  then
					(
						if keyboard.controlPressed then
							showRCMenu #allNodes
						else					
						(
							local theDeps = refs.dependentNodes magma
							if theDeps.count == 1 and classof theDeps[1].baseobject == PRT_Hair then
							(
								local theNewNode = createNode "InputChannel" channelName:"HairRoot" mode:#dragwire
								if theDeps[1].SourceType == 1 then
								(
									setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
									displaySelectedNodeProperties()	
								)
								else
								(
									setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
									displaySelectedNodeProperties()	
									MagmaFlowEditor_InputChannelRollout.btn_transformToWorld.pressed()					
									try
									(
										local theConverter = magma.getNodeID (getSelectedNodes())[1]
										magma.setNodeProperty theConverter "inputType"	"Point"
									)catch()
									setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
									displaySelectedNodeProperties()	
								)
							)
							else
							(
								local theNewNode = createNode "InputChannel" channelName:"Position" mode:#dragwire
								setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
								displaySelectedNodeProperties()	
								MagmaFlowEditor_InputChannelRollout.btn_transformToWorld.pressed()				
								setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
								displaySelectedNodeProperties()	
							)
						)
					)
					else if matchPattern (getInputSocketName ConnectToEmpty_fromID socketIndex) pattern:"Particles" then
					(
						local theNewNode = createNode "InputParticles" mode:#dragwire
						setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
						displaySelectedNodeProperties()	
					)
					else if findItem #("Posit","Norma","Color","Textu","Mappi") (substring (getInputSocketName ConnectToEmpty_fromID socketIndex) 1 5) > 0 and magma.getNodeType ConnectToEmpty_fromID == "InputTexmap" then
					(
						if keyboard.controlPressed then
							showRCMenu #allNodes
						else
						(
							local theNewNode = createNode "InputChannel" channelName:(getInputSocketName ConnectToEmpty_fromID socketIndex) mode:#dragwire
							setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
							displaySelectedNodeProperties()	
						)
					)				
					else
					(
						if keyboard.controlPressed then
							showRCMenu #Input
						else
						(
							showRCMenu #allNodes
						)
					)
				)
				else
				(
					ConnectToEmpty_Index = socketIndex - numInputs
					ConnectToEmpty_SocketType = #output
					local theFromType = (magma.getNodeType ConnectToEmpty_fromID)
					if theFromType == "InputGeometry" then
					(
						showRCMenu #Object
					)
					else if theFromType == "InputObject" then
					(
						local theNewNode = createNode "PropertyQuery" mode:#dragwire
						setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
						displaySelectedNodeProperties()					
					)
					else if theFromType == "InputParticles" then
					(
						local theNewNode = createNode "ParticleQuery" mode:#dragwire
						setSelectedNodes #(MagmaFlowEditor_Functions.getIndexByID magma theNewNode)
						displaySelectedNodeProperties()					
					)
					else
					(
						--format "General \n"
						showRCMenu #allNodes
					)
				)
			)
		)
		
		on hc connectionSelectionChanged fromNodeIndex toNodeIndex toSocketID fromSocketID do
		(
			lastWireSelection = #(fromNodeIndex, fromSocketID, toNodeIndex, toSocketID, timestamp() )
			--format "%\n" lastWireSelection 
		)
		
		fn removeNode deleteTheNode:true=
		(
			local needExposureUpdate = false
			theIndices = for i = 1 to EditorNodeCount collect 
			(
				hc.ActiveNode = i
				if hc.isSelected then i else dontcollect
			)
			if theIndices.count > 0 do
			(
				sort theIndices
				for index in theIndices.count to 1 by -1 do --loop backwards through all nodes selected for removal
				(
					local theID = magma.getNodeID theIndices[index] --get the ID of the node to remove
					local firstInput = #(-1,1)
					for j = 1 to magma.getNumNodeInputs theID while firstInput[1] == -1 do
					(
						firstInput = magma.getNodeInput theID j --get the first input of the node to remove
					)
					local firstOutput = (magmaFlowEditor_Functions.GetConnectedNodes magma theID)[1] --get the nodes connected to the first output of the node to remove
					if firstOutput != undefined and firstOutput.count > 0 do 
					(
						for j in firstOutput do
							magma.setNodeInput j[1] j[2] firstInput[1] firstInput[2] --connect the upstream node's input 1 to the downstream node's output socket connected to the input 1 of the node to remove
					)
					for j = 1 to magma.getNumNodeInputs theID do magma.setNodeInput theID j -1 1 --disconnect all inputs of the node to remove
					if deleteTheNode do 
					(
						if magma.getNodeProperty theID "Exposed" == True do needExposureUpdate = true
						for i = 1 to magma.getNumNodes() do
						(
							theIDtoCheck = magma.getNodeID i
							for c = 1 to magma.getNumNodeInputs theIDtoCheck do
								if (magma.getNodeInput theIDtoCheck c)[1] == theID do 
									magma.setNodeInput theIDtoCheck c -1 1
						)
						magma.deleteNode theID --if deleting, delete the node
					)
				)				
				updateMagmaHolder()
				if needExposureUpdate do exposeControlsToModifier()
				autoReorderFlow createUndo:false
				displaySelectedNodeProperties()	
				updateNavigator fullUpdate:true				
				updateInsertMode()
				updateEditorTitle()
				lastSelection = #()
			)	
		)
		
		fn removeNodeFromFlow = 
		(
			removeNode deleteTheNode:false
		)	

		fn deleteSelectedNodes =
		(
			removeNode deleteTheNode:true
		)
		
		on hc nodesDeleted do
		(
			local needUpdate = false
			local theIndices = sort (for i = 1 to hc.getDeletedNodeCount collect (hc.getDeletedNodeIndex = i))
			for index in theIndices.count to 1 by -1 do
			(
				local theID = magma.getNodeID theIndices[index]
				if theID != undefined and theID > -1 do --if the ID is valid, in other words not a Depot item
				(
					local theType = magma.getNodeType theID
					if theType != undefined do --and theType != "Output" do 
					(
						needUpdate = true
						for i = 1 to magma.getNumNodes() do
						(
							local theIDtoCheck = magma.getNodeID i
							for c = 1 to magma.getNumNodeInputs theIDtoCheck do
								if (magma.getNodeInput theIDtoCheck c)[1] == theID do 
								(
									--format "Input % of Node % still connected to %, resetting...\n" c theIDtoCheck theID
									magma.setNodeInput theIDtoCheck c -1 1
								)
						)	
						magma.deleteNode theID
					)	
				)
			)	
			if needUpdate do
			(
				if theIndices.count == 1 then
					createUndoRecord ("Delete One Selected Node")				
				else
					createUndoRecord ("Delete " + theIndices.count as string + " Selected Nodes")				
				autoReorderFlow createUndo:false
				--if AutoZoomExtents do zoomExtents createUndo:false
				exposeControlsToModifier()
				displaySelectedNodeProperties()
			)	
			updateMagmaHolder()
			--createNodeTree init:true	
			updateNavigator fullUpdate:true		
			updateInsertMode()
			updateEditorTitle()		
			lastSelection = #()
		)		
		
		

		on hc mouseScroll do
		(
			if hc.zoom > 1.2 do hc.zoom = 1.2
			showGrid MagmaFlowSettings.SnapToGrid
			drawDepot init:false lock:true
			updateNavigator fullUpdate:false
		)
		
		fn storePanAndZoom =
		(
			if magma.NumEditingBLOPs() == 0 then
			(
				MagmaFlowEditor_Functions.setEditorProperty magma "EditorPan" (hc.pan as string)
				MagmaFlowEditor_Functions.setEditorProperty magma "EditorZoom" (hc.zoom as string)
			)
			else
			(
				for i = 1 to magma.getNumNodes() do 
				(
					theBlopSocket = (magma.getNodeID i)
					magma.DeclareExtensionProperty theBlopSocket  "EditorPan" 
					magma.DeclareExtensionProperty theBlopSocket  "EditorZoom" 
					magma.setNodeProperty theBlopSocket "EditorPan" hc.pan 
					magma.setNodeProperty theBlopSocket "EditorZoom" hc.zoom 
				)
			)
		)
		
		fn restorePanAndZoom =
		(
			if magma.NumEditingBLOPs() == 0 then
			(
				thePan =  (MagmaFlowEditor_Functions.getEditorProperty magma "EditorPan" )
				theZoom = (MagmaFlowEditor_Functions.getEditorProperty magma "EditorZoom" )
				if thePan != undefined do hc.pan = execute thePan
				if theZoom != undefined do hc.zoom = execute theZoom
			)
			else
			(
				local done = false
				for i = 1 to magma.getNumNodes() while not done do 
				(
					theBlopSocket = (magma.getNodeID i)
					thePan = magma.getNodeProperty theBlopSocket "EditorPan" 
					theZoom = magma.getNodeProperty theBlopSocket "EditorZoom"
					if thePan != undefined and theZoom != undefined do 
					(
						hc.pan = thePan
						hc.zoom = theZoom
						hc.redrawView	
						done = true
					)
				)
			)
			hc.redrawView	
		)		
		
		local leftButtonDown = false
		local middleButtonDown = false
		on hc mButtonUp do
		(
			middleButtonDown = false
			drawDepot init:false lock:false
			updateNavigator fullUpdate:false
			storePanAndZoom()
		)		
		
		on hc mButtonDown do
		(
			middleButtonDown = true
			drawDepot init:false lock:true
		)			
		
		on hc LButtonDown do
		(
			leftButtonDown = true
			if not DisableDragAndDrop do
			(
				prepareDepotForDragAndDrop()
			)
			lastSelectionBeforeClick = getSelectedNodes()
			lastMouseClick = mouse.screenpos
		)		
		
		fn updateInsertMode update:true=
		(
			local theSel = getSelectedNodes()
			MagmaFlowSettings.nodeInsertMode = true
			MagmaFlowSettings.nodeInsertSocket = 0
			toggleInsertMode update:update
		)		
		
		on hc LButtonUp do
		(
			leftButtonDown = false
			local theSel = getSelectedDepotButton()
			try
			(
				hc.setInfo = case theSel.count of
				(
					1: "Depot: " + DepotNodes[theSel[1]][5] --getFileNameFile
					0: "" 
					default: "Multiple Depot Nodes Selected"
				)	
			)catch()
			
			--handle Depot Category Head clicking
			if theSel.count == 1 and theSel[1] <= DepotNodes.count and (DepotNodes[theSel[1]][1] == "HEAD" or DepotNodes[theSel[1]][1] == "SUBHEAD") then 
			(
				if (keyboard.ControlPressed and not keyboard.shiftPressed) then
				(
					if (MagmaFlowSettings.DepotPlacement != #bottomrollup and MagmaFlowSettings.DepotPlacement != #bottomrollupreverse) do
						for j = 1 to DepotDefinition.count where DepotDefinition[j][1][1]  == "HEAD" do
							DepotDefinition[j][1][6] = false
					for j = 1 to DepotDefinition.count where DepotDefinition[j][1][2] == DepotNodes[theSel[1]][2] do
						DepotDefinition[j][1][6] = true
				)
				else if keyboard.shiftPressed and not keyboard.ControlPressed then
				(
					for j = 1 to DepotDefinition.count where DepotDefinition[j][1][1]  == "HEAD" do
						DepotDefinition[j][1][6] = true					
				)
				else if keyboard.shiftPressed and keyboard.ControlPressed then
				(
					for j = 1 to DepotDefinition.count where DepotDefinition[j][1][1]  == "HEAD" do
						DepotDefinition[j][1][6] = false							
				)
				else if not keyboard.shiftPressed and not keyboard.ControlPressed then
				(
					for j = 1 to DepotDefinition.count do
					(
						if DepotDefinition[j][1][2] == DepotNodes[theSel[1]][2] do
						(
							DepotDefinition[j][1][6] = not DepotDefinition[j][1][6]
							if (MagmaFlowSettings.DepotPlacement == #bottomrollup or MagmaFlowSettings.DepotPlacement == #bottomrollupreverse) and DepotDefinition[j][1][6] == true do 
							(
								for k = 1 to DepotDefinition.count where k != j do
									DepotDefinition[k][1][6] = false
							)
						)
					)
					
				)	
				updateDepotDefinition()
				createNodeTree init:true
				--if AutoZoomExtents do zoomExtents createUndo:false
			)	
			else --handle Depot Drag and Drop
			(
				if not DisableDragAndDrop then
				(
					local result = handleDepotDragAndDrop()
					drawDepot init:false
					if not result do updateNodeSelection()
				)	
				else 
				(
					updateNodeSelection()
				)
			)
			
			if keyboard.shiftPressed do 
			(
				removeNode deleteTheNode:false
			)
			
			if MagmaFlowSettings.isPickingChannelFromNode != undefined then
			(
				--format "%\n" MagmaFlowSettings.isPickingChannelFromNode
				local NodesSelected = getSelectedNodes()
				local NodeClick = 0
				if NodesSelected.count == 1 do NodeClick = NodesSelected[1]
				--format "NodeClick = %\n" NodeClick 
				--setSelectedNodes #(MagmaFlowSettings.isPickingChannelFromNode)
				if NodeClick > 0 and NodeClick <= magma.getNumNodes() then 
				(
					local theID = magma.getNodeID NodeClick
					--format "theID = %\n" theID 
					
					local theChannel = magma.getNodeProperty theID "channelName"
					--format "theChannel = %\n" theChannel 
					if theChannel != undefined do 
					(
						local theChannelType = magma.getNodeProperty theID "channelType"
						magma.setNodeProperty (magma.getNodeID MagmaFlowSettings.isPickingChannelFromNode) "channelName" theChannel
						magma.setNodeProperty (magma.getNodeID MagmaFlowSettings.isPickingChannelFromNode) "channelType" theChannelType
						
						setSelectedNodes #(MagmaFlowSettings.isPickingChannelFromNode)
						MagmaFlowSettings.isPickingChannelFromNode = undefined
					)
				)
			)
				
			--debugFlow()	
			DisableDragAndDrop = false --enable DND on first mouse move. This prevents from undesired DnD operations on menu commands.

			if MagmaFlowSettings.insertNodeIntoFlow do
			(
				local theSelection = getSelectedNodes()
				if theSelection.count == 1 do
				(
					local theInsertID = magma.getNodeID theSelection[1]
					insertNodeIntoExistingFlow theInsertID
				)
			)
			

			updateDepotDefinition()
			updateNodeSelection()
			updateInsertMode() --FIXME - this causes an update of all nodes

			local theSelection = getSelectedNodes()
			if theSelection.count != 1 do 
			(
				--print "selection is not 1, resetting"
				--lastWireSelection = #()
			)
			if hc.getSelectedConnectionNodeAndSocket == false and not keyboard.controlPressed  do  --and theSelection.count != 1 
			(
				if lastWireSelection.count > 0 and timestamp()-lastWireSelection[5] > 100.0 do
				(
					--print "wire deselected, resetting"
					lastWireSelection = #()
				)
			)
			
			drawDepot init:false
			updateNavigator()
		)
		

		
		
		on hc RButtonDown do
		(
			local theMouse = getMouseInSchematicView()
			lastNodeClick = (hc.findNodeByPos = theMouse)
			if lastNodeClick > 0 and lastNodeClick <= editorNodeCount then 
			(
				popupMenu EditNode_RCMenu pos:mouse.screenpos
			)
			else if lastNodeClick  > editorNodeCount then 
				popupMenu DepotNode_RCMenu pos:mouse.screenpos
			else if lastWireSelection.count > 0 then
				popupMenu InsertNode_RCMenu pos:mouse.screenpos
			else
				popupMenu AddNode_RCMenu pos:mouse.screenpos
		)		
		
			
		fn setToolTip thePos theNodeIndex =
		(
			hc.activeNode = theNodeIndex
			local refPos = hc.ActiveNodePos 
			local refSize = hc.nodeSize
			hc.activeNode = hc.getNodeCount
			theID = magma.getNodeID theNodeIndex
			local theNotes = MagmaFlowEditor_Functions.getUIProperty magma theID "Notes" --KrakatoaChannelEditor_DisplayNodeTreeData[theNodeIndex][4][16]
			if theNotes != undefined then
			(
				local theNotesArray = filterString theNotes "\n" splitEmptyTokens:true
				local maxChars = 0
				local theLinesCount = amin #(theNotesArray.count,10)
				for i = 1 to theLinesCount do
				(
					hc.activeSocket = i
					hc.socketName = theNotesArray[i]
					if theNotesArray[i].count > maxChars do maxChars = theNotesArray[i].count
				)
				for i = theLinesCount+1 to 10 do
				(
					hc.activeSocket = i
					hc.socketName = ""
				)
				hc.nodeSize = [amin #(amax #(maxChars*6,refSize.x),300) ,20+theLinesCount*13]
				hc.ActiveNodePos = refPos+[refSize.x/2-hc.nodeSize.x/2,refSize.y]
			)
			else
				hc.ActiveNodePos = thePos+[-100000,-100000]
			hc.redrawView	
		)
		
		fn hideToolTip =
		(
			hc.activeNode = hc.getNodeCount
			hc.ActiveNodePos = [-100000,-100000]
			hc.redrawView	
		)
		

		
		on hc mouseMoved do
		(
			showTooltips = true
			local theMouse = getMouseInSchematicView()
			lastNodeOver = (hc.findNodeByPos = theMouse)
			local theID = magma.getNodeID lastNodeOver
			if lastNodeOver == 0 then
			(
				hideToolTip()
				hc.setInfo = lastInfoMessage
			)
			else
			(
				if lastNodeOver >= 0 and not leftButtonDown do
				(
					if lastNodeOver <= editorNodeCount then
					(
						if keyboard.controlPressed == true do setToolTip theMouse lastNodeOver
							
						theText = try(magma.GetNodeTypeDescription (magma.getNodeType theID) )catch("???")
						if theID > -1 then
						(
							local theNotes = magma.getNodeProperty theID "Notes"
							if theNotes != undefined and theNotes != "" do theText = substituteString theNotes "\n" " "
							if MagmaFlowSettings.DebugModeOn do
							(
								for i in DebugOverlayArray where i[1] == theID do
								(
									local theDebugText = "DEBUG: "
									for k = 2 to i.count do theDebugText+= i[k] as string + "  "
									theText = theDebugText + "  |  " + theText 
								)
							)
						)
						else theText = ""
					)
					else --if over depot
					(
						hc.activeNode = lastNodeOver
						theText = try(magma.GetNodeTypeDescription hc.nodeName)catch("")
						if theText == "" do 
						(
							local theIndex = findItem allBlopNames hc.nodeName
							if theIndex > 0 do theText = allBlopDescriptions[theIndex]
						)
					)
					hc.setInfo = theText
					hc.redrawView
				)
			)
			if middleButtonDown do updateNavigator fullUpdate:false
			--if leftButtonDown do updateNavigator fullUpdate:true
		)			
		
		
		fn disconnectAllInputs single:false =
		(
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 			
			for i in theSelection do
			(
				theID = magma.getNodeID i
				for c = 1 to magma.getNumNodeInputs theID do
				(
					magma.setNodeInput theID c -1 1
				)
			)		
			if theSelection.count > 0 do
			(
				createNodeTree init:true
				autoReorderFlow createUndo:false
				--if AutoZoomExtents do zoomExtents createUndo:false	
				createUndoRecord "Delete All Inputs"
				if single == false do setSelectedNodes theSelection
				updateMagmaHolder()
			)		
		)
		
		fn disconnectAllOutputs single:false =
		(
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 			
			for i in theSelection do
			(
				local theID = magma.getNodeID i
				for n = 1 to magma.getNumNodes() where n != i do
				(
					local theID2 = magma.getNodeID n
					for c = 1 to magma.GetNumNodeInputs theID2 do
					(
						if (magma.getNodeInput theID2 c)[1] == theID do
						(
							magma.setNodeInput theID2 c -1 1
						)
					)
				)
				/*
				local theWires = magma.getConnectedNodes theID
				format "theWires = %\n" theWires 
				for c = 1 to theWires.count do
				(
					for j = 1 to theWires[c].count do
					(
						magma.setNodeInput theWires[c][j][1] theWires[c][j][2] -1 1
					)
				)
				*/
			)		
			if theSelection.count > 0 do
			(
				createNodeTree init:true
				autoReorderFlow createUndo:false
				--if AutoZoomExtents do zoomExtents createUndo:false	
				createUndoRecord "Delete All Outputs"
				if single == false do setSelectedNodes theSelection
				updateMagmaHolder()
			)			
		)		
		
		
		fn swapInputsOrder single:false Last:false=
		(
			local success = false
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 
			for i in theSelection do
			(
				local theID = magma.getNodeID i
				--if magma.getNodeType theID == "Operator" do
				(
					if (Last==true OR keyboard.ShiftPressed) and magma.GetNumNodeInputs theID > 2 then
					(
						local temp1 = magma.getNodeInput theID 2 
						local temp2 = magma.getNodeInput theID 3
						magma.setNodeInput theID 2 temp2[1] temp2[2]
						magma.setNodeInput theID 3 temp1[1] temp1[2]
						success = true
					)
					else if magma.GetNumNodeInputs theID > 1 do
					(
						local temp1 = magma.getNodeInput theID 2 
						local temp2 = magma.getNodeInput theID 1
						magma.setNodeInput theID 2 temp2[1] temp2[2]
						magma.setNodeInput theID 1 temp1[1] temp1[2]
						success = true
					)	
				)
			)
			if theSelection.count > 0 and success == true do
			(
				autoReorderFlow createUndo:false
				createNodeTree init:true					
				--if AutoZoomExtents do zoomExtents createUndo:false	
				--createUndoRecord "Swap Operator Inputs"
				if single == false do setSelectedNodes theSelection
				updateMagmaHolder()
				displaySelectedNodeProperties()
			)	
		)		
		
		
		fn setPassThrough single:false =
		(
			local theSelection = getSelectedNodes()
			if single == true do
				if lastNodeClick > 1 then theSelection = #(lastNodeClick) else theSelection = #() 
			for i in theSelection do
			(
				local theID = magma.getNodeID i
				local theType = magma.getNodeType theID 
				if not matchPattern theType pattern:"Input*" do --theType != "Output" and 
					magma.setNodeProperty theID "enabled" (not (magma.getNodeProperty theID "enabled"))
			)
			if theSelection.count > 0 do
			(			
				createNodeTree init:false
				/*
				if theSelection.count == 1  then
					createUndoRecord ("Toggle Node ["+ KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][4][8] as string +"] " + (if KrakatoaChannelEditor_DisplayNodeTreeData[theSelection[1]][5] == false then "Off" else "On") )
				else
					createUndoRecord ("Toggle "+theSelection.count as string +" Nodes On/Off")
				if single == false do setSelectedNodes theSelection			
				*/
				updateMagmaHolder()
			)
			if theSelection.count == 1 do 
			(
				try(MagmaFlowEditor_OperatorRollout.updateGUI())catch()
				try(MagmaFlowEditor_OutputRollout.updateGUI())catch()
			)
			updateNavigator()
		)	
		
		fn updateEditorTitle = 
		(
			local txt = "KRAKATOA"
			if MagmaFlowEditor_Functions.IsGenome magma do txt = "GENOME"
			txt +=" MagmaFlow - "
			txt += (if MagmaFlowSettings.autoReorderToggle then "[REORDER] " else "[FREE] ")
			if MagmaFlowSettings.nodeInsertSocket > 0 then
			(
				txt += (if MagmaFlowSettings.nodeInsertMode then "[INSERT " else "[CONNECT ")
				txt += MagmaFlowSettings.nodeInsertSocket as string + "] "
			)
			else
				txt += "[OFF] "
			local theNodes = refs.dependentNodes magma
			for i in theNodes do txt += "<"+i.name+">"			
			if EditableBlopStack.count > 0 do
			(	
				for i in EditableBlopStack do txt += ">"+ i as string +":BLOP "
			)
			MagmaFlowEditor_Rollout.title = txt
		)
		
		fn toggleInsertMode update:true =
		(
			local theSel = getSelectedNodes()
			if theSel.count == 1 then
			(
				local theID = magma.getNodeID theSel[1]
				local theOuts = MagmaFlowEditor_Functions.getConnectedNodes magma theID
				local theConnected = for c = 1 to theOuts.count where theOuts[c].count > 0 collect c
				if MagmaFlowSettings.nodeInsertMode == false and MagmaFlowSettings.nodeInsertSocket == theOuts do
				(
					MagmaFlowSettings.nodeInsertMode = true
					MagmaFlowSettings.nodeInsertSocket = 0
				)
					
				if not MagmaFlowSettings.nodeInsertMode do
				(
					if keyboard.shiftPressed then
					(
						MagmaFlowSettings.nodeInsertSocket -= 1
						if MagmaFlowSettings.nodeInsertSocket < 1 do 
						(
							MagmaFlowSettings.nodeInsertMode = true
							MagmaFlowSettings.nodeInsertSocket = theOuts.count + 1
						)
					)
					else
					(
						MagmaFlowSettings.nodeInsertSocket += 1
						if MagmaFlowSettings.nodeInsertSocket > theOuts.count do 
						(
							MagmaFlowSettings.nodeInsertMode = true
							MagmaFlowSettings.nodeInsertSocket = 0
						)
					)
				)

				if MagmaFlowSettings.nodeInsertMode do
				(
					local done = false
					while not done do
					(
						if keyboard.shiftPressed then
						(
							MagmaFlowSettings.nodeInsertSocket -= 1
							if MagmaFlowSettings.nodeInsertSocket > 0 and theOuts[MagmaFlowSettings.nodeInsertSocket] != undefined and theOuts[MagmaFlowSettings.nodeInsertSocket].count > 0 do done = true
							if MagmaFlowSettings.nodeInsertSocket < 1 do 
							(
								MagmaFlowSettings.nodeInsertSocket = theOuts.count
								MagmaFlowSettings.nodeInsertMode = false
								done = true
							)
						)
						else
						(
							MagmaFlowSettings.nodeInsertSocket += 1
							if theOuts[MagmaFlowSettings.nodeInsertSocket] != undefined and theOuts[MagmaFlowSettings.nodeInsertSocket].count > 0 do done = true
							if MagmaFlowSettings.nodeInsertSocket > theOuts.count do 
							(
								MagmaFlowSettings.nodeInsertSocket = 1
								MagmaFlowSettings.nodeInsertMode = false
								done = true
							)
						)
					)
				)
			)
			else
				if MagmaFlowSettings.nodeInsertMode == false do 
				(
					MagmaFlowSettings.nodeInsertMode == true
					MagmaFlowSettings.nodeInsertSocket = 1 
				)
				updateWireColorsOnly()
			--if update do createNodeTree init:true
			updateEditorTitle()
		)
		
		fn closeEditorDialog =
		(
			destroyDialog MagmaFlowEditor_Rollout
		)
		
		fn copySelectionToClipboard =
		(
			::magmaClipBoardId = trackId
			local theSelection = getSelectedNodes()
			local theFlowScript = MagmaFlowEditor_Functions.emitMAXScriptCode magma specificNodes:theSelection isClipboard:true editorID:trackID	
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			clipboardClass.SetText theFlowScript
		)
		
		fn pasteSelectionFromClipboard preserveWires:false =
		(
			if keyboard.altPressed do preserveWires = true
			local clipboardClass = dotNetClass "System.Windows.Forms.Clipboard" 
			local theFlowScript = clipboardClass.GetText()
			if matchPattern theFlowScript pattern:"(--MAGMAFLOW2--*" do
			(
				setSelectedNodes #()
				local oldCount = magma.getNumNodes()
				::magmaNode = magma
				::magmaClipBoardId = trackId
				::magmaClipBoardPreserveWires = preserveWires
				execute theFlowScript
				EditableBlopStack = deepCopy ::MagmaFlowEditor_EditBLOPHistory
				local averageCenter = [0,0]
				local newCount = magma.getNumNodes()
				for i = oldCount+1 to newCount do
				(
					local theID = magma.getNodeID i
					local thePos = magma.getNodeProperty theID "Position"
					averageCenter += thePos
				)
				if (newCount-oldCount) != 0 do averageCenter /= (newCount-oldCount)
				local theMouse = ((getMouseInSchematicView() - [MagmaFlowSettings.NodeWidth/2, 10]  - hc.pan ) / hc.zoom)
				local posOffset = theMouse  - averageCenter
				for i = oldCount+1 to newCount do
				(
					local theID = magma.getNodeID i
					local thePos = magma.setNodeProperty theID "Position" ((magma.getNodeProperty theID "Position") + posOffset)
				)				
				createNodeTree init:true
				updateEditorTitle()
				displaySelectedNodeProperties()
				updateNavigator fullUpdate:true
				local theSelection = getSelectedNodes()
				createUndoRecord ("Paste "+theSelection.count as string + (if theSelection.count == 1 then " Node" else " Nodes") + " From Clipboard")
			)			
		)

		
		
-------------------------------------------------		
--KEYBOARD SHORTCUTS HANDLING
-------------------------------------------------		
		
		fn showRCMenu which =
		(
			local theIndex = findItem rcmenuNames which
			if theIndex > 0 do
			(
				NodeCreationMenuPosition = mouse.screenpos
				popupmenu rcmenus[theIndex] pos:NodeCreationMenuPosition
			)
		)
		
		local keyboardDefinition = #(
			--Code, Control, Shift, type, node, parameters...
			#(8, false, false, #function, removeNode ), --Backspace
			#(8, false, true, #function, removeNodeFromFlow ), 
			
			#(32, false, false, #function, connectSelectedNodes), --Spacebar
			
			/*
			#(33, false, false, #function, selectPreviousNodeByCreationOrder),
			#(34, false, false, #function, selectNextNodeByCreationOrder),
			#(33, false, true, #function, selectParentNodesByChild),
			#(34, false, true, #function, selectChildrenNodesByParent),
			*/
			
			#(45, false, false, #function, toggleInsertMode ),
			#(45, false, true, #function, toggleInsertMode ),
			
			#(48, false, false, #inputValue, "InputValue", #integer, 0), -- zero
			#(48, true, false, #inputValue, "InputValue", #float, 0.0),
			#(48, false, true, #inputValue, "InputValue", #vector, [0,0,0]),
			#(49, false, false, #inputValue, "InputValue", #integer, 1), -- 1
			#(49, true, false, #inputValue, "InputValue", #float, 1.0),
			#(49, false, true, #inputValue, "InputValue", #vector, [1,0,0]),
			#(50, false, false, #inputValue, "InputValue", #integer, 2), -- 2
			#(50, true, false, #inputValue, "InputValue", #float, 2.0),
			#(50, false, true, #inputValue, "InputValue", #vector, [0,1,0]),
			#(51, false, false, #inputValue, "InputValue", #integer, 3), -- 3
			#(51, true, false, #inputValue, "InputValue", #float, 3.0),
			#(51, false, true, #inputValue, "InputValue", #vector, [0,0,1]),
			#(52, false, false, #inputValue, "InputValue", #integer, 4), -- 4
			#(52, true, false, #inputValue, "InputValue", #float, 4.0),
			#(52, false, true, #inputValue, "InputValue", #vector, [0,1,1]),
			#(53, false, false, #operator, "Modulo" ), -- 5
			#(53, true, false, #inputValue, "InputValue", #float, 5.0),
			#(53, false, true, #inputValue, "InputValue", #vector, [1,0,1]),
			#(54, false, false, #operator, "Power" ), -- 6
			#(54, true, false, #inputValue, "InputValue", #float, 6.0),
			#(54, false, true, #inputValue, "InputValue", #vector, [1,1,0]),
			#(55, true, false, #inputValue, "InputValue", #float, 7.0), --7
			#(55, false, true, #inputValue, "InputValue", #vector, [1,1,1]),
			#(56, true, false, #inputValue, "InputValue", #float, 8.0), --8
			#(57, true, false, #inputValue, "InputValue", #float, 9.0), --9
			
			#(65, false, false, #menu, #Arithmetic), --A
			#(65, true, false, #function, selectAllNodes), 
			#(65, false, true, #InputChannel, "InputChannel", "Age"), 
			#(65, true, true, #function, alignAllNodesToGrid), 

			#(66, false, false, #menu, #BLOP),
			#(66, true, false, #operator, "Blend" ), --B
			#(66, false, true, #InputChannel, "InputChannel", "Absorption"),
			
			#(67, false, true, #InputChannel, "InputChannel", "Color"), --C
			#(67, true, false, #function, copySelectionToClipboard),
			#(67, false, false, #menu, #Convert),
			
			#(68, true, false, #function, deselectAllNodes), --D
			#(68, false,true, #InputChannel, "InputChannel", "Density"),
			
			#(69, false,true, #InputChannel, "InputChannel", "Emission"), --E
			
			#(70, false, false, #menu, #Function), --F
			#(70, true, true, #operator, "ToFloat" ), 
			#(70, true, false, #operator, "Floor" ), 
			
			#(71, true, false, #function, toggleSnapToGrid),

			#(73, false, true, #InputChannel, "InputChannel", "ID"), --I
			#(73, true, false, #function, invertSelection),
			#(73, true, true, #operator, "ToInt" ), 
			#(73, false, false, #menu, #Input),
			
			
			#(76, false, false, #menu, #Logic), --L
			#(76, false, true, #InputChannel, "InputChannel", "LifeSpan"),

			#(77, true, false, #operator, "Magnitude" ), --M
			#(77, false, true, #InputChannel, "InputChannel", "TextureCoord"), --M
			
			#(78, false, true, #InputChannel, "InputChannel", "Normal"), --N
			#(78, false, false, #operator, "Normalize" ),
			#(78, true, false, #operator, "Noise" ),
			#(78, true, true, #operator, "VecNoise" ),
			
			#(79, false, true, #InputChannel, "InputChannel", "Orientation"), --O
			#(79, true, false, #function, addNewOutputChannel),
			#(79, false, false, #menu, #Object),
			
			
			#(80, false, true, #InputChannel, "InputChannel", "Position"), --P
			#(80, true, false, #function, setPassThrough ),

			#(81, false, false, #operator, "FromQuat" ), --Q
			#(81, false, true, #operator, "ToQuat" ),
			#(81, true, false, #function, closeEditorDialog ),

			#(82, true, false, #function, ReorderToggle ),--R
			#(82, true, true, #function, AcceptReorderedFlow ),
			#(82, false, false, #menu, #Trigonometry),
			
			
			#(83, false, false, #menu, #System), --S
			#(83, false, true, #InputChannel, "InputChannel", "Selection"),
			--#(81, true, false, #function, saveFlowAs ),
			
			#(84, false, false, #menu, #Transform), --T
			#(84, false, true, #InputChannel, "InputChannel", "Tangent"),
			
			#(85, true, false, #function, selectUnconnectedNodes ),--U
			
			#(86, false, false, #menu, #Vector), --V
			#(86, true, true, #operator, "ToVector" ),
			#(86, true, false, #function, pasteSelectionFromClipboard ),
			#(86, false, true, #InputChannel, "InputChannel", "Velocity"),

			#(87, true, false, #function, swapInputsOrder ), --W
			#(87, true, true, #function, swapInputsOrder ), 

			#(88, false, false, #function, resetZoomFactor ), --X
			#(88, false, true, #function, resetPanFactor ), 

			#(89, true, false, #function, redoLastStep ), --Y

			#(90, true, false, #function, undoLastStep ),  --Z
			#(90, false, true, #function, ZoomExtentsSelected ),  
			#(90, false, false, #function, ZoomExtents ),  

			#(106, false, false, #operator, "Multiply" ),
			#(107, false, false, #operator, "Add" ),
			#(109, false, false, #operator, "Subtract" ),
			#(111, false, false, #operator, "Divide" ),
			
			#(187, false, false, #operator, "Equal" ), --=
			
			#(188, false, false, #operator, "VectorCross" ), --<,
			#(188, false, true, #operator, "Less" ),
			
			#(189, false, false, #operator, "Negate" ), -- -
			
			#(190, false, false, #operator, "VectorDot" ), -->,
			#(190, false, true, #operator, "Greater" ), -->.

			#(191, false, false, #operator, "Switch" ), --/
			#(191, false, true, #operator, "Mux" ), --?

			#(192, false, true, #operator, "Curve" ), --~
			#(192, false, false, #menu, #allNodes ), --~

			#(219, false, false, #operator, "Sin" ), --[
			#(219, false, true, #operator, "ASin" ), --Shift+[
			#(220, false, false, #operator, "Tan" ), --\
			#(220, false, true, #operator, "ATan" ), --Shift+\
			#(220, true, true, #operator, "ATan2" ), --Ctrl+Shift+\
			#(221, false, false, #operator, "Cos" ), --]
			#(221, false, true, #operator, "ACos" ) --Shift+]
		)			
			
		
		on hc keyboardDown keyCode do
		(
			--print keycode
			for k in keyboardDefinition where keycode == k[1] and keyboard.ControlPressed == k[2] and keyboard.ShiftPressed == k[3] do
			(
				case k[4] of
				(
					#inputValue: createNode k[5] ValueType:k[6] defaultValue:k[7]
					#inputChannel: createNode k[5] ChannelName:k[6]
					#operator: createNode k[5]
					#output: createNode k[5]
					#menu: 
					(
						showRCMenu k[5]
					)
					#function: 	(k[5])()
				)
			)
		)		
			
			
		fn updateValues =
		(
			createNodeTree init:false
			try
			(
				if MagmaFlowEditor_InputValueRollout.open do --and MagmaFlowEditor_InputRollout.ddl_InputType.selection == 2 do 
					with animate off MagmaFlowEditor_InputValueRollout.updateControls()
			)catch()	
		)	
		
---------------------------------------------		
--ROLLOUT EVENT HANDLERS
---------------------------------------------		
		on chk_autoUpdateModifier changed state do 
		(
			magma.autoUpdate = state
			updateMagmaHolder()
			if state do updateModifierName()
		)
		on btn_updateModifier pressed do 
		(
			magma.autoUpdate = magma.autoUpdate
			local theNodes = for i in refs.dependentNodes magma where classof i.baseobject == KrakatoaPRTLoader do try(i.delegate.InvalidateObjectSpaceCache())catch()
			updateErrorLog()
			createNodeTree init:true
			updateModifierName()	
		)

		
		on MagmaFlowEditor_Rollout resized val do 
		(
			hc.width = val.x-182
			hc.height = val.y-18
			
			prg_bar.pos = [val.x-178,val.y-31]
			
			edt_log.width = val.x-176-80
			edt_log.pos = [-2,val.y-19]
			
			btn_Undo.pos = [val.x-78-180,val.y-18]
			btn_Redo.pos = [val.x-39-180,val.y-18]			
			
			btn_RecorderToStart.pos = [val.x-178,val.y-56]
			btn_RecorderBackOneStep.pos = [val.x-178+25,val.y-56]
			chk_RecorderPlay.pos = [val.x-178+25*2,val.y-56]
			btn_RecorderForwardOneStep.pos = [val.x-178+25*3,val.y-56]
			btn_RecorderToEnd.pos = [val.x-178+25*4,val.y-56]
			btn_RecorderClose.pos = [val.x-178+25*5,val.y-56]
			
			NodePropsSR.pos = [val.x-180,21]
			NodePropsSR.height = val.y-20-100 --if KrakatoaChannelEditor_MacroRecording.count > 0 then val.y-80 else val.y-49
			bmp_navigator.pos = [val.x-180,val.y-100]
			
			chk_autoUpdateModifier.pos=[val.x-180,1] 
			btn_updateModifier.pos = [val.x-118,1] 			
			
			/*
			btn_zoomExtents.pos = [val.x-178,val.y-25]
			btn_zoomExtentsSelected.pos = [val.x-153,val.y-25]
			btn_NoZoom.pos = [val.x-128,val.y-25]
			btn_NoPoom.pos = [val.x-103,val.y-25]
			

			*/
			
			drawDepot init:false	lock:true
			if val.x > 100 and val.y > 100 do 
				setIniSetting (theIniFileLocation +"MagmaFlowEditor_Preferences.ini") "Editor" "Size" (val as string)
			--updateMacroRecorderControls()
			MagmaFlowEditor_Rollout.autoReorderFlow createUndo:false
			--if AutoZoomExtents do MagmaFlowEditor_Rollout.zoomExtents createUndo:false		
			if val.y > 50 do 
				MagmaFlowEditor_Functions.setEditorProperty magma "DialogSize" val
			
			updateNavigator fullUpdate:false
		)		
		
		on MagmaFlowEditor_Rollout moved val do 
		(
			if val.y < sysinfo.desktopsize.y-50 do 
			(
				setIniSetting (theIniFileLocation +"MagmaFlowEditor_Preferences.ini") "Editor" "Position" (val as string)		
				MagmaFlowEditor_Functions.setEditorProperty magma "DialogPosition" val
			)
		)			
		
		on MagmaFlowEditor_Rollout open do
		(
			loadSettings()
			local MaxBGColor = ((colorman.getColor #background)*255) 
			if abs ((MaxBGColor as color).value - (MagmaFlowColors.EditorBackgroundColor as color).value ) > 50 do 
			(
				MagmaFlowColors.EditorBackgroundColor = MaxBGColor
				MagmaFlowColors.GridColor = MagmaFlowColors.EditorBackgroundColor + [10,10,10]
			)
			
			for i in MagmaFlowEditor_CurrentEditors where i[2] == MagmaFlowEditor_Rollout do currentMagmaNode = magma = i[1]
				
			theUserFolder = (dotnetclass "System.Environment").GetFolderPath (dotnetclass "System.Environment+SpecialFolder").LocalApplicationData + "\\Thinkbox\\Genome"
			if not MagmaFlowEditor_Functions.IsGenome magma do theUserFolder = ::Krakatoa_PresetsDirectory
				
			theIniFileLocation = GetDir #plugcfg
			theIniFileLocation += (if MagmaFlowEditor_Functions.IsGenome magma then "\\Genome\\" else "\\Krakatoa\\")
			makeDir theIniFileLocation all:true
			loadDefaultSettings()
				
			local theSettings = MagmaFlowEditor_Functions.restoreSettingsFromMagmaHolder magma
			if theSettings != undefined do
			(
				local theVal = execute theSettings 
				for p in theVal do 
					try(setProperty MagmaFlowSettings p[1] p[2])catch()
			)
			
			createUndoRecord ("Editor Window Opened.")
			initSchematicView()
			restorePanAndZoom()
			createDepot()
			collapseBranches()
			createNodeTree init:true
			showGrid MagmaFlowSettings.SnapToGrid
			initNavigator()
			updateNavigator()
			displaySelectedNodeProperties()
			chk_autoUpdateModifier.state = magma.autoUpdate
			
			updateInsertMode update:false
			autoReorderFlow update:false
			updateEditorTitle()
			setUndoRedoEnable()
			--alignAllNodesToGrid()
			MagmaFlowEditor_Rollout.resized (getDialogSize MagmaFlowEditor_Rollout)
			registerTimeCallback updateValues		
		)
		
		on MagmaFlowEditor_Rollout close do
		(
			updateModifierName()	
			try(destroyDialog MagmaFlowEditor_DebugRollout)catch()
			MagmaFlowSettings.DebugModeOn = false
			MagmaFlowEditor_Functions.storeSettingsInMagmaHolder magma MagmaFlowSettings --store all settings in AppData
			for i = 1 to magma.NumEditingBLOPs() do magma.PopEditableBLOP() --get out to top level
			saveSettings()
			closeAllCurveEditors()
			updateMagmaHolder()		
			for f in (getFiles (GetDir #plugcfg + "\\Krakatoa\\MagmaFlowUndoRecords\\UndoRecord_"+MagmaFlowEditor_UniqueUndoID+".*"))	do deleteFile f --clear undo folder
			for i = MagmaFlowEditor_CurrentEditors.count to 1 by -1 where MagmaFlowEditor_CurrentEditors[i] != undefined and MagmaFlowEditor_CurrentEditors[i][2] == MagmaFlowEditor_Rollout do deleteItem MagmaFlowEditor_CurrentEditors i
			unregisterTimeCallback updateValues
			DisableDragAndDrop = true
		)		
	)--end rollout
	
	#(MagmaFlowEditor_Rollout,MagmaFlowEditor_Rollout_MainMenu, MagmaFlowEditor_InputValueRollout, MagmaFlowEditor_UniqueUndoID)
)--end script